/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.struct.EnumSet;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.mod.NoPatch;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.LiquidStack;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.liquid.Conduit;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import mindustryX.features.RenderExt;
import mindustryX.features.ui.FormatDefault;

public class GenericCrafter
extends Block {
    @Nullable
    public ItemStack outputItem;
    @Nullable
    public ItemStack[] outputItems;
    @Nullable
    public LiquidStack outputLiquid;
    @Nullable
    public LiquidStack[] outputLiquids;
    public int[] liquidOutputDirections = new int[]{-1};
    public boolean dumpExtraLiquid = true;
    public boolean ignoreLiquidFullness = false;
    public float craftTime = 80.0f;
    public Effect craftEffect = Fx.none;
    public Effect updateEffect = Fx.none;
    public float updateEffectChance = 0.04f;
    public float updateEffectSpread = 4.0f;
    public float warmupSpeed = 0.019f;
    @NoPatch
    public boolean legacyReadWarmup = false;
    public DrawBlock drawer = new DrawDefault();

    public GenericCrafter(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.hasItems = true;
        this.ambientSound = Sounds.loopMachine;
        this.sync = true;
        this.ambientSoundVolume = 0.03f;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.factory});
        this.drawArrow = false;
    }

    @Override
    public void setStats() {
        this.stats.timePeriod = this.craftTime;
        super.setStats();
        if (this.hasItems && this.itemCapacity > 0 || this.outputItems != null) {
            this.stats.add(Stat.productionTime, this.craftTime / 60.0f, StatUnit.seconds);
        }
        if (this.outputItems != null) {
            this.stats.add(Stat.output, StatValues.items(this.craftTime, this.outputItems));
        }
        if (this.outputLiquids != null) {
            this.stats.add(Stat.output, StatValues.liquids(1.0f, this.outputLiquids));
        }
    }

    @Override
    public void setBars() {
        super.setBars();
        if (this.outputLiquids != null && this.outputLiquids.length > 0) {
            this.removeBar("liquid");
            for (LiquidStack stack : this.outputLiquids) {
                this.addLiquidBar(stack.liquid);
            }
        }
    }

    @Override
    public boolean rotatedOutput(int fromX, int fromY, Tile destination) {
        if (!(destination.build instanceof Conduit.ConduitBuild)) {
            return false;
        }
        Building crafter = Vars.world.build(fromX, fromY);
        if (crafter == null) {
            return false;
        }
        int relative = Mathf.mod((int)(crafter.relativeTo(destination) - crafter.rotation), (int)4);
        for (int dir : this.liquidOutputDirections) {
            if (dir != -1 && dir != relative) continue;
            return false;
        }
        return true;
    }

    @Override
    public void load() {
        super.load();
        this.drawer.load((Block)this);
    }

    @Override
    public void init() {
        if (this.outputItems == null && this.outputItem != null) {
            this.outputItems = new ItemStack[]{this.outputItem};
        }
        if (this.outputLiquids == null && this.outputLiquid != null) {
            this.outputLiquids = new LiquidStack[]{this.outputLiquid};
        }
        if (this.outputLiquid == null && this.outputLiquids != null && this.outputLiquids.length > 0) {
            this.outputLiquid = this.outputLiquids[0];
        }
        boolean bl = this.outputsLiquid = this.outputLiquids != null;
        if (this.outputItems != null) {
            this.hasItems = true;
        }
        if (this.outputLiquids != null) {
            this.hasLiquids = true;
        }
        super.init();
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawer.drawPlan((Block)this, plan, list);
    }

    @Override
    public TextureRegion[] icons() {
        return this.drawer.finalIcons((Block)this);
    }

    @Override
    public boolean outputsItems() {
        return this.outputItems != null;
    }

    @Override
    public void getRegionsToOutline(Seq<TextureRegion> out) {
        this.drawer.getRegionsToOutline((Block)this, out);
    }

    @Override
    public void drawOverlay(float x, float y, int rotation) {
        if (this.outputLiquids != null) {
            for (int i = 0; i < this.outputLiquids.length; ++i) {
                int dir;
                int n = dir = this.liquidOutputDirections.length > i ? this.liquidOutputDirections[i] : -1;
                if (dir == -1) continue;
                Draw.rect((TextureRegion)this.outputLiquids[i].liquid.fullIcon, (float)(x + (float)Geometry.d4x((int)(dir + rotation)) * ((float)(this.size * 8) / 2.0f + 4.0f)), (float)(y + (float)Geometry.d4y((int)(dir + rotation)) * ((float)(this.size * 8) / 2.0f + 4.0f)), (float)8.0f, (float)8.0f);
            }
        }
    }

    public class GenericCrafterBuild
    extends Building {
        public float progress;
        public float totalProgress;
        public float warmup;

        @Override
        public void draw() {
            GenericCrafter.this.drawer.draw((Building)this);
        }

        @Override
        public void drawLight() {
            super.drawLight();
            GenericCrafter.this.drawer.drawLight((Building)this);
        }

        @Override
        public boolean shouldConsume() {
            if (GenericCrafter.this.outputItems != null) {
                for (ItemStack output : GenericCrafter.this.outputItems) {
                    if (this.items.get(output.item) + output.amount <= GenericCrafter.this.itemCapacity) continue;
                    return false;
                }
            }
            if (GenericCrafter.this.outputLiquids != null && !GenericCrafter.this.ignoreLiquidFullness) {
                boolean allFull = true;
                for (LiquidStack output : GenericCrafter.this.outputLiquids) {
                    if (this.liquids.get(output.liquid) >= GenericCrafter.this.liquidCapacity - 0.001f) {
                        if (GenericCrafter.this.dumpExtraLiquid) continue;
                        return false;
                    }
                    allFull = false;
                }
                if (allFull) {
                    return false;
                }
            }
            return this.enabled;
        }

        @Override
        public void updateTile() {
            if (this.efficiency > 0.0f) {
                this.progress += this.getProgressIncrease(GenericCrafter.this.craftTime);
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)this.warmupTarget(), (float)GenericCrafter.this.warmupSpeed);
                if (GenericCrafter.this.outputLiquids != null) {
                    float inc = this.getProgressIncrease(1.0f);
                    for (LiquidStack output : GenericCrafter.this.outputLiquids) {
                        this.handleLiquid(this, output.liquid, Math.min(output.amount * inc, GenericCrafter.this.liquidCapacity - this.liquids.get(output.liquid)));
                    }
                }
                if (RenderExt.blockRenderLevel > 1 && this.wasVisible && Mathf.chanceDelta((double)GenericCrafter.this.updateEffectChance)) {
                    GenericCrafter.this.updateEffect.at(this.x + Mathf.range((float)((float)GenericCrafter.this.size * GenericCrafter.this.updateEffectSpread)), this.y + Mathf.range((float)((float)GenericCrafter.this.size * GenericCrafter.this.updateEffectSpread)));
                }
            } else {
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)0.0f, (float)GenericCrafter.this.warmupSpeed);
            }
            this.totalProgress += this.warmup * Time.delta;
            if (this.progress >= 1.0f) {
                this.craft();
            }
            this.dumpOutputs();
        }

        @Override
        public float getProgressIncrease(float baseTime) {
            if (GenericCrafter.this.ignoreLiquidFullness) {
                return super.getProgressIncrease(baseTime);
            }
            float scaling = 1.0f;
            float max = 1.0f;
            if (GenericCrafter.this.outputLiquids != null) {
                max = 0.0f;
                for (LiquidStack s : GenericCrafter.this.outputLiquids) {
                    float value = (GenericCrafter.this.liquidCapacity - this.liquids.get(s.liquid)) / (s.amount * this.edelta());
                    scaling = Math.min(scaling, value);
                    max = Math.max(max, value);
                }
            }
            return super.getProgressIncrease(baseTime) * (GenericCrafter.this.dumpExtraLiquid ? Math.min(max, 1.0f) : scaling);
        }

        public float warmupTarget() {
            return 1.0f;
        }

        @Override
        public float warmup() {
            return this.warmup;
        }

        @Override
        public float totalProgress() {
            return this.totalProgress;
        }

        public void craft() {
            this.consume();
            if (GenericCrafter.this.outputItems != null) {
                for (ItemStack output : GenericCrafter.this.outputItems) {
                    for (int i = 0; i < output.amount; ++i) {
                        this.offload(output.item);
                    }
                }
            }
            if (this.wasVisible) {
                GenericCrafter.this.craftEffect.at(this.x, this.y);
            }
            if (RenderExt.blockRenderLevel > 1) {
                GenericCrafter.this.craftEffect.at(this.x, this.y);
            }
            this.progress %= 1.0f;
        }

        public void dumpOutputs() {
            if (GenericCrafter.this.outputItems != null && this.timer(GenericCrafter.this.timerDump, (float)GenericCrafter.this.dumpTime / this.timeScale)) {
                for (ItemStack output : GenericCrafter.this.outputItems) {
                    this.dump(output.item);
                }
            }
            if (GenericCrafter.this.outputLiquids != null) {
                for (int i = 0; i < GenericCrafter.this.outputLiquids.length; ++i) {
                    int dir = GenericCrafter.this.liquidOutputDirections.length > i ? GenericCrafter.this.liquidOutputDirections[i] : -1;
                    this.dumpLiquid(GenericCrafter.this.outputLiquids[i].liquid, 2.0f, dir);
                }
            }
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return this.progress();
            }
            if (sensor == LAccess.totalLiquids && GenericCrafter.this.outputLiquid != null) {
                return this.liquids.get(GenericCrafter.this.outputLiquid.liquid);
            }
            return super.sense(sensor);
        }

        @Override
        public float progress() {
            return Mathf.clamp((float)this.progress);
        }

        @Override
        public int getMaximumAccepted(Item item) {
            return GenericCrafter.this.itemCapacity;
        }

        @Override
        public boolean shouldAmbientSound() {
            return this.efficiency > 0.0f;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
            write.f(this.warmup);
            if (GenericCrafter.this.legacyReadWarmup) {
                write.f(0.0f);
            }
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.progress = read.f();
            this.warmup = read.f();
            if (GenericCrafter.this.legacyReadWarmup) {
                read.f();
            }
        }

        @Override
        public void displayBars(Table bars) {
            super.displayBars(bars);
            bars.add((Element)new Bar(() -> "\ue830 " + Strings.fixed((float)(this.progress * 100.0f), (int)0) + " %" + (this.getProgressIncrease(GenericCrafter.this.craftTime) == 0.0f ? "" : FormatDefault.duration((1.0f - this.progress) / (this.getProgressIncrease(GenericCrafter.this.craftTime) / Time.delta * 60.0f))), () -> Pal.ammo, () -> this.progress));
            bars.row();
        }
    }
}

