/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.audio.Sound;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.EnumSet;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Puddles;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.power.PowerDistributor;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class PowerGenerator
extends PowerDistributor {
    public float powerProduction;
    public Stat generationType = Stat.basePowerGeneration;
    public DrawBlock drawer = new DrawDefault();
    public int explosionRadius = 12;
    public int explosionDamage = 0;
    public Effect explodeEffect = Fx.none;
    public Sound explodeSound = Sounds.none;
    public int explosionPuddles = 10;
    public float explosionPuddleRange = 16.0f;
    public float explosionPuddleAmount = 100.0f;
    @Nullable
    public Liquid explosionPuddleLiquid;
    public float explosionMinWarmup = 0.0f;
    public float explosionShake = 0.0f;
    public float explosionShakeDuration = 6.0f;

    public PowerGenerator(String name) {
        super(name);
        this.sync = true;
        this.baseExplosiveness = 5.0f;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.generator});
    }

    public float getDisplayedPowerProduction() {
        return this.powerProduction;
    }

    public TextureRegion[] icons() {
        return this.drawer.finalIcons((Block)((Object)this));
    }

    public void load() {
        super.load();
        this.drawer.load((Block)((Object)this));
    }

    public void setStats() {
        super.setStats();
        this.stats.add(this.generationType, this.powerProduction * 60.0f, StatUnit.powerSecond);
    }

    public void setBars() {
        super.setBars();
        if (this.hasPower && this.outputsPower) {
            this.addBar("power", entity -> new Bar(() -> "\ue810+ " + Strings.autoFixed((float)(entity.getPowerProduction() * 60.0f * entity.timeScale()), (int)1), () -> Pal.powerBar, () -> entity.productionEfficiency));
        }
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawer.drawPlan((Block)((Object)this), plan, list);
    }

    public boolean outputsItems() {
        return false;
    }

    public class GeneratorBuild
    extends Building {
        public float generateTime;
        public float productionEfficiency = 0.0f;

        @Override
        public void draw() {
            PowerGenerator.this.drawer.draw((Building)this);
        }

        @Override
        public float warmup() {
            return this.enabled ? this.productionEfficiency : 0.0f;
        }

        @Override
        public void onDestroyed() {
            super.onDestroyed();
            if (Vars.state.rules.reactorExplosions) {
                this.createExplosion();
            }
        }

        public boolean shouldExplode() {
            return this.warmup() >= PowerGenerator.this.explosionMinWarmup;
        }

        public void createExplosion() {
            if (this.shouldExplode()) {
                if (PowerGenerator.this.explosionDamage > 0) {
                    Damage.damage(this.x, this.y, PowerGenerator.this.explosionRadius * 8, PowerGenerator.this.explosionDamage);
                }
                PowerGenerator.this.explodeEffect.at((Position)this);
                PowerGenerator.this.explodeSound.at((Position)this);
                if (PowerGenerator.this.explosionPuddleLiquid != null) {
                    for (int i = 0; i < PowerGenerator.this.explosionPuddles; ++i) {
                        Tmp.v1.trns(Mathf.random((float)360.0f), Mathf.random((float)PowerGenerator.this.explosionPuddleRange));
                        Tile tile = Vars.world.tileWorld(this.x + Tmp.v1.x, this.y + Tmp.v1.y);
                        Puddles.deposit((Tile)tile, (Liquid)PowerGenerator.this.explosionPuddleLiquid, (float)PowerGenerator.this.explosionPuddleAmount);
                    }
                }
                if (PowerGenerator.this.explosionShake > 0.0f) {
                    Effect.shake((float)PowerGenerator.this.explosionShake, (float)PowerGenerator.this.explosionShakeDuration, (Position)this);
                }
            }
        }

        @Override
        public void drawLight() {
            super.drawLight();
            PowerGenerator.this.drawer.drawLight((Building)this);
        }

        @Override
        public float ambientVolume() {
            return Mathf.clamp((float)this.productionEfficiency);
        }

        @Override
        public float getPowerProduction() {
            return this.enabled ? PowerGenerator.this.powerProduction * this.productionEfficiency : 0.0f;
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.productionEfficiency);
            write.f(this.generateTime);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.productionEfficiency = read.f();
            if (revision >= 1) {
                this.generateTime = read.f();
            }
        }
    }
}

