/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.logic;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.math.Mat;
import arc.struct.LongQueue;
import arc.struct.LongSeq;
import arc.util.Nullable;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Building;
import mindustry.gen.DisplayCmd;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustryX.features.RenderExt;

public class LogicDisplay
extends Block {
    public static final byte commandClear = 0;
    public static final byte commandColor = 1;
    public static final byte commandColorPack = 2;
    public static final byte commandStroke = 3;
    public static final byte commandLine = 4;
    public static final byte commandRect = 5;
    public static final byte commandLineRect = 6;
    public static final byte commandPoly = 7;
    public static final byte commandLinePoly = 8;
    public static final byte commandTriangle = 9;
    public static final byte commandImage = 10;
    public static final byte commandPrint = 11;
    public static final byte commandTranslate = 12;
    public static final byte commandScale = 13;
    public static final byte commandRotate = 14;
    public static final byte commandResetTransform = 15;
    public static final float scaleStep = 0.05f;
    public int maxSides = 25;
    public int displaySize = 64;
    public float scaleFactor = 1.0f;

    public LogicDisplay(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.canOverdrive = false;
        this.group = BlockGroup.logic;
        this.drawDisabled = false;
        this.envEnabled = -1;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.displaySize, "@x@", new Object[]{this.displaySize, this.displaySize});
    }

    @Override
    public void init() {
        super.init();
        this.clipSize = Math.max(this.clipSize, this.scaleFactor * Draw.scl * (float)this.displaySize);
    }

    static int unpackSign(int value) {
        return (value & 0x1FF) * ((value & 0x200) != 0 ? -1 : 1);
    }

    static class DisplayCmdStruct {
        public int type;
        public int x;
        public int y;
        public int p1;
        public int p2;
        public int p3;
        public int p4;

        DisplayCmdStruct() {
        }
    }

    public static enum GraphicsType {
        clear,
        color,
        col,
        stroke,
        line,
        rect,
        lineRect,
        poly,
        linePoly,
        triangle,
        image,
        print,
        translate,
        scale,
        rotate,
        reset;

        public static final GraphicsType[] all;

        static {
            all = GraphicsType.values();
        }
    }

    public class LogicDisplayBuild
    extends Building {
        public LogicDisplayBuild rootDisplay = this;
        @Nullable
        public FrameBuffer buffer;
        public float color = Color.whiteFloatBits;
        public float stroke = 1.0f;
        public LongQueue commands = new LongQueue(256);
        @Nullable
        public Mat transform;
        public long operations;

        @Override
        public void draw() {
            if (!RenderExt.logicDisplayNoBorder) {
                super.draw();
            }
            if (!Vars.renderer.drawDisplays) {
                return;
            }
            Draw.draw((float)29.998f, () -> {
                if (this.buffer == null) {
                    this.buffer = new FrameBuffer(LogicDisplay.this.displaySize, LogicDisplay.this.displaySize);
                    this.buffer.begin(Pal.darkerMetal);
                    this.buffer.end();
                }
            });
            this.processCommands();
            Draw.blend((Blending)Blending.disabled);
            Draw.draw((float)30.001f, () -> {
                if (this.buffer != null) {
                    if (RenderExt.logicDisplayNoBorder) {
                        Draw.rect((TextureRegion)Draw.wrap((Texture)((Texture)this.buffer.getTexture())), (float)this.x, (float)this.y, (float)((float)(this.buffer.getWidth() + 16) * Draw.scl), (float)((float)(-(this.buffer.getHeight() + 16)) * Draw.scl));
                        return;
                    }
                    Draw.rect((TextureRegion)Draw.wrap((Texture)((Texture)this.buffer.getTexture())), (float)this.x, (float)this.y, (float)((float)this.buffer.getWidth() * LogicDisplay.this.scaleFactor * Draw.scl), (float)((float)(-this.buffer.getHeight()) * LogicDisplay.this.scaleFactor * Draw.scl));
                }
            });
            Draw.blend();
            Draw.z((float)30.0f);
        }

        @Override
        public double sense(LAccess sensor) {
            double d;
            switch (sensor) {
                case displayWidth: 
                case displayHeight: {
                    d = LogicDisplay.this.displaySize;
                    break;
                }
                case bufferSize: {
                    d = this.rootDisplay.commands.size;
                    break;
                }
                case operations: {
                    d = this.rootDisplay.operations;
                    break;
                }
                default: {
                    d = super.sense(sensor);
                }
            }
            return d;
        }

        public void flushCommands(LongSeq graphicsBuffer) {
            int added = Math.min(graphicsBuffer.size, 1024 - this.commands.size);
            for (int i = 0; i < added; ++i) {
                this.commands.addLast(graphicsBuffer.items[i]);
            }
            ++this.operations;
        }

        public void processCommands() {
            if (!this.commands.isEmpty() && this.buffer != null) {
                Draw.draw((float)29.999f, () -> {
                    if (this.buffer == null) {
                        return;
                    }
                    Tmp.m1.set(Draw.proj());
                    Tmp.m2.set(Draw.trans());
                    Draw.proj((float)0.0f, (float)0.0f, (float)this.buffer.getWidth(), (float)this.buffer.getHeight());
                    if (this.transform != null) {
                        Draw.trans((Mat)this.transform);
                    }
                    this.buffer.begin();
                    Draw.color((float)this.color);
                    Lines.stroke(this.stroke);
                    block17: while (!this.commands.isEmpty()) {
                        long c = this.commands.removeFirst();
                        int type = DisplayCmd.type((long)c);
                        int x = LogicDisplay.unpackSign(DisplayCmd.x((long)c));
                        int y = LogicDisplay.unpackSign(DisplayCmd.y((long)c));
                        int p1 = LogicDisplay.unpackSign(DisplayCmd.p1((long)c));
                        int p2 = LogicDisplay.unpackSign(DisplayCmd.p2((long)c));
                        int p3 = LogicDisplay.unpackSign(DisplayCmd.p3((long)c));
                        int p4 = LogicDisplay.unpackSign(DisplayCmd.p4((long)c));
                        switch (type) {
                            case 0: {
                                Draw.discard();
                                Core.graphics.clear((float)x / 255.0f, (float)y / 255.0f, (float)p1 / 255.0f, 1.0f);
                                break;
                            }
                            case 4: {
                                Lines.line(x, y, p1, p2);
                                break;
                            }
                            case 5: {
                                Fill.crect((float)x, (float)y, (float)p1, (float)p2);
                                break;
                            }
                            case 6: {
                                Lines.rect(x, y, p1, p2);
                                break;
                            }
                            case 7: {
                                Fill.poly((float)x, (float)y, (int)Math.min(p1, LogicDisplay.this.maxSides), (float)p2, (float)p3);
                                break;
                            }
                            case 8: {
                                Lines.poly(x, y, Math.min(p1, LogicDisplay.this.maxSides), p2, p3);
                                break;
                            }
                            case 9: {
                                Fill.tri((float)x, (float)y, (float)p1, (float)p2, (float)p3, (float)p4);
                                break;
                            }
                            case 1: {
                                this.color = Color.toFloatBits((int)x, (int)y, (int)p1, (int)p2);
                                Draw.color((float)this.color);
                                break;
                            }
                            case 3: {
                                this.stroke = x;
                                Lines.stroke(this.stroke);
                                break;
                            }
                            case 10: {
                                Object patt6553$temp;
                                if (p4 < 0 || p4 >= ContentType.all.length || !((patt6553$temp = Vars.content.getByID(ContentType.all[p4], p1)) instanceof UnlockableContent)) continue block17;
                                UnlockableContent u = (UnlockableContent)((Object)((Object)patt6553$temp));
                                TextureRegion icon = u.fullIcon;
                                Draw.rect((TextureRegion)icon, (float)x, (float)y, (float)p2, (float)((float)p2 / icon.ratio()), (float)p3);
                                break;
                            }
                            case 11: {
                                Font.Glyph glyph = Fonts.logic.getData().getGlyph((char)p1);
                                if (glyph == null) continue block17;
                                Tmp.tr1.set(Fonts.logic.getRegion().texture);
                                Tmp.tr1.set(glyph.u, glyph.v2, glyph.u2, glyph.v);
                                Draw.rect((TextureRegion)Tmp.tr1, (float)((float)x + (float)Tmp.tr1.width / 2.0f + (float)glyph.xoffset), (float)((float)y + (float)Tmp.tr1.height / 2.0f + (float)glyph.yoffset + Fonts.logic.getData().capHeight + Fonts.logic.getData().ascent), (float)Tmp.tr1.width, (float)Tmp.tr1.height);
                                break;
                            }
                            case 12: {
                                Mat mat;
                                if (this.transform == null) {
                                    mat = new Mat();
                                    this.transform = this.transform;
                                } else {
                                    mat = this.transform;
                                }
                                Draw.trans((Mat)mat.translate((float)x, (float)y));
                                break;
                            }
                            case 13: {
                                Mat mat;
                                if (this.transform == null) {
                                    mat = new Mat();
                                    this.transform = this.transform;
                                } else {
                                    mat = this.transform;
                                }
                                Draw.trans((Mat)mat.scale((float)x * 0.05f, (float)y * 0.05f));
                                break;
                            }
                            case 14: {
                                Mat mat;
                                if (this.transform == null) {
                                    mat = new Mat();
                                    this.transform = this.transform;
                                } else {
                                    mat = this.transform;
                                }
                                Draw.trans((Mat)mat.rotate((float)p1));
                                break;
                            }
                            case 15: {
                                Mat mat;
                                if (this.transform == null) {
                                    mat = new Mat();
                                    this.transform = this.transform;
                                } else {
                                    mat = this.transform;
                                }
                                Draw.trans((Mat)mat.idt());
                            }
                        }
                    }
                    this.buffer.end();
                    Draw.proj((Mat)Tmp.m1);
                    Draw.trans((Mat)Tmp.m2);
                    Draw.reset();
                });
            }
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            if (this.transform != null) {
                write.bool(true);
                for (int i = 0; i < this.transform.val.length; ++i) {
                    write.f(this.transform.val[i]);
                }
            } else {
                write.bool(false);
            }
        }

        @Override
        public void read(Reads read, byte revision) {
            boolean hasTransform;
            super.read(read, revision);
            if (revision >= 1 && (hasTransform = read.bool())) {
                this.transform = new Mat();
                for (int i = 0; i < this.transform.val.length; ++i) {
                    this.transform.val[i] = read.f();
                }
            }
        }

        @Override
        public void remove() {
            super.remove();
            if (this.buffer != null) {
                this.buffer.dispose();
                this.buffer = null;
            }
        }
    }
}

