/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.heat;

import arc.Core;
import arc.graphics.g2d.TextureRegion;
import arc.util.Eachable;
import mindustry.entities.units.BuildPlan;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustryX.features.ui.FormatDefault;

public class HeatConductor
extends Block {
    public float visualMaxHeat = 15.0f;
    public DrawBlock drawer = new DrawDefault();
    public boolean splitHeat = false;

    public HeatConductor(String name) {
        super(name);
        this.rotate = true;
        this.solid = true;
        this.update = true;
        this.rotateDraw = false;
        this.size = 3;
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("heat", entity -> new Bar(() -> Core.bundle.get("bar.heat") + " " + FormatDefault.percent(entity.heat, this.visualMaxHeat), () -> Pal.lightOrange, () -> entity.heat / this.visualMaxHeat));
    }

    @Override
    public void load() {
        super.load();
        this.drawer.load((Block)this);
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawer.drawPlan((Block)this, plan, list);
    }

    @Override
    public TextureRegion[] icons() {
        return this.drawer.finalIcons((Block)this);
    }
}

