/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.Core;
import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.Bits;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.gen.Sounds;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.MultiPacker;
import mindustry.type.Liquid;
import mindustry.type.StatusEffect;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.TileBitmask;
import mindustry.world.blocks.environment.OreBlock;

public class Floor
extends Block {
    public String edge = "stone";
    public float speedMultiplier = 1.0f;
    public float dragMultiplier = 1.0f;
    public float damageTaken = 0.0f;
    public float drownTime = 0.0f;
    public Effect walkEffect = Fx.none;
    public Sound walkSound = Sounds.none;
    public float walkSoundVolume = 0.1f;
    public float walkSoundPitchMin = 0.8f;
    public float walkSoundPitchMax = 1.2f;
    public Effect drownUpdateEffect = Fx.bubble;
    public StatusEffect status = StatusEffects.none;
    public float statusDuration = 60.0f;
    @Nullable
    public Liquid liquidDrop = null;
    public float liquidMultiplier = 1.0f;
    public boolean isLiquid;
    public float overlayAlpha = 0.65f;
    public boolean supportsOverlay = false;
    public boolean shallow = false;
    public Block blendGroup = this;
    public boolean oreDefault = false;
    public float oreScale = 24.0f;
    public float oreThreshold = 0.828f;
    public Block wall = Blocks.air;
    public Block decoration = Blocks.air;
    public boolean canShadow = true;
    public boolean forceDrawLight = false;
    public boolean needsSurface = true;
    public boolean allowCorePlacement = false;
    public boolean wallOre = false;
    public int blendId = -1;
    public int tilingVariants = 0;
    public boolean autotile = false;
    public int autotileMidVariants = 1;
    public int autotileVariants = 1;
    public boolean drawEdgeIn = true;
    public boolean drawEdgeOut = true;
    protected TextureRegion[][][] tilingRegions;
    protected TextureRegion[] autotileRegions;
    protected TextureRegion[] autotileMidRegions;
    protected TextureRegion[][] autotileVariantRegions;
    protected int tilingSize;
    protected TextureRegion[][] edges;
    protected Seq<Floor> blenders = new Seq();
    protected Bits blended = new Bits(256);
    protected int[] dirs = new int[8];
    protected TextureRegion edgeRegion;

    public Floor(String name) {
        this(name, 3);
    }

    public Floor(String name, int variants) {
        super(name);
        this.variants = variants;
        this.placeableLiquid = true;
        this.allowRectanglePlacement = true;
        this.instantBuild = true;
        this.ignoreBuildDarkness = true;
        this.obstructsLight = false;
        this.placeEffect = Fx.rotateBlock;
        this.schematicPriority = 100;
    }

    @Override
    public void load() {
        int i;
        super.load();
        if (this.autotile) {
            this.variants = 0;
        }
        int tsize = (int)(8.0f / Draw.scl);
        if (this.tilingVariants > 0 && !Vars.headless) {
            this.tilingRegions = new TextureRegion[this.tilingVariants][][];
            for (i = 0; i < this.tilingVariants; ++i) {
                TextureAtlas.AtlasRegion tile = Core.atlas.find(this.name + "-tile" + (i + 1));
                this.tilingRegions[i] = tile.split(tsize, tsize);
                this.tilingSize = this.tilingRegions[i].length;
            }
            for (i = 0; i < this.tilingVariants; ++i) {
                if (this.tilingRegions[i].length == this.tilingSize && this.tilingRegions[i][0].length == this.tilingSize) continue;
                Log.warn((String)"Block: @: In order to prevent crashes, tiling regions must all be valid regions with the same size. Tiling has been disabled. Sprite '@' has a width or height inconsistent with other tiles.", (Object[])new Object[]{this.name, this.name + "-tile" + (i + 1)});
                this.tilingVariants = 0;
            }
        }
        if (this.variants > 0) {
            this.variantRegions = new TextureRegion[this.variants];
            for (i = 0; i < this.variants; ++i) {
                this.variantRegions[i] = Core.atlas.find(this.name + (i + 1));
            }
        } else {
            this.variantRegions = new TextureRegion[1];
            this.variantRegions[0] = Core.atlas.find(this.name);
        }
        if (this.autotile) {
            this.autotileRegions = TileBitmask.load((String)this.name);
            if (this.autotileVariants > 1) {
                this.autotileVariantRegions = TileBitmask.loadVariants((String)this.name, (int)this.autotileVariants);
            }
            if (this.autotileMidVariants > 1) {
                this.autotileMidRegions = new TextureRegion[this.autotileMidVariants];
                for (i = 0; i < this.autotileMidVariants; ++i) {
                    this.autotileMidRegions[i] = Core.atlas.find(i == 0 ? this.name + "-13" : this.name + "-mid-" + (i + 1));
                }
            }
        }
        if (Core.atlas.has(this.name + "-edge")) {
            this.edges = Core.atlas.find(this.name + "-edge").split(tsize, tsize);
        }
        this.region = this.variantRegions[0];
        this.edgeRegion = Core.atlas.find("edge");
    }

    @Override
    public void init() {
        super.init();
        this.blendId = this.blendGroup.id;
        if (this.wall == Blocks.air) {
            this.wall = Vars.content.block(this.name + "-wall");
            if (this.wall == null) {
                this.wall = Vars.content.block(this.name.replace("darksand", "dune") + "-wall");
            }
        }
        if (this.wall == null) {
            this.wall = Blocks.air;
        }
        if (this.decoration == null) {
            this.decoration = Vars.content.block(this.name + "-boulder");
        }
        if (this.isLiquid && this.walkEffect == Fx.none) {
            this.walkEffect = Fx.ripple;
        }
        if (this.isLiquid && this.walkSound == Sounds.none) {
            this.walkSound = Sounds.stepWater;
        }
    }

    @Override
    public TextureRegion getDisplayIcon(Tile tile) {
        return this.liquidDrop == null ? super.getDisplayIcon(tile) : this.liquidDrop.uiIcon;
    }

    @Override
    public String getDisplayName(Tile tile) {
        return this.liquidDrop == null ? super.getDisplayName(tile) : this.liquidDrop.localizedName;
    }

    @Override
    public void createIcons(MultiPacker packer) {
        super.createIcons(packer);
        if (this.blendGroup != this) {
            return;
        }
        if (Core.atlas.has(this.name + "-edge")) {
            return;
        }
        PixmapRegion image = Core.atlas.getPixmap(this.icons()[0]);
        PixmapRegion edge = Core.atlas.getPixmap(Core.atlas.find(this.name + "-edge-stencil", "edge-stencil"));
        Pixmap result = new Pixmap(edge.width, edge.height);
        for (int x = 0; x < edge.width; ++x) {
            for (int y = 0; y < edge.height; ++y) {
                result.set(x, y, Color.muli((int)edge.get(x, y), (int)image.get(x % image.width, y % image.height)));
            }
        }
        packer.add(MultiPacker.PageType.environment, this.name + "-edge", result);
        result.dispose();
    }

    @Override
    public void drawBase(Tile tile) {
        this.drawMain(tile);
        if (this.drawEdgeIn) {
            this.drawEdges(tile);
        }
        this.drawOverlay(tile);
        if (tile.overlay() != Blocks.air && tile.floor() == this && this.isLiquid) {
            Draw.alpha((float)(1.0f - this.overlayAlpha));
            this.drawMain(tile);
            Draw.color();
        }
    }

    public void drawMain(Tile tile) {
        if (this.tilingVariants > 0) {
            int index = Mathf.randomSeed((long)Point2.pack((int)(tile.x / this.tilingSize), (int)(tile.y / this.tilingSize)), (int)0, (int)(this.tilingVariants - 1));
            TextureRegion[][] regions = this.tilingRegions[index];
            Draw.rect((TextureRegion)regions[tile.x % this.tilingSize][this.tilingSize - 1 - tile.y % this.tilingSize], (float)tile.worldx(), (float)tile.worldy());
        } else if (this.autotile) {
            int bits = 0;
            TextureRegion[] regions = this.autotileVariants > 1 ? this.autotileVariantRegions[this.variant(tile.x, tile.y, this.autotileVariantRegions.length)] : this.autotileRegions;
            for (int i = 0; i < 8; ++i) {
                Tile other = tile.nearby(Geometry.d8[i]);
                if (!this.checkAutotileSame(tile, other)) continue;
                bits |= 1 << i;
            }
            int bit = TileBitmask.values[bits];
            TextureRegion region = bit == 13 && this.autotileMidVariants > 1 ? this.autotileMidRegions[this.variant(tile.x, tile.y, this.autotileMidRegions.length)] : regions[bit];
            Draw.rect((TextureRegion)region, (float)tile.worldx(), (float)tile.worldy());
        } else {
            Draw.rect((TextureRegion)this.variantRegions[this.variant(tile.x, tile.y)], (float)tile.worldx(), (float)tile.worldy());
        }
        Draw.alpha((float)1.0f);
    }

    public boolean checkAutotileSame(Tile tile, @Nullable Tile other) {
        return other != null && (this == tile.floor() ? other.floor() : other.overlay()).blendGroup == this.blendGroup;
    }

    public int variant(int x, int y) {
        return this.variant(x, y, this.variantRegions.length);
    }

    public int variant(int x, int y, int max) {
        return Mathf.randomSeed((long)Point2.pack((int)x, (int)y), (int)0, (int)Math.max(0, max - 1));
    }

    public void drawOverlay(Tile tile) {
        Floor floor = tile.overlay();
        if (floor != Blocks.air && floor != this) {
            floor.drawBase(tile);
        }
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{Core.atlas.find(Core.atlas.has(this.name) ? this.name : this.name + "1")};
    }

    public void floorChanged(Tile tile) {
    }

    public boolean shouldIndex(Tile tile) {
        return true;
    }

    public boolean updateRender(Tile tile) {
        return false;
    }

    public void renderUpdate(UpdateRenderState tile) {
    }

    public boolean hasSurface() {
        return !this.isLiquid && !this.solid;
    }

    public boolean isDeep() {
        return this.drownTime > 0.0f;
    }

    public void drawNonLayer(Tile tile, CacheLayer layer) {
        Arrays.fill(this.dirs, 0);
        this.blenders.clear();
        this.blended.clear();
        for (int i = 0; i < 8; ++i) {
            Point2 point = Geometry.d8[i];
            Tile other = tile.nearby(point);
            if (other == null || !other.floor().drawEdgeOut || other.floor().cacheLayer != layer || other.floor().edges(tile.x, tile.y) == null || this.blended.getAndSet((int)other.floor().id)) continue;
            this.blenders.add((Object)other.floor());
            this.dirs[i] = other.floorID();
        }
        this.drawBlended(tile, false);
    }

    protected void drawEdges(Tile tile) {
        this.blenders.clear();
        this.blended.clear();
        Arrays.fill(this.dirs, 0);
        CacheLayer realCache = tile.floor().cacheLayer;
        for (int i = 0; i < 8; ++i) {
            Floor ob;
            Point2 point = Geometry.d8[i];
            Tile other = tile.nearby(point);
            if (other == null) continue;
            Floor floor = ob = this == tile.floor() || other.overlay() == Blocks.air ? other.floor() : other.overlay();
            if (!ob.drawEdgeOut || !this.doEdge(tile, other, ob) || other.floor().cacheLayer != realCache || ob.edges(tile.x, tile.y) == null) continue;
            if (!this.blended.getAndSet((int)ob.id)) {
                this.blenders.add((Object)ob);
            }
            this.dirs[i] = ob.id;
        }
        this.drawBlended(tile, true);
    }

    protected void drawBlended(Tile tile, boolean checkId) {
        this.blenders.sort(a -> a.id + (tile.floor() != this && a == tile.floor() ? 99999 : 0));
        for (Floor block : this.blenders) {
            for (int i = 0; i < 8; ++i) {
                Floor ob;
                Point2 point = Geometry.d8[i];
                Tile other = tile.nearby(point);
                if (other == null) continue;
                Floor floor = ob = this == tile.floor() || other.overlay() == Blocks.air ? other.floor() : other.overlay();
                if (ob != block || checkId && this.dirs[i] != block.id) continue;
                TextureRegion region = block.edge(tile.x, tile.y, 1 - point.x, 1 - point.y);
                Draw.rect((TextureRegion)region, (float)tile.worldx(), (float)tile.worldy());
            }
        }
    }

    public int realBlendId(Tile tile) {
        if (tile.floor().isLiquid && !tile.overlay().isAir() && !(tile.overlay() instanceof OreBlock)) {
            return -(tile.overlay().blendId | tile.floor().blendId << 15);
        }
        return this.blendId;
    }

    protected TextureRegion[][] edges(int x, int y) {
        return this.blendGroup.asFloor().edges;
    }

    protected TextureRegion edge(int x, int y, int rx, int ry) {
        return this.edges(x, y)[rx][2 - ry];
    }

    protected boolean doEdge(Tile tile, Tile otherTile, Floor other) {
        return other.realBlendId(otherTile) > this.realBlendId(tile) || this.edges(tile.x, tile.y) == null;
    }

    public boolean damages() {
        return this.damageTaken > 0.0f || this.status != null && this.status.damage > 0.0f;
    }

    public static class UpdateRenderState {
        public Tile tile;
        public Floor floor;
        public float data;

        public UpdateRenderState(Tile tile, Floor floor) {
            this.tile = tile;
            this.floor = floor;
        }
    }
}

