/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Geometry;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.gen.Unit;
import mindustry.graphics.CacheLayer;
import mindustry.world.Block;
import mindustry.world.Tile;

public class Cliff
extends Block {
    public float size = 11.0f;
    public TextureRegion[] cliffs;

    public Cliff(String name) {
        super(name);
        this.alwaysReplace = false;
        this.breakable = false;
        this.solid = true;
        this.cacheLayer = CacheLayer.walls;
        this.fillsTile = false;
        this.hasShadow = false;
    }

    @Override
    public void drawBase(Tile tile) {
        Draw.color((Color)Tmp.c1.set(tile.floor().mapColor).mul(1.6f));
        Draw.rect((TextureRegion)(tile.data != 0 ? this.cliffs[tile.data & 0xFF] : this.region), (float)tile.worldx(), (float)tile.worldy());
        Draw.color();
    }

    @Override
    public void placeEnded(Tile tile, @Nullable Unit builder, int rotation, @Nullable Object config) {
        int rotationb = 0;
        for (int i = 0; i < 8; ++i) {
            Tile other = Vars.world.tiles.get(tile.x + Geometry.d8[i].x, tile.y + Geometry.d8[i].y);
            if (other == null || other.floor().hasSurface()) continue;
            rotationb |= 1 << i;
        }
        tile.data = (byte)rotationb;
    }

    @Override
    public int minimapColor(Tile tile) {
        return Tmp.c1.set(tile.floor().mapColor).mul(1.2f).rgba();
    }
}

