/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.blocks.storage.StorageBlock;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustryX.features.RenderExt;

public class DirectionalUnloader
extends Block {
    public TextureRegion centerRegion;
    public TextureRegion topRegion;
    public TextureRegion arrowRegion;
    public float speed = 1.0f;
    public boolean allowCoreUnload = false;

    public DirectionalUnloader(String name) {
        super(name);
        this.group = BlockGroup.transportation;
        this.update = true;
        this.solid = true;
        this.hasItems = true;
        this.configurable = true;
        this.saveConfig = true;
        this.rotate = true;
        this.itemCapacity = 0;
        this.noUpdateDisabled = true;
        this.unloadable = false;
        this.isDuct = true;
        this.envDisabled = 0;
        this.clearOnDoubleTap = true;
        this.priority = -1.0f;
        this.config(Item.class, (tile, item) -> {
            tile.unloadItem = item;
        });
        this.configClear(tile -> {
            tile.unloadItem = null;
        });
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.speed, 60.0f / this.speed, StatUnit.itemsSecond);
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.topRegion, (float)plan.drawx(), (float)plan.drawy(), (float)(plan.rotation * 90));
        this.drawPlanConfig(plan, list);
    }

    @Override
    public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawPlanConfigCenter(plan, plan.config, "duct-unloader-center");
    }

    @Override
    public void setBars() {
        super.setBars();
        this.removeBar("items");
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.topRegion, this.arrowRegion};
    }

    public class DirectionalUnloaderBuild
    extends Building {
        public float unloadTimer = 0.0f;
        public Item unloadItem = null;
        public int offset = 0;

        @Override
        public void updateTile() {
            block7: {
                block6: {
                    Building back;
                    Building front;
                    block8: {
                        float f;
                        this.unloadTimer += this.edelta();
                        if (!(f >= DirectionalUnloader.this.speed)) break block7;
                        front = this.front();
                        back = this.back();
                        if (front == null || back == null || back.items == null || front.team != this.team || back.team != this.team || !back.canUnload()) break block6;
                        if (DirectionalUnloader.this.allowCoreUnload) break block8;
                        if (back instanceof CoreBlock.CoreBuild) break block6;
                        if (!(back instanceof StorageBlock.StorageBuild)) break block8;
                        StorageBlock.StorageBuild sb = (StorageBlock.StorageBuild)back;
                        if (sb.linkedCore != null) break block6;
                    }
                    if (this.unloadItem == null) {
                        Seq<Item> itemseq = Vars.content.items();
                        int itemc = itemseq.size;
                        for (int i = 0; i < itemc; ++i) {
                            Item item = (Item)((Object)itemseq.get((i + this.offset) % itemc));
                            if (!back.items.has(item) || !front.acceptItem(this, item)) continue;
                            front.handleItem(this, item);
                            back.items.remove(item, 1);
                            back.itemTaken(item);
                            this.offset = item.id + 1;
                            break;
                        }
                    } else if (back.items.has(this.unloadItem) && front.acceptItem(this, this.unloadItem)) {
                        front.handleItem(this, this.unloadItem);
                        back.items.remove(this.unloadItem, 1);
                        back.itemTaken(this.unloadItem);
                    }
                }
                this.unloadTimer %= DirectionalUnloader.this.speed;
            }
        }

        @Override
        public void draw() {
            Draw.rect((TextureRegion)DirectionalUnloader.this.region, (float)this.x, (float)this.y);
            Draw.rect((TextureRegion)DirectionalUnloader.this.topRegion, (float)this.x, (float)this.y, (float)this.rotdeg());
            if (this.unloadItem != null) {
                Draw.color((Color)this.unloadItem.color);
                Draw.rect((TextureRegion)DirectionalUnloader.this.centerRegion, (float)this.x, (float)this.y);
                Draw.color();
                if (RenderExt.arcChoiceUiIcon) {
                    Draw.rect((TextureRegion)this.unloadItem.fullIcon, (float)this.x, (float)this.y, (float)4.0f, (float)4.0f);
                }
            } else {
                Draw.rect((TextureRegion)DirectionalUnloader.this.arrowRegion, (float)this.x, (float)this.y, (float)this.rotdeg());
            }
        }

        @Override
        public void drawSelect() {
            super.drawSelect();
            this.drawItemSelection(this.unloadItem);
        }

        @Override
        public void buildConfiguration(Table table2) {
            ItemSelection.buildTable(DirectionalUnloader.this, table2, Vars.content.items(), () -> this.unloadItem, this::configure);
        }

        public Item config() {
            return this.unloadItem;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.s(this.unloadItem == null ? -1 : (int)this.unloadItem.id);
            write.s(this.offset);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            short id = read.s();
            this.unloadItem = id == -1 ? null : (Item)((Object)Vars.content.items().get((int)id));
            this.offset = read.s();
        }
    }
}

