/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.Core;
import arc.struct.ObjectMap;
import arc.struct.OrderedMap;
import mindustry.entities.bullet.BulletType;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.ui.Bar;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import mindustryX.features.ui.FormatDefault;

public class ItemTurret
extends Turret {
    public ObjectMap<Item, BulletType> ammoTypes = new OrderedMap();

    public ItemTurret(String name) {
        super(name);
        this.hasItems = true;
    }

    public void ammo(Object ... objects) {
        this.ammoTypes = OrderedMap.of((Object[])objects);
    }

    public void limitRange() {
        this.limitRange(9.0f);
    }

    public void limitRange(float margin) {
        for (ObjectMap.Entry entry : this.ammoTypes.entries()) {
            this.limitRange((BulletType)entry.value, margin);
        }
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.itemCapacity);
        this.stats.add(Stat.ammo, StatValues.ammo(this.ammoTypes));
        this.stats.add(Stat.ammoCapacity, (float)(this.maxAmmo / this.ammoPerShot), StatUnit.shots);
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("ammo", entity -> new Bar(() -> Core.bundle.get("stat.ammo") + " " + (entity.totalAmmo > 0 ? ((ItemEntry)entity.ammo.peek()).item.emoji() : "") + " " + FormatDefault.percent(entity.totalAmmo, this.maxAmmo), () -> Pal.ammo, () -> (float)entity.totalAmmo / (float)this.maxAmmo));
    }

    @Override
    public void init() {
        this.consume((Consume)new /* Unavailable Anonymous Inner Class!! */);
        this.ammoTypes.each((item, type) -> {
            this.placeOverlapRange = Math.max(this.placeOverlapRange, this.range + type.rangeChange + this.placeOverlapMargin);
        });
        super.init();
    }
}

