/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.struct.EnumSet;
import arc.struct.Seq;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.world.Block;
import mindustry.world.meta.BlockFlag;

public class Radar
extends Block {
    public float discoveryTime = 600.0f;
    public float rotateSpeed = 2.0f;
    public TextureRegion baseRegion;
    public TextureRegion glowRegion;
    public Color glowColor = Pal.turretHeat;
    public float glowScl = 5.0f;
    public float glowMag = 0.6f;

    public Radar(String name) {
        super(name);
        this.solid = true;
        this.update = true;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.hasFogRadius});
        this.outlineIcon = true;
        this.fogRadius = 10;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.baseRegion, this.region};
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)(this.fogRadius * 8), (Color)Pal.accent);
    }

    @Override
    public void changePlacementPath(Seq<Point2> points, int rotation) {
        float placeRadius2 = Mathf.pow((float)this.fogRadius, (float)2.0f) * 3.0f;
        Placement.calculateNodes(points, (Block)this, (int)rotation, (point, other) -> point.dst2(other) <= placeRadius2);
    }

    public class RadarBuild
    extends Building {
        public float progress;
        public float lastRadius = 0.0f;
        public float smoothEfficiency = 1.0f;
        public float totalProgress;

        @Override
        public float fogRadius() {
            return (float)Radar.this.fogRadius * this.progress * this.smoothEfficiency;
        }

        @Override
        public void updateTile() {
            this.smoothEfficiency = Mathf.lerpDelta((float)this.smoothEfficiency, (float)this.efficiency, (float)0.05f);
            if (Math.abs(this.fogRadius() - this.lastRadius) >= 0.5f) {
                Vars.fogControl.forceUpdate(this.team, this);
                this.lastRadius = this.fogRadius();
            }
            this.progress += this.edelta() / Radar.this.discoveryTime;
            this.progress = Mathf.clamp((float)this.progress);
            this.totalProgress += this.efficiency * this.edelta();
        }

        @Override
        public boolean canPickup() {
            return false;
        }

        @Override
        public void drawSelect() {
            Drawf.dashCircle((float)this.x, (float)this.y, (float)(this.fogRadius() * 8.0f), (Color)Pal.accent);
        }

        @Override
        public void draw() {
            Draw.rect((TextureRegion)Radar.this.baseRegion, (float)this.x, (float)this.y);
            Draw.rect((TextureRegion)Radar.this.region, (float)this.x, (float)this.y, (float)(Radar.this.rotateSpeed * this.totalProgress));
            Drawf.additive((TextureRegion)Radar.this.glowRegion, (Color)Radar.this.glowColor, (float)(Radar.this.glowColor.a * (1.0f - Radar.this.glowMag + Mathf.absin((float)Radar.this.glowScl, (float)Radar.this.glowMag))), (float)this.x, (float)this.y, (float)(Radar.this.rotateSpeed * this.totalProgress), (float)31.0f);
        }

        @Override
        public float progress() {
            return this.progress;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.progress = read.f();
        }
    }
}

