/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.func.Boolf;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.Ranged;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import mindustryX.features.RenderExt;

public class OverdriveProjector
extends Block {
    public TextureRegion topRegion;
    public float reload = 60.0f;
    public float range = 80.0f;
    public float speedBoost = 1.5f;
    public float speedBoostPhase = 0.75f;
    public float useTime = 400.0f;
    public float phaseRangeBoost = 20.0f;
    public boolean hasBoost = true;
    public Color baseColor = Color.valueOf((String)"feb380");
    public Color phaseColor = Color.valueOf((String)"ffd59e");

    public OverdriveProjector(String name) {
        super(name);
        this.solid = true;
        this.update = true;
        this.group = BlockGroup.projectors;
        this.hasPower = true;
        this.hasItems = true;
        this.canOverdrive = false;
        this.emitLight = true;
        this.lightRadius = 50.0f;
        this.envEnabled |= 2;
        this.ambientSound = Sounds.loopCircuit;
        this.ambientSoundVolume = 0.13f;
    }

    @Override
    public void init() {
        this.updateClipRadius(this.range + this.phaseRangeBoost + 3.0f);
        super.init();
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.range, (Color)this.baseColor);
        if (this.hasBoost) {
            Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)(this.range + this.phaseRangeBoost), (Color)this.phaseColor);
            Vars.indexer.eachBlock(Vars.player.team(), (float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range + this.phaseRangeBoost, (Boolf<Building>)((Boolf)other -> other.block.canOverdrive), (Cons<Building>)((Cons)other -> Drawf.selected((Building)other, (Color)Tmp.c1.set(this.phaseColor).a(Mathf.absin((float)4.0f, (float)1.0f)))));
        }
        Vars.indexer.eachBlock(Vars.player.team(), (float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range, (Boolf<Building>)((Boolf)other -> other.block.canOverdrive), (Cons<Building>)((Cons)other -> Drawf.selected((Building)other, (Color)Tmp.c1.set(this.baseColor).a(Mathf.absin((float)4.0f, (float)1.0f)))));
    }

    @Override
    public void setStats() {
        Object t;
        this.stats.timePeriod = this.useTime;
        super.setStats();
        this.stats.add(Stat.speedIncrease, "+" + (int)(this.speedBoost * 100.0f - 100.0f) + "%", new Object[0]);
        this.stats.add(Stat.range, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.productionTime, this.useTime / 60.0f, StatUnit.seconds);
        if (this.hasBoost && (t = this.findConsumer((Boolf<Consume>)((Boolf)f -> f instanceof ConsumeItems))) instanceof ConsumeItems) {
            ConsumeItems items = (ConsumeItems)((Object)t);
            this.stats.remove(Stat.booster);
            this.stats.add(Stat.booster, StatValues.itemBoosters("+{0}%", this.stats.timePeriod, this.speedBoostPhase * 100.0f, this.phaseRangeBoost, items.items));
        }
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("boost", entity -> new Bar(() -> "\u8d85\u901f\uff1a" + (entity.realBoost() <= 1.0f ? "[red]\ue815" : "+" + (int)((entity.realBoost() - 1.0f) * 100.0f) + "%"), () -> Pal.accent, () -> entity.realBoost() / (this.hasBoost ? this.speedBoost + this.speedBoostPhase : this.speedBoost)));
    }

    public class OverdriveBuild
    extends Building
    implements Ranged {
        public float heat;
        public float charge;
        public float phaseHeat;
        public float smoothEfficiency;
        public float useProgress;

        public OverdriveBuild() {
            this.charge = Mathf.random((float)OverdriveProjector.this.reload);
        }

        public float range() {
            return OverdriveProjector.this.range;
        }

        @Override
        public void drawLight() {
            Drawf.light((float)this.x, (float)this.y, (float)(OverdriveProjector.this.lightRadius * this.smoothEfficiency), (Color)OverdriveProjector.this.baseColor, (float)(0.7f * this.smoothEfficiency));
        }

        @Override
        public void updateTile() {
            this.smoothEfficiency = Mathf.lerpDelta((float)this.smoothEfficiency, (float)this.efficiency, (float)0.08f);
            this.heat = Mathf.lerpDelta((float)this.heat, (float)(this.efficiency > 0.0f ? 1.0f : 0.0f), (float)0.08f);
            this.charge += this.heat * Time.delta;
            if (OverdriveProjector.this.hasBoost) {
                this.phaseHeat = Mathf.lerpDelta((float)this.phaseHeat, (float)this.optionalEfficiency, (float)0.1f);
            }
            if (this.charge >= OverdriveProjector.this.reload) {
                float realRange = OverdriveProjector.this.range + this.phaseHeat * OverdriveProjector.this.phaseRangeBoost;
                this.charge = 0.0f;
                Vars.indexer.eachBlock(this, realRange, (Boolf<Building>)((Boolf)other -> other.block.canOverdrive), (Cons<Building>)((Cons)other -> other.applyBoost(this.realBoost(), OverdriveProjector.this.reload + 1.0f)));
            }
            if (this.efficiency > 0.0f) {
                this.useProgress += this.delta();
            }
            if (this.useProgress >= OverdriveProjector.this.useTime) {
                this.consume();
                this.useProgress %= OverdriveProjector.this.useTime;
            }
        }

        public float realBoost() {
            return (OverdriveProjector.this.speedBoost + this.phaseHeat * OverdriveProjector.this.speedBoostPhase) * this.efficiency;
        }

        @Override
        public void drawSelect() {
            float realRange = OverdriveProjector.this.range + this.phaseHeat * OverdriveProjector.this.phaseRangeBoost;
            Vars.indexer.eachBlock(this, realRange, (Boolf<Building>)((Boolf)other -> other.block.canOverdrive), (Cons<Building>)((Cons)other -> Drawf.selected((Building)other, (Color)Tmp.c1.set(OverdriveProjector.this.baseColor).a(Mathf.absin((float)4.0f, (float)1.0f)))));
            Drawf.dashCircle((float)this.x, (float)this.y, (float)realRange, (Color)OverdriveProjector.this.baseColor);
        }

        @Override
        public void draw() {
            super.draw();
            float realRange = OverdriveProjector.this.range + this.phaseHeat * OverdriveProjector.this.phaseRangeBoost;
            float pro_Transparency = RenderExt.overdriveZoneTransparency;
            if (this.realBoost() > 1.0f && pro_Transparency > 0.0f) {
                if (Vars.renderer.animateShields) {
                    Draw.z((float)127.0f);
                    Draw.color((Color)((double)this.phaseHeat > 0.2 ? OverdriveProjector.this.phaseColor : OverdriveProjector.this.baseColor));
                    Fill.circle((float)this.x, (float)this.y, (float)realRange);
                    Draw.color();
                    Draw.z((float)126.7f);
                } else {
                    Draw.color((Color)((double)this.phaseHeat > 0.2 ? OverdriveProjector.this.phaseColor : OverdriveProjector.this.baseColor), (float)pro_Transparency);
                    Lines.circle(this.x, this.y, realRange);
                    Draw.alpha((float)(pro_Transparency * 0.1f));
                    Fill.circle((float)this.x, (float)this.y, (float)realRange);
                }
            }
            float f = 1.0f - Time.time / 100.0f % 1.0f;
            Draw.color((Color)OverdriveProjector.this.baseColor, (Color)OverdriveProjector.this.phaseColor, (float)this.phaseHeat);
            Draw.alpha((float)(this.heat * Mathf.absin((float)Time.time, (float)7.957747f, (float)1.0f) * 0.5f));
            Draw.rect((TextureRegion)OverdriveProjector.this.topRegion, (float)this.x, (float)this.y);
            Draw.alpha((float)1.0f);
            Lines.stroke((2.0f * f + 0.1f) * this.heat);
            float r = Math.max(0.0f, Mathf.clamp((float)(2.0f - f * 2.0f)) * (float)OverdriveProjector.this.size * 8.0f / 2.0f - f - 0.2f);
            float w = Mathf.clamp((float)(0.5f - f)) * (float)OverdriveProjector.this.size * 8.0f;
            Lines.beginLine();
            for (int i = 0; i < 4; ++i) {
                Lines.linePoint(this.x + (float)Geometry.d4((int)i).x * r + (float)Geometry.d4((int)i).y * w, this.y + (float)Geometry.d4((int)i).y * r - (float)Geometry.d4((int)i).x * w);
                if (!(f < 0.5f)) continue;
                Lines.linePoint(this.x + (float)Geometry.d4((int)i).x * r - (float)Geometry.d4((int)i).y * w, this.y + (float)Geometry.d4((int)i).y * r + (float)Geometry.d4((int)i).x * w);
            }
            Lines.endLine(true);
            Draw.reset();
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.heat);
            write.f(this.phaseHeat);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.heat = read.f();
            this.phaseHeat = read.f();
        }
    }
}

