/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world;

import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.BufferItem;
import mindustry.gen.BufferItemLegacy;
import mindustry.type.Item;

public class DirectionalItemBuffer {
    public final long[][] buffers;
    public final int[] indexes;

    public DirectionalItemBuffer(int capacity) {
        this.buffers = new long[4][capacity];
        this.indexes = new int[5];
    }

    public boolean accepts(int buffer) {
        return this.indexes[buffer] < this.buffers[buffer].length;
    }

    public Item getItem(int dir, int i) {
        if (i >= this.indexes[dir]) {
            return null;
        }
        return Vars.content.item(BufferItem.item((long)this.buffers[dir][i]));
    }

    public float getTime(int dir, int i) {
        if (i >= this.indexes[dir]) {
            return Float.MAX_VALUE;
        }
        return BufferItem.time((long)this.buffers[dir][i]);
    }

    public void accept(int buffer, Item item) {
        if (!this.accepts(buffer)) {
            return;
        }
        int n = buffer;
        int n2 = this.indexes[n];
        this.indexes[n] = n2 + 1;
        this.buffers[buffer][n2] = BufferItem.get((short)item.id, (float)Time.time);
    }

    public Item poll(int buffer, float speed) {
        long l;
        float time;
        if (this.indexes[buffer] > 0 && (Time.time >= (time = BufferItem.time((long)(l = this.buffers[buffer][0]))) + speed || Time.time < time)) {
            return Vars.content.item(BufferItem.item((long)l));
        }
        return null;
    }

    public void remove(int buffer) {
        System.arraycopy(this.buffers[buffer], 1, this.buffers[buffer], 0, this.indexes[buffer] - 1);
        int n = buffer;
        this.indexes[n] = this.indexes[n] - 1;
    }

    public void write(Writes write) {
        for (int i = 0; i < 4; ++i) {
            write.b(this.indexes[i]);
            write.b(this.buffers[i].length);
            for (long l : this.buffers[i]) {
                write.l(l);
            }
        }
    }

    public void read(Reads read) {
        this.read(read, false);
    }

    public void read(Reads read, boolean legacy) {
        for (int i = 0; i < 4; ++i) {
            this.indexes[i] = read.b();
            int length = read.b();
            for (int j = 0; j < length; ++j) {
                long value = read.l();
                if (legacy) {
                    value = BufferItem.get((short)BufferItemLegacy.item((long)value), (float)BufferItemLegacy.time((long)value));
                }
                if (j >= this.buffers[i].length) continue;
                this.buffers[i][j] = value;
            }
        }
    }

    class BufferItemLegacyStruct {
        byte item;
        float time;

        BufferItemLegacyStruct() {
        }
    }

    class BufferItemStruct {
        short item;
        float time;

        BufferItemStruct() {
        }
    }
}

