/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world;

import arc.Events;
import arc.func.Boolf;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.Liquids;
import mindustry.entities.Units;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.storage.CoreBlock;
import mindustryX.features.LogicExt;

public class Build {
    private static final IntSet tmp = new IntSet();

    public static void beginBreak(@Nullable Unit unit, Team team, int x, int y) {
        if (!Build.validBreak(team, x, y)) {
            return;
        }
        Tile tile = Vars.world.tileBuilding(x, y);
        float prevPercent = 1.0f;
        if (tile.build != null) {
            prevPercent = tile.build.healthf();
        }
        int rotation = tile.build != null ? tile.build.rotation : 0;
        Block previous = tile.block();
        if (previous.instantDeconstruct) {
            ConstructBlock.deconstructFinish(tile, previous, unit);
            return;
        }
        ConstructBlock sub = ConstructBlock.get(previous.size);
        Seq prevBuild = new Seq(1);
        if (tile.build != null) {
            prevBuild.add((Object)tile.build);
            tile.build.onDeconstructed(unit);
            tile.build.dead = true;
        }
        tile.setBlock((Block)sub, team, rotation);
        ConstructBlock.ConstructBuild build = (ConstructBlock.ConstructBuild)tile.build;
        build.setDeconstruct(previous);
        build.prevBuild = prevBuild;
        tile.build.health = tile.build.maxHealth * prevPercent;
        if (unit != null && unit.getControllerName() != null) {
            tile.build.lastAccessed = unit.getControllerName();
        }
        Events.fire((Object)new EventType.BlockBuildBeginEvent(tile, team, unit, true));
    }

    public static void beginPlace(@Nullable Unit unit, Block result, Team team, int x, int y, int rotation, @Nullable Object placeConfig) {
        if (!Build.validPlace(result, team, x, y, rotation)) {
            return;
        }
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return;
        }
        if (tile.team() == team && tile.block == result && tile.build != null && tile.block.quickRotate) {
            if (unit != null && unit.getControllerName() != null) {
                tile.build.lastAccessed = unit.getControllerName();
            }
            int previous = tile.build.rotation;
            tile.build.rotation = Mathf.mod((int)rotation, (int)4);
            tile.build.updateProximity();
            tile.build.noSleep();
            Fx.rotateBlock.at(tile.build.x, tile.build.y, (float)tile.build.block.size);
            Events.fire((Object)new EventType.BuildRotateEvent(tile.build, unit, previous));
            if (!Vars.headless) {
                Sounds.blockRotate.at((Position)tile.build, 1.0f + Mathf.range((float)0.1f), 1.0f);
            }
            return;
        }
        if (tile.team() == Team.derelict && team != Team.derelict && tile.block == result && tile.build != null && tile.block.allowDerelictRepair && Vars.state.rules.derelictRepair) {
            tile.build.rotation = rotation;
            tile.build.changeTeam(team);
            tile.build.enabled = true;
            if (tile.build.power != null) {
                tile.build.power.links.clear();
                tile.build.powerGraphRemoved();
            }
            tile.build.checkAllowUpdate();
            tile.build.updateProximity();
            tile.build.onRepaired();
            if (unit != null && unit.getControllerName() != null) {
                tile.build.lastAccessed = unit.getControllerName();
            }
            if (Vars.fogControl.isVisibleTile(team, tile.x, tile.y)) {
                result.placeEffect.at(tile.drawx(), tile.drawy(), (float)result.size);
                Fx.rotateBlock.at(tile.build.x, tile.build.y, (float)tile.build.block.size);
                ConstructBlock.playRepairSound(team, tile);
            }
            Events.fire((Object)new EventType.BlockBuildEndEvent(tile, unit, team, false, tile.build.config()));
            return;
        }
        tile.getLinkedTilesAs(result, out -> {
            if (out.block != Blocks.air && out.block.alwaysReplace) {
                out.block.breakEffect.at(out.drawx(), out.drawy(), (float)out.block.size, out.block.mapColor);
                out.remove();
            }
        });
        if (result.instantBuild) {
            Events.fire((Object)new EventType.BlockBuildBeginEvent(tile, team, unit, false));
            result.placeBegan(tile, tile.block, unit);
            ConstructBlock.constructFinish(tile, result, unit, (byte)rotation, team, placeConfig);
            return;
        }
        Block previous = tile.block();
        ConstructBlock sub = ConstructBlock.get(result.size);
        Seq prevBuild = new Seq(9);
        result.beforePlaceBegan(tile, previous);
        tmp.clear();
        tile.getLinkedTilesAs(result, t -> {
            if (t.build != null && t.build.team == team && tmp.add(t.build.id)) {
                prevBuild.add((Object)t.build);
            }
        });
        tile.setBlock((Block)sub, team, rotation);
        ConstructBlock.ConstructBuild build = (ConstructBlock.ConstructBuild)tile.build;
        build.setConstruct(previous.size == sub.size ? previous : Blocks.air, result);
        build.prevBuild = prevBuild;
        if (unit != null && unit.getControllerName() != null) {
            build.lastAccessed = unit.getControllerName();
        }
        Events.fire((Object)new EventType.BlockBuildBeginEvent(tile, team, unit, false));
        result.placeBegan(tile, previous, unit);
    }

    public static boolean validPlace(Block type, Team team, int x, int y, int rotation) {
        return Build.validPlace(type, team, x, y, rotation, true);
    }

    public static boolean validPlace(Block type, Team team, int x, int y, int rotation, boolean checkVisible) {
        return Build.validPlace(type, team, x, y, rotation, checkVisible, true);
    }

    public static boolean validPlace(Block type, Team team, int x, int y, int rotation, boolean checkVisible, boolean checkCoreRadius) {
        return Build.validPlaceIgnoreUnits(type, team, x, y, rotation, checkVisible, checkCoreRadius) && Build.checkNoUnitOverlap(type, x, y);
    }

    public static boolean checkNoUnitOverlap(Block type, int x, int y) {
        return !type.solid && !type.solidifes || !Units.anyEntities((float)(x * 8) + type.offset - (float)(type.size * 8) / 2.0f, (float)(y * 8) + type.offset - (float)(type.size * 8) / 2.0f, type.size * 8, type.size * 8);
    }

    public static boolean validPlaceIgnoreUnits(Block type, Team team, int x, int y, int rotation, boolean checkVisible, boolean checkCoreRadius) {
        Tile tile;
        if (LogicExt.worldCreator) {
            Tile tile2 = Vars.world.tile(x, y);
            return tile2 != null;
        }
        if (!(type != null && (Vars.state.rules.editor || !checkVisible || type.environmentBuildable() && (type.isPlaceable() || Vars.state.rules.waves && team == Vars.state.rules.waveTeam && type.isVisible())))) {
            return false;
        }
        if (!Vars.state.rules.editor && checkCoreRadius) {
            if (Vars.state.rules.polygonCoreProtection) {
                float mindst = Float.MAX_VALUE;
                CoreBlock.CoreBuild closest = null;
                for (Teams.TeamData data : Vars.state.teams.active) {
                    for (CoreBlock.CoreBuild tile3 : data.cores) {
                        float dst = tile3.dst2((float)(x * 8) + type.offset, (float)(y * 8) + type.offset);
                        if (!(dst < mindst)) continue;
                        closest = tile3;
                        mindst = dst;
                    }
                }
                if (closest != null && closest.team != team) {
                    return false;
                }
            } else if (Vars.state.teams.anyEnemyCoresWithinBuildRadius(team, (float)(x * 8) + type.offset, (float)(y * 8) + type.offset)) {
                return false;
            }
        }
        if ((tile = Vars.world.tile(x, y)) == null) {
            return false;
        }
        if (!type.canPlaceOn(tile, team, rotation)) {
            return false;
        }
        if (type.isFloor()) {
            return type.isOverlay() ? tile.overlay() != type : tile.floor() != type;
        }
        if (!type.ignoreBuildDarkness && Vars.world.getDarkness(x, y) >= 3.0f) {
            return false;
        }
        if (!(type.requiresWater || Build.contactsShallows(tile.x, tile.y, type) || type.placeableLiquid)) {
            return false;
        }
        int offsetx = -(type.size - 1) / 2;
        int offsety = -(type.size - 1) / 2;
        for (int dx = 0; dx < type.size; ++dx) {
            for (int dy = 0; dy < type.size; ++dy) {
                block20: {
                    Tile check;
                    block21: {
                        int wx = dx + offsetx + tile.x;
                        int wy = dy + offsety + tile.y;
                        check = Vars.world.tile(wx, wy);
                        if (check == null || type.size == 2 && Vars.world.getDarkness(wx, wy) >= 3.0f || Vars.state.rules.staticFog && Vars.state.rules.fog && !Vars.fogControl.isDiscovered(team, wx, wy) || check.floor().isDeep() && !type.floating && !type.requiresWater && !type.placeableLiquid || !Vars.state.rules.derelictRepair && check.team() == Team.derelict && check.build != null || type == check.block() && check.build != null && rotation == check.build.rotation && type.rotate && (type != check.block || team == Team.derelict || check.team() != Team.derelict) || !check.interactable(team) || !check.floor().placeableOn && !type.ignoreBuildDarkness || !checkVisible && checkCoreRadius && !check.block().alwaysReplace) break block20;
                        if (type.canReplace(check.block()) || check.build != null && check.build.canBeReplaced(type) || type == check.block && team != Team.derelict && check.team() == Team.derelict) break block21;
                        Building building = check.build;
                        if (!(building instanceof ConstructBlock.ConstructBuild)) break block20;
                        ConstructBlock.ConstructBuild build = (ConstructBlock.ConstructBuild)building;
                        if (build.current != type || check.centerX() != tile.x || check.centerY() != tile.y) break block20;
                    }
                    if (type.bounds(tile.x, tile.y, Tmp.r1).grow(0.01f).contains(check.block.bounds(check.centerX(), check.centerY(), Tmp.r2)) && (!type.requiresWater || check.floor().liquidDrop == Liquids.water)) continue;
                }
                return false;
            }
        }
        return !Vars.state.rules.placeRangeCheck || !checkCoreRadius || Vars.state.isEditor() || Build.getEnemyOverlap(type, team, x, y) == null;
    }

    @Nullable
    public static Building getEnemyOverlap(Block block, Team team, int x, int y) {
        return Vars.indexer.findEnemyTile(team, x * 8 + block.size, y * 8 + block.size, block.placeOverlapRange + 4.0f, (Boolf<Building>)((Boolf)p -> true));
    }

    public static boolean contactsGround(int x, int y, Block block) {
        if (block.isMultiblock()) {
            for (Point2 point : Edges.getEdges((int)block.size)) {
                Tile tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isLiquid) continue;
                return true;
            }
        } else {
            for (Point2 point : Geometry.d4) {
                Tile tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isLiquid) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contactsShallows(int x, int y, Block block) {
        if (block.isMultiblock()) {
            Tile tile;
            for (Point2 point : block.getInsideEdges()) {
                tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isDeep()) continue;
                return true;
            }
            for (Point2 point : block.getEdges()) {
                tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isDeep()) continue;
                return true;
            }
        } else {
            for (Point2 point : Geometry.d4) {
                Tile tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isDeep()) continue;
                return true;
            }
            Tile tile = Vars.world.tile(x, y);
            return tile != null && !tile.floor().isDeep();
        }
        return false;
    }

    public static boolean validBreak(Team team, int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        if (LogicExt.worldCreator && tile.block() != Blocks.air) {
            return true;
        }
        return tile != null && tile.block() != Blocks.air && tile.block().canBreak(tile) && (tile.breakable() || Vars.state.rules.allowEnvironmentDeconstruct) && tile.interactable(team);
    }
}

