/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.event.ClickListener;
import arc.scene.event.EventListener;
import arc.scene.event.HandCursorListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Structs;
import java.util.Comparator;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.Player;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.net.NetConnection;
import mindustry.net.Packets;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.AdminsDialog;
import mindustry.ui.dialogs.BansDialog;
import mindustry.ui.dialogs.BaseDialog;
import mindustryX.features.UIExt;
import mindustryX.features.ui.ArcMessageDialog;

public class PlayerListFragment {
    public Table content = new Table().marginRight(13.0f).marginLeft(13.0f);
    private boolean visible = false;
    private Interval timer = new Interval();
    private TextField search;
    private Seq<Player> players = new Seq();

    public void build(Group parent) {
        this.content.name = "players";
        parent.fill(cont -> {
            cont.name = "playerlist";
            cont.visible(() -> this.visible);
            cont.update(() -> {
                if (!Vars.net.active() || !Vars.state.isGame()) {
                    this.visible = false;
                    return;
                }
                if (this.visible && this.timer.get(20.0f)) {
                    this.rebuild();
                    this.content.pack();
                    this.content.act(Core.graphics.getDeltaTime());
                    Core.scene.act(0.0f);
                }
            });
            cont.table(Tex.buttonTrans, pane -> {
                pane.label(() -> Core.bundle.format(Groups.player.size() == 1 ? "players.single" : "players", new Object[]{Groups.player.size()}));
                pane.row();
                this.search = (TextField)pane.field(null, text -> this.rebuild()).grow().pad(8.0f).name("search").maxTextLength(40).get();
                this.search.setMessageText(Core.bundle.get("players.search"));
                pane.row();
                pane.pane((Element)this.content).grow().scrollX(false);
                pane.row();
                pane.table(menu -> {
                    menu.defaults().growX().height(50.0f).fillY();
                    menu.name = "menu";
                    menu.button("@server.bans", () -> ((BansDialog)Vars.ui.bans).show()).disabled(b -> Vars.net.client());
                    menu.button("@server.admins", () -> ((AdminsDialog)Vars.ui.admins).show()).disabled(b -> Vars.net.client());
                    menu.button("@close", this::toggle);
                }).margin(0.0f).pad(10.0f).growX();
            }).touchable(Touchable.enabled).margin(14.0f).minWidth(620.0f);
        });
        this.rebuild();
    }

    public void rebuild() {
        boolean allowTeamSwitch = !Vars.state.isCampaign() && (Vars.state.rules.pvp || Vars.state.rules.infiniteResources);
        this.content.clear();
        float h = 40.0f;
        boolean found = false;
        this.players.clear();
        Groups.player.copy(this.players);
        this.players.sort(Structs.comps((Comparator)Structs.comparing(Player::team), (Comparator)Structs.comparingBool(p -> !p.admin)));
        if (this.search.getText().length() > 0) {
            this.players.retainAll(p -> p.name().toLowerCase().contains(this.search.getText().toLowerCase()) || Strings.stripColors((CharSequence)p.name().toLowerCase()).contains(this.search.getText().toLowerCase()));
        }
        for (final Player user : this.players) {
            boolean clickable;
            found = true;
            NetConnection connection = user.con;
            if (connection == null && Vars.net.server() && !user.isLocal()) {
                return;
            }
            Table button2 = new Table();
            button2.left();
            button2.margin(5.0f).marginBottom(10.0f);
            final ClickListener listener = new ClickListener();
            Table iconTable = new Table(){

                public void draw() {
                    super.draw();
                    Draw.colorMul((Color)user.team().color, (float)(listener.isOver() ? 1.3f : 1.0f));
                    Draw.alpha((float)this.parentAlpha);
                    Lines.stroke(Scl.scl((float)4.0f));
                    Lines.rect(this.x, this.y, this.width, this.height);
                    Draw.reset();
                }
            };
            boolean bl = clickable = !Vars.state.rules.fog || !Vars.state.rules.pvp || user.team() == Vars.player.team();
            if (clickable) {
                iconTable.addListener((EventListener)listener);
                iconTable.addListener((EventListener)new HandCursorListener());
            }
            iconTable.margin(4.0f);
            iconTable.add((Element)new Image(user.icon()).setScaling(Scaling.bounded)).grow();
            iconTable.name = user.name();
            iconTable.touchable = Touchable.enabled;
            iconTable.tapped(() -> {
                if (!user.dead() && clickable) {
                    Vars.control.input.spectate(user.unit());
                    Vars.ui.showInfoFade(Core.bundle.format("viewplayer", new Object[]{user.name}), 1.0f);
                }
            });
            button2.add((Element)iconTable).size(h);
            ((Image)button2.image((Drawable)Icon.admin).visible(() -> user.admin && (user.isLocal() || !Vars.net.server())).pad(4.0f).get()).updateVisibility();
            button2.labelWrap("[#" + user.color().toString().toUpperCase() + "]" + user.name()).style((Style)Styles.outlineLabel).growX();
            button2.background(Tex.underlineWhite);
            button2.setColor(Vars.state.rules.pvp || Core.settings.getBool("arcAlwaysTeamColor") ? user.team().color : Pal.gray);
            ImageButton.ImageButtonStyle ustyle = new ImageButton.ImageButtonStyle(){
                {
                    this.down = Styles.none;
                    this.up = Styles.none;
                    this.imageDownColor = Pal.accent;
                    this.imageUpColor = Color.white;
                    this.imageOverColor = Color.lightGray;
                }
            };
            button2.button((Drawable)Icon.copySmall, ustyle, () -> {
                Core.app.setClipboardText(user.name);
                UIExt.announce("\u5df2\u590d\u5236\u6635\u79f0\uff1a" + user.name);
            }).size(32.0f);
            button2.button((Drawable)Icon.linkSmall, ustyle, () -> ArcMessageDialog.share("AT", "\u6233\u4e86" + user.name + "[white]\u4e00\u4e0b\uff0c\u5e76\u63d0\u9192\u4f60\u7559\u610f\u5bf9\u8bdd\u6846")).size(32.0f);
            button2.button((Drawable)Icon.planeOutlineSmall, ustyle, () -> Vars.ui.showTextInput("@votekick.reason", Core.bundle.format("votekick.reason.message", new Object[]{user.name()}), "", (Cons<String>)((Cons)reason -> Call.sendChatMessage((String)("/votekick #" + user.id + " " + reason))))).size(32.0f);
            if (Vars.net.server() || Vars.player.admin && (!user.admin || user == Vars.player)) {
                button2.add().growY();
                if (allowTeamSwitch || user != Vars.player) {
                    button2.button((Drawable)Icon.wrenchSmall, ustyle, () -> {
                        BaseDialog dialog = new BaseDialog(user.coloredName());
                        dialog.title.setColor(Color.white);
                        dialog.titleTable.remove();
                        dialog.closeOnBack();
                        TextButton.TextButtonStyle bstyle = Styles.defaultt;
                        dialog.cont.add((CharSequence)user.coloredName()).row();
                        dialog.cont.image(Tex.whiteui, Pal.accent).fillX().height(3.0f).pad(4.0f).row();
                        dialog.cont.pane(t -> {
                            t.defaults().size(220.0f, 55.0f).pad(3.0f);
                            if (user != Vars.player) {
                                t.button("@player.ban", (Drawable)Icon.hammer, bstyle, () -> {
                                    Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmban", new Object[]{user.name()}), () -> Call.adminRequest((Player)user, (Packets.AdminAction)Packets.AdminAction.ban, null));
                                    dialog.hide();
                                }).row();
                                t.button("@player.kick", (Drawable)Icon.cancel, bstyle, () -> {
                                    Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmkick", new Object[]{user.name()}), () -> Call.adminRequest((Player)user, (Packets.AdminAction)Packets.AdminAction.kick, null));
                                    dialog.hide();
                                }).row();
                                t.button("@player.trace", (Drawable)Icon.zoom, bstyle, () -> {
                                    Call.adminRequest((Player)user, (Packets.AdminAction)Packets.AdminAction.trace, null);
                                    dialog.hide();
                                }).row();
                            }
                            if (allowTeamSwitch) {
                                t.button("@player.team", (Drawable)Icon.redo, bstyle, () -> {
                                    UIExt.teamSelect.pickOne((Cons<Team>)((Cons)it -> Call.adminRequest((Player)user, (Packets.AdminAction)Packets.AdminAction.switchTeam, (Object)it)), user.team());
                                    dialog.hide();
                                }).row();
                            }
                            if (!Vars.net.client() && !user.isLocal()) {
                                t.button("@player.admin", (Drawable)Icon.admin, Styles.togglet, () -> {
                                    dialog.hide();
                                    String id = user.uuid();
                                    if (user.admin) {
                                        Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmunadmin", new Object[]{user.name()}), () -> {
                                            Vars.netServer.admins.unAdminPlayer(id);
                                            user.admin = false;
                                        });
                                    } else {
                                        Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmadmin", new Object[]{user.name()}), () -> {
                                            Vars.netServer.admins.adminPlayer(id, user.usid());
                                            user.admin = true;
                                        });
                                    }
                                }).checked(b -> user.admin).row();
                            }
                        }).row();
                        dialog.cont.button("@back", (Drawable)Icon.left, () -> ((BaseDialog)dialog).hide()).padTop(-1.0f).size(220.0f, 55.0f);
                        dialog.show();
                    }).size(32.0f);
                }
            }
            this.content.add((Element)button2).width(600.0f).height(h + 14.0f);
            this.content.row();
        }
        if (!found) {
            this.content.add((CharSequence)Core.bundle.format("players.notfound", new Object[0])).padBottom(6.0f).width(350.0f).maxHeight(h + 14.0f);
        }
        this.content.marginBottom(5.0f);
    }

    public void toggle() {
        boolean bl = this.visible = !this.visible;
        if (this.visible) {
            this.rebuild();
        } else {
            Core.scene.setKeyboardFocus(null);
            this.search.clearText();
        }
    }
}

