/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.files.Fi;
import arc.files.ZipFi;
import arc.func.Boolc;
import arc.func.Cons;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.scene.Element;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.CheckBox;
import arc.scene.ui.Image;
import arc.scene.ui.Label;
import arc.scene.ui.Slider;
import arc.scene.ui.TextArea;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.OS;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import mindustry.Vars;
import mindustry.content.TechTree;
import mindustry.core.GameState;
import mindustry.core.Version;
import mindustry.ctype.Content;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.game.Saves;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.graphics.Shaders;
import mindustry.input.DesktopInput;
import mindustry.input.MobileInput;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.JoinDialog;
import mindustry.ui.dialogs.KeybindDialog;
import mindustry.ui.dialogs.LanguageDialog;
import mindustry.ui.dialogs.SettingsMenuDialog;

public class SettingsMenuDialog
extends BaseDialog {
    public SettingsTable graphics;
    public SettingsTable game;
    public SettingsTable sound;
    public SettingsTable main;
    private Table prefs;
    private Table menu;
    private BaseDialog dataDialog;
    private Seq<SettingsCategory> categories = new Seq();

    public SettingsMenuDialog() {
        super(Core.bundle.get("settings", "Settings"));
        this.addCloseButton();
        this.main = new SettingsTable();
        this.cont.add((Element)this.main);
        this.shouldPause = true;
        this.shown(this::back);
        this.onResize(() -> {
            this.graphics.rebuild();
            this.sound.rebuild();
            this.game.rebuild();
            this.updateScrollFocus();
        });
        this.cont.clearChildren();
        this.cont.remove();
        this.buttons.remove();
        this.menu = new Table(Tex.button);
        this.game = new SettingsTable();
        this.graphics = new SettingsTable();
        this.sound = new SettingsTable();
        this.prefs = new Table();
        this.prefs.top();
        this.prefs.margin(14.0f);
        this.rebuildMenu();
        this.prefs.clearChildren();
        this.prefs.add((Element)this.menu);
        this.dataDialog = new BaseDialog("@settings.data");
        this.dataDialog.addCloseButton();
        this.dataDialog.cont.table(Tex.button, t -> {
            t.defaults().size(280.0f, 60.0f).left();
            TextButton.TextButtonStyle style = Styles.flatt;
            t.button("@settings.cleardata", (Drawable)Icon.trash, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clearall.confirm", () -> {
                ObjectMap map = new ObjectMap();
                for (String value : Core.settings.keys()) {
                    if (!value.contains("usid") && !value.contains("uuid")) continue;
                    map.put((Object)value, Core.settings.get(value, null));
                }
                Core.settings.clear();
                Core.settings.putAll(map);
                for (Fi file : Vars.dataDirectory.list()) {
                    file.deleteDirectory();
                }
                Core.app.exit();
            })).marginLeft(4.0f);
            t.row();
            t.button("@settings.clearsaves", (Drawable)Icon.trash, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clearsaves.confirm", () -> Vars.control.saves.deleteAll())).marginLeft(4.0f);
            t.row();
            t.button("@settings.clearresearch", (Drawable)Icon.trash, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clearresearch.confirm", () -> {
                Vars.universe.clearLoadoutInfo();
                for (TechTree.TechNode node : TechTree.all) {
                    node.reset();
                }
                Vars.content.each((Cons<Content>)((Cons)c -> {
                    if (c instanceof UnlockableContent) {
                        UnlockableContent u = (UnlockableContent)((Object)((Object)((Object)((Object)c))));
                        u.clearUnlock();
                    }
                }));
                Core.settings.remove("unlocks");
            })).marginLeft(4.0f);
            t.row();
            t.button("@settings.clearcampaignsaves", (Drawable)Icon.trash, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clearcampaignsaves.confirm", () -> {
                for (Planet planet : Vars.content.planets()) {
                    for (Sector sec : planet.sectors) {
                        sec.clearInfo();
                        if (sec.save == null) continue;
                        sec.save.delete();
                        sec.save = null;
                    }
                }
                for (Saves.SaveSlot slot : Vars.control.saves.getSaveSlots().copy()) {
                    if (!slot.isSector()) continue;
                    slot.delete();
                }
            })).marginLeft(4.0f);
            t.row();
            t.button("@data.export", (Drawable)Icon.upload, style, () -> {
                if (Vars.ios) {
                    Fi file2 = Core.files.local("mindustry-data-export.zip");
                    try {
                        this.exportData(file2);
                    }
                    catch (Exception e) {
                        Vars.ui.showException(e);
                    }
                    Vars.platform.shareFile(file2);
                } else {
                    Vars.platform.showFileChooser(false, "zip", file -> {
                        try {
                            this.exportData((Fi)file);
                            Vars.ui.showInfo("@data.exported");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Vars.ui.showException(e);
                        }
                    });
                }
            }).marginLeft(4.0f);
            t.row();
            t.button("@data.import", (Drawable)Icon.download, style, () -> Vars.ui.showConfirm("@confirm", "@data.import.confirm", () -> Vars.platform.showFileChooser(true, "zip", file -> {
                try {
                    this.importData((Fi)file);
                    Vars.control.saves.resetSave();
                    Vars.state = new GameState();
                    Core.app.exit();
                }
                catch (IllegalArgumentException e) {
                    Vars.ui.showErrorMessage("@data.invalid");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e.getMessage() == null || !e.getMessage().contains("too short")) {
                        Vars.ui.showException(e);
                    }
                    Vars.ui.showErrorMessage("@data.invalid");
                }
            }))).marginLeft(4.0f);
            if (!Vars.mobile) {
                t.row();
                t.button("@data.openfolder", (Drawable)Icon.folder, style, () -> Core.app.openFolder(Core.settings.getDataDirectory().absolutePath())).marginLeft(4.0f);
            }
            t.row();
            t.button("@crash.export", (Drawable)Icon.upload, style, () -> {
                if (Core.settings.getDataDirectory().child("crashes").list().length == 0 && !Core.settings.getDataDirectory().child("last_log.txt").exists()) {
                    Vars.ui.showInfo("@crash.none");
                } else if (Vars.ios) {
                    Fi logs = Vars.tmpDirectory.child("logs.txt");
                    logs.writeString(this.getLogs());
                    Vars.platform.shareFile(logs);
                } else {
                    Vars.platform.showFileChooser(false, "txt", file -> {
                        try {
                            file.writeBytes(this.getLogs().getBytes(Strings.utf8));
                            Core.app.post(() -> Vars.ui.showInfo("@crash.exported"));
                        }
                        catch (Throwable e) {
                            Vars.ui.showException(e);
                        }
                    });
                }
            }).marginLeft(4.0f);
        });
        this.row();
        this.pane((Element)this.prefs).grow().top();
        this.row();
        this.add((Element)this.buttons).fillX();
        this.addSettings();
    }

    String getLogs() {
        Fi log = Core.settings.getDataDirectory().child("last_log.txt");
        StringBuilder out = new StringBuilder();
        for (Fi fi : Core.settings.getDataDirectory().child("crashes").list()) {
            out.append(fi.name()).append("\n\n").append(fi.readString()).append("\n");
        }
        if (log.exists()) {
            out.append("\nlast log:\n").append(log.readString());
        }
        return out.toString();
    }

    public void addCategory(String name, @Nullable String region, Cons<SettingsTable> builder) {
        this.categories.add((Object)new SettingsCategory(name, (Drawable)(region == null ? null : new TextureRegionDrawable((TextureRegion)Core.atlas.find(region))), builder));
    }

    public void addCategory(String name, @Nullable Drawable icon, Cons<SettingsTable> builder) {
        this.categories.add((Object)new SettingsCategory(name, icon, builder));
    }

    public void addCategory(String name, Cons<SettingsTable> builder) {
        this.addCategory(name, (Drawable)null, builder);
    }

    public Seq<SettingsCategory> getCategories() {
        return this.categories;
    }

    void rebuildMenu() {
        float isize;
        float marg;
        TextButton.TextButtonStyle style;
        block7: {
            block6: {
                this.menu.clearChildren();
                style = Styles.flatt;
                marg = 8.0f;
                isize = 32.0f;
                this.menu.defaults().size(300.0f, 60.0f);
                this.menu.button("@settings.game", (Drawable)Icon.settings, style, isize, () -> this.visible(0)).marginLeft(marg).row();
                this.menu.button("@settings.graphics", (Drawable)Icon.image, style, isize, () -> this.visible(1)).marginLeft(marg).row();
                this.menu.button("@settings.sound", (Drawable)Icon.filters, style, isize, () -> this.visible(2)).marginLeft(marg).row();
                int i = 3;
                for (SettingsCategory cat : this.categories) {
                    int index = i;
                    if (cat.icon == null) {
                        this.menu.button(cat.name, style, () -> this.visible(index)).marginLeft(marg).row();
                    } else {
                        this.menu.button(cat.name, cat.icon, style, isize, () -> this.visible(index)).with(b -> ((Image)b.getChildren().get(1)).setScaling(Scaling.fit)).marginLeft(marg).row();
                    }
                    ++i;
                }
                this.menu.button("@settings.language", (Drawable)Icon.chat, style, isize, () -> ((LanguageDialog)Vars.ui.language).show()).marginLeft(marg).row();
                if (!Vars.mobile) break block6;
                if (!Core.settings.getBool("keyboard")) break block7;
            }
            this.menu.button("@settings.controls", (Drawable)Icon.move, style, isize, () -> ((KeybindDialog)Vars.ui.controls).show()).marginLeft(marg).row();
        }
        this.menu.button("@settings.data", (Drawable)Icon.save, style, isize, () -> this.dataDialog.show()).marginLeft(marg).row();
    }

    void addSettings() {
        this.sound.checkPref("alwaysmusic", false);
        this.sound.sliderPref("musicvol", 100, 0, 100, 1, i -> i + "%");
        this.sound.sliderPref("sfxvol", 100, 0, 100, 1, i -> i + "%");
        this.sound.sliderPref("ambientvol", 100, 0, 100, 1, i -> i + "%");
        this.game.sliderPref("saveinterval", 60, 10, 600, 10, i -> Core.bundle.format("setting.seconds", new Object[]{i}));
        this.game.checkPref("autotarget", true);
        if (Vars.mobile) {
            this.game.checkPref("keyboard", false, val -> {
                Vars.control.setInput(val ? new DesktopInput() : new MobileInput());
                Core.input.setUseKeyboard(val);
            });
            if (Core.settings.getBool("keyboard")) {
                Vars.control.setInput(new DesktopInput());
                Core.input.setUseKeyboard(true);
            }
        }
        if (!Vars.mobile) {
            this.game.checkPref("crashreport", true);
        }
        this.game.checkPref("communityservers", true, val -> {
            Vars.defaultServers.clear();
            if (val) {
                JoinDialog.fetchServers();
            }
        });
        this.game.checkPref("savecreate", true);
        this.game.checkPref("blockreplace", true);
        this.game.checkPref("conveyorpathfinding", true);
        this.game.checkPref("hints", true);
        this.game.checkPref("logichints", true);
        this.game.checkPref("backgroundpause", true);
        this.game.checkPref("buildautopause", false);
        this.game.checkPref("distinctcontrolgroups", true);
        this.game.checkPref("doubletapmine", false);
        this.game.checkPref("commandmodehold", true);
        if (!Vars.ios) {
            this.game.checkPref("modcrashdisable", true);
        }
        if (Vars.steam) {
            this.game.sliderPref("playerlimit", 16, 2, 32, i -> {
                Vars.platform.updateLobby();
                return i + "";
            });
            if (!Version.modifier.contains("beta")) {
                this.game.checkPref("steampublichost", false, i -> Vars.platform.updateLobby());
            }
        }
        this.game.checkPref("console", false);
        this.graphics.addCategory("arcCOverview");
        int[] lastUiScale = new int[]{Core.settings.getInt("uiscale", 100)};
        this.graphics.sliderPref("uiscale", 100, 25, 300, 5, s -> {
            Core.settings.put("uiscalechanged", (Object)(s != lastUiScale[0] ? 1 : 0));
            return s + "%";
        });
        this.graphics.sliderPref("screenshake", 4, 0, 8, i -> (float)i / 4.0f + "x");
        this.graphics.sliderPref("bloomintensity", 6, 0, 16, i -> (int)((float)i / 4.0f * 100.0f) + "%");
        this.graphics.sliderPref("bloomblur", 2, 1, 16, i -> i + "x");
        this.graphics.sliderPref("fpscap", 240, 10, 245, 5, s -> {
            if (Vars.ios) {
                Core.graphics.setPreferredFPS(s > 240 ? 0 : s);
            }
            return s > 240 ? Core.bundle.get("setting.fpscap.none") : Core.bundle.format("setting.fpscap.text", new Object[]{s});
        });
        if (Vars.ios) {
            int value = Core.settings.getInt("fpscap", 240);
            Core.graphics.setPreferredFPS(value > 240 ? 0 : value);
        }
        this.graphics.sliderPref("chatopacity", 100, 0, 100, 5, s -> s + "%");
        this.graphics.sliderPref("lasersopacity", 100, 0, 100, 5, s -> {
            if (Vars.ui.settings != null) {
                Core.settings.put("preferredlaseropacity", (Object)s);
            }
            return s + "%";
        });
        this.graphics.sliderPref("unitlaseropacity", 100, 0, 100, 5, s -> s + "%");
        this.graphics.sliderPref("bridgeopacity", 100, 0, 100, 5, s -> s + "%");
        this.graphics.sliderPref("maxmagnificationmultiplierpercent", 100, 100, 300, 25, s -> {
            if (Vars.ui.settings != null) {
                Core.settings.put("maxzoomingamemultiplier", (Object)Float.valueOf((float)s / 100.0f));
            }
            return s + "%";
        });
        this.graphics.sliderPref("minmagnificationmultiplierpercent", 100, 100, 800, 25, s -> {
            if (Vars.ui.settings != null) {
                Core.settings.put("minzoomingamemultiplier", (Object)Float.valueOf((float)s / 100.0f));
            }
            return s + "%";
        });
        if (!Vars.mobile) {
            this.graphics.checkPref("vsync", true, b -> Core.graphics.setVSync(b));
            this.graphics.checkPref("fullscreen", false, b -> {
                if (b && Core.settings.getBool("borderlesswindow")) {
                    Core.graphics.setWindowedMode(Core.graphics.getWidth(), Core.graphics.getHeight());
                    Core.settings.put("borderlesswindow", (Object)false);
                    this.graphics.rebuild();
                }
                if (b) {
                    Core.graphics.setFullscreen();
                } else {
                    Core.graphics.setWindowedMode(Core.graphics.getWidth(), Core.graphics.getHeight());
                }
            });
            this.graphics.checkPref("borderlesswindow", false, b -> {
                if (b && Core.settings.getBool("fullscreen")) {
                    Core.graphics.setWindowedMode(Core.graphics.getWidth(), Core.graphics.getHeight());
                    Core.settings.put("fullscreen", (Object)false);
                    this.graphics.rebuild();
                }
                Core.graphics.setBorderless(b);
            });
            Core.graphics.setVSync(Core.settings.getBool("vsync"));
            if (Core.settings.getBool("fullscreen")) {
                Core.app.post(() -> Core.graphics.setFullscreen());
            }
            if (Core.settings.getBool("borderlesswindow")) {
                Core.app.post(() -> Core.graphics.setBorderless(true));
            }
        } else if (!Vars.ios) {
            this.graphics.checkPref("landscape", false, b -> {
                if (b) {
                    Vars.platform.beginForceLandscape();
                } else {
                    Vars.platform.endForceLandscape();
                }
            });
            if (Core.settings.getBool("landscape")) {
                Vars.platform.beginForceLandscape();
            }
        }
        this.graphics.checkPref("effects", true);
        this.graphics.checkPref("atmosphere", !Vars.mobile);
        this.graphics.checkPref("drawlight", true);
        this.graphics.checkPref("destroyedblocks", true);
        this.graphics.checkPref("blockstatus", false);
        this.graphics.checkPref("playerchat", true);
        this.graphics.addCategory("arcCgamewindow");
        if (!Vars.mobile) {
            this.graphics.checkPref("coreitems", true);
        }
        this.graphics.checkPref("minimap", !Vars.mobile);
        this.graphics.checkPref("smoothcamera", true);
        if (!Vars.mobile) {
            this.graphics.checkPref("detach-camera", false);
        }
        this.graphics.checkPref("position", false);
        this.graphics.checkPref("mouseposition", false);
        this.graphics.checkPref("fps", false);
        this.graphics.checkPref("playerindicators", true);
        this.graphics.checkPref("indicators", true);
        this.graphics.addCategory("arcCGraphicsOther");
        this.graphics.checkPref("showweather", true);
        this.graphics.checkPref("animatedwater", true);
        if (Shaders.shield != null) {
            this.graphics.checkPref("animatedshields", !Vars.android);
        }
        this.graphics.checkPref("bloom", true, val -> Vars.renderer.toggleBloom(val));
        this.graphics.checkPref("pixelate", false, val -> {
            if (val) {
                Events.fire((Enum)EventType.Trigger.enablePixelation);
            }
        });
        this.graphics.checkPref("linear", !Vars.mobile, b -> {
            for (Texture tex : Core.atlas.getTextures()) {
                Texture.TextureFilter filter = b ? Texture.TextureFilter.linear : Texture.TextureFilter.nearest;
                tex.setFilter(filter, filter);
            }
        });
        if (Core.settings.getBool("linear")) {
            for (Texture tex : Core.atlas.getTextures()) {
                Texture.TextureFilter filter = Texture.TextureFilter.linear;
                tex.setFilter(filter, filter);
            }
        }
        this.graphics.checkPref("skipcoreanimation", false);
        this.graphics.checkPref("hidedisplays", false);
        if (OS.isMac) {
            this.graphics.checkPref("macnotch", false);
        }
        if (!Vars.mobile) {
            Core.settings.put("swapdiagonal", (Object)false);
        }
    }

    public void exportData(Fi file) throws IOException {
        Seq files = new Seq();
        files.add((Object)Core.settings.getSettingsFile());
        files.addAll((Object[])Vars.customMapDirectory.list());
        files.addAll((Object[])Vars.saveDirectory.list());
        files.addAll((Object[])Vars.modDirectory.list());
        files.addAll((Object[])Vars.schematicDirectory.list());
        String base = Core.settings.getDataDirectory().path();
        for (Fi other : files.copy()) {
            Fi parent = other.parent();
            while (!files.contains((Object)parent) && !parent.equals((Object)Core.settings.getDataDirectory())) {
                files.add((Object)parent);
            }
        }
        try (OutputStream fos = file.write(false, 2048);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (Fi add : files) {
                String path = add.path().substring(base.length());
                if (add.isDirectory()) {
                    path = path + "/";
                }
                path = path.startsWith("/") ? path.substring(1) : path;
                zos.putNextEntry(new ZipEntry(path));
                if (!add.isDirectory()) {
                    try (InputStream stream = add.read();){
                        Streams.copy((InputStream)stream, (OutputStream)zos);
                    }
                }
                zos.closeEntry();
            }
        }
    }

    public void importData(Fi file) {
        Fi dest = Core.files.local("zipdata.zip");
        file.copyTo(dest);
        ZipFi zipped = new ZipFi(dest);
        Fi base = Core.settings.getDataDirectory();
        if (!zipped.child("settings.bin").exists()) {
            throw new IllegalArgumentException("Not valid save data.");
        }
        Vars.saveDirectory.deleteDirectory();
        Vars.tmpDirectory.deleteDirectory();
        zipped.walk(f -> f.copyTo(base.child(f.path())));
        dest.delete();
        Core.settings.clear();
        Core.settings.load();
    }

    private void back() {
        this.rebuildMenu();
        this.prefs.clearChildren();
        this.prefs.add((Element)this.menu);
    }

    private void visible(int index) {
        this.prefs.clearChildren();
        Seq tables = new Seq();
        tables.addAll((Object[])new SettingsTable[]{this.game, this.graphics, this.sound});
        for (SettingsCategory custom : this.categories) {
            tables.add((Object)custom.table);
        }
        this.prefs.add((Element)((SettingsTable)((Object)tables.get(index))).build());
    }

    public void addCloseButton() {
        this.buttons.button("@back", (Drawable)Icon.left, () -> {
            if (this.prefs.getChildren().first() != this.menu) {
                this.back();
            } else {
                this.hide();
            }
        }).size(210.0f, 64.0f);
        this.keyDown(key -> {
            if (key == KeyCode.escape || key == KeyCode.back) {
                if (this.prefs.getChildren().first() != this.menu) {
                    this.back();
                } else {
                    this.hide();
                }
            }
        });
    }

    public static class SettingsTable
    extends Table {
        protected Seq<Setting> list = new Seq();
        private int lastSize;

        @Deprecated
        public SettingsTable() {
            this.left();
        }

        public void act(float delta) {
            if (this.lastSize != this.list.size) {
                this.build();
            }
            super.act(delta);
        }

        public Seq<Setting> getSettings() {
            return this.list;
        }

        public void pref(Setting setting) {
            this.list.add((Object)setting);
        }

        public SliderSetting sliderPref(String name, int def, int min, int max, StringProcessor s) {
            return this.sliderPref(name, def, min, max, 1, s);
        }

        public SliderSetting sliderPref(String name, int def, int min, int max, int step, StringProcessor s) {
            SliderSetting res = new SliderSetting(name, def, min, max, step, s);
            this.list.add((Object)res);
            Core.settings.defaults(new Object[]{name, def});
            return res;
        }

        public void checkPref(String name, boolean def) {
            this.list.add((Object)new CheckSetting(name, def, null));
            Core.settings.defaults(new Object[]{name, def});
        }

        public void checkPref(String name, boolean def, Boolc changed) {
            this.list.add((Object)new CheckSetting(name, def, changed));
            Core.settings.defaults(new Object[]{name, def});
        }

        public void addCategory(String name) {
            this.list.add((Object)new Divider(name, Core.bundle.get("category." + name + ".name")));
        }

        public void textPref(String name, String def) {
            this.list.add((Object)new TextSetting(name, def, null));
            Core.settings.defaults(new Object[]{name, def});
        }

        public void textPref(String name, String def, Cons<String> changed) {
            this.list.add((Object)new TextSetting(name, def, changed));
            Core.settings.defaults(new Object[]{name, def});
        }

        public void areaTextPref(String name, String def) {
            this.list.add((Object)new AreaTextSetting(name, def, null));
            Core.settings.defaults(new Object[]{name, def});
        }

        public void areaTextPref(String name, String def, Cons<String> changed) {
            this.list.add((Object)new AreaTextSetting(name, def, changed));
            Core.settings.defaults(new Object[]{name, def});
        }

        public void reset() {
            this.clearChildren();
            this.list.clear();
        }

        public void rebuild() {
            this.build();
        }

        public Table build() {
            if (this.list.size == this.lastSize) {
                return this;
            }
            this.lastSize = this.list.size;
            this.clearChildren();
            for (Setting setting : this.list) {
                setting.add(this);
            }
            this.button(Core.bundle.get("settings.reset", "Reset to Defaults"), () -> {
                for (Setting setting : this.list) {
                    if (setting.name == null || setting.title == null) continue;
                    Core.settings.remove(setting.name);
                }
                this.rebuild();
            }).margin(14.0f).width(240.0f).pad(6.0f);
            return this;
        }

        public static class SliderSetting
        extends Setting {
            int def;
            int min;
            int max;
            int step;
            StringProcessor sp;

            public SliderSetting(String name, int def, int min, int max, int step, StringProcessor s) {
                super(name);
                this.def = def;
                this.min = min;
                this.max = max;
                this.step = step;
                this.sp = s;
            }

            @Override
            public void add(SettingsTable table2) {
                Slider slider = new Slider((float)this.min, (float)this.max, (float)this.step, false);
                slider.setValue((float)Core.settings.getInt(this.name));
                Label value = new Label((CharSequence)"", Styles.outlineLabel);
                Table content = new Table();
                content.add((CharSequence)this.title, Styles.outlineLabel).left().growX().wrap();
                content.add((Element)value).padLeft(10.0f).right();
                content.margin(3.0f, 33.0f, 3.0f, 33.0f);
                content.touchable = Touchable.disabled;
                slider.changed(() -> {
                    Core.settings.put(this.name, (Object)((int)slider.getValue()));
                    value.setText((CharSequence)this.sp.get((int)slider.getValue()));
                });
                slider.change();
                this.addDesc(table2.stack(new Element[]{slider, content}).width(Math.min((float)Core.graphics.getWidth() / 1.2f, 460.0f)).left().padTop(4.0f).get());
                table2.row();
            }
        }

        public static class CheckSetting
        extends Setting {
            boolean def;
            Boolc changed;

            public CheckSetting(String name, boolean def, Boolc changed) {
                super(name);
                this.def = def;
                this.changed = changed;
            }

            @Override
            public void add(SettingsTable table2) {
                CheckBox box = new CheckBox(this.title);
                box.update(() -> box.setChecked(Core.settings.getBool(this.name)));
                box.changed(() -> {
                    Core.settings.put(this.name, (Object)box.isChecked());
                    if (this.changed != null) {
                        this.changed.get(box.isChecked());
                    }
                });
                box.left();
                this.addDesc(table2.add((Element)box).left().padTop(3.0f).get());
                table2.row();
            }
        }

        public static class Divider
        extends Setting {
            Divider(String name, String title) {
                super(name);
                this.title = title;
            }

            @Override
            public void add(SettingsTable table2) {
                table2.add(this.title).color(Pal.accent).colspan(4).pad(10.0f).padTop(15.0f).padBottom(4.0f).row();
                table2.image().color(Pal.accent).fillX().height(3.0f).colspan(4).padTop(0.0f).padBottom(10.0f).row();
            }
        }

        public static class TextSetting
        extends Setting {
            String def;
            Cons<String> changed;

            public TextSetting(String name, String def, Cons<String> changed) {
                super(name);
                this.def = def;
                this.changed = changed;
            }

            @Override
            public void add(SettingsTable table2) {
                TextField field = new TextField();
                field.update(() -> field.setText(Core.settings.getString(this.name)));
                field.changed(() -> {
                    Core.settings.put(this.name, (Object)field.getText());
                    if (this.changed != null) {
                        this.changed.get((Object)field.getText());
                    }
                });
                Table prefTable = (Table)table2.table().left().padTop(3.0f).fillX().get();
                prefTable.label(() -> this.title).padRight(8.0f);
                prefTable.add((Element)field).growX();
                this.addDesc((Element)prefTable);
                table2.row();
            }
        }

        public static class AreaTextSetting
        extends TextSetting {
            public AreaTextSetting(String name, String def, Cons<String> changed) {
                super(name, def, changed);
            }

            @Override
            public void add(SettingsTable table2) {
                TextArea area = new TextArea("");
                area.setPrefRows(5.0f);
                area.update(() -> {
                    area.setText(Core.settings.getString(this.name));
                    area.setWidth(table2.getWidth());
                });
                area.changed(() -> {
                    Core.settings.put(this.name, (Object)area.getText());
                    if (this.changed != null) {
                        this.changed.get((Object)area.getText());
                    }
                });
                this.addDesc(table2.label(() -> this.title).left().padTop(3.0f).get());
                table2.row().add((Element)area).left();
                table2.row();
            }
        }

        public static abstract class Setting {
            public String name;
            public String title;
            @Nullable
            public String description;

            public Setting(String name) {
                this.name = name;
                String winkey = "setting." + name + ".name.windows";
                this.title = OS.isWindows && Core.bundle.has(winkey) ? Core.bundle.get(winkey) : Core.bundle.get("setting." + name + ".name", name);
                this.description = Core.bundle.getOrNull("setting." + name + ".description");
            }

            public abstract void add(SettingsTable var1);

            public void addDesc(Element elem) {
                Vars.ui.addDescTooltip(elem, this.description);
            }
        }
    }

    public static class SettingsCategory {
        public String name;
        @Nullable
        public Drawable icon;
        public Cons<SettingsTable> builder;
        public SettingsTable table;

        public SettingsCategory(String name, Drawable icon, Cons<SettingsTable> builder) {
            this.name = name;
            this.icon = icon;
            this.builder = builder;
            this.table = new SettingsTable();
            builder.get((Object)this.table);
        }

        public void rebuild() {
            this.table.reset();
            this.builder.get((Object)this.table);
            this.table.rebuild();
        }
    }
}

