/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.input.KeyCode;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.actions.RelativeTemporalAction;
import arc.scene.event.ElementGestureListener;
import arc.scene.event.EventListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ImageButton;
import arc.scene.ui.Label;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Structs;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.content.Planets;
import mindustry.content.TechTree;
import mindustry.core.UI;
import mindustry.game.EventType;
import mindustry.game.Objectives;
import mindustry.gen.Icon;
import mindustry.gen.Sounds;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.ui.Fonts;
import mindustry.ui.ItemsDisplay;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.layout.BranchTreeLayout;
import mindustry.ui.layout.TreeLayout;
import mindustryX.features.RenderExt;

public class ResearchDialog
extends BaseDialog {
    public static boolean debugShowRequirements = false;
    public final float nodeSize = Scl.scl((float)60.0f);
    public ObjectSet<TechTreeNode> nodes = new ObjectSet();
    public TechTreeNode root = new TechTreeNode((TechTree.TechNode)TechTree.roots.first(), null);
    public TechTree.TechNode lastNode;
    public Rect bounds;
    public ItemsDisplay itemDisplay;
    public View view;
    public ItemSeq items;
    private final Seq<Planet> rootPlanets;
    private boolean showTechSelect;
    private boolean needsRebuild;

    public ResearchDialog() {
        super("");
        this.lastNode = this.root.node;
        this.bounds = new Rect();
        this.rootPlanets = new Seq(false, 4);
        Events.on(EventType.ResetEvent.class, e -> this.hide());
        Events.on(EventType.UnlockEvent.class, e -> {
            if (Vars.net.client() && !this.needsRebuild) {
                this.needsRebuild = true;
                Core.app.post(() -> {
                    this.needsRebuild = false;
                    this.checkNodes(this.root);
                    this.view.hoverNode = null;
                    this.treeLayout();
                    this.view.rebuild();
                    Core.scene.act();
                });
            }
        });
        this.titleTable.remove();
        this.titleTable.clear();
        this.titleTable.top();
        this.titleTable.button(b -> {
            b.imageDraw(() -> this.root.node.icon()).padRight(8.0f).size(32.0f);
            b.add().growX();
            b.label(() -> this.root.node.localizedName()).color(Pal.accent);
            b.add().growX();
            b.add().size(32.0f);
        }, () -> new BaseDialog("@techtree.select"){
            {
                this.cont.pane(t -> t.table(Tex.button, in -> {
                    in.defaults().width(300.0f).height(60.0f);
                    for (TechTree.TechNode node : TechTree.roots) {
                        if (node.requiresUnlock && !node.content.unlockedHost() && node != ResearchDialog.this.getPrefRoot()) continue;
                        in.button(node.localizedName(), node.icon(), Styles.flatTogglet, 32.0f, () -> {
                            if (node == ResearchDialog.this.lastNode) {
                                return;
                            }
                            ResearchDialog.this.rebuildTree(node);
                            this.hide();
                        }).marginLeft(12.0f).checked(node == ResearchDialog.this.lastNode).row();
                    }
                }));
                this.addCloseButton();
            }
        }.show()).visible(() -> {
            this.showTechSelect = TechTree.roots.count(node -> !node.requiresUnlock || node.content.unlockedHost()) > 1;
            return this.showTechSelect;
        }).minWidth(300.0f);
        this.margin(0.0f).marginBottom(8.0f);
        Element[] elementArray = new Element[3];
        elementArray[0] = this.titleTable;
        this.view = new View();
        elementArray[1] = this.view;
        this.itemDisplay = new ItemsDisplay();
        elementArray[2] = this.itemDisplay;
        this.cont.stack(elementArray).grow();
        this.itemDisplay.visible(() -> !Vars.net.client());
        this.titleTable.toFront();
        this.shouldPause = true;
        this.onResize(this::checkMargin);
        this.shown(() -> {
            Planet currPlanet;
            this.checkMargin();
            Core.app.post(this::checkMargin);
            Object object = Vars.ui.planet.isShown() ? Vars.ui.planet.state.planet : (currPlanet = Vars.state.isCampaign() ? Vars.state.rules.sector.planet : null);
            if (currPlanet != null && currPlanet.techTree != null) {
                this.switchTree(currPlanet.techTree);
            }
            this.rebuildItems();
            this.checkNodes(this.root);
            this.treeLayout();
            this.view.hoverNode = null;
            this.view.infoTable.remove();
            this.view.infoTable.clear();
        });
        this.hidden(Vars.ui.planet::setup);
        this.addCloseButton();
        this.keyDown(key -> {
            if (key == Binding.research.value.key) {
                Core.app.post(() -> ((ResearchDialog)this).hide());
            }
        });
        this.buttons.button("@database", (Drawable)Icon.book, () -> {
            this.hide();
            Vars.ui.database.show();
        }).size(210.0f, 64.0f).name("database");
        this.addListener((EventListener)new InputListener(){

            public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
                ResearchDialog.this.view.setScale(Mathf.clamp((float)(ResearchDialog.this.view.scaleX - amountY / 10.0f * ResearchDialog.this.view.scaleX), (float)0.25f, (float)1.0f));
                ResearchDialog.this.view.setOrigin(1);
                ResearchDialog.this.view.setTransform(true);
                return true;
            }

            public boolean mouseMoved(InputEvent event, float x, float y) {
                ResearchDialog.this.view.requestScroll();
                return super.mouseMoved(event, x, y);
            }
        });
        this.touchable = Touchable.enabled;
        this.addCaptureListener((EventListener)new ElementGestureListener(){

            public void zoom(InputEvent event, float initialDistance, float distance) {
                if (ResearchDialog.this.view.lastZoom < 0.0f) {
                    ResearchDialog.this.view.lastZoom = ResearchDialog.this.view.scaleX;
                }
                ResearchDialog.this.view.setScale(Mathf.clamp((float)(distance / initialDistance * ResearchDialog.this.view.lastZoom), (float)0.25f, (float)1.0f));
                ResearchDialog.this.view.setOrigin(1);
                ResearchDialog.this.view.setTransform(true);
            }

            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button2) {
                ResearchDialog.this.view.lastZoom = ResearchDialog.this.view.scaleX;
            }

            public void pan(InputEvent event, float x, float y, float deltaX, float deltaY) {
                ResearchDialog.this.view.panX += deltaX / ResearchDialog.this.view.scaleX;
                ResearchDialog.this.view.panY += deltaY / ResearchDialog.this.view.scaleY;
                ResearchDialog.this.view.moved = true;
                ResearchDialog.this.view.clamp();
            }
        });
    }

    void checkMargin() {
        if (Core.graphics.isPortrait() && this.showTechSelect) {
            this.itemDisplay.marginTop(60.0f);
        } else {
            this.itemDisplay.marginTop(0.0f);
        }
        this.itemDisplay.invalidate();
        this.itemDisplay.layout();
    }

    public void rebuildItems() {
        this.items = new ItemSeq(){
            ObjectMap<Sector, ItemSeq> cache = new ObjectMap();
            {
                ResearchDialog.this.rootPlanets.clear();
                for (Planet planet : Vars.content.planets()) {
                    if (planet.techTree != ResearchDialog.this.lastNode && ResearchDialog.this.lastNode.planet != planet) continue;
                    ResearchDialog.this.rootPlanets.add((Object)planet);
                }
                if (((ResearchDialog)ResearchDialog.this).rootPlanets.size == 0) {
                    ResearchDialog.this.rootPlanets.add((Object)Planets.serpulo);
                }
                for (Planet planet : ResearchDialog.this.rootPlanets) {
                    for (Sector sector : planet.sectors) {
                        if (!sector.hasBase() || sector.isFrozen()) continue;
                        ItemSeq cached = sector.items();
                        this.cache.put((Object)sector, (Object)cached);
                        cached.each((item, amount) -> {
                            short s = item.id;
                            this.values[s] = this.values[s] + Math.max(amount, 0);
                            this.total += Math.max(amount, 0);
                        });
                    }
                }
            }

            public void add(Item item, int amount) {
                if (amount < 0) {
                    amount = -amount;
                    double percentage = (double)amount / (double)this.get(item);
                    int[] counter = new int[]{amount};
                    this.cache.each((sector, seq) -> {
                        if (counter[0] == 0) {
                            return;
                        }
                        int toRemove = Math.min((int)Math.ceil(percentage * (double)seq.get(item)), counter[0]);
                        sector.removeItem(item, toRemove);
                        seq.remove(item, toRemove);
                        counter[0] = counter[0] - toRemove;
                    });
                    amount = -amount;
                }
                super.add(item, amount);
            }
        };
        this.itemDisplay.rebuild(this.items);
    }

    @Nullable
    public TechTree.TechNode getPrefRoot() {
        Planet currPlanet = Vars.ui.planet.isShown() ? Vars.ui.planet.state.planet : (Vars.state.isCampaign() ? Vars.state.rules.sector.planet : null);
        return currPlanet == null ? null : currPlanet.techTree;
    }

    public void switchTree(TechTree.TechNode node) {
        if (this.lastNode == node || node == null) {
            return;
        }
        this.nodes.clear();
        this.root = new TechTreeNode(node, null);
        this.lastNode = node;
        this.view.rebuildAll();
        this.rebuildItems();
    }

    public void rebuildTree(TechTree.TechNode node) {
        this.switchTree(node);
        this.view.panX = 0.0f;
        this.view.panY = -200.0f;
        this.view.setScale(1.0f);
        this.view.hoverNode = null;
        this.view.infoTable.remove();
        this.view.infoTable.clear();
        this.checkNodes(this.root);
        this.treeLayout();
    }

    void treeLayout() {
        final float spacing = 20.0f;
        LayoutNode node = new LayoutNode(this.root, null);
        LayoutNode[] children = (LayoutNode[])node.children;
        LayoutNode[] leftHalf = Arrays.copyOfRange((LayoutNode[])node.children, 0, Mathf.ceil((float)((float)((LayoutNode[])node.children).length / 2.0f)));
        LayoutNode[] rightHalf = Arrays.copyOfRange((LayoutNode[])node.children, Mathf.ceil((float)((float)((LayoutNode[])node.children).length / 2.0f)), ((LayoutNode[])node.children).length);
        node.children = leftHalf;
        new BranchTreeLayout(){
            {
                this.gapBetweenLevels = this.gapBetweenNodes = spacing;
                this.rootLocation = BranchTreeLayout.TreeLocation.top;
            }
        }.layout((TreeLayout.TreeNode)node);
        float lastY = node.y;
        if (rightHalf.length > 0) {
            node.children = rightHalf;
            new BranchTreeLayout(){
                {
                    this.gapBetweenLevels = this.gapBetweenNodes = spacing;
                    this.rootLocation = BranchTreeLayout.TreeLocation.bottom;
                }
            }.layout((TreeLayout.TreeNode)node);
            this.shift(leftHalf, node.y - lastY);
        }
        node.children = children;
        float minx = 0.0f;
        float miny = 0.0f;
        float maxx = 0.0f;
        float maxy = 0.0f;
        this.copyInfo(node);
        for (TechTreeNode n : this.nodes) {
            if (!n.visible) continue;
            minx = Math.min(n.x - n.width / 2.0f, minx);
            maxx = Math.max(n.x + n.width / 2.0f, maxx);
            miny = Math.min(n.y - n.height / 2.0f, miny);
            maxy = Math.max(n.y + n.height / 2.0f, maxy);
        }
        this.bounds = new Rect(minx, miny, maxx - minx, maxy - miny);
        this.bounds.y += this.nodeSize * 1.5f;
    }

    void shift(LayoutNode[] children, float amount) {
        for (LayoutNode node : children) {
            node.y += amount;
            if (node.children == null || ((LayoutNode[])node.children).length <= 0) continue;
            this.shift((LayoutNode[])node.children, amount);
        }
    }

    void copyInfo(LayoutNode node) {
        node.node.x = node.x;
        node.node.y = node.y;
        if (node.children != null) {
            for (LayoutNode child : (LayoutNode[])node.children) {
                this.copyInfo(child);
            }
        }
    }

    void checkNodes(TechTreeNode node) {
        boolean locked;
        boolean bl = locked = !RenderExt.researchViewer && this.locked(node.node);
        if (!locked && (node.parent == null || ((TechTreeNode)node.parent).visible)) {
            node.visible = true;
        }
        node.selectable = this.selectable(node.node);
        for (TechTreeNode l : (TechTreeNode[])node.children) {
            l.visible = !locked && ((TechTreeNode)l.parent).visible;
            this.checkNodes(l);
        }
        this.itemDisplay.rebuild(this.items);
    }

    boolean selectable(TechTree.TechNode node) {
        if (node.content.unlockedHost()) {
            return true;
        }
        if (RenderExt.researchViewer && this.locked(node.parent)) {
            return false;
        }
        return node.content.unlockedHost() || !node.objectives.contains(i -> !i.complete());
    }

    boolean locked(TechTree.TechNode node) {
        return !node.content.unlockedHost();
    }

    public class TechTreeNode
    extends TreeLayout.TreeNode<TechTreeNode> {
        public final TechTree.TechNode node;
        public boolean visible = true;
        public boolean selectable = true;

        public TechTreeNode(TechTree.TechNode node, TechTreeNode parent) {
            this.node = node;
            this.parent = parent;
            this.width = this.height = ResearchDialog.this.nodeSize;
            ResearchDialog.this.nodes.add((Object)this);
            this.children = new TechTreeNode[node.children.size];
            for (int i = 0; i < ((TechTreeNode[])this.children).length; ++i) {
                ((TechTreeNode[])this.children)[i] = new TechTreeNode((TechTree.TechNode)node.children.get(i), this);
            }
        }
    }

    public class View
    extends Group {
        public float panX = 0.0f;
        public float panY = -200.0f;
        public float lastZoom = -1.0f;
        public boolean moved = false;
        public ImageButton hoverNode;
        public Table infoTable = new Table();

        public View() {
            this.rebuildAll();
        }

        public void rebuildAll() {
            this.clear();
            this.hoverNode = null;
            this.infoTable.clear();
            this.infoTable.touchable = Touchable.enabled;
            for (TechTreeNode node : ResearchDialog.this.nodes) {
                ImageButton button2 = new ImageButton(node.node.content.uiIcon, Styles.nodei);
                button2.resizeImage(32.0f);
                button2.getImage().setScaling(Scaling.fit);
                button2.visible(() -> node.visible);
                if (!Vars.net.client()) {
                    button2.clicked(() -> {
                        if (this.moved) {
                            return;
                        }
                        if (Vars.mobile) {
                            this.hoverNode = button2;
                            this.rebuild();
                            float right = this.infoTable.getRight();
                            if (right > (float)Core.graphics.getWidth()) {
                                final float moveBy = right - (float)Core.graphics.getWidth();
                                this.addAction((Action)new RelativeTemporalAction(){
                                    {
                                        this.setDuration(0.1f);
                                        this.setInterpolation(Interp.fade);
                                    }

                                    protected void updateRelative(float percentDelta) {
                                        View.this.panX -= moveBy * percentDelta;
                                    }
                                });
                            }
                        } else if (this.canSpend(node.node) && ResearchDialog.this.locked(node.node)) {
                            this.spend(node.node);
                        }
                    });
                }
                button2.hovered(() -> {
                    if (!Vars.mobile && this.hoverNode != button2 && node.visible) {
                        this.hoverNode = button2;
                        this.rebuild();
                    }
                });
                button2.exited(() -> {
                    if (!(Vars.mobile || this.hoverNode != button2 || this.infoTable.hasMouse() || this.hoverNode.hasMouse())) {
                        this.hoverNode = null;
                        this.rebuild();
                    }
                });
                button2.touchable(() -> !node.visible ? Touchable.disabled : Touchable.enabled);
                button2.userObject = node.node;
                button2.setSize(ResearchDialog.this.nodeSize);
                button2.update(() -> {
                    button2.setDisabled(Vars.net.client() && !Vars.mobile);
                    float offset = (float)(Core.graphics.getHeight() % 2) / 2.0f;
                    button2.setPosition(node.x + this.panX + this.width / 2.0f, node.y + this.panY + this.height / 2.0f + offset, 1);
                    button2.getStyle().up = !ResearchDialog.this.locked(node.node) ? Tex.buttonOver : (!ResearchDialog.this.selectable(node.node) || !this.canSpend(node.node) && !Vars.net.client() ? Tex.buttonRed : Tex.button);
                    ((TextureRegionDrawable)button2.getStyle().imageUp).setRegion(node.selectable || RenderExt.researchViewer ? node.node.content.uiIcon : Icon.lock.getRegion());
                    button2.getImage().setColor(!ResearchDialog.this.locked(node.node) ? Color.white : (node.selectable ? Color.gray : Pal.gray));
                    button2.getImage().layout();
                });
                this.addChild((Element)button2);
            }
            if (Vars.mobile) {
                this.addListener((EventListener)new InputListener(){

                    public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button2) {
                        if (pointer == -1) {
                            return false;
                        }
                        Element e = Core.scene.hit((float)Core.input.mouseX(pointer), (float)Core.input.mouseY(pointer), true);
                        if (e == View.this) {
                            View.this.hoverNode = null;
                            View.this.rebuild();
                        }
                        return false;
                    }
                });
            }
            this.setOrigin(1);
            this.setTransform(true);
            this.released(() -> {
                this.moved = false;
            });
        }

        void clamp() {
            float pad = ResearchDialog.this.nodeSize;
            float ox = this.width / 2.0f;
            float oy = this.height / 2.0f;
            float rx = ResearchDialog.this.bounds.x + this.panX + ox;
            float ry = this.panY + oy + ResearchDialog.this.bounds.y;
            float rw = ResearchDialog.this.bounds.width;
            float rh = ResearchDialog.this.bounds.height;
            rx = Mathf.clamp((float)rx, (float)(-rw + pad), (float)((float)Core.graphics.getWidth() - pad));
            ry = Mathf.clamp((float)ry, (float)(-rh + pad), (float)((float)Core.graphics.getHeight() - pad));
            this.panX = rx - ResearchDialog.this.bounds.x - ox;
            this.panY = ry - ResearchDialog.this.bounds.y - oy;
        }

        boolean canSpend(TechTree.TechNode node) {
            if (!ResearchDialog.this.selectable(node) || Vars.net.client()) {
                return false;
            }
            if (node.requirements.length == 0) {
                return true;
            }
            for (int i = 0; i < node.requirements.length; ++i) {
                if (node.finishedRequirements[i].amount >= node.requirements[i].amount || !ResearchDialog.this.items.has(node.requirements[i].item)) continue;
                return true;
            }
            return node.content.locked();
        }

        void spend(TechTree.TechNode node) {
            if (Vars.net.client()) {
                return;
            }
            boolean complete = true;
            boolean[] shine = new boolean[node.requirements.length];
            boolean[] usedShine = new boolean[Vars.content.items().size];
            for (int i = 0; i < node.requirements.length; ++i) {
                ItemStack req = node.requirements[i];
                ItemStack completed = node.finishedRequirements[i];
                int used = Math.max(Math.min(req.amount - completed.amount, ResearchDialog.this.items.get(req.item)), 0);
                ResearchDialog.this.items.remove(req.item, used);
                completed.amount += used;
                if (used > 0) {
                    shine[i] = true;
                    usedShine[req.item.id] = true;
                }
                if (completed.amount >= req.amount) continue;
                complete = false;
            }
            if (complete) {
                this.unlock(node);
            }
            node.save();
            Core.scene.act();
            this.rebuild(shine);
            ResearchDialog.this.itemDisplay.rebuild(ResearchDialog.this.items, usedShine);
            ResearchDialog.this.checkMargin();
        }

        void unlock(TechTree.TechNode node) {
            node.content.unlock();
            TechTree.TechNode parent = node.parent;
            while (parent != null) {
                parent.content.unlock();
                parent = parent.parent;
            }
            ResearchDialog.this.checkNodes(ResearchDialog.this.root);
            this.hoverNode = null;
            ResearchDialog.this.treeLayout();
            this.rebuild();
            Core.scene.act();
            Sounds.uiUnlock.play();
            Events.fire((Object)new EventType.ResearchEvent(node.content));
        }

        void rebuild() {
            this.rebuild(null);
        }

        void rebuild(@Nullable boolean[] shine) {
            final ImageButton button2 = this.hoverNode;
            this.infoTable.remove();
            this.infoTable.clear();
            this.infoTable.update(null);
            this.infoTable.touchable = Touchable.enabled;
            if (button2 == null) {
                return;
            }
            TechTree.TechNode node = (TechTree.TechNode)button2.userObject;
            this.infoTable.addListener((EventListener)new InputListener(){

                public void exit(InputEvent event, float x, float y, int pointer, Element fromActor) {
                    Element e = Core.scene.hit((float)Core.input.mouseX(pointer == -1 ? 0 : pointer), (float)Core.input.mouseY(pointer == -1 ? 0 : pointer), true);
                    if (!(View.this.hoverNode != button2 || e != null && (e == View.this.infoTable || e.isDescendantOf((Element)View.this.infoTable) || e == View.this.hoverNode || e.isDescendantOf((Element)View.this.hoverNode)) || !Core.app.isDesktop() && pointer != 0)) {
                        View.this.hoverNode = null;
                        View.this.rebuild();
                    }
                }
            });
            this.infoTable.update(() -> this.infoTable.setPosition(button2.x + button2.getWidth(), button2.y + button2.getHeight(), 10));
            this.infoTable.left();
            this.infoTable.background(Tex.button).margin(8.0f);
            boolean selectable = ResearchDialog.this.selectable(node);
            this.infoTable.table(b -> {
                b.margin(0.0f).left().defaults().left();
                if (selectable || RenderExt.researchViewer) {
                    b.button((Drawable)Icon.info, Styles.flati, () -> Vars.ui.content.show(node.content)).growY().width(50.0f);
                }
                b.add().grow();
                b.table(desc -> {
                    desc.left().defaults().left();
                    desc.add((CharSequence)(selectable ? node.content.localizedName : (RenderExt.researchViewer ? node.content.localizedName + "\n[red]\u672a\u6ee1\u8db3\u524d\u7f6e\u79d1\u6280" : "[accent]???")));
                    desc.row();
                    if (ResearchDialog.this.locked(node) || debugShowRequirements && !Vars.net.client()) {
                        if (Vars.net.client()) {
                            desc.add((CharSequence)"@locked").color(Pal.remove);
                        } else {
                            desc.table(t -> {
                                t.left();
                                if (selectable) {
                                    if (Structs.contains((Object[])node.finishedRequirements, s -> s.amount > 0)) {
                                        float sum = 0.0f;
                                        float used = 0.0f;
                                        boolean shiny = false;
                                        for (int i = 0; i < node.requirements.length; ++i) {
                                            sum += node.requirements[i].item.cost * (float)node.requirements[i].amount;
                                            used += node.finishedRequirements[i].item.cost * (float)node.finishedRequirements[i].amount;
                                            if (shine == null) continue;
                                            shiny |= shine[i];
                                        }
                                        Label label = (Label)t.add((CharSequence)Core.bundle.format("research.progress", new Object[]{Math.min((int)(used / sum * 100.0f), 99)})).left().get();
                                        if (shiny) {
                                            label.setColor(Pal.accent);
                                            label.actions(new Action[]{Actions.color((Color)Color.lightGray, (float)0.75f, (Interp)Interp.fade)});
                                        } else {
                                            label.setColor(Color.lightGray);
                                        }
                                        t.row();
                                    }
                                    for (int i = 0; i < node.requirements.length; ++i) {
                                        ItemStack req = node.requirements[i];
                                        ItemStack completed = node.finishedRequirements[i];
                                        if (req.amount <= completed.amount && !debugShowRequirements) continue;
                                        boolean shiny = shine != null && shine[i];
                                        t.table(list -> {
                                            Color targetColor;
                                            int reqAmount = debugShowRequirements ? req.amount : req.amount - completed.amount;
                                            list.left();
                                            list.image(req.item.uiIcon).size(24.0f).padRight(3.0f);
                                            list.add((CharSequence)req.item.localizedName).color(Color.lightGray);
                                            Label label = (Label)list.label(() -> " " + UI.formatAmount(Math.min(ResearchDialog.this.items.get(req.item), reqAmount)) + " / " + UI.formatAmount(reqAmount)).get();
                                            Color color = targetColor = ResearchDialog.this.items.has(req.item) ? Color.lightGray : Color.scarlet;
                                            if (shiny) {
                                                label.setColor(Pal.accent);
                                                label.actions(new Action[]{Actions.color((Color)targetColor, (float)0.75f, (Interp)Interp.fade)});
                                            } else {
                                                label.setColor(targetColor);
                                            }
                                        }).fillX().left();
                                        t.row();
                                    }
                                } else if (node.objectives.size > 0) {
                                    t.table(r -> {
                                        r.add((CharSequence)"@complete").colspan(2).left();
                                        r.row();
                                        for (Objectives.Objective o : node.objectives) {
                                            if (o.complete()) continue;
                                            r.add((CharSequence)("> " + o.display())).color(Color.lightGray).left();
                                            r.image((Drawable)(o.complete() ? Icon.ok : Icon.cancel), o.complete() ? Color.lightGray : Color.scarlet).padLeft(3.0f);
                                            r.row();
                                        }
                                    });
                                    t.row();
                                }
                            });
                        }
                    } else {
                        desc.add((CharSequence)"@completed");
                    }
                }).pad(9.0f);
                if (Vars.mobile && ResearchDialog.this.locked(node) && !Vars.net.client()) {
                    b.row();
                    b.button("@research", (Drawable)Icon.ok, new TextButton.TextButtonStyle(){
                        {
                            this.disabled = Tex.button;
                            this.font = Fonts.def;
                            this.fontColor = Color.white;
                            this.disabledFontColor = Color.gray;
                            this.up = Tex.buttonOver;
                            this.over = Tex.buttonDown;
                        }
                    }, () -> this.spend(node)).disabled(i -> !this.canSpend(node)).growX().height(44.0f).colspan(3);
                }
            });
            this.infoTable.row();
            if (node.content.description != null && node.content.inlineDescription && selectable) {
                this.infoTable.table(t -> t.margin(3.0f).left().labelWrap(node.content.displayDescription()).color(Color.lightGray).growX()).fillX();
            }
            this.addChild((Element)this.infoTable);
            ResearchDialog.this.checkMargin();
            Core.app.post(() -> ResearchDialog.this.checkMargin());
            this.infoTable.pack();
            this.infoTable.act(Core.graphics.getDeltaTime());
        }

        public void drawChildren() {
            this.clamp();
            float offsetX = this.panX + this.width / 2.0f;
            float offsetY = this.panY + this.height / 2.0f;
            Draw.sort((boolean)true);
            for (TechTreeNode node : ResearchDialog.this.nodes) {
                if (!node.visible) continue;
                for (TechTreeNode child : (TechTreeNode[])node.children) {
                    if (!child.visible) continue;
                    boolean lock = ResearchDialog.this.locked(node.node) || ResearchDialog.this.locked(child.node);
                    Draw.z((float)(lock ? 1.0f : 2.0f));
                    Lines.stroke(Scl.scl((float)4.0f), lock ? Pal.gray : Pal.accent);
                    Draw.alpha((float)this.parentAlpha);
                    if (Mathf.equal((float)Math.abs(node.y - child.y), (float)Math.abs(node.x - child.x), (float)1.0f) && Mathf.dstm((float)node.x, (float)node.y, (float)child.x, (float)child.y) <= node.width * 3.0f) {
                        Lines.line(node.x + offsetX, node.y + offsetY, child.x + offsetX, child.y + offsetY);
                        continue;
                    }
                    Lines.line(node.x + offsetX, node.y + offsetY, child.x + offsetX, node.y + offsetY);
                    Lines.line(child.x + offsetX, node.y + offsetY, child.x + offsetX, child.y + offsetY);
                }
            }
            Draw.sort((boolean)false);
            Draw.reset();
            super.drawChildren();
        }
    }

    class LayoutNode
    extends TreeLayout.TreeNode<LayoutNode> {
        final TechTreeNode node;

        LayoutNode(TechTreeNode node, LayoutNode parent) {
            this.node = node;
            this.parent = parent;
            this.width = this.height = ResearchDialog.this.nodeSize;
            if (node.children != null) {
                this.children = (TreeLayout.TreeNode[])Seq.with((Object[])((TechTreeNode[])node.children)).map(t -> new LayoutNode((TechTreeNode)((Object)t), this)).toArray(LayoutNode.class);
            }
        }
    }
}

