/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.freetype.FreeTypeFontGenerator;
import arc.func.Cons;
import arc.func.ConsT;
import arc.graphics.Color;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.event.EventListener;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.Dialog;
import arc.scene.ui.ImageButton;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Collapser;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Http;
import arc.util.Log;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Timer;
import arc.util.serialization.Jval;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.io.versions.LegacyIO;
import mindustry.net.Host;
import mindustry.net.Packets;
import mindustry.net.ServerGroup;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.PaletteDialog;

public class JoinDialog
extends BaseDialog {
    Seq<ServerGroup> tmpServers = new Seq();
    Seq<Server> servers = new Seq();
    Dialog add;
    Server renaming;
    Table local = new Table();
    Table remote = new Table();
    Table global = new Table();
    Table hosts = new Table();
    int totalHosts;
    int refreshes;
    boolean showHidden;
    TextButton.TextButtonStyle style;
    Timer.Task fontIgnoreDirtyTask;
    String lastIp;
    int lastPort;
    int lastColumns = -1;
    Timer.Task ping;
    String serverSearch = "";

    public JoinDialog() {
        super("@joingame");
        this.makeButtonOverlay();
        this.style = new /* Unavailable Anonymous Inner Class!! */;
        this.loadServers();
        this.buttons.add().width(Float.MIN_NORMAL).pad(0.0f);
        this.buttons.add().width(Float.MIN_NORMAL).pad(0.0f);
        this.addCloseButton(Vars.mobile ? 190.0f : 210.0f);
        this.buttons.button("@server.add", (Drawable)Icon.add, () -> {
            this.renaming = null;
            this.add.show();
        });
        this.buttons.add().width(Float.MIN_NORMAL).pad(0.0f);
        this.buttons.add().width(Float.MIN_NORMAL).pad(0.0f);
        this.buttons.addChild((Element)new Table(t -> {
            t.setFillParent(true);
            t.right().bottom().button("?", () -> Vars.ui.showInfo("@join.info")).size(60.0f, 64.0f);
        }));
        this.add = new BaseDialog("@joingame.title");
        this.add.cont.add((CharSequence)"@joingame.ip").padRight(5.0f).left();
        TextField field = (TextField)this.add.cont.field(Core.settings.getString("ip"), text -> Core.settings.put("ip", text)).size(320.0f, 54.0f).maxTextLength(100).get();
        this.add.cont.row();
        this.add.buttons.defaults().size(140.0f, 60.0f).pad(4.0f);
        this.add.buttons.button("@cancel", () -> ((Dialog)this.add).hide());
        this.add.buttons.button("@ok", () -> {
            if (this.renaming == null) {
                Server server = new Server();
                server.setIP(Core.settings.getString("ip"));
                this.servers.add((Object)server);
            } else {
                this.renaming.setIP(Core.settings.getString("ip"));
            }
            this.saveServers();
            this.setupRemote();
            this.refreshRemote();
            this.add.hide();
        }).disabled(b -> Core.settings.getString("ip").isEmpty() || Vars.net.active());
        this.add.shown(() -> {
            this.add.title.setText((CharSequence)(this.renaming != null ? "@server.edit" : "@server.add"));
            if (this.renaming != null) {
                field.setText(this.renaming.displayIP());
            }
        });
        this.keyDown(KeyCode.f5, this::refreshAll);
        this.shown(() -> {
            this.setup();
            this.refreshAll();
            if (!Vars.steam) {
                Core.app.post(() -> Core.settings.getBoolOnce("joininfo", () -> Vars.ui.showInfo("@join.info")));
            }
        });
        this.onResize(() -> {
            if ((float)Math.min(Core.graphics.getWidth(), Core.graphics.getHeight()) / Scl.scl() * 0.9f < 500.0f || this.lastColumns != this.columns()) {
                this.setup();
                this.refreshAll();
            }
            this.lastColumns = this.columns();
        });
    }

    void refreshAll() {
        ++this.refreshes;
        this.refreshLocal();
        this.refreshRemote();
        if (Core.settings.getBool("communityservers", true)) {
            this.refreshCommunity();
        }
    }

    void setupRemote() {
        this.remote.clear();
        for (Server server : this.servers) {
            Button[] buttons = new Button[]{null};
            Button button2 = buttons[0] = (Button)this.remote.button(b -> {}, (Button.ButtonStyle)this.style, () -> {
                if (!buttons[0].childrenPressed()) {
                    if (server.lastHost != null) {
                        Events.fire((Object)new EventType.ClientPreConnectEvent(server.lastHost));
                        this.safeConnect(server.lastHost.address, server.lastHost.port, server.lastHost.version);
                    } else {
                        this.connect(server.ip, server.port);
                    }
                }
            }).width(this.targetWidth()).growY().top().left().pad(4.0f).get();
            if (this.remote.getChildren().size % this.columns() == 0) {
                this.remote.row();
            }
            Table inner = new Table(Tex.whiteui);
            inner.setColor(Pal.gray);
            button2.clearChildren();
            button2.add((Element)inner).growX();
            inner.add((CharSequence)("[accent]" + server.displayIP())).left().padLeft(10.0f).wrap().style((Style)Styles.outlineLabel).growX();
            inner.button((Drawable)Icon.upOpen, Styles.emptyi, () -> this.moveRemote(server, -1)).margin(3.0f).padTop(6.0f).top().right();
            inner.button((Drawable)Icon.downOpen, Styles.emptyi, () -> this.moveRemote(server, 1)).margin(3.0f).pad(2.0f).padTop(6.0f).top().right();
            inner.button((Drawable)Icon.refresh, Styles.emptyi, () -> this.refreshServer(server)).margin(3.0f).pad(2.0f).padTop(6.0f).top().right();
            inner.button((Drawable)Icon.pencil, Styles.emptyi, () -> {
                this.renaming = server;
                this.add.show();
            }).margin(3.0f).pad(2.0f).padTop(6.0f).top().right();
            inner.button((Drawable)Icon.trash, Styles.emptyi, () -> Vars.ui.showConfirm("@confirm", "@server.delete", () -> {
                this.servers.remove((Object)server, true);
                this.saveServers();
                this.setupRemote();
                this.refreshRemote();
            })).margin(3.0f).pad(2.0f).pad(6.0f).top().right();
            button2.row();
            server.content = (Table)button2.table(t -> {}).grow().get();
        }
    }

    void moveRemote(Server server, int sign) {
        int index = this.servers.indexOf((Object)server);
        if (index + sign < 0) {
            return;
        }
        if (index + sign > this.servers.size - 1) {
            return;
        }
        this.servers.remove(index);
        this.servers.insert(index + sign, (Object)server);
        this.saveServers();
        this.setupRemote();
        for (Server other : this.servers) {
            if (other.lastHost != null) {
                this.setupServer(other, other.lastHost);
                continue;
            }
            this.refreshServer(other);
        }
    }

    void refreshRemote() {
        for (Server server : this.servers) {
            this.refreshServer(server);
        }
    }

    void refreshServer(Server server) {
        server.content.clear();
        server.content.background(Tex.whitePane).setColor(Pal.gray);
        server.content.label(() -> Core.bundle.get("server.refreshing") + Strings.animated((float)Time.time, (int)4, (float)11.0f, (String)".")).grow().center().labelAlign(1).padBottom(4.0f);
        Vars.net.pingHost(server.ip, server.port, (Cons<Host>)((Cons)host -> this.setupServer(server, (Host)host)), (Cons<Exception>)((Cons)e -> {
            server.content.clear();
            server.content.background(Tex.whitePane).setColor(Pal.gray);
            server.content.add((CharSequence)"@host.invalid").grow().center().labelAlign(1);
        }));
    }

    void setupServer(Server server, Host host) {
        server.lastHost = host;
        server.content.clear();
        this.buildServer(host, server.content, false, true);
    }

    void buildServer(Host host, Table content, boolean local, boolean addName) {
        content.top().left();
        boolean isBanned = local && Vars.steam && host.description != null && host.description.equals("[banned]");
        String versionString = this.getVersionString(host) + (isBanned ? "[red]\ue817 [banned]" : "");
        float twidth = this.targetWidth() - 40.0f;
        content.background(null);
        Color color = Pal.gray;
        if (addName) {
            content.table(Tex.whiteui, t -> {
                t.left();
                t.setColor(color);
                t.add((CharSequence)(host.name + "   " + versionString)).style((Style)Styles.outlineLabel).padLeft(10.0f).width(twidth).left().ellipsis(true);
            }).growX().height(36.0f).row();
        }
        content.table(Tex.whitePane, t -> {
            t.top().left();
            t.setColor(color);
            t.left();
            if (!host.description.isEmpty() && !isBanned) {
                int count = 0;
                StringBuilder result = new StringBuilder(host.description.length());
                for (int i = 0; i < host.description.length(); ++i) {
                    char c = host.description.charAt(i);
                    if (c == '\n') {
                        if (++count >= 3) continue;
                        result.append(c);
                        continue;
                    }
                    result.append(c);
                }
                t.add((CharSequence)("[gray]" + result)).width(twidth).left().wrap();
                t.row();
            }
            t.add((CharSequence)("[lightgray]" + Core.bundle.format("players" + (host.players == 1 && host.playerLimit <= 0 ? ".single" : ""), new Object[]{(host.players == 0 ? "[lightgray]" : "[accent]") + host.players + (host.playerLimit > 0 ? "[lightgray]/[accent]" + host.playerLimit : "") + "[lightgray]"}))).left().row();
            t.add((CharSequence)("[lightgray]" + Core.bundle.format("save.map", new Object[]{host.mapname}) + "[lightgray] / " + (host.modeName == null ? host.mode.toString() : host.modeName))).width(twidth).left().ellipsis(true).row();
            if (host.ping > 0) {
                t.add((CharSequence)("\ue819 " + host.ping + "ms")).style((Style)Styles.outlineLabel).color(Pal.gray).left();
            }
        }).growY().growX().left().bottom();
    }

    void setup() {
        this.local.clear();
        this.remote.clear();
        this.global.clear();
        float w = this.targetWidth();
        this.hosts.clear();
        this.hosts.marginBottom(70.0f);
        this.section(Vars.steam ? "@servers.local.steam" : "@servers.local", this.local, false);
        this.section("@servers.remote", this.remote, false);
        if (Core.settings.getBool("communityservers", true)) {
            this.section("@servers.global", this.global, true);
        }
        ScrollPane pane = new ScrollPane((Element)this.hosts);
        pane.setFadeScrollBars(false);
        pane.setScrollingDisabled(true, false);
        this.setupRemote();
        this.cont.clear();
        this.cont.table(t -> {
            t.add((CharSequence)"@name").padRight(10.0f);
            t.field(Core.settings.getString("name"), text -> {
                Vars.player.name((String)text);
                Core.settings.put("name", text);
            }).grow().pad(8.0f).maxTextLength(40);
            ImageButton button2 = (ImageButton)t.button(Tex.whiteui, Styles.squarei, 40.0f, () -> new PaletteDialog().show(color -> {
                Vars.player.color().set(color);
                Core.settings.put("color-0", (Object)color.rgba8888());
            })).size(54.0f).get();
            button2.update(() -> {
                button2.getStyle().imageUpColor = Vars.player.color();
            });
        }).width(w).height(70.0f).pad(4.0f);
        this.cont.row();
        this.cont.add((Element)pane).width((w + 5.0f) * (float)this.columns() + 33.0f).pad(0.0f);
        this.cont.row();
    }

    void section(String label, Table servers, boolean eye) {
        Collapser coll = new Collapser(servers, Core.settings.getBool("collapsed-" + label, false));
        coll.setDuration(0.1f);
        this.hosts.table(name -> {
            name.add((CharSequence)label).pad(10.0f).growX().left().color(Pal.accent);
            if (eye) {
                name.button((Drawable)Icon.eyeSmall, Styles.emptyi, () -> {
                    this.showHidden = !this.showHidden;
                    this.refreshCommunity();
                }).update(i -> {
                    i.getStyle().imageUp = this.showHidden ? Icon.eyeSmall : Icon.eyeOffSmall;
                }).size(40.0f).right().padRight(3.0f).tooltip("@servers.showhidden");
            }
            name.button((Drawable)Icon.downOpen, Styles.emptyi, () -> {
                coll.toggle(false);
                Core.settings.put("collapsed-" + label, (Object)coll.isCollapsed());
            }).update(i -> {
                i.getStyle().imageUp = !coll.isCollapsed() ? Icon.upOpen : Icon.downOpen;
            }).size(40.0f).right().padRight(10.0f);
        }).growX();
        this.hosts.row();
        this.hosts.image().growX().pad(5.0f).padLeft(10.0f).padRight(10.0f).height(3.0f).color(Pal.accent);
        this.hosts.row();
        this.hosts.add((Element)coll).width((this.targetWidth() + 5.0f) * (float)this.columns());
        this.hosts.row();
    }

    void refreshLocal() {
        this.totalHosts = 0;
        this.local.clear();
        this.local.background(null);
        this.local.table(Tex.button, t -> t.label(() -> "[accent]" + Core.bundle.get("hosts.discovering.any") + Strings.animated((float)Time.time, (int)4, (float)10.0f, (String)".")).pad(10.0f)).growX();
        Vars.net.discoverServers((Cons<Host>)((Cons)this::addLocalHost), this::finishLocalHosts);
    }

    void refreshCommunity() {
        int cur = this.refreshes;
        this.global.clear();
        this.global.background(null);
        if (!Vars.fetchedServers) {
            JoinDialog.fetchServers();
        }
        this.global.table(t -> {
            t.add((CharSequence)"@search").padRight(10.0f);
            ((TextField)t.field(this.serverSearch, text -> {
                this.serverSearch = text.trim().replaceAll(" +", " ").toLowerCase();
            }).grow().pad(8.0f).get()).keyDown(KeyCode.enter, this::refreshCommunity);
            t.button((Drawable)Icon.zoom, Styles.emptyi, this::refreshCommunity).size(54.0f);
        }).width((this.targetWidth() + 5.0f) * (float)this.columns()).height(70.0f).pad(4.0f).row();
        Seq servers = Vars.fetchedServers ? Vars.defaultServers : this.tmpServers.clear().addAll(Vars.cachedServers).addAll(Vars.defaultServers);
        for (int i = 0; i < servers.size; ++i) {
            ServerGroup group = (ServerGroup)servers.get((i + servers.size / 2) % servers.size);
            boolean hidden = group.hidden();
            if (hidden && !this.showHidden) continue;
            Table[] groupTable = new Table[]{null, null};
            boolean favorite = group.favorite();
            if (group.prioritized) {
                this.addHeader(groupTable, group, hidden, favorite, false);
            } else if (favorite) {
                this.addHeader(groupTable, group, hidden, true, true);
            }
            for (String address : group.addresses) {
                String resaddress = address.contains(":") ? address.split(":")[0] : address;
                int resport = address.contains(":") ? Strings.parseInt((String)address.split(":")[1]) : 6567;
                Vars.net.pingHost(resaddress, resport, (Cons<Host>)((Cons)res -> {
                    if (this.refreshes != cur) {
                        return;
                    }
                    if (this.fontIgnoreDirtyTask == null) {
                        FreeTypeFontGenerator.FreeTypeFontData.ignoreDirty = true;
                        this.fontIgnoreDirtyTask = Time.runTask((float)36.0f, () -> {
                            FreeTypeFontGenerator.FreeTypeFontData.ignoreDirty = false;
                            this.fontIgnoreDirtyTask = null;
                        });
                    }
                    if (!(this.serverSearch.isEmpty() || group.name.toLowerCase().contains(this.serverSearch) || res.name.toLowerCase().contains(this.serverSearch) || res.description.toLowerCase().contains(this.serverSearch) || res.mapname.toLowerCase().contains(this.serverSearch) || res.modeName != null && res.modeName.toLowerCase().contains(this.serverSearch))) {
                        return;
                    }
                    if (groupTable[0] == null) {
                        this.addHeader(groupTable, group, hidden, favorite, true);
                    } else if (!groupTable[0].visible) {
                        this.addHeader(groupTable, group, hidden, favorite, true);
                    }
                    this.addCommunityHost((Host)res, groupTable[1]);
                    groupTable[0].margin(5.0f);
                    groupTable[0].pack();
                }), (Cons<Exception>)((Cons)e -> {}));
            }
        }
    }

    void addHeader(Table[] groupTable, ServerGroup group, boolean hidden, final boolean favorite, boolean doInit) {
        if (groupTable[0] == null) {
            this.global.table(t -> {
                groupTable[0] = t;
            }).fillX().left().row();
        }
        groupTable[0].visible(() -> doInit);
        if (!doInit) {
            return;
        }
        groupTable[0].table(head -> {
            Color col;
            Color color = col = group.prioritized ? Pal.accent : Color.lightGray;
            if (!group.name.isEmpty()) {
                head.add((CharSequence)group.name).color(col).padRight(4.0f);
            }
            head.image().height(3.0f).growX().color(col);
            ImageButton[] image = new ImageButton[]{null, null};
            image[0] = (ImageButton)head.button((Drawable)Icon.star, new ImageButton.ImageButtonStyle(){
                {
                    this.imageUpColor = favorite ? Pal.accent : Color.lightGray;
                    this.imageDownColor = Color.white;
                }
            }, () -> {
                group.setFavorite(!group.favorite());
                image[0].getStyle().imageUpColor = group.favorite() ? Pal.accent : Pal.lightishGray;
            }).size(40.0f).get();
            image[0].getStyle().imageUpColor = favorite ? Pal.accent : Pal.lightishGray;
            image[1] = (ImageButton)head.button((Drawable)(hidden ? Icon.eyeOffSmall : Icon.eyeSmall), Styles.grayi, () -> {
                group.setHidden(!group.hidden());
                TextureRegionDrawable textureRegionDrawable = image[1].getStyle().imageUp = group.hidden() ? Icon.eyeOffSmall : Icon.eyeSmall;
                if (group.hidden() && !this.showHidden) {
                    groupTable[0].remove();
                }
            }).size(40.0f).get();
            image[1].addListener((EventListener)new Tooltip(t -> t.background(Styles.black6).margin(4.0f).label(() -> !group.hidden() ? "@server.shown" : "@server.hidden")));
        }).width(this.targetWidth() * (float)this.columns()).padBottom(-2.0f).row();
        groupTable[1] = (Table)groupTable[0].row().table().top().left().grow().get();
    }

    int columns() {
        return Mathf.clamp((int)((int)((float)Core.graphics.getWidth() / Scl.scl() * 0.9f / this.targetWidth())), (int)1, (int)4);
    }

    void addCommunityHost(Host host, Table container) {
        this.global.background(null);
        String versionString = this.getVersionString(host);
        float w = this.targetWidth();
        container.left().top();
        Button[] button2 = new Button[]{null};
        button2[0] = (Button)container.button(b -> {}, (Button.ButtonStyle)this.style, () -> {
            if (button2[0].childrenPressed()) {
                return;
            }
            Events.fire((Object)new EventType.ClientPreConnectEvent(host));
            if (!Core.settings.getBool("server-disclaimer", false)) {
                Vars.ui.showCustomConfirm("@warning", "@servers.disclaimer", "@ok", "@back", () -> {
                    Core.settings.put("server-disclaimer", (Object)true);
                    this.safeConnect(host.address, host.port, host.version);
                }, () -> Core.settings.put("server-disclaimer", (Object)false));
            } else {
                this.safeConnect(host.address, host.port, host.version);
            }
        }).width(w).padBottom(7.0f).padRight(4.0f).top().left().growY().uniformY().get();
        Table inner = new Table(Tex.whiteui);
        inner.setColor(Pal.gray);
        button2[0].clearChildren();
        button2[0].add((Element)inner).height(45.0f).growX();
        inner.add((CharSequence)(host.name + "   " + versionString)).left().padLeft(10.0f).wrap().style((Style)Styles.outlineLabel).growX();
        inner.button((Drawable)Icon.add, Styles.emptyi, () -> {
            Server server = new Server();
            server.setIP(host.address + ":" + host.port);
            this.servers.add((Object)server);
            this.saveServers();
            this.setupRemote();
            this.refreshRemote();
        }).margin(3.0f).pad(8.0f).padRight(4.0f).top().right();
        button2[0].row();
        this.buildServer(host, (Table)button2[0].table(t -> {}).grow().get(), false, false);
        if (container.getChildren().size % this.columns() == 0) {
            container.row();
        }
    }

    void finishLocalHosts() {
        if (this.totalHosts == 0) {
            this.local.clear();
            this.local.background(Tex.button);
            this.local.add((CharSequence)"@hosts.none").pad(10.0f);
            this.local.add().growX();
            this.local.button((Drawable)Icon.refresh, this::refreshLocal).pad(-12.0f).padLeft(0.0f).size(70.0f);
        } else {
            this.local.background(null);
        }
    }

    void addLocalHost(Host host) {
        if (this.totalHosts == 0) {
            this.local.clear();
        }
        this.local.background(null);
        ++this.totalHosts;
        float w = this.targetWidth();
        if (this.local.getChildren().size % this.columns() == 0) {
            this.local.row();
        }
        this.local.button(b -> this.buildServer(host, (Table)b, true, true), (Button.ButtonStyle)this.style, () -> {
            Events.fire((Object)new EventType.ClientPreConnectEvent(host));
            this.safeConnect(host.address, host.port, host.version);
        }).width(w).top().left().growY();
    }

    public void connect(String ip, int port) {
        if (Vars.player.name.trim().isEmpty()) {
            Vars.ui.showInfo("@noname");
            return;
        }
        Vars.ui.loadfrag.show("@connecting");
        Vars.ui.loadfrag.setButton(() -> {
            Vars.ui.loadfrag.hide();
            Vars.netClient.disconnectQuietly();
        });
        Time.runTask((float)2.0f, () -> {
            Vars.logic.reset();
            Vars.net.reset();
            Vars.netClient.beginConnecting();
            this.lastIp = ip;
            this.lastPort = port;
            Vars.net.connect(this.lastIp, this.lastPort, () -> {
                if (Vars.net.client()) {
                    this.hide();
                    this.add.hide();
                }
            });
        });
    }

    public void reconnect() {
        if (this.lastIp == null || this.lastIp.isEmpty()) {
            return;
        }
        Vars.ui.loadfrag.show("@reconnecting");
        this.ping = Timer.schedule(() -> Vars.net.pingHost(this.lastIp, this.lastPort, (Cons<Host>)((Cons)host -> {
            if (this.ping == null) {
                return;
            }
            this.ping.cancel();
            this.ping = null;
            this.connect(this.lastIp, this.lastPort);
        }), (Cons<Exception>)((Cons)exception -> {})), (float)1.0f, (float)1.0f);
        Vars.ui.loadfrag.setButton(() -> {
            Vars.ui.loadfrag.hide();
            if (this.ping == null) {
                return;
            }
            this.ping.cancel();
            this.ping = null;
        });
    }

    void safeConnect(final String ip, final int port, final int version) {
        Packets.ConnectPacket.clientVersion = Version.build;
        if (version != Version.build && Version.build != -1 && version != -1) {
            new Dialog((version > Version.build ? Packets.KickReason.clientOutdated : Packets.KickReason.serverOutdated).toString()){
                {
                    super(arg0);
                    this.title.setAlignment(1);
                    this.cont.add((CharSequence)Core.bundle.format("server.versions", new Object[]{Version.build, version})).row();
                    this.cont.row();
                    this.cont.add((CharSequence)"@forceJoin.tips").row();
                    this.cont.pack();
                    ((TextButton)this.buttons.button("\u5f3a\u5236\u52a0\u5165", () -> {
                        this.hide();
                        Packets.ConnectPacket.clientVersion = version;
                        JoinDialog.this.connect(ip, port);
                    }).get()).getLabel().setWrap(false);
                    this.buttons.button("@cancel", () -> (this).hide());
                    this.closeOnBack();
                }
            }.show();
        } else {
            this.connect(ip, port);
        }
    }

    float targetWidth() {
        return Math.min((float)Core.graphics.getWidth() / Scl.scl() * 0.9f, 550.0f);
    }

    private void loadServers() {
        this.servers = (Seq)Core.settings.getJson("servers", Seq.class, Server.class, Seq::new);
        if (Core.settings.has("server-list")) {
            this.servers = LegacyIO.readServers();
            Core.settings.remove("server-list");
        }
        JoinDialog.fetchServers();
    }

    public static void fetchServers() {
        String[] urls;
        String[] stringArray = urls = Version.type.equals("bleeding-edge") || Vars.forceBeServers ? Vars.serverJsonBeURLs : Vars.serverJsonURLs;
        if (Core.settings.getBool("communityservers", true)) {
            try {
                if (!Vars.loadedServerCache && Vars.serverCacheFile.exists()) {
                    Vars.loadedServerCache = true;
                    Vars.cachedServers.addAll(JoinDialog.parseServerString(Vars.serverCacheFile.readString()));
                }
            }
            catch (Exception e) {
                Log.err((String)"Failed to load cached server file", (Throwable)e);
            }
            JoinDialog.fetchServers(urls, 0);
        }
    }

    private static void fetchServers(String[] urls, int index) {
        if (index >= urls.length) {
            return;
        }
        Http.get(urls[index]).error((Cons<Throwable>)((Cons)t -> {
            if (Vars.fetchedServers) {
                return;
            }
            if (index < urls.length - 1) {
                JoinDialog.fetchServers(urls, index + 1);
            } else {
                Log.err((String)"Failed to fetch community servers", (Throwable)t);
            }
        })).submit((ConsT<Http.HttpResponse, Exception>)((ConsT)result -> {
            if (Vars.fetchedServers) {
                return;
            }
            String text = result.getResultAsString();
            Seq<ServerGroup> servers = JoinDialog.parseServerString(text);
            Core.app.post(() -> {
                if (Vars.fetchedServers) {
                    return;
                }
                try {
                    Vars.serverCacheFile.writeString(text);
                }
                catch (Exception e) {
                    Log.err((String)"Failed to write server cache", (Throwable)e);
                }
                Vars.defaultServers.addAll(servers);
                Vars.fetchedServers = true;
                Log.info((String)"Fetched @ community servers.", (Object[])new Object[]{Vars.defaultServers.sum(s -> s.addresses.length)});
            });
        }));
    }

    private static Seq<ServerGroup> parseServerString(String str) {
        Jval val = Jval.read((String)str);
        Seq servers = new Seq();
        val.asArray().each(child -> {
            String name = child.getString("name", "");
            boolean prioritized = child.getBool("prioritized", false);
            String[] addresses = child.has("addresses") || child.has("address") && child.get("address").isArray() ? (String[])(child.has("addresses") ? child.get("addresses") : child.get("address")).asArray().map(Jval::asString).toArray(String.class) : new String[]{child.getString("address", "<invalid>")};
            servers.add((Object)new ServerGroup(name, addresses, prioritized));
        });
        servers.sort(s -> s.name == null ? 2.1474836E9f : (float)s.name.hashCode());
        return servers;
    }

    private void saveServers() {
        Core.settings.putJson("servers", Server.class, this.servers);
    }

    private String getVersionString(Host host) {
        if (host.version == -1) {
            return Core.bundle.format("server.version", new Object[]{Core.bundle.get("server.custombuild"), ""});
        }
        if (host.version == 0) {
            return Core.bundle.get("server.outdated");
        }
        if (host.version < Version.build && Version.build != -1) {
            return Core.bundle.get("server.outdated") + "\n" + Core.bundle.format("server.version", new Object[]{host.version, ""});
        }
        if (host.version > Version.build && Version.build != -1) {
            return Core.bundle.get("server.outdated.client") + "\n" + Core.bundle.format("server.version", new Object[]{host.version, ""});
        }
        if (host.version == Version.build && Version.type.equals(host.versionType)) {
            return "";
        }
        return Core.bundle.format("server.version", new Object[]{host.version, host.versionType});
    }

    public static class Server {
        public String ip;
        public int port;
        transient Table content;
        transient Host lastHost;

        void setIP(String ip) {
            try {
                boolean isIpv6;
                boolean bl = isIpv6 = Strings.count((CharSequence)ip, (char)':') > 1;
                if (isIpv6 && ip.lastIndexOf("]:") != -1 && ip.lastIndexOf("]:") != ip.length() - 1) {
                    int idx = ip.indexOf("]:");
                    this.ip = ip.substring(1, idx);
                    this.port = Integer.parseInt(ip.substring(idx + 2));
                } else if (!isIpv6 && ip.lastIndexOf(58) != -1 && ip.lastIndexOf(58) != ip.length() - 1) {
                    int idx = ip.lastIndexOf(58);
                    this.ip = ip.substring(0, idx);
                    this.port = Integer.parseInt(ip.substring(idx + 1));
                } else {
                    this.ip = ip;
                    this.port = 6567;
                }
            }
            catch (Exception e) {
                this.ip = ip;
                this.port = 6567;
            }
        }

        String displayIP() {
            if (Strings.count((CharSequence)this.ip, (char)':') > 1) {
                return this.port != 6567 ? "[" + this.ip + "]:" + this.port : this.ip;
            }
            return this.ip + (this.port != 6567 ? ":" + this.port : "");
        }
    }
}

