/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui;

import arc.graphics.g2d.Fill;
import arc.scene.Element;

public class GridImage
extends Element {
    private int imageWidth;
    private int imageHeight;
    public int interval = 1;

    public GridImage(int w, int h) {
        this.imageWidth = w;
        this.imageHeight = h;
    }

    public void draw() {
        float xspace = this.getWidth() / (float)this.imageWidth;
        float yspace = this.getHeight() / (float)this.imageHeight;
        float s = 1.0f;
        int minspace = 10;
        int jumpx = (int)(Math.max((float)minspace, xspace * (float)this.interval) / xspace);
        int jumpy = (int)(Math.max((float)minspace, yspace * (float)this.interval) / yspace);
        for (int x = 0; x <= this.imageWidth; x += jumpx) {
            Fill.crect((float)((int)(this.x + xspace * (float)x - s)), (float)(this.y - s), (float)2.0f, (float)(this.getHeight() + (float)(x == this.imageWidth ? 1 : 0)));
        }
        for (int y = 0; y <= this.imageHeight; y += jumpy) {
            Fill.crect((float)(this.x - s), (float)((int)(this.y + (float)y * yspace - s)), (float)this.getWidth(), (float)2.0f);
        }
    }

    public void setImageSize(int w, int h) {
        this.imageWidth = w;
        this.imageHeight = h;
    }
}

