/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import arc.Core;
import arc.Events;
import arc.func.Cons;
import arc.func.Cons2;
import arc.func.Prov;
import arc.net.ArcNetException;
import arc.net.Server;
import arc.struct.IntMap;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.channels.ClosedChannelException;
import mindustry.Vars;
import mindustry.core.Platform;
import mindustry.game.EventType;
import mindustry.gen.Call;
import mindustry.net.Host;
import mindustry.net.NetConnection;
import mindustry.net.Packet;
import mindustry.net.Packets;
import mindustry.net.Streamable;
import mindustry.net.ValidateException;
import mindustryX.events.SendPacketEvent;
import mindustryX.features.LogicExt;
import mindustryX.features.PingService;
import mindustryX.features.ProtocolMap;
import mindustryX.features.ReplayController;
import net.jpountz.lz4.LZ4Exception;

public class Net {
    private static Seq<Prov<? extends Packet>> packetProvs = new Seq();
    private static Seq<Class<? extends Packet>> packetClasses = new Seq();
    private static ObjectIntMap<Class<?>> packetToId = new ObjectIntMap();
    private boolean server;
    private boolean active;
    private boolean clientLoaded;
    @Nullable
    private Streamable.StreamBuilder currentStream;
    private final Seq<Packet> packetQueue = new Seq();
    private final ObjectMap<Class<?>, Cons> clientListeners = new ObjectMap();
    private final ObjectMap<Class<?>, Cons2<NetConnection, Object>> serverListeners = new ObjectMap();
    private final IntMap<Streamable.StreamBuilder> streams = new IntMap();
    private final NetProvider provider;
    private static final ProtocolMap v146ProtocolMap;
    private static final ProtocolMap v153ProtocolMap;

    public static Seq<Class<? extends Packet>> allPacketClasses() {
        return packetClasses;
    }

    public static <T extends Packet> void registerPacket(Prov<T> cons) {
        packetProvs.add(cons);
        Packet t = (Packet)cons.get();
        packetClasses.add(t.getClass());
        packetToId.put(t.getClass(), Net.packetProvs.size - 1);
    }

    public static byte getPacketId(Packet packet) {
        int id;
        int n = LogicExt.v146Mode ? v146ProtocolMap.getId(packet) : (id = LogicExt.mockProtocol <= 153 ? v153ProtocolMap.getId(packet) : packetToId.get(packet.getClass(), -1));
        if (id == -1) {
            throw new ArcRuntimeException("Unknown packet type: " + packet.getClass());
        }
        return (byte)id;
    }

    public static <T extends Packet> T newPacket(byte id) {
        int id2 = id & 0xFF;
        if (LogicExt.v146Mode) {
            id2 = v146ProtocolMap.mapId(id2);
        } else if (LogicExt.mockProtocol <= 153) {
            id2 = v153ProtocolMap.mapId(id2);
        }
        return (T)((Packet)((Prov)packetProvs.get(id2)).get());
    }

    public Net(NetProvider provider) {
        this.provider = provider;
    }

    public void handleException(Throwable e) {
        if (e instanceof ArcNetException) {
            Core.app.post(() -> this.showError(new IOException("mismatch", e)));
        } else if (e instanceof ClosedChannelException) {
            Core.app.post(() -> this.showError(new IOException("alreadyconnected", e)));
        } else {
            Core.app.post(() -> this.showError(e));
        }
    }

    public void showError(Throwable e) {
        if (!Vars.headless) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            String baseError = Strings.getFinalMessage((Throwable)e);
            String error = baseError == null ? "" : baseError.toLowerCase();
            String type = t.getClass().toString().toLowerCase();
            boolean isError = false;
            if (e instanceof BufferUnderflowException || e instanceof BufferOverflowException || e.getCause() instanceof EOFException) {
                error = Core.bundle.get("error.io");
            } else if (error.equals("mismatch") || e instanceof LZ4Exception || e instanceof IndexOutOfBoundsException && e.getStackTrace().length > 0 && e.getStackTrace()[0].getClassName().contains("java.nio")) {
                error = Core.bundle.get("error.mismatch");
            } else if (error.contains("port out of range") || error.contains("invalid argument") || error.contains("invalid") && error.contains("address") || Strings.neatError((Throwable)e).contains("address associated")) {
                error = Core.bundle.get("error.invalidaddress");
            } else if (error.contains("connection refused") || error.contains("route to host") || type.contains("unknownhost")) {
                error = Core.bundle.get("error.unreachable");
            } else if (type.contains("timeout")) {
                error = Core.bundle.get("error.timedout");
            } else if (error.equals("alreadyconnected") || error.contains("connection is closed")) {
                error = Core.bundle.get("error.alreadyconnected");
            } else if (!error.isEmpty()) {
                error = Core.bundle.get("error.any");
                isError = true;
            }
            if (isError) {
                Vars.ui.showException("@error.any", e);
            } else {
                Vars.ui.showText("", Core.bundle.format("connectfail", new Object[]{error}));
            }
            Vars.ui.loadfrag.hide();
            if (this.client()) {
                Vars.netClient.disconnectQuietly();
            }
        }
        Log.err((Throwable)e);
    }

    public void setClientLoaded(boolean loaded) {
        this.clientLoaded = loaded;
        if (loaded) {
            for (int i = 0; i < this.packetQueue.size; ++i) {
                this.handleClientReceived((Packet)this.packetQueue.get(i));
            }
        }
        this.packetQueue.clear();
    }

    public void setClientConnected() {
        this.active = true;
        this.server = false;
    }

    public void connect(String ip, int port, Runnable success) {
        try {
            if (this.active) {
                throw new IOException("alreadyconnected");
            }
            Events.fire((Object)new EventType.ClientServerConnectEvent(ip, port));
            this.provider.connectClient(ip, port, success);
            this.active = true;
            this.server = false;
        }
        catch (IOException e) {
            this.showError(e);
        }
    }

    public void host(int port) throws IOException {
        this.provider.hostServer(port);
        this.active = true;
        this.server = true;
        Time.runTask((float)60.0f, () -> ((Platform)Vars.platform).updateRPC());
    }

    public void closeServer() {
        for (NetConnection con : this.getConnections()) {
            Call.kick((NetConnection)con, (Packets.KickReason)Packets.KickReason.serverClose);
        }
        this.provider.closeServer();
        this.server = false;
        this.active = false;
    }

    public void reset() {
        this.closeServer();
        Vars.netClient.disconnectNoReset();
    }

    public void disconnect() {
        Vars.content.setTemporaryMapper(null);
        if (this.active && !this.server) {
            Log.info((Object)"Disconnecting.");
        }
        this.provider.disconnectClient();
        this.server = false;
        this.active = false;
    }

    public void discoverServers(Cons<Host> cons, Runnable done) {
        this.provider.discoverServers(cons, done);
    }

    public Iterable<NetConnection> getConnections() {
        return this.provider.getConnections();
    }

    public void send(Object object, boolean reliable) {
        if (SendPacketEvent.emit(null, null, object)) {
            return;
        }
        if (this.server) {
            for (NetConnection netConnection : this.provider.getConnections()) {
                if (!netConnection.hasBegunConnecting) continue;
                netConnection.send(object, reliable);
            }
        } else {
            this.provider.sendClient(object, reliable |= ((Boolean)LogicExt.reliableSync.get()).booleanValue());
        }
    }

    public void sendExcept(NetConnection except, Object object, boolean reliable) {
        if (SendPacketEvent.emit(null, except, object)) {
            return;
        }
        for (NetConnection con : this.getConnections()) {
            if (con == except || !con.hasBegunConnecting) continue;
            con.send(object, reliable);
        }
    }

    @Nullable
    public Streamable.StreamBuilder getCurrentStream() {
        return this.currentStream;
    }

    public <T> void handleClient(Class<T> type, Cons<T> listener) {
        this.clientListeners.put(type, listener);
    }

    public <T> void handleServer(Class<T> type, Cons2<NetConnection, T> listener) {
        this.serverListeners.put(type, listener);
    }

    public void handleClientReceived(Packet object) {
        block13: {
            try {
                object.handled();
            }
            catch (RuntimeException e) {
                if (LogicExt.contentsCompatibleMode && e.getCause() instanceof EOFException) break block13;
                throw e;
            }
        }
        if (object instanceof Packets.StreamBegin) {
            Packets.StreamBegin b = (Packets.StreamBegin)object;
            this.currentStream = new Streamable.StreamBuilder(b);
            this.streams.put(b.id, (Object)this.currentStream);
        } else if (object instanceof Packets.StreamChunk) {
            Packets.StreamChunk c = (Packets.StreamChunk)object;
            Streamable.StreamBuilder builder = (Streamable.StreamBuilder)this.streams.get(c.id);
            if (builder == null) {
                throw new RuntimeException("Received stream chunk without a StreamBegin beforehand!");
            }
            builder.add(c.data);
            Vars.ui.loadfrag.setProgress(builder.progress());
            Vars.ui.loadfrag.snapProgress();
            Vars.netClient.resetTimeout();
            if (builder.isDone()) {
                this.streams.remove(builder.id);
                this.handleClientReceived((Packet)builder.build());
                this.currentStream = null;
            }
        } else {
            int p = object.getPriority();
            if (this.clientLoaded || p == 2) {
                ReplayController.onClientPacket(object);
                if (this.clientListeners.get(object.getClass()) != null) {
                    ((Cons)this.clientListeners.get(object.getClass())).get((Object)object);
                } else {
                    object.handleClient();
                }
            } else if (p != 0) {
                this.packetQueue.add((Object)object);
            }
        }
    }

    public void handleServerReceived(NetConnection connection, Packet object) {
        try {
            if (connection.hasConnected || object.getPriority() == 2) {
                object.handled();
                if (this.serverListeners.get(object.getClass()) != null) {
                    ((Cons2)this.serverListeners.get(object.getClass())).get((Object)connection, (Object)object);
                } else {
                    object.handleServer(connection);
                }
            }
        }
        catch (ValidateException e) {
            Log.debug((String)"Validation failed for '@': @", (Object[])new Object[]{e.player, e.getMessage()});
        }
        catch (RuntimeException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof ValidateException) {
                ValidateException v = (ValidateException)throwable;
                Log.debug((String)"Validation failed for '@': @", (Object[])new Object[]{v.player, v.getMessage()});
            }
            throw e;
        }
    }

    public void setConnectFilter(@Nullable Server.ServerConnectFilter filter) {
        this.provider.setConnectFilter(filter);
    }

    @Nullable
    public Server.ServerConnectFilter getConnectFilter() {
        return this.provider.getConnectFilter();
    }

    public void pingHost(String address, int port, Cons<Host> valid, Cons<Exception> failed) {
        Vars.mainExecutor.submit(() -> PingService.INSTANCE.pingHost(address, port, valid, failed));
    }

    public boolean active() {
        return this.active;
    }

    public boolean server() {
        return this.server && this.active;
    }

    public boolean client() {
        return !this.server && this.active;
    }

    public void dispose() {
        this.provider.dispose();
        this.server = false;
        this.active = false;
    }

    static {
        Net.registerPacket(Packets.StreamBegin::new);
        Net.registerPacket(Packets.StreamChunk::new);
        Net.registerPacket(Packets.WorldStream::new);
        Net.registerPacket(Packets.ConnectPacket::new);
        Call.registerPackets();
        v146ProtocolMap = new ProtocolMap("v146");
        v153ProtocolMap = new ProtocolMap("v153");
    }

    public static interface NetProvider {
        public void connectClient(String var1, int var2, Runnable var3) throws IOException;

        public void sendClient(Object var1, boolean var2);

        public void disconnectClient();

        public void discoverServers(Cons<Host> var1, Runnable var2);

        public void pingHost(String var1, int var2, Cons<Host> var3, Cons<Exception> var4);

        public void hostServer(int var1) throws IOException;

        public Iterable<? extends NetConnection> getConnections();

        public void closeServer();

        default public void dispose() {
            this.disconnectClient();
            this.closeServer();
        }

        default public void setConnectFilter(Server.ServerConnectFilter connectFilter) {
        }

        @Nullable
        default public Server.ServerConnectFilter getConnectFilter() {
            return null;
        }
    }
}

