/*
 * Decompiled with CFR 0.152.
 */
package mindustry.mod;

import arc.Core;
import arc.Events;
import arc.assets.Loadable;
import arc.files.Fi;
import arc.files.ZipFi;
import arc.func.Cons;
import arc.func.Cons2;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.Texture;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.scene.style.Drawable;
import arc.scene.ui.Dialog;
import arc.struct.ObjectFloatMap;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.OrderedMap;
import arc.struct.OrderedSet;
import arc.struct.Seq;
import arc.util.Disposable;
import arc.util.I18NBundle;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.OS;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.Time;
import arc.util.io.PropertiesUtils;
import arc.util.serialization.Json;
import arc.util.serialization.Jval;
import java.io.IOException;
import java.io.Reader;
import java.util.Comparator;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.graphics.MultiPacker;
import mindustry.graphics.Pal;
import mindustry.mod.ClassLoaderCloser;
import mindustry.mod.ContentParser;
import mindustry.mod.Mod;
import mindustry.mod.ModClassLoader;
import mindustry.mod.Plugin;
import mindustry.mod.Scripts;
import mindustry.type.ErrorContent;
import mindustry.type.Publishable;
import mindustry.ui.Styles;
import mindustryX.features.InternalMods;

public class Mods
implements Loadable {
    private static final String[] metaFiles = new String[]{"mod.json", "mod.hjson", "plugin.json", "plugin.hjson"};
    private static final ObjectSet<String> blacklistedMods = ObjectSet.with((Object[])new String[]{"ui-lib", "braindustry"});
    private Json json = new Json();
    @Nullable
    private Scripts scripts;
    private ContentParser parser = new ContentParser();
    private ObjectMap<String, Seq<Fi>> bundles = new ObjectMap();
    private ObjectSet<String> specialFolders = ObjectSet.with((Object[])new String[]{"bundles", "sprites", "sprites-override", ".git"});
    @Nullable
    private Seq<LoadedMod> lastOrderedMods = new Seq();
    private ModClassLoader mainLoader = new ModClassLoader(this.getClass().getClassLoader());
    Seq<LoadedMod> mods = new Seq();
    private Seq<LoadedMod> newImports = new Seq();
    private ObjectMap<Class<?>, ModMeta> metas = new ObjectMap();
    private boolean requiresReload;

    public Mods() {
        Events.on(EventType.ClientLoadEvent.class, e -> Core.app.post(this::checkWarnings));
    }

    public ClassLoader mainLoader() {
        return this.mainLoader;
    }

    public Fi getConfigFolder(Mod mod) {
        ModMeta load = (ModMeta)this.metas.get(mod.getClass());
        if (load == null) {
            throw new IllegalArgumentException("Mod is not loaded yet (or missing)!");
        }
        Fi result = Vars.modDirectory.child(load.name);
        result.mkdirs();
        return result;
    }

    public Fi getConfig(Mod mod) {
        return this.getConfigFolder(mod).child("config.json");
    }

    public void listFiles(String directory, Cons2<LoadedMod, Fi> cons) {
        this.eachEnabled((Cons<LoadedMod>)((Cons)mod -> {
            Fi file = mod.root.child(directory);
            if (file.exists()) {
                for (Fi child : file.list()) {
                    cons.get(mod, (Object)child);
                }
            }
        }));
    }

    @Nullable
    public LoadedMod getMod(String name) {
        return (LoadedMod)this.mods.find(m -> m.name.equals(name));
    }

    @Nullable
    public LoadedMod getMod(Class<? extends Mod> type) {
        return (LoadedMod)this.mods.find(m -> m.main != null && m.main.getClass() == type);
    }

    public LoadedMod importMod(Fi file) throws IOException {
        String baseName;
        String finalName = baseName = file.nameWithoutExtension().replace(':', '_').replace(' ', '_');
        int count = 1;
        while (Vars.modDirectory.child(finalName + ".zip").exists()) {
            finalName = baseName + "" + count++;
        }
        Fi dest = Vars.modDirectory.child(finalName + ".zip");
        try {
            file.copyTo(dest);
            LoadedMod loaded = this.loadMod(dest, true, true);
            this.mods.add((Object)loaded);
            this.newImports.add((Object)loaded);
            this.lastOrderedMods = null;
            this.requiresReload = true;
            Core.settings.put("mod-" + loaded.name + "-enabled", (Object)true);
            this.sortMods();
            Core.app.post(() -> this.loadIcon(loaded));
            Events.fire((Enum)EventType.Trigger.importMod);
            return loaded;
        }
        catch (IOException e) {
            dest.delete();
            throw e;
        }
        catch (Throwable t) {
            dest.delete();
            throw new IOException(t);
        }
    }

    public void loadAsync() {
        class RegionEntry {
            String name;
            PixmapRegion region;
            int[] splits;
            int[] pads;

            RegionEntry(String name, PixmapRegion region, int[] splits, int[] pads) {
                this.name = name;
                this.region = region;
                this.splits = splits;
                this.pads = pads;
            }
        }
        MultiPacker.PageType type;
        if (!this.mods.contains(LoadedMod::enabled)) {
            return;
        }
        long startTime = Time.millis();
        final MultiPacker packer = new MultiPacker();
        ObjectFloatMap textureResize = new ObjectFloatMap();
        int[] totalSprites = new int[]{0};
        Seq tasks = new Seq();
        this.eachEnabled((Cons<LoadedMod>)((Cons)mod -> {
            Seq sprites = mod.root.child("sprites").findAll(f -> f.extension().equals("png"));
            Seq<Fi> overrides = mod.root.child("sprites-override").findAll(f -> f.extension().equals("png"));
            if (mod.root.path().equals("/mindustryX/mods/MindustryX")) {
                overrides = InternalMods.spritesOverride();
            }
            this.packSprites(packer, (Seq<Fi>)sprites, (LoadedMod)mod, true, (Seq<Future<Runnable>>)tasks, (ObjectFloatMap<String>)textureResize);
            this.packSprites(packer, overrides, (LoadedMod)mod, false, (Seq<Future<Runnable>>)tasks, (ObjectFloatMap<String>)textureResize);
            Log.debug((String)"Packed @ images for mod '@'.", (Object[])new Object[]{sprites.size + overrides.size, mod.meta.name});
            totalSprites[0] = totalSprites[0] + (sprites.size + overrides.size);
        }));
        for (Future result : tasks) {
            try {
                Runnable packRun = (Runnable)result.get();
                if (packRun == null) continue;
                try {
                    packRun.run();
                }
                catch (Exception e) {
                    Log.err((String)"Failed to fit image into the spritesheet, skipping.", (Object[])new Object[0]);
                    Log.err((Throwable)e);
                }
            }
            catch (Exception e) {
                Log.err((Throwable)e);
            }
        }
        Log.debug((String)"Total sprites: @", (Object[])new Object[]{totalSprites[0]});
        Texture.TextureFilter filter = Core.settings.getBool("linear", true) ? Texture.TextureFilter.linear : Texture.TextureFilter.nearest;
        final Texture[] whiteToDispose = new Texture[]{null};
        Seq[] entries = new Seq[MultiPacker.PageType.all.length];
        for (int i = 0; i < MultiPacker.PageType.all.length; ++i) {
            entries[i] = new Seq();
        }
        ObjectMap pageTypes = ObjectMap.of((Object[])new Object[]{Core.atlas.find((String)"white").texture, MultiPacker.PageType.main, Core.atlas.find((String)"stone1").texture, MultiPacker.PageType.environment, Core.atlas.find((String)"whiteui").texture, MultiPacker.PageType.ui, Core.atlas.find((String)"rubble-1-0").texture, MultiPacker.PageType.rubble});
        for (TextureAtlas.AtlasRegion region : Core.atlas.getRegions()) {
            type = (MultiPacker.PageType)((Object)pageTypes.get((Object)region.texture, (Object)MultiPacker.PageType.main));
            if (packer.has(type, region.name)) continue;
            entries[type.ordinal()].add((Object)new RegionEntry(region.name, Core.atlas.getPixmap(region), region.splits, region.pads));
        }
        for (int i = 0; i < MultiPacker.PageType.all.length; ++i) {
            Seq rects = entries[i];
            type = MultiPacker.PageType.all[i];
            rects.sort(Structs.comparingInt(o -> -Math.max(o.region.width, o.region.height)));
            for (RegionEntry entry : rects) {
                packer.add(type, entry.name, entry.region, entry.splits, entry.pads);
            }
        }
        this.waitForMain(() -> {
            Core.atlas.dispose();
            final TextureAtlas shadow = Core.atlas;
            Core.atlas = new TextureAtlas(){
                boolean foundWhite;
                TextureAtlas.AtlasRegion whiteRegion;
                {
                    this.error = shadow.find("error");
                }

                public TextureAtlas.AtlasRegion white() {
                    if (Core.app.isOnMainThread() && !this.foundWhite) {
                        Texture tex;
                        Pixmap pixmap = Pixmaps.blankPixmap();
                        whiteToDispose[0] = tex = new Texture(pixmap);
                        this.whiteRegion = new TextureAtlas.AtlasRegion(tex, 0, 0, 1, 1);
                        return this.whiteRegion;
                    }
                    return super.white();
                }

                public TextureAtlas.AtlasRegion find(String name) {
                    PixmapRegion base = packer.get(name);
                    if (base != null) {
                        TextureAtlas.AtlasRegion reg = new TextureAtlas.AtlasRegion(shadow.find((String)name).texture, base.x, base.y, base.width, base.height);
                        reg.name = name;
                        reg.pixmapRegion = base;
                        return reg;
                    }
                    return shadow.find(name);
                }

                public boolean isFound(TextureRegion region) {
                    return region != shadow.find("error");
                }

                public TextureRegion find(String name, TextureRegion def) {
                    return !this.has(name) ? def : this.find(name);
                }

                public boolean has(String s) {
                    return shadow.has(s) || packer.get(s) != null;
                }

                public PixmapRegion getPixmap(TextureAtlas.AtlasRegion region) {
                    PixmapRegion out = packer.get(region.name);
                    if (out == null) {
                        return packer.get("error");
                    }
                    return out;
                }
            };
        });
        for (Seq<Content> arr : Vars.content.getContentMap()) {
            arr.each(c -> {
                if (c instanceof UnlockableContent) {
                    UnlockableContent u = (UnlockableContent)((Object)c);
                    if (c.minfo.mod != null) {
                        u.load();
                        u.loadIcon();
                        if (u.generateIcons && !c.minfo.mod.meta.pregenerated) {
                            u.createIcons(packer);
                        }
                    }
                }
            });
        }
        this.waitForMain(() -> {
            if (whiteToDispose[0] != null) {
                whiteToDispose[0].dispose();
            }
            Core.atlas = packer.flush(filter, new TextureAtlas(){

                public PixmapRegion getPixmap(TextureAtlas.AtlasRegion region) {
                    PixmapRegion other = super.getPixmap(region);
                    if (other.pixmap.isDisposed()) {
                        throw new RuntimeException("Calling getPixmap outside of createIcons is not supported!");
                    }
                    return other;
                }
            });
            textureResize.each(e -> {
                Core.atlas.find((String)((String)e.key)).scale = e.value;
            });
            Core.atlas.setErrorRegion("error");
            Log.debug((String)"Total pages: @", (Object[])new Object[]{Core.atlas.getTextures().size});
            packer.printStats();
            Events.fire((Object)new EventType.AtlasPackEvent());
            packer.dispose();
            Log.debug((String)"Total time to pack and generate sprites: @ms", (Object[])new Object[]{Time.timeSinceMillis((long)startTime)});
        });
    }

    private void loadIcons() {
        for (LoadedMod mod : this.mods) {
            this.loadIcon(mod);
        }
    }

    private void loadIcon(LoadedMod mod) {
        if (mod.root.child("icon.png").exists() && !Vars.headless) {
            try {
                mod.iconTexture = new Texture(mod.root.child("icon.png"));
                mod.iconTexture.setFilter(Texture.TextureFilter.linear);
            }
            catch (Throwable t) {
                Log.err((String)("Failed to load icon for mod '" + mod.name + "'."), (Throwable)t);
            }
        }
    }

    private void packSprites(MultiPacker packer, Seq<Fi> sprites, LoadedMod mod, boolean prefix, Seq<Future<Runnable>> tasks, ObjectFloatMap<String> textureResize) {
        boolean bleed = Core.settings.getBool("linear", true) && !mod.meta.pregenerated;
        float textureScale = mod.meta.texturescale;
        for (Fi file : sprites) {
            String regionName;
            String baseName = file.nameWithoutExtension();
            String string = regionName = baseName.contains(".") ? baseName.substring(0, baseName.indexOf(".")) : baseName;
            if (!prefix && !Core.atlas.has(regionName)) {
                Log.warn((String)"Sprite '@' in mod '@' attempts to override a non-existent sprite.", (Object[])new Object[]{regionName, mod.name});
            }
            tasks.add(Vars.mainExecutor.submit(() -> {
                try {
                    Pixmap pix = new Pixmap(file.readBytes());
                    if (bleed) {
                        Pixmaps.bleed((Pixmap)pix, (int)2);
                    }
                    return () -> {
                        int hyphen = baseName.indexOf(45);
                        String fullName = (prefix && (hyphen == -1 || !baseName.substring(hyphen + 1).startsWith(mod.name + "-")) ? mod.name + "-" : "") + baseName;
                        packer.add(this.getPage(file), fullName, new PixmapRegion(pix));
                        if (textureScale != 1.0f) {
                            textureResize.put((Object)fullName, textureScale);
                        }
                        pix.dispose();
                    };
                }
                catch (Exception e) {
                    throw new Exception("Failed to load image " + file + " for mod " + mod.name, e);
                }
            }));
        }
    }

    void waitForMain(Runnable run) {
        CountDownLatch latch = new CountDownLatch(1);
        Core.app.post(() -> {
            run.run();
            latch.countDown();
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadSync() {
        this.loadIcons();
    }

    private MultiPacker.PageType getPage(Fi file) {
        String path = file.path();
        return path.contains("sprites/blocks/environment") || path.contains("sprites-override/blocks/environment") ? MultiPacker.PageType.environment : (path.contains("sprites/rubble") || path.contains("sprites-override/rubble") ? MultiPacker.PageType.rubble : (path.contains("sprites/ui") || path.contains("sprites-override/ui") ? MultiPacker.PageType.ui : MultiPacker.PageType.main));
    }

    public void removeMod(LoadedMod mod) {
        boolean deleted = true;
        if (mod.loader != null) {
            if (Vars.android) {
                Fi cacheDir = new Fi(Core.files.getCachePath()).child("mods");
                Fi modCacheDir = cacheDir.child(mod.file.nameWithoutExtension());
                if (modCacheDir.exists()) {
                    deleted = modCacheDir.deleteDirectory();
                }
            } else {
                try {
                    ClassLoaderCloser.close((ClassLoader)mod.loader);
                }
                catch (Exception e) {
                    Log.err((Throwable)e);
                }
            }
        }
        if (mod.root instanceof ZipFi) {
            mod.root.delete();
        }
        if (!(deleted &= mod.file.isDirectory() ? mod.file.deleteDirectory() : mod.file.delete())) {
            Vars.ui.showErrorMessage("@mod.delete.error");
            return;
        }
        this.mods.remove((Object)mod);
        this.newImports.remove((Object)mod);
        mod.dispose();
        if (mod.state != ModState.disabled) {
            this.requiresReload = true;
        }
    }

    public Scripts getScripts() {
        if (this.scripts == null) {
            this.scripts = Vars.platform.createScripts();
        }
        return this.scripts;
    }

    public boolean hasScripts() {
        return this.scripts != null;
    }

    public boolean requiresReload() {
        return this.requiresReload;
    }

    public boolean skipModLoading() {
        return Vars.failedToLaunch && Core.settings.getBool("modcrashdisable", true);
    }

    public void load() {
        Seq candidates = new Seq();
        this.mods.addAll(InternalMods.load());
        Seq.with((Object[])Vars.modDirectory.list()).retainAll(f -> f.extEquals("jar") || f.extEquals("zip") || f.isDirectory() && Structs.contains((Object[])metaFiles, meta -> this.resolveRoot((Fi)f).child(meta).exists())).each(arg_0 -> ((Seq)candidates).add(arg_0));
        Vars.platform.getWorkshopContent(LoadedMod.class).each(arg_0 -> ((Seq)candidates).add(arg_0));
        ObjectMap mapping = new ObjectMap();
        Seq metas = new Seq();
        for (Fi file : candidates) {
            ModMeta meta = null;
            try {
                meta = this.findMeta(this.resolveRoot((Fi)(file.isDirectory() ? file : new ZipFi(file))));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (meta == null || meta.name == null) continue;
            metas.add((Object)meta);
            mapping.put((Object)meta.internalName, (Object)file);
        }
        OrderedMap<String, ModState> resolved = this.resolveDependencies((Seq<ModMeta>)metas);
        for (ObjectMap.Entry entry : resolved) {
            Fi file = (Fi)mapping.get((Object)((String)entry.key));
            boolean steam = Vars.platform.getWorkshopContent(LoadedMod.class).contains((Object)file);
            Log.debug((String)"[Mods] Loading mod @", (Object[])new Object[]{file});
            try {
                LoadedMod mod = this.loadMod(file, false, entry.value == ModState.enabled);
                mod.state = (ModState)((Object)entry.value);
                this.mods.add((Object)mod);
                this.lastOrderedMods = null;
                if (!steam) continue;
                mod.addSteamID(file.name());
            }
            catch (Throwable e) {
                if (e instanceof ClassNotFoundException && e.getMessage().contains("mindustry.plugin.Plugin")) {
                    Log.warn((String)"Plugin '@' is outdated and needs to be ported to v7! Update its main class to inherit from 'mindustry.mod.Plugin'.", (Object[])new Object[]{file.name()});
                    continue;
                }
                if (steam) {
                    Log.err((String)"Failed to load mod workshop file @. Skipping.", (Object[])new Object[]{file});
                    Log.err((Throwable)e);
                    continue;
                }
                Log.err((String)"Failed to load mod file @. Skipping.", (Object[])new Object[]{file});
                Log.err((Throwable)e);
            }
        }
        this.mods.each(this::updateDependencies);
        for (LoadedMod mod : this.mods) {
            if (mod.state != ModState.enabled) continue;
            if (!mod.isSupported()) {
                mod.state = ModState.unsupported;
                continue;
            }
            if (mod.shouldBeEnabled()) continue;
            mod.state = ModState.disabled;
        }
        this.sortMods();
        this.buildFiles();
    }

    private void sortMods() {
        this.mods.sort(Structs.comps((Comparator)Structs.comparingInt(m -> m.state.ordinal()), (Comparator)Structs.comparing(m -> m.name)));
    }

    private void updateDependencies(LoadedMod mod) {
        int i;
        mod.dependencies.clear();
        mod.missingDependencies.clear();
        mod.missingSoftDependencies.clear();
        mod.dependencies = mod.meta.dependencies.map(this::locateMod);
        mod.softDependencies = mod.meta.softDependencies.map(this::locateMod);
        for (i = 0; i < mod.dependencies.size; ++i) {
            if (mod.dependencies.get(i) != null) continue;
            mod.missingDependencies.add((Object)((String)mod.meta.dependencies.get(i)));
        }
        for (i = 0; i < mod.softDependencies.size; ++i) {
            if (mod.softDependencies.get(i) != null) continue;
            mod.missingSoftDependencies.add((Object)((String)mod.meta.softDependencies.get(i)));
        }
    }

    public Seq<LoadedMod> orderedMods() {
        if (this.lastOrderedMods == null) {
            Seq enabled = this.mods.select(LoadedMod::enabled);
            ObjectMap mapping = enabled.asMap(m -> m.meta.internalName);
            this.lastOrderedMods = this.resolveDependencies((Seq<ModMeta>)enabled.map(m -> m.meta)).orderedKeys().map(arg_0 -> ((ObjectMap)mapping).get(arg_0));
        }
        return this.lastOrderedMods;
    }

    public LoadedMod locateMod(String name) {
        return (LoadedMod)this.mods.find(mod -> mod.enabled() && mod.name.equals(name));
    }

    private void buildFiles() {
        for (LoadedMod mod : this.orderedMods()) {
            boolean zipFolder = !mod.file.isDirectory() && mod.root.parent() != null;
            String parentName = zipFolder ? mod.root.name() : null;
            for (Fi file : mod.root.list()) {
                if (!file.isDirectory() || this.specialFolders.contains((Object)file.name())) continue;
                file.walk(f -> Vars.tree.addFile(mod.file.isDirectory() ? f.path().substring(1 + mod.file.path().length()) : (zipFolder ? f.path().substring(parentName.length() + 1) : f.path()), f));
            }
            Fi folder = mod.root.child("bundles");
            if (!folder.exists()) continue;
            for (Fi file : folder.list()) {
                if (!file.name().startsWith("bundle") || !file.extension().equals("properties")) continue;
                String name = file.nameWithoutExtension();
                ((Seq)this.bundles.get((Object)name, Seq::new)).add((Object)file);
            }
        }
        Events.fire((Object)new EventType.FileTreeInitEvent());
        for (I18NBundle bundle = Core.bundle; bundle != null; bundle = bundle.getParent()) {
            String str = bundle.getLocale().toString();
            String locale = "bundle" + (str.isEmpty() ? "" : "_" + str);
            for (Fi file : (Seq)this.bundles.get((Object)locale, Seq::new)) {
                try {
                    PropertiesUtils.load((ObjectMap)bundle.getProperties(), (Reader)file.reader());
                }
                catch (Throwable e) {
                    Log.err((String)("Error loading bundle: " + file + "/" + locale), (Throwable)e);
                }
            }
        }
    }

    private void checkWarnings() {
        Seq toCheck;
        if (this.scripts != null && this.scripts.hasErrored()) {
            Vars.ui.showErrorMessage("@mod.scripts.disable");
        }
        if (this.mods.contains(LoadedMod::hasContentErrors)) {
            Vars.ui.loadfrag.hide();
            new Dialog(""){
                {
                    this.setFillParent(true);
                    this.cont.margin(15.0f);
                    this.cont.add((CharSequence)"@error.title");
                    this.cont.row();
                    this.cont.image().width(300.0f).pad(2.0f).colspan(2).height(4.0f).color(Color.scarlet);
                    this.cont.row();
                    this.cont.add((CharSequence)"@mod.errors").wrap().growX().center().labelAlign(1);
                    this.cont.row();
                    this.cont.pane(p -> Mods.this.mods.each(m -> m.enabled() && m.hasContentErrors(), m -> {
                        p.add((CharSequence)m.name).color(Pal.accent).left();
                        p.row();
                        p.image().fillX().pad(4.0f).color(Pal.accent);
                        p.row();
                        p.table(d -> {
                            d.left().marginLeft(15.0f);
                            for (final Content c : m.erroredContent) {
                                d.add((CharSequence)c.minfo.sourceFile.nameWithoutExtension()).left().padRight(10.0f);
                                d.button("@details", (Drawable)Icon.downOpen, Styles.cleart, () -> new Dialog(""){
                                    {
                                        super(arg0);
                                        this.setFillParent(true);
                                        this.cont.pane(e -> e.add((CharSequence)c2.minfo.error).wrap().grow().labelAlign(1, 8)).grow();
                                        this.cont.row();
                                        this.cont.button("@ok", (Drawable)Icon.left, () -> (this).hide()).size(240.0f, 60.0f);
                                    }
                                }.show()).size(190.0f, 50.0f).left().marginLeft(6.0f);
                                d.row();
                            }
                        }).left();
                        p.row();
                    }));
                    this.cont.row();
                    this.cont.button("@ok", () -> (this).hide()).size(300.0f, 50.0f);
                }
            }.show();
        }
        if (!(toCheck = this.mods.select(mod -> mod.shouldBeEnabled() && mod.hasUnmetDependencies())).isEmpty()) {
            Vars.ui.loadfrag.hide();
            this.checkDependencies((Seq<LoadedMod>)toCheck, false);
        }
    }

    private void checkDependencies(final Seq<LoadedMod> toCheck, final boolean soft) {
        new Dialog(""){
            {
                super(arg0);
                this.setFillParent(true);
                this.cont.margin(15.0f);
                int span = soft ? 3 : 2;
                this.cont.add((CharSequence)"@mod.dependencies.error").colspan(span);
                this.cont.row();
                this.cont.image().width(300.0f).colspan(span).pad(2.0f).height(4.0f).color(Color.scarlet);
                this.cont.row();
                this.cont.pane(p -> toCheck.each(mod -> {
                    p.add((CharSequence)(Core.bundle.get("mods.name") + " [accent]" + mod.meta.displayName)).wrap().growX().left().labelAlign(8);
                    p.row();
                    p.table(d -> {
                        mod.missingDependencies.each(dep -> {
                            d.add((CharSequence)("[lightgray] > []" + dep)).wrap().growX().left().labelAlign(8);
                            d.row();
                        });
                        if (soft) {
                            mod.missingSoftDependencies.each(dep -> {
                                d.add((CharSequence)("[lightgray] > []" + dep + " [lightgray]" + Core.bundle.get("mod.dependencies.soft"))).wrap().growX().left().labelAlign(8);
                                d.row();
                            });
                        }
                    }).growX().padBottom(8.0f).padLeft(8.0f);
                    p.row();
                })).fillX().colspan(span);
                this.cont.row();
                this.cont.button("@cancel", (Drawable)Icon.cancel, () -> (this).hide()).size(160.0f, 50.0f);
                this.cont.button(soft ? "@mod.dependencies.downloadreq" : "@mod.dependencies.download", (Drawable)Icon.download, () -> {
                    this.hide();
                    Seq toImport = new Seq();
                    toCheck.each(mod -> mod.missingDependencies.each(arg_0 -> ((Seq)toImport).addUnique(arg_0)));
                    Mods.this.downloadDependencies((Seq<String>)toImport);
                }).size(160.0f, 50.0f);
                if (soft) {
                    if (Core.graphics.isPortrait()) {
                        this.cont.row();
                    }
                    this.cont.button("@mod.dependencies.downloadall", (Drawable)Icon.download, () -> {
                        this.hide();
                        Seq toImport = new Seq();
                        toCheck.each(mod -> mod.missingDependencies.each(arg_0 -> ((Seq)toImport).addUnique(arg_0)));
                        toCheck.each(mod -> mod.missingSoftDependencies.each(arg_0 -> ((Seq)toImport).addUnique(arg_0)));
                        Mods.this.downloadDependencies((Seq<String>)toImport);
                    }).size(160.0f, 50.0f);
                }
            }
        }.show();
    }

    private void downloadDependencies(Seq<String> toImport) {
        Seq remaining = toImport.copy();
        Vars.ui.mods.importDependencies((Seq<String>)remaining, () -> {
            toImport.removeAll(remaining);
            if (toImport.any()) {
                this.requiresReload = true;
            }
            this.displayDependencyImportStatus((Seq<String>)remaining, toImport);
        });
    }

    private void displayDependencyImportStatus(final Seq<String> failed, final Seq<String> success) {
        new Dialog(""){
            {
                super(arg0);
                this.setFillParent(true);
                this.cont.margin(15.0f);
                this.cont.add((CharSequence)"@mod.dependencies.status").color(Pal.accent).center();
                this.cont.row();
                this.cont.image().width(300.0f).pad(2.0f).height(4.0f).color(Pal.accent);
                this.cont.row();
                this.cont.pane(p -> {
                    if (success.any()) {
                        p.add((CharSequence)"@mod.dependencies.success").color(Pal.accent).wrap().fillX().left().labelAlign(8);
                        p.row();
                        p.table(t -> success.each(d -> {
                            t.add((CharSequence)("[accent] > []" + d)).wrap().growX().left().labelAlign(8);
                            t.row();
                        })).growX().padBottom(8.0f).padLeft(8.0f);
                        p.row();
                    }
                    if (failed.any()) {
                        p.add((CharSequence)"@mod.dependencies.failure").color(Color.scarlet).wrap().fillX().left().labelAlign(8);
                        p.row();
                        p.table(t -> failed.each(d -> {
                            t.add((CharSequence)("[scarlet] > []" + d)).wrap().growX().left().labelAlign(8);
                            t.row();
                        })).growX().padBottom(8.0f).padLeft(8.0f);
                    }
                }).fillX();
                this.cont.row();
                if (success.any()) {
                    this.cont.image().width(300.0f).pad(2.0f).height(4.0f).color(Pal.accent);
                    this.cont.row();
                    this.cont.add((CharSequence)"@mods.reloadexit").center();
                    this.cont.row();
                    this.hidden(() -> {
                        Log.info((Object)"Exiting to reload mods after dependency auto-import.");
                        Core.app.exit();
                    });
                }
                this.cont.button("@ok", () -> (this).hide()).size(300.0f, 50.0f);
                this.closeOnBack();
            }
        }.show();
    }

    public void reload() {
        this.newImports.each(this::updateDependencies);
        this.newImports.removeAll(m -> m.missingDependencies.isEmpty() && m.softDependencies.isEmpty());
        if (this.newImports.any()) {
            this.checkDependencies(this.newImports, this.newImports.contains(m -> m.softDependencies.any()));
        } else {
            Vars.ui.showInfoOnHidden("@mods.reloadexit", () -> {
                Log.info((Object)"Exiting to reload mods.");
                Core.app.exit();
            });
        }
    }

    public boolean hasContentErrors() {
        return this.mods.contains(LoadedMod::hasContentErrors) || this.scripts != null && this.scripts.hasErrored();
    }

    public void loadScripts() {
        if (Vars.skipModCode) {
            return;
        }
        try {
            this.eachEnabled((Cons<LoadedMod>)((Cons)mod -> {
                if (mod.root.child("scripts").exists()) {
                    Fi main;
                    Vars.content.setCurrentMod((LoadedMod)mod);
                    Seq allScripts = mod.root.child("scripts").findAll(f -> f.extEquals("js"));
                    Fi fi = main = allScripts.size == 1 ? (Fi)allScripts.first() : mod.root.child("scripts").child("main.js");
                    if (main.exists() && !main.isDirectory()) {
                        try {
                            if (this.scripts == null) {
                                this.scripts = Vars.platform.createScripts();
                            }
                            this.scripts.run(mod, main);
                        }
                        catch (Throwable e) {
                            Core.app.post(() -> {
                                Log.err((String)"Error loading main script @ for mod @.", (Object[])new Object[]{main.name(), mod.meta.name});
                                Log.err((Throwable)e);
                            });
                        }
                    } else {
                        Core.app.post(() -> Log.err((String)"No main.js found for mod @.", (Object[])new Object[]{mod.meta.name}));
                    }
                }
            }));
        }
        finally {
            Vars.content.setCurrentMod(null);
        }
    }

    public void loadContent() {
        class LoadRun
        implements Comparable<LoadRun> {
            final ContentType type;
            final Fi file;
            final LoadedMod mod;

            public LoadRun(ContentType type, Fi file, LoadedMod mod) {
                this.type = type;
                this.file = file;
                this.mod = mod;
            }

            @Override
            public int compareTo(LoadRun l) {
                int mod = this.mod.name.compareTo(l.mod.name);
                if (mod != 0) {
                    return mod;
                }
                return this.file.name().compareTo(l.file.name());
            }
        }
        for (LoadedMod mod : this.orderedMods()) {
            if (mod.main == null || mod.meta.hidden) continue;
            Vars.content.setCurrentMod(mod);
            mod.main.loadContent();
        }
        Vars.content.setCurrentMod(null);
        Seq runs = new Seq();
        for (LoadedMod mod : this.orderedMods()) {
            ObjectSet orderSet;
            Seq unorderedContent = new Seq();
            ObjectMap orderedContent = new ObjectMap();
            Object[] contentOrder = mod.meta.contentOrder;
            ObjectSet objectSet = orderSet = contentOrder == null ? null : ObjectSet.with((Object[])contentOrder);
            if (mod.root.child("content").exists()) {
                Fi contentRoot = mod.root.child("content");
                ContentType[] contentTypeArray = ContentType.all;
                int n = contentTypeArray.length;
                for (int i = 0; i < n; ++i) {
                    ContentType type = contentTypeArray[i];
                    String lower = type.name().toLowerCase(Locale.ROOT);
                    Fi folder = contentRoot.child(lower + (lower.endsWith("s") ? "" : "s"));
                    if (!folder.exists()) continue;
                    for (Fi file : folder.findAll(f -> f.extension().equals("json") || f.extension().equals("hjson"))) {
                        if (orderSet != null && orderSet.contains((Object)file.nameWithoutExtension())) {
                            orderedContent.put((Object)file.nameWithoutExtension(), (Object)new LoadRun(type, file, mod));
                            continue;
                        }
                        unorderedContent.add((Object)new LoadRun(type, file, mod));
                    }
                }
            }
            if (contentOrder != null) {
                for (Object contentName : contentOrder) {
                    LoadRun run = (LoadRun)orderedContent.get(contentName);
                    if (run != null) {
                        runs.add((Object)run);
                        continue;
                    }
                    Log.warn((String)"Cannot find content defined in contentOrder: @", (Object[])new Object[]{contentName});
                }
            }
            runs.addAll(unorderedContent.sort());
        }
        for (LoadRun l : runs) {
            Content current = Vars.content.getLastAdded();
            try {
                Object object;
                Content loaded = this.parser.parse(l.mod, l.file.nameWithoutExtension(), l.file.readString("UTF-8"), l.file, l.type);
                Object[] objectArray = new Object[2];
                objectArray[0] = l.mod.meta.name;
                if (loaded instanceof UnlockableContent) {
                    UnlockableContent u = (UnlockableContent)loaded;
                    object = u.localizedName;
                } else {
                    object = loaded;
                }
                objectArray[1] = object;
                Log.debug((String)"[@] Loaded '@'.", (Object[])objectArray);
            }
            catch (Throwable e) {
                if (current != Vars.content.getLastAdded() && Vars.content.getLastAdded() != null) {
                    this.parser.markError(Vars.content.getLastAdded(), l.mod, l.file, e);
                    continue;
                }
                ErrorContent error = new ErrorContent();
                this.parser.markError((Content)error, l.mod, l.file, e);
            }
        }
        this.parser.finishParsing();
        Events.fire((Object)new EventType.ModContentLoadEvent());
    }

    public void handleContentError(Content content, Throwable error) {
        this.parser.markError(content, error);
    }

    public void addParseListener(ContentParser.ParseListener hook) {
        this.parser.listeners.add((Object)hook);
    }

    public Seq<String> getModStrings() {
        return this.mods.select(l -> !l.meta.hidden && l.enabled()).map(l -> l.name + ":" + l.meta.version);
    }

    public void setEnabled(LoadedMod mod, boolean enabled) {
        if (mod.enabled() != enabled) {
            Core.settings.put("mod-" + mod.name + "-enabled", (Object)enabled);
            this.requiresReload = true;
            mod.state = enabled ? ModState.enabled : ModState.disabled;
            this.mods.each(this::updateDependencies);
            this.sortMods();
        }
    }

    public Seq<String> getIncompatibility(Seq<String> out) {
        Seq<String> mods = this.getModStrings();
        Seq result = mods.copy();
        for (String mod : mods) {
            if (!out.remove((Object)mod)) continue;
            result.remove((Object)mod);
        }
        return result;
    }

    public Seq<LoadedMod> list() {
        return this.mods;
    }

    public void eachClass(Cons<Mod> cons) {
        this.orderedMods().each(p -> p.main != null, p -> this.contextRun((LoadedMod)p, () -> cons.get((Object)p.main)));
    }

    public void eachEnabled(Cons<LoadedMod> cons) {
        this.orderedMods().each(LoadedMod::enabled, cons);
    }

    public void contextRun(LoadedMod mod, Runnable run) {
        try {
            run.run();
        }
        catch (Throwable t) {
            throw new RuntimeException("Error loading mod " + mod.meta.name, t);
        }
    }

    @Nullable
    public ModMeta findMeta(Fi file) {
        String name;
        Fi metaFile = null;
        String[] stringArray = metaFiles;
        int n = stringArray.length;
        for (int i = 0; i < n && !(metaFile = file.child(name = stringArray[i])).exists(); ++i) {
        }
        if (!metaFile.exists()) {
            return null;
        }
        ModMeta meta = (ModMeta)this.json.fromJson(ModMeta.class, Jval.read((String)metaFile.readString()).toString(Jval.Jformat.plain));
        meta.cleanup();
        return meta;
    }

    public OrderedMap<String, ModState> resolveDependencies(Seq<ModMeta> metas) {
        ModResolutionContext context = new ModResolutionContext();
        for (ModMeta meta : metas) {
            Seq dependencies = new Seq();
            for (String dependency : meta.dependencies) {
                dependencies.add((Object)new ModDependency(dependency, true));
            }
            for (String dependency : meta.softDependencies) {
                dependencies.add((Object)new ModDependency(dependency, false));
            }
            context.dependencies.put((Object)meta.internalName, (Object)dependencies);
        }
        for (String key : context.dependencies.keys()) {
            if (context.ordered.contains((Object)key)) continue;
            this.resolve(key, context);
            context.visited.clear();
        }
        OrderedMap result = new OrderedMap();
        for (String name : context.ordered) {
            result.put((Object)name, (Object)ModState.enabled);
        }
        result.putAll(context.invalid);
        return result;
    }

    private boolean resolve(String element, ModResolutionContext context) {
        context.visited.add((Object)element);
        for (ModDependency dependency : (Seq)context.dependencies.get((Object)element)) {
            if (context.visited.contains((Object)dependency.name) && !context.ordered.contains((Object)dependency.name)) {
                context.invalid.put((Object)dependency.name, (Object)ModState.circularDependencies);
                return false;
            }
            if (context.dependencies.containsKey((Object)dependency.name)) {
                if ((context.ordered.contains((Object)dependency.name) || this.resolve(dependency.name, context)) && Core.settings.getBool("mod-" + dependency.name + "-enabled", true) || !dependency.required) continue;
                context.invalid.put((Object)element, (Object)ModState.incompleteDependencies);
                return false;
            }
            if (!dependency.required) continue;
            context.invalid.put((Object)element, (Object)ModState.missingDependencies);
            return false;
        }
        if (!context.ordered.contains((Object)element)) {
            context.ordered.add((Object)element);
        }
        return true;
    }

    private Fi resolveRoot(Fi fi) {
        Fi[] files;
        if (OS.isMac && !(fi instanceof ZipFi)) {
            fi.child(".DS_Store").delete();
        }
        return (files = fi.list()).length == 1 && files[0].isDirectory() ? files[0] : fi;
    }

    private LoadedMod loadMod(Fi sourceFile, boolean overwrite, boolean initialize) throws Exception {
        Time.mark();
        ZipFi rootZip = null;
        try {
            int line;
            Mod mainMod;
            Fi fi;
            if (sourceFile.isDirectory()) {
                fi = sourceFile;
            } else {
                rootZip = new ZipFi(sourceFile);
                fi = rootZip;
            }
            Fi zip = this.resolveRoot(fi);
            ModMeta meta = this.findMeta(zip);
            if (meta == null) {
                Log.warn((String)"Mod @ doesn't have a '[mod/plugin].[h]json' file, skipping.", (Object[])new Object[]{zip});
                throw new ModLoadException("Invalid file: No mod.json found.");
            }
            String camelized = meta.name.replace(" ", "");
            String mainClass = meta.main == null ? camelized.toLowerCase(Locale.ROOT) + "." + camelized + "Mod" : meta.main;
            String baseName = meta.name.toLowerCase(Locale.ROOT).replace(" ", "-");
            LoadedMod other = (LoadedMod)this.mods.find(m -> m.name.equals(baseName));
            if (other != null) {
                if (overwrite && !other.hasSteamID()) {
                    if (!Vars.android) {
                        ClassLoaderCloser.close((ClassLoader)other.loader);
                    } else if (other.loader != null) {
                        Fi cacheDir = new Fi(Core.files.getCachePath()).child("mods");
                        Fi modCacheDir = cacheDir.child(other.file.nameWithoutExtension());
                        modCacheDir.deleteDirectory();
                    }
                    if (other.root instanceof ZipFi) {
                        other.root.delete();
                    }
                    if (other.file.isDirectory()) {
                        other.file.deleteDirectory();
                    } else {
                        other.file.delete();
                    }
                    this.mods.remove((Object)other);
                } else {
                    throw new ModLoadException("A mod with the name '" + baseName + "' is already imported.");
                }
            }
            ClassLoader loader = null;
            Fi mainFile = zip;
            if (Vars.android) {
                mainFile = mainFile.child("classes.dex");
            } else {
                String[] path;
                for (String str : path = (mainClass.replace('.', '/') + ".class").split("/")) {
                    if (str.isEmpty()) continue;
                    mainFile = mainFile.child(str);
                }
            }
            if ((mainFile.exists() || meta.java) && !this.skipModLoading() && Core.settings.getBool("mod-" + baseName + "-enabled", true) && Version.isAtLeast(meta.minGameVersion) && (meta.getMinMajor() >= 154 || Vars.headless) && !Vars.skipModCode && initialize) {
                if (Vars.ios) {
                    throw new ModLoadException("Java class mods are not supported on iOS.");
                }
                loader = Vars.platform.loadJar(sourceFile, (ClassLoader)this.mainLoader);
                this.mainLoader.addChild(loader);
                Class<?> main = Class.forName(mainClass, true, loader);
                if ((main.getSuperclass().getName().equals("mindustry.mod.Plugin") || main.getSuperclass().getName().equals("mindustry.mod.Mod")) && main.getSuperclass().getClassLoader() != Mod.class.getClassLoader()) {
                    throw new ModLoadException("This mod/plugin has loaded Mindustry dependencies from its own class loader. You are incorrectly including Mindustry dependencies in the mod JAR - make sure Mindustry is declared as `compileOnly` in Gradle, and that the JAR is created with `runtimeClasspath`!");
                }
                this.metas.put(main, (Object)meta);
                mainMod = (Mod)main.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                mainMod = null;
            }
            if (mainMod instanceof Plugin) {
                meta.hidden = true;
            }
            if (meta.version != null && (line = meta.version.indexOf(10)) != -1) {
                meta.version = meta.version.substring(0, line);
            }
            if (this.skipModLoading()) {
                Core.settings.put("mod-" + baseName + "-enabled", (Object)false);
            }
            if (!Vars.headless && Core.settings.getBool("mod-" + baseName + "-enabled", true)) {
                Log.info((String)"Loaded mod '@' in @ms", (Object[])new Object[]{meta.name, Float.valueOf(Time.elapsed())});
            }
            return new LoadedMod(sourceFile, zip, mainMod, loader, meta);
        }
        catch (Exception e) {
            if (rootZip != null) {
                rootZip.delete();
            }
            throw e;
        }
    }

    public static class ModMeta {
        public String name;
        public String internalName;
        public String minGameVersion = "0";
        @Nullable
        public String displayName;
        @Nullable
        public String author;
        @Nullable
        public String description;
        @Nullable
        public String subtitle;
        @Nullable
        public String version;
        @Nullable
        public String main;
        @Nullable
        public String repo;
        public Seq<String> dependencies = Seq.with((Object[])new String[0]);
        public Seq<String> softDependencies = Seq.with((Object[])new String[0]);
        public boolean hidden;
        public boolean java;
        public float texturescale = 1.0f;
        public boolean pregenerated;
        public String[] contentOrder;

        public String shortDescription() {
            return Strings.truncate((String)(this.subtitle == null ? (this.description == null || this.description.length() > 40 ? "" : this.description) : this.subtitle), (int)40, (String)"...");
        }

        public void cleanup() {
            if (this.name != null) {
                this.name = Strings.stripColors((CharSequence)this.name);
            }
            if (this.displayName != null) {
                this.displayName = Strings.stripColors((CharSequence)this.displayName);
            }
            if (this.displayName == null) {
                this.displayName = this.name;
            }
            if (this.version == null) {
                this.version = "0";
            }
            if (this.author != null) {
                this.author = Strings.stripColors((CharSequence)this.author);
            }
            if (this.description != null) {
                this.description = Strings.stripColors((CharSequence)this.description);
            }
            if (this.subtitle != null) {
                this.subtitle = Strings.stripColors((CharSequence)this.subtitle).replace("\n", "");
            }
            if (this.name != null) {
                this.internalName = this.name.toLowerCase(Locale.ROOT).replace(" ", "-");
            }
        }

        public int getMinMajor() {
            String ver = this.minGameVersion == null ? "0" : this.minGameVersion;
            int dot = ver.indexOf(".");
            return dot != -1 ? Strings.parseInt((String)ver.substring(0, dot), (int)0) : Strings.parseInt((String)ver, (int)0);
        }

        public String toString() {
            return "ModMeta{name='" + this.name + '\'' + ", minGameVersion='" + this.minGameVersion + '\'' + ", displayName='" + this.displayName + '\'' + ", author='" + this.author + '\'' + ", description='" + this.description + '\'' + ", subtitle='" + this.subtitle + '\'' + ", version='" + this.version + '\'' + ", main='" + this.main + '\'' + ", repo='" + this.repo + '\'' + ", dependencies=" + this.dependencies + ", softDependencies=" + this.softDependencies + ", hidden=" + this.hidden + ", java=" + this.java + ", texturescale=" + this.texturescale + ", pregenerated=" + this.pregenerated + '}';
        }
    }

    public static class LoadedMod
    implements Publishable,
    Disposable {
        public final Fi file;
        public final Fi root;
        @Nullable
        public final Mod main;
        public final String name;
        public final ModMeta meta;
        public Seq<LoadedMod> dependencies = new Seq();
        public Seq<LoadedMod> softDependencies = new Seq();
        public Seq<String> missingDependencies = new Seq();
        public Seq<String> missingSoftDependencies = new Seq();
        public ObjectSet<Content> erroredContent = new ObjectSet();
        public ModState state = ModState.enabled;
        @Nullable
        public Texture iconTexture;
        @Nullable
        public ClassLoader loader;

        public LoadedMod(Fi file, Fi root, Mod main, ClassLoader loader, ModMeta meta) {
            this.root = root;
            this.file = file;
            this.loader = loader;
            this.main = main;
            this.meta = meta;
            this.name = meta.name.toLowerCase(Locale.ROOT).replace(" ", "-");
        }

        public boolean isJava() {
            return this.meta.java || this.main != null || this.meta.main != null;
        }

        @Nullable
        public String getRepo() {
            return Core.settings.getString("mod-" + this.name + "-repo", this.meta.repo);
        }

        public void setRepo(String repo) {
            Core.settings.put("mod-" + this.name + "-repo", (Object)repo);
        }

        public boolean enabled() {
            return this.state == ModState.enabled || this.state == ModState.contentErrors;
        }

        public boolean shouldBeEnabled() {
            return Core.settings.getBool("mod-" + this.name + "-enabled", true);
        }

        public boolean hasUnmetDependencies() {
            return !this.missingDependencies.isEmpty();
        }

        public boolean hasContentErrors() {
            return !this.erroredContent.isEmpty();
        }

        public boolean isSupported() {
            if (Vars.headless) {
                return true;
            }
            if (this.isOutdated() || this.isBlacklisted()) {
                return false;
            }
            return Version.isAtLeast(this.meta.minGameVersion);
        }

        public boolean isBlacklisted() {
            return blacklistedMods.contains((Object)this.name);
        }

        public boolean isOutdated() {
            return this.getMinMajor() < (this.isJava() ? 154 : 136);
        }

        public int getMinMajor() {
            return this.meta.getMinMajor();
        }

        public void dispose() {
            if (this.iconTexture != null) {
                this.iconTexture.dispose();
                this.iconTexture = null;
            }
        }

        public String getSteamID() {
            return Core.settings.getString(this.name + "-steamid", null);
        }

        public void addSteamID(String id) {
            Core.settings.put(this.name + "-steamid", (Object)id);
        }

        public void removeSteamID() {
            Core.settings.remove(this.name + "-steamid");
        }

        public String steamTitle() {
            return this.meta.name;
        }

        public String steamDescription() {
            return this.meta.description;
        }

        public String steamTag() {
            return "mod";
        }

        public Fi createSteamFolder(String id) {
            return this.file;
        }

        public Fi createSteamPreview(String id) {
            return this.file.child("preview.png");
        }

        public boolean prePublish() {
            if (!this.file.isDirectory()) {
                Vars.ui.showErrorMessage("@mod.folder.missing");
                return false;
            }
            if (!this.file.child("preview.png").exists()) {
                Vars.ui.showErrorMessage("@mod.preview.missing");
                return false;
            }
            return true;
        }

        public String toString() {
            return "LoadedMod{file=" + this.file + ", root=" + this.root + ", name='" + this.name + '\'' + '}';
        }
    }

    public static enum ModState {
        enabled,
        contentErrors,
        missingDependencies,
        incompleteDependencies,
        circularDependencies,
        unsupported,
        disabled;

    }

    public static class ModResolutionContext {
        public final ObjectMap<String, Seq<ModDependency>> dependencies = new ObjectMap();
        public final ObjectSet<String> visited = new ObjectSet();
        public final OrderedSet<String> ordered = new OrderedSet();
        public final ObjectMap<String, ModState> invalid = new OrderedMap();
    }

    public static final class ModDependency {
        public final String name;
        public final boolean required;

        public ModDependency(String name, boolean required) {
            this.name = name;
            this.required = required;
        }
    }

    public static class ModLoadException
    extends RuntimeException {
        public ModLoadException(String message) {
            super(message);
        }
    }
}

