/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.Core;
import arc.func.Cons;
import arc.func.Prov;
import arc.graphics.Color;
import arc.math.Interp;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.util.Nullable;
import arc.util.Reflect;
import java.lang.reflect.Field;
import mindustry.Vars;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.MapObjectives;
import mindustry.gen.Icon;
import mindustry.graphics.Layer;
import mindustry.graphics.Pal;
import mindustry.logic.ConditionOp;
import mindustry.logic.CutsceneAction;
import mindustry.logic.FetchType;
import mindustry.logic.GlobalVars;
import mindustry.logic.LAccess;
import mindustry.logic.LAssembler;
import mindustry.logic.LCanvas;
import mindustry.logic.LCategory;
import mindustry.logic.LExecutor;
import mindustry.logic.LLocate;
import mindustry.logic.LMarkerControl;
import mindustry.logic.LStatement;
import mindustry.logic.LUnitControl;
import mindustry.logic.LogicFx;
import mindustry.logic.LogicOp;
import mindustry.logic.LogicRule;
import mindustry.logic.MessageType;
import mindustry.logic.RadarSort;
import mindustry.logic.RadarTarget;
import mindustry.logic.TileLayer;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.type.UnitType;
import mindustry.type.Weather;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.logic.LogicDisplay;
import mindustry.world.meta.BlockFlag;
import mindustryX.features.UIExt;

public class LStatements {

    public static class LocalePrintStatement
    extends LStatement {
        public String value = "\"name\"";

        public void build(Table table2) {
            this.field(table2, this.value, str -> {
                this.value = str;
            }).width(0.0f).growX().padRight(3.0f);
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.LocalePrintI(builder.var(this.value));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class MakeMarkerStatement
    extends LStatement {
        public String type = "shape";
        public String id = "0";
        public String x = "0";
        public String y = "0";
        public String replace = "true";

        public void build(Table table2) {
            table2.clearChildren();
            table2.button(b -> {
                b.label(() -> this.type);
                b.clicked(() -> this.showSelect((Button)b, (String[])MapObjectives.allMarkerTypeNames.toArray(String.class), this.type, t -> {
                    this.type = t;
                    this.build(table2);
                }, 2, cell -> cell.size(160.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(190.0f, 40.0f).color(table2.color).left().padLeft(2.0f);
            this.fieldst(table2, "id", this.id, str -> {
                this.id = str;
            });
            this.row(table2);
            this.fieldst(table2, "x", this.x, v -> {
                this.x = v;
            });
            this.fieldst(table2, "y", this.y, v -> {
                this.y = v;
            });
            this.row(table2);
            this.fieldst(table2, "replace", this.replace, v -> {
                this.replace = v;
            });
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.MakeMarkerI(this.type, builder.var(this.id), builder.var(this.x), builder.var(this.y), builder.var(this.replace));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class SetMarkerStatement
    extends LStatement {
        public LMarkerControl type = LMarkerControl.pos;
        public String id = "0";
        public String p1 = "0";
        public String p2 = "0";
        public String p3 = "0";

        public void build(Table table2) {
            this.rebuild(table2);
        }

        void rebuild(Table table2) {
            table2.clearChildren();
            table2.add((CharSequence)"set");
            table2.button(b -> {
                b.label(() -> this.type.name());
                b.clicked(() -> this.showSelect((Button)b, LMarkerControl.all, this.type, t -> {
                    this.type = t;
                    this.rebuild(table2);
                }, 3, cell -> cell.size(140.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(190.0f, 40.0f).color(table2.color).left().padLeft(2.0f);
            this.row(table2);
            this.fieldst(table2, "of id#", this.id, str -> {
                this.id = str;
            });
            for (int f = 0; f < this.type.params.length; ++f) {
                int i = f;
                table2.table(t -> {
                    String value;
                    t.setColor(table2.color);
                    String string = i == 0 ? this.p1 : (value = i == 1 ? this.p2 : this.p3);
                    Cons setter = i == 0 ? v -> {
                        this.p1 = v;
                    } : (i == 1 ? v -> {
                        this.p2 = v;
                    } : v -> {
                        this.p3 = v;
                    });
                    this.fields((Table)t, this.type.params[i], value, setter).width(100.0f);
                    if (this.type == LMarkerControl.color || this.type == LMarkerControl.colori && i == 1) {
                        this.col((Table)t, value, res -> {
                            setter.get((Object)("%" + res.toString().substring(0, res.a >= 1.0f ? 6 : 8)));
                            this.build(table2);
                        });
                    } else if (this.type == LMarkerControl.drawLayer) {
                        t.button(b -> {
                            b.image((Drawable)Icon.pencilSmall);
                            b.clicked(() -> SetMarkerStatement.showSelectTable((Button)b, (o, hide) -> {
                                o.row();
                                o.table(s -> {
                                    s.left();
                                    for (Field field : Layer.class.getFields()) {
                                        float layer = ((Float)Reflect.get((Field)field)).floatValue();
                                        s.button(field.getName() + " = " + layer, Styles.logicTogglet, () -> {
                                            this.p1 = Float.toString(layer);
                                            this.rebuild(table2);
                                            hide.run();
                                        }).size(240.0f, 40.0f).row();
                                    }
                                }).width(240.0f).left();
                            }));
                        }, (Button.ButtonStyle)Styles.logict, () -> {}).size(40.0f).padLeft(-11.0f).color(table2.color);
                    } else if (this.type == LMarkerControl.textAlign || this.type == LMarkerControl.lineAlign) {
                        this.fieldAlignSelect((Table)t, () -> this.p1, v -> {
                            this.p1 = v;
                            this.rebuild(table2);
                        }, true, this.type != LMarkerControl.lineAlign);
                    }
                });
                if (i == 0) {
                    this.row(table2);
                }
                if (i != 2) continue;
                table2.row();
            }
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SetMarkerI(this.type, builder.var(this.id), builder.var(this.p1), builder.var(this.p2), builder.var(this.p3));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class PlaySoundStatement
    extends LStatement {
        public boolean positional;
        public String id = "@sfx-pew";
        public String volume = "1";
        public String pitch = "1";
        public String pan = "0";
        public String x = "@thisx";
        public String y = "@thisy";
        public String limit = "true";

        public void build(Table table2) {
            this.rebuild(table2);
        }

        void rebuild(Table table2) {
            table2.clearChildren();
            table2.button(this.positional ? "positional" : "global", Styles.logict, () -> {
                this.positional = !this.positional;
                this.rebuild(table2);
            }).size(160.0f, 40.0f).pad(4.0f).color(table2.color);
            this.row(table2);
            this.field(table2, this.id, str -> {
                this.id = str;
            }).padRight(0.0f).get();
            table2.button(b -> {
                b.image((Drawable)Icon.pencilSmall);
                String soundName = this.id.startsWith("@sfx-") ? this.id.substring(5) : this.id;
                b.clicked(() -> this.showSelect((Button)b, (String[])GlobalVars.soundNames.toArray(String.class), soundName, t -> {
                    this.id = "@sfx-" + t;
                    this.rebuild(table2);
                }, 2, cell -> cell.size(160.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(40.0f).color(table2.color).left().padLeft(-1.0f);
            this.row(table2);
            this.fieldst(table2, "volume", this.volume, str -> {
                this.volume = str;
            });
            this.fieldst(table2, "pitch", this.pitch, str -> {
                this.pitch = str;
            });
            table2.row();
            if (this.positional) {
                this.fieldst(table2, "x", this.x, str -> {
                    this.x = str;
                });
                this.fieldst(table2, "y", this.y, str -> {
                    this.y = str;
                });
            } else {
                this.fieldst(table2, "pan", this.pan, str -> {
                    this.pan = str;
                });
            }
            table2.row();
            this.fieldst(table2, "limit", this.limit, str -> {
                this.limit = str;
            });
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.PlaySoundI(this.positional, builder.var(this.id), builder.var(this.volume), builder.var(this.pitch), builder.var(this.pan), builder.var(this.x), builder.var(this.y), builder.var(this.limit));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class SetPropStatement
    extends LStatement {
        public String type = "@copper";
        public String of = "block1";
        public String value = "0";
        private transient int selected = 0;
        private transient TextField tfield;

        public void build(Table table2) {
            table2.add((CharSequence)" set ");
            this.tfield = (TextField)this.field(table2, this.type, str -> {
                this.type = str;
            }).padRight(0.0f).get();
            table2.button(b -> {
                b.image((Drawable)Icon.pencilSmall);
                b.clicked(() -> SetPropStatement.showSelectTable((Button)b, (t, hide) -> {
                    Table[] tables = new Table[]{new Table(i -> {
                        i.left();
                        int c = 0;
                        for (Item item : Vars.content.items()) {
                            if (item.hidden) continue;
                            i.button((Drawable)new TextureRegionDrawable(item.uiIcon), Styles.flati, 24.0f, () -> {
                                this.stype("@" + item.name);
                                hide.run();
                            }).size(40.0f);
                            if (++c % 6 != 0) continue;
                            i.row();
                        }
                    }), new Table(i -> {
                        i.left();
                        int c = 0;
                        for (Liquid item : Vars.content.liquids()) {
                            if (!item.unlockedNow() || item.hidden) continue;
                            i.button((Drawable)new TextureRegionDrawable(item.uiIcon), Styles.flati, 24.0f, () -> {
                                this.stype("@" + item.name);
                                hide.run();
                            }).size(40.0f);
                            if (++c % 6 != 0) continue;
                            i.row();
                        }
                    }), new Table(i -> {
                        for (LAccess property : LAccess.settable) {
                            i.button(property.name(), Styles.flatt, () -> {
                                this.stype("@" + property.name());
                                hide.run();
                            }).size(240.0f, 40.0f).self(c -> LCanvas.tooltip(c, property)).row();
                        }
                    })};
                    Drawable[] icons = new Drawable[]{Icon.box, Icon.liquid, Icon.tree};
                    Stack stack = new Stack(new Element[]{tables[this.selected]});
                    ButtonGroup group = new ButtonGroup();
                    for (int i2 = 0; i2 < tables.length; ++i2) {
                        int fi = i2;
                        t.button(icons[i2], Styles.squareTogglei, () -> {
                            this.selected = fi;
                            stack.clearChildren();
                            stack.addChild((Element)tables[this.selected]);
                            t.parent.parent.pack();
                            t.parent.parent.invalidateHierarchy();
                        }).height(50.0f).growX().checked(this.selected == fi).group(group);
                    }
                    t.row();
                    t.add((Element)stack).colspan(3).width(240.0f).left();
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(40.0f).padLeft(-1.0f).color(table2.color);
            this.row(table2);
            table2.add((CharSequence)" of ").self(arg_0 -> ((SetPropStatement)this).param(arg_0));
            this.field(table2, this.of, str -> {
                this.of = str;
            }).colspan(2);
            this.row(table2);
            table2.add((CharSequence)" to ");
            this.field(table2, this.value, str -> {
                this.value = str;
            }).colspan(2);
        }

        private void stype(String text) {
            this.tfield.setText(text);
            this.type = text;
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SetPropI(builder.var(this.type), builder.var(this.of), builder.var(this.value));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class SetFlagStatement
    extends LStatement {
        public String flag = "\"flag\"";
        public String value = "true";

        public void build(Table table2) {
            float width = LCanvas.useRows() ? 100.0f : 190.0f;
            this.fields(table2, this.flag, str -> {
                this.flag = str;
            }).width(width);
            table2.add((CharSequence)" = ");
            this.fields(table2, this.value, str -> {
                this.value = str;
            }).width(width);
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SetFlagI(builder.var(this.flag), builder.var(this.value));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class GetFlagStatement
    extends LStatement {
        public String result = "result";
        public String flag = "\"flag\"";

        public void build(Table table2) {
            float width = LCanvas.useRows() ? 100.0f : 190.0f;
            this.fields(table2, this.result, str -> {
                this.result = str;
            }).width(width);
            table2.add((CharSequence)" = flag ");
            this.fields(table2, this.flag, str -> {
                this.flag = str;
            }).width(width);
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.GetFlagI(builder.var(this.result), builder.var(this.flag));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class ClientDataStatement
    extends LStatement {
        public String channel = "\"frog\"";
        public String value = "\"bar\"";
        public String reliable = "0";

        public void build(Table table2) {
            table2.add((CharSequence)"send ");
            this.fields(table2, this.value, str -> {
                this.value = str;
            });
            table2.add((CharSequence)" on ");
            this.fields(table2, this.channel, str -> {
                this.channel = str;
            });
            table2.add((CharSequence)", reliable ");
            this.fields(table2, this.reliable, str -> {
                this.reliable = str;
            });
        }

        public boolean hidden() {
            return true;
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            if (!Vars.state.rules.allowLogicData) {
                return null;
            }
            return new LExecutor.ClientDataI(builder.var(this.channel), builder.var(this.value), builder.var(this.reliable));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class SyncStatement
    extends LStatement {
        public String variable = "var";

        public void build(Table table2) {
            this.fields(table2, this.variable, str -> {
                this.variable = str;
            }).width(190.0f);
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SyncI(builder.var(this.variable));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class FetchStatement
    extends LStatement {
        public FetchType type = FetchType.unit;
        public String result = "result";
        public String team = "@sharded";
        public String index = "0";
        public String extra = "@conveyor";

        public void build(Table table2) {
            this.rebuild(table2);
        }

        void rebuild(Table table2) {
            table2.clearChildren();
            this.fields(table2, this.result, r -> {
                this.result = r;
            });
            table2.add((CharSequence)" = ");
            table2.button(b -> {
                b.label(() -> this.type.name()).growX().wrap().labelAlign(1);
                b.clicked(() -> this.showSelect((Button)b, FetchType.all, this.type, o -> {
                    this.type = o;
                    this.rebuild(table2);
                }, 2, c -> c.width(150.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(160.0f, 40.0f).margin(5.0f).pad(4.0f).color(table2.color);
            this.row(table2);
            this.fields(table2, "team", this.team, s -> {
                this.team = s;
            });
            if (this.type != FetchType.coreCount && this.type != FetchType.playerCount && this.type != FetchType.unitCount && this.type != FetchType.buildCount) {
                table2.add((CharSequence)" # ");
                this.row(table2);
                this.fields(table2, this.index, i -> {
                    this.index = i;
                });
            }
            if (this.type == FetchType.buildCount || this.type == FetchType.build) {
                this.row(table2);
                this.fields(table2, "block", this.extra, i -> {
                    this.extra = i;
                });
            }
            if (this.type == FetchType.unitCount || this.type == FetchType.unit) {
                this.row(table2);
                this.fields(table2, "unit", this.extra, i -> {
                    this.extra = i;
                });
            }
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.FetchI(this.type, builder.var(this.result), builder.var(this.team), builder.var(this.extra), builder.var(this.index));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class SetRateStatement
    extends LStatement {
        public String amount = "10";

        public void build(Table table2) {
            this.fields(table2, "ipt = ", this.amount, str -> {
                this.amount = str;
            });
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SetRateI(builder.var(this.amount));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class ExplosionStatement
    extends LStatement {
        public String team = "@crux";
        public String x = "0";
        public String y = "0";
        public String radius = "5";
        public String damage = "50";
        public String air = "true";
        public String ground = "true";
        public String pierce = "false";
        public String effect = "true";

        public void build(Table table2) {
            this.fields(table2, "team", this.team, str -> {
                this.team = str;
            });
            this.fields(table2, "x", this.x, str -> {
                this.x = str;
            });
            this.row(table2);
            this.fields(table2, "y", this.y, str -> {
                this.y = str;
            });
            this.fields(table2, "radius", this.radius, str -> {
                this.radius = str;
            });
            table2.row();
            this.fields(table2, "damage", this.damage, str -> {
                this.damage = str;
            });
            this.fields(table2, "air", this.air, str -> {
                this.air = str;
            });
            this.row(table2);
            this.fields(table2, "ground", this.ground, str -> {
                this.ground = str;
            });
            this.fields(table2, "pierce", this.pierce, str -> {
                this.pierce = str;
            });
            table2.row();
            this.fields(table2, "effect", this.effect, str -> {
                this.effect = str;
            });
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler b) {
            return new LExecutor.ExplosionI(b.var(this.team), b.var(this.x), b.var(this.y), b.var(this.radius), b.var(this.damage), b.var(this.air), b.var(this.ground), b.var(this.pierce), b.var(this.effect));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class EffectStatement
    extends LStatement {
        public String type = "warn";
        public String x = "0";
        public String y = "0";
        public String sizerot = "2";
        public String color = "%ffaaff";
        public String data = "";

        public void build(Table table2) {
            table2.clearChildren();
            table2.button(b -> {
                b.label(() -> this.type).growX().wrap().labelAlign(1);
                b.clicked(() -> Vars.ui.effects.show(entry -> {
                    this.type = entry.name;
                    this.build(table2);
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(150.0f, 40.0f).margin(5.0f).pad(4.0f).color(table2.color).colspan(2);
            LogicFx.EffectEntry entry = LogicFx.get((String)this.type);
            this.row(table2);
            this.fields(table2, "x", this.x, str -> {
                this.x = str;
            });
            this.fields(table2, "y", this.y, str -> {
                this.y = str;
            });
            this.row(table2);
            if (entry != null) {
                if (entry.color) {
                    this.fields(table2, "color", this.color, str -> {
                        this.color = str;
                    }).width(120.0f);
                    this.col(table2, this.color, res -> {
                        this.color = "%" + res.toString().substring(0, res.a >= 1.0f ? 6 : 8);
                        this.build(table2);
                    });
                }
                this.row(table2);
                if (entry.size || entry.rotate) {
                    this.fields(table2, entry.size ? "size" : "rotation", this.sizerot, str -> {
                        this.sizerot = str;
                    });
                }
                if (entry.data != null) {
                    this.fields(table2, "data", this.data, str -> {
                        this.data = str;
                    });
                }
            }
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler b) {
            return new LExecutor.EffectI(LogicFx.get((String)this.type), b.var(this.x), b.var(this.y), b.var(this.sizerot), b.var(this.color), b.var(this.data));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class CutsceneStatement
    extends LStatement {
        public CutsceneAction action = CutsceneAction.pan;
        public String p1 = "100";
        public String p2 = "100";
        public String p3 = "0.06";
        public String p4 = "0";

        public void build(Table table2) {
            this.rebuild(table2);
        }

        void rebuild(Table table2) {
            table2.clearChildren();
            table2.button(b -> {
                b.label(() -> this.action.name()).growX().wrap().labelAlign(1);
                b.clicked(() -> this.showSelect((Button)b, CutsceneAction.all, this.action, o -> {
                    this.action = o;
                    this.rebuild(table2);
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(90.0f, 40.0f).padLeft(2.0f).color(table2.color);
            switch (this.action) {
                case pan: {
                    table2.add((CharSequence)" x ");
                    this.fields(table2, this.p1, str -> {
                        this.p1 = str;
                    });
                    table2.add((CharSequence)" y ");
                    this.fields(table2, this.p2, str -> {
                        this.p2 = str;
                    });
                    this.row(table2);
                    table2.add((CharSequence)" speed ");
                    this.fields(table2, this.p3, str -> {
                        this.p3 = str;
                    });
                    break;
                }
                case zoom: {
                    table2.add((CharSequence)" level ");
                    this.fields(table2, this.p1, str -> {
                        this.p1 = str;
                    });
                }
            }
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.CutsceneI(this.action, builder.var(this.p1), builder.var(this.p2), builder.var(this.p3), builder.var(this.p4));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class FlushMessageStatement
    extends LStatement {
        public MessageType type = MessageType.announce;
        public String duration = "3";
        public String outSuccess = "@wait";

        public void build(Table table2) {
            this.rebuild(table2);
        }

        void rebuild(Table table2) {
            table2.clearChildren();
            table2.button(b -> {
                b.label(() -> this.type.name()).growX().wrap().labelAlign(1);
                b.clicked(() -> this.showSelect((Button)b, MessageType.all, this.type, o -> {
                    this.type = o;
                    this.rebuild(table2);
                }, 2, c -> c.width(150.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(160.0f, 40.0f).padLeft(2.0f).color(table2.color);
            switch (this.type) {
                case announce: 
                case toast: {
                    table2.add((CharSequence)" for ");
                    this.fields(table2, this.duration, str -> {
                        this.duration = str;
                    });
                    table2.add((CharSequence)" sec ");
                }
            }
            this.row(table2);
            table2.add((CharSequence)" success ");
            this.fields(table2, this.outSuccess, str -> {
                this.outSuccess = str;
            });
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.FlushMessageI(this.type, builder.var(this.duration), builder.var(this.outSuccess));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class SetRuleStatement
    extends LStatement {
        public LogicRule rule = LogicRule.waveSpacing;
        public String value = "10";
        public String p1 = "0";
        public String p2 = "0";
        public String p3 = "100";
        public String p4 = "100";

        public void build(Table table2) {
            this.rebuild(table2);
        }

        void rebuild(Table table2) {
            table2.clearChildren();
            table2.button(b -> {
                b.label(() -> this.rule.name()).growX().wrap().labelAlign(1);
                b.clicked(() -> this.showSelect((Button)b, LogicRule.all, this.rule, o -> {
                    this.rule = o;
                    this.rebuild(table2);
                }, 2, c -> c.width(150.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(160.0f, 40.0f).margin(5.0f).pad(4.0f).color(table2.color);
            switch (this.rule) {
                case mapArea: {
                    table2.add((CharSequence)" = ");
                    this.row(table2);
                    this.fields(table2, "x", this.p1, s -> {
                        this.p1 = s;
                    });
                    this.fields(table2, "y", this.p2, s -> {
                        this.p2 = s;
                    });
                    this.row(table2);
                    this.fields(table2, "w", this.p3, s -> {
                        this.p3 = s;
                    });
                    this.fields(table2, "h", this.p4, s -> {
                        this.p4 = s;
                    });
                    break;
                }
                case buildSpeed: 
                case unitHealth: 
                case unitBuildSpeed: 
                case unitMineSpeed: 
                case unitCost: 
                case unitDamage: 
                case blockHealth: 
                case blockDamage: 
                case rtsMinSquad: 
                case rtsMinWeight: {
                    if (this.p1.equals("0")) {
                        this.p1 = "@sharded";
                    }
                    this.fields(table2, "of", this.p1, s -> {
                        this.p1 = s;
                    });
                    table2.add((CharSequence)" = ");
                    this.row(table2);
                    this.field(table2, this.value, s -> {
                        this.value = s;
                    });
                    break;
                }
                case ban: 
                case unban: {
                    table2.add((CharSequence)" block/unit ");
                    this.fields(table2, this.value, s -> {
                        this.value = s;
                    });
                    break;
                }
                default: {
                    table2.add((CharSequence)" = ");
                    this.field(table2, this.value, s -> {
                        this.value = s;
                    });
                }
            }
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SetRuleI(this.rule, builder.var(this.value), builder.var(this.p1), builder.var(this.p2), builder.var(this.p3), builder.var(this.p4));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class SpawnWaveStatement
    extends LStatement {
        public String x = "10";
        public String y = "10";
        public String natural = "false";

        public void build(Table table2) {
            table2.add((CharSequence)"natural ");
            this.fields(table2, this.natural, str -> {
                this.natural = str;
            });
            table2.add((CharSequence)"x ").visible(() -> !this.natural.equals("true"));
            this.fields(table2, this.x, str -> {
                this.x = str;
            }).visible(() -> !this.natural.equals("true"));
            table2.add((CharSequence)" y ").visible(() -> !this.natural.equals("true"));
            this.fields(table2, this.y, str -> {
                this.y = str;
            }).visible(() -> !this.natural.equals("true"));
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SpawnWaveI(builder.var(this.natural), builder.var(this.x), builder.var(this.y));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class WeatherSetStatement
    extends LStatement {
        public String weather = "@rain";
        public String state = "true";
        private transient TextField tfield;

        public void build(Table table2) {
            table2.add((CharSequence)" set weather ");
            this.tfield = (TextField)this.field(table2, this.weather, str -> {
                this.weather = str;
            }).padRight(0.0f).get();
            table2.button(b -> {
                b.image((Drawable)Icon.pencilSmall);
                b.clicked(() -> WeatherSetStatement.showSelectTable((Button)b, (t, hide) -> {
                    t.row();
                    t.table(i -> {
                        i.left();
                        int c = 0;
                        for (Weather w : Vars.content.weathers()) {
                            i.button(w.name, Styles.flatt, () -> {
                                this.weather = "@" + w.name;
                                this.tfield.setText(this.weather);
                                hide.run();
                            }).height(40.0f).uniformX().wrapLabel(false).growX();
                            if (++c % 2 != 0) continue;
                            i.row();
                        }
                    }).left();
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(40.0f).padLeft(-1.0f).color(table2.color);
            table2.add((CharSequence)" state ");
            this.fields(table2, this.state, str -> {
                this.state = str;
            });
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SetWeatherI(builder.var(this.weather), builder.var(this.state));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class WeatherSenseStatement
    extends LStatement {
        public String to = "result";
        public String weather = "@rain";
        private transient TextField tfield;

        public void build(Table table2) {
            this.field(table2, this.to, str -> {
                this.to = str;
            });
            table2.add((CharSequence)" = weather ");
            this.row(table2);
            this.tfield = (TextField)this.field(table2, this.weather, str -> {
                this.weather = str;
            }).padRight(0.0f).get();
            table2.button(b -> {
                b.image((Drawable)Icon.pencilSmall);
                b.clicked(() -> WeatherSenseStatement.showSelectTable((Button)b, (t, hide) -> {
                    t.row();
                    t.table(i -> {
                        i.left();
                        int c = 0;
                        for (Weather w : Vars.content.weathers()) {
                            i.button(w.name, Styles.flatt, () -> {
                                this.weather = "@" + w.name;
                                this.tfield.setText(this.weather);
                                hide.run();
                            }).height(40.0f).uniformX().wrapLabel(false).growX();
                            if (++c % 2 != 0) continue;
                            i.row();
                        }
                    }).left();
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(40.0f).padLeft(-1.0f).color(table2.color);
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SenseWeatherI(builder.var(this.weather), builder.var(this.to));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class ApplyStatusStatement
    extends LStatement {
        public boolean clear;
        public String effect = "wet";
        public String unit = "unit";
        public String duration = "10";
        @Nullable
        private static String[] statusNames;

        public void build(Table table2) {
            table2.clearChildren();
            table2.button(this.clear ? "clear" : "apply", Styles.logict, () -> {
                this.clear = !this.clear;
                this.build(table2);
            }).size(80.0f, 40.0f).pad(4.0f).color(table2.color);
            if (statusNames == null) {
                statusNames = (String[])Vars.content.statusEffects().select(s -> !s.isHidden()).map(s -> s.name).toArray(String.class);
            }
            table2.button(b -> {
                b.label(() -> this.effect).grow().wrap().labelAlign(1).center();
                b.clicked(() -> this.showSelect((Button)b, statusNames, this.effect, o -> {
                    this.effect = o;
                    this.build(table2);
                }, 2, c -> c.size(120.0f, 38.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(120.0f, 40.0f).pad(4.0f).color(table2.color);
            table2.add((CharSequence)(this.clear ? " from " : " to "));
            this.row(table2);
            this.fields(table2, this.unit, str -> {
                this.unit = str;
            });
            if (!(this.clear || Vars.content.statusEffect(this.effect) != null && Vars.content.statusEffect((String)this.effect).permanent)) {
                table2.add((CharSequence)" for ");
                this.fields(table2, this.duration, str -> {
                    this.duration = str;
                });
                table2.add((CharSequence)" sec");
            }
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.ApplyEffectI(this.clear, this.effect, builder.var(this.unit), builder.var(this.duration));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class SpawnUnitStatement
    extends LStatement {
        public String type = "@dagger";
        public String x = "10";
        public String y = "10";
        public String rotation = "90";
        public String team = "@sharded";
        public String result = "result";

        public void build(Table table2) {
            this.fields(table2, this.result, str -> {
                this.result = str;
            });
            table2.add((CharSequence)" = spawn ");
            this.field(table2, this.type, str -> {
                this.type = str;
            }).colspan(!LCanvas.useRows() ? 1 : 2);
            this.row(table2);
            table2.add((CharSequence)" at ");
            this.fields(table2, this.x, str -> {
                this.x = str;
            });
            table2.add((CharSequence)", ");
            this.fields(table2, this.y, str -> {
                this.y = str;
            });
            table2.row();
            if (!LCanvas.useRows()) {
                table2.add();
            }
            table2.add((CharSequence)"team ");
            this.field(table2, this.team, str -> {
                this.team = str;
            });
            table2.add((CharSequence)" rot ");
            this.fields(table2, this.rotation, str -> {
                this.rotation = str;
            }).left();
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SpawnUnitI(builder.var(this.type), builder.var(this.x), builder.var(this.y), builder.var(this.rotation), builder.var(this.team), builder.var(this.result));
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class SetBlockStatement
    extends LStatement {
        public TileLayer layer = TileLayer.block;
        public String block = "@air";
        public String x = "0";
        public String y = "0";
        public String team = "@derelict";
        public String rotation = "0";

        public void build(Table table2) {
            this.rebuild(table2);
        }

        void rebuild(Table table2) {
            table2.clearChildren();
            table2.add((CharSequence)"set");
            table2.button(b -> {
                b.label(() -> this.layer.name());
                b.clicked(() -> this.showSelect((Button)b, TileLayer.settable, this.layer, o -> {
                    this.layer = o;
                    this.rebuild(table2);
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(64.0f, 40.0f).pad(4.0f).color(table2.color);
            this.row(table2);
            table2.add((CharSequence)" at ");
            this.fields(table2, this.x, str -> {
                this.x = str;
            });
            table2.add((CharSequence)", ");
            this.fields(table2, this.y, str -> {
                this.y = str;
            });
            this.row(table2);
            table2.add((CharSequence)" to ");
            this.fields(table2, this.block, str -> {
                this.block = str;
            });
            if (this.layer == TileLayer.block) {
                this.row(table2);
                table2.add((CharSequence)"team ");
                this.fields(table2, this.team, str -> {
                    this.team = str;
                });
                table2.add((CharSequence)" rotation ");
                this.fields(table2, this.rotation, str -> {
                    this.rotation = str;
                });
            }
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SetBlockI(builder.var(this.x), builder.var(this.y), builder.var(this.block), builder.var(this.team), builder.var(this.rotation), this.layer);
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class GetBlockStatement
    extends LStatement {
        public TileLayer layer = TileLayer.block;
        public String result = "result";
        public String x = "0";
        public String y = "0";

        public void build(Table table2) {
            this.fields(table2, this.result, str -> {
                this.result = str;
            });
            table2.add((CharSequence)" = get ");
            this.row(table2);
            table2.button(b -> {
                b.label(() -> this.layer.name());
                b.clicked(() -> this.showSelect((Button)b, TileLayer.all, this.layer, o -> {
                    this.layer = o;
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(64.0f, 40.0f).pad(4.0f).color(table2.color);
            table2.add((CharSequence)" at ");
            this.fields(table2, this.x, str -> {
                this.x = str;
            });
            table2.add((CharSequence)", ");
            this.fields(table2, this.y, str -> {
                this.y = str;
            });
        }

        public boolean privileged() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.GetBlockI(builder.var(this.x), builder.var(this.y), builder.var(this.result), this.layer);
        }

        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class UnitLocateStatement
    extends LStatement {
        public LLocate locate = LLocate.building;
        public BlockFlag flag = BlockFlag.core;
        public String enemy = "true";
        public String ore = "@copper";
        public String outX = "outx";
        public String outY = "outy";
        public String outFound = "found";
        public String outBuild = "building";

        public void build(Table table2) {
            this.rebuild(table2);
        }

        void rebuild(Table table2) {
            table2.clearChildren();
            table2.add((CharSequence)" find ").left().self(arg_0 -> ((UnitLocateStatement)this).param(arg_0));
            table2.button(b -> {
                b.label(() -> this.locate.name());
                b.clicked(() -> this.showSelect((Button)b, LLocate.all, this.locate, t -> {
                    this.locate = t;
                    this.rebuild(table2);
                }, 2, cell -> cell.size(110.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(110.0f, 40.0f).color(table2.color).left().padLeft(2.0f);
            switch (this.locate) {
                case building: {
                    this.row(table2);
                    table2.add((CharSequence)" group ").left().self(arg_0 -> ((UnitLocateStatement)this).param(arg_0));
                    table2.button(b -> {
                        b.label(() -> this.flag.name());
                        b.clicked(() -> this.showSelect((Button)b, BlockFlag.allLogic, this.flag, t -> {
                            this.flag = t;
                        }, 2, cell -> cell.size(110.0f, 50.0f)));
                    }, (Button.ButtonStyle)Styles.logict, () -> {}).size(110.0f, 40.0f).color(table2.color).left().padLeft(2.0f);
                    this.row(table2);
                    table2.add((CharSequence)" enemy ").left().self(arg_0 -> ((UnitLocateStatement)this).param(arg_0));
                    this.fields(table2, this.enemy, str -> {
                        this.enemy = str;
                    });
                    table2.row();
                    break;
                }
                case ore: {
                    table2.add((CharSequence)" ore ").left().self(arg_0 -> ((UnitLocateStatement)this).param(arg_0));
                    table2.table(ts -> {
                        ts.color.set(table2.color);
                        this.fields((Table)ts, this.ore, str -> {
                            this.ore = str;
                        });
                        ts.button(b -> {
                            b.image((Drawable)Icon.pencilSmall);
                            b.clicked(() -> UnitLocateStatement.showSelectTable((Button)b, (t, hide) -> {
                                t.row();
                                t.table(i -> {
                                    i.left();
                                    int c = 0;
                                    for (Item item : Vars.content.items()) {
                                        if (!item.unlockedNow()) continue;
                                        i.button((Drawable)new TextureRegionDrawable(item.uiIcon), Styles.flati, 24.0f, () -> {
                                            this.ore = "@" + item.name;
                                            this.rebuild(table2);
                                            hide.run();
                                        }).size(40.0f);
                                        if (++c % 6 != 0) continue;
                                        i.row();
                                    }
                                }).colspan(3).width(240.0f).left();
                            }));
                        }, (Button.ButtonStyle)Styles.logict, () -> {}).size(40.0f).padLeft(-2.0f).color(table2.color);
                    });
                    table2.row();
                    break;
                }
                case spawn: 
                case damaged: {
                    table2.row();
                }
            }
            table2.add((CharSequence)" outX ").left().self(arg_0 -> ((UnitLocateStatement)this).param(arg_0));
            this.fields(table2, this.outX, str -> {
                this.outX = str;
            });
            table2.add((CharSequence)" outY ").left().self(arg_0 -> ((UnitLocateStatement)this).param(arg_0));
            this.fields(table2, this.outY, str -> {
                this.outY = str;
            });
            this.row(table2);
            table2.add((CharSequence)" found ").left().self(arg_0 -> ((UnitLocateStatement)this).param(arg_0));
            this.fields(table2, this.outFound, str -> {
                this.outFound = str;
            });
            if (this.locate != LLocate.ore) {
                table2.add((CharSequence)" building ").left().self(arg_0 -> ((UnitLocateStatement)this).param(arg_0));
                this.fields(table2, this.outBuild, str -> {
                    this.outBuild = str;
                });
            }
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.UnitLocateI(this.locate, this.flag, builder.var(this.enemy), builder.var(this.ore), builder.var(this.outX), builder.var(this.outY), builder.var(this.outFound), builder.var(this.outBuild));
        }

        public LCategory category() {
            return LCategory.unit;
        }
    }

    public static class UnitRadarStatement
    extends RadarStatement {
        public UnitRadarStatement() {
            this.radar = "0";
        }

        @Override
        public boolean buildFrom() {
            return false;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.RadarI(this.target1, this.target2, this.target3, this.sort, builder.var("@unit"), builder.var(this.sortOrder), builder.var(this.output));
        }

        @Override
        public LCategory category() {
            return LCategory.unit;
        }
    }

    public static class UnitControlStatement
    extends LStatement {
        public LUnitControl type = LUnitControl.move;
        public String p1 = "0";
        public String p2 = "0";
        public String p3 = "0";
        public String p4 = "0";
        public String p5 = "0";

        public void build(Table table2) {
            this.rebuild(table2);
        }

        void rebuild(Table table2) {
            table2.clearChildren();
            table2.left();
            table2.add((CharSequence)" ");
            table2.button(b -> {
                b.label(() -> this.type.name());
                b.clicked(() -> this.showSelect((Button)b, LUnitControl.all, this.type, t -> {
                    if (t == LUnitControl.build && !Vars.state.rules.logicUnitBuild) {
                        Vars.ui.showInfo("@logic.nounitbuild");
                    } else {
                        this.type = t;
                    }
                    this.rebuild(table2);
                }, 2, cell -> cell.size(120.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(120.0f, 40.0f).color(table2.color).left().padLeft(2.0f);
            this.row(table2);
            int c = 0;
            for (int i = 0; i < this.type.params.length; ++i) {
                this.fields(table2, this.type.params[i], i == 0 ? this.p1 : (i == 1 ? this.p2 : (i == 2 ? this.p3 : (i == 3 ? this.p4 : this.p5))), i == 0 ? v -> {
                    this.p1 = v;
                } : (i == 1 ? v -> {
                    this.p2 = v;
                } : (i == 2 ? v -> {
                    this.p3 = v;
                } : (i == 3 ? v -> {
                    this.p4 = v;
                } : v -> {
                    this.p5 = v;
                })))).width(100.0f);
                if (++c % 2 == 0) {
                    this.row(table2);
                }
                if (i != 3) continue;
                table2.row();
            }
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.UnitControlI(this.type, builder.var(this.p1), builder.var(this.p2), builder.var(this.p3), builder.var(this.p4), builder.var(this.p5));
        }

        public LCategory category() {
            return LCategory.unit;
        }
    }

    public static class UnitBindStatement
    extends LStatement {
        public String type = "@poly";

        public void build(Table table2) {
            table2.add((CharSequence)" type ");
            TextField field = (TextField)this.field(table2, this.type, str -> {
                this.type = str;
            }).get();
            table2.button(b -> {
                b.image((Drawable)Icon.pencilSmall);
                b.clicked(() -> UnitBindStatement.showSelectTable((Button)b, (t, hide) -> {
                    t.row();
                    t.table(i -> {
                        i.left();
                        int c = 0;
                        for (UnitType item : Vars.content.units()) {
                            if (!item.unlockedNow() || item.isHidden() || !item.logicControllable) continue;
                            i.button((Drawable)new TextureRegionDrawable(item.uiIcon), Styles.flati, 24.0f, () -> {
                                this.type = "@" + item.name;
                                field.setText(this.type);
                                hide.run();
                            }).size(40.0f);
                            if (++c % 6 != 0) continue;
                            i.row();
                        }
                    }).colspan(3).width(240.0f).left();
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(40.0f).padLeft(-2.0f).color(table2.color);
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.UnitBindI(builder.var(this.type));
        }

        public LCategory category() {
            return LCategory.unit;
        }
    }

    public static class JumpStatement
    extends LStatement {
        private static Color last = new Color();
        public transient LCanvas.StatementElem dest;
        public int destIndex;
        public ConditionOp op = ConditionOp.notEqual;
        public String value = "x";
        public String compare = "false";

        public void build(Table table2) {
            table2.add((CharSequence)"if ").padLeft(4.0f);
            last = table2.color;
            table2.table(this::rebuild);
            table2.add().growX();
            if (!Vars.mobile || !Core.graphics.isPortrait()) {
                table2.button("JUMP", Styles.grayt, () -> {
                    if (this.dest == null) {
                        return;
                    }
                    Group canvas = this.dest.parent.parent;
                    ScrollPane scroll = (ScrollPane)canvas.parent;
                    scroll.setScrollY(scroll.getMaxY() - this.dest.y + scroll.getHeight() * 0.5f);
                    this.saveUI();
                    UIExt.announce("[gold]\u8df3\u8f6c\u884c\u53f7:[] " + this.destIndex);
                    Element header = (Element)this.dest.getChildren().first();
                    this.dest.clearActions();
                    header.clearActions();
                    this.dest.addAction((Action)Actions.repeat((int)2, (Action)Actions.sequence((Action)Actions.color((Color)Pal.placing, (float)0.5f, (Interp)Interp.smooth), (Action)Actions.color((Color)this.dest.st.category().color, (float)0.5f, (Interp)Interp.smooth))));
                    header.addAction((Action)Actions.repeat((int)2, (Action)Actions.sequence((Action)Actions.color((Color)Pal.placing, (float)0.5f, (Interp)Interp.smooth), (Action)Actions.color((Color)this.dest.st.category().color, (float)0.5f, (Interp)Interp.smooth))));
                }).width(80.0f);
            }
            table2.add((Element)new LCanvas.JumpButton((Prov<LCanvas.StatementElem>)((Prov)() -> this.dest), (Cons<LCanvas.StatementElem>)((Cons)s -> {
                this.dest = s;
            }), this.elem)).size(30.0f).right().padLeft(-8.0f);
            String name = this.name();
            Core.app.post(() -> {
                Label title;
                if (table2.parent != null && (title = (Label)table2.parent.find("statement-name")) != null) {
                    title.update(() -> title.setText((CharSequence)(this.dest != null ? name + " -> " + this.dest.index : name)));
                }
            });
        }

        void rebuild(Table table2) {
            table2.clearChildren();
            table2.setColor(last);
            JumpStatement.addOp(this, table2, this.op, (Cons<ConditionOp>)((Cons)o -> {
                this.op = o;
                this.rebuild(table2);
            }), this.value, (Cons<String>)((Cons)str -> {
                this.value = str;
            }), this.compare, (Cons<String>)((Cons)str -> {
                this.compare = str;
            }));
        }

        public static void addOp(LStatement st, Table t, ConditionOp op, Cons<ConditionOp> getter, String comp0, Cons<String> set0, String comp1, Cons<String> set2) {
            if (op != ConditionOp.always) {
                st.field(t, comp0, set0);
            }
            t.button(b -> {
                b.add((CharSequence)op.symbol);
                b.clicked(() -> st.showSelect(b, (Object[])ConditionOp.all, (Object)op, getter));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(op == ConditionOp.always ? 80.0f : 48.0f, 40.0f).pad(4.0f).color(t.color);
            if (op != ConditionOp.always) {
                st.field(t, comp1, set2);
            }
        }

        public void setupUI() {
            if (this.elem != null && this.destIndex >= 0 && this.destIndex < this.elem.parent.getChildren().size) {
                this.dest = (LCanvas.StatementElem)((Object)this.elem.parent.getChildren().get(this.destIndex));
            }
        }

        public void saveUI() {
            if (this.elem != null) {
                this.destIndex = this.dest == null ? -1 : this.dest.parent.getChildren().indexOf((Object)this.dest);
            }
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.JumpI(this.op, builder.var(this.value), builder.var(this.compare), this.destIndex);
        }

        public LCategory category() {
            return LCategory.control;
        }
    }

    public static class EndStatement
    extends LStatement {
        public void build(Table table2) {
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.EndI();
        }

        public LCategory category() {
            return LCategory.control;
        }
    }

    public static class UnpackColorStatement
    extends LStatement {
        public String r = "r";
        public String g = "g";
        public String b = "b";
        public String a = "a";
        public String value = "color";

        public void build(Table table2) {
            this.fields(table2, this.r, str -> {
                this.r = str;
            });
            this.fields(table2, this.g, str -> {
                this.g = str;
            });
            this.fields(table2, this.b, str -> {
                this.b = str;
            });
            this.fields(table2, this.a, str -> {
                this.a = str;
            });
            this.row(table2);
            table2.add((CharSequence)" = unpack ");
            this.fields(table2, this.value, str -> {
                this.value = str;
            });
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.UnpackColorI(builder.var(this.r), builder.var(this.g), builder.var(this.b), builder.var(this.a), builder.var(this.value));
        }

        public LCategory category() {
            return LCategory.operation;
        }
    }

    public static class PackColorStatement
    extends LStatement {
        public String result = "result";
        public String r = "1";
        public String g = "0";
        public String b = "0";
        public String a = "1";

        public void build(Table table2) {
            this.fields(table2, this.result, str -> {
                this.result = str;
            });
            table2.add((CharSequence)" = pack ");
            this.row(table2);
            this.fields(table2, this.r, str -> {
                this.r = str;
            });
            this.fields(table2, this.g, str -> {
                this.g = str;
            });
            this.fields(table2, this.b, str -> {
                this.b = str;
            });
            this.fields(table2, this.a, str -> {
                this.a = str;
            });
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.PackColorI(builder.var(this.result), builder.var(this.r), builder.var(this.g), builder.var(this.b), builder.var(this.a));
        }

        public LCategory category() {
            return LCategory.operation;
        }
    }

    public static class LookupStatement
    extends LStatement {
        public ContentType type = ContentType.item;
        public String result = "result";
        public String id = "0";

        public void build(Table table2) {
            this.fields(table2, this.result, str -> {
                this.result = str;
            }).width(120.0f);
            table2.add((CharSequence)" = lookup ");
            this.row(table2);
            table2.button(b -> {
                b.label(() -> this.type.name());
                b.clicked(() -> this.showSelect((Button)b, GlobalVars.lookableContent, this.type, o -> {
                    this.type = o;
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(64.0f, 40.0f).pad(4.0f).color(table2.color);
            table2.add((CharSequence)" # ");
            this.fields(table2, this.id, str -> {
                this.id = str;
            });
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.LookupI(builder.var(this.result), builder.var(this.id), this.type);
        }

        public LCategory category() {
            return LCategory.operation;
        }
    }

    public static class StopStatement
    extends LStatement {
        public void build(Table table2) {
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.StopI();
        }

        public LCategory category() {
            return LCategory.control;
        }
    }

    public static class WaitStatement
    extends LStatement {
        public String value = "0.5";

        public void build(Table table2) {
            this.field(table2, this.value, str -> {
                this.value = str;
            });
            table2.add((CharSequence)" sec");
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.WaitI(builder.var(this.value));
        }

        public LCategory category() {
            return LCategory.control;
        }
    }

    public static class SelectStatement
    extends LStatement {
        public String result = "result";
        public ConditionOp op = ConditionOp.notEqual;
        public String comp0 = "x";
        public String comp1 = "false";
        public String a = "a";
        public String b = "b";

        public void build(Table table2) {
            this.rebuild(table2);
        }

        private void rebuild(Table table2) {
            table2.clearChildren();
            table2.left();
            table2.table(t -> {
                t.setColor(table2.color);
                this.field((Table)t, this.result, str -> {
                    this.result = str;
                });
                t.add((CharSequence)" = if ");
                this.row((Table)t);
                JumpStatement.addOp(this, t, this.op, (Cons<ConditionOp>)((Cons)o -> {
                    this.op = o;
                    this.rebuild(table2);
                }), this.comp0, (Cons<String>)((Cons)str -> {
                    this.comp0 = str;
                }), this.comp1, (Cons<String>)((Cons)str -> {
                    this.comp1 = str;
                }));
            }).left();
            table2.row();
            table2.table(t -> {
                t.setColor(table2.color);
                t.add((CharSequence)"then ");
                this.field((Table)t, this.a, str -> {
                    this.a = str;
                }).width(130.0f);
                t.add((CharSequence)" else ");
                this.field((Table)t, this.b, str -> {
                    this.b = str;
                }).width(130.0f);
            }).left();
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SelectI(this.op, builder.var(this.result), builder.var(this.comp0), builder.var(this.comp1), builder.var(this.a), builder.var(this.b));
        }

        public LCategory category() {
            return LCategory.operation;
        }
    }

    public static class OperationStatement
    extends LStatement {
        public LogicOp op = LogicOp.add;
        public String dest = "result";
        public String a = "a";
        public String b = "b";

        public void build(Table table2) {
            this.rebuild(table2);
        }

        void rebuild(Table table2) {
            table2.clearChildren();
            this.field(table2, this.dest, str -> {
                this.dest = str;
            });
            table2.add((CharSequence)" = ");
            if (this.op.unary) {
                this.opButton(table2, table2);
                this.field(table2, this.a, str -> {
                    this.a = str;
                });
            } else {
                this.row(table2);
                if (this.op.func) {
                    if (LCanvas.useRows()) {
                        table2.left();
                        table2.row();
                        table2.table(c -> {
                            c.color.set(this.category().color);
                            c.left();
                            this.funcs((Table)c, table2);
                        }).colspan(2).left();
                    } else {
                        this.funcs(table2, table2);
                    }
                } else {
                    this.field(table2, this.a, str -> {
                        this.a = str;
                    });
                    this.opButton(table2, table2);
                    this.field(table2, this.b, str -> {
                        this.b = str;
                    });
                }
            }
        }

        void funcs(Table table2, Table parent) {
            this.opButton(table2, parent);
            this.field(table2, this.a, str -> {
                this.a = str;
            });
            this.field(table2, this.b, str -> {
                this.b = str;
            });
        }

        void opButton(Table table2, Table parent) {
            table2.button(b -> {
                b.label(() -> this.op.symbol);
                b.clicked(() -> this.showSelect((Button)b, LogicOp.all, this.op, o -> {
                    this.op = o;
                    this.rebuild(parent);
                }, 4, c -> c.width(64.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(64.0f, 40.0f).pad(4.0f).color(table2.color);
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.OpI(this.op, builder.var(this.a), builder.var(this.b), builder.var(this.dest));
        }

        public LCategory category() {
            return LCategory.operation;
        }
    }

    public static class SetStatement
    extends LStatement {
        public String to = "result";
        public String from = "0";

        public void build(Table table2) {
            this.field(table2, this.to, str -> {
                this.to = str;
            });
            table2.add((CharSequence)" = ");
            this.field(table2, this.from, str -> {
                this.from = str;
            });
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SetI(builder.var(this.from), builder.var(this.to));
        }

        public LCategory category() {
            return LCategory.operation;
        }
    }

    public static class SensorStatement
    extends LStatement {
        public String to = "result";
        public String from = "block1";
        public String type = "@copper";
        private transient int selected = 0;
        private transient TextField tfield;

        public void build(Table table2) {
            this.field(table2, this.to, str -> {
                this.to = str;
            });
            table2.add((CharSequence)" = ");
            this.row(table2);
            this.tfield = (TextField)this.field(table2, this.type, str -> {
                this.type = str;
            }).padRight(0.0f).get();
            table2.button(b -> {
                b.image((Drawable)Icon.pencilSmall);
                b.clicked(() -> SensorStatement.showSelectTable((Button)b, (t, hide) -> {
                    Table[] tables = new Table[]{new Table(i -> {
                        i.left();
                        int c = 0;
                        for (Item item : Vars.content.items()) {
                            if (!item.unlockedNow() || item.hidden) continue;
                            i.button((Drawable)new TextureRegionDrawable(item.uiIcon), Styles.flati, 24.0f, () -> {
                                this.stype("@" + item.name);
                                hide.run();
                            }).size(40.0f);
                            if (++c % 6 != 0) continue;
                            i.row();
                        }
                    }), new Table(i -> {
                        i.left();
                        int c = 0;
                        for (Liquid item : Vars.content.liquids()) {
                            if (!item.unlockedNow() || item.hidden) continue;
                            i.button((Drawable)new TextureRegionDrawable(item.uiIcon), Styles.flati, 24.0f, () -> {
                                this.stype("@" + item.name);
                                hide.run();
                            }).size(40.0f);
                            if (++c % 6 != 0) continue;
                            i.row();
                        }
                    }), new Table(i -> {
                        i.left();
                        int c = 0;
                        for (UnlockableContent item : Vars.content.units()) {
                            if (!item.unlockedNow() || ((UnitType)item).hidden) continue;
                            i.button((Drawable)new TextureRegionDrawable(((UnitType)item).uiIcon), Styles.flati, 24.0f, () -> this.lambda$build$6((UnitType)item, hide)).size(40.0f);
                            if (++c % 6 != 0) continue;
                            i.row();
                        }
                        for (UnlockableContent item : Vars.content.blocks()) {
                            if (!item.unlockedNow() || ((Block)item).isHidden()) continue;
                            i.button((Drawable)new TextureRegionDrawable(((Block)item).uiIcon), Styles.flati, 24.0f, () -> this.lambda$build$7((Block)item, hide)).size(40.0f);
                            if (++c % 6 != 0) continue;
                            i.row();
                        }
                    }), new Table(i -> {
                        for (LAccess sensor : LAccess.senseable) {
                            i.button(sensor.name(), Styles.flatt, () -> {
                                this.stype("@" + sensor.name());
                                hide.run();
                            }).size(240.0f, 40.0f).self(c -> LCanvas.tooltip(c, sensor)).row();
                        }
                    })};
                    Drawable[] icons = new Drawable[]{Icon.box, Icon.liquid, Icon.units, Icon.tree};
                    Stack stack = new Stack(new Element[]{tables[this.selected]});
                    ButtonGroup group = new ButtonGroup();
                    for (int i2 = 0; i2 < tables.length; ++i2) {
                        int fi = i2;
                        t.button(icons[i2], Styles.squareTogglei, () -> {
                            this.selected = fi;
                            stack.clearChildren();
                            stack.addChild((Element)tables[this.selected]);
                            t.parent.parent.pack();
                            t.parent.parent.invalidateHierarchy();
                        }).height(50.0f).growX().checked(this.selected == fi).group(group);
                    }
                    t.row();
                    t.add((Element)stack).colspan(4).width(240.0f).left();
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(40.0f).padLeft(-1.0f).color(table2.color);
            table2.add((CharSequence)" in ").self(arg_0 -> ((SensorStatement)this).param(arg_0));
            this.field(table2, this.from, str -> {
                this.from = str;
            });
        }

        private void stype(String text) {
            this.tfield.setText(text);
            this.type = text;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SenseI(builder.var(this.from), builder.var(this.to), builder.var(this.type));
        }

        public LCategory category() {
            return LCategory.block;
        }

        private /* synthetic */ void lambda$build$7(Block item, Runnable hide) {
            this.stype("@" + item.name);
            hide.run();
        }

        private /* synthetic */ void lambda$build$6(UnitType item, Runnable hide) {
            this.stype("@" + item.name);
            hide.run();
        }
    }

    public static class RadarStatement
    extends LStatement {
        public RadarTarget target1 = RadarTarget.enemy;
        public RadarTarget target2 = RadarTarget.any;
        public RadarTarget target3 = RadarTarget.any;
        public RadarSort sort = RadarSort.distance;
        public String radar = "turret1";
        public String sortOrder = "1";
        public String output = "result";

        public void build(Table table2) {
            table2.defaults().left();
            if (this.buildFrom()) {
                table2.add((CharSequence)" from ").self(arg_0 -> ((RadarStatement)this).param(arg_0));
                this.fields(table2, this.radar, v -> {
                    this.radar = v;
                });
                this.row(table2);
            }
            for (int i = 0; i < 3; ++i) {
                int fi = i;
                Prov get = () -> fi == 0 ? this.target1 : (fi == 1 ? this.target2 : this.target3);
                table2.add((CharSequence)(i == 0 ? " target " : " and ")).self(arg_0 -> ((RadarStatement)this).param(arg_0));
                table2.button(b -> {
                    b.label(() -> ((RadarTarget)get.get()).name());
                    b.clicked(() -> this.showSelect((Button)b, RadarTarget.all, (RadarTarget)get.get(), t -> {
                        if (fi == 0) {
                            this.target1 = t;
                        } else if (fi == 1) {
                            this.target2 = t;
                        } else {
                            this.target3 = t;
                        }
                    }, 2, cell -> cell.size(100.0f, 50.0f)));
                }, (Button.ButtonStyle)Styles.logict, () -> {}).size(90.0f, 40.0f).color(table2.color).left().padLeft(2.0f);
                if (i != 1) continue;
                this.row(table2);
            }
            table2.add((CharSequence)" order ").self(arg_0 -> ((RadarStatement)this).param(arg_0));
            this.fields(table2, this.sortOrder, v -> {
                this.sortOrder = v;
            });
            table2.row();
            table2.add((CharSequence)" sort ").self(arg_0 -> ((RadarStatement)this).param(arg_0));
            table2.button(b -> {
                b.label(() -> this.sort.name());
                b.clicked(() -> this.showSelect((Button)b, RadarSort.all, this.sort, t -> {
                    this.sort = t;
                }, 2, cell -> cell.size(100.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(90.0f, 40.0f).color(table2.color).left().padLeft(2.0f);
            table2.add((CharSequence)" output ").self(arg_0 -> ((RadarStatement)this).param(arg_0));
            this.fields(table2, this.output, v -> {
                this.output = v;
            });
        }

        public boolean buildFrom() {
            return true;
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.RadarI(this.target1, this.target2, this.target3, this.sort, builder.var(this.radar), builder.var(this.sortOrder), builder.var(this.output));
        }

        public LCategory category() {
            return LCategory.block;
        }
    }

    public static class ControlStatement
    extends LStatement {
        public LAccess type = LAccess.enabled;
        public String target = "block1";
        public String p1 = "0";
        public String p2 = "0";
        public String p3 = "0";
        public String p4 = "0";

        public void build(Table table2) {
            this.rebuild(table2);
        }

        void rebuild(Table table2) {
            table2.clearChildren();
            table2.left();
            table2.add((CharSequence)" set ");
            table2.button(b -> {
                b.label(() -> this.type.name());
                b.clicked(() -> this.showSelect((Button)b, LAccess.controls, this.type, t -> {
                    this.type = t;
                    this.rebuild(table2);
                }, 2, cell -> cell.size(100.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(90.0f, 40.0f).color(table2.color).left().padLeft(2.0f);
            table2.add((CharSequence)" of ").self(arg_0 -> ((ControlStatement)this).param(arg_0));
            this.field(table2, this.target, v -> {
                this.target = v;
            });
            this.row(table2);
            int c = 0;
            for (int i = 0; i < this.type.params.length; ++i) {
                this.fields(table2, this.type.params[i], i == 0 ? this.p1 : (i == 1 ? this.p2 : (i == 2 ? this.p3 : this.p4)), i == 0 ? v -> {
                    this.p1 = v;
                } : (i == 1 ? v -> {
                    this.p2 = v;
                } : (i == 2 ? v -> {
                    this.p3 = v;
                } : v -> {
                    this.p4 = v;
                })));
                if (++c % 2 != 0) continue;
                this.row(table2);
            }
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.ControlI(this.type, builder.var(this.target), builder.var(this.p1), builder.var(this.p2), builder.var(this.p3), builder.var(this.p4));
        }

        public LCategory category() {
            return LCategory.block;
        }
    }

    public static class GetLinkStatement
    extends LStatement {
        public String output = "result";
        public String address = "0";

        public void build(Table table2) {
            this.field(table2, this.output, str -> {
                this.output = str;
            });
            table2.add((CharSequence)" = link# ");
            this.field(table2, this.address, str -> {
                this.address = str;
            });
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.GetLinkI(builder.var(this.output), builder.var(this.address));
        }

        public LCategory category() {
            return LCategory.block;
        }
    }

    public static class PrintFlushStatement
    extends LStatement {
        public String target = "message1";

        public void build(Table table2) {
            table2.add((CharSequence)" to ");
            this.field(table2, this.target, str -> {
                this.target = str;
            });
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.PrintFlushI(builder.var(this.target));
        }

        public LCategory category() {
            return LCategory.block;
        }
    }

    public static class DrawFlushStatement
    extends LStatement {
        public String target = "display1";

        public void build(Table table2) {
            table2.add((CharSequence)" to ");
            this.field(table2, this.target, str -> {
                this.target = str;
            });
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.DrawFlushI(builder.var(this.target));
        }

        public LCategory category() {
            return LCategory.block;
        }
    }

    public static class FormatStatement
    extends LStatement {
        public String value = "\"frog\"";

        public void build(Table table2) {
            this.field(table2, this.value, str -> {
                this.value = str;
            }).width(0.0f).growX().padRight(3.0f);
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.FormatI(builder.var(this.value));
        }

        public LCategory category() {
            return LCategory.io;
        }
    }

    public static class PrintCharStatement
    extends LStatement {
        public String value = "65";

        public void build(Table table2) {
            table2.add((CharSequence)" char ");
            TextField field = (TextField)this.field(table2, this.value, str -> {
                this.value = str;
            }).get();
            table2.button(b -> {
                b.image((Drawable)Icon.pencilSmall);
                b.clicked(() -> PrintCharStatement.showSelectTable((Button)b, (t, hide) -> {
                    t.row();
                    t.table(i -> {
                        i.left();
                        int c = 0;
                        for (char j = ' '; j < '\u007f'; j = (char)(j + '\u0001')) {
                            char chr = j;
                            i.button(String.valueOf(j), Styles.flatt, () -> {
                                this.value = Integer.toString(chr);
                                field.setText(this.value);
                                hide.run();
                            }).size(32.0f);
                            if (++c % 8 != 0) continue;
                            i.row();
                        }
                    });
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(40.0f).padLeft(-2.0f).color(table2.color);
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.PrintCharI(builder.var(this.value));
        }

        public LCategory category() {
            return LCategory.io;
        }
    }

    public static class PrintStatement
    extends LStatement {
        public String value = "\"frog\"";

        public void build(Table table2) {
            this.field(table2, this.value, str -> {
                this.value = str;
            }).width(0.0f).growX().padRight(3.0f);
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.PrintI(builder.var(this.value));
        }

        public LCategory category() {
            return LCategory.io;
        }
    }

    public static class DrawStatement
    extends LStatement {
        public LogicDisplay.GraphicsType type = LogicDisplay.GraphicsType.clear;
        public String x = "0";
        public String y = "0";
        public String p1 = "0";
        public String p2 = "0";
        public String p3 = "0";
        public String p4 = "0";

        public void build(Table table2) {
            this.rebuild(table2);
        }

        void rebuild(Table table2) {
            table2.clearChildren();
            table2.left();
            table2.button(b -> {
                b.label(() -> this.type.name());
                b.clicked(() -> this.showSelect((Button)b, (Object[])LogicDisplay.GraphicsType.all, (Object)this.type, t -> {
                    this.type = t;
                    if (this.type == LogicDisplay.GraphicsType.color) {
                        this.p2 = "255";
                    }
                    if (this.type == LogicDisplay.GraphicsType.image) {
                        this.p1 = "@copper";
                        this.p2 = "32";
                        this.p3 = "0";
                    }
                    if (this.type == LogicDisplay.GraphicsType.print) {
                        this.p1 = "@bottomLeft";
                    }
                    this.rebuild(table2);
                }, 2, cell -> cell.size(100.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(90.0f, 40.0f).color(table2.color).left().padLeft(2.0f);
            if (this.type != LogicDisplay.GraphicsType.stroke) {
                this.row(table2);
            }
            table2.table(s -> {
                s.left();
                s.setColor(table2.color);
                switch (this.type) {
                    case clear: {
                        this.fields((Table)s, "r", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "g", this.y, v -> {
                            this.y = v;
                        });
                        this.fields((Table)s, "b", this.p1, v -> {
                            this.p1 = v;
                        });
                        break;
                    }
                    case color: {
                        this.fields((Table)s, "r", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "g", this.y, v -> {
                            this.y = v;
                        });
                        this.fields((Table)s, "b", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "a", this.p2, v -> {
                            this.p2 = v;
                        });
                        break;
                    }
                    case col: {
                        this.fields((Table)s, "color", this.x, v -> {
                            this.x = v;
                        }).width(144.0f);
                        this.col((Table)s, this.x, res -> {
                            this.x = "%" + res.toString().substring(0, res.a >= 1.0f ? 6 : 8);
                            this.build(table2);
                        });
                        break;
                    }
                    case stroke: {
                        s.add().width(4.0f);
                        this.fields((Table)s, this.x, v -> {
                            this.x = v;
                        });
                        break;
                    }
                    case line: {
                        this.fields((Table)s, "x", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "y", this.y, v -> {
                            this.y = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "x2", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.fields((Table)s, "y2", this.p2, v -> {
                            this.p2 = v;
                        });
                        break;
                    }
                    case rect: 
                    case lineRect: {
                        this.fields((Table)s, "x", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "y", this.y, v -> {
                            this.y = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "width", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.fields((Table)s, "height", this.p2, v -> {
                            this.p2 = v;
                        });
                        break;
                    }
                    case poly: 
                    case linePoly: {
                        this.fields((Table)s, "x", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "y", this.y, v -> {
                            this.y = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "sides", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.fields((Table)s, "radius", this.p2, v -> {
                            this.p2 = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "rotation", this.p3, v -> {
                            this.p3 = v;
                        });
                        break;
                    }
                    case triangle: {
                        this.fields((Table)s, "x", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "y", this.y, v -> {
                            this.y = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "x2", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.fields((Table)s, "y2", this.p2, v -> {
                            this.p2 = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "x3", this.p3, v -> {
                            this.p3 = v;
                        });
                        this.fields((Table)s, "y3", this.p4, v -> {
                            this.p4 = v;
                        });
                        break;
                    }
                    case image: {
                        this.fields((Table)s, "x", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "y", this.y, v -> {
                            this.y = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "image", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.fields((Table)s, "size", this.p2, v -> {
                            this.p2 = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "rotation", this.p3, v -> {
                            this.p3 = v;
                        });
                        break;
                    }
                    case print: {
                        this.fields((Table)s, "x", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "y", this.y, v -> {
                            this.y = v;
                        });
                        this.row((Table)s);
                        s.add((CharSequence)"align ");
                        this.fields((Table)s, "align", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.fieldAlignSelect((Table)s, () -> this.p1, v -> {
                            this.p1 = v;
                            this.rebuild(table2);
                        }, true, true);
                        break;
                    }
                    case translate: 
                    case scale: {
                        this.fields((Table)s, "x", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "y", this.y, v -> {
                            this.y = v;
                        });
                        break;
                    }
                    case rotate: {
                        this.fields((Table)s, "degrees", this.p1, v -> {
                            this.p1 = v;
                        });
                    }
                }
            }).expand().left();
        }

        public void afterRead() {
            if (this.type == LogicDisplay.GraphicsType.color && this.p2.equals("0")) {
                this.p2 = "255";
            }
            if (this.type == LogicDisplay.GraphicsType.print && nameToAlign.get((Object)this.p1) != null) {
                this.p1 = "@" + this.p1;
            }
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.DrawI((byte)this.type.ordinal(), builder.var(this.x), builder.var(this.y), builder.var(this.p1), builder.var(this.p2), builder.var(this.p3), builder.var(this.p4));
        }

        public LCategory category() {
            return LCategory.io;
        }
    }

    public static class WriteStatement
    extends LStatement {
        public String input = "result";
        public String target = "cell1";
        public String address = "0";

        public void build(Table table2) {
            table2.add((CharSequence)" write ");
            this.field(table2, this.input, str -> {
                this.input = str;
            });
            table2.add((CharSequence)" to ");
            this.fields(table2, this.target, str -> {
                this.target = str;
            });
            this.row(table2);
            table2.add((CharSequence)" at ");
            this.field(table2, this.address, str -> {
                this.address = str;
            });
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.WriteI(builder.var(this.target), builder.var(this.address), builder.var(this.input));
        }

        public LCategory category() {
            return LCategory.io;
        }
    }

    public static class ReadStatement
    extends LStatement {
        public String output = "result";
        public String target = "cell1";
        public String address = "0";

        public void build(Table table2) {
            table2.add((CharSequence)" read ");
            this.field(table2, this.output, str -> {
                this.output = str;
            });
            table2.add((CharSequence)" = ");
            this.fields(table2, this.target, str -> {
                this.target = str;
            });
            this.row(table2);
            table2.add((CharSequence)" at ");
            this.field(table2, this.address, str -> {
                this.address = str;
            });
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.ReadI(builder.var(this.target), builder.var(this.address), builder.var(this.output));
        }

        public LCategory category() {
            return LCategory.io;
        }
    }

    public static class InvalidStatement
    extends LStatement {
        public transient String[] tokens = new String[0];

        public InvalidStatement() {
        }

        public InvalidStatement(String[] tokens) {
            this.tokens = tokens;
        }

        public void build(Table table2) {
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.NoopI();
        }
    }

    public static class CommentStatement
    extends LStatement {
        public String comment = "";

        public void build(Table table2) {
            table2.area(this.comment, Styles.nodeArea, v -> {
                this.comment = v;
            }).growX().height(90.0f).padLeft(2.0f).padRight(6.0f).color(table2.color);
        }

        public LExecutor.LInstruction build(LAssembler builder) {
            return null;
        }
    }
}

