/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.Core;
import arc.Events;
import arc.audio.Sound;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.Font;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.scene.style.Drawable;
import arc.struct.IntFloatMap;
import arc.struct.IntSet;
import arc.struct.LongSeq;
import arc.struct.ObjectIntMap;
import arc.struct.Seq;
import arc.util.Align;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.types.LogicAI;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.core.UI;
import mindustry.core.World;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.MappableContent;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Damage;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.entities.units.UnitController;
import mindustry.game.EventType;
import mindustry.game.MapObjectives;
import mindustry.game.SpawnGroup;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.DisplayCmd;
import mindustry.gen.Healthc;
import mindustry.gen.Icon;
import mindustry.gen.Payloadc;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.logic.ConditionOp;
import mindustry.logic.CutsceneAction;
import mindustry.logic.FetchType;
import mindustry.logic.LAccess;
import mindustry.logic.LAssembler;
import mindustry.logic.LExecutor;
import mindustry.logic.LLocate;
import mindustry.logic.LMarkerControl;
import mindustry.logic.LReadable;
import mindustry.logic.LUnitControl;
import mindustry.logic.LVar;
import mindustry.logic.LWritable;
import mindustry.logic.LogicFx;
import mindustry.logic.LogicOp;
import mindustry.logic.LogicRule;
import mindustry.logic.MessageType;
import mindustry.logic.RadarSort;
import mindustry.logic.RadarTarget;
import mindustry.logic.Ranged;
import mindustry.logic.Senseable;
import mindustry.logic.Settable;
import mindustry.logic.TileLayer;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.type.Weather;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OverlayFloor;
import mindustry.world.blocks.logic.LogicBlock;
import mindustry.world.blocks.logic.LogicDisplay;
import mindustry.world.blocks.logic.MessageBlock;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BuildVisibility;
import mindustryX.features.ui.ArcMessageDialog;

public class LExecutor {
    public static int maxInstructions = 1000;
    public static final int maxGraphicsBuffer = 256;
    public static final int maxDisplayBuffer = 1024;
    public static final int maxTextBuffer = 400;
    public LInstruction[] instructions = new LInstruction[0];
    public LVar[] vars = new LVar[0];
    public LVar[] allVars = new LVar[0];
    public LVar counter;
    public LVar unit;
    public LVar thisv;
    public LVar ipt;
    public int[] binds;
    public boolean yield;
    public LongSeq graphicsBuffer = new LongSeq();
    public StringBuilder textBuffer = new StringBuilder();
    public Building[] links = new Building[0];
    @Nullable
    public LogicBlock.LogicBuild build;
    public IntSet linkIds = new IntSet();
    public Team team = Team.derelict;
    public boolean privileged = false;
    @Nullable
    protected ObjectIntMap<String> nameMap;
    protected static IntFloatMap unitTimeouts = new IntFloatMap();

    boolean timeoutDone(Unit unit, float delay) {
        return Time.time >= unitTimeouts.get(unit.id) + delay;
    }

    void updateTimeout(Unit unit) {
        unitTimeouts.put(unit.id, Time.time);
    }

    public boolean initialized() {
        return this.instructions.length > 0;
    }

    public void runOnce() {
        if (this.counter.numval >= (double)this.instructions.length || this.counter.numval < 0.0) {
            this.counter.numval = 0.0;
        }
        if (this.counter.numval < (double)this.instructions.length) {
            this.counter.isobj = false;
            double d = this.counter.numval;
            this.counter.numval = d + 1.0;
            this.instructions[(int)d].run(this);
        }
    }

    public void load(LAssembler builder) {
        this.nameMap = null;
        this.vars = (LVar[])builder.vars.values().toSeq().retainAll(var -> !var.constant).toArray(LVar.class);
        this.allVars = (LVar[])builder.vars.values().toSeq().toArray(LVar.class);
        for (int i = 0; i < this.vars.length; ++i) {
            this.vars[i].id = i;
        }
        this.instructions = builder.instructions;
        this.counter = builder.getVar("@counter");
        this.unit = builder.getVar("@unit");
        this.thisv = builder.getVar("@this");
        this.ipt = builder.putConst("@ipt", (Object)(this.build != null ? this.build.ipt : 0));
    }

    @Nullable
    public LVar optionalVar(String name) {
        if (this.nameMap == null) {
            this.nameMap = new ObjectIntMap();
            for (int i = 0; i < this.vars.length; ++i) {
                this.nameMap.put((Object)this.vars[i].name, i);
            }
        }
        return this.optionalVar(this.nameMap.get((Object)name, -1));
    }

    @Nullable
    public LVar optionalVar(int index) {
        return index < 0 || index >= this.vars.length ? null : this.vars[index];
    }

    static boolean checkMapArea(int x, int y, int w, int h, boolean set) {
        boolean full;
        x = Math.max(x, 0);
        y = Math.max(y, 0);
        w = Math.min(Vars.world.width(), w);
        h = Math.min(Vars.world.height(), h);
        boolean bl = full = x == 0 && y == 0 && w == Vars.world.width() && h == Vars.world.height();
        if (Vars.state.rules.limitMapArea) {
            if (Vars.state.rules.limitX == x && Vars.state.rules.limitY == y && Vars.state.rules.limitWidth == w && Vars.state.rules.limitHeight == h) {
                return true;
            }
            if (full && set) {
                int prevX = Vars.state.rules.limitX;
                int prevY = Vars.state.rules.limitY;
                int prevW = Vars.state.rules.limitWidth;
                int prevH = Vars.state.rules.limitHeight;
                Vars.state.rules.limitMapArea = false;
                if (!Vars.headless) {
                    Vars.renderer.updateAllDarkness();
                }
                Vars.world.checkMapArea(prevX, prevY, prevW, prevH);
                return false;
            }
        } else if (full) {
            return true;
        }
        if (set) {
            int prevX = Vars.state.rules.limitX;
            int prevY = Vars.state.rules.limitY;
            int prevW = Vars.state.rules.limitWidth;
            int prevH = Vars.state.rules.limitHeight;
            if (!Vars.state.rules.limitMapArea) {
                prevW = 0;
                prevH = 0;
                prevX = -1;
                prevY = -1;
            }
            Vars.state.rules.limitMapArea = true;
            Vars.state.rules.limitX = x;
            Vars.state.rules.limitY = y;
            Vars.state.rules.limitWidth = w;
            Vars.state.rules.limitHeight = h;
            Vars.world.checkMapArea(prevX, prevY, prevW, prevH);
            if (!Vars.headless) {
                Vars.renderer.updateAllDarkness();
            }
        }
        return false;
    }

    public static void setMapArea(int x, int y, int w, int h) {
        LExecutor.checkMapArea(x, y, w, h, true);
    }

    public static void logicExplosion(Team team, float x, float y, float radius, float damage, boolean air, boolean ground, boolean pierce, boolean effect) {
        if (damage < 0.0f) {
            return;
        }
        Damage.damage(team, x, y, radius, damage, pierce, air, ground, true, null);
        if (effect) {
            if (pierce) {
                Fx.spawnShockwave.at(x, y, World.conv(radius));
            } else {
                Fx.dynamicExplosion.at(x, y, World.conv(radius) / 8.0f);
            }
        }
    }

    public static void syncVariable(Building building, int variable, Object value) {
        if (building instanceof LogicBlock.LogicBuild) {
            LogicBlock.LogicBuild build = (LogicBlock.LogicBuild)building;
            LVar v = build.executor.optionalVar(variable);
            if (v != null && !v.constant) {
                if (value instanceof Number) {
                    Number n = (Number)value;
                    v.isobj = false;
                    v.numval = n.doubleValue();
                } else {
                    v.isobj = true;
                    v.objval = value;
                }
            }
        }
    }

    public static void setFlag(String flag, boolean add) {
        if (add) {
            Vars.state.rules.objectiveFlags.add((Object)flag);
        } else {
            Vars.state.rules.objectiveFlags.remove((Object)flag);
        }
    }

    public static void createMarker(int id, MapObjectives.ObjectiveMarker marker) {
        Vars.state.markers.add(id, marker);
    }

    public static void removeMarker(int id) {
        Vars.state.markers.remove(id);
    }

    public static void updateMarker(int id, LMarkerControl control, double p1, double p2, double p3) {
        MapObjectives.ObjectiveMarker marker = Vars.state.markers.get(id);
        if (marker != null) {
            marker.control(control, p1, p2, p3);
        }
    }

    public static void updateMarkerText(int id, LMarkerControl type, boolean fetch, String text) {
        MapObjectives.ObjectiveMarker marker = Vars.state.markers.get(id);
        if (marker != null && type == LMarkerControl.flushText) {
            marker.setText(text, fetch);
        }
    }

    public static void updateMarkerTexture(int id, String textureName) {
        MapObjectives.ObjectiveMarker marker = Vars.state.markers.get(id);
        if (marker != null) {
            marker.setTexture(textureName);
        }
    }

    static {
        Events.on(EventType.ResetEvent.class, e -> unitTimeouts.clear());
    }

    public static class LocalePrintI
    implements LInstruction {
        public LVar name;

        public LocalePrintI(LVar name) {
            this.name = name;
        }

        public LocalePrintI() {
        }

        public void run(LExecutor exec) {
            if (exec.textBuffer.length() >= 400) {
                return;
            }
            if (this.name.isobj) {
                String name = PrintI.toString(this.name.objval);
                String strValue = Vars.mobile ? (Vars.state.mapLocales.containsProperty(name + ".mobile") ? Vars.state.mapLocales.getProperty(name + ".mobile") : Vars.state.mapLocales.getProperty(name)) : Vars.state.mapLocales.getProperty(name);
                exec.textBuffer.append(strValue);
            }
        }
    }

    public static class MakeMarkerI
    implements LInstruction {
        public static final int maxMarkers = 20000;
        public String type = "shape";
        public LVar id;
        public LVar x;
        public LVar y;
        public LVar replace;

        public MakeMarkerI(String type, LVar id, LVar x, LVar y, LVar replace) {
            this.type = type;
            this.id = id;
            this.x = x;
            this.y = y;
            this.replace = replace;
        }

        public MakeMarkerI() {
        }

        public void run(LExecutor exec) {
            Prov cons = (Prov)MapObjectives.markerNameToType.get((Object)this.type);
            if (cons != null && Vars.state.markers.size() < 20000) {
                int mid = this.id.numi();
                if (this.replace.bool() || !Vars.state.markers.has(mid)) {
                    MapObjectives.ObjectiveMarker marker = (MapObjectives.ObjectiveMarker)cons.get();
                    marker.control(LMarkerControl.pos, this.x.num(), this.y.num(), 0.0);
                    Vars.state.markers.add(mid, marker);
                }
            }
        }
    }

    public static class SetMarkerI
    implements LInstruction {
        public LMarkerControl type = LMarkerControl.pos;
        public LVar id;
        public LVar p1;
        public LVar p2;
        public LVar p3;

        public SetMarkerI(LMarkerControl type, LVar id, LVar p1, LVar p2, LVar p3) {
            this.type = type;
            this.id = id;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
        }

        public SetMarkerI() {
        }

        public void run(LExecutor exec) {
            if (this.type == LMarkerControl.remove) {
                Vars.state.markers.remove(this.id.numi());
            } else {
                MapObjectives.ObjectiveMarker marker = Vars.state.markers.get(this.id.numi());
                if (marker == null) {
                    return;
                }
                if (this.type == LMarkerControl.flushText) {
                    marker.setText(exec.textBuffer.toString(), this.p1.bool());
                    exec.textBuffer.setLength(0);
                } else if (this.type == LMarkerControl.texture) {
                    if (this.p1.bool()) {
                        marker.setTexture(exec.textBuffer.toString());
                        exec.textBuffer.setLength(0);
                    } else {
                        marker.setTexture(PrintI.toString(this.p2.obj()));
                    }
                } else {
                    marker.control(this.type, this.p1.numOrNan(), this.p2.numOrNan(), this.p3.numOrNan());
                }
            }
        }
    }

    public static class PlaySoundI
    implements LInstruction {
        public boolean positional;
        public LVar id;
        public LVar volume;
        public LVar pitch;
        public LVar pan;
        public LVar x;
        public LVar y;
        public LVar limit;

        public PlaySoundI() {
        }

        public PlaySoundI(boolean positional, LVar id, LVar volume, LVar pitch, LVar pan, LVar x, LVar y, LVar limit) {
            this.positional = positional;
            this.id = id;
            this.volume = volume;
            this.pitch = pitch;
            this.pan = pan;
            this.x = x;
            this.y = y;
            this.limit = limit;
        }

        public void run(LExecutor exec) {
            Sound sound = Sounds.getSound((int)this.id.numi());
            if (sound == null) {
                sound = Sounds.none;
            }
            if (this.positional) {
                sound.at(World.unconv(this.x.numf()), World.unconv(this.y.numf()), this.pitch.numf(), Math.min(this.volume.numf(), 2.0f), this.limit.bool());
            } else {
                sound.play(Math.min(this.volume.numf() * ((float)Core.settings.getInt("sfxvol") / 100.0f), 2.0f), this.pitch.numf(), this.pan.numf(), false, this.limit.bool());
            }
        }
    }

    public static class SetPropI
    implements LInstruction {
        public LVar type;
        public LVar of;
        public LVar value;

        public SetPropI(LVar type, LVar of, LVar value) {
            this.type = type;
            this.of = of;
            this.value = value;
        }

        public SetPropI() {
        }

        public void run(LExecutor exec) {
            Object object = this.of.obj();
            if (object instanceof Settable) {
                Settable sp = (Settable)object;
                Object key = this.type.obj();
                if (key instanceof LAccess) {
                    LAccess property = (LAccess)key;
                    if (this.value.isobj) {
                        sp.setProp(property, this.value.objval);
                    } else {
                        sp.setProp(property, this.value.numval);
                    }
                } else if (key instanceof UnlockableContent) {
                    UnlockableContent content = (UnlockableContent)((Object)key);
                    sp.setProp(content, this.value.num());
                }
            }
        }
    }

    public static class SpawnWaveI
    implements LInstruction {
        public LVar natural;
        public LVar x;
        public LVar y;

        public SpawnWaveI() {
        }

        public SpawnWaveI(LVar natural, LVar x, LVar y) {
            this.natural = natural;
            this.x = x;
            this.y = y;
        }

        public void run(LExecutor exec) {
            if (Vars.net.client()) {
                return;
            }
            if (this.natural.bool()) {
                Vars.logic.skipWave();
                return;
            }
            float spawnX = World.unconv(this.x.numf());
            float spawnY = World.unconv(this.y.numf());
            int packed = Point2.pack((int)this.x.numi(), (int)this.y.numi());
            for (SpawnGroup group : Vars.state.rules.spawns) {
                if (group.type == null || group.spawn != -1 && group.spawn != packed) continue;
                int spawned = group.getSpawned(Vars.state.wave - 1);
                float spread = 16.0f;
                for (int i = 0; i < spawned; ++i) {
                    Tmp.v1.rnd(spread);
                    Vars.spawner.spawnUnit(group, spawnX + Tmp.v1.x, spawnY + Tmp.v1.y);
                }
            }
        }
    }

    public static class SetFlagI
    implements LInstruction {
        public LVar flag;
        public LVar value;

        public SetFlagI(LVar flag, LVar value) {
            this.flag = flag;
            this.value = value;
        }

        public SetFlagI() {
        }

        public void run(LExecutor exec) {
            String str;
            Object object = this.flag.obj();
            if (object instanceof String && Vars.state.rules.objectiveFlags.contains((Object)(str = (String)object)) != this.value.bool()) {
                Call.setFlag((String)str, (boolean)this.value.bool());
            }
        }
    }

    public static class GetFlagI
    implements LInstruction {
        public LVar result;
        public LVar flag;

        public GetFlagI(LVar result, LVar flag) {
            this.result = result;
            this.flag = flag;
        }

        public GetFlagI() {
        }

        public void run(LExecutor exec) {
            Object object = this.flag.obj();
            if (object instanceof String) {
                String str = (String)object;
                this.result.setbool(Vars.state.rules.objectiveFlags.contains((Object)str));
            } else {
                this.result.setobj(null);
            }
        }
    }

    public static class ClientDataI
    implements LInstruction {
        public LVar channel;
        public LVar value;
        public LVar reliable;

        public ClientDataI(LVar channel, LVar value, LVar reliable) {
            this.channel = channel;
            this.value = value;
            this.reliable = reliable;
        }

        public ClientDataI() {
        }

        public void run(LExecutor exec) {
            Object object = this.channel.obj();
            if (object instanceof String) {
                Object v;
                String c = (String)object;
                Object object2 = v = this.value.isobj ? this.value.objval : Double.valueOf(this.value.numval);
                if (this.reliable.bool()) {
                    Call.clientLogicDataReliable((String)c, (Object)v);
                } else {
                    Call.clientLogicDataUnreliable((String)c, (Object)v);
                }
            }
        }
    }

    public static class SyncI
    implements LInstruction {
        public static long syncInterval = 50L;
        public LVar variable;

        public SyncI(LVar variable) {
            this.variable = variable;
        }

        public SyncI() {
        }

        public void run(LExecutor exec) {
            if (!this.variable.constant && Time.timeSinceMillis((long)this.variable.syncTime) > syncInterval) {
                this.variable.syncTime = Time.millis();
                Call.syncVariable((Building)exec.build, (int)this.variable.id, (Object)(this.variable.isobj ? this.variable.objval : Double.valueOf(this.variable.numval)));
            }
        }
    }

    public static class SetRateI
    implements LInstruction {
        public LVar amount;

        public SetRateI(LVar amount) {
            this.amount = amount;
        }

        public SetRateI() {
        }

        public void run(LExecutor exec) {
            exec.build.ipt = Mathf.clamp((int)this.amount.numi(), (int)1, (int)((LogicBlock)exec.build.block).maxInstructionsPerTick);
            if (exec.ipt != null) {
                exec.ipt.numval = exec.build.ipt;
            }
        }
    }

    public static class ExplosionI
    implements LInstruction {
        public LVar team;
        public LVar x;
        public LVar y;
        public LVar radius;
        public LVar damage;
        public LVar air;
        public LVar ground;
        public LVar pierce;
        public LVar effect;

        public ExplosionI(LVar team, LVar x, LVar y, LVar radius, LVar damage, LVar air, LVar ground, LVar pierce, LVar effect) {
            this.team = team;
            this.x = x;
            this.y = y;
            this.radius = radius;
            this.damage = damage;
            this.air = air;
            this.ground = ground;
            this.pierce = pierce;
            this.effect = effect;
        }

        public ExplosionI() {
        }

        public void run(LExecutor exec) {
            if (Vars.net.client()) {
                return;
            }
            Team t = this.team.team();
            Call.logicExplosion((Team)t, (float)World.unconv(this.x.numf()), (float)World.unconv(this.y.numf()), (float)World.unconv(Math.min(this.radius.numf(), 100.0f)), (float)this.damage.numf(), (boolean)this.air.bool(), (boolean)this.ground.bool(), (boolean)this.pierce.bool(), (boolean)this.effect.bool());
        }
    }

    public static class EffectI
    implements LInstruction {
        public LogicFx.EffectEntry type;
        public LVar x;
        public LVar y;
        public LVar rotation;
        public LVar color;
        public LVar data;

        public EffectI(LogicFx.EffectEntry type, LVar x, LVar y, LVar rotation, LVar color, LVar data) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.rotation = rotation;
            this.color = color;
            this.data = data;
        }

        public EffectI() {
        }

        public void run(LExecutor exec) {
            if (this.type != null) {
                double col = this.color.num();
                float rot = this.type.rotate ? this.rotation.numf() : Math.min(this.rotation.numf(), 1000.0f);
                this.type.effect.at(World.unconv(this.x.numf()), World.unconv(this.y.numf()), rot, Tmp.c1.fromDouble(col), this.data.obj());
            }
        }
    }

    public static class FlushMessageI
    implements LInstruction {
        public MessageType type = MessageType.announce;
        public LVar duration;
        public LVar outSuccess;

        public FlushMessageI(MessageType type, LVar duration, LVar outSuccess) {
            this.type = type;
            this.duration = duration;
            this.outSuccess = outSuccess;
        }

        public FlushMessageI() {
        }

        public void run(LExecutor exec) {
            String substr;
            this.outSuccess.setnum(1.0);
            if (Vars.headless && this.type != MessageType.mission) {
                exec.textBuffer.setLength(0);
                return;
            }
            if (this.type == MessageType.announce && Vars.ui.hasAnnouncement() || this.type == MessageType.notify && Vars.ui.hudfrag.hasToast() || this.type == MessageType.toast && Vars.ui.hasAnnouncement()) {
                if (this.outSuccess == Vars.logicVars.waitVar()) {
                    exec.counter.numval -= 1.0;
                    exec.yield = true;
                } else {
                    this.outSuccess.setnum(0.0);
                }
                return;
            }
            String text = UI.formatIcons(exec.textBuffer.toString());
            if (text.startsWith("@") && Core.bundle.has(substr = text.substring(1))) {
                text = Core.bundle.get(substr);
            }
            switch (this.type) {
                case notify: {
                    Vars.ui.hudfrag.showToast((Drawable)Icon.info, text);
                    new ArcMessageDialog.Msg(ArcMessageDialog.Type.logicNotify, text).add();
                    break;
                }
                case announce: {
                    Vars.ui.announce(text, this.duration.numf());
                    new ArcMessageDialog.Msg(ArcMessageDialog.Type.logicAnnounce, text).add();
                    break;
                }
                case toast: {
                    Vars.ui.showInfoToast(text, this.duration.numf());
                    break;
                }
                case mission: {
                    Vars.state.rules.mission = text;
                }
            }
            exec.textBuffer.setLength(0);
        }
    }

    public static class SetRuleI
    implements LInstruction {
        public LogicRule rule = LogicRule.waveSpacing;
        public LVar value;
        public LVar p1;
        public LVar p2;
        public LVar p3;
        public LVar p4;

        public SetRuleI(LogicRule rule, LVar value, LVar p1, LVar p2, LVar p3, LVar p4) {
            this.rule = rule;
            this.value = value;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.p4 = p4;
        }

        public SetRuleI() {
        }

        public void run(LExecutor exec) {
            block0 : switch (this.rule) {
                case waveTimer: {
                    Vars.state.rules.waveTimer = this.value.bool();
                    break;
                }
                case wave: {
                    Vars.state.wave = Math.max(this.value.numi(), 1);
                    break;
                }
                case currentWaveTime: {
                    Vars.state.wavetime = Math.max(this.value.numf() * 60.0f, 0.0f);
                    break;
                }
                case waves: {
                    Vars.state.rules.waves = this.value.bool();
                    break;
                }
                case waveSending: {
                    Vars.state.rules.waveSending = this.value.bool();
                    break;
                }
                case attackMode: {
                    Vars.state.rules.attackMode = this.value.bool();
                    break;
                }
                case waveSpacing: {
                    Vars.state.rules.waveSpacing = this.value.numf() * 60.0f;
                    break;
                }
                case enemyCoreBuildRadius: {
                    Vars.state.rules.enemyCoreBuildRadius = this.value.numf() * 8.0f;
                    break;
                }
                case dropZoneRadius: {
                    Vars.state.rules.dropZoneRadius = this.value.numf() * 8.0f;
                    break;
                }
                case unitCap: {
                    Vars.state.rules.unitCap = Math.max(this.value.numi(), 0);
                    break;
                }
                case lighting: {
                    Vars.state.rules.lighting = this.value.bool();
                    break;
                }
                case canGameOver: {
                    Vars.state.rules.canGameOver = this.value.bool();
                    break;
                }
                case mapArea: {
                    int x = this.p1.numi();
                    int y = this.p2.numi();
                    int w = this.p3.numi();
                    int h = this.p4.numi();
                    if (LExecutor.checkMapArea(x, y, w, h, false)) break;
                    Call.setMapArea((int)x, (int)y, (int)w, (int)h);
                    break;
                }
                case ambientLight: {
                    Vars.state.rules.ambientLight.fromDouble(this.value.num());
                    break;
                }
                case solarMultiplier: {
                    Vars.state.rules.solarMultiplier = Math.max(this.value.numf(), 0.0f);
                    break;
                }
                case dragMultiplier: {
                    Vars.state.rules.dragMultiplier = Math.max(this.value.numf(), 0.0f);
                    break;
                }
                case ban: {
                    Object cont = this.value.obj();
                    if (cont instanceof Block) {
                        Block b = (Block)((Object)cont);
                        if (!Vars.state.rules.bannedBlocks.add((Object)b) || Vars.headless) break;
                        Vars.ui.hudfrag.blockfrag.rebuild();
                        break;
                    }
                    if (!(cont instanceof UnitType)) break;
                    UnitType u = (UnitType)((Object)cont);
                    Vars.state.rules.bannedUnits.add((Object)u);
                    break;
                }
                case unban: {
                    Object cont = this.value.obj();
                    if (cont instanceof Block) {
                        Block b = (Block)((Object)cont);
                        if (!Vars.state.rules.bannedBlocks.remove((Object)b) || Vars.headless) break;
                        Vars.ui.hudfrag.blockfrag.rebuild();
                        break;
                    }
                    if (!(cont instanceof UnitType)) break;
                    UnitType u = (UnitType)((Object)cont);
                    Vars.state.rules.bannedUnits.remove((Object)u);
                    break;
                }
                case buildSpeed: 
                case unitHealth: 
                case unitBuildSpeed: 
                case unitMineSpeed: 
                case unitCost: 
                case unitDamage: 
                case blockHealth: 
                case blockDamage: 
                case rtsMinWeight: 
                case rtsMinSquad: {
                    Team team = this.p1.team();
                    if (team == null) break;
                    float num = this.value.numf();
                    switch (this.rule) {
                        case buildSpeed: {
                            team.rules().buildSpeedMultiplier = Mathf.clamp((float)num, (float)0.001f, (float)50.0f);
                            break block0;
                        }
                        case unitHealth: {
                            team.rules().unitHealthMultiplier = Math.max(num, 0.001f);
                            break block0;
                        }
                        case unitBuildSpeed: {
                            team.rules().unitBuildSpeedMultiplier = Mathf.clamp((float)num, (float)0.0f, (float)50.0f);
                            break block0;
                        }
                        case unitMineSpeed: {
                            team.rules().unitMineSpeedMultiplier = Math.max(num, 0.0f);
                            break block0;
                        }
                        case unitCost: {
                            team.rules().unitCostMultiplier = Math.max(num, 0.0f);
                            break block0;
                        }
                        case unitDamage: {
                            team.rules().unitDamageMultiplier = Math.max(num, 0.0f);
                            break block0;
                        }
                        case blockHealth: {
                            team.rules().blockHealthMultiplier = Math.max(num, 0.001f);
                            break block0;
                        }
                        case blockDamage: {
                            team.rules().blockDamageMultiplier = Math.max(num, 0.0f);
                            break block0;
                        }
                        case rtsMinWeight: {
                            team.rules().rtsMinWeight = num;
                            break block0;
                        }
                        case rtsMinSquad: {
                            team.rules().rtsMinSquad = (int)num;
                        }
                    }
                }
            }
        }
    }

    public static class ApplyEffectI
    implements LInstruction {
        public boolean clear;
        public String effect;
        public LVar unit;
        public LVar duration;

        public ApplyEffectI(boolean clear, String effect, LVar unit, LVar duration) {
            this.clear = clear;
            this.effect = effect;
            this.unit = unit;
            this.duration = duration;
        }

        public ApplyEffectI() {
        }

        public void run(LExecutor exec) {
            if (Vars.net.client()) {
                return;
            }
            Object object = this.unit.obj();
            if (object instanceof Unit) {
                Unit unit = (Unit)object;
                if (Vars.content.statusEffect(this.effect) != null) {
                    if (this.clear) {
                        unit.unapply(Vars.content.statusEffect(this.effect));
                    } else {
                        unit.apply(Vars.content.statusEffect(this.effect), this.duration.numf() * 60.0f);
                    }
                }
            }
        }
    }

    public static class SetWeatherI
    implements LInstruction {
        public LVar type;
        public LVar state;

        public SetWeatherI(LVar type, LVar state) {
            this.type = type;
            this.state = state;
        }

        public void run(LExecutor exec) {
            Object object = this.type.obj();
            if (object instanceof Weather) {
                Weather weather = (Weather)((Object)object);
                if (this.state.bool()) {
                    if (!weather.isActive()) {
                        Tmp.v1.setToRandomDirection();
                        Call.createWeather((Weather)weather, (float)1.0f, (float)240.0f, (float)Tmp.v1.x, (float)Tmp.v1.y);
                    } else {
                        weather.instance().life(240.0f);
                    }
                } else if (weather.isActive() && weather.instance().life > 240.0f) {
                    weather.instance().life(240.0f);
                }
            }
        }
    }

    public static class SenseWeatherI
    implements LInstruction {
        public LVar type;
        public LVar to;

        public SenseWeatherI(LVar type, LVar to) {
            this.type = type;
            this.to = to;
        }

        public void run(LExecutor exec) {
            Weather weather;
            Object object = this.type.obj();
            this.to.setbool(object instanceof Weather && (weather = (Weather)((Object)object)).isActive());
        }
    }

    public static class SpawnUnitI
    implements LInstruction {
        public LVar type;
        public LVar x;
        public LVar y;
        public LVar rotation;
        public LVar team;
        public LVar result;

        public SpawnUnitI(LVar type, LVar x, LVar y, LVar rotation, LVar team, LVar result) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.rotation = rotation;
            this.team = team;
            this.result = result;
        }

        public SpawnUnitI() {
        }

        public void run(LExecutor exec) {
            Object object;
            if (Vars.net.client()) {
                return;
            }
            Team t = this.team.team();
            if (t != null && (object = this.type.obj()) instanceof UnitType) {
                UnitType type = (UnitType)((Object)object);
                if (!type.internal && Units.canCreate(t, type)) {
                    Unit unit = type.spawn(t, World.unconv(this.x.numf()) + Mathf.range((float)0.01f), World.unconv(this.y.numf()) + Mathf.range((float)0.01f), this.rotation.numf());
                    Vars.spawner.spawnEffect(unit);
                    this.result.setobj((Object)unit);
                }
            }
        }
    }

    public static class SetBlockI
    implements LInstruction {
        public LVar x;
        public LVar y;
        public LVar block;
        public LVar team;
        public LVar rotation;
        public TileLayer layer = TileLayer.block;

        public SetBlockI(LVar x, LVar y, LVar block, LVar team, LVar rotation, TileLayer layer) {
            this.x = x;
            this.y = y;
            this.block = block;
            this.team = team;
            this.rotation = rotation;
            this.layer = layer;
        }

        public SetBlockI() {
        }

        public void run(LExecutor exec) {
            Object object;
            if (Vars.net.client()) {
                return;
            }
            Tile tile = Vars.world.tile(this.x.numi(), this.y.numi());
            if (tile != null && (object = this.block.obj()) instanceof Block) {
                Block b = (Block)((Object)object);
                switch (this.layer) {
                    case ore: {
                        if (!(b instanceof OverlayFloor) && b != Blocks.air || tile.overlay() == b) break;
                        tile.setOverlayNet(b);
                        break;
                    }
                    case floor: {
                        if (!(b instanceof Floor)) break;
                        Floor f = (Floor)b;
                        if (tile.floor() == f || f.isOverlay() || f.isAir()) break;
                        tile.setFloorNet((Block)f);
                        break;
                    }
                    case block: {
                        if (b.isFloor() && b != Blocks.air) break;
                        Team t = this.team.team();
                        if (t == null) {
                            t = Team.derelict;
                        }
                        if (tile.block() == b && tile.team() == t) break;
                        tile.setNet(b, t, Mathf.clamp((int)this.rotation.numi(), (int)0, (int)3));
                    }
                }
            }
        }
    }

    public static class GetBlockI
    implements LInstruction {
        public LVar x;
        public LVar y;
        public LVar dest;
        public TileLayer layer = TileLayer.block;

        public GetBlockI(LVar x, LVar y, LVar dest, TileLayer layer) {
            this.x = x;
            this.y = y;
            this.dest = dest;
            this.layer = layer;
        }

        public GetBlockI() {
        }

        public void run(LExecutor exec) {
            Tile tile = Vars.world.tile(Mathf.round((float)this.x.numf()), Mathf.round((float)this.y.numf()));
            if (tile == null) {
                this.dest.setobj(null);
            } else {
                Object object;
                switch (this.layer) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case floor: {
                        object = tile.floor();
                        break;
                    }
                    case ore: {
                        object = tile.overlay();
                        break;
                    }
                    case block: {
                        object = tile.block();
                        break;
                    }
                    case building: {
                        object = tile.build;
                    }
                }
                this.dest.setobj(object);
            }
        }
    }

    public static class FetchI
    implements LInstruction {
        public FetchType type = FetchType.unit;
        public LVar result;
        public LVar team;
        public LVar extra;
        public LVar index;

        public FetchI(FetchType type, LVar result, LVar team, LVar extra, LVar index) {
            this.type = type;
            this.result = result;
            this.team = team;
            this.extra = extra;
            this.index = index;
        }

        public FetchI() {
        }

        public void run(LExecutor exec) {
            int i = this.index.numi();
            Team t = this.team.team();
            if (t == null) {
                return;
            }
            Teams.TeamData data = t.data();
            switch (this.type) {
                case unit: {
                    UnitType u;
                    UnitType type;
                    Object object = this.extra.obj();
                    UnitType unitType = type = object instanceof UnitType ? (u = (UnitType)((Object)object)) : null;
                    if (type == null) {
                        this.result.setobj(i < 0 || i >= data.units.size ? null : data.units.get(i));
                        break;
                    }
                    Seq units = data.unitCache(type);
                    this.result.setobj(units == null || i < 0 || i >= units.size ? null : units.get(i));
                    break;
                }
                case player: {
                    Healthc healthc;
                    if (i < 0 || i >= data.players.size) {
                        healthc = null;
                    } else {
                        Unit units = ((Player)data.players.get(i)).unit();
                        if (units instanceof BlockUnitc) {
                            BlockUnitc block = (BlockUnitc)units;
                            healthc = block.tile();
                        } else {
                            healthc = ((Player)data.players.get(i)).unit();
                        }
                    }
                    this.result.setobj(healthc);
                    break;
                }
                case core: {
                    this.result.setobj(i < 0 || i >= data.cores.size ? null : data.cores.get(i));
                    break;
                }
                case build: {
                    Block b;
                    Block block;
                    Object object = this.extra.obj();
                    Block block2 = block = object instanceof Block ? (b = (Block)((Object)object)) : null;
                    if (block == null) {
                        this.result.setobj(i < 0 || i >= data.buildings.size ? null : data.buildings.get(i));
                        break;
                    }
                    Seq builds = data.getBuildings(block);
                    this.result.setobj(i < 0 || i >= builds.size ? null : builds.get(i));
                    break;
                }
                case unitCount: {
                    UnitType u;
                    UnitType type;
                    Object object = this.extra.obj();
                    UnitType unitType = type = object instanceof UnitType ? (u = (UnitType)((Object)object)) : null;
                    if (type == null) {
                        this.result.setnum((double)data.units.size);
                        break;
                    }
                    this.result.setnum(data.unitCache(type) == null ? 0.0 : (double)data.unitCache((UnitType)type).size);
                    break;
                }
                case coreCount: {
                    this.result.setnum((double)data.cores.size);
                    break;
                }
                case playerCount: {
                    this.result.setnum((double)data.players.size);
                    break;
                }
                case buildCount: {
                    Block b;
                    Block block;
                    Object object = this.extra.obj();
                    Block block3 = block = object instanceof Block ? (b = (Block)((Object)object)) : null;
                    if (block == null) {
                        this.result.setnum((double)data.buildings.size);
                        break;
                    }
                    this.result.setnum((double)data.getBuildings((Block)block).size);
                }
            }
        }
    }

    public static class CutsceneI
    implements LInstruction {
        public CutsceneAction action = CutsceneAction.stop;
        public LVar p1;
        public LVar p2;
        public LVar p3;
        public LVar p4;

        public CutsceneI(CutsceneAction action, LVar p1, LVar p2, LVar p3, LVar p4) {
            this.action = action;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.p4 = p4;
        }

        public CutsceneI() {
        }

        public void run(LExecutor exec) {
            if (Vars.headless) {
                return;
            }
            if (Core.settings.getBool("removeLogicLock")) {
                return;
            }
            switch (this.action) {
                case pan: {
                    Vars.control.input.logicCutscene = true;
                    Vars.control.input.logicCamPan.set(World.unconv(this.p1.numf()), World.unconv(this.p2.numf()));
                    Vars.control.input.logicCamSpeed = this.p3.numf();
                    break;
                }
                case zoom: {
                    Vars.control.input.logicCutscene = true;
                    Vars.control.input.logicCutsceneZoom = Mathf.clamp((float)this.p1.numf());
                    break;
                }
                case stop: {
                    Vars.control.input.logicCutscene = false;
                }
            }
        }
    }

    public static class UnpackColorI
    implements LInstruction {
        public LVar r;
        public LVar g;
        public LVar b;
        public LVar a;
        public LVar value;

        public UnpackColorI(LVar r, LVar g, LVar b, LVar a, LVar value) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.value = value;
        }

        public UnpackColorI() {
        }

        public void run(LExecutor exec) {
            Color color = Tmp.c1.fromDouble(this.value.num());
            this.r.setnum((double)color.r);
            this.g.setnum((double)color.g);
            this.b.setnum((double)color.b);
            this.a.setnum((double)color.a);
        }
    }

    public static class PackColorI
    implements LInstruction {
        public LVar result;
        public LVar r;
        public LVar g;
        public LVar b;
        public LVar a;

        public PackColorI(LVar result, LVar r, LVar g, LVar b, LVar a) {
            this.result = result;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        public PackColorI() {
        }

        public void run(LExecutor exec) {
            this.result.setnum(Color.toDoubleBits((float)Mathf.clamp((float)this.r.numf()), (float)Mathf.clamp((float)this.g.numf()), (float)Mathf.clamp((float)this.b.numf()), (float)Mathf.clamp((float)this.a.numf())));
        }
    }

    public static class LookupI
    implements LInstruction {
        public LVar dest;
        public LVar from;
        public ContentType type;

        public LookupI(LVar dest, LVar from, ContentType type) {
            this.dest = dest;
            this.from = from;
            this.type = type;
        }

        public LookupI() {
        }

        public void run(LExecutor exec) {
            this.dest.setobj(Vars.logicVars.lookupContent(this.type, this.from.numi()));
        }
    }

    public static class StopI
    implements LInstruction {
        public void run(LExecutor exec) {
            exec.counter.numval -= 1.0;
            exec.yield = true;
        }
    }

    public static class WaitI
    implements LInstruction {
        public LVar value;
        public float curTime;

        public WaitI(LVar value) {
            this.value = value;
        }

        public WaitI() {
        }

        public void run(LExecutor exec) {
            if ((double)this.curTime >= this.value.num()) {
                this.curTime = 0.0f;
            } else {
                exec.counter.numval -= 1.0;
                exec.yield = true;
                this.curTime += Time.delta / 60.0f;
            }
        }
    }

    public static class JumpI
    implements LInstruction {
        public ConditionOp op = ConditionOp.notEqual;
        public LVar value;
        public LVar compare;
        public int address;

        public JumpI(ConditionOp op, LVar value, LVar compare, int address) {
            this.op = op;
            this.value = value;
            this.compare = compare;
            this.address = address;
        }

        public JumpI() {
        }

        public void run(LExecutor exec) {
            if (this.address != -1 && this.op.test(this.value, this.compare)) {
                exec.counter.numval = this.address;
            }
        }
    }

    public static class PrintFlushI
    implements LInstruction {
        public LVar target;

        public PrintFlushI(LVar target) {
            this.target = target;
        }

        public PrintFlushI() {
        }

        public void run(LExecutor exec) {
            MessageBlock.MessageBuild d;
            Building building = this.target.building();
            if (building instanceof MessageBlock.MessageBuild && (d = (MessageBlock.MessageBuild)building).isValid() && (exec.privileged || d.team == exec.team && !d.block.privileged)) {
                d.message.setLength(0);
                d.message.append(exec.textBuffer, 0, Math.min(exec.textBuffer.length(), 400));
            }
            exec.textBuffer.setLength(0);
        }
    }

    public static class FormatI
    implements LInstruction {
        public LVar value;

        public FormatI(LVar value) {
            this.value = value;
        }

        FormatI() {
        }

        public void run(LExecutor exec) {
            if (exec.textBuffer.length() >= 400) {
                return;
            }
            int placeholderIndex = -1;
            int placeholderNumber = 10;
            for (int i = 0; i < exec.textBuffer.length(); ++i) {
                char numChar;
                if (exec.textBuffer.charAt(i) != '{' || exec.textBuffer.length() - i <= 2 || (numChar = exec.textBuffer.charAt(i + 1)) < '0' || numChar > '9' || exec.textBuffer.charAt(i + 2) != '}' || numChar - 48 >= placeholderNumber) continue;
                placeholderNumber = numChar - 48;
                placeholderIndex = i;
            }
            if (placeholderIndex == -1) {
                return;
            }
            if (this.value.isobj) {
                String strValue = PrintI.toString(this.value.objval);
                exec.textBuffer.replace(placeholderIndex, placeholderIndex + 3, strValue);
            } else if (Math.abs(this.value.numval - (double)Math.round(this.value.numval)) < 1.0E-5) {
                exec.textBuffer.replace(placeholderIndex, placeholderIndex + 3, Math.round(this.value.numval) + "");
            } else {
                exec.textBuffer.replace(placeholderIndex, placeholderIndex + 3, this.value.numval + "");
            }
        }
    }

    public static class PrintCharI
    implements LInstruction {
        public LVar value;

        public PrintCharI(LVar value) {
            this.value = value;
        }

        PrintCharI() {
        }

        public void run(LExecutor exec) {
            if (exec.textBuffer.length() >= 400) {
                return;
            }
            if (this.value.isobj) {
                Object object = this.value.objval;
                if (!(object instanceof UnlockableContent)) {
                    return;
                }
                UnlockableContent cont = (UnlockableContent)((Object)object);
                exec.textBuffer.append((char)cont.emojiChar());
                return;
            }
            exec.textBuffer.append((char)Math.floor(this.value.numval));
        }
    }

    public static class PrintI
    implements LInstruction {
        public LVar value;

        public PrintI(LVar value) {
            this.value = value;
        }

        PrintI() {
        }

        public void run(LExecutor exec) {
            if (exec.textBuffer.length() >= 400) {
                return;
            }
            if (this.value.isobj) {
                String strValue = PrintI.toString(this.value.objval);
                exec.textBuffer.append(strValue);
            } else if (Math.abs(this.value.numval - (double)Math.round(this.value.numval)) < 1.0E-5) {
                exec.textBuffer.append(Math.round(this.value.numval));
            } else {
                exec.textBuffer.append(this.value.numval);
            }
        }

        public static String toString(Object obj) {
            String string;
            if (obj == null) {
                string = "null";
            } else if (obj instanceof String) {
                String s;
                string = s = (String)obj;
            } else if (obj instanceof MappableContent) {
                MappableContent content = (MappableContent)obj;
                string = content.name;
            } else if (obj instanceof Content) {
                string = "[content]";
            } else if (obj instanceof Building) {
                Building build = (Building)obj;
                string = build.block.name;
            } else if (obj instanceof Unit) {
                Unit unit = (Unit)obj;
                string = unit.type.name;
            } else if (obj instanceof Enum) {
                Enum e = (Enum)obj;
                string = e.name();
            } else if (obj instanceof Team) {
                Team team = (Team)obj;
                string = team.name;
            } else {
                string = "[object]";
            }
            return string;
        }
    }

    public static class DrawFlushI
    implements LInstruction {
        public LVar target;

        public DrawFlushI(LVar target) {
            this.target = target;
        }

        public DrawFlushI() {
        }

        public void run(LExecutor exec) {
            LogicDisplay.LogicDisplayBuild d;
            if (Vars.headless) {
                return;
            }
            Building building = this.target.building();
            if (building instanceof LogicDisplay.LogicDisplayBuild && (d = (LogicDisplay.LogicDisplayBuild)building).isValid() && (d.team == exec.team || exec.privileged)) {
                d.flushCommands(exec.graphicsBuffer);
                exec.graphicsBuffer.clear();
            }
        }
    }

    public static class DrawI
    implements LInstruction {
        public byte type;
        public LVar x;
        public LVar y;
        public LVar p1;
        public LVar p2;
        public LVar p3;
        public LVar p4;

        public DrawI(byte type, LVar x, LVar y, LVar p1, LVar p2, LVar p3, LVar p4) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.p4 = p4;
        }

        public DrawI() {
        }

        public void run(LExecutor exec) {
            if (Vars.headless || exec.graphicsBuffer.size >= 256) {
                return;
            }
            if (this.type == 2) {
                double packed = this.x.num();
                int value = (int)Double.doubleToRawLongBits(packed);
                int r = (value & 0xFF000000) >>> 24;
                int g = (value & 0xFF0000) >>> 16;
                int b = (value & 0xFF00) >>> 8;
                int a = value & 0xFF;
                exec.graphicsBuffer.add(DisplayCmd.get((int)1, (int)DrawI.pack(r), (int)DrawI.pack(g), (int)DrawI.pack(b), (int)DrawI.pack(a), (int)0, (int)0));
            } else if (this.type == 11) {
                StringBuilder str = exec.textBuffer;
                if (str.length() > 0) {
                    Font.FontData data = Fonts.logic.getData();
                    int advance = (int)data.spaceXadvance;
                    int lineHeight = (int)data.lineHeight;
                    int align = this.p1.numi();
                    int maxWidth = 0;
                    int lines = 1;
                    int lineWidth = 0;
                    for (int i = 0; i < str.length(); ++i) {
                        char next = str.charAt(i);
                        if (next == '\n') {
                            maxWidth = Math.max(maxWidth, lineWidth);
                            lineWidth = 0;
                            ++lines;
                            continue;
                        }
                        ++lineWidth;
                    }
                    maxWidth = Math.max(maxWidth, lineWidth);
                    float width = maxWidth * advance;
                    float height = lines * lineHeight;
                    float ha = ((Align.isLeft((int)align) ? -1.0f : 0.0f) + 1.0f + (Align.isRight((int)align) ? 1.0f : 0.0f)) / 2.0f;
                    float va = ((Align.isBottom((int)align) ? -1.0f : 0.0f) + 1.0f + (Align.isTop((int)align) ? 1.0f : 0.0f)) / 2.0f;
                    int xOffset = -((int)(width * ha));
                    int yOffset = -((int)(height * va)) + (lines - 1) * lineHeight;
                    int curX = this.x.numi();
                    int curY = this.y.numi();
                    for (int i = 0; i < str.length(); ++i) {
                        char next = str.charAt(i);
                        if (next == '\n') {
                            curY -= lineHeight;
                            curX = this.x.numi();
                            continue;
                        }
                        if (Fonts.logic.getData().hasGlyph(next)) {
                            exec.graphicsBuffer.add(DisplayCmd.get((int)11, (int)DrawI.packSign(curX + xOffset), (int)DrawI.packSign(curY + yOffset), (int)next, (int)0, (int)0, (int)0));
                        }
                        curX += advance;
                    }
                    exec.textBuffer.setLength(0);
                }
            } else {
                int num1 = this.p1.numi();
                int num4 = this.p4.numi();
                int xval = DrawI.packSign(this.x.numi());
                int yval = DrawI.packSign(this.y.numi());
                if (this.type == 10) {
                    Object object = this.p1.obj();
                    if (object instanceof UnlockableContent) {
                        UnlockableContent u = (UnlockableContent)((Object)object);
                        num1 = u.id;
                        num4 = u.getContentType().ordinal();
                    } else {
                        num1 = -1;
                        num4 = -1;
                    }
                } else if (this.type == 13) {
                    xval = DrawI.packSign((int)(this.x.numf() / 0.05f));
                    yval = DrawI.packSign((int)(this.y.numf() / 0.05f));
                }
                exec.graphicsBuffer.add(DisplayCmd.get((int)this.type, (int)xval, (int)yval, (int)DrawI.packSign(num1), (int)DrawI.packSign(this.p2.numi()), (int)DrawI.packSign(this.p3.numi()), (int)DrawI.packSign(num4)));
            }
        }

        static int pack(int value) {
            return value & 0x1FF;
        }

        static int packSign(int value) {
            return Math.abs(value) & 0x1FF | (value < 0 ? 512 : 0);
        }
    }

    public static class NoopI
    implements LInstruction {
        public void run(LExecutor exec) {
        }
    }

    public static class EndI
    implements LInstruction {
        public void run(LExecutor exec) {
            exec.counter.numval = exec.instructions.length;
        }
    }

    public static class SelectI
    implements LInstruction {
        public ConditionOp op = ConditionOp.notEqual;
        public LVar result;
        public LVar comp0;
        public LVar comp1;
        public LVar a;
        public LVar b;

        public SelectI(ConditionOp op, LVar result, LVar comp0, LVar comp1, LVar a, LVar b) {
            this.op = op;
            this.result = result;
            this.comp0 = comp0;
            this.comp1 = comp1;
            this.a = a;
            this.b = b;
        }

        public SelectI() {
        }

        public void run(LExecutor exec) {
            if (this.result.constant) {
                return;
            }
            this.result.set(this.op.test(this.comp0, this.comp1) ? this.a : this.b);
        }
    }

    public static class OpI
    implements LInstruction {
        public LogicOp op = LogicOp.add;
        public LVar a;
        public LVar b;
        public LVar dest;

        public OpI(LogicOp op, LVar a, LVar b, LVar dest) {
            this.op = op;
            this.a = a;
            this.b = b;
            this.dest = dest;
        }

        OpI() {
        }

        public void run(LExecutor exec) {
            if (this.op == LogicOp.strictEqual) {
                this.dest.setnum(this.a.isobj == this.b.isobj && (this.a.isobj && Structs.eq((Object)this.a.objval, (Object)this.b.objval) || !this.a.isobj && this.a.numval == this.b.numval) ? 1.0 : 0.0);
            } else if (this.op.unary) {
                this.dest.setnum(this.op.function1.get(this.a.num()));
            } else if (this.op.objFunction2 != null && this.a.isobj && this.b.isobj) {
                this.dest.setnum(this.op.objFunction2.get(this.a.obj(), this.b.obj()));
            } else {
                this.dest.setnum(this.op.function2.get(this.a.num(), this.b.num()));
            }
        }
    }

    public static class SetI
    implements LInstruction {
        public LVar from;
        public LVar to;

        public SetI(LVar from, LVar to) {
            this.from = from;
            this.to = to;
        }

        SetI() {
        }

        public void run(LExecutor exec) {
            if (!this.to.constant) {
                this.to.set(this.from);
            }
        }
    }

    public static class RadarI
    implements LInstruction {
        public RadarTarget target1 = RadarTarget.enemy;
        public RadarTarget target2 = RadarTarget.any;
        public RadarTarget target3 = RadarTarget.any;
        public RadarSort sort = RadarSort.distance;
        public LVar radar;
        public LVar sortOrder;
        public LVar output;
        public Healthc lastTarget;
        public Object lastSourceBuild;
        public Interval timer = new Interval();
        static float bestValue = 0.0f;
        static Unit best = null;

        public RadarI(RadarTarget target1, RadarTarget target2, RadarTarget target3, RadarSort sort, LVar radar, LVar sortOrder, LVar output) {
            this.target1 = target1;
            this.target2 = target2;
            this.target3 = target3;
            this.sort = sort;
            this.radar = radar;
            this.sortOrder = sortOrder;
            this.output = output;
        }

        public RadarI() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void run(LExecutor exec) {
            block12: {
                Healthc targeted;
                Ranged r;
                LogicAI ai;
                int sortDir;
                Object base;
                block14: {
                    block13: {
                        base = this.radar.obj();
                        sortDir = this.sortOrder.bool() ? 1 : -1;
                        ai = null;
                        if (!(base instanceof Ranged)) break block12;
                        r = (Ranged)base;
                        if (!exec.privileged && r.team() != exec.team) break block12;
                        if (!(base instanceof Building)) break block13;
                        Building b = (Building)base;
                        if (!b.block.privileged || exec.privileged) break block14;
                    }
                    if ((ai = UnitControlI.checkLogicAI(exec, base)) == null) break block12;
                }
                float range = r.range();
                if (base instanceof Building && (this.timer.get(30.0f) || this.lastSourceBuild != base) || ai != null && ai.checkTargetTimer((Object)this)) {
                    boolean enemies = this.target1 == RadarTarget.enemy || this.target2 == RadarTarget.enemy || this.target3 == RadarTarget.enemy;
                    boolean allies = this.target1 == RadarTarget.ally || this.target2 == RadarTarget.ally || this.target3 == RadarTarget.ally;
                    best = null;
                    bestValue = 0.0f;
                    if (enemies) {
                        Seq data = Vars.state.teams.present;
                        for (int i = 0; i < data.size; ++i) {
                            if (((Teams.TeamData[])data.items)[i].team == r.team()) continue;
                            this.find(r, range, sortDir, ((Teams.TeamData[])data.items)[i].team);
                        }
                    } else if (!allies) {
                        Seq data = Vars.state.teams.present;
                        for (int i = 0; i < data.size; ++i) {
                            this.find(r, range, sortDir, ((Teams.TeamData[])data.items)[i].team);
                        }
                    } else {
                        this.find(r, range, sortDir, r.team());
                    }
                    if (ai != null) {
                        ai.execCache.put((Object)this, (Object)best);
                    }
                    this.lastSourceBuild = base;
                    this.lastTarget = targeted = best;
                } else {
                    targeted = ai != null ? (Healthc)ai.execCache.get((Object)this) : this.lastTarget;
                }
                this.output.setobj((Object)targeted);
                return;
            }
            this.output.setobj(null);
        }

        void find(Ranged b, float range, int sortDir, Team team) {
            Units.nearby(team, b.x(), b.y(), range, (Cons<Unit>)((Cons)u -> {
                boolean valid;
                if (!u.within((Position)b, range) || !u.targetable(team) || b == u) {
                    return;
                }
                boolean bl = valid = this.target1.func.get(b.team(), u) && this.target2.func.get(b.team(), u) && this.target3.func.get(b.team(), u);
                if (!valid) {
                    return;
                }
                float val = this.sort.func.get((Position)b, u) * (float)sortDir;
                if (val > bestValue || best == null) {
                    bestValue = val;
                    best = u;
                }
            }));
        }
    }

    public static class SenseI
    implements LInstruction {
        public LVar from;
        public LVar to;
        public LVar type;

        public SenseI(LVar from, LVar to, LVar type) {
            this.from = from;
            this.to = to;
            this.type = type;
        }

        public SenseI() {
        }

        public void run(LExecutor exec) {
            Object target = this.from.obj();
            Object sense = this.type.obj();
            if (target == null && sense == LAccess.dead) {
                this.to.setnum(1.0);
                return;
            }
            if (target instanceof Senseable) {
                Senseable se = (Senseable)target;
                if (sense instanceof Content) {
                    Content co = (Content)sense;
                    this.to.setnum(se.sense(co));
                } else if (sense instanceof LAccess) {
                    LAccess la = (LAccess)sense;
                    Object objOut = se.senseObject(la);
                    if (objOut == Senseable.noSensed) {
                        this.to.setnum(se.sense(la));
                    } else {
                        this.to.setobj(objOut);
                    }
                }
            } else {
                if (target instanceof CharSequence) {
                    CharSequence seq = (CharSequence)target;
                    if (sense == LAccess.size || sense == LAccess.bufferSize) {
                        this.to.setnum((double)seq.length());
                        return;
                    }
                }
                this.to.setobj(null);
            }
        }
    }

    public static class WriteI
    implements LInstruction {
        public LVar target;
        public LVar position;
        public LVar value;

        public WriteI(LVar target, LVar position, LVar value) {
            this.target = target;
            this.position = position;
            this.value = value;
        }

        public WriteI() {
        }

        public void run(LExecutor exec) {
            Object targetObj = this.target.obj();
            if (targetObj instanceof LWritable) {
                LWritable write = (LWritable)targetObj;
                if (!write.writable(exec)) {
                    return;
                }
                write.write(this.position, this.value);
            }
        }
    }

    public static class ReadI
    implements LInstruction {
        public LVar target;
        public LVar position;
        public LVar output;

        public ReadI(LVar target, LVar position, LVar output) {
            this.target = target;
            this.position = position;
            this.output = output;
        }

        public ReadI() {
        }

        public void run(LExecutor exec) {
            Object targetObj = this.target.obj();
            if (targetObj instanceof LReadable) {
                LReadable read = (LReadable)targetObj;
                if (!read.readable(exec)) {
                    return;
                }
                read.read(this.position, this.output);
            } else {
                int address = this.position.numi();
                if (targetObj instanceof CharSequence) {
                    CharSequence str = (CharSequence)targetObj;
                    this.output.setnum(address < 0 || address >= str.length() ? Double.NaN : (double)str.charAt(address));
                }
            }
        }
    }

    public static class GetLinkI
    implements LInstruction {
        public LVar output;
        public LVar index;

        public GetLinkI(LVar output, LVar index) {
            this.index = index;
            this.output = output;
        }

        public GetLinkI() {
        }

        public void run(LExecutor exec) {
            int address = this.index.numi();
            this.output.setobj(address >= 0 && address < exec.links.length ? exec.links[address] : null);
        }
    }

    public static class ControlI
    implements LInstruction {
        public LVar target;
        public LAccess type = LAccess.enabled;
        public LVar p1;
        public LVar p2;
        public LVar p3;
        public LVar p4;

        public ControlI(LAccess type, LVar target, LVar p1, LVar p2, LVar p3, LVar p4) {
            this.type = type;
            this.target = target;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.p4 = p4;
        }

        ControlI() {
        }

        public void run(LExecutor exec) {
            Object obj = this.target.obj();
            if (obj instanceof Building) {
                Building b = (Building)obj;
                if (exec.privileged || exec.build != null && exec.build.validLink(b)) {
                    b.lastLogicController = exec.build;
                    if (this.type == LAccess.enabled) {
                        if (this.p1.bool()) {
                            b.noSleep();
                        } else {
                            b.lastDisabler = exec.build;
                        }
                    }
                    if (this.type.isObj && this.p1.isobj) {
                        b.control(this.type, this.p1.obj(), this.p2.num(), this.p3.num(), this.p4.num());
                    } else {
                        b.control(this.type, this.p1.num(), this.p2.num(), this.p3.num(), this.p4.num());
                    }
                }
            }
        }
    }

    public static class UnitControlI
    implements LInstruction {
        public LUnitControl type = LUnitControl.move;
        public LVar p1;
        public LVar p2;
        public LVar p3;
        public LVar p4;
        public LVar p5;

        public UnitControlI(LUnitControl type, LVar p1, LVar p2, LVar p3, LVar p4, LVar p5) {
            this.type = type;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.p4 = p4;
            this.p5 = p5;
        }

        public UnitControlI() {
        }

        @Nullable
        public static LogicAI checkLogicAI(LExecutor exec, Object unitObj) {
            Unit unit;
            if (unitObj instanceof Unit && (unit = (Unit)unitObj).isValid() && exec.unit.obj() == unit && (unit.team == exec.team || exec.privileged) && unit.controller().isLogicControllable()) {
                UnitController unitController = unit.controller();
                if (unitController instanceof LogicAI) {
                    LogicAI la = (LogicAI)unitController;
                    la.controller = exec.thisv.building();
                    return la;
                }
                LogicAI la = new LogicAI();
                la.controller = exec.thisv.building();
                unit.controller((UnitController)la);
                unit.mineTile = null;
                unit.clearBuilding();
                return la;
            }
            return null;
        }

        public void run(LExecutor exec) {
            Object unitObj = exec.unit.obj();
            LogicAI ai = UnitControlI.checkLogicAI(exec, unitObj);
            if (unitObj instanceof Unit) {
                Unit unit = (Unit)unitObj;
                if (ai != null) {
                    ai.controlTimer = 600.0f;
                    float x1 = World.unconv(this.p1.numf());
                    float y1 = World.unconv(this.p2.numf());
                    float d1 = World.unconv(this.p3.numf());
                    switch (this.type) {
                        case idle: 
                        case autoPathfind: {
                            ai.control = this.type;
                            break;
                        }
                        case move: 
                        case stop: 
                        case approach: 
                        case pathfind: {
                            ai.control = this.type;
                            ai.moveX = x1;
                            ai.moveY = y1;
                            if (this.type == LUnitControl.approach) {
                                ai.moveRad = d1;
                            }
                            if (this.type != LUnitControl.stop) break;
                            unit.mineTile = null;
                            unit.clearBuilding();
                            break;
                        }
                        case unbind: {
                            unit.resetController();
                            break;
                        }
                        case within: {
                            this.p4.setnum(unit.within(x1, y1, d1) ? 1.0 : 0.0);
                            break;
                        }
                        case target: {
                            ai.posTarget.set(x1, y1);
                            ai.aimControl = this.type;
                            ai.mainTarget = null;
                            ai.shoot = this.p3.bool();
                            break;
                        }
                        case targetp: {
                            Teamc t;
                            ai.aimControl = this.type;
                            Object object = this.p1.obj();
                            ai.mainTarget = object instanceof Teamc ? (t = (Teamc)object) : null;
                            ai.shoot = this.p2.bool();
                            break;
                        }
                        case boost: {
                            ai.boost = this.p1.bool();
                            break;
                        }
                        case flag: {
                            unit.flag = this.p1.num();
                            break;
                        }
                        case mine: {
                            Tile tile = Vars.world.tileWorld(x1, y1);
                            if (!unit.canMine()) break;
                            unit.mineTile = unit.validMine(tile) ? tile : null;
                            break;
                        }
                        case payDrop: {
                            Payloadc pay;
                            if (!exec.timeoutDone(unit, 90.0f)) {
                                return;
                            }
                            if (!(unit instanceof Payloadc) || !(pay = (Payloadc)unit).hasPayload()) break;
                            Call.payloadDropped((Unit)unit, (float)unit.x, (float)unit.y);
                            exec.updateTimeout(unit);
                            break;
                        }
                        case payTake: {
                            if (!exec.timeoutDone(unit, 90.0f)) {
                                return;
                            }
                            if (!(unit instanceof Payloadc)) break;
                            Payloadc pay = (Payloadc)unit;
                            if (this.p1.bool()) {
                                Unit result = Units.closest(unit.team, unit.x, unit.y, unit.type.hitSize * 2.0f, (Boolf<Unit>)((Boolf)u -> u != unit && u.isAI() && u.isGrounded() && pay.canPickup(u) && u.within((Position)unit, u.hitSize + unit.hitSize * 1.2f)));
                                if (result != null) {
                                    Call.pickedUnitPayload((Unit)unit, (Unit)result);
                                }
                            } else {
                                Building build = Vars.world.buildWorld(unit.x, unit.y);
                                if (build != null && build.team == unit.team) {
                                    Payload current = build.getPayload();
                                    if (current != null && pay.canPickupPayload(current)) {
                                        Call.pickedBuildPayload((Unit)unit, (Building)build, (boolean)false);
                                    } else if (build.block.buildVisibility != BuildVisibility.hidden && build.canPickup() && pay.canPickup(build)) {
                                        Call.pickedBuildPayload((Unit)unit, (Building)build, (boolean)true);
                                    }
                                }
                            }
                            exec.updateTimeout(unit);
                            break;
                        }
                        case payEnter: {
                            Building build = Vars.world.buildWorld(unit.x, unit.y);
                            if (build == null || unit.team() != build.team || !build.canControlSelect(unit)) break;
                            Call.unitBuildingControlSelect((Unit)unit, (Building)build);
                            break;
                        }
                        case build: {
                            Object object;
                            Block block;
                            Object build;
                            if (!Vars.state.rules.logicUnitBuild && !exec.privileged || !unit.canBuild() || !((build = this.p3.obj()) instanceof Block) || !(block = (Block)((Object)build)).canBeBuilt() || !block.unlockedNow() && !unit.team.isAI()) break;
                            int x = World.toTile(x1 - block.offset / 8.0f);
                            int y = World.toTile(y1 - block.offset / 8.0f);
                            int rot = Mathf.mod((int)this.p4.numi(), (int)4);
                            if (ai.plan.x != x || ai.plan.y != y || ai.plan.block != block || unit.plans.isEmpty()) {
                                ai.plan.progress = 0.0f;
                                ai.plan.initialized = false;
                                ai.plan.stuck = false;
                            }
                            Object conf = this.p5.obj();
                            ai.plan.set(x, y, rot, block);
                            BuildPlan buildPlan = ai.plan;
                            if (conf instanceof Content) {
                                Content c;
                                object = c = (Content)conf;
                            } else if (conf instanceof Building) {
                                Building b = (Building)conf;
                                object = b;
                            } else {
                                object = null;
                            }
                            buildPlan.config = object;
                            unit.clearBuilding();
                            Tile tile = ai.plan.tile();
                            if (tile == null || tile.block() == block && tile.build != null && tile.build.rotation == rot) break;
                            unit.updateBuilding = true;
                            unit.addBuild(ai.plan);
                            break;
                        }
                        case getBlock: {
                            float range = Math.max(unit.range(), unit.type.buildRange);
                            if (!unit.within(x1, y1, range)) {
                                this.p3.setobj(null);
                                this.p4.setobj(null);
                                this.p5.setobj(null);
                                break;
                            }
                            Tile tile = Vars.world.tileWorld(x1, y1);
                            if (tile == null) {
                                this.p3.setobj(null);
                                this.p4.setobj(null);
                                this.p5.setobj(null);
                                break;
                            }
                            this.p3.setobj((Object)tile.block());
                            this.p4.setobj((Object)(tile.build != null ? tile.build : null));
                            this.p5.setobj((Object)(tile.overlay() == Blocks.air ? tile.floor() : tile.overlay()));
                            break;
                        }
                        case itemDrop: {
                            int accepted;
                            if (!exec.timeoutDone(unit, 90.0f)) {
                                return;
                            }
                            if (this.p1.obj() == Blocks.air) {
                                if (!Vars.net.client()) {
                                    unit.clearItem();
                                }
                                exec.updateTimeout(unit);
                                break;
                            }
                            Building build = this.p1.building();
                            int dropped = Math.min(unit.stack.amount, this.p2.numi());
                            if (build == null || build.team != unit.team || !build.isValid() || !build.allowDeposit() || dropped <= 0 || !unit.within((Position)build, 45.0f + (float)(build.block.size * 8) / 2.0f) || (accepted = build.acceptStack(unit.item(), dropped, unit)) <= 0) break;
                            Call.transferItemTo((Unit)unit, (Item)unit.item(), (int)accepted, (float)unit.x, (float)unit.y, (Building)build);
                            exec.updateTimeout(unit);
                            break;
                        }
                        case itemTake: {
                            int taken;
                            Object rot;
                            if (!exec.timeoutDone(unit, 90.0f)) {
                                return;
                            }
                            Building build = this.p1.building();
                            int amount = this.p3.numi();
                            if (build == null || build.team != unit.team || !build.isValid() || build.items == null || !((rot = this.p2.obj()) instanceof Item)) break;
                            Item item = (Item)((Object)rot);
                            if (!unit.within((Position)build, 45.0f + (float)(build.block.size * 8) / 2.0f) || (taken = Math.min(build.items.get(item), Math.min(amount, unit.maxAccepted(item)))) <= 0) break;
                            Call.takeItems((Building)build, (Item)item, (int)taken, (Unit)unit);
                            exec.updateTimeout(unit);
                            break;
                        }
                    }
                }
            }
        }
    }

    public static class UnitLocateI
    implements LInstruction {
        public LLocate locate = LLocate.building;
        public BlockFlag flag = BlockFlag.core;
        public LVar enemy;
        public LVar ore;
        public LVar outX;
        public LVar outY;
        public LVar outFound;
        public LVar outBuild;

        public UnitLocateI(LLocate locate, BlockFlag flag, LVar enemy, LVar ore, LVar outX, LVar outY, LVar outFound, LVar outBuild) {
            this.locate = locate;
            this.flag = flag;
            this.enemy = enemy;
            this.ore = ore;
            this.outX = outX;
            this.outY = outY;
            this.outFound = outFound;
            this.outBuild = outBuild;
        }

        public UnitLocateI() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void run(LExecutor exec) {
            Object unitObj = exec.unit.obj();
            LogicAI ai = UnitControlI.checkLogicAI(exec, unitObj);
            if (unitObj instanceof Unit) {
                Unit unit = (Unit)unitObj;
                if (ai != null) {
                    ai.controlTimer = 600.0f;
                    Cache cache = (Cache)ai.execCache.get((Object)this, Cache::new);
                    if (!ai.checkTargetTimer((Object)this)) {
                        this.outBuild.setobj((Object)cache.build);
                        this.outFound.setbool(cache.found);
                        this.outX.setnum((double)cache.x);
                        this.outY.setnum((double)cache.y);
                        return;
                    }
                    Tile res = null;
                    boolean build = false;
                    switch (this.locate) {
                        case ore: {
                            Object object = this.ore.obj();
                            if (!(object instanceof Item)) break;
                            Item item = (Item)((Object)object);
                            res = Vars.indexer.findClosestOre(unit, item);
                            break;
                        }
                        case building: {
                            Building b = (Building)Geometry.findClosest((float)unit.x, (float)unit.y, this.enemy.bool() ? Vars.indexer.getEnemy(unit.team, this.flag) : Vars.indexer.getFlagged(unit.team, this.flag));
                            res = b == null ? null : b.tile;
                            build = true;
                            break;
                        }
                        case spawn: {
                            res = (Tile)Geometry.findClosest((float)unit.x, (float)unit.y, (Iterable)Vars.spawner.getSpawns());
                            break;
                        }
                        case damaged: {
                            Building b = Units.findDamagedTile(unit.team, unit.x, unit.y);
                            res = b == null ? null : b.tile;
                            build = true;
                            break;
                        }
                    }
                    if (!(res == null || build && res.build == null)) {
                        cache.found = true;
                        cache.x = World.conv(build ? res.build.x : res.worldx());
                        this.outX.setnum((double)cache.x);
                        cache.y = World.conv(build ? res.build.y : res.worldy());
                        this.outY.setnum((double)cache.y);
                        this.outFound.setnum(1.0);
                    } else {
                        cache.found = false;
                        this.outFound.setnum(0.0);
                    }
                    if (res != null && res.build != null && (unit.within(res.build.x, res.build.y, Math.max(unit.range(), 220.0f)) || res.build.team == exec.team)) {
                        cache.build = res.build;
                        this.outBuild.setobj((Object)res.build);
                        return;
                    }
                    this.outBuild.setobj(null);
                    return;
                }
            }
            this.outFound.setbool(false);
        }

        static class Cache {
            float x;
            float y;
            boolean found;
            Building build;

            Cache() {
            }
        }
    }

    public static class UnitBindI
    implements LInstruction {
        public LVar type;

        public UnitBindI(LVar type) {
            this.type = type;
        }

        public UnitBindI() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void run(LExecutor exec) {
            Object object;
            if (exec.binds == null || exec.binds.length != Vars.content.units().size) {
                exec.binds = new int[Vars.content.units().size];
            }
            if ((object = this.type.obj()) instanceof UnitType) {
                UnitType type = (UnitType)((Object)object);
                if (type.logicControllable) {
                    Seq seq = exec.team.data().unitCache(type);
                    if (seq != null && seq.any()) {
                        short s = type.id;
                        exec.binds[s] = exec.binds[s] % seq.size;
                        if (exec.binds[type.id] < seq.size) {
                            exec.unit.setconst(seq.get(exec.binds[type.id]));
                        }
                        short s2 = type.id;
                        exec.binds[s2] = exec.binds[s2] + 1;
                        return;
                    }
                    exec.unit.setconst(null);
                    return;
                }
            }
            if ((object = this.type.obj()) instanceof Unit) {
                Unit u = (Unit)object;
                if ((u.team == exec.team || exec.privileged) && u.type.logicControllable) {
                    exec.unit.setconst((Object)u);
                    return;
                }
            }
            exec.unit.setconst(null);
        }
    }
}

