/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.Core;
import arc.func.Cons;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Intersector;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.Scene;
import arc.scene.event.ClickListener;
import arc.scene.event.ElementGestureListener;
import arc.scene.event.EventListener;
import arc.scene.event.HandCursorListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.Bits;
import arc.struct.IntMap;
import arc.struct.Seq;
import arc.struct.SnapshotSeq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.gen.LogicIO;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.logic.LAssembler;
import mindustry.logic.LExecutor;
import mindustry.logic.LStatement;
import mindustry.logic.LStatements;
import mindustry.ui.Styles;
import mindustryX.features.UIExt;
import mindustryX.features.ui.LogicSupport;

public class LCanvas
extends Table {
    private static final Seq<JumpCurve> tmpOccupiers1 = new Seq();
    private static final Seq<JumpCurve> tmpOccupiers2 = new Seq();
    private static final Bits tmpBits1 = new Bits();
    private static final Bits tmpBits2 = new Bits();
    private static final int invalidJump = Integer.MAX_VALUE;
    static LCanvas canvas;
    private static final boolean dynamicJumpHeights = true;
    public DragLayout statements;
    public ScrollPane pane;
    StatementElem dragging;
    StatementElem hovered;
    float targetWidth;
    boolean privileged;
    Seq<Tooltip> tooltips = new Seq();

    public LCanvas() {
        canvas = this;
        Core.scene.addListener((EventListener)new InputListener(){

            public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button2) {
                for (Tooltip t : LCanvas.this.tooltips) {
                    t.container.toFront();
                }
                Core.app.post(() -> {
                    LCanvas.this.tooltips.each(Tooltip::hide);
                    LCanvas.this.tooltips.clear();
                });
                return super.touchDown(event, x, y, pointer, button2);
            }
        });
        this.rebuild();
    }

    public static boolean useRows() {
        return (float)Core.graphics.getWidth() - ((Boolean)LogicSupport.visible.get() != false ? 400.0f : 0.0f) < Scl.scl((float)900.0f) * 1.2f;
    }

    public static void tooltip(final Cell<?> cell, String key) {
        String lkey = key.toLowerCase().replace(" ", "");
        if (Core.settings.getBool("logichints", true) && Core.bundle.has(lkey)) {
            final Tooltip tip = new Tooltip(t -> t.background(Styles.black8).margin(4.0f).add((CharSequence)("[lightgray]" + Core.bundle.get(lkey))).style((Style)Styles.outlineLabel));
            if (Vars.mobile) {
                cell.get().addListener((EventListener)new ElementGestureListener(20.0f, 0.4f, 0.43f, 0.15f){

                    public boolean longPress(Element element, float x, float y) {
                        tip.show(element, x, y);
                        LCanvas.canvas.tooltips.add((Object)tip);
                        for (EventListener list : cell.get().getListeners()) {
                            if (!(list instanceof ClickListener)) continue;
                            ClickListener cl = (ClickListener)list;
                            cl.cancel();
                        }
                        return true;
                    }
                });
            } else {
                cell.get().addListener((EventListener)tip);
            }
        }
    }

    public static void tooltip(Cell<?> cell, Enum<?> key) {
        String cl = key.getClass().getSimpleName().toLowerCase() + "." + key.name().toLowerCase();
        if (Core.bundle.has(cl)) {
            LCanvas.tooltip(cell, cl);
        } else {
            LCanvas.tooltip(cell, "lenum." + key.name());
        }
    }

    public void rebuild() {
        this.targetWidth = LCanvas.useRows() ? 400.0f : 900.0f;
        float s = this.pane != null ? this.pane.getVisualScrollY() : 0.0f;
        String toLoad = this.statements != null ? this.save() : null;
        this.clear();
        this.statements = new DragLayout();
        this.pane = (ScrollPane)this.pane(t -> {
            t.center();
            t.add((Element)this.statements).pad(2.0f).center().width(this.targetWidth);
            t.addChild((Element)this.statements.jumps);
            this.statements.jumps.touchable = Touchable.disabled;
            this.statements.jumps.update(() -> this.statements.jumps.setCullingArea(t.getCullingArea()));
            this.statements.jumps.cullable = false;
        }).grow().get();
        this.pane.setFlickScroll(false);
        this.pane.setScrollYForce(s);
        if (toLoad != null) {
            this.load(toLoad);
        }
    }

    public void add(LStatement statement) {
        this.statements.addChild((Element)new StatementElem(statement));
    }

    public void addAt(int at, LStatement statement) {
        this.statements.addChildAt(at, (Element)new StatementElem(statement));
    }

    public String save() {
        Seq st = this.statements.getChildren().as().map(s -> s.st);
        st.each(LStatement::saveUI);
        return LAssembler.write((Seq)st);
    }

    public void load(String asm) {
        this.statements.jumps.clear();
        Seq statements = LAssembler.read((String)asm, (boolean)this.privileged);
        statements.truncate(LExecutor.maxInstructions);
        this.statements.clearChildren();
        for (LStatement st : statements) {
            this.add(st);
        }
        for (LStatement st : statements) {
            st.setupUI();
        }
        this.statements.updateJumpHeights = true;
    }

    public void clearStatements() {
        this.statements.jumps.clear();
        this.statements.clearChildren();
    }

    StatementElem checkHovered() {
        Element e = Core.scene.getHoverElement();
        if (e != null) {
            while (e != null && !(e instanceof StatementElem)) {
                e = e.parent;
            }
        }
        if (e == null || this.isDescendantOf(e)) {
            return null;
        }
        return (StatementElem)e;
    }

    public void act(float delta) {
        float y;
        float dst;
        super.act(delta);
        this.hovered = this.checkHovered();
        if (Core.input.isTouched() && (dst = Math.min((y = (float)Core.input.mouseY()) - this.y, (float)Core.graphics.getHeight() - y)) < Scl.scl((float)100.0f)) {
            int sign = Mathf.sign((float)((float)Core.graphics.getHeight() / 2.0f - y));
            this.pane.setScrollY(this.pane.getScrollY() + (float)sign * Scl.scl((float)15.0f) * Time.delta);
        }
    }

    public class DragLayout
    extends WidgetGroup {
        float space = Scl.scl((float)10.0f);
        float prefWidth;
        float prefHeight;
        Seq<Element> seq = new Seq();
        int insertPosition = 0;
        boolean invalidated;
        public Group jumps = new WidgetGroup();
        private Seq<JumpCurve> processedJumps = new Seq();
        private IntMap<JumpCurve> reprBefore = new IntMap();
        private IntMap<JumpCurve> reprAfter = new IntMap();
        public boolean updateJumpHeights = true;

        public DragLayout() {
            this.setTransform(true);
        }

        public void layout() {
            this.invalidated = true;
            float cy = 0.0f;
            this.seq.clear();
            float totalHeight = this.getChildren().sumf(e -> e.getPrefHeight() + this.space);
            if (this.height != totalHeight || this.width != Scl.scl((float)LCanvas.this.targetWidth)) {
                this.height = this.prefHeight = totalHeight;
                this.width = this.prefWidth = Scl.scl((float)LCanvas.this.targetWidth);
                this.invalidateHierarchy();
            }
            for (int i = 0; i < this.getChildren().size; ++i) {
                Element e2 = (Element)this.getChildren().get(i);
                if (LCanvas.this.dragging == e2) continue;
                e2.setSize(this.width, e2.getPrefHeight());
                e2.setPosition(0.0f, totalHeight - cy, 10);
                ((StatementElem)e2).updateAddress(i);
                cy += e2.getPrefHeight() + this.space;
                this.seq.add((Object)e2);
            }
            if (LCanvas.this.dragging != null) {
                float realY = LCanvas.this.dragging.getY(2) + LCanvas.this.dragging.translation.y;
                this.insertPosition = 0;
                for (int i = 0; i < this.seq.size; ++i) {
                    Element cur = (Element)this.seq.get(i);
                    if (!(realY < cur.y) || i != this.seq.size - 1 && !(realY > ((Element)this.seq.get((int)(i + 1))).y)) continue;
                    this.insertPosition = i + 1;
                    break;
                }
                float shiftAmount = LCanvas.this.dragging.getHeight() + this.space;
                for (int i = this.insertPosition; i < this.seq.size; ++i) {
                    ((Element)this.seq.get((int)i)).y -= shiftAmount;
                }
            }
            if (this.updateJumpHeights) {
                this.setJumpHeights();
            }
            this.updateJumpHeights = false;
            if (this.parent != null && this.parent instanceof Table) {
                this.setCullingArea(this.parent.getCullingArea());
            }
        }

        private void setJumpHeights() {
            SnapshotSeq jumpsChildren = this.jumps.getChildren();
            this.processedJumps.clear();
            this.reprBefore.clear();
            this.reprAfter.clear();
            jumpsChildren.each(e -> {
                if (!(e instanceof JumpCurve)) {
                    return;
                }
                JumpCurve e2 = (JumpCurve)((Object)e);
                e2.prepareHeight();
                if (e2.jumpUIBegin == Integer.MAX_VALUE) {
                    return;
                }
                if (e2.flipped) {
                    JumpCurve prev = (JumpCurve)((Object)((Object)this.reprAfter.get(e2.jumpUIBegin)));
                    if (prev != null && prev.jumpUIEnd >= e2.jumpUIEnd) {
                        return;
                    }
                    this.reprAfter.put(e2.jumpUIBegin, (Object)e2);
                } else {
                    JumpCurve prev = (JumpCurve)((Object)((Object)this.reprBefore.get(e2.jumpUIEnd)));
                    if (prev != null && prev.jumpUIBegin <= e2.jumpUIBegin) {
                        return;
                    }
                    this.reprBefore.put(e2.jumpUIEnd, (Object)e2);
                }
            });
            this.processedJumps.add(this.reprBefore.values().toArray());
            this.processedJumps.add(this.reprAfter.values().toArray());
            this.processedJumps.sort((a, b) -> a.jumpUIBegin - b.jumpUIBegin);
            Seq occupiers = tmpOccupiers1;
            Bits occupied = tmpBits1;
            occupiers.clear();
            occupied.clear();
            for (int i = 0; i < this.processedJumps.size; ++i) {
                JumpCurve cur = (JumpCurve)((Object)this.processedJumps.get(i));
                occupiers.retainAll(e -> {
                    if (e.jumpUIEnd > cur.jumpUIBegin) {
                        return true;
                    }
                    occupied.clear(e.predHeight);
                    return false;
                });
                int h = this.getJumpHeight(i, (Seq<JumpCurve>)occupiers, occupied);
                occupiers.add((Object)cur);
                occupied.set(h);
            }
            occupiers.clear();
            jumpsChildren.each(e -> {
                if (!(e instanceof JumpCurve)) {
                    return;
                }
                JumpCurve e2 = (JumpCurve)((Object)e);
                if (e2.jumpUIBegin == Integer.MAX_VALUE) {
                    return;
                }
                e2.predHeight = e2.flipped ? ((JumpCurve)((Object)((Object)this.reprAfter.get((int)e2.jumpUIBegin)))).predHeight : ((JumpCurve)((Object)((Object)this.reprBefore.get((int)e2.jumpUIEnd)))).predHeight;
                e2.markedDone = true;
            });
        }

        private int getJumpHeight(int index, Seq<JumpCurve> occupiers, Bits occupied) {
            JumpCurve jmp = (JumpCurve)((Object)this.processedJumps.get(index));
            if (jmp.markedDone) {
                return jmp.predHeight;
            }
            Seq tmpOccupiers = tmpOccupiers2;
            Bits tmpOccupied = tmpBits2;
            tmpOccupiers.set(occupiers);
            tmpOccupied.set(occupied);
            int max = -1;
            for (int i = index + 1; i < this.processedJumps.size; ++i) {
                JumpCurve cur = (JumpCurve)((Object)this.processedJumps.get(i));
                if (cur.jumpUIEnd > jmp.jumpUIEnd) continue;
                tmpOccupiers.retainAll(e -> {
                    if (e.jumpUIEnd > cur.jumpUIBegin) {
                        return true;
                    }
                    tmpOccupied.clear(e.predHeight);
                    return false;
                });
                int h = this.getJumpHeight(i, (Seq<JumpCurve>)tmpOccupiers, tmpOccupied);
                tmpOccupiers.add((Object)cur);
                tmpOccupied.set(h);
                max = Math.max(max, h);
            }
            jmp.predHeight = occupied.nextClearBit(max + 1);
            jmp.markedDone = true;
            tmpOccupiers.clear();
            return jmp.predHeight;
        }

        public float getPrefWidth() {
            return this.prefWidth;
        }

        public float getPrefHeight() {
            return this.prefHeight;
        }

        public void draw() {
            Draw.alpha((float)this.parentAlpha);
            if (LCanvas.this.dragging != null && this.insertPosition <= this.seq.size) {
                float shiftAmount = LCanvas.this.dragging.getHeight();
                float lastX = this.x;
                float lastY = this.insertPosition == 0 ? this.height + this.y : ((Element)this.seq.get((int)(this.insertPosition - 1))).y + this.y - this.space;
                Tex.pane.draw(lastX, lastY - shiftAmount, this.width, LCanvas.this.dragging.getHeight());
            }
            if (this.invalidated) {
                this.children.each(c -> {
                    c.cullable = false;
                });
            }
            super.draw();
            if (this.invalidated) {
                this.children.each(c -> {
                    c.cullable = true;
                });
                this.invalidated = false;
            }
        }

        void finishLayout() {
            if (LCanvas.this.dragging != null) {
                int i;
                for (Element child : this.getChildren()) {
                    child.setTranslation(0.0f, 0.0f);
                }
                this.clearChildren();
                for (i = 0; i <= this.insertPosition - 1 && i < this.seq.size; ++i) {
                    this.addChild((Element)this.seq.get(i));
                }
                this.addChild((Element)LCanvas.this.dragging);
                for (i = this.insertPosition; i < this.seq.size; ++i) {
                    this.addChild((Element)this.seq.get(i));
                }
                LCanvas.this.dragging = null;
                this.invalidateHierarchy();
            }
            this.updateJumpHeights = true;
        }
    }

    public class StatementElem
    extends Table {
        public LStatement st;
        public int index;
        Label addressLabel;

        public StatementElem(LStatement st) {
            this.st = st;
            st.elem = this;
            this.background(Tex.whitePane);
            this.setColor(st.category().color);
            this.margin(0.0f);
            this.touchable = Touchable.enabled;
            this.table(Tex.whiteui, t -> {
                t.color.set(this.color);
                t.addListener((EventListener)new HandCursorListener());
                t.margin(6.0f);
                t.touchable = Touchable.enabled;
                t.add((CharSequence)st.name()).style((Style)Styles.outlineLabel).name("statement-name").color(this.color).padRight(8.0f);
                t.add().growX();
                this.addressLabel = (Label)t.add((CharSequence)(this.index + "")).style((Style)Styles.outlineLabel).color(this.color).padRight(8.0f).get();
                t.button((Drawable)Icon.add, Styles.logici, () -> Vars.ui.logic.showAddDialog(this.index + 1)).disabled(b -> LCanvas.canvas.statements.getChildren().size >= LExecutor.maxInstructions).size(24.0f).padRight(6.0f);
                ((ImageButton)t.button((Drawable)Icon.copy, Styles.logici, () -> {}).size(24.0f).padRight(6.0f).get()).tapped(this::copy);
                t.button((Drawable)(st instanceof LStatements.PrintStatement ? Icon.fileText : Icon.pencil), Styles.logici, this::toggleComment).size(24.0f).padRight(6.0f);
                t.button((Drawable)Icon.cancel, Styles.logici, () -> {
                    this.remove();
                    LCanvas.this.dragging = null;
                    LCanvas.this.statements.updateJumpHeights = true;
                }).size(24.0f).padLeft(Vars.mobile ? 48.0f : 0.0f);
                t.addListener((EventListener)new InputListener(){
                    float lastx;
                    float lasty;

                    public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button2) {
                        if (event.targetActor instanceof Image) {
                            return false;
                        }
                        if (button2 == KeyCode.mouseMiddle) {
                            StatementElem.this.copy();
                            return false;
                        }
                        Vec2 v = StatementElem.this.localToParentCoordinates(Tmp.v1.set(x, y));
                        this.lastx = v.x;
                        this.lasty = v.y;
                        LCanvas.this.dragging = StatementElem.this;
                        StatementElem.this.toFront();
                        LCanvas.this.statements.updateJumpHeights = true;
                        LCanvas.this.statements.invalidate();
                        return true;
                    }

                    public void touchDragged(InputEvent event, float x, float y, int pointer) {
                        Vec2 v = StatementElem.this.localToParentCoordinates(Tmp.v1.set(x, y));
                        StatementElem.this.translation.add(v.x - this.lastx, v.y - this.lasty);
                        this.lastx = v.x;
                        this.lasty = v.y;
                        LCanvas.this.statements.invalidate();
                    }

                    public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button2) {
                        LCanvas.this.statements.finishLayout();
                    }
                });
            }).growX().height(38.0f);
            this.row();
            this.table(t -> {
                t.left();
                t.marginLeft(4.0f);
                t.setColor(this.color);
                st.build(t);
            }).pad(4.0f).padTop(2.0f).left().grow();
            this.marginBottom(7.0f);
        }

        public void updateAddress(int index) {
            this.index = index;
            this.addressLabel.setText((CharSequence)(index + ""));
        }

        public void copy() {
            this.st.saveUI();
            LStatement copy = this.st.copy();
            if (copy instanceof LStatements.JumpStatement) {
                int index;
                LStatements.JumpStatement st = (LStatements.JumpStatement)copy;
                if (st.destIndex != -1 && (index = LCanvas.this.statements.getChildren().indexOf((Object)this)) != -1 && index < st.destIndex) {
                    ++st.destIndex;
                }
            }
            if (copy != null) {
                StatementElem s = new StatementElem(copy);
                LCanvas.this.statements.addChildAfter((Element)this, (Element)s);
                copy.elem = s;
                copy.setupUI();
                LCanvas.this.statements.updateJumpHeights = true;
            }
        }

        /*
         * Unable to fully structure code
         */
        public void toggleComment() {
            var3_1 = this.st;
            if (!(var3_1 instanceof LStatements.PrintStatement)) ** GOTO lbl-1000
            pst = (LStatements.PrintStatement)var3_1;
            if (!pst.value.isEmpty()) {
                code = pst.value.replace("_", " ");
                lsStatement = LAssembler.read((String)code, (boolean)LCanvas.this.privileged);
                stNew = (LStatement)lsStatement.first();
                if (stNew instanceof LStatements.InvalidStatement) {
                    UIExt.announce("[orange]\u8b66\u544a\uff1a\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u683c\u5f0f");
                    return;
                }
                newElem = new StatementElem(stNew);
            } else lbl-1000:
            // 2 sources

            {
                this.st.saveUI();
                thisText = new StringBuilder();
                LogicIO.write((Object)this.st, (StringBuilder)thisText);
                stNew = new LStatements.PrintStatement();
                stNew.value = thisText.toString().replace(' ', '_');
                newElem = new StatementElem(stNew);
            }
            for (Element c : LCanvas.this.statements.getChildren()) {
                if (!(c instanceof StatementElem)) continue;
                ste = (StatementElem)c;
                var6_6 = ste.st;
                if (!(var6_6 instanceof LStatements.JumpStatement)) continue;
                jst = (LStatements.JumpStatement)var6_6;
                if (jst.dest != null && jst.dest != this.st.elem || 0 > jst.destIndex || jst.destIndex >= LCanvas.this.statements.getChildren().size) continue;
                jst.saveUI();
            }
            LCanvas.this.statements.addChildBefore((Element)this, (Element)newElem);
            this.remove();
            for (Element c : LCanvas.this.statements.getChildren()) {
                if (!(c instanceof StatementElem)) continue;
                ste = (StatementElem)c;
                var6_6 = ste.st;
                if (!(var6_6 instanceof LStatements.JumpStatement)) continue;
                jst = (LStatements.JumpStatement)var6_6;
                if (jst.dest != null && jst.dest != this.st.elem || 0 > jst.destIndex || jst.destIndex >= LCanvas.this.statements.getChildren().size) continue;
                jst.setupUI();
            }
            newElem.st.setupUI();
        }

        public void draw() {
            float pad = 5.0f;
            Fill.dropShadow((float)(this.x + this.width / 2.0f), (float)(this.y + this.height / 2.0f), (float)(this.width + pad), (float)(this.height + pad), (float)10.0f, (float)(0.9f * this.parentAlpha));
            Draw.color((float)0.0f, (float)0.0f, (float)0.0f, (float)(0.3f * this.parentAlpha));
            Fill.crect((float)this.x, (float)this.y, (float)this.width, (float)this.height);
            Draw.reset();
            super.draw();
        }
    }

    public static class JumpCurve
    extends Element {
        public JumpButton button;
        private boolean invertedHeight;
        public int predHeight = 0;
        public boolean markedDone = false;
        public int jumpUIBegin = 0;
        public int jumpUIEnd = 0;
        public boolean flipped = false;
        private float uiHeight = 60.0f;

        public JumpCurve(JumpButton button2) {
            this.button = button2;
        }

        public void setSize(float width, float height) {
            if (height < 0.0f) {
                this.y += height;
                height = -height;
                this.invertedHeight = true;
            }
            super.setSize(width, height);
        }

        public void act(float delta) {
            Object hover;
            super.act(delta);
            this.invertedHeight = false;
            Group desc = LCanvas.canvas.statements.jumps.parent;
            Vec2 t = Tmp.v1.set(this.button.getWidth() / 2.0f, this.button.getHeight() / 2.0f);
            this.button.localToAscendantCoordinates((Element)desc, t);
            this.setPosition(t.x, t.y);
            Object object = hover = this.button.to.get() == null && this.button.selecting ? LCanvas.canvas.hovered : (Element)this.button.to.get();
            if (hover != null) {
                t.set(hover.getWidth(), hover.getHeight() / 2.0f);
                hover.localToAscendantCoordinates((Element)desc, t);
                this.setSize(t.x - this.x, t.y - this.y);
            } else if (this.button.selecting) {
                this.setSize(this.button.mx, this.button.my);
            } else {
                this.setSize(0.0f, 0.0f);
            }
            if (this.button.listener.isOver()) {
                this.toFront();
            }
        }

        public void draw() {
            if (this.height == 0.0f) {
                return;
            }
            Vec2 t = Tmp.v1.set(this.width, !this.invertedHeight ? this.height : 0.0f);
            Vec2 r = Tmp.v2.set(0.0f, !this.invertedHeight ? 0.0f : this.height);
            ScrollPane desc = LCanvas.canvas.pane;
            this.localToAscendantCoordinates((Element)desc, r);
            this.localToAscendantCoordinates((Element)desc, t);
            this.drawCurve(r.x, r.y, t.x, t.y);
            float s = this.button.getWidth();
            Draw.color((Color)this.button.color, (float)this.parentAlpha);
            Tex.logicNode.draw(t.x + s * 0.75f, t.y - s / 2.0f, -s, s);
            Draw.reset();
        }

        public void drawCurve(float x, float y, float x2, float y2) {
            Lines.stroke(Scl.scl((float)4.0f), this.button.color);
            Draw.alpha((float)this.parentAlpha);
            this.uiHeight = Mathf.lerp((float)(Scl.scl((float)(Core.graphics.isPortrait() ? 20.0f : 40.0f)) + Scl.scl((float)(Core.graphics.isPortrait() ? 8.0f : 10.0f)) * (float)this.predHeight), (float)this.uiHeight, (float)Mathf.pow((float)0.9f, (float)Time.delta));
            float dy = (y2 == y ? 0.0f : (y2 > y ? 1.0f : -1.0f)) * this.uiHeight * 0.5f;
            if (Intersector.intersectSegments((float)x, (float)y, (float)(x + this.uiHeight), (float)(y + dy), (float)x2, (float)y2, (float)(x + this.uiHeight), (float)(y2 - dy), (Vec2)Tmp.v3)) {
                Lines.beginLine();
                Lines.linePoint(x, y);
                Lines.linePoint(Tmp.v3.x, Tmp.v3.y);
                Lines.linePoint(x2, y2);
                Lines.endLine();
            } else {
                Lines.beginLine();
                Lines.linePoint(x, y);
                Lines.linePoint(x + this.uiHeight, y + dy);
                Lines.linePoint(x + this.uiHeight, y2 - dy);
                Lines.linePoint(x2, y2);
                Lines.endLine();
            }
        }

        public void prepareHeight() {
            if (this.button.to.get() == null) {
                this.markedDone = true;
                this.predHeight = 0;
                this.flipped = false;
                this.jumpUIEnd = Integer.MAX_VALUE;
                this.jumpUIBegin = Integer.MAX_VALUE;
            } else {
                this.markedDone = false;
                int i = this.button.elem.index;
                int j = ((StatementElem)((Object)this.button.to.get())).index;
                this.flipped = i >= j;
                this.jumpUIBegin = Math.min(i, j);
                this.jumpUIEnd = Math.max(i, j);
            }
        }
    }

    public static class JumpButton
    extends ImageButton {
        Color hoverColor = Pal.place;
        Prov<StatementElem> to;
        boolean selecting;
        float mx;
        float my;
        ClickListener listener;
        public JumpCurve curve;
        public StatementElem elem;

        public JumpButton(Prov<StatementElem> getter, final Cons<StatementElem> setter, StatementElem elem) {
            super(Tex.logicNode, new ImageButton.ImageButtonStyle(){
                {
                    this.imageUpColor = Color.white;
                }
            });
            this.elem = elem;
            this.to = getter;
            this.listener = new ClickListener();
            this.addListener((EventListener)this.listener);
            this.addListener((EventListener)new InputListener(){

                public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode code) {
                    selecting = true;
                    setter.get(null);
                    mx = x;
                    my = y;
                    LCanvas.canvas.statements.updateJumpHeights = true;
                    return true;
                }

                public void touchDragged(InputEvent event, float x, float y, int pointer) {
                    mx = x;
                    my = y;
                }

                public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode code) {
                    this.localToStageCoordinates(Tmp.v1.set(x, y));
                    StatementElem elem = LCanvas.canvas.hovered;
                    if (elem != null && !this.isDescendantOf((Element)elem)) {
                        setter.get((Object)elem);
                    } else {
                        setter.get(null);
                    }
                    selecting = false;
                    LCanvas.canvas.statements.updateJumpHeights = true;
                }
            });
            this.update(() -> {
                if (this.to.get() != null && ((StatementElem)((Object)((Object)this.to.get()))).parent == null) {
                    setter.get(null);
                }
                this.setColor(this.listener.isOver() ? this.hoverColor : Color.white);
                this.getStyle().imageUpColor = this.color;
            });
            this.curve = new JumpCurve(this);
        }

        protected void setScene(Scene stage) {
            super.setScene(stage);
            if (stage == null) {
                this.curve.remove();
            } else {
                LCanvas.canvas.statements.jumps.addChild((Element)this.curve);
            }
        }
    }
}

