/*
 * Decompiled with CFR 0.152.
 */
package mindustry.input;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Boolp;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.input.GestureDetector;
import arc.input.InputProcessor;
import arc.input.KeyBind;
import arc.input.KeyCode;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.IntSeq;
import arc.struct.IntSet;
import arc.struct.ObjectMap;
import arc.struct.Queue;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import java.util.Arrays;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.ai.UnitGroup;
import mindustry.ai.UnitStance;
import mindustry.ai.types.CommandAI;
import mindustry.ai.types.LogicAI;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.UnitTypes;
import mindustry.core.World;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.entities.units.UnitController;
import mindustry.game.EventType;
import mindustry.game.Schematic;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Healthc;
import mindustry.gen.Icon;
import mindustry.gen.Itemsc;
import mindustry.gen.Mechc;
import mindustry.gen.Payloadc;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.TileConfigCallPacket;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.input.Placement;
import mindustry.net.Administration;
import mindustry.net.ValidateException;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.type.UnitType;
import mindustry.ui.Fonts;
import mindustry.ui.fragments.BlockConfigFragment;
import mindustry.ui.fragments.BlockInventoryFragment;
import mindustry.ui.fragments.PlanConfigFragment;
import mindustry.world.Block;
import mindustry.world.Build;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.ControlBlock;
import mindustry.world.blocks.distribution.ChainedBuilding;
import mindustry.world.blocks.logic.CanvasBlock;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.BuildVisibility;
import mindustryX.features.BindingExt;
import mindustryX.features.LogicExt;
import mindustryX.features.RenderExt;

public abstract class InputHandler
implements InputProcessor,
GestureDetector.GestureListener {
    static ObjectMap<Vec2, Seq<Unit>> queuedCommands = new ObjectMap();
    static final float playerSelectRange = Vars.mobile ? 17.0f : 11.0f;
    static final float unitSelectRadScl = 1.0f;
    static final Seq<UnitStance> stancesOut = new Seq();
    static final IntSeq removed = new IntSeq();
    static final IntSet intSet = new IntSet();
    static final int maxLength = 100;
    static final Rect r1 = new Rect();
    static final Rect r2 = new Rect();
    static final Seq<Unit> tmpUnits = new Seq(false);
    static final Seq<Building> tmpBuildings = new Seq(false);
    static final KeyBind[] controlGroupBindings = new KeyBind[]{Binding.blockSelect01, Binding.blockSelect02, Binding.blockSelect03, Binding.blockSelect04, Binding.blockSelect05, Binding.blockSelect06, Binding.blockSelect07, Binding.blockSelect08, Binding.blockSelect09, Binding.blockSelect10};
    public boolean logicCutscene;
    public Vec2 logicCamPan = new Vec2();
    public float logicCamSpeed = 0.1f;
    public float logicCutsceneZoom = -1.0f;
    public Seq<Boolp> inputLocks = Seq.with((Object[])new Boolp[]{() -> Vars.renderer.isCutscene(), () -> this.logicCutscene});
    public Interval controlInterval = new Interval();
    @Nullable
    public Block block;
    public boolean overrideLineRotation;
    public int rotation = 1;
    public boolean droppingItem;
    public float itemDepositCooldown;
    public Group uiGroup;
    public boolean isBuilding = true;
    public boolean buildWasAutoPaused = false;
    public boolean wasShooting = false;
    @Nullable
    public UnitType controlledType;
    public float recentRespawnTimer;
    @Nullable
    public Schematic lastSchematic;
    public GestureDetector detector;
    public PlaceLine line = new PlaceLine();
    public BuildPlan resultplan;
    public BuildPlan bplan = new BuildPlan();
    public Seq<BuildPlan> linePlans = new Seq();
    public Seq<BuildPlan> selectPlans = new Seq(BuildPlan.class);
    public Queue<BuildPlan> lastPlans = new Queue();
    @Nullable
    public Unit lastUnit;
    @Nullable
    public Unit spectating;
    public Seq<Unit> selectedUnits = new Seq();
    public Seq<Building> commandBuildings = new Seq(false);
    public boolean commandMode = false;
    public boolean commandRect = false;
    public boolean tappedOne = false;
    public float commandRectX;
    public float commandRectY;
    public IntSeq[] controlGroups = new IntSeq[controlGroupBindings.length];
    public Rect lastSelection = new Rect();
    private Seq<BuildPlan> plansOut = new Seq(BuildPlan.class);
    private QuadTree<BuildPlan> playerPlanTree = new QuadTree(new Rect());
    public final BlockInventoryFragment inv;
    public final BlockConfigFragment config;
    public final PlanConfigFragment planConfig;
    private WidgetGroup group = new WidgetGroup();
    private final Eachable<BuildPlan> allPlans = cons -> {
        if (!Vars.player.dead()) {
            Vars.player.unit().plans().each(cons);
        }
        this.selectPlans.each(cons);
        this.linePlans.each(cons);
    };
    private final Eachable<BuildPlan> allSelectLines = cons -> {
        this.selectPlans.each(cons);
        this.linePlans.each(cons);
    };

    public InputHandler() {
        this.group.touchable = Touchable.childrenOnly;
        this.inv = new BlockInventoryFragment();
        this.config = new BlockConfigFragment();
        this.planConfig = new PlanConfigFragment();
        Events.on(EventType.UnitDestroyEvent.class, e -> {
            if (e.unit != null && e.unit.isPlayer() && e.unit.getPlayer().isLocal() && e.unit.type.weapons.contains(w -> w.bullet.killShooter)) {
                Vars.player.shooting = false;
            }
        });
        Events.on(EventType.WorldLoadEvent.class, e -> {
            this.playerPlanTree = new QuadTree(new Rect(0.0f, 0.0f, (float)Vars.world.unitWidth(), (float)Vars.world.unitHeight()));
        });
        Events.on(EventType.ResetEvent.class, e -> this.reset());
    }

    public static void transferItemEffect(Item item, float x, float y, Itemsc to) {
        if (to == null) {
            return;
        }
        InputHandler.createItemTransfer(item, 1, x, y, (Position)to, null);
    }

    public static void takeItems(Building build, Item item, int amount, Unit to) {
        if (to == null || build == null) {
            return;
        }
        int removed = build.removeStack(item, Math.min(to.maxAccepted(item), amount));
        if (removed == 0) {
            return;
        }
        to.addItem(item, removed);
        for (int j = 0; j < Mathf.clamp((int)(removed / 3), (int)1, (int)8); ++j) {
            Time.run((float)((float)j * 3.0f), () -> InputHandler.transferItemEffect(item, build.x, build.y, to));
        }
    }

    public static void transferItemToUnit(Item item, float x, float y, Itemsc to) {
        if (to == null) {
            return;
        }
        InputHandler.createItemTransfer(item, 1, x, y, (Position)to, () -> to.addItem(item));
    }

    public static void setItem(Building build, Item item, int amount) {
        if (build == null || build.items == null) {
            return;
        }
        build.items.set(item, amount);
    }

    public static void setItems(Building build, ItemStack[] items) {
        if (build == null || build.items == null) {
            return;
        }
        for (ItemStack stack : items) {
            build.items.set(stack.item, stack.amount);
        }
    }

    public static void setTileItems(Item item, int amount, int[] positions) {
        for (int pos : positions) {
            Building build = Vars.world.build(pos);
            if (build == null || build.items == null) continue;
            build.items.set(item, amount);
        }
    }

    public static void clearItems(Building build) {
        if (build == null || build.items == null) {
            return;
        }
        build.items.clear();
    }

    public static void setLiquid(Building build, Liquid liquid, float amount) {
        if (build == null || build.liquids == null) {
            return;
        }
        build.liquids.set(liquid, amount);
    }

    public static void setLiquids(Building build, LiquidStack[] liquids) {
        if (build == null || build.liquids == null) {
            return;
        }
        for (LiquidStack stack : liquids) {
            build.liquids.set(stack.liquid, stack.amount);
        }
    }

    public static void setTileLiquids(Liquid liquid, float amount, int[] positions) {
        for (int pos : positions) {
            Building build = Vars.world.build(pos);
            if (build == null || build.liquids == null) continue;
            build.liquids.set(liquid, amount);
        }
    }

    public static void clearLiquids(Building build) {
        if (build == null || build.liquids == null) {
            return;
        }
        build.liquids.clear();
    }

    public static void transferItemTo(@Nullable Unit unit, Item item, int amount, float x, float y, Building build) {
        if (build == null || build.items == null || item == null) {
            return;
        }
        if (unit != null && unit.item() == item) {
            unit.stack.amount = Math.max(unit.stack.amount - amount, 0);
        }
        for (int i = 0; i < Mathf.clamp((int)(amount / 3), (int)1, (int)8); ++i) {
            Time.run((float)(i * 3), () -> InputHandler.createItemTransfer(item, amount, x, y, (Position)build, () -> {}));
        }
        if (amount > 0) {
            build.handleStack(item, amount, unit);
        }
    }

    public static void deletePlans(Player player, int[] positions) {
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.removePlanned, a -> {
            a.plans = positions;
        })) {
            throw new ValidateException(player, "Player cannot remove plans.");
        }
        if (player == null) {
            return;
        }
        Iterator it = player.team().data().plans.iterator();
        block0: while (it.hasNext()) {
            Teams.BlockPlan plan = (Teams.BlockPlan)it.next();
            for (int pos : positions) {
                if (plan.x != Point2.x((int)pos) || plan.y != Point2.y((int)pos)) continue;
                plan.removed = true;
                it.remove();
                continue block0;
            }
        }
    }

    public static void createItemTransfer(Item item, int amount, float x, float y, Position to, Runnable done) {
        Fx.itemTransfer.at(x, y, (float)amount, item.color, (Object)to);
        if (done != null) {
            Time.run((float)Fx.itemTransfer.lifetime, (Runnable)done);
        }
    }

    public static void commandUnits(Player player, int[] unitIds, @Nullable Building buildTarget, @Nullable Unit unitTarget, @Nullable Vec2 posTarget, boolean queueCommand, boolean finalBatch) {
        if (player == null || unitIds == null) {
            return;
        }
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.commandUnits, event -> {
            event.unitIDs = unitIds;
        })) {
            throw new ValidateException(player, "Player cannot command units.");
        }
        Healthc teamTarget = buildTarget == null ? unitTarget : buildTarget;
        Vec2 targetAsVec = new Vec2().set((Position)(teamTarget != null ? teamTarget : posTarget));
        Seq toAdd = (Seq)queuedCommands.get((Object)targetAsVec, Seq::new);
        boolean anyCommandedTarget = false;
        for (int id : unitIds) {
            Healthc u;
            UnitController unitController;
            Unit unit = (Unit)Groups.unit.getByID(id);
            if (unit == null || unit.team != player.team() || !((unitController = unit.controller()) instanceof CommandAI)) continue;
            CommandAI ai = (CommandAI)unitController;
            if (ai.command == null || ai.command.switchToMove) {
                ai.command(UnitCommand.moveCommand);
            }
            if (!(teamTarget == null || teamTarget.team() == player.team() || teamTarget instanceof Unit && !unit.canTarget((Teamc)(u = teamTarget)) || teamTarget instanceof Building && !unit.type.targetGround)) {
                anyCommandedTarget = true;
                if (queueCommand) {
                    ai.commandQueue((Position)teamTarget);
                } else {
                    ai.commandQueue.clear();
                    ai.commandTarget((Teamc)teamTarget);
                }
            } else if (posTarget != null) {
                if (queueCommand) {
                    ai.commandQueue((Position)posTarget);
                } else {
                    ai.commandQueue.clear();
                    ai.commandPosition(posTarget);
                }
            }
            unit.lastCommanded = player.coloredName();
            if (ai.commandQueue.size <= 0) {
                ai.group = null;
            }
            if (!Vars.headless && player != Vars.player && Vars.control.input.selectedUnits.remove((Object)unit)) {
                RenderExt.onRtsRemoveUnit(player, unit);
            }
            toAdd.add((Object)unit);
        }
        if (finalBatch) {
            UnitGroup[] groups2 = new UnitGroup[4];
            Seq units = (Seq)queuedCommands.remove((Object)targetAsVec);
            for (Unit unit : units) {
                UnitController ai = unit.controller();
                if (!(ai instanceof CommandAI)) continue;
                CommandAI ai2 = (CommandAI)ai;
                if (ai2.commandQueue.size != 0 || unitIds.length <= 1) continue;
                int layer = unit.collisionLayer();
                if (layer == -1) {
                    layer = 0;
                }
                if (groups2[layer] == null) {
                    groups2[layer] = new UnitGroup();
                }
                groups2[layer].units.add((Object)unit);
                ai2.group = groups2[layer];
            }
            for (int i = 0; i < groups2.length; ++i) {
                UnitGroup group = groups2[i];
                if (group == null || group.units.size <= 0) continue;
                group.calculateFormation(targetAsVec, i);
            }
        }
        if (unitIds.length > 0 && player == Vars.player && !Vars.state.isPaused()) {
            if (anyCommandedTarget) {
                Fx.attackCommand.at((Position)teamTarget);
            } else {
                Fx.moveCommand.at((Position)posTarget);
            }
        }
    }

    public static void setUnitCommand(Player player, int[] unitIds, UnitCommand command) {
        if (player == null || unitIds == null || command == null) {
            return;
        }
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.commandUnits, event -> {
            event.unitIDs = unitIds;
        })) {
            throw new ValidateException(player, "Player cannot command units.");
        }
        for (int id : unitIds) {
            UnitController unitController;
            Unit unit = (Unit)Groups.unit.getByID(id);
            if (unit == null || unit.team != player.team() || !((unitController = unit.controller()) instanceof CommandAI)) continue;
            CommandAI ai = (CommandAI)unitController;
            if (!unit.type.allowCommand(unit, command)) continue;
            boolean reset = command.resetTarget || ai.currentCommand().resetTarget;
            ai.command(command);
            if (reset) {
                ai.targetPos = null;
                ai.attackTarget = null;
            }
            unit.lastCommanded = player.coloredName();
            stancesOut.clear();
            unit.type.getUnitStances(unit, stancesOut);
            for (UnitStance stance : Vars.content.unitStances()) {
                if (!ai.hasStance(stance) || stancesOut.contains((Object)stance)) continue;
                ai.disableStance(stance);
            }
        }
    }

    public static void setUnitStance(Player player, int[] unitIds, UnitStance stance, boolean enable) {
        if (player == null || unitIds == null || stance == null) {
            return;
        }
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.commandUnits, event -> {
            event.unitIDs = unitIds;
        })) {
            throw new ValidateException(player, "Player cannot command units.");
        }
        for (int id : unitIds) {
            UnitController unitController;
            Unit unit = (Unit)Groups.unit.getByID(id);
            if (unit == null || unit.team != player.team() || !((unitController = unit.controller()) instanceof CommandAI)) continue;
            CommandAI ai = (CommandAI)unitController;
            if (stance == UnitStance.stop) {
                ai.clearCommands();
            } else if (unit.type.allowStance(unit, stance)) {
                ai.setStance(stance, !stance.toggle || enable);
            }
            unit.lastCommanded = player.coloredName();
        }
    }

    public static void commandBuilding(Player player, int[] buildings, Vec2 target) {
        if (player == null || target == null) {
            return;
        }
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.commandBuilding, event -> {
            event.buildingPositions = buildings;
        })) {
            throw new ValidateException(player, "Player cannot command buildings.");
        }
        for (int pos : buildings) {
            Building build = Vars.world.build(pos);
            if (build == null || build.team() != player.team() || !build.isCommandable()) continue;
            build.onCommand(target);
            build.updateLastAccess(player);
            if (!Vars.state.isPaused() && player == Vars.player) {
                Fx.moveCommand.at((Position)target);
            }
            Events.fire((Object)new EventType.BuildingCommandEvent(player, build, target));
        }
    }

    public static void requestItem(Player player, Building build, Item item, int amount) {
        if (player == null || build == null || !build.interactable(player.team()) || !player.within((Position)build, 220.0f) || player.dead() || amount <= 0) {
            return;
        }
        if (!(!Vars.net.server() || Units.canInteract(player, build) && Vars.netServer.admins.allowAction(player, Administration.ActionType.withdrawItem, build.tile, action -> {
            action.item = item;
            action.itemAmount = amount;
        }))) {
            throw new ValidateException(player, "Player cannot request items.");
        }
        Call.takeItems((Building)build, (Item)item, (int)Math.min(player.unit().maxAccepted(item), amount), (Unit)player.unit());
        Events.fire((Object)new EventType.WithdrawEvent(build, player, item, amount));
    }

    public static void transferInventory(Player player, Building build) {
        if (player == null || build == null || !player.within((Position)build, 220.0f) || build.items == null || player.dead() || !build.allowDeposit()) {
            return;
        }
        if (!(!Vars.net.server() || player.unit().stack.amount > 0 && Units.canInteract(player, build) && (player.isLocal() || player.itemDepositRate.allow((long)(Vars.state.rules.itemDepositCooldown * 1000.0f * 2.0f), 2)) && Vars.netServer.admins.allowAction(player, Administration.ActionType.depositItem, build.tile, action -> {
            action.itemAmount = player.unit().stack.amount;
            action.item = player.unit().item();
        }))) {
            throw new ValidateException(player, "Player cannot transfer an item.");
        }
        Unit unit = player.unit();
        Item item = unit.item();
        int accepted = build.acceptStack(item, unit.stack.amount, unit);
        Call.transferItemTo((Unit)unit, (Item)item, (int)accepted, (float)unit.x, (float)unit.y, (Building)build);
        Events.fire((Object)new EventType.DepositEvent(build, player, item, accepted));
    }

    public static void removeQueueBlock(int x, int y, boolean breaking) {
        if (!Vars.player.dead()) {
            Vars.player.unit().removeBuild(x, y, breaking);
        }
    }

    public static void requestUnitPayload(Player player, Unit target) {
        Payloadc pay;
        block5: {
            block4: {
                Unit unit;
                if (player == null || !((unit = player.unit()) instanceof Payloadc)) break block4;
                pay = (Payloadc)unit;
                if (target != null) break block5;
            }
            return;
        }
        Unit unit = player.unit();
        if (target.isAI() && target.isGrounded() && pay.canPickup(target) && target.within((Position)unit, unit.type.hitSize * 2.0f + target.type.hitSize * 2.0f)) {
            Call.pickedUnitPayload((Unit)unit, (Unit)target);
        }
    }

    public static void requestBuildPayload(Player player, Building build) {
        Payloadc pay;
        block10: {
            block9: {
                Unit unit;
                if (player == null || !((unit = player.unit()) instanceof Payloadc)) break block9;
                pay = (Payloadc)unit;
                if (build != null) break block10;
            }
            return;
        }
        Unit unit = player.unit();
        if (!unit.within((Position)build, (float)(8 * build.block.size) * 1.2f + 40.0f)) {
            return;
        }
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.pickupBlock, build.tile, action -> {
            action.unit = unit;
        })) {
            throw new ValidateException(player, "Player cannot pick up a block.");
        }
        if (Vars.state.teams.canInteract(unit.team, build.team)) {
            Payload current = build.getPayload();
            if (current != null && pay.canPickupPayload(current)) {
                Call.pickedBuildPayload((Unit)unit, (Building)build, (boolean)false);
            } else if (build.block.buildVisibility != BuildVisibility.hidden && build.canPickup() && pay.canPickup(build)) {
                Call.pickedBuildPayload((Unit)unit, (Building)build, (boolean)true);
            }
        }
    }

    public static void pickedUnitPayload(Unit unit, Unit target) {
        if (target != null && unit instanceof Payloadc) {
            Payloadc pay = (Payloadc)unit;
            pay.pickup(target);
        } else if (target != null) {
            target.remove();
        }
    }

    public static void pickedBuildPayload(Unit unit, Building build, boolean onGround) {
        if (build != null && unit instanceof Payloadc) {
            Payloadc pay = (Payloadc)unit;
            if (onGround) {
                if (build.block.buildVisibility != BuildVisibility.hidden && build.canPickup() && pay.canPickup(build)) {
                    pay.pickup(build);
                } else {
                    Fx.unitPickup.at((Position)build);
                    build.tile.remove();
                }
            } else {
                Payload taken;
                Payload current = build.getPayload();
                if (current != null && pay.canPickupPayload(current) && (taken = build.takePayload()) != null) {
                    pay.addPayload(taken);
                    Fx.unitPickup.at((Position)build);
                }
            }
        } else if (build != null && onGround) {
            Fx.unitPickup.at((Position)build);
            build.tile.remove();
        }
    }

    public static void requestDropPayload(Player player, float x, float y) {
        if (player == null || Vars.net.client() || player.dead()) {
            return;
        }
        Payloadc pay = (Payloadc)player.unit();
        if (pay.payloads().isEmpty()) {
            return;
        }
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.dropPayload, player.unit().tileOn(), action -> {
            action.payload = (Payload)pay.payloads().peek();
        })) {
            throw new ValidateException(player, "Player cannot drop a payload.");
        }
        Tmp.v1.set(x, y).sub((Position)pay).limit(32.0f).add((Position)pay);
        float cx = Tmp.v1.x;
        float cy = Tmp.v1.y;
        Call.payloadDropped((Unit)player.unit(), (float)cx, (float)cy);
    }

    public static void payloadDropped(Unit unit, float x, float y) {
        if (unit instanceof Payloadc) {
            Payloadc pay = (Payloadc)unit;
            float prevx = pay.x();
            float prevy = pay.y();
            pay.set(x, y);
            pay.dropLastPayload();
            pay.set(prevx, prevy);
        }
    }

    public static void unitEnteredPayload(Unit unit, Building build) {
        UnitPayload unitPay;
        if (unit == null || build == null || unit.team != build.team) {
            return;
        }
        unit.remove();
        UnitController unitController = unit.controller();
        if (unitController instanceof CommandAI) {
            CommandAI ai = (CommandAI)unitController;
            if (ai.command == UnitCommand.enterPayloadCommand) {
                ai.clearCommands();
                ai.command = UnitCommand.moveCommand;
            }
        }
        if (Vars.net.client()) {
            Vars.netClient.clearRemovedEntity(unit.id);
        }
        if (build.acceptPayload(build, (Payload)(unitPay = new UnitPayload(unit)))) {
            Fx.unitDrop.at((Position)build);
            build.handlePayload(build, (Payload)unitPay);
        }
    }

    public static void dropItem(Player player, float angle) {
        if (player == null || player.unit() == null) {
            return;
        }
        if (Vars.net.server() && player.unit().stack.amount <= 0) {
            throw new ValidateException(player, "Player cannot drop an item.");
        }
        Unit unit = player.unit();
        Fx.dropItem.at(unit.x, unit.y, angle, Color.white, (Object)unit.item());
        unit.clearItem();
    }

    public static void rotateBlock(@Nullable Player player, Building build, boolean direction) {
        if (build == null) {
            return;
        }
        if (!(!Vars.net.server() || Units.canInteract(player, build) && Vars.netServer.admins.allowAction(player, Administration.ActionType.rotate, build.tile, action -> {
            action.rotation = Mathf.mod((int)(build.rotation + Mathf.sign((boolean)direction)), (int)4);
        }))) {
            throw new ValidateException(player, "Player cannot rotate a block.");
        }
        if (player != null) {
            build.updateLastAccess(player);
        }
        int previous = build.rotation;
        build.rotation = Mathf.mod((int)(build.rotation + Mathf.sign((boolean)direction)), (int)4);
        build.updateProximity();
        build.noSleep();
        Fx.rotateBlock.at(build.x, build.y, (float)build.block.size);
        if (!Vars.headless) {
            Sounds.blockRotate.at((Position)build, 1.0f + Mathf.range((float)0.1f), 1.0f);
        }
        Events.fire((Object)new EventType.BuildRotateEvent(build, player == null ? null : player.unit(), previous));
    }

    public static void tileConfig(@Nullable Player player, Building build, @Nullable Object value) {
        if (build == null && Vars.net.server()) {
            throw new ValidateException(player, "building is null");
        }
        if (build == null) {
            return;
        }
        if (!(!Vars.net.server() || Units.canInteract(player, build) && Vars.netServer.admins.allowAction(player, Administration.ActionType.configure, build.tile, action -> {
            action.config = value;
        }))) {
            if (player.con != null) {
                TileConfigCallPacket packet = new TileConfigCallPacket();
                packet.player = player;
                packet.build = build;
                packet.value = build.config();
                player.con.send((Object)packet, true);
            }
            if (!player.isLocal()) {
                throw new ValidateException(player, "Player cannot configure a tile.");
            }
            return;
        }
        if (player != null) {
            build.updateLastAccess(player);
        }
        build.configured(player == null || player.dead() ? null : player.unit(), value);
        Events.fire((Object)new EventType.ConfigEvent(build, player, value));
    }

    public static void tileTap(@Nullable Player player, Tile tile) {
        if (tile == null) {
            return;
        }
        Events.fire((Object)new EventType.TapEvent(player, tile));
    }

    public static void buildingControlSelect(Player player, Building build) {
        if (player == null || build == null || player.dead()) {
            return;
        }
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.buildSelect, action -> {
            action.tile = build.tile;
        })) {
            throw new ValidateException(player, "Player cannot control a building.");
        }
        if ((player.team() == build.team || build instanceof CoreBlock.CoreBuild && Vars.state.rules.editor) && build.canControlSelect(player.unit())) {
            Unit before = player.unit();
            build.onControlSelect(player.unit());
            if (!before.dead && before.spawnedByCore && !before.isPlayer()) {
                Call.unitDespawn((Unit)before);
            }
        }
    }

    public static void unitBuildingControlSelect(Unit unit, Building build) {
        if (unit == null || unit.dead()) {
            return;
        }
        if (unit.team() == build.team && (Vars.net.client() || build.canControlSelect(unit))) {
            build.onControlSelect(unit);
        }
    }

    public static void unitControl(Player player, @Nullable Unit unit) {
        if (player == null) {
            return;
        }
        if (!(!Vars.net.server() || Vars.state.rules.possessionAllowed && Vars.netServer.admins.allowAction(player, Administration.ActionType.control, action -> {
            action.unit = unit;
        }))) {
            throw new ValidateException(player, "Player cannot control a unit.");
        }
        if (unit == null) {
            player.clearUnit();
        } else if (unit.isAI() && unit.team == player.team() && !unit.dead && unit.playerControllable()) {
            if (Vars.net.client() && player.isLocal()) {
                player.justSwitchFrom = player.unit();
                player.justSwitchTo = unit;
            }
            Unit before = player.unit();
            player.unit(unit);
            if (before != null) {
                if (before.spawnedByCore) {
                    unit.dockedType = before.type;
                } else if (before.dockedType != null && before.dockedType.coreUnitDock) {
                    unit.dockedType = before.dockedType;
                }
                if (before.spawnedByCore && !before.isPlayer()) {
                    Call.unitDespawn((Unit)before);
                }
            }
            Time.run((float)Fx.unitSpirit.lifetime, () -> Fx.unitControl.at(unit.x, unit.y, 0.0f, (Object)unit));
            if (!player.dead()) {
                Fx.unitSpirit.at(player.x, player.y, 0.0f, (Object)unit);
            }
        } else if (Vars.net.server()) {
            throw new ValidateException(player, "Player attempted to control invalid unit.");
        }
        Events.fire((Object)new EventType.UnitControlEvent(player, unit));
    }

    public static void unitClear(Player player) {
        if (player == null) {
            return;
        }
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.respawn, action -> {})) {
            throw new ValidateException(player, "Player cannot respawn.");
        }
        if (!player.dead() && !player.unit().spawnedByCore) {
            CoreBlock.CoreBuild closest;
            UnitType docked = player.unit().dockedType;
            if (docked == null && (closest = player.bestCore()) != null) {
                docked = ((CoreBlock)((Object)closest.block)).unitType;
            }
            if (docked != null && docked.coreUnitDock) {
                Fx.spawn.at((Position)player);
                if (!Vars.net.client()) {
                    Unit unit = docked.create(player.team());
                    unit.set((Position)player.unit());
                    if (player.unit().isFlying() && unit.type.flying) {
                        Tmp.v1.trns(player.unit().rotation + 180.0f, player.unit().hitSize / 2.0f + unit.hitSize / 2.0f);
                        unit.x += Tmp.v1.x;
                        unit.y += Tmp.v1.y;
                    }
                    unit.rotation(player.unit().rotation);
                    unit.controller((UnitController)player);
                    unit.spawnedByCore(true);
                    unit.add();
                }
                return;
            }
        }
        Fx.spawn.at((Position)player);
        player.clearUnit();
        player.checkSpawn();
        player.deathTimer = 61.0f;
    }

    public void addLock(Boolp lock) {
        this.inputLocks.add((Object)lock);
    }

    public boolean locked() {
        return this.inputLocks.contains(Boolp::get);
    }

    public Eachable<BuildPlan> allPlans() {
        return this.allPlans;
    }

    public boolean isUsingSchematic() {
        return !this.selectPlans.isEmpty();
    }

    public void spectate(Unit unit) {
        this.spectating = unit;
        Core.camera.position.set((Position)unit);
    }

    public void reset() {
        this.logicCutscene = false;
        this.commandBuildings.clear();
        this.selectedUnits.clear();
        this.itemDepositCooldown = 0.0f;
        Arrays.fill(this.controlGroups, null);
        this.lastUnit = null;
        this.lastPlans.clear();
        Vars.player.shooting = false;
    }

    public void update() {
        Unit unit;
        if (this.spectating != null && !this.spectating.isValid()) {
            this.spectating = null;
        }
        if (this.logicCutscene && !Vars.renderer.isCutscene()) {
            Core.camera.position.lerpDelta((Position)this.logicCamPan, this.logicCamSpeed);
        } else {
            this.logicCutsceneZoom = -1.0f;
        }
        this.itemDepositCooldown -= Time.delta / 60.0f;
        this.commandBuildings.removeAll(b -> !b.isValid() || !b.isCommandable() || b.team != Vars.player.team());
        if (!this.commandMode) {
            this.commandRect = false;
        }
        if (Vars.player.isBuilder()) {
            Queue<BuildPlan> playerPlans = Vars.player.unit().plans;
            if (Vars.player.unit() != this.lastUnit && playerPlans.size <= 1) {
                playerPlans.ensureCapacity(this.lastPlans.size);
                for (BuildPlan plan : this.lastPlans) {
                    playerPlans.addLast((Object)plan);
                }
            }
            if (this.lastPlans.size != playerPlans.size || this.lastPlans.size > 0 && playerPlans.size > 0 && this.lastPlans.first() != playerPlans.first()) {
                this.lastPlans.clear();
                for (BuildPlan plan : playerPlans) {
                    this.lastPlans.addLast((Object)plan);
                }
            }
        }
        this.lastUnit = Vars.player.unit();
        this.playerPlanTree.clear();
        if (!Vars.player.dead()) {
            Vars.player.unit().plans.each(arg_0 -> this.playerPlanTree.insert(arg_0));
        }
        Vars.player.typing = Vars.ui.chatfrag.shown();
        if (Vars.player.dead()) {
            this.droppingItem = false;
        }
        if (Vars.player.isBuilder()) {
            Vars.player.unit().updateBuilding(this.isBuilding);
        }
        if (this.locked()) {
            this.block = null;
        }
        this.wasShooting = Vars.player.shooting;
        if (!Vars.player.dead()) {
            float f;
            this.recentRespawnTimer -= Time.delta / 70.0f;
            if (f <= 0.0f && Vars.player.justSwitchFrom != Vars.player.unit()) {
                this.controlledType = Vars.player.unit().type;
            }
        }
        if (this.controlledType != null && Vars.player.dead() && this.controlledType.playerControllable && (unit = Units.closest(Vars.player.team(), Vars.player.x, Vars.player.y, (Boolf<Unit>)((Boolf)u -> !u.isPlayer() && u.type == this.controlledType && u.playerControllable() && !u.dead))) != null && (!Vars.net.client() || this.controlInterval.get(0, 70.0f))) {
            this.recentRespawnTimer = 1.0f;
            Call.unitControl((Player)Vars.player, (Unit)unit);
        }
    }

    public void checkUnit() {
        if (this.controlledType != null && this.controlledType.playerControllable) {
            Unit unit = Units.closest(Vars.player.team(), Vars.player.x, Vars.player.y, (Boolf<Unit>)((Boolf)u -> !u.isPlayer() && u.type == this.controlledType && !u.dead));
            if (unit == null && this.controlledType == UnitTypes.block) {
                ControlBlock cont;
                Building building = Vars.world.buildWorld(Vars.player.x, Vars.player.y);
                Unit unit2 = unit = building instanceof ControlBlock && (cont = (ControlBlock)building).canControl() ? cont.unit() : null;
            }
            if (unit != null) {
                if (Vars.net.client()) {
                    Call.unitControl((Player)Vars.player, (Unit)unit);
                } else {
                    unit.controller((UnitController)Vars.player);
                }
            }
        }
    }

    public void tryPickupPayload() {
        Unit unit = Vars.player.unit();
        if (!(unit instanceof Payloadc)) {
            return;
        }
        Payloadc pay = (Payloadc)unit;
        Unit target = Units.closest(Vars.player.team(), pay.x(), pay.y(), unit.type.hitSize * 2.0f, (Boolf<Unit>)((Boolf)u -> u.isAI() && u.isGrounded() && pay.canPickup(u) && u.within((Position)unit, u.hitSize + unit.hitSize)));
        if (target != null) {
            Call.requestUnitPayload((Player)Vars.player, (Unit)target);
        } else {
            Building build = Vars.world.buildWorld(pay.x(), pay.y());
            if (build != null && Vars.state.teams.canInteract(unit.team, build.team)) {
                Call.requestBuildPayload((Player)Vars.player, (Building)build);
            }
        }
    }

    public void tryDropPayload() {
        Unit unit = Vars.player.unit();
        if (!(unit instanceof Payloadc)) {
            return;
        }
        Call.requestDropPayload((Player)Vars.player, (float)Vars.player.x, (float)Vars.player.y);
    }

    public float getMouseX() {
        return Core.input.mouseX();
    }

    public float getMouseY() {
        return Core.input.mouseY();
    }

    public void buildPlacementUI(Table table2) {
    }

    public void buildUI(Group group) {
    }

    public void updateState() {
        if (Vars.state.isMenu()) {
            this.controlledType = null;
            this.logicCutscene = false;
            this.config.forceHide();
            this.commandRect = false;
            this.commandMode = false;
        }
    }

    public boolean multiUnitSelect() {
        return false;
    }

    public void selectUnitsRect() {
        if (this.commandMode && this.commandRect) {
            if (!this.tappedOne) {
                Seq<Unit> units = this.selectedCommandUnits(this.commandRectX, this.commandRectY, Core.input.mouseWorldX() - this.commandRectX, Core.input.mouseWorldY() - this.commandRectY);
                if (this.multiUnitSelect()) {
                    this.selectedUnits.removeAll(units);
                } else {
                    this.selectedUnits.clear();
                }
                this.commandBuildings.clear();
                this.selectedUnits.addAll(units);
                if (this.selectedUnits.isEmpty()) {
                    this.commandBuildings.addAll(this.selectedCommandBuildings(this.commandRectX, this.commandRectY, Core.input.mouseWorldX() - this.commandRectX, Core.input.mouseWorldY() - this.commandRectY));
                }
                Events.fire((Enum)EventType.Trigger.unitCommandChange);
            }
            this.commandRect = false;
        }
    }

    public void selectTypedUnits() {
        Unit unit;
        if (this.commandMode && (unit = this.selectedCommandUnit(Core.input.mouseWorldX(), Core.input.mouseWorldY())) != null) {
            this.selectedUnits.clear();
            Core.camera.bounds(Tmp.r1);
            this.selectedUnits.addAll(this.selectedCommandUnits(Tmp.r1.x, Tmp.r1.y, Tmp.r1.width, Tmp.r1.height, (Boolf<Unit>)((Boolf)u -> u.type == unit.type)));
            Events.fire((Enum)EventType.Trigger.unitCommandChange);
        }
    }

    public void tapCommandUnit() {
        if (this.commandMode) {
            Unit unit = this.selectedCommandUnit(Core.input.mouseWorldX(), Core.input.mouseWorldY());
            Building build = Vars.world.buildWorld(Core.input.mouseWorldX(), Core.input.mouseWorldY());
            if (unit != null) {
                if (!this.selectedUnits.contains((Object)unit)) {
                    this.selectedUnits.add((Object)unit);
                } else {
                    this.selectedUnits.remove((Object)unit);
                }
                this.commandBuildings.clear();
            } else {
                this.selectedUnits.clear();
                if (build != null && build.team == Vars.player.team() && build.isCommandable()) {
                    if (this.commandBuildings.contains((Object)build)) {
                        this.commandBuildings.remove((Object)build);
                    } else {
                        this.commandBuildings.add((Object)build);
                    }
                } else {
                    this.commandBuildings.clear();
                }
            }
            Events.fire((Enum)EventType.Trigger.unitCommandChange);
        }
    }

    public void commandTap(float screenX, float screenY) {
        this.commandTap(screenX, screenY, false);
    }

    public void commandTap(float screenX, float screenY, boolean queue) {
        if (this.commandMode) {
            Vec2 target = Core.input.mouseWorld(screenX, screenY).cpy();
            if (this.selectedUnits.size > 0) {
                Healthc attack = Vars.world.buildWorld(target.x, target.y);
                if (attack == null || attack.team() == Vars.player.team()) {
                    attack = this.selectedEnemyUnit(target.x, target.y);
                }
                if (Core.input.keyDown(KeyCode.altLeft)) {
                    attack = null;
                }
                int[] ids = new int[this.selectedUnits.size];
                for (int i = 0; i < ids.length; ++i) {
                    ids[i] = ((Unit)this.selectedUnits.get((int)i)).id;
                }
                if (attack != null) {
                    Events.fire((Enum)EventType.Trigger.unitCommandAttack);
                } else {
                    Events.fire((Enum)EventType.Trigger.unitCommandPosition);
                }
                int maxChunkSize = 200;
                if (ids.length > maxChunkSize) {
                    for (int i = 0; i < ids.length; i += maxChunkSize) {
                        Unit u;
                        Healthc b2;
                        int[] data = Arrays.copyOfRange(ids, i, Math.min(i + maxChunkSize, ids.length));
                        Call.commandUnits((Player)Vars.player, (int[])data, (Building)(attack instanceof Building ? (b2 = attack) : null), (Unit)(attack instanceof Unit ? (u = (Unit)attack) : null), (Vec2)target, (boolean)queue, (i + maxChunkSize >= ids.length ? 1 : 0) != 0);
                    }
                } else {
                    Unit u;
                    Healthc b3;
                    Call.commandUnits((Player)Vars.player, (int[])ids, (Building)(attack instanceof Building ? (b3 = attack) : null), (Unit)(attack instanceof Unit ? (u = (Unit)attack) : null), (Vec2)target, (boolean)queue, (boolean)true);
                }
            }
            if (this.commandBuildings.size > 0) {
                Call.commandBuilding((Player)Vars.player, (int[])this.commandBuildings.mapInt(b -> b.pos()).toArray(), (Vec2)target);
            }
        }
    }

    public void drawCommand(Unit sel) {
        Drawf.poly((float)sel.x, (float)sel.y, (int)6, (float)(sel.hitSize / 1.0f + Mathf.absin((float)4.0f, (float)1.0f)), (float)0.0f, (Color)(this.selectedUnits.contains((Object)sel) ? Pal.remove : Pal.accent));
    }

    public void drawCommand(Building build) {
        Drawf.poly((float)build.x, (float)build.y, (int)4, (float)(build.hitSize() / 1.4f + 0.5f + Mathf.absin((float)4.0f, (float)1.0f)), (float)0.0f, (Color)(this.commandBuildings.contains((Object)build) ? Pal.remove : Pal.accent));
    }

    public void drawCommanded() {
        Draw.draw((float)85.0f, () -> this.drawCommanded(true));
        Draw.draw((float)59.0f, () -> this.drawCommanded(false));
        Draw.draw((float)120.0f, () -> this.drawCommandedTargets());
    }

    public void drawCommandedTargets() {
        if (this.commandMode) {
            for (Unit unit : this.selectedUnits) {
                UnitController unitController = unit.controller();
                if (!(unitController instanceof CommandAI)) continue;
                CommandAI ai = (CommandAI)unitController;
                UnitCommand cmd = ai.currentCommand();
                if (ai.attackTarget == null || !cmd.drawTarget) continue;
                Drawf.target((float)ai.attackTarget.getX(), (float)ai.attackTarget.getY(), (float)6.0f, (Color)Pal.remove);
            }
        }
    }

    public void drawCommanded(boolean flying) {
        float lineLimit = 6.5f;
        int sides = 6;
        float alpha = 0.5f;
        if (this.commandMode) {
            this.selectedUnits.removeAll(u -> !u.allowCommand());
            for (Unit unit : this.selectedUnits) {
                Object lineDest;
                Color color = unit.controller() instanceof LogicAI ? Team.malis.color : Pal.accent;
                Teamc lastPos = null;
                UnitController unitController = unit.controller();
                if (unitController instanceof CommandAI) {
                    CommandAI ai = (CommandAI)unitController;
                    UnitCommand cmd = ai.currentCommand();
                    lastPos = ai.attackTarget != null ? ai.attackTarget : ai.targetPos;
                    if ((unit.isFlying() || unit.type.allowLegStep) != flying) continue;
                    if (ai.targetPos != null && cmd.drawTarget) {
                        lineDest = ai.attackTarget != null ? ai.attackTarget : ai.targetPos;
                        Drawf.limitLine((Position)unit, (Position)lineDest, (float)(unit.hitSize / 1.0f + 1.0f), (float)lineLimit, (Color)color.write(Tmp.c1).a(alpha));
                        if (ai.attackTarget == null) {
                            Drawf.square((float)lineDest.getX(), (float)lineDest.getY(), (float)3.5f, (Color)color.write(Tmp.c1).a(alpha));
                            if (cmd == UnitCommand.enterPayloadCommand) {
                                Building build = Vars.world.buildWorld(lineDest.getX(), lineDest.getY());
                                if (build != null && build.block.acceptsUnitPayloads && build.team == unit.team) {
                                    Drawf.selected((Building)build, (Color)color);
                                } else {
                                    Drawf.cross((float)lineDest.getX(), (float)lineDest.getY(), (float)7.0f, (Color)Pal.remove);
                                }
                            }
                        }
                    }
                }
                float rad = unit.hitSize / 1.0f + 1.0f;
                Fill.lightInner((float)unit.x, (float)unit.y, (int)sides, (float)Math.max(0.0f, rad * 0.8f), (float)rad, (float)0.0f, (Color)Tmp.c3.set(color).a(0.0f), (Color)Tmp.c2.set(color).a(0.7f));
                Lines.stroke(1.0f);
                Draw.color((Color)color);
                Lines.poly(unit.x, unit.y, sides, rad + 0.5f);
                Draw.reset();
                if (lastPos == null) {
                    lastPos = unit;
                }
                if (!((lineDest = unit.controller()) instanceof CommandAI)) continue;
                CommandAI ai = (CommandAI)lineDest;
                if (ai.currentCommand().drawTarget && ai.commandQueue.size > 0) {
                    lineDest = ai.commandQueue.iterator();
                    while (lineDest.hasNext()) {
                        Position next = (Position)lineDest.next();
                        Drawf.limitLine((Position)lastPos, (Position)next, (float)lineLimit, (float)lineLimit, (Color)color.write(Tmp.c1).a(alpha));
                        lastPos = next;
                        if (next instanceof Vec2) {
                            Vec2 vec = (Vec2)next;
                            Drawf.square((float)vec.x, (float)vec.y, (float)3.5f, (Color)color.write(Tmp.c1).a(alpha));
                            continue;
                        }
                        Drawf.target((float)next.getX(), (float)next.getY(), (float)6.0f, (Color)Pal.remove);
                    }
                }
                if (ai.targetPos == null || ai.currentCommand() != UnitCommand.loopPayloadCommand || !(unit instanceof Payloadc)) continue;
                Payloadc pay = (Payloadc)unit;
                Draw.color((Color)color, (float)(0.4f + Mathf.absin((float)5.0f, (float)0.5f)));
                TextureRegion region = pay.hasPayload() ? Icon.download.getRegion() : Icon.upload.getRegion();
                float offset = 11.0f;
                float size = 8.0f;
                Draw.rect((TextureRegion)region, (float)ai.targetPos.x, (float)(ai.targetPos.y + offset), (float)size, (float)(size / region.ratio()));
                if (ai.commandQueue.size > 0) {
                    region = !pay.hasPayload() ? Icon.download.getRegion() : Icon.upload.getRegion();
                    Draw.rect((TextureRegion)region, (float)((Position)ai.commandQueue.first()).getX(), (float)(((Position)ai.commandQueue.first()).getY() + offset), (float)size, (float)(size / region.ratio()));
                }
                Draw.color();
            }
            if (flying) {
                Color color = Pal.accent;
                for (Building commandBuild : this.commandBuildings) {
                    if (commandBuild == null) continue;
                    Drawf.square((float)commandBuild.x, (float)commandBuild.y, (float)(commandBuild.hitSize() / 1.4f + 1.0f));
                    Vec2 cpos = commandBuild.getCommandPosition();
                    if (cpos == null) continue;
                    Drawf.limitLine((Position)commandBuild, (Position)cpos, (float)(commandBuild.hitSize() / 2.0f), (float)lineLimit, (Color)color.write(Tmp.c1).a(alpha));
                    Drawf.square((float)cpos.x, (float)cpos.y, (float)3.5f, (Color)color.write(Tmp.c1).a(alpha));
                }
            }
        }
        Draw.reset();
    }

    public void drawUnitSelection() {
        Unit sel;
        if (this.commandRect && this.commandMode) {
            float x2 = Core.input.mouseWorldX();
            float y2 = Core.input.mouseWorldY();
            Seq<Unit> units = this.selectedCommandUnits(this.commandRectX, this.commandRectY, x2 - this.commandRectX, y2 - this.commandRectY);
            for (Unit unit : units) {
                this.drawCommand(unit);
            }
            if (units.isEmpty()) {
                Seq<Building> buildings = this.selectedCommandBuildings(this.commandRectX, this.commandRectY, x2 - this.commandRectX, y2 - this.commandRectY);
                for (Building build : buildings) {
                    this.drawCommand(build);
                }
            }
            Draw.color((Color)Pal.accent, (float)0.3f);
            Fill.crect((float)this.commandRectX, (float)this.commandRectY, (float)(x2 - this.commandRectX), (float)(y2 - this.commandRectY));
        }
        if (this.commandMode && !this.commandRect && (sel = this.selectedCommandUnit(Core.input.mouseWorldX(), Core.input.mouseWorldY())) != null && (this.multiUnitSelect() || this.selectedUnits.size != 1 || !this.selectedUnits.contains((Object)sel))) {
            this.drawCommand(sel);
        }
    }

    public void drawBottom() {
    }

    public void drawTop() {
    }

    public void drawOverSelect() {
    }

    public void drawSelected(int x, int y, Block block, Color color) {
        Drawf.selected((int)x, (int)y, (Block)block, (Color)color);
    }

    public void drawBreaking(BuildPlan plan) {
        if (plan.breaking) {
            this.drawBreaking(plan.x, plan.y);
        } else {
            this.drawSelected(plan.x, plan.y, plan.block, Pal.remove);
        }
    }

    public void drawOverlapCheck(Block block, int cursorX, int cursorY, boolean valid) {
        Building blocker;
        if (!valid && Vars.state.rules.placeRangeCheck && (blocker = Build.getEnemyOverlap(block, Vars.player.team(), cursorX, cursorY)) != null && blocker.wasVisible) {
            Drawf.selected((Building)blocker, (Color)Pal.remove);
            Tmp.v1.set((float)cursorX, (float)cursorY).scl(8.0f).add(block.offset, block.offset).sub((Position)blocker).scl(-1.0f).nor();
            Drawf.dashLineDst((Color)Pal.remove, (float)((float)(cursorX * 8) + block.offset + Tmp.v1.x * (float)block.size * 8.0f / 2.0f), (float)((float)(cursorY * 8) + block.offset + Tmp.v1.y * (float)block.size * 8.0f / 2.0f), (float)(blocker.x + Tmp.v1.x * (float)(-blocker.block.size) * 8.0f / 2.0f), (float)(blocker.y + Tmp.v1.y * (float)(-blocker.block.size) * 8.0f / 2.0f));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean planMatches(BuildPlan plan) {
        Tile tile = Vars.world.tile(plan.x, plan.y);
        if (tile == null) return false;
        Building building = tile.build;
        if (!(building instanceof ConstructBlock.ConstructBuild)) return false;
        ConstructBlock.ConstructBuild cons = (ConstructBlock.ConstructBuild)building;
        if (cons.current != plan.block) return false;
        return true;
    }

    public void drawBreaking(int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return;
        }
        Block block = tile.block();
        this.drawSelected(x, y, block, Pal.remove);
    }

    public void useSchematic(Schematic schem) {
        this.useSchematic(schem, true);
    }

    public abstract void useSchematic(Schematic var1, boolean var2);

    protected void showSchematicSave() {
        if (this.lastSchematic == null) {
            return;
        }
        Schematic last = this.lastSchematic;
        Vars.ui.showTextInput("@schematic.add", "@name", 1000, "", (Cons<String>)((Cons)text -> {
            Schematic replacement = (Schematic)Vars.schematics.all().find(s -> s.name().equals(text));
            if (replacement != null) {
                Vars.ui.showConfirm("@confirm", "@schematic.replace", () -> {
                    Vars.schematics.overwrite(replacement, last);
                    Vars.ui.showInfoFade("@schematic.saved");
                    Vars.ui.schematics.showInfo(replacement);
                });
            } else {
                last.tags.put((Object)"name", text);
                last.tags.put((Object)"description", (Object)"");
                Vars.schematics.add(last);
                Vars.ui.showInfoFade("@schematic.saved");
                Vars.ui.schematics.showInfo(last);
                Events.fire((Object)new EventType.SchematicCreateEvent(last));
            }
        }));
    }

    protected void showSchematicPreview() {
        if (this.lastSchematic == null) {
            return;
        }
        Vars.ui.schematics.showInfo(this.lastSchematic);
    }

    public void rotatePlans(Seq<BuildPlan> plans, int direction) {
        int ox = this.schemOriginX();
        int oy = this.schemOriginY();
        plans.each(plan -> {
            Block patt55817$temp;
            if (plan.breaking) {
                return;
            }
            float off = plan.block.size % 2 == 0 ? -0.5f : 0.0f;
            plan.pointConfig(p -> {
                float cx = (float)p.x + off;
                float cy = (float)p.y + off;
                float lx = cx;
                if (direction >= 0) {
                    cx = -cy;
                    cy = lx;
                } else {
                    cx = cy;
                    cy = -lx;
                }
                p.set(Mathf.floor((float)(cx - off)), Mathf.floor((float)(cy - off)));
            });
            float wx = (float)((plan.x - ox) * 8) + plan.block.offset;
            float wy = (float)((plan.y - oy) * 8) + plan.block.offset;
            float x = wx;
            if (direction >= 0) {
                wx = -wy;
                wy = x;
            } else {
                wx = wy;
                wy = -x;
            }
            plan.x = World.toTile(wx - plan.block.offset) + ox;
            plan.y = World.toTile(wy - plan.block.offset) + oy;
            plan.rotation = plan.block.planRotation(Mathf.mod((int)(plan.rotation + direction), (int)4));
            if (((Boolean)LogicExt.rotateCanvas.get()).booleanValue() && (patt55817$temp = plan.block) instanceof CanvasBlock) {
                CanvasBlock cb = (CanvasBlock)patt55817$temp;
                CanvasBlock.CanvasBuild temp = new CanvasBlock.CanvasBuild(cb);
                Pixmap pix = new Pixmap(cb.canvasSize, cb.canvasSize);
                Pixmap pix2 = new Pixmap(cb.canvasSize, cb.canvasSize);
                cb.makePixmap((byte[])plan.config, pix);
                pix.each((px, py) -> pix2.setRaw(direction >= 0 ? py : cb.canvasSize - py - 1, direction >= 0 ? cb.canvasSize - px - 1 : px, pix.getRaw(px, py)));
                plan.config = temp.packPixmap(pix2);
                temp.remove();
                pix.dispose();
                pix2.dispose();
            }
        });
    }

    public void flipPlans(Seq<BuildPlan> plans, boolean x) {
        int origin = (x ? this.schemOriginX() : this.schemOriginY()) * 8;
        plans.each(plan -> {
            Block patt57409$temp;
            if (plan.breaking) {
                return;
            }
            float value = -((float)((x ? plan.x : plan.y) * 8 - origin) + plan.block.offset) + (float)origin;
            if (x) {
                plan.x = (int)((value - plan.block.offset) / 8.0f);
            } else {
                plan.y = (int)((value - plan.block.offset) / 8.0f);
            }
            plan.pointConfig(p -> {
                if (x) {
                    if (plan.block.size % 2 == 0) {
                        --p.x;
                    }
                    p.x = -p.x;
                } else {
                    if (plan.block.size % 2 == 0) {
                        --p.y;
                    }
                    p.y = -p.y;
                }
            });
            plan.block.flipRotation((BuildPlan)plan, x);
            if (((Boolean)LogicExt.rotateCanvas.get()).booleanValue() && (patt57409$temp = plan.block) instanceof CanvasBlock) {
                CanvasBlock cb = (CanvasBlock)patt57409$temp;
                CanvasBlock.CanvasBuild temp = new CanvasBlock.CanvasBuild(cb);
                Pixmap pix = new Pixmap(cb.canvasSize, cb.canvasSize);
                cb.makePixmap((byte[])plan.config, pix);
                Pixmap out = x ? pix.flipX() : pix.flipY();
                plan.config = temp.packPixmap(out);
                temp.remove();
                pix.dispose();
                out.dispose();
            }
        });
    }

    protected int schemOriginX() {
        return this.rawTileX();
    }

    protected int schemOriginY() {
        return this.rawTileY();
    }

    @Nullable
    protected BuildPlan getPlan(int x, int y) {
        return this.getPlan(x, y, 1, null);
    }

    @Nullable
    protected BuildPlan getPlan(int x, int y, int size, BuildPlan skip) {
        float offset = (float)((size + 1) % 2 * 8) / 2.0f;
        r2.setSize((float)(8 * size));
        r2.setCenter((float)(x * 8) + offset, (float)(y * 8) + offset);
        this.resultplan = null;
        Boolf test = plan -> {
            if (plan == skip) {
                return false;
            }
            Tile other = plan.tile();
            if (other == null) {
                return false;
            }
            if (!plan.breaking) {
                r1.setSize((float)(plan.block.size * 8));
                r1.setCenter(other.worldx() + plan.block.offset, other.worldy() + plan.block.offset);
            } else {
                r1.setSize((float)(other.block().size * 8));
                r1.setCenter(other.worldx() + other.block().offset, other.worldy() + other.block().offset);
            }
            return r2.overlaps(r1);
        };
        if (!Vars.player.dead()) {
            for (BuildPlan plan2 : Vars.player.unit().plans()) {
                if (!test.get((Object)plan2)) continue;
                return plan2;
            }
        }
        return (BuildPlan)this.selectPlans.find(test);
    }

    protected void drawBreakSelection(int x1, int y1, int x2, int y2, int maxLength) {
        this.drawBreakSelection(x1, y1, x2, y2, maxLength, true);
    }

    protected void drawBreakSelection(int x1, int y1, int x2, int y2, int maxLength, boolean useSelectPlans) {
        Placement.NormalizeDrawResult result = Placement.normalizeDrawArea((Block)Blocks.air, (int)x1, (int)y1, (int)x2, (int)y2, (boolean)false, (int)maxLength, (float)1.0f);
        Placement.NormalizeResult dresult = Placement.normalizeArea((int)x1, (int)y1, (int)x2, (int)y2, (int)this.rotation, (boolean)false, (int)maxLength);
        for (int x = dresult.x; x <= dresult.x2; ++x) {
            for (int y = dresult.y; y <= dresult.y2; ++y) {
                Tile tile = Vars.world.tileBuilding(x, y);
                if (tile == null || !this.validBreak(tile.x, tile.y)) continue;
                this.drawBreaking(tile.x, tile.y);
            }
        }
        Tmp.r1.set(result.x, result.y, result.x2 - result.x, result.y2 - result.y);
        Draw.color((Color)Pal.remove);
        Lines.stroke(1.0f);
        if (!Vars.player.dead()) {
            for (BuildPlan plan : Vars.player.unit().plans()) {
                if (plan.breaking || !plan.bounds(Tmp.r2).overlaps(Tmp.r1)) continue;
                this.drawBreaking(plan);
            }
        }
        if (useSelectPlans) {
            for (BuildPlan plan : this.selectPlans) {
                if (plan.breaking || !plan.bounds(Tmp.r2).overlaps(Tmp.r1)) continue;
                this.drawBreaking(plan);
            }
        }
        for (Teams.BlockPlan plan : Vars.player.team().data().plans) {
            Block block = plan.block;
            if (!block.bounds(plan.x, plan.y, Tmp.r2).overlaps(Tmp.r1)) continue;
            this.drawSelected(plan.x, plan.y, plan.block, Pal.remove);
        }
        Lines.stroke(2.0f);
        Draw.color((Color)Pal.removeBack);
        Lines.rect(result.x, result.y - 1.0f, result.x2 - result.x, result.y2 - result.y);
        Draw.color((Color)Pal.remove);
        Lines.rect(result.x, result.y, result.x2 - result.x, result.y2 - result.y);
    }

    protected void drawRebuildSelection(int x1, int y1, int x2, int y2) {
        this.drawSelection(x1, y1, x2, y2, 0, Pal.sapBulletBack, Pal.sapBullet, false);
        Placement.NormalizeDrawResult result = Placement.normalizeDrawArea((Block)Blocks.air, (int)x1, (int)y1, (int)x2, (int)y2, (boolean)false, (int)0, (float)1.0f);
        Tmp.r1.set(result.x, result.y, result.x2 - result.x, result.y2 - result.y);
        for (Teams.BlockPlan plan : Vars.player.team().data().plans) {
            Block block = plan.block;
            if (!block.bounds(plan.x, plan.y, Tmp.r2).overlaps(Tmp.r1)) continue;
            this.drawSelected(plan.x, plan.y, plan.block, Pal.sapBullet);
        }
        Placement.NormalizeResult dresult = Placement.normalizeArea((int)x1, (int)y1, (int)x2, (int)y2, (int)this.rotation, (boolean)false, (int)999999999);
        intSet.clear();
        for (int x = dresult.x; x <= dresult.x2; ++x) {
            for (int y = dresult.y; y <= dresult.y2; ++y) {
                Tile tile = Vars.world.tileBuilding(x, y);
                if (tile == null || !intSet.add(tile.pos()) || !this.canRepairDerelict(tile)) continue;
                this.drawSelected(tile.x, tile.y, tile.block(), Pal.sapBullet);
            }
        }
    }

    protected void drawBreakSelection(int x1, int y1, int x2, int y2) {
        this.drawBreakSelection(x1, y1, x2, y2, 100);
    }

    protected void drawSelection(int x1, int y1, int x2, int y2, int maxLength) {
        this.drawSelection(x1, y1, x2, y2, maxLength, Pal.accentBack, Pal.accent, true);
    }

    protected void drawSelection(int x1, int y1, int x2, int y2, int maxLength, Color col1, Color col2, boolean withText) {
        Placement.NormalizeDrawResult result = Placement.normalizeDrawArea((Block)Blocks.air, (int)x1, (int)y1, (int)x2, (int)y2, (boolean)false, (int)maxLength, (float)1.0f);
        Lines.stroke(2.0f);
        Draw.color((Color)col1);
        Lines.rect(result.x, result.y - 1.0f, result.x2 - result.x, result.y2 - result.y);
        Draw.color((Color)col2);
        Lines.rect(result.x, result.y, result.x2 - result.x, result.y2 - result.y);
        if (withText) {
            Font font = Fonts.outline;
            font.setColor(col2);
            boolean ints = font.usesIntegerPositions();
            font.setUseIntegerPositions(false);
            float z = Draw.z();
            Draw.z((float)210.0f);
            font.getData().setScale(1.0f / Vars.renderer.camerascale);
            boolean snapToCursor = Core.settings.getBool("selectionsizeoncursor");
            int textOffset = Core.settings.getInt("selectionsizeoncursoroffset", 5);
            int width = (int)((result.x2 - result.x) / 8.0f);
            int height = (int)((result.y2 - result.y) / 8.0f);
            int area = width * height;
            font.draw((CharSequence)(width + "x" + height + " (" + area + ")"), snapToCursor ? Core.input.mouseWorldX() + (float)textOffset * (4.0f / Vars.renderer.camerascale) : result.x2, snapToCursor ? Core.input.mouseWorldY() - (float)textOffset * (4.0f / Vars.renderer.camerascale) : result.y);
            font.setColor(Color.white);
            font.getData().setScale(1.0f);
            font.setUseIntegerPositions(ints);
            Draw.z((float)z);
        }
        this.lastSelection.set((float)x1, (float)y1, (float)(x2 - x1), (float)(y2 - y1));
        this.lastSelection.normalize();
    }

    protected void flushSelectPlans(Seq<BuildPlan> plans) {
        for (BuildPlan plan : plans) {
            if (plan.block == null || !this.validPlace(plan.x, plan.y, plan.block, plan.rotation, null, true)) continue;
            BuildPlan other = this.getPlan(plan.x, plan.y, plan.block.size, null);
            if (other == null) {
                this.selectPlans.add((Object)plan.copy());
                continue;
            }
            if (other.breaking || other.x != plan.x || other.y != plan.y || other.block.size != plan.block.size) continue;
            this.selectPlans.remove((Object)other);
            this.selectPlans.add((Object)plan.copy());
        }
    }

    protected void flushPlansReverse(Seq<BuildPlan> plans) {
        for (int i = plans.size - 1; i >= 0; --i) {
            BuildPlan plan = (BuildPlan)plans.get(i);
            if (plan.block == null || !this.validPlace(plan.x, plan.y, plan.block, plan.rotation, null, true)) continue;
            BuildPlan copy = plan.copy();
            plan.block.onNewPlan(copy);
            Vars.player.unit().addBuild(copy, false);
        }
    }

    protected void flushPlans(Seq<BuildPlan> plans) {
        for (BuildPlan plan : plans) {
            if (plan.block == null || !this.validPlace(plan.x, plan.y, plan.block, plan.rotation, null, true)) continue;
            BuildPlan copy = plan.copy();
            plan.block.onNewPlan(copy);
            Vars.player.unit().addBuild(copy);
        }
    }

    protected void drawOverPlan(BuildPlan plan) {
        this.drawOverPlan(plan, this.validPlace(plan.x, plan.y, plan.block, plan.rotation));
    }

    protected void drawOverPlan(BuildPlan plan, boolean valid) {
        Draw.reset();
        Draw.mixcol((Color)(!valid ? Pal.breakInvalid : Color.white), (float)((!valid ? 0.4f : 0.24f) + Mathf.absin((float)Time.globalTime, (float)6.0f, (float)0.28f)));
        Draw.alpha((float)1.0f);
        plan.block.drawPlanConfigTop(plan, this.allSelectLines);
        Draw.reset();
    }

    protected void drawPlan(BuildPlan plan) {
        plan.cachedValid = this.validPlace(plan.x, plan.y, plan.block, plan.rotation);
        this.drawPlan(plan, plan.cachedValid);
    }

    protected void drawPlan(BuildPlan plan, boolean valid) {
        plan.block.drawPlan(plan, this.allPlans(), valid);
    }

    protected void drawPlan(int x, int y, Block block, int rotation) {
        this.bplan.set(x, y, rotation, block);
        if (block.saveConfig) {
            this.bplan.config = block.lastConfig;
        }
        this.bplan.animScale = 1.0f;
        block.drawPlan(this.bplan, this.allPlans(), this.validPlace(x, y, block, rotation));
    }

    protected void removeSelection(int x1, int y1, int x2, int y2) {
        this.removeSelection(x1, y1, x2, y2, false);
    }

    protected void removeSelection(int x1, int y1, int x2, int y2, int maxLength) {
        this.removeSelection(x1, y1, x2, y2, false, maxLength);
    }

    protected void removeSelection(int x1, int y1, int x2, int y2, boolean flush) {
        this.removeSelection(x1, y1, x2, y2, flush, 100);
    }

    protected void removeSelection(int x1, int y1, int x2, int y2, boolean flush, int maxLength) {
        Placement.NormalizeResult result = Placement.normalizeArea((int)x1, (int)y1, (int)x2, (int)y2, (int)this.rotation, (boolean)false, (int)maxLength);
        for (int x = 0; x <= Math.abs(result.x2 - result.x); ++x) {
            for (int y = 0; y <= Math.abs(result.y2 - result.y); ++y) {
                int wy;
                int wx = x1 + x * Mathf.sign((float)(x2 - x1));
                Tile tile = Vars.world.tileBuilding(wx, wy = y1 + y * Mathf.sign((float)(y2 - y1)));
                if (tile == null) continue;
                if (!flush) {
                    this.tryBreakBlock(wx, wy);
                    continue;
                }
                if (!this.validBreak(tile.x, tile.y) || this.selectPlans.contains(r -> r.tile() != null && r.tile() == tile)) continue;
                this.selectPlans.add((Object)new BuildPlan((int)tile.x, (int)tile.y));
            }
        }
        Tmp.r1.set((float)(result.x * 8), (float)(result.y * 8), (float)((result.x2 - result.x) * 8), (float)((result.y2 - result.y) * 8));
        if (!Vars.player.dead()) {
            Iterator it = Vars.player.unit().plans().iterator();
            while (it.hasNext()) {
                BuildPlan plan = (BuildPlan)it.next();
                if (plan.breaking || !plan.bounds(Tmp.r2).overlaps(Tmp.r1)) continue;
                it.remove();
            }
            if (flush) {
                it = this.selectPlans.iterator();
                while (it.hasNext()) {
                    BuildPlan plan = (BuildPlan)it.next();
                    if (plan.breaking || !plan.bounds(Tmp.r2).overlaps(Tmp.r1)) continue;
                    it.remove();
                }
            }
        }
        removed.clear();
        Iterator broken = Vars.player.team().data().plans.iterator();
        while (broken.hasNext()) {
            Teams.BlockPlan plan = (Teams.BlockPlan)broken.next();
            Block block = plan.block;
            if (!block.bounds(plan.x, plan.y, Tmp.r2).overlaps(Tmp.r1)) continue;
            removed.add(Point2.pack((int)plan.x, (int)plan.y));
            plan.removed = true;
            broken.remove();
        }
        if (InputHandler.removed.size > 0 && Vars.net.active()) {
            Call.deletePlans((Player)Vars.player, (int[])removed.toArray());
        }
    }

    protected void updateLine(int x1, int y1, int x2, int y2) {
        this.linePlans.clear();
        Block old = this.block;
        if (BindingExt.placeRouterReplacement.keyDown()) {
            if (old == Blocks.duct) {
                this.block = x1 == x2 & y1 == y2 ? Blocks.ductRouter : Blocks.ductBridge;
            } else if (old == Blocks.conveyor || old == Blocks.titaniumConveyor) {
                this.block = x1 == x2 & y1 == y2 ? Blocks.router : Blocks.itemBridge;
            } else if (old == Blocks.conduit || old == Blocks.pulseConduit) {
                this.block = x1 == x2 & y1 == y2 ? Blocks.liquidRouter : Blocks.bridgeConduit;
            } else if (old == Blocks.reinforcedConduit) {
                this.block = x1 == x2 & y1 == y2 ? Blocks.reinforcedLiquidRouter : Blocks.reinforcedBridgeConduit;
            }
        }
        this.iterateLine(x1, y1, x2, y2, (Cons<PlaceLine>)((Cons)l -> {
            this.rotation = l.rotation;
            BuildPlan plan = new BuildPlan(l.x, l.y, l.rotation, this.block, this.block.nextConfig());
            plan.animScale = 1.0f;
            this.linePlans.add((Object)plan);
        }));
        if (Core.settings.getBool("blockreplace")) {
            this.linePlans.each(plan -> {
                Block replace = plan.block.getReplacement((BuildPlan)plan, this.linePlans);
                if (replace.unlockedNow()) {
                    plan.block = replace;
                }
            });
            this.block.handlePlacementLine(this.linePlans);
        }
        this.block = old;
    }

    protected void updateLine(int x1, int y1) {
        this.updateLine(x1, y1, this.tileX(this.getMouseX()), this.tileY(this.getMouseY()));
    }

    boolean checkConfigTap() {
        return this.config.isShown() && this.config.getSelected().onConfigureTapped(Core.input.mouseWorldX(), Core.input.mouseWorldY());
    }

    boolean tileTapped(@Nullable Building build) {
        this.planConfig.hide();
        if (build == null) {
            this.inv.hide();
            this.config.hideConfig();
            this.commandBuildings.clear();
            return false;
        }
        boolean consumed = false;
        boolean showedInventory = false;
        if (build.isCommandable() && this.commandMode) {
            consumed = true;
        } else if (build.block.configurable && build.interactable(Vars.player.team())) {
            consumed = true;
            if (!this.config.isShown() && build.shouldShowConfigure(Vars.player) || this.config.isShown() && this.config.getSelected().onConfigureBuildTapped(build) && build.shouldShowConfigure(Vars.player)) {
                Sounds.click.at((Position)build);
                this.config.showConfig(build);
            }
        } else if (!this.config.hasConfigMouse()) {
            if (this.config.isShown() && this.config.getSelected().onConfigureBuildTapped(build)) {
                consumed = true;
                this.config.hideConfig();
            }
            if (this.config.isShown()) {
                consumed = true;
            }
        }
        if (!consumed && build.interactable(Vars.player.team())) {
            build.tapped();
        }
        if (build.interactable(Vars.player.team()) && build.block.consumesTap) {
            consumed = true;
        } else if (build.interactable(Vars.player.team()) && build.block.synthetic() && (!consumed || build.block.allowConfigInventory) && build.block.hasItems && build.items.total() > 0) {
            this.inv.showFor(build);
            consumed = true;
            showedInventory = true;
        }
        if (!showedInventory) {
            this.inv.hide();
        }
        return consumed;
    }

    boolean tryTapPlayer(float x, float y) {
        if (this.canTapPlayer(x, y)) {
            this.droppingItem = true;
            return true;
        }
        return false;
    }

    boolean canTapPlayer(float x, float y) {
        return Vars.player.within(x, y, playerSelectRange) && !Vars.player.dead() && Vars.player.unit().stack.amount > 0 && this.block == null;
    }

    boolean tryBeginMine(Tile tile) {
        if (!Vars.player.dead() && this.canMine(tile)) {
            Vars.player.unit().mineTile = tile;
            return true;
        }
        return false;
    }

    boolean tryStopMine() {
        if (!Vars.player.dead() && Vars.player.unit().mining()) {
            Vars.player.unit().mineTile = null;
            return true;
        }
        return false;
    }

    boolean tryStopMine(Tile tile) {
        if (!Vars.player.dead() && Vars.player.unit().mineTile == tile) {
            Vars.player.unit().mineTile = null;
            return true;
        }
        return false;
    }

    boolean tryRepairDerelict(Tile selected) {
        if (!Vars.player.dead() && selected != null && !Vars.state.rules.editor && Vars.player.team() != Team.derelict && selected.build != null && selected.build.block.unlockedNow() && selected.build.team == Team.derelict && Build.validPlace(selected.block(), Vars.player.team(), selected.build.tileX(), selected.build.tileY(), selected.build.rotation)) {
            Vars.player.unit().addBuild(new BuildPlan(selected.build.tileX(), selected.build.tileY(), selected.build.rotation, selected.block(), selected.build.config()));
            return true;
        }
        return false;
    }

    boolean canRepairDerelict(Tile tile) {
        return tile != null && tile.build != null && !Vars.player.dead() && !Vars.state.rules.editor && Vars.player.team() != Team.derelict && tile.build.team == Team.derelict && tile.build.block.unlockedNowHost() && Build.validPlace(tile.block(), Vars.player.team(), tile.build.tileX(), tile.build.tileY(), tile.build.rotation);
    }

    boolean canMine(Tile tile) {
        return !Core.scene.hasMouse() && !Vars.player.dead() && Vars.player.unit().validMine(tile) && Vars.player.unit().acceptsItem(Vars.player.unit().getMineResult(tile)) && (Core.settings.getBool("doubletapmine") || !tile.floor().playerUnmineable || tile.overlay().itemDrop != null);
    }

    Tile tileAt(float x, float y) {
        return Vars.world.tile(this.tileX(x), this.tileY(y));
    }

    int rawTileX() {
        return World.toTile(Core.input.mouseWorld().x);
    }

    int rawTileY() {
        return World.toTile(Core.input.mouseWorld().y);
    }

    int tileX(float cursorX) {
        Vec2 vec = Core.input.mouseWorld(cursorX, 0.0f);
        if (this.selectedBlock()) {
            vec.sub(this.block.offset, this.block.offset);
        }
        return World.toTile(vec.x);
    }

    int tileY(float cursorY) {
        Vec2 vec = Core.input.mouseWorld(0.0f, cursorY);
        if (this.selectedBlock()) {
            vec.sub(this.block.offset, this.block.offset);
        }
        return World.toTile(vec.y);
    }

    public void panCamera(Vec2 position) {
        if (!this.locked()) {
            Core.camera.position.set(position);
        }
    }

    public boolean selectedBlock() {
        return this.isPlacing();
    }

    public boolean isPlacing() {
        return this.block != null;
    }

    public boolean isBreaking() {
        return false;
    }

    public boolean isRebuildSelecting() {
        return Core.input.keyDown(Binding.rebuildSelect);
    }

    public float mouseAngle(float x, float y) {
        return Core.input.mouseWorld(this.getMouseX(), this.getMouseY()).sub(x, y).angle();
    }

    @Nullable
    public Unit selectedUnit() {
        ControlBlock cont;
        Building build;
        Unit unit = Units.closest(Vars.player.team(), Core.input.mouseWorld().x, Core.input.mouseWorld().y, 40.0f, (Boolf<Unit>)((Boolf)u -> u.isAI() && u.playerControllable()));
        if (!((Boolean)RenderExt.unitHide.get()).booleanValue() && unit != null) {
            unit.hitbox(Tmp.r1);
            Tmp.r1.grow(6.0f);
            if (Tmp.r1.contains(Core.input.mouseWorld())) {
                return unit;
            }
        }
        if ((build = Vars.world.buildWorld(Core.input.mouseWorld().x, Core.input.mouseWorld().y)) instanceof ControlBlock && (cont = (ControlBlock)build).canControl() && build.team == Vars.player.team() && cont.unit() != Vars.player.unit() && cont.unit().isAI()) {
            return cont.unit();
        }
        return null;
    }

    @Nullable
    public Building selectedControlBuild() {
        Building build = Vars.world.buildWorld(Core.input.mouseWorld().x, Core.input.mouseWorld().y);
        if (build != null && !Vars.player.dead() && build.canControlSelect(Vars.player.unit()) && (build.team == Vars.player.team() || build instanceof CoreBlock.CoreBuild && Vars.state.rules.editor)) {
            return build;
        }
        return null;
    }

    @Nullable
    public Unit selectedCommandUnit(float x, float y) {
        QuadTree tree = Vars.player.team().data().tree();
        tmpUnits.clear();
        float rad = 4.0f;
        tree.intersect(x - rad / 2.0f, y - rad / 2.0f, rad, rad, tmpUnits);
        return (Unit)tmpUnits.min(u -> u.isCommandable(), u -> u.dst(x, y) - u.hitSize / 2.0f);
    }

    @Nullable
    public Unit selectedEnemyUnit(float x, float y) {
        tmpUnits.clear();
        float rad = 4.0f;
        Seq data = Vars.state.teams.present;
        for (int i = 0; i < data.size; ++i) {
            if (((Teams.TeamData[])data.items)[i].team == Vars.player.team()) continue;
            ((Teams.TeamData[])data.items)[i].tree().intersect(x - rad / 2.0f, y - rad / 2.0f, rad, rad, tmpUnits);
        }
        return (Unit)tmpUnits.min(u -> !u.inFogTo(Vars.player.team()), u -> u.dst(x, y) - u.hitSize / 2.0f);
    }

    public Seq<Building> selectedCommandBuildings(float x, float y, float w, float h) {
        QuadTree tree = Vars.player.team().data().buildingTree;
        tmpBuildings.clear();
        if (tree == null) {
            return tmpBuildings;
        }
        float rad = 4.0f;
        tree.intersect(Tmp.r1.set(x - rad / 2.0f, y - rad / 2.0f, rad * 2.0f + w, rad * 2.0f + h).normalize(), b -> {
            if (b.isCommandable()) {
                tmpBuildings.add(b);
            }
        });
        return tmpBuildings;
    }

    public Seq<Unit> selectedCommandUnits(float x, float y, float w, float h, Boolf<Unit> predicate) {
        QuadTree tree = Vars.player.team().data().tree();
        tmpUnits.clear();
        float rad = 4.0f;
        tree.intersect(Tmp.r1.set(x - rad / 2.0f, y - rad / 2.0f, rad * 2.0f + w, rad * 2.0f + h).normalize(), tmpUnits);
        tmpUnits.removeAll(u -> !u.isCommandable() || !predicate.get(u));
        return tmpUnits;
    }

    public Seq<Unit> selectedCommandUnits(float x, float y, float w, float h) {
        return this.selectedCommandUnits(x, y, w, h, (Boolf<Unit>)((Boolf)u -> true));
    }

    public void remove() {
        Table table2;
        Core.input.removeProcessor((InputProcessor)this);
        this.group.remove();
        if (Core.scene != null && (table2 = (Table)Core.scene.find("inputTable")) != null) {
            table2.clear();
        }
        if (this.detector != null) {
            Core.input.removeProcessor((InputProcessor)this.detector);
        }
        if (this.uiGroup != null) {
            this.uiGroup.remove();
            this.uiGroup = null;
        }
    }

    public void add() {
        Core.input.getInputProcessors().remove(i -> i instanceof InputHandler || i instanceof GestureDetector && ((GestureDetector)i).getListener() instanceof InputHandler);
        this.detector = new GestureDetector(20.0f, 0.5f, 0.3f, 0.15f, (GestureDetector.GestureListener)this);
        Core.input.addProcessor((InputProcessor)this.detector);
        Core.input.addProcessor((InputProcessor)this);
        if (Core.scene != null) {
            Table table2 = (Table)Core.scene.find("inputTable");
            if (table2 != null) {
                table2.clear();
                this.buildPlacementUI(table2);
            }
            this.uiGroup = new WidgetGroup();
            this.uiGroup.touchable = Touchable.childrenOnly;
            this.uiGroup.setFillParent(true);
            Vars.ui.hudGroup.addChild((Element)this.uiGroup);
            this.uiGroup.toBack();
            this.buildUI(this.uiGroup);
            this.group.setFillParent(true);
            Vars.ui.hudGroup.addChildBefore(Core.scene.find("overlaymarker"), (Element)this.group);
            this.inv.build((Group)this.group);
            this.config.build((Group)this.group);
            this.planConfig.build((Group)this.group);
        }
    }

    public boolean canShoot() {
        if (Vars.player.dead()) {
            return false;
        }
        if (Core.settings.getBool("playerNeedShooting")) {
            return this.block == null && !this.onConfigurable() && !this.isDroppingItem() && !this.commandMode;
        }
        return this.block == null && !this.onConfigurable() && !this.isDroppingItem() && !Vars.player.unit().activelyBuilding() && (!(Vars.player.unit() instanceof Mechc) || !Vars.player.unit().isFlying()) && !Vars.player.unit().mining() && !this.commandMode;
    }

    public boolean onConfigurable() {
        return false;
    }

    public boolean isDroppingItem() {
        return this.droppingItem;
    }

    public boolean canDropItem() {
        return this.droppingItem && !this.canTapPlayer(Core.input.mouseWorldX(), Core.input.mouseWorldY());
    }

    public void tryDropItems(@Nullable Building build, float x, float y) {
        if (Vars.player.dead()) {
            return;
        }
        if (!this.droppingItem || Vars.player.unit().stack.amount <= 0 || this.canTapPlayer(x, y) || Vars.state.isPaused()) {
            this.droppingItem = false;
            return;
        }
        this.droppingItem = false;
        ItemStack stack = Vars.player.unit().stack;
        if (build != null && build.acceptStack(stack.item, stack.amount, Vars.player.unit()) > 0 && build.interactable(Vars.player.team()) && build.block.hasItems && Vars.player.unit().stack().amount > 0 && build.interactable(Vars.player.team())) {
            if (build.allowDeposit() && this.itemDepositCooldown <= 0.0f) {
                Call.transferInventory((Player)Vars.player, (Building)build);
                this.itemDepositCooldown = Vars.state.rules.itemDepositCooldown;
            }
        } else {
            Call.dropItem((float)Vars.player.angleTo(x, y));
        }
    }

    public void rebuildArea(int x1, int y1, int x2, int y2) {
        if (!Vars.player.isBuilder()) {
            return;
        }
        Placement.NormalizeResult result = Placement.normalizeArea((int)x1, (int)y1, (int)x2, (int)y2, (int)this.rotation, (boolean)false, (int)999999999);
        Tmp.r1.set((float)(result.x * 8), (float)(result.y * 8), (float)((result.x2 - result.x) * 8), (float)((result.y2 - result.y) * 8));
        for (Teams.BlockPlan plan : Vars.player.team().data().plans) {
            Block block = plan.block;
            if (!block.bounds(plan.x, plan.y, Tmp.r2).overlaps(Tmp.r1)) continue;
            Vars.player.unit().addBuild(new BuildPlan((int)plan.x, (int)plan.y, (int)plan.rotation, plan.block, plan.config));
        }
        intSet.clear();
        for (int x = result.x; x <= result.x2; ++x) {
            for (int y = result.y; y <= result.y2; ++y) {
                Tile tile = Vars.world.tileBuilding(x, y);
                if (tile == null || tile.build == null || !intSet.add(tile.pos())) continue;
                this.tryRepairDerelict(tile);
            }
        }
    }

    public void tryBreakBlock(int x, int y) {
        if (this.validBreak(x, y)) {
            this.breakBlock(x, y);
        }
    }

    public boolean validPlace(int x, int y, Block type, int rotation) {
        return this.validPlace(x, y, type, rotation, null);
    }

    public boolean validPlace(int x, int y, Block type, int rotation, @Nullable BuildPlan ignore) {
        return this.validPlace(x, y, type, rotation, ignore, false);
    }

    public boolean validPlace(int x, int y, Block type, int rotation, @Nullable BuildPlan ignore, boolean ignoreUnits) {
        if (Vars.player.isBuilder() && Vars.player.unit().plans.size > 0) {
            Tmp.r1.setCentered((float)(x * 8) + type.offset, (float)(y * 8) + type.offset, (float)(type.size * 8));
            this.plansOut.clear();
            this.playerPlanTree.intersect(Tmp.r1, this.plansOut);
            for (int i = 0; i < this.plansOut.size; ++i) {
                BuildPlan plan = ((BuildPlan[])this.plansOut.items)[i];
                if (plan == ignore || plan.breaking || !plan.block.bounds(plan.x, plan.y, Tmp.r1).overlaps(type.bounds(x, y, Tmp.r2)) || type.canReplace(plan.block) && Tmp.r1.equals((Object)Tmp.r2)) continue;
                return false;
            }
        }
        return ignoreUnits ? Build.validPlaceIgnoreUnits(type, Vars.player.team(), x, y, rotation, true, true) : Build.validPlace(type, Vars.player.team(), x, y, rotation);
    }

    public boolean validBreak(int x, int y) {
        return Build.validBreak(Vars.player.team(), x, y);
    }

    public void breakBlock(int x, int y) {
        if (!Vars.player.isBuilder()) {
            return;
        }
        Tile tile = Vars.world.tile(x, y);
        if (tile != null && tile.build != null) {
            tile = tile.build.tile;
        }
        Vars.player.unit().addBuild(new BuildPlan((int)tile.x, (int)tile.y));
    }

    public void drawArrow(Block block, int x, int y, int rotation) {
        this.drawArrow(block, x, y, rotation, this.validPlace(x, y, block, rotation));
    }

    public void drawArrow(Block block, int x, int y, int rotation, boolean valid) {
        float trns = block.size / 2 * 8;
        int dx = Geometry.d4((int)rotation).x;
        int dy = Geometry.d4((int)rotation).y;
        float offsetx = (float)(x * 8) + block.offset + (float)dx * trns;
        float offsety = (float)(y * 8) + block.offset + (float)dy * trns;
        Draw.color((Color)(!valid ? Pal.removeBack : Pal.accentBack));
        TextureAtlas.AtlasRegion regionArrow = Core.atlas.find("place-arrow");
        Draw.rect((TextureRegion)regionArrow, (float)offsetx, (float)(offsety - 1.0f), (float)((float)regionArrow.width * regionArrow.scl()), (float)((float)regionArrow.height * regionArrow.scl()), (float)(rotation * 90 - 90));
        Draw.color((Color)(!valid ? Pal.remove : Pal.accent));
        Draw.rect((TextureRegion)regionArrow, (float)offsetx, (float)offsety, (float)((float)regionArrow.width * regionArrow.scl()), (float)((float)regionArrow.height * regionArrow.scl()), (float)(rotation * 90 - 90));
    }

    void iterateLine(int startX, int startY, int endX, int endY, Cons<PlaceLine> cons) {
        boolean diagonal = Core.input.keyDown(Binding.diagonalPlacement);
        if (Core.settings.getBool("swapdiagonal") && Vars.mobile) {
            boolean bl = diagonal = !diagonal;
        }
        if (this.block != null && this.block.swapDiagonalPlacement) {
            diagonal = !diagonal;
        }
        int endRotation = -1;
        Building start = Vars.world.build(startX, startY);
        Building end = Vars.world.build(endX, endY);
        Seq points = diagonal && (this.block == null || this.block.allowDiagonal) ? (this.block != null && start instanceof ChainedBuilding && end instanceof ChainedBuilding && this.block.canReplace(end.block) && this.block.canReplace(start.block) ? Placement.upgradeLine((int)startX, (int)startY, (int)endX, (int)endY) : Placement.pathfindLine((this.block != null && this.block.conveyorPlacement ? 1 : 0) != 0, (int)startX, (int)startY, (int)endX, (int)endY)) : (this.block != null && this.block.allowRectanglePlacement ? Placement.normalizeRectangle((int)startX, (int)startY, (int)endX, (int)endY, (int)this.block.size) : Placement.normalizeLine((int)startX, (int)startY, (int)endX, (int)endY));
        if (points.size > 1 && end instanceof ChainedBuilding) {
            Point2 secondToLast = (Point2)points.get(points.size - 2);
            if (!(Vars.world.build(secondToLast.x, secondToLast.y) instanceof ChainedBuilding)) {
                endRotation = end.rotation;
            }
        }
        if (this.block != null) {
            this.block.changePlacementPath((Seq<Point2>)points, this.rotation, diagonal);
        }
        float angle = Angles.angle((float)startX, (float)startY, (float)endX, (float)endY);
        int baseRotation = this.rotation;
        if (!this.overrideLineRotation || diagonal) {
            baseRotation = startX == endX && startY == endY ? this.rotation : (int)((angle + 45.0f) / 90.0f) % 4;
        }
        Tmp.r3.set(-1.0f, -1.0f, 0.0f, 0.0f);
        for (int i = 0; i < points.size; ++i) {
            Point2 point = (Point2)points.get(i);
            if (this.block != null && Tmp.r2.setSize((float)(this.block.size * 8)).setCenter((float)(point.x * 8) + this.block.offset, (float)(point.y * 8) + this.block.offset).overlaps(Tmp.r3)) continue;
            Point2 next = i == points.size - 1 ? null : (Point2)points.get(i + 1);
            this.line.x = point.x;
            this.line.y = point.y;
            if (!(this.overrideLineRotation && !diagonal || this.block != null && this.block.ignoreLineRotation)) {
                int result = baseRotation;
                if (next != null) {
                    result = Tile.relativeTo((int)point.x, (int)point.y, (int)next.x, (int)next.y);
                } else if (endRotation != -1) {
                    result = endRotation;
                } else if (this.block.conveyorPlacement && i > 0) {
                    Point2 prev = (Point2)points.get(i - 1);
                    result = Tile.relativeTo((int)prev.x, (int)prev.y, (int)point.x, (int)point.y);
                }
                if (result != -1) {
                    this.line.rotation = result;
                }
            } else {
                this.line.rotation = this.rotation;
            }
            this.line.last = next == null;
            cons.get((Object)this.line);
            Tmp.r3.setSize((float)(this.block.size * 8)).setCenter((float)(point.x * 8) + this.block.offset, (float)(point.y * 8) + this.block.offset);
        }
    }

    static class PlaceLine {
        public int x;
        public int y;
        public int rotation;
        public boolean last;

        PlaceLine() {
        }
    }
}

