/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.Shader;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Tmp;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.graphics.Shaders;

public class LightRenderer {
    private static final int scaling = 4;
    private final FrameBuffer buffer = new FrameBuffer();
    private final Seq<Runnable> lights = new Seq(Runnable.class);
    private final Seq<CircleLight> circles = new Seq(CircleLight.class);
    private int circleIndex = 0;
    private TextureRegion circleRegion;

    public void add(Runnable run) {
        if (!this.enabled()) {
            return;
        }
        this.lights.add((Object)run);
    }

    public void add(float x, float y, float radius, Color color, float opacity) {
        if (!this.enabled() || radius <= 0.0f) {
            return;
        }
        float res = Color.toFloatBits((float)color.r, (float)color.g, (float)color.b, (float)opacity);
        if (this.circles.size <= this.circleIndex) {
            this.circles.add((Object)new CircleLight());
        }
        CircleLight light = ((CircleLight[])this.circles.items)[this.circleIndex];
        light.set(x, y, res, radius);
        ++this.circleIndex;
    }

    public void add(float x, float y, TextureRegion region, Color color, float opacity) {
        this.add(x, y, region, 0.0f, color, opacity);
    }

    public void add(float x, float y, TextureRegion region, float rotation, Color color, float opacity) {
        if (!this.enabled()) {
            return;
        }
        float res = Tmp.c1.set(color).a(opacity).toFloatBits();
        float xscl = Draw.xscl;
        float yscl = Draw.yscl;
        this.add(((RegionData)RegionData.pool.obtain()).set(res, xscl, yscl, region, x, y, rotation));
    }

    public void line(float x, float y, float x2, float y2, float stroke, Color tint, float alpha) {
        if (!this.enabled()) {
            return;
        }
        float res = Tmp.c1.set(tint).a(alpha).toFloatBits();
        this.add(((LineData)LineData.pool.obtain()).set(res, x2, x, y2, y, stroke));
    }

    public boolean enabled() {
        return Vars.state.rules.lighting && Vars.state.rules.ambientLight.a > 1.0E-4f && Vars.renderer.drawLight;
    }

    public void draw() {
        if (!Vars.enableLight) {
            Pools.freeAll(this.lights);
            this.lights.clear();
            this.circleIndex = 0;
            return;
        }
        if (this.circleRegion == null) {
            this.circleRegion = Core.atlas.find("circle-shadow");
        }
        this.buffer.resize(Core.graphics.getWidth() / 4, Core.graphics.getHeight() / 4);
        Draw.color();
        this.buffer.begin(Color.clear);
        Draw.sort((boolean)false);
        Gl.blendEquationSeparate((int)32774, (int)32776);
        Blending.normal.apply();
        for (Runnable run : this.lights) {
            run.run();
        }
        for (int i = 0; i < this.circleIndex; ++i) {
            CircleLight cir = ((CircleLight[])this.circles.items)[i];
            Draw.color((float)cir.color);
            Draw.rect((TextureRegion)this.circleRegion, (float)cir.x, (float)cir.y, (float)(cir.radius * 2.0f), (float)(cir.radius * 2.0f));
        }
        Draw.reset();
        Draw.sort((boolean)true);
        this.buffer.end();
        Gl.blendEquationSeparate((int)32774, (int)32774);
        Draw.color();
        Shaders.light.ambient.set(Vars.state.rules.ambientLight);
        this.buffer.blit((Shader)Shaders.light);
        for (Runnable o : (Runnable[])this.lights.items) {
            if (o instanceof LineData) {
                LineData.pool.free((Object)((LineData)o));
                continue;
            }
            if (!(o instanceof RegionData)) continue;
            RegionData.pool.free((Object)((RegionData)o));
        }
        this.lights.clear();
        this.circleIndex = 0;
    }

    static class CircleLight {
        float x;
        float y;
        float color;
        float radius;

        CircleLight() {
        }

        public void set(float x, float y, float color, float radius) {
            this.x = x;
            this.y = y;
            this.color = color;
            this.radius = radius;
        }
    }

    private static class RegionData
    implements Runnable,
    Pool.Poolable {
        static Pool<RegionData> pool = Pools.get(RegionData.class, RegionData::new);
        private float res;
        private float xscl;
        private float yscl;
        private TextureRegion region;
        private float x;
        private float y;
        private float rotation;

        private RegionData() {
        }

        public void reset() {
            this.region = null;
        }

        public RegionData set(float res, float xscl, float yscl, TextureRegion region, float x, float y, float rotation) {
            this.res = res;
            this.xscl = xscl;
            this.yscl = yscl;
            this.region = region;
            this.x = x;
            this.y = y;
            this.rotation = rotation;
            return this;
        }

        @Override
        public void run() {
            Draw.color((float)this.res);
            Draw.scl((float)this.xscl, (float)this.yscl);
            Draw.rect((TextureRegion)this.region, (float)this.x, (float)this.y, (float)this.rotation);
            Draw.scl();
        }
    }

    private static class LineData
    implements Runnable,
    Pool.Poolable {
        static Pool<LineData> pool = Pools.get(LineData.class, LineData::new);
        private static final float[] vertices = new float[24];
        private static TextureRegion ledge;
        private static TextureRegion lmid;
        private float tint;
        private float x2;
        private float x;
        private float y2;
        private float y;
        private float stroke;

        private LineData() {
        }

        public void reset() {
        }

        public LineData set(float tint, float x2, float x, float y2, float y, float stroke) {
            this.tint = tint;
            this.x2 = x2;
            this.x = x;
            this.y2 = y2;
            this.y = y;
            this.stroke = stroke;
            return this;
        }

        @Override
        public void run() {
            Draw.color((float)this.tint);
            float rot = Mathf.angleExact((float)(this.x2 - this.x), (float)(this.y2 - this.y));
            if (ledge == null) {
                ledge = Core.atlas.find("circle-end");
                lmid = Core.atlas.find("circle-mid");
            }
            float color = Draw.getColorPacked();
            float u = LineData.lmid.u;
            float v = LineData.lmid.v2;
            float u2 = LineData.lmid.u2;
            float v2 = LineData.lmid.v;
            Vec2 v1 = Tmp.v1.trnsExact(rot + 90.0f, this.stroke);
            float lx1 = this.x - v1.x;
            float ly1 = this.y - v1.y;
            float lx2 = this.x + v1.x;
            float ly2 = this.y + v1.y;
            float lx3 = this.x2 + v1.x;
            float ly3 = this.y2 + v1.y;
            float lx4 = this.x2 - v1.x;
            float ly4 = this.y2 - v1.y;
            LineData.vertices[0] = lx1;
            LineData.vertices[1] = ly1;
            LineData.vertices[2] = color;
            LineData.vertices[3] = u;
            LineData.vertices[4] = v;
            LineData.vertices[5] = 0.0f;
            LineData.vertices[6] = lx2;
            LineData.vertices[7] = ly2;
            LineData.vertices[8] = color;
            LineData.vertices[9] = u;
            LineData.vertices[10] = v2;
            LineData.vertices[11] = 0.0f;
            LineData.vertices[12] = lx3;
            LineData.vertices[13] = ly3;
            LineData.vertices[14] = color;
            LineData.vertices[15] = u2;
            LineData.vertices[16] = v2;
            LineData.vertices[17] = 0.0f;
            LineData.vertices[18] = lx4;
            LineData.vertices[19] = ly4;
            LineData.vertices[20] = color;
            LineData.vertices[21] = u2;
            LineData.vertices[22] = v;
            LineData.vertices[23] = 0.0f;
            Draw.vert((Texture)LineData.ledge.texture, (float[])vertices, (int)0, (int)vertices.length);
            Vec2 v3 = Tmp.v2.trnsExact(rot, this.stroke);
            u = LineData.ledge.u;
            v = LineData.ledge.v2;
            u2 = LineData.ledge.u2;
            v2 = LineData.ledge.v;
            LineData.vertices[0] = lx4;
            LineData.vertices[1] = ly4;
            LineData.vertices[2] = color;
            LineData.vertices[3] = u;
            LineData.vertices[4] = v;
            LineData.vertices[5] = 0.0f;
            LineData.vertices[6] = lx3;
            LineData.vertices[7] = ly3;
            LineData.vertices[8] = color;
            LineData.vertices[9] = u;
            LineData.vertices[10] = v2;
            LineData.vertices[11] = 0.0f;
            LineData.vertices[12] = lx3 + v3.x;
            LineData.vertices[13] = ly3 + v3.y;
            LineData.vertices[14] = color;
            LineData.vertices[15] = u2;
            LineData.vertices[16] = v2;
            LineData.vertices[17] = 0.0f;
            LineData.vertices[18] = lx4 + v3.x;
            LineData.vertices[19] = ly4 + v3.y;
            LineData.vertices[20] = color;
            LineData.vertices[21] = u2;
            LineData.vertices[22] = v;
            LineData.vertices[23] = 0.0f;
            Draw.vert((Texture)LineData.ledge.texture, (float[])vertices, (int)0, (int)vertices.length);
            LineData.vertices[0] = lx2;
            LineData.vertices[1] = ly2;
            LineData.vertices[2] = color;
            LineData.vertices[3] = u;
            LineData.vertices[4] = v;
            LineData.vertices[5] = 0.0f;
            LineData.vertices[6] = lx1;
            LineData.vertices[7] = ly1;
            LineData.vertices[8] = color;
            LineData.vertices[9] = u;
            LineData.vertices[10] = v2;
            LineData.vertices[11] = 0.0f;
            LineData.vertices[12] = lx1 - v3.x;
            LineData.vertices[13] = ly1 - v3.y;
            LineData.vertices[14] = color;
            LineData.vertices[15] = u2;
            LineData.vertices[16] = v2;
            LineData.vertices[17] = 0.0f;
            LineData.vertices[18] = lx2 - v3.x;
            LineData.vertices[19] = ly2 - v3.y;
            LineData.vertices[20] = color;
            LineData.vertices[21] = u2;
            LineData.vertices[22] = v;
            LineData.vertices[23] = 0.0f;
            Draw.vert((Texture)LineData.ledge.texture, (float[])vertices, (int)0, (int)vertices.length);
        }
    }
}

