/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.scene.ui.layout.Scl;
import arc.util.Align;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pools;
import java.nio.FloatBuffer;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.World;
import mindustry.entities.EntityGroup;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.IndexableEntity__all;
import mindustry.gen.IndexableEntity__draw;
import mindustry.gen.IndexableEntity__label;
import mindustry.gen.IndexableEntity__sync;
import mindustry.gen.Player;
import mindustry.gen.Posc;
import mindustry.gen.Syncc;
import mindustry.gen.Unitc;
import mindustry.gen.WorldLabelc;
import mindustry.graphics.Drawf;
import mindustry.io.TypeIO;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

public class WorldLabel
implements Drawc,
Entityc,
IndexableEntity__all,
IndexableEntity__draw,
IndexableEntity__label,
IndexableEntity__sync,
Posc,
Syncc,
WorldLabelc {
    public static final byte flagAlignLeft = 4;
    public static final byte flagAlignRight = 8;
    public static final byte flagAutoscale = 16;
    public static final byte flagBackground = 1;
    public static final byte flagOutline = 2;
    protected transient boolean added;
    public byte flags = (byte)3;
    public float fontSize = 1.0f;
    public transient int id = EntityGroup.nextId();
    protected transient int index__all = -1;
    protected transient int index__draw = -1;
    protected transient int index__label = -1;
    protected transient int index__sync = -1;
    public transient long lastUpdated;
    public String text = "sample text";
    public transient long updateSpacing;
    public float x;
    private transient float x_LAST_;
    private transient float x_TARGET_;
    public float y;
    private transient float y_LAST_;
    private transient float y_TARGET_;
    public float z = 151.0f;

    protected WorldLabel() {
    }

    @Nullable
    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Nullable
    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public int classId() {
        return 35;
    }

    public int id() {
        return this.id;
    }

    public String toString() {
        return "WorldLabel#" + this.id;
    }

    public long lastUpdated() {
        return this.lastUpdated;
    }

    public long updateSpacing() {
        return this.updateSpacing;
    }

    public void id(int id) {
        this.id = id;
    }

    public void lastUpdated(long lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void setIndex__all(int index) {
        this.index__all = index;
    }

    public void setIndex__draw(int index) {
        this.index__draw = index;
    }

    public void setIndex__label(int index) {
        this.index__label = index;
    }

    public void setIndex__sync(int index) {
        this.index__sync = index;
    }

    public void updateSpacing(long updateSpacing) {
        this.updateSpacing = updateSpacing;
    }

    public void x(float x) {
        this.x = x;
    }

    public void y(float y) {
        this.y = y;
    }

    public void read(Reads read) {
        short REV = read.s();
        if (REV != 0) {
            throw new IllegalArgumentException("Unknown revision '" + REV + "' for entity type 'WorldLabelComp'");
        }
        this.flags = read.b();
        this.fontSize = read.f();
        this.text = TypeIO.readString(read);
        this.x = read.f();
        this.y = read.f();
        this.z = read.f();
        this.afterRead();
    }

    public void write(Writes write) {
        write.s(0);
        write.b((int)this.flags);
        write.f(this.fontSize);
        TypeIO.writeString(write, this.text);
        write.f(this.x);
        write.f(this.y);
        write.f(this.z);
    }

    public <T extends Entityc> T self() {
        return (T)this;
    }

    public <T> T as() {
        return (T)this;
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isLocal() {
        Unitc u;
        WorldLabel worldLabel;
        return this == Vars.player || (worldLabel = this) instanceof Unitc && (u = (Unitc)worldLabel).controller() == Vars.player;
    }

    public boolean isRemote() {
        Unitc u;
        WorldLabel worldLabel = this;
        return worldLabel instanceof Unitc && (u = (Unitc)worldLabel).isPlayer() && !this.isLocal();
    }

    public boolean isSyncHidden(Player player) {
        return false;
    }

    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    public boolean serialize() {
        return false;
    }

    public float clipSize() {
        return (float)this.text.length() * 10.0f * this.fontSize;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int tileX() {
        return World.toTile(this.x);
    }

    public int tileY() {
        return World.toTile(this.y);
    }

    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public static WorldLabel create() {
        return new WorldLabel();
    }

    public static void drawAt(String text, float x, float y, float layer, int flags, float fontSize, int align, int lineAlign) {
        boolean border;
        Draw.z((float)layer);
        float z = Drawf.text();
        Font font = (flags & 2) != 0 ? Fonts.outline : Fonts.def;
        GlyphLayout layout = (GlyphLayout)Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        boolean ints = font.usesIntegerPositions();
        font.setUseIntegerPositions(false);
        font.getData().setScale(0.25f * fontSize / Scl.scl((float)1.0f) / ((flags & 0x10) != 0 ? 0.2f * Vars.renderer.camerascale + 0.05f : 1.0f));
        layout.setText(font, (CharSequence)text);
        boolean bl = border = (flags & 1) != 0;
        y = Align.isBottom((int)align) ? (y += layout.height + (float)border * 1.5f) : (Align.isTop((int)align) ? (y -= (float)border * 1.5f) : (y += layout.height / 2.0f));
        if (Align.isLeft((int)align)) {
            x += layout.width / 2.0f + (float)border;
        } else if (Align.isRight((int)align)) {
            x -= layout.width / 2.0f + (float)border;
        }
        if ((flags & 1) != 0) {
            Draw.color((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3f);
            Fill.rect((float)x, (float)(y - layout.height / 2.0f), (float)(layout.width + 2.0f), (float)(layout.height + 3.0f));
            Draw.color();
        }
        float tx = Align.isLeft((int)lineAlign) ? -layout.width * 0.5f : (Align.isRight((int)lineAlign) ? layout.width * 0.5f : 0.0f);
        font.setColor(Color.white);
        font.draw((CharSequence)text, x + tx, y, 0.0f, lineAlign, false);
        Draw.reset();
        Pools.free((Object)layout);
        font.getData().setScale(1.0f);
        font.setColor(Color.white);
        font.setUseIntegerPositions(ints);
        Draw.z((float)z);
    }

    public void add() {
        if (this.added) {
            return;
        }
        this.index__all = Groups.all.addIndex(this);
        this.index__sync = Groups.sync.addIndex(this);
        this.index__draw = Groups.draw.addIndex(this);
        this.index__label = Groups.label.addIndex(this);
        this.added = true;
    }

    public void afterRead() {
    }

    public void afterReadAll() {
    }

    public void afterSync() {
    }

    public void beforeWrite() {
    }

    public void draw() {
        WorldLabel.drawAt(this.text, this.x, this.y, this.z, this.flags, this.fontSize, 1, (this.flags & 4) != 0 ? 8 : ((this.flags & 8) != 0 ? 16 : 1));
    }

    public void handleSyncHidden() {
    }

    public void hide() {
        this.remove();
        Call.removeWorldLabel((int)this.id);
    }

    public void interpolate() {
        if (this.lastUpdated != 0L && this.updateSpacing != 0L) {
            float timeSinceUpdate = Time.timeSinceMillis((long)this.lastUpdated);
            float alpha = Math.min(timeSinceUpdate / (float)this.updateSpacing, 2.0f);
            this.x = Mathf.lerp((float)this.x_LAST_, (float)this.x_TARGET_, (float)alpha);
            this.y = Mathf.lerp((float)this.y_LAST_, (float)this.y_TARGET_, (float)alpha);
        } else if (this.lastUpdated != 0L) {
            this.x = this.x_TARGET_;
            this.y = this.y_TARGET_;
        }
    }

    public void readSync(Reads read) {
        if (this.lastUpdated != 0L) {
            this.updateSpacing = Time.timeSinceMillis((long)this.lastUpdated);
        }
        this.lastUpdated = Time.millis();
        boolean islocal = this.isLocal();
        this.flags = read.b();
        this.fontSize = read.f();
        this.text = TypeIO.readString(read);
        if (!islocal) {
            this.x_LAST_ = this.x;
            this.x_TARGET_ = read.f();
        } else {
            read.f();
            this.x_LAST_ = this.x;
            this.x_TARGET_ = this.x;
        }
        if (!islocal) {
            this.y_LAST_ = this.y;
            this.y_TARGET_ = read.f();
        } else {
            read.f();
            this.y_LAST_ = this.y;
            this.y_TARGET_ = this.y;
        }
        this.z = read.f();
        this.afterSync();
    }

    public void readSyncManual(FloatBuffer buffer) {
        if (this.lastUpdated != 0L) {
            this.updateSpacing = Time.timeSinceMillis((long)this.lastUpdated);
        }
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x;
        this.x_TARGET_ = buffer.get();
        this.y_LAST_ = this.y;
        this.y_TARGET_ = buffer.get();
    }

    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.removeIndex(this, this.index__all);
        this.index__all = -1;
        Groups.sync.removeIndex(this, this.index__sync);
        this.index__sync = -1;
        Groups.draw.removeIndex(this, this.index__draw);
        this.index__draw = -1;
        Groups.label.removeIndex(this, this.index__label);
        this.index__label = -1;
        this.added = false;
        if (Vars.net.client()) {
            Vars.netClient.addRemovedEntity(this.id());
        }
    }

    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void snapInterpolation() {
        this.updateSpacing = 16L;
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x;
        this.x_TARGET_ = this.x;
        this.y_LAST_ = this.y;
        this.y_TARGET_ = this.y;
    }

    public void snapSync() {
        this.updateSpacing = 16L;
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x_TARGET_;
        this.x = this.x_TARGET_;
        this.y_LAST_ = this.y_TARGET_;
        this.y = this.y_TARGET_;
    }

    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    public void update() {
        if (Vars.net.client() && !this.isLocal() || this.isRemote()) {
            this.interpolate();
        }
    }

    public void writeSync(Writes write) {
        write.b((int)this.flags);
        write.f(this.fontSize);
        TypeIO.writeString(write, this.text);
        write.f(this.x);
        write.f(this.y);
        write.f(this.z);
    }

    public void writeSyncManual(FloatBuffer buffer) {
        buffer.put(this.x);
        buffer.put(this.y);
    }
}

