/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.func.Cons;
import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import java.nio.FloatBuffer;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.ctype.ContentType;
import mindustry.entities.EntityGroup;
import mindustry.entities.Fires;
import mindustry.entities.Puddles;
import mindustry.entities.Units;
import mindustry.gen.Building;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.IndexableEntity__all;
import mindustry.gen.IndexableEntity__draw;
import mindustry.gen.IndexableEntity__puddle;
import mindustry.gen.IndexableEntity__sync;
import mindustry.gen.Player;
import mindustry.gen.Posc;
import mindustry.gen.Puddlec;
import mindustry.gen.Syncc;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.io.TypeIO;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

public class Puddle
implements Pool.Poolable,
Drawc,
Entityc,
IndexableEntity__all,
IndexableEntity__draw,
IndexableEntity__puddle,
IndexableEntity__sync,
Posc,
Puddlec,
Syncc {
    protected static Puddle paramPuddle;
    protected static final Rect rect;
    protected static final Rect rect2;
    protected static Cons<Unit> unitCons;
    public transient float accepting;
    protected transient boolean added;
    public float amount;
    public transient float effectTime = Mathf.random((float)50.0f);
    public transient int id = EntityGroup.nextId();
    protected transient int index__all = -1;
    protected transient int index__draw = -1;
    protected transient int index__puddle = -1;
    protected transient int index__sync = -1;
    public transient float lastRipple = Time.time + Mathf.random((float)40.0f);
    public transient long lastUpdated;
    public Liquid liquid;
    public Tile tile;
    public transient long updateSpacing;
    public transient float updateTime;
    public float x;
    private transient float x_LAST_;
    private transient float x_TARGET_;
    public float y;
    private transient float y_LAST_;
    private transient float y_TARGET_;

    protected Puddle() {
    }

    @Nullable
    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Nullable
    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public int classId() {
        return 13;
    }

    public int id() {
        return this.id;
    }

    public String toString() {
        return "Puddle#" + this.id;
    }

    public long lastUpdated() {
        return this.lastUpdated;
    }

    public long updateSpacing() {
        return this.updateSpacing;
    }

    public void id(int id) {
        this.id = id;
    }

    public void lastUpdated(long lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void setIndex__all(int index) {
        this.index__all = index;
    }

    public void setIndex__draw(int index) {
        this.index__draw = index;
    }

    public void setIndex__puddle(int index) {
        this.index__puddle = index;
    }

    public void setIndex__sync(int index) {
        this.index__sync = index;
    }

    public void updateSpacing(long updateSpacing) {
        this.updateSpacing = updateSpacing;
    }

    public void x(float x) {
        this.x = x;
    }

    public void y(float y) {
        this.y = y;
    }

    public void read(Reads read) {
        short REV = read.s();
        if (REV == 0) {
            this.amount = read.f();
            read.i();
            this.liquid = (Liquid)((Object)Vars.content.getByID(ContentType.liquid, read.s()));
            this.tile = TypeIO.readTile(read);
            this.x = read.f();
            this.y = read.f();
        } else if (REV == 1) {
            this.amount = read.f();
            this.liquid = (Liquid)((Object)Vars.content.getByID(ContentType.liquid, read.s()));
            this.tile = TypeIO.readTile(read);
            this.x = read.f();
            this.y = read.f();
        } else {
            throw new IllegalArgumentException("Unknown revision '" + REV + "' for entity type 'PuddleComp'");
        }
        this.afterRead();
    }

    public void write(Writes write) {
        write.s(1);
        write.f(this.amount);
        write.s((int)this.liquid.id);
        TypeIO.writeTile(write, this.tile);
        write.f(this.x);
        write.f(this.y);
    }

    public <T extends Entityc> T self() {
        return (T)this;
    }

    public <T> T as() {
        return (T)this;
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isLocal() {
        Unitc u;
        Puddle puddle;
        return this == Vars.player || (puddle = this) instanceof Unitc && (u = (Unitc)puddle).controller() == Vars.player;
    }

    public boolean isRemote() {
        Unitc u;
        Puddle puddle = this;
        return puddle instanceof Unitc && (u = (Unitc)puddle).isPlayer() && !this.isLocal();
    }

    public boolean isSyncHidden(Player player) {
        return false;
    }

    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    public boolean serialize() {
        return true;
    }

    public float clipSize() {
        return 50.0f;
    }

    public float getFlammability() {
        return this.liquid.flammability * this.amount;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int tileX() {
        return World.toTile(this.x);
    }

    public int tileY() {
        return World.toTile(this.y);
    }

    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public static Puddle create() {
        return (Puddle)Pools.obtain(Puddle.class, Puddle::new);
    }

    public void add() {
        if (this.added) {
            return;
        }
        this.index__all = Groups.all.addIndex(this);
        this.index__sync = Groups.sync.addIndex(this);
        this.index__draw = Groups.draw.addIndex(this);
        this.index__puddle = Groups.puddle.addIndex(this);
        this.added = true;
    }

    public void afterRead() {
        Puddles.register((Puddle)this);
    }

    public void afterReadAll() {
    }

    public void afterSync() {
        if (this.liquid != null) {
            Puddles.register((Puddle)this);
        }
    }

    public void beforeWrite() {
    }

    public void draw() {
        Draw.z((float)19.0f);
        this.liquid.drawPuddle(this);
    }

    public void handleSyncHidden() {
    }

    public void interpolate() {
        if (this.lastUpdated != 0L && this.updateSpacing != 0L) {
            float timeSinceUpdate = Time.timeSinceMillis((long)this.lastUpdated);
            float alpha = Math.min(timeSinceUpdate / (float)this.updateSpacing, 2.0f);
            this.x = Mathf.lerp((float)this.x_LAST_, (float)this.x_TARGET_, (float)alpha);
            this.y = Mathf.lerp((float)this.y_LAST_, (float)this.y_TARGET_, (float)alpha);
        } else if (this.lastUpdated != 0L) {
            this.x = this.x_TARGET_;
            this.y = this.y_TARGET_;
        }
    }

    public void readSync(Reads read) {
        if (this.lastUpdated != 0L) {
            this.updateSpacing = Time.timeSinceMillis((long)this.lastUpdated);
        }
        this.lastUpdated = Time.millis();
        boolean islocal = this.isLocal();
        this.amount = read.f();
        this.liquid = (Liquid)((Object)Vars.content.getByID(ContentType.liquid, read.s()));
        this.tile = TypeIO.readTile(read);
        if (!islocal) {
            this.x_LAST_ = this.x;
            this.x_TARGET_ = read.f();
        } else {
            read.f();
            this.x_LAST_ = this.x;
            this.x_TARGET_ = this.x;
        }
        if (!islocal) {
            this.y_LAST_ = this.y;
            this.y_TARGET_ = read.f();
        } else {
            read.f();
            this.y_LAST_ = this.y;
            this.y_TARGET_ = this.y;
        }
        this.afterSync();
    }

    public void readSyncManual(FloatBuffer buffer) {
        if (this.lastUpdated != 0L) {
            this.updateSpacing = Time.timeSinceMillis((long)this.lastUpdated);
        }
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x;
        this.x_TARGET_ = buffer.get();
        this.y_LAST_ = this.y;
        this.y_TARGET_ = buffer.get();
    }

    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.removeIndex(this, this.index__all);
        this.index__all = -1;
        Groups.sync.removeIndex(this, this.index__sync);
        this.index__sync = -1;
        Groups.draw.removeIndex(this, this.index__draw);
        this.index__draw = -1;
        Groups.puddle.removeIndex(this, this.index__puddle);
        this.index__puddle = -1;
        this.added = false;
        Puddles.remove((Tile)this.tile);
        if (Vars.net.client()) {
            Vars.netClient.addRemovedEntity(this.id());
        }
        Groups.queueFree((Pool.Poolable)this);
    }

    public void reset() {
        this.accepting = 0.0f;
        this.added = false;
        this.amount = 0.0f;
        this.effectTime = Mathf.random((float)50.0f);
        this.id = EntityGroup.nextId();
        this.lastRipple = Time.time + Mathf.random((float)40.0f);
        this.lastUpdated = 0L;
        this.liquid = null;
        this.tile = null;
        this.updateSpacing = 0L;
        this.updateTime = 0.0f;
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void snapInterpolation() {
        this.updateSpacing = 16L;
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x;
        this.x_TARGET_ = this.x;
        this.y_LAST_ = this.y;
        this.y_TARGET_ = this.y;
    }

    public void snapSync() {
        this.updateSpacing = 16L;
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x_TARGET_;
        this.x = this.x_TARGET_;
        this.y_LAST_ = this.y_TARGET_;
        this.y = this.y_TARGET_;
    }

    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    public void update() {
        if (this.liquid == null || this.tile == null) {
            this.remove();
        } else {
            float addSpeed = this.accepting > 0.0f ? 3.0f : 0.0f;
            this.amount -= Time.delta * (1.0f - this.liquid.viscosity) / (5.0f + addSpeed);
            this.amount += this.accepting;
            this.amount = Math.min(this.amount, 70.0f);
            this.accepting = 0.0f;
            if (this.amount >= 46.666668f) {
                float deposited = Math.min((this.amount - 46.666668f) / 4.0f, 0.3f * Time.delta);
                int targets = 0;
                for (Point2 point : Geometry.d4) {
                    Tile other = Vars.world.tile(this.tile.x + point.x, this.tile.y + point.y);
                    if (other == null || other.block() != Blocks.air && !this.liquid.moveThroughBlocks) continue;
                    ++targets;
                    Puddles.deposit((Tile)other, (Tile)this.tile, (Liquid)this.liquid, (float)deposited, (boolean)false);
                }
                this.amount -= deposited * (float)targets;
            }
            if (this.liquid.capPuddles) {
                this.amount = Mathf.clamp((float)this.amount, (float)0.0f, (float)70.0f);
            }
            if (this.amount <= 0.0f) {
                this.remove();
            } else if (Puddles.get((Tile)this.tile) != this && this.added) {
                Groups.all.remove(this);
                Groups.draw.remove(this);
                Groups.puddle.remove(this);
                this.added = false;
            } else {
                if (this.amount >= 35.0f && this.updateTime <= 0.0f) {
                    paramPuddle = this;
                    Units.nearby(rect.setSize(Mathf.clamp((float)(this.amount / 46.666668f)) * 10.0f).setCenter(this.x, this.y), unitCons);
                    if (this.liquid.temperature > 0.7f && this.tile.build != null && Mathf.chance((double)0.5)) {
                        Fires.create((Tile)this.tile);
                    }
                    this.updateTime = 40.0f;
                    if (this.tile.build != null) {
                        this.tile.build.puddleOn(this);
                    }
                }
                if (!Vars.headless && this.liquid.particleEffect != Fx.none) {
                    float f;
                    this.effectTime += Time.delta;
                    if (f >= this.liquid.particleSpacing) {
                        float size = Mathf.clamp((float)(this.amount / 46.666668f)) * 4.0f;
                        this.liquid.particleEffect.at(this.x + Mathf.range((float)size), this.y + Mathf.range((float)size));
                        this.effectTime = 0.0f;
                    }
                }
                this.updateTime -= Time.delta;
                this.liquid.update(this);
            }
        }
        if (Vars.net.client() && !this.isLocal() || this.isRemote()) {
            this.interpolate();
        }
    }

    public void writeSync(Writes write) {
        write.f(this.amount);
        write.s((int)this.liquid.id);
        TypeIO.writeTile(write, this.tile);
        write.f(this.x);
        write.f(this.y);
    }

    public void writeSyncManual(FloatBuffer buffer) {
        buffer.put(this.x);
        buffer.put(this.y);
    }

    static {
        rect = new Rect();
        rect2 = new Rect();
        unitCons = unit -> {
            if (unit.isGrounded() && !unit.type.hovering) {
                unit.hitbox(rect2);
                if (rect.overlaps(rect2)) {
                    unit.apply(Puddle.paramPuddle.liquid.effect, 120.0f);
                    if (unit.vel.len2() > 0.010000001f) {
                        Fx.ripple.at(unit.x, unit.y, unit.type.rippleScale, Puddle.paramPuddle.liquid.color);
                    }
                }
            }
        };
    }
}

