/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.entities.EntityGroup;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.IndexableEntity__all;
import mindustry.gen.IndexableEntity__draw;
import mindustry.gen.LaunchPayloadc;
import mindustry.gen.Posc;
import mindustry.gen.Teamc;
import mindustry.gen.Timedc;
import mindustry.gen.Unitc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.io.TypeIO;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.type.Sector;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.campaign.LaunchPad;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.storage.CoreBlock;

public class LaunchPayload
implements Drawc,
Entityc,
IndexableEntity__all,
IndexableEntity__draw,
LaunchPayloadc,
Posc,
Teamc,
Timedc {
    protected transient boolean added;
    public transient int id = EntityGroup.nextId();
    public transient Interval in = new Interval();
    protected transient int index__all = -1;
    protected transient int index__draw = -1;
    public float lifetime;
    public Seq<ItemStack> stacks = new Seq();
    public Team team = Team.derelict;
    public float time;
    public float x;
    public float y;

    protected LaunchPayload() {
    }

    @Nullable
    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Nullable
    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    @Nullable
    public CoreBlock.CoreBuild closestCore() {
        return Vars.state.teams.closestCore(this.x, this.y, this.team);
    }

    @Nullable
    public CoreBlock.CoreBuild closestEnemyCore() {
        return Vars.state.teams.closestEnemyCore(this.x, this.y, this.team);
    }

    @Nullable
    public CoreBlock.CoreBuild core() {
        return this.team.core();
    }

    public Seq<ItemStack> stacks() {
        return this.stacks;
    }

    public Interval in() {
        return this.in;
    }

    public float lifetime() {
        return this.lifetime;
    }

    public float time() {
        return this.time;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public int classId() {
        return 15;
    }

    public int id() {
        return this.id;
    }

    public String toString() {
        return "LaunchPayload#" + this.id;
    }

    public Team team() {
        return this.team;
    }

    public void id(int id) {
        this.id = id;
    }

    public void in(Interval in) {
        this.in = in;
    }

    public void lifetime(float lifetime) {
        this.lifetime = lifetime;
    }

    public void setIndex__all(int index) {
        this.index__all = index;
    }

    public void setIndex__draw(int index) {
        this.index__draw = index;
    }

    public void stacks(Seq<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public void team(Team team) {
        this.team = team;
    }

    public void time(float time) {
        this.time = time;
    }

    public void x(float x) {
        this.x = x;
    }

    public void y(float y) {
        this.y = y;
    }

    public void read(Reads read) {
        short REV = read.s();
        if (REV == 0) {
            this.lifetime = read.f();
            int stacks_LENGTH = read.i();
            this.stacks.clear();
            for (int INDEX = 0; INDEX < stacks_LENGTH; ++INDEX) {
                ItemStack stacks_ITEM = TypeIO.readItems(read);
                if (stacks_ITEM == null) continue;
                this.stacks.add((Object)stacks_ITEM);
            }
        } else {
            throw new IllegalArgumentException("Unknown revision '" + REV + "' for entity type 'LaunchPayloadComp'");
        }
        this.team = TypeIO.readTeam(read);
        this.time = read.f();
        this.x = read.f();
        this.y = read.f();
        this.afterRead();
    }

    public void write(Writes write) {
        write.s(0);
        write.f(this.lifetime);
        write.i(this.stacks.size);
        for (int INDEX = 0; INDEX < this.stacks.size; ++INDEX) {
            TypeIO.writeItems(write, (ItemStack)this.stacks.get(INDEX));
        }
        TypeIO.writeTeam(write, this.team);
        write.f(this.time);
        write.f(this.x);
        write.f(this.y);
    }

    public <T extends Entityc> T self() {
        return (T)this;
    }

    public <T> T as() {
        return (T)this;
    }

    public boolean cheating() {
        return this.team.rules().cheat;
    }

    public boolean inFogTo(Team viewer) {
        return this.team != viewer && !Vars.fogControl.isVisible(viewer, this.x, this.y);
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isLocal() {
        Unitc u;
        LaunchPayload launchPayload;
        return this == Vars.player || (launchPayload = this) instanceof Unitc && (u = (Unitc)launchPayload).controller() == Vars.player;
    }

    public boolean isRemote() {
        Unitc u;
        LaunchPayload launchPayload = this;
        return launchPayload instanceof Unitc && (u = (Unitc)launchPayload).isPlayer() && !this.isLocal();
    }

    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    public boolean serialize() {
        return true;
    }

    public float clipSize() {
        return Float.MAX_VALUE;
    }

    public float cx() {
        return this.x + this.fin((Interp)Interp.pow2In) * (12.0f + Mathf.randomSeedRange((long)(this.id() + 3), (float)4.0f));
    }

    public float cy() {
        return this.y + this.fin((Interp)Interp.pow5In) * (100.0f + Mathf.randomSeedRange((long)(this.id() + 2), (float)30.0f));
    }

    public float fin() {
        return this.time / this.lifetime;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int tileX() {
        return World.toTile(this.x);
    }

    public int tileY() {
        return World.toTile(this.y);
    }

    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public static LaunchPayload create() {
        return new LaunchPayload();
    }

    public void add() {
        if (this.added) {
            return;
        }
        this.index__all = Groups.all.addIndex(this);
        this.index__draw = Groups.draw.addIndex(this);
        this.added = true;
    }

    public void afterRead() {
    }

    public void afterReadAll() {
    }

    public void beforeWrite() {
    }

    public void draw() {
        TextureAtlas.AtlasRegion atlasRegion;
        float alpha = this.fout((Interp)Interp.pow5Out);
        float scale = (1.0f - alpha) * 1.3f + 1.0f;
        float cx = this.cx();
        float cy = this.cy();
        float rotation = this.fin() * (130.0f + Mathf.randomSeedRange((long)this.id(), (float)50.0f));
        Draw.z((float)110.001f);
        Draw.color((Color)Pal.engine);
        float rad = 0.2f + this.fslope();
        Fill.light((float)cx, (float)cy, (int)10, (float)(25.0f * (rad + scale - 1.0f)), (Color)Tmp.c2.set(Pal.engine).a(alpha), (Color)Tmp.c1.set(Pal.engine).a(0.0f));
        Draw.alpha((float)alpha);
        for (int i = 0; i < 4; ++i) {
            Drawf.tri((float)cx, (float)cy, (float)6.0f, (float)(40.0f * (rad + scale - 1.0f)), (float)((float)i * 90.0f + rotation));
        }
        Draw.color();
        Draw.z((float)129.0f);
        Block block = this.blockOn();
        if (block instanceof LaunchPad) {
            LaunchPad p = (LaunchPad)block;
            atlasRegion = p.podRegion;
        } else {
            atlasRegion = Core.atlas.find("launchpod");
        }
        TextureAtlas.AtlasRegion region = atlasRegion;
        float rw = (float)region.width * (scale *= region.scl());
        float rh = (float)region.height * scale;
        Draw.alpha((float)alpha);
        Draw.rect((TextureRegion)region, (float)cx, (float)cy, (float)rw, (float)rh, (float)rotation);
        Tmp.v1.trns(225.0f, this.fin((Interp)Interp.pow3In) * 250.0f);
        Draw.z((float)116.0f);
        Draw.color((float)0.0f, (float)0.0f, (float)0.0f, (float)(0.22f * alpha));
        Draw.rect((TextureRegion)region, (float)(cx + Tmp.v1.x), (float)(cy + Tmp.v1.y), (float)rw, (float)rh, (float)rotation);
        Draw.reset();
    }

    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.removeIndex(this, this.index__all);
        this.index__all = -1;
        Groups.draw.removeIndex(this, this.index__draw);
        this.index__draw = -1;
        this.added = false;
        if (Vars.state.isCampaign() && !Vars.net.client()) {
            Sector destsec = Vars.state.rules.sector.info.destination;
            if (this.team() == Vars.state.rules.defaultTeam && destsec != null && destsec != Vars.state.rules.sector) {
                ItemSeq dest = new ItemSeq();
                for (ItemStack stack : this.stacks) {
                    dest.add(stack);
                    Vars.state.rules.sector.info.handleItemExport(stack);
                    Events.fire((Object)new EventType.LaunchItemEvent(stack));
                }
                if (Vars.state.getPlanet().campaignRules.legacyLaunchPads) {
                    destsec.addItems(dest);
                }
            }
        }
    }

    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    public void update() {
        float r = 3.0f;
        if (this.in.get(4.0f - this.fin() * 2.0f)) {
            Fx.rocketSmoke.at(this.cx() + Mathf.range((float)r), this.cy() + Mathf.range((float)r), this.fin());
        }
        this.time = Math.min(this.time + Time.delta, this.lifetime);
        if (this.time >= this.lifetime) {
            this.remove();
        }
    }
}

