/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.entities.EntityGroup;
import mindustry.gen.Building;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.IndexableEntity__all;
import mindustry.gen.IndexableEntity__draw;
import mindustry.gen.LaunchCorec;
import mindustry.gen.Posc;
import mindustry.gen.Timedc;
import mindustry.gen.Unitc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

public class LaunchCore
implements Drawc,
Entityc,
IndexableEntity__all,
IndexableEntity__draw,
LaunchCorec,
Posc,
Timedc {
    protected transient boolean added;
    public Block block;
    public transient int id = EntityGroup.nextId();
    public transient Interval in = new Interval();
    protected transient int index__all = -1;
    protected transient int index__draw = -1;
    public float lifetime;
    public float time;
    public float x;
    public float y;

    protected LaunchCore() {
    }

    @Nullable
    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Nullable
    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    public Interval in() {
        return this.in;
    }

    public float lifetime() {
        return this.lifetime;
    }

    public float time() {
        return this.time;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public int classId() {
        return 11;
    }

    public int id() {
        return this.id;
    }

    public String toString() {
        return "LaunchCore#" + this.id;
    }

    public Block block() {
        return this.block;
    }

    public void block(Block block) {
        this.block = block;
    }

    public void id(int id) {
        this.id = id;
    }

    public void in(Interval in) {
        this.in = in;
    }

    public void lifetime(float lifetime) {
        this.lifetime = lifetime;
    }

    public void setIndex__all(int index) {
        this.index__all = index;
    }

    public void setIndex__draw(int index) {
        this.index__draw = index;
    }

    public void time(float time) {
        this.time = time;
    }

    public void x(float x) {
        this.x = x;
    }

    public void y(float y) {
        this.y = y;
    }

    public <T extends Entityc> T self() {
        return (T)this;
    }

    public <T> T as() {
        return (T)this;
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isLocal() {
        Unitc u;
        LaunchCore launchCore;
        return this == Vars.player || (launchCore = this) instanceof Unitc && (u = (Unitc)launchCore).controller() == Vars.player;
    }

    public boolean isRemote() {
        Unitc u;
        LaunchCore launchCore = this;
        return launchCore instanceof Unitc && (u = (Unitc)launchCore).isPlayer() && !this.isLocal();
    }

    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    public boolean serialize() {
        return false;
    }

    public float clipSize() {
        return Float.MAX_VALUE;
    }

    public float cx() {
        return this.x + this.fin((Interp)Interp.pow2In) * (12.0f + Mathf.randomSeedRange((long)(this.id() + 3), (float)4.0f));
    }

    public float cy() {
        return this.y + this.fin((Interp)Interp.pow5In) * (100.0f + Mathf.randomSeedRange((long)(this.id() + 2), (float)30.0f));
    }

    public float fin() {
        return this.time / this.lifetime;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int tileX() {
        return World.toTile(this.x);
    }

    public int tileY() {
        return World.toTile(this.y);
    }

    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public static LaunchCore create() {
        return new LaunchCore();
    }

    public void add() {
        if (this.added) {
            return;
        }
        this.index__all = Groups.all.addIndex(this);
        this.index__draw = Groups.draw.addIndex(this);
        this.added = true;
    }

    public void afterRead() {
    }

    public void afterReadAll() {
    }

    public void beforeWrite() {
    }

    public void draw() {
        float alpha = this.fout((Interp)Interp.pow5Out);
        float scale = (1.0f - alpha) * 1.4f + 1.0f;
        float cx = this.cx();
        float cy = this.cy();
        float rotation = this.fin() * (140.0f + Mathf.randomSeedRange((long)this.id(), (float)50.0f));
        Draw.z((float)110.001f);
        Draw.color((Color)Pal.engine);
        float rad = 0.2f + this.fslope();
        float rscl = (float)(this.block.size - 1) * 0.85f;
        Fill.light((float)cx, (float)cy, (int)10, (float)(25.0f * (rad + scale - 1.0f) * rscl), (Color)Tmp.c2.set(Pal.engine).a(alpha), (Color)Tmp.c1.set(Pal.engine).a(0.0f));
        Draw.alpha((float)alpha);
        for (int i = 0; i < 4; ++i) {
            Drawf.tri((float)cx, (float)cy, (float)(6.0f * rscl), (float)(40.0f * (rad + scale - 1.0f) * rscl), (float)((float)i * 90.0f + rotation));
        }
        Draw.color();
        Draw.z((float)129.0f);
        TextureRegion region = this.block.fullIcon;
        float rw = (float)region.width * (scale *= region.scl());
        float rh = (float)region.height * scale;
        Draw.alpha((float)alpha);
        Draw.rect((TextureRegion)region, (float)cx, (float)cy, (float)rw, (float)rh, (float)(rotation - 45.0f));
        Tmp.v1.trns(225.0f, this.fin((Interp)Interp.pow3In) * 250.0f);
        Draw.z((float)116.0f);
        Draw.color((float)0.0f, (float)0.0f, (float)0.0f, (float)(0.22f * alpha));
        Draw.rect((TextureRegion)region, (float)(cx + Tmp.v1.x), (float)(cy + Tmp.v1.y), (float)rw, (float)rh, (float)(rotation - 45.0f));
        Draw.reset();
    }

    public void read(Reads read) {
        this.afterRead();
    }

    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.removeIndex(this, this.index__all);
        this.index__all = -1;
        Groups.draw.removeIndex(this, this.index__draw);
        this.index__draw = -1;
        this.added = false;
    }

    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    public void update() {
        float r = 4.0f;
        if (this.in.get(3.0f - this.fin() * 2.0f)) {
            Fx.rocketSmokeLarge.at(this.cx() + Mathf.range((float)r), this.cy() + Mathf.range((float)r), this.fin());
        }
        this.time = Math.min(this.time + Time.delta, this.lifetime);
        if (this.time >= this.lifetime) {
            this.remove();
        }
    }

    public void write(Writes write) {
    }
}

