/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.graphics.Color;
import arc.math.Angles;
import arc.math.geom.Position;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.World;
import mindustry.entities.Effect;
import mindustry.entities.EntityGroup;
import mindustry.gen.Building;
import mindustry.gen.Childc;
import mindustry.gen.Drawc;
import mindustry.gen.EffectStatec;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.IndexableEntity__all;
import mindustry.gen.IndexableEntity__draw;
import mindustry.gen.Posc;
import mindustry.gen.Rotc;
import mindustry.gen.Timedc;
import mindustry.gen.Unitc;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.RotBlock;
import mindustry.world.blocks.environment.Floor;

public class EffectState
implements Pool.Poolable,
Childc,
Drawc,
EffectStatec,
Entityc,
IndexableEntity__all,
IndexableEntity__draw,
Posc,
Rotc,
Timedc {
    protected transient boolean added;
    public Color color = new Color(Color.white);
    public Object data;
    public Effect effect;
    public transient int id = EntityGroup.nextId();
    protected transient int index__all = -1;
    protected transient int index__draw = -1;
    public float lifetime;
    public float offsetPos;
    public float offsetRot;
    public float offsetX;
    public float offsetY;
    @Nullable
    public Posc parent;
    public boolean rotWithParent;
    public float rotation;
    public float time;
    public float x;
    public float y;

    protected EffectState() {
    }

    @Nullable
    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Nullable
    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    public Color color() {
        return this.color;
    }

    public boolean rotWithParent() {
        return this.rotWithParent;
    }

    public float lifetime() {
        return this.lifetime;
    }

    public float offsetPos() {
        return this.offsetPos;
    }

    public float offsetRot() {
        return this.offsetRot;
    }

    public float offsetX() {
        return this.offsetX;
    }

    public float offsetY() {
        return this.offsetY;
    }

    public float rotation() {
        return this.rotation;
    }

    public float time() {
        return this.time;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public int classId() {
        return 9;
    }

    public int id() {
        return this.id;
    }

    public Object data() {
        return this.data;
    }

    public String toString() {
        return "EffectState#" + this.id;
    }

    public Effect effect() {
        return this.effect;
    }

    public Posc parent() {
        return this.parent;
    }

    public void color(Color color) {
        this.color = color;
    }

    public void data(Object data) {
        this.data = data;
    }

    public void effect(Effect effect) {
        this.effect = effect;
    }

    public void id(int id) {
        this.id = id;
    }

    public void lifetime(float lifetime) {
        this.lifetime = lifetime;
    }

    public void offsetPos(float offsetPos) {
        this.offsetPos = offsetPos;
    }

    public void offsetRot(float offsetRot) {
        this.offsetRot = offsetRot;
    }

    public void offsetX(float offsetX) {
        this.offsetX = offsetX;
    }

    public void offsetY(float offsetY) {
        this.offsetY = offsetY;
    }

    public void parent(Posc parent) {
        this.parent = parent;
    }

    public void rotWithParent(boolean rotWithParent) {
        this.rotWithParent = rotWithParent;
    }

    public void rotation(float rotation) {
        this.rotation = rotation;
    }

    public void setIndex__all(int index) {
        this.index__all = index;
    }

    public void setIndex__draw(int index) {
        this.index__draw = index;
    }

    public void time(float time) {
        this.time = time;
    }

    public void x(float x) {
        this.x = x;
    }

    public void y(float y) {
        this.y = y;
    }

    public <T extends Entityc> T self() {
        return (T)this;
    }

    public <T> T as() {
        return (T)this;
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isLocal() {
        Unitc u;
        EffectState effectState;
        return this == Vars.player || (effectState = this) instanceof Unitc && (u = (Unitc)effectState).controller() == Vars.player;
    }

    public boolean isRemote() {
        Unitc u;
        EffectState effectState = this;
        return effectState instanceof Unitc && (u = (Unitc)effectState).isPlayer() && !this.isLocal();
    }

    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    public boolean serialize() {
        return false;
    }

    public float clipSize() {
        return this.effect.clip;
    }

    public float fin() {
        return this.time / this.lifetime;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int tileX() {
        return World.toTile(this.x);
    }

    public int tileY() {
        return World.toTile(this.y);
    }

    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public static EffectState create() {
        return (EffectState)Pools.obtain(EffectState.class, EffectState::new);
    }

    public void add() {
        if (this.added) {
            return;
        }
        this.index__all = Groups.all.addIndex(this);
        this.index__draw = Groups.draw.addIndex(this);
        if (this.parent != null) {
            this.offsetX = this.x - this.parent.getX();
            this.offsetY = this.y - this.parent.getY();
            if (this.rotWithParent) {
                Posc posc = this.parent;
                if (posc instanceof Rotc) {
                    Rotc r = (Rotc)posc;
                    this.offsetPos = -r.rotation();
                    this.offsetRot = this.rotation - r.rotation();
                } else {
                    posc = this.parent;
                    if (posc instanceof RotBlock) {
                        RotBlock rot = (RotBlock)posc;
                        this.offsetPos = -rot.buildRotation();
                        this.offsetRot = this.rotation - rot.buildRotation();
                    }
                }
            }
        }
        this.added = true;
    }

    public void afterRead() {
    }

    public void afterReadAll() {
    }

    public void beforeWrite() {
    }

    public void draw() {
        this.lifetime = this.effect.render(this.id, this.color, this.time, this.lifetime, this.rotation, this.x, this.y, this.data);
    }

    public void read(Reads read) {
        this.afterRead();
    }

    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.removeIndex(this, this.index__all);
        this.index__all = -1;
        Groups.draw.removeIndex(this, this.index__draw);
        this.index__draw = -1;
        this.added = false;
        Groups.queueFree((Pool.Poolable)this);
    }

    public void reset() {
        this.added = false;
        this.data = null;
        this.effect = null;
        this.id = EntityGroup.nextId();
        this.lifetime = 0.0f;
        this.offsetPos = 0.0f;
        this.offsetRot = 0.0f;
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
        this.parent = null;
        this.rotWithParent = false;
        this.rotation = 0.0f;
        this.time = 0.0f;
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    public void update() {
        if (this.parent != null) {
            if (this.rotWithParent) {
                Posc posc = this.parent;
                if (posc instanceof Rotc) {
                    Rotc r = (Rotc)posc;
                    this.x = this.parent.getX() + Angles.trnsx((float)(r.rotation() + this.offsetPos), (float)this.offsetX, (float)this.offsetY);
                    this.y = this.parent.getY() + Angles.trnsy((float)(r.rotation() + this.offsetPos), (float)this.offsetX, (float)this.offsetY);
                    this.rotation = r.rotation() + this.offsetRot;
                } else {
                    posc = this.parent;
                    if (posc instanceof RotBlock) {
                        RotBlock rot = (RotBlock)posc;
                        this.x = this.parent.getX() + Angles.trnsx((float)(rot.buildRotation() + this.offsetPos), (float)this.offsetX, (float)this.offsetY);
                        this.y = this.parent.getY() + Angles.trnsy((float)(rot.buildRotation() + this.offsetPos), (float)this.offsetX, (float)this.offsetY);
                        this.rotation = rot.buildRotation() + this.offsetRot;
                    }
                }
            } else {
                this.x = this.parent.getX() + this.offsetX;
                this.y = this.parent.getY() + this.offsetY;
            }
        }
        this.time = Math.min(this.time + Time.delta, this.lifetime);
        if (this.time >= this.lifetime) {
            this.remove();
        }
    }

    public void write(Writes write) {
    }
}

