/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.func.Cons;
import arc.graphics.g2d.Draw;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Position;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.World;
import mindustry.entities.EntityGroup;
import mindustry.entities.Mover;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Bulletc;
import mindustry.gen.Damagec;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.gen.IndexableEntity__all;
import mindustry.gen.IndexableEntity__bullet;
import mindustry.gen.IndexableEntity__draw;
import mindustry.gen.Ownerc;
import mindustry.gen.Posc;
import mindustry.gen.Rotc;
import mindustry.gen.Shielderc;
import mindustry.gen.Teamc;
import mindustry.gen.Timedc;
import mindustry.gen.Timerc;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Trail;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.StaticWall;
import mindustry.world.blocks.storage.CoreBlock;

public class Bullet
implements Pool.Poolable,
Bulletc,
Damagec,
Drawc,
Entityc,
Hitboxc,
IndexableEntity__all,
IndexableEntity__bullet,
IndexableEntity__draw,
Ownerc,
Posc,
Shielderc,
Teamc,
Timedc,
Timerc {
    public transient boolean absorbed;
    protected transient boolean added;
    @Nullable
    public transient Tile aimTile;
    public transient float aimX;
    public transient float aimY;
    public IntSeq collided = new IntSeq(6);
    public float damage;
    public Object data;
    public transient float deltaX;
    public transient float deltaY;
    public float fdata;
    public transient int frags;
    public transient boolean hit;
    public transient float hitSize;
    public transient int id = EntityGroup.nextId();
    protected transient int index__all = -1;
    protected transient int index__bullet = -1;
    protected transient int index__draw = -1;
    public transient boolean justSpawned = true;
    public transient boolean keepAlive;
    public transient float lastX;
    public transient float lastY;
    public float lifetime;
    @Nullable
    public transient Mover mover;
    public transient float originX;
    public transient float originY;
    public Entityc owner;
    protected float rotation;
    public transient Entityc shooter;
    public transient float stickyRotation;
    public transient float stickyRotationOffset;
    public transient Posc stickyTarget;
    public transient float stickyX;
    public transient float stickyY;
    public Team team = Team.derelict;
    public float time;
    public transient Interval timer = new Interval(6);
    @Nullable
    public transient Trail trail;
    public BulletType type;
    public Vec2 vel = new Vec2();
    public float x;
    public float y;

    protected Bullet() {
    }

    @Nullable
    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Nullable
    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    @Nullable
    public CoreBlock.CoreBuild closestCore() {
        return Vars.state.teams.closestCore(this.x, this.y, this.team);
    }

    @Nullable
    public CoreBlock.CoreBuild closestEnemyCore() {
        return Vars.state.teams.closestEnemyCore(this.x, this.y, this.team);
    }

    @Nullable
    public CoreBlock.CoreBuild core() {
        return this.team.core();
    }

    public Vec2 vel() {
        return this.vel;
    }

    public IntSeq collided() {
        return this.collided;
    }

    public Interval timer() {
        return this.timer;
    }

    public boolean absorbed() {
        return this.absorbed;
    }

    public boolean hit() {
        return this.hit;
    }

    public boolean justSpawned() {
        return this.justSpawned;
    }

    public boolean keepAlive() {
        return this.keepAlive;
    }

    public float aimX() {
        return this.aimX;
    }

    public float aimY() {
        return this.aimY;
    }

    public float damage() {
        return this.damage;
    }

    public float deltaX() {
        return this.deltaX;
    }

    public float deltaY() {
        return this.deltaY;
    }

    public float fdata() {
        return this.fdata;
    }

    public float lastX() {
        return this.lastX;
    }

    public float lastY() {
        return this.lastY;
    }

    public float lifetime() {
        return this.lifetime;
    }

    public float originX() {
        return this.originX;
    }

    public float originY() {
        return this.originY;
    }

    public float stickyRotation() {
        return this.stickyRotation;
    }

    public float stickyRotationOffset() {
        return this.stickyRotationOffset;
    }

    public float stickyX() {
        return this.stickyX;
    }

    public float stickyY() {
        return this.stickyY;
    }

    public float time() {
        return this.time;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public int classId() {
        return 7;
    }

    public int frags() {
        return this.frags;
    }

    public int id() {
        return this.id;
    }

    public Object data() {
        return this.data;
    }

    public String toString() {
        return "Bullet#" + this.id;
    }

    public Mover mover() {
        return this.mover;
    }

    public BulletType type() {
        return this.type;
    }

    public Team team() {
        return this.team;
    }

    public Entityc owner() {
        return this.owner;
    }

    public Entityc shooter() {
        return this.shooter;
    }

    public Posc stickyTarget() {
        return this.stickyTarget;
    }

    public Trail trail() {
        return this.trail;
    }

    public Tile aimTile() {
        return this.aimTile;
    }

    public void absorbed(boolean absorbed) {
        this.absorbed = absorbed;
    }

    public void aimTile(Tile aimTile) {
        this.aimTile = aimTile;
    }

    public void aimX(float aimX) {
        this.aimX = aimX;
    }

    public void aimY(float aimY) {
        this.aimY = aimY;
    }

    public void collided(IntSeq collided) {
        this.collided = collided;
    }

    public void damage(float damage) {
        this.damage = damage;
    }

    public void data(Object data) {
        this.data = data;
    }

    public void deltaX(float deltaX) {
        this.deltaX = deltaX;
    }

    public void deltaY(float deltaY) {
        this.deltaY = deltaY;
    }

    public void fdata(float fdata) {
        this.fdata = fdata;
    }

    public void frags(int frags) {
        this.frags = frags;
    }

    public void hit(boolean hit) {
        this.hit = hit;
    }

    public void hitSize(float hitSize) {
        this.hitSize = hitSize;
    }

    public void id(int id) {
        this.id = id;
    }

    public void justSpawned(boolean justSpawned) {
        this.justSpawned = justSpawned;
    }

    public void keepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void lastX(float lastX) {
        this.lastX = lastX;
    }

    public void lastY(float lastY) {
        this.lastY = lastY;
    }

    public void lifetime(float lifetime) {
        this.lifetime = lifetime;
    }

    public void mover(Mover mover) {
        this.mover = mover;
    }

    public void originX(float originX) {
        this.originX = originX;
    }

    public void originY(float originY) {
        this.originY = originY;
    }

    public void owner(Entityc owner) {
        this.owner = owner;
    }

    public void setIndex__all(int index) {
        this.index__all = index;
    }

    public void setIndex__bullet(int index) {
        this.index__bullet = index;
    }

    public void setIndex__draw(int index) {
        this.index__draw = index;
    }

    public void shooter(Entityc shooter) {
        this.shooter = shooter;
    }

    public void stickyRotation(float stickyRotation) {
        this.stickyRotation = stickyRotation;
    }

    public void stickyRotationOffset(float stickyRotationOffset) {
        this.stickyRotationOffset = stickyRotationOffset;
    }

    public void stickyTarget(Posc stickyTarget) {
        this.stickyTarget = stickyTarget;
    }

    public void stickyX(float stickyX) {
        this.stickyX = stickyX;
    }

    public void stickyY(float stickyY) {
        this.stickyY = stickyY;
    }

    public void team(Team team) {
        this.team = team;
    }

    public void time(float time) {
        this.time = time;
    }

    public void timer(Interval timer) {
        this.timer = timer;
    }

    public void trail(Trail trail) {
        this.trail = trail;
    }

    public void type(BulletType type) {
        this.type = type;
    }

    public void vel(Vec2 vel) {
        this.vel = vel;
    }

    public void x(float x) {
        this.x = x;
    }

    public void y(float y) {
        this.y = y;
    }

    public <T extends Entityc> T self() {
        return (T)this;
    }

    public <T> T as() {
        return (T)this;
    }

    public boolean cheating() {
        return this.team.rules().cheat;
    }

    public boolean checkUnderBuild(Building build, float x, float y) {
        return !build.block.underBullets || this.aimTile != null && this.aimTile.build == build || this.type.hitUnder || build.team == this.team || this.type.pierce && this.aimTile != null && Mathf.dst((float)x, (float)y, (float)this.originX, (float)this.originY) > this.aimTile.dst(this.originX, this.originY) + 2.0f || this.aimX == -1.0f && this.aimY == -1.0f;
    }

    public boolean collides(Hitboxc other) {
        Unit f;
        Teamc t;
        return !(!this.type.collides || !(other instanceof Teamc) || (t = (Teamc)other).team() == this.team || other instanceof Unit && !(f = (Unit)other).checkTarget(this.type.collidesAir, this.type.collidesGround) || this.type.pierce && this.hasCollided(other.id()) || this.stickyTarget != null);
    }

    public boolean hasCollided(int id) {
        return this.collided.size != 0 && this.collided.contains(id);
    }

    public boolean inFogTo(Team viewer) {
        return this.team != viewer && !Vars.fogControl.isVisible(viewer, this.x, this.y);
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isLocal() {
        return true;
    }

    public boolean isRemote() {
        Unitc u;
        Bullet bullet = this;
        return bullet instanceof Unitc && (u = (Unitc)bullet).isPlayer() && !this.isLocal();
    }

    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    public boolean serialize() {
        return false;
    }

    public boolean timer(int index, float time) {
        if (Float.isInfinite(time)) {
            return false;
        }
        return this.timer.get(index, time);
    }

    public float clipSize() {
        return this.type.drawSize;
    }

    public float damageMultiplier() {
        return this.type.damageMultiplier(this);
    }

    public float deltaAngle() {
        return Mathf.angle((float)this.deltaX, (float)this.deltaY);
    }

    public float deltaLen() {
        return Mathf.len((float)this.deltaX, (float)this.deltaY);
    }

    public float fin() {
        return this.time / this.lifetime;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float hitSize() {
        return this.hitSize;
    }

    public float rotation() {
        return this.vel.isZero(0.001f) ? this.rotation : this.vel.angle();
    }

    public int tileX() {
        return World.toTile(this.x);
    }

    public int tileY() {
        return World.toTile(this.y);
    }

    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public static Bullet create() {
        return (Bullet)Pools.obtain(Bullet.class, Bullet::new);
    }

    public void absorb() {
        this.absorbed = true;
        this.remove();
    }

    public void add() {
        if (this.added) {
            return;
        }
        this.index__all = Groups.all.addIndex(this);
        this.index__bullet = Groups.bullet.addIndex(this);
        this.index__draw = Groups.draw.addIndex(this);
        this.type.init(this);
        this.added = true;
        this.updateLastPosition();
    }

    public void afterRead() {
        this.updateLastPosition();
    }

    public void afterReadAll() {
    }

    public void beforeWrite() {
    }

    public void collision(Hitboxc other, float x, float y) {
        if (this.type.sticky) {
            if (this.stickyTarget == null) {
                this.x = x + this.vel.x;
                this.y = y + this.vel.y;
                this.stickTo((Posc)other);
            }
        } else {
            float f;
            this.type.hit(this, x, y);
            if (!this.type.pierce) {
                this.hit = true;
                this.remove();
            } else {
                this.collided.add(other.id());
            }
            if (other instanceof Healthc) {
                Healthc h = (Healthc)other;
                f = h.health();
            } else {
                f = 0.0f;
            }
            this.type.hitEntity(this, other, f);
        }
    }

    public void draw() {
        Draw.z((float)this.type.layer);
        if (this.type.underwater) {
            Drawf.underwater(() -> this.type.draw(this));
        } else {
            this.type.draw(this);
        }
        this.type.drawLight(this);
        Draw.reset();
    }

    public void getCollisions(Cons<QuadTree> consumer) {
        Seq data = Vars.state.teams.present;
        for (int i = 0; i < data.size; ++i) {
            if (((Teams.TeamData[])data.items)[i].team == this.team) continue;
            consumer.get((Object)((Teams.TeamData[])data.items)[i].tree());
        }
    }

    public void hitbox(Rect rect) {
        rect.setCentered(this.x, this.y, this.hitSize, this.hitSize);
    }

    public void hitboxTile(Rect rect) {
        float size = Math.min(this.hitSize * 0.66f, 7.8f);
        rect.setCentered(this.x, this.y, size, size);
    }

    public void initVel(float angle, float amount) {
        this.vel.trns(angle, amount);
        this.rotation = angle;
    }

    public void moveRelative(float x, float y) {
        float rot = this.rotation();
        this.x += Angles.trnsx((float)rot, (float)(x * Time.delta), (float)(y * Time.delta));
        this.y += Angles.trnsy((float)rot, (float)(x * Time.delta), (float)(y * Time.delta));
    }

    public void read(Reads read) {
        this.afterRead();
    }

    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.removeIndex(this, this.index__all);
        this.index__all = -1;
        Groups.bullet.removeIndex(this, this.index__bullet);
        this.index__bullet = -1;
        Groups.draw.removeIndex(this, this.index__draw);
        this.index__draw = -1;
        if (!Groups.isClearing) {
            if (!this.hit) {
                this.type.despawned(this);
            }
            this.type.removed(this);
            this.collided.clear();
        }
        this.added = false;
        Groups.queueFree((Pool.Poolable)this);
    }

    public void reset() {
        this.absorbed = false;
        this.added = false;
        this.aimTile = null;
        this.aimX = 0.0f;
        this.aimY = 0.0f;
        this.damage = 0.0f;
        this.data = null;
        this.deltaX = 0.0f;
        this.deltaY = 0.0f;
        this.fdata = 0.0f;
        this.frags = 0;
        this.hit = false;
        this.hitSize = 0.0f;
        this.id = EntityGroup.nextId();
        this.justSpawned = true;
        this.keepAlive = false;
        this.lastX = 0.0f;
        this.lastY = 0.0f;
        this.lifetime = 0.0f;
        this.mover = null;
        this.originX = 0.0f;
        this.originY = 0.0f;
        this.owner = null;
        this.rotation = 0.0f;
        this.shooter = null;
        this.stickyRotation = 0.0f;
        this.stickyRotationOffset = 0.0f;
        this.stickyTarget = null;
        this.stickyX = 0.0f;
        this.stickyY = 0.0f;
        this.time = 0.0f;
        this.trail = null;
        this.type = null;
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public void rotation(float angle) {
        this.rotation = angle;
        this.vel.setAngle(this.rotation);
    }

    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void stickTo(Posc other) {
        float f;
        this.lifetime += this.type.stickyExtraLifetime;
        this.stickyX = this.x - other.x();
        this.stickyY = this.y - other.y();
        this.stickyTarget = other;
        this.stickyRotationOffset = this.rotation;
        if (other instanceof Rotc) {
            Rotc rot = (Rotc)other;
            f = rot.rotation();
        } else {
            f = 0.0f;
        }
        this.stickyRotation = f;
    }

    public void tileRaycast(int x1, int y1, int x2, int y2) {
        int x = x1;
        int dx = Math.abs(x2 - x);
        int sx = x < x2 ? 1 : -1;
        int y = y1;
        int dy = Math.abs(y2 - y);
        int sy = y < y2 ? 1 : -1;
        int err = dx - dy;
        int ww = Vars.world.width();
        int wh = Vars.world.height();
        while (x >= 0 && y >= 0 && x < ww && y < wh) {
            Building build = Vars.world.build(x, y);
            if (this.type.collideFloor || this.type.collideTerrain) {
                Tile tile = Vars.world.tile(x, y);
                if (this.type.collideFloor && (tile == null || tile.floor().hasSurface() || tile.block() != Blocks.air) || this.type.collideTerrain && tile != null && tile.block() instanceof StaticWall) {
                    this.remove();
                    this.hit = true;
                    return;
                }
            }
            if (build != null && this.isAdded() && this.checkUnderBuild(build, x * 8, y * 8) && build.collide(this) && this.type.testCollision(this, build) && !build.dead() && (this.type.collidesTeam || build.team != this.team) && (!this.type.pierceBuilding || !this.hasCollided(build.id))) {
                if (this.type.sticky) {
                    if (build.team != this.team) {
                        Vec2 hit = Geometry.raycastRect((float)this.lastX, (float)this.lastY, (float)x, (float)y, (Rect)Tmp.r1.setCentered((float)(x * 8), (float)(y * 8), 8.0f, 8.0f));
                        if (hit != null) {
                            this.x = hit.x;
                            this.y = hit.y;
                        }
                        this.stickTo(build);
                        return;
                    }
                } else {
                    boolean remove = false;
                    float health = build.health;
                    if (build.team != this.team) {
                        remove = build.collision(this);
                    }
                    if (remove || this.type.collidesTeam) {
                        if (Mathf.dst2((float)this.lastX, (float)this.lastY, (float)(x * 8), (float)(y * 8)) < Mathf.dst2((float)this.lastX, (float)this.lastY, (float)this.x, (float)this.y)) {
                            this.x = x * 8;
                            this.y = y * 8;
                        }
                        if (!this.type.pierceBuilding) {
                            this.hit = true;
                            this.remove();
                        } else {
                            this.collided.add(build.id);
                        }
                    }
                    this.type.hitTile(this, build, x * 8, y * 8, health, true);
                    if (this.type.pierceBuilding) {
                        return;
                    }
                }
            }
            if (x == x2 && y == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y += sy;
        }
    }

    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    public void turn(float x, float y) {
        float ang = this.vel.angle();
        this.vel.add(Angles.trnsx((float)ang, (float)(x * Time.delta), (float)(y * Time.delta)), Angles.trnsy((float)ang, (float)(x * Time.delta), (float)(y * Time.delta))).limit(this.type.speed);
    }

    public void update() {
        if (!this.justSpawned) {
            this.x += this.vel.x * Time.delta;
            this.y += this.vel.y * Time.delta;
            this.vel.scl(Math.max(1.0f - this.type.drag * Time.delta, 0.0f));
        }
        this.justSpawned = false;
        if (this.mover != null) {
            this.mover.move(this);
        }
        if (this.type.accel != 0.0f) {
            this.vel.setLength(this.vel.len() + this.type.accel * Time.delta);
        }
        this.type.update(this);
        if (this.stickyTarget != null) {
            Healthc h;
            Posc posc = this.stickyTarget;
            if (posc instanceof Healthc && (h = (Healthc)posc).isValid()) {
                float f;
                Posc posc2 = this.stickyTarget;
                if (posc2 instanceof Rotc) {
                    Rotc rot = (Rotc)posc2;
                    f = rot.rotation() - this.stickyRotation;
                } else {
                    f = 0.0f;
                }
                float rotate = f;
                this.set((Position)Tmp.v1.set(this.stickyX, this.stickyY).rotate(rotate).add((Position)this.stickyTarget));
                this.rotation = rotate + this.stickyRotationOffset;
                this.vel.setAngle(this.rotation);
            }
        } else if (this.type.collidesTiles && this.type.collides && this.type.collidesGround) {
            this.tileRaycast(World.toTile(this.lastX), World.toTile(this.lastY), this.tileX(), this.tileY());
        }
        if (this.type.removeAfterPierce && this.type.pierceCap != -1 && this.collided.size >= this.type.pierceCap) {
            this.hit = true;
            this.remove();
        }
        if (this.keepAlive) {
            this.time -= Time.delta;
            this.keepAlive = false;
        }
        this.time = Math.min(this.time + Time.delta, this.lifetime);
        if (this.time >= this.lifetime) {
            this.remove();
        }
    }

    public void updateLastPosition() {
        this.deltaX = this.x - this.lastX;
        this.deltaY = this.y - this.lastY;
        this.lastX = this.x;
        this.lastY = this.y;
    }

    public void write(Writes write) {
    }
}

