/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.files.Fi;
import arc.struct.ObjectFloatMap;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.mod.Mods;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.type.Publishable;
import mindustry.world.Block;
import mindustry.world.blocks.power.ConsumeGenerator;
import mindustry.world.blocks.power.ImpactReactor;
import mindustry.world.blocks.power.NuclearReactor;
import mindustry.world.blocks.power.PowerGenerator;
import mindustry.world.blocks.production.Fracker;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.blocks.production.Separator;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumeLiquids;

public class Schematic
implements Publishable,
Comparable<Schematic> {
    public final Seq<Stile> tiles;
    public Seq<String> labels = new Seq();
    public StringMap tags;
    public int width;
    public int height;
    @Nullable
    public Fi file;
    @Nullable
    public Mods.LoadedMod mod;
    public ObjectFloatMap<Item> items;
    public ObjectFloatMap<Liquid> liquids;

    public Schematic(Seq<Stile> tiles, StringMap tags, int width, int height) {
        this.tiles = tiles;
        this.tags = tags;
        this.width = width;
        this.height = height;
    }

    public boolean containsBlock(Block block) {
        return this.tiles.find(tile -> tile.block == block) != null;
    }

    public float powerProduction() {
        return this.tiles.sumf(s -> {
            float f;
            Block patt1519$temp = s.block;
            if (patt1519$temp instanceof PowerGenerator) {
                PowerGenerator p = (PowerGenerator)((Object)((Object)((Object)patt1519$temp)));
                f = p.getDisplayedPowerProduction();
            } else {
                f = 0.0f;
            }
            return f;
        });
    }

    public float powerConsumption() {
        return this.tiles.sumf(s -> s.block.consPower != null ? s.block.consPower.usage : 0.0f);
    }

    public void calProduction() {
        this.items = new ObjectFloatMap(Vars.content.items().copy().size << 1);
        this.liquids = new ObjectFloatMap(Vars.content.liquids().copy().size << 1);
        this.tiles.each(t -> {
            block34: {
                block33: {
                    if (t.block == null) {
                        return;
                    }
                    Consume[] patt2016$temp = t.block;
                    if (!(patt2016$temp instanceof GenericCrafter)) break block33;
                    GenericCrafter gc = (GenericCrafter)patt2016$temp;
                    for (Consume consume : gc.nonOptionalConsumers) {
                        if (consume instanceof ConsumeItems) {
                            ConsumeItems consumeItems = (ConsumeItems)consume;
                            for (ItemStack itemStack : consumeItems.items) {
                                Item item = itemStack.item;
                                this.items.put((Object)item, this.items.get((Object)item, 0.0f) - (float)itemStack.amount * 60.0f / gc.craftTime);
                            }
                            continue;
                        }
                        if (consume instanceof ConsumeLiquid) {
                            ConsumeLiquid consumeLiquid = (ConsumeLiquid)consume;
                            LiquidStack[] liquid = consumeLiquid.liquid;
                            this.liquids.put((Object)liquid, this.liquids.get((Object)liquid, 0.0f) - consumeLiquid.amount * 60.0f);
                            continue;
                        }
                        if (!(consume instanceof ConsumeLiquids)) continue;
                        ConsumeLiquids consumeLiquids = (ConsumeLiquids)consume;
                        for (LiquidStack liquidStack : consumeLiquids.liquids) {
                            Liquid liquid = liquidStack.liquid;
                            this.liquids.put((Object)liquid, this.liquids.get((Object)liquid, 0.0f) - liquidStack.amount * 60.0f);
                        }
                    }
                    if (gc.outputsItems()) {
                        for (Consume consume : gc.outputItems) {
                            Item item = consume.item;
                            this.items.put((Object)item, this.items.get((Object)item, 0.0f) + (float)consume.amount * 60.0f / gc.craftTime);
                        }
                    }
                    if (gc.outputLiquids == null) break block34;
                    for (Consume consume : gc.outputLiquids) {
                        Liquid liquid = consume.liquid;
                        this.liquids.put((Object)liquid, this.liquids.get((Object)liquid, 0.0f) + consume.amount * 60.0f);
                    }
                    break block34;
                }
                Consume[] patt3808$temp = t.block;
                if (patt3808$temp instanceof Separator) {
                    Separator s = (Separator)patt3808$temp;
                    for (Consume consume : s.nonOptionalConsumers) {
                        if (consume instanceof ConsumeItems) {
                            ConsumeItems consumeItems = (ConsumeItems)consume;
                            for (ItemStack stack : consumeItems.items) {
                                Item item = stack.item;
                                this.items.put((Object)item, this.items.get((Object)item, 0.0f) - (float)stack.amount * 60.0f / s.craftTime);
                            }
                            continue;
                        }
                        if (!(consume instanceof ConsumeLiquid)) continue;
                        ConsumeLiquid consumeLiquid = (ConsumeLiquid)consume;
                        Liquid liquid = consumeLiquid.liquid;
                        this.liquids.put((Object)liquid, this.liquids.get((Object)liquid, 0.0f) - consumeLiquid.amount * 60.0f);
                    }
                } else {
                    Consume[] patt4496$temp = t.block;
                    if (patt4496$temp instanceof Fracker) {
                        Fracker f = (Fracker)patt4496$temp;
                        for (Consume consume : f.nonOptionalConsumers) {
                            if (!(consume instanceof ConsumeItems)) continue;
                            ConsumeItems consumeItems = (ConsumeItems)consume;
                            for (ItemStack stack : consumeItems.items) {
                                Item item = stack.item;
                                this.items.put((Object)item, this.items.get((Object)item, 0.0f) - (float)stack.amount * f.itemUseTime / 60.0f);
                            }
                        }
                    } else if (t.block instanceof PowerGenerator) {
                        float itemDuration = 0.0f;
                        Block patt5047$temp = t.block;
                        if (patt5047$temp instanceof ConsumeGenerator) {
                            ConsumeGenerator cg = (ConsumeGenerator)patt5047$temp;
                            itemDuration = cg.itemDuration;
                        } else {
                            Block patt5165$temp = t.block;
                            if (patt5165$temp instanceof NuclearReactor) {
                                NuclearReactor nr = (NuclearReactor)patt5165$temp;
                                itemDuration = nr.itemDuration;
                            } else {
                                Block patt5281$temp = t.block;
                                if (patt5281$temp instanceof ImpactReactor) {
                                    ImpactReactor impactReactor = (ImpactReactor)((Object)((Object)((Object)patt5281$temp)));
                                    itemDuration = impactReactor.itemDuration;
                                }
                            }
                        }
                        if (itemDuration > 0.0f) {
                            void var8_23;
                            Consume[] consumeArray = t.block.nonOptionalConsumers;
                            int n = consumeArray.length;
                            boolean bl = false;
                            while (var8_23 < n) {
                                Consume c = consumeArray[var8_23];
                                if (c instanceof ConsumeItems) {
                                    ConsumeItems consumeItems = (ConsumeItems)c;
                                    for (ItemStack itemStack : consumeItems.items) {
                                        Item item = itemStack.item;
                                        this.items.put((Object)item, this.items.get((Object)item, 0.0f) - (float)itemStack.amount * 60.0f / itemDuration);
                                    }
                                } else if (c instanceof ConsumeLiquid) {
                                    ConsumeLiquid consumeLiquid = (ConsumeLiquid)c;
                                    Liquid liquid = consumeLiquid.liquid;
                                    this.liquids.put((Object)liquid, this.liquids.get((Object)liquid, 0.0f) - consumeLiquid.amount * 60.0f);
                                } else if (c instanceof ConsumeLiquids) {
                                    ConsumeLiquids consumeLiquids = (ConsumeLiquids)c;
                                    for (LiquidStack liquidStack : consumeLiquids.liquids) {
                                        Liquid liquid = liquidStack.liquid;
                                        this.liquids.put((Object)liquid, this.liquids.get((Object)liquid, 0.0f) - liquidStack.amount * 60.0f);
                                    }
                                }
                                ++var8_23;
                            }
                        }
                    }
                }
            }
        });
    }

    public ItemSeq requirements() {
        ItemSeq requirements = new ItemSeq();
        this.tiles.each(t -> {
            for (ItemStack stack : t.block.requirements) {
                requirements.add(stack.item, stack.amount);
            }
        });
        return requirements;
    }

    public boolean hasCore() {
        return this.tiles.contains(s -> s.block instanceof CoreBlock);
    }

    public CoreBlock findCore() {
        Stile tile = (Stile)this.tiles.find(s -> s.block instanceof CoreBlock);
        if (tile == null) {
            throw new IllegalArgumentException("Schematic is missing a core!");
        }
        return (CoreBlock)((Object)tile.block);
    }

    public String name() {
        return (String)this.tags.get((Object)"name", (Object)"unknown");
    }

    public String description() {
        return (String)this.tags.get((Object)"description", (Object)"");
    }

    public void save() {
        Vars.schematics.saveChanges(this);
    }

    public String getSteamID() {
        return (String)this.tags.get((Object)"steamid");
    }

    public void addSteamID(String id) {
        this.tags.put((Object)"steamid", (Object)id);
        this.save();
    }

    public void removeSteamID() {
        this.tags.remove((Object)"steamid");
        this.save();
    }

    public String steamTitle() {
        return this.name();
    }

    public String steamDescription() {
        return this.description();
    }

    public String steamTag() {
        return "schematic";
    }

    public Fi createSteamFolder(String id) {
        Fi directory = Vars.tmpDirectory.child("schematic_" + id).child("schematic.msch");
        this.file.copyTo(directory);
        return directory;
    }

    public Fi createSteamPreview(String id) {
        Fi preview = Vars.tmpDirectory.child("schematic_preview_" + id + ".png");
        Vars.schematics.savePreview(this, preview);
        return preview;
    }

    @Override
    public int compareTo(Schematic schematic) {
        return this.name().compareTo(schematic.name());
    }

    public static class Stile {
        public Block block;
        public short x;
        public short y;
        public Object config;
        public byte rotation;

        public Stile(Block block, int x, int y, Object config, byte rotation) {
            this.block = block;
            this.x = (short)x;
            this.y = (short)y;
            this.config = config;
            this.rotation = rotation;
        }

        public Stile() {
            this.block = Blocks.air;
        }

        public Stile set(Stile other) {
            this.block = other.block;
            this.x = other.x;
            this.y = other.y;
            this.config = other.config;
            this.rotation = other.rotation;
            return this;
        }

        public Stile copy() {
            return new Stile(this.block, this.x, this.y, this.config, this.rotation);
        }
    }
}

