/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.ScissorStack;
import arc.input.GestureDetector;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.event.EventListener;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Scl;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.editor.EditorTool;
import mindustry.editor.MapEditor;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.ui.GridImage;

public class MapView
extends Element
implements GestureDetector.GestureListener {
    EditorTool tool = Vars.mobile ? EditorTool.zoom : EditorTool.pencil;
    private float offsetx;
    private float offsety;
    private float zoom = 1.0f;
    private boolean grid = false;
    private GridImage image = new GridImage(0, 0);
    private Vec2 vec = new Vec2();
    private Rect rect = new Rect();
    private Vec2[][] brushPolygons = new Vec2[MapEditor.brushSizes.length][0];
    boolean drawing;
    int lastx;
    int lasty;
    int startx;
    int starty;
    float mousex;
    float mousey;
    EditorTool lastTool;

    public MapView() {
        for (int i = 0; i < MapEditor.brushSizes.length; ++i) {
            float size = MapEditor.brushSizes[i];
            float mod = size % 1.0f;
            this.brushPolygons[i] = Geometry.pixelCircle((float)size, (index, x, y) -> Mathf.dst((float)x, (float)y, (float)(index - mod), (float)(index - mod)) <= size - 0.5f);
        }
        Core.input.getInputProcessors().insert(0, (Object)new GestureDetector(20.0f, 0.5f, 2.0f, 0.15f, (GestureDetector.GestureListener)this));
        this.touchable = Touchable.enabled;
        Point2 firstTouch = new Point2();
        this.addListener((EventListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public EditorTool getTool() {
        return this.tool;
    }

    public void setTool(EditorTool tool) {
        this.tool = tool;
    }

    public boolean isGrid() {
        return this.grid;
    }

    public void setGrid(boolean grid) {
        this.grid = grid;
    }

    public void center() {
        this.offsety = 0.0f;
        this.offsetx = 0.0f;
    }

    public void act(float delta) {
        super.act(delta);
        if (Core.scene.getKeyboardFocus() == null || !Core.scene.hasField() && !Core.input.keyDown(KeyCode.controlLeft)) {
            float ax = Core.input.axis(Binding.moveX);
            float ay = Core.input.axis(Binding.moveY);
            this.offsetx -= ax * 15.0f * Time.delta / this.zoom;
            this.offsety -= ay * 15.0f * Time.delta / this.zoom;
        }
        if (Core.input.keyTap(KeyCode.shiftLeft) || Core.input.keyTap(KeyCode.altLeft)) {
            this.lastTool = this.tool;
            this.tool = EditorTool.pick;
        }
        if ((Core.input.keyRelease(KeyCode.shiftLeft) || Core.input.keyRelease(KeyCode.altLeft)) && this.lastTool != null) {
            this.tool = this.lastTool;
            this.lastTool = null;
        }
        if (Core.scene.getScrollFocus() != this) {
            return;
        }
        this.zoom += Core.input.axis(Binding.zoom) / 10.0f * this.zoom;
        this.clampZoom();
    }

    private void clampZoom() {
        this.zoom = Mathf.clamp((float)this.zoom, (float)0.2f, (float)20.0f);
    }

    public Point2 project(float x, float y) {
        float ratio = 1.0f / ((float)Vars.editor.width() / (float)Vars.editor.height());
        float size = Math.min(this.width, this.height);
        float sclwidth = size * this.zoom;
        float sclheight = size * this.zoom * ratio;
        x = (x - this.getWidth() / 2.0f + sclwidth / 2.0f - this.offsetx * this.zoom) / sclwidth * (float)Vars.editor.width();
        y = (y - this.getHeight() / 2.0f + sclheight / 2.0f - this.offsety * this.zoom) / sclheight * (float)Vars.editor.height();
        if (Vars.editor.drawBlock.size % 2 == 0 && this.tool != EditorTool.eraser) {
            return Tmp.p1.set((int)(x - 0.5f), (int)(y - 0.5f));
        }
        return Tmp.p1.set((int)x, (int)y);
    }

    private Vec2 unproject(int x, int y) {
        float ratio = 1.0f / ((float)Vars.editor.width() / (float)Vars.editor.height());
        float size = Math.min(this.width, this.height);
        float sclwidth = size * this.zoom;
        float sclheight = size * this.zoom * ratio;
        float px = (float)x / (float)Vars.editor.width() * sclwidth + this.offsetx * this.zoom - sclwidth / 2.0f + this.getWidth() / 2.0f;
        float py = (float)y / (float)Vars.editor.height() * sclheight + this.offsety * this.zoom - sclheight / 2.0f + this.getHeight() / 2.0f;
        return this.vec.set(px, py);
    }

    public void draw() {
        float ratio = 1.0f / ((float)Vars.editor.width() / (float)Vars.editor.height());
        float size = Math.min(this.width, this.height);
        float sclwidth = size * this.zoom;
        float sclheight = size * this.zoom * ratio;
        float centerx = this.x + this.width / 2.0f + this.offsetx * this.zoom;
        float centery = this.y + this.height / 2.0f + this.offsety * this.zoom;
        this.image.setImageSize(Vars.editor.width(), Vars.editor.height());
        if (!ScissorStack.push((Rect)this.rect.set(this.x + Core.scene.marginLeft, this.y + Core.scene.marginBottom, this.width, this.height))) {
            return;
        }
        Draw.color((Color)Pal.remove);
        Lines.stroke(2.0f);
        Lines.rect(centerx - sclwidth / 2.0f - 1.0f, centery - sclheight / 2.0f - 1.0f, sclwidth + 2.0f, sclheight + 2.0f);
        Vars.editor.renderer.draw(centerx - sclwidth / 2.0f + Core.scene.marginLeft, centery - sclheight / 2.0f + Core.scene.marginBottom, sclwidth, sclheight);
        Draw.reset();
        if (this.grid) {
            Draw.color((Color)Color.gray);
            this.image.setBounds(centerx - sclwidth / 2.0f, centery - sclheight / 2.0f, sclwidth, sclheight);
            this.image.interval = 1;
            this.image.draw();
            Draw.color((Color)Color.cyan, (float)0.5f);
            this.image.interval = Vars.editor.interval;
            this.image.draw();
            Lines.stroke(2.0f);
            Draw.color((Color)Pal.bulletYellowBack);
            Lines.line(centerx - sclwidth / 2.0f, centery - sclheight / 4.0f, centerx + sclwidth / 2.0f, centery - sclheight / 4.0f);
            Lines.line(centerx - sclwidth / 4.0f, centery - sclheight / 2.0f, centerx - sclwidth / 4.0f, centery + sclheight / 2.0f);
            Lines.line(centerx - sclwidth / 2.0f, centery + sclheight / 4.0f, centerx + sclwidth / 2.0f, centery + sclheight / 4.0f);
            Lines.line(centerx + sclwidth / 4.0f, centery - sclheight / 2.0f, centerx + sclwidth / 4.0f, centery + sclheight / 2.0f);
            Lines.stroke(3.0f);
            Draw.color((Color)Pal.accent);
            Lines.line(centerx - sclwidth / 2.0f, centery, centerx + sclwidth / 2.0f, centery);
            Lines.line(centerx, centery - sclheight / 2.0f, centerx, centery + sclheight / 2.0f);
            float diagonal = Math.max(sclwidth / 2.0f, sclheight / 2.0f);
            Draw.color((Color)Color.orange, (float)0.5f);
            Lines.line(centerx - diagonal, centery - diagonal, centerx + diagonal, centery + diagonal);
            Lines.line(centerx - diagonal, centery + diagonal, centerx + diagonal, centery - diagonal);
            Draw.reset();
        }
        Vec2[] brush = null;
        for (int i = 0; i < MapEditor.brushSizes.length; ++i) {
            if (Vars.editor.brushSize != MapEditor.brushSizes[i]) continue;
            brush = this.brushPolygons[i];
            break;
        }
        if (brush == null) {
            float bSize = Vars.editor.brushSize;
            float mod = bSize % 1.0f;
            brush = Geometry.pixelCircle((float)bSize, (index, x, y) -> Mathf.dst((float)x, (float)y, (float)(index - mod), (float)(index - mod)) <= bSize - 0.5f);
        }
        float scaling = this.zoom * Math.min(this.width, this.height) / (float)Vars.editor.width();
        Draw.color((Color)Pal.accent);
        Lines.stroke(Scl.scl((float)2.0f));
        if (!(Vars.editor.drawBlock.isMultiblock() && this.tool != EditorTool.eraser || this.tool == EditorTool.fill)) {
            if (this.tool == EditorTool.line && this.drawing) {
                Vec2 v1 = this.unproject(this.startx, this.starty).add(this.x, this.y);
                float sx = v1.x;
                float sy = v1.y;
                Vec2 v2 = this.unproject(this.lastx, this.lasty).add(this.x, this.y);
                Lines.poly(brush, sx, sy, scaling);
                Lines.poly(brush, v2.x, v2.y, scaling);
            }
            if ((this.tool.edit || this.tool == EditorTool.line && !this.drawing) && (!Vars.mobile || this.drawing)) {
                Point2 p = this.project(this.mousex, this.mousey);
                Vec2 v = this.unproject(p.x, p.y).add(this.x, this.y);
                if (this.tool == EditorTool.pencil && (this.tool.mode == 1 || this.tool.mode == 4)) {
                    int brushSize = (int)(Vars.editor.brushSize * (float)(this.tool.mode == 1 ? 2 : 1));
                    float corr = brushSize % 2 == 0 ? 0.0f : scaling / 2.0f;
                    Lines.square(v.x + corr, v.y + corr, scaling * (float)brushSize / 2.0f);
                } else {
                    Lines.poly(brush, v.x, v.y, scaling);
                }
            }
        } else if (!(!this.tool.edit && this.tool != EditorTool.line || Vars.mobile && !this.drawing)) {
            Point2 p = this.project(this.mousex, this.mousey);
            Vec2 v = this.unproject(p.x, p.y).add(this.x, this.y);
            float offset = Vars.editor.drawBlock.size % 2 == 0 ? scaling / 2.0f : 0.0f;
            Lines.square(v.x + scaling / 2.0f + offset, v.y + scaling / 2.0f + offset, scaling * (float)Vars.editor.drawBlock.size / 2.0f);
        }
        Draw.color((Color)Pal.accent);
        Lines.stroke(Scl.scl((float)3.0f));
        Lines.rect(this.x, this.y, this.width, this.height);
        Draw.reset();
        ScissorStack.pop();
    }

    private boolean active() {
        return Core.scene != null && Core.scene.getKeyboardFocus() != null && Core.scene.getKeyboardFocus().isDescendantOf((Element)Vars.ui.editor) && Vars.ui.editor.isShown() && this.tool == EditorTool.zoom && Core.scene.getHoverElement() == this;
    }

    public boolean pan(float x, float y, float deltaX, float deltaY) {
        if (!this.active()) {
            return false;
        }
        this.offsetx += deltaX / this.zoom;
        this.offsety += deltaY / this.zoom;
        return false;
    }

    public boolean zoom(float initialDistance, float distance) {
        if (!this.active()) {
            return false;
        }
        float nzoom = distance - initialDistance;
        this.zoom += nzoom / 10000.0f / Scl.scl((float)1.0f) * this.zoom;
        this.clampZoom();
        return false;
    }

    public boolean pinch(Vec2 initialPointer1, Vec2 initialPointer2, Vec2 pointer1, Vec2 pointer2) {
        return false;
    }

    public void pinchStop() {
    }
}

