/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.files.Fi;
import arc.func.Boolf;
import arc.func.Cons;
import arc.graphics.Pixmap;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.struct.StringMap;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.editor.DrawOperation;
import mindustry.editor.EditorRenderer;
import mindustry.editor.EditorTile;
import mindustry.editor.OperationStack;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.TileOp;
import mindustry.gen.TileOpData;
import mindustry.io.MapIO;
import mindustry.maps.Map;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.Tiles;
import mindustry.world.WorldContext;
import mindustry.world.blocks.environment.OverlayFloor;

public class MapEditor {
    public static final float[] brushSizes = new float[]{1.0f, 1.5f, 2.0f, 3.0f, 4.0f, 5.0f, 9.0f, 15.0f, 20.0f};
    public StringMap tags = new StringMap();
    public EditorRenderer renderer = new EditorRenderer();
    private final Context context = new Context();
    private OperationStack stack = new OperationStack();
    private DrawOperation currentOp;
    private boolean loading;
    public float brushSize = 1.0f;
    public int interval = 25;
    public int rotation;
    public boolean diamMode;
    public Block drawBlock = Blocks.stone;
    public Team drawTeam = Team.sharded;
    public boolean showTerrain = true;
    public boolean showFloor = true;
    public boolean showBuildings = true;

    public boolean isLoading() {
        return this.loading;
    }

    public void beginEdit(int width, int height) {
        this.reset();
        this.loading = true;
        this.createTiles(width, height);
        this.renderer.resize(width, height);
        this.loading = false;
    }

    public void beginEdit(Map map) {
        this.reset();
        this.loading = true;
        this.tags.putAll((ObjectMap)map.tags);
        if (map.file.parent().parent().name().equals("1127400") && Vars.steam) {
            this.tags.put((Object)"steamid", (Object)map.file.parent().name());
        }
        this.load(() -> MapIO.loadMap((Map)map, (WorldContext)this.context));
        this.renderer.resize(this.width(), this.height());
        this.loading = false;
    }

    public void beginEdit(Pixmap pixmap) {
        this.reset();
        this.createTiles(pixmap.width, pixmap.height);
        this.load(() -> MapIO.readImage((Pixmap)pixmap, (Tiles)this.tiles()));
        this.renderer.resize(this.width(), this.height());
    }

    public void updateRenderer() {
        Tiles tiles = Vars.world.tiles;
        Seq builds = new Seq();
        for (int i = 0; i < tiles.width * tiles.height; ++i) {
            Tile tile = tiles.geti(i);
            Building build = tile.build;
            if (build != null && tile.isCenter()) {
                builds.add((Object)build);
            }
            tiles.seti(i, (Tile)new EditorTile((int)tile.x, (int)tile.y, (int)tile.floorID(), (int)tile.overlayID(), (int)(build == null ? tile.blockID() : (short)0)));
        }
        for (Building build : builds) {
            tiles.get(build.tileX(), build.tileY()).setBlock(build.block, build.team, build.rotation, () -> build);
        }
        this.renderer.resize(this.width(), this.height());
    }

    public void load(Runnable r) {
        this.loading = true;
        r.run();
        this.loading = false;
    }

    private void createTiles(int width, int height) {
        Tiles tiles = Vars.world.resize(width, height);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                tiles.set(x, y, (Tile)new EditorTile(x, y, (int)Blocks.stone.id, 0, 0));
            }
        }
    }

    public Map createMap(Fi file) {
        return new Map(file, this.width(), this.height(), new StringMap((ObjectMap)this.tags), true);
    }

    private void reset() {
        this.clearOp();
        this.brushSize = 1.0f;
        this.drawBlock = Blocks.stone;
        this.tags = new StringMap();
    }

    public Tiles tiles() {
        return Vars.world.tiles;
    }

    public Tile tile(int x, int y) {
        return Vars.world.rawTile(x, y);
    }

    public int width() {
        return Vars.world.width();
    }

    public int height() {
        return Vars.world.height();
    }

    public void drawBlocksReplace(int x, int y) {
        this.drawBlocks(x, y, (Boolf<Tile>)((Boolf)tile -> tile.block() != Blocks.air || this.drawBlock.isFloor()));
    }

    public void drawBlocks(int x, int y) {
        this.drawBlocks(x, y, false, false, (Boolf<Tile>)((Boolf)tile -> true));
    }

    public void drawBlocks(int x, int y, Boolf<Tile> tester) {
        this.drawBlocks(x, y, false, false, tester);
    }

    public void drawBlocks(int x, int y, boolean square, boolean forceOverlay, Boolf<Tile> tester) {
        if (this.drawBlock.isMultiblock()) {
            if (!this.hasOverlap(x = Mathf.clamp((int)x, (int)((this.drawBlock.size - 1) / 2), (int)(this.width() - this.drawBlock.size / 2 - 1)), y = Mathf.clamp((int)y, (int)((this.drawBlock.size - 1) / 2), (int)(this.height() - this.drawBlock.size / 2 - 1)))) {
                this.tile(x, y).setBlock(this.drawBlock, this.drawTeam, this.rotation);
                this.addTileOp(TileOp.get((int)((short)x), (int)((short)y), (int)3, (int)((byte)this.drawTeam.id)));
            }
        } else {
            boolean isFloor = this.drawBlock.isFloor() && this.drawBlock != Blocks.air;
            Cons drawer = tile -> {
                if (!tester.get(tile)) {
                    return;
                }
                boolean changed = false;
                boolean didDataOp = false;
                int oldData1 = 0;
                int oldData2 = 0;
                if (this.drawBlock.saveData || tile.shouldSaveData()) {
                    this.addTileOp(TileOp.get((int)tile.x, (int)tile.y, (int)5, (int)TileOpData.get((byte)tile.data, (byte)tile.floorData, (byte)tile.overlayData)));
                    this.addTileOp(TileOp.get((int)tile.x, (int)tile.y, (int)6, (int)tile.extraData));
                    oldData1 = TileOpData.get((byte)tile.data, (byte)tile.floorData, (byte)tile.overlayData);
                    oldData2 = tile.extraData;
                    didDataOp = true;
                }
                int preDataOps = this.ops();
                if (isFloor) {
                    if (forceOverlay) {
                        tile.setOverlay((Block)this.drawBlock.asFloor());
                        changed = true;
                    } else if (!this.drawBlock.asFloor().wallOre || tile.block().solid) {
                        tile.setFloor(this.drawBlock.asFloor());
                        if (!(tile.overlay() instanceof OverlayFloor) && !this.drawBlock.asFloor().supportsOverlay) {
                            tile.setOverlay(Blocks.air);
                        }
                        changed = true;
                    }
                } else if (!tile.block().isMultiblock() || this.drawBlock.isMultiblock()) {
                    if (this.drawBlock.rotate && tile.build != null && tile.build.rotation != this.rotation) {
                        this.addTileOp(TileOp.get((int)tile.x, (int)tile.y, (int)2, (int)((byte)this.rotation)));
                    }
                    tile.setBlock(this.drawBlock, this.drawTeam, this.rotation);
                    boolean bl = changed = !this.drawBlock.synthetic();
                    if (this.drawBlock.synthetic()) {
                        this.addTileOp(TileOp.get((int)tile.x, (int)tile.y, (int)3, (int)((byte)this.drawTeam.id)));
                    }
                }
                if (changed && this.drawBlock.saveConfig) {
                    this.drawBlock.placeEnded((Tile)tile, null, Vars.editor.rotation, this.drawBlock.lastConfig);
                    this.renderer.updateStatic((int)tile.x, (int)tile.y);
                }
                if (didDataOp && this.ops() == preDataOps && oldData1 == TileOpData.get((byte)tile.data, (byte)tile.floorData, (byte)tile.overlayData) && oldData2 == tile.extraData) {
                    this.removeLastOps(2);
                }
            };
            if (square) {
                this.drawSquare(x, y, (Cons<Tile>)drawer);
            } else {
                this.drawCircle(x, y, (Cons<Tile>)drawer);
            }
        }
    }

    boolean hasOverlap(int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        if (tile != null && tile.isCenter() && tile.block() != this.drawBlock && tile.block().size == this.drawBlock.size && tile.x == x && tile.y == y) {
            return false;
        }
        int offsetx = -(this.drawBlock.size - 1) / 2;
        int offsety = -(this.drawBlock.size - 1) / 2;
        for (int dx = 0; dx < this.drawBlock.size; ++dx) {
            for (int dy = 0; dy < this.drawBlock.size; ++dy) {
                int worldx = dx + offsetx + x;
                int worldy = dy + offsety + y;
                Tile other = Vars.world.tile(worldx, worldy);
                if (other == null || !other.block().isMultiblock()) continue;
                return true;
            }
        }
        return false;
    }

    public void addCliffs() {
        for (Tile tile : Vars.world.tiles) {
            if (!tile.block().isStatic() || tile.block() == Blocks.cliff) continue;
            int rotation = 0;
            for (int i = 0; i < 8; ++i) {
                Tile other = Vars.world.tiles.get(tile.x + Geometry.d8[i].x, tile.y + Geometry.d8[i].y);
                if (other == null || other.block().isStatic()) continue;
                rotation |= 1 << i;
            }
            if (rotation != 0) {
                tile.setBlock(Blocks.cliff);
            }
            tile.data = (byte)rotation;
        }
        for (Tile tile : Vars.world.tiles) {
            if (tile.block() == Blocks.cliff || !tile.block().isStatic()) continue;
            tile.setBlock(Blocks.air);
        }
        Vars.editor.flushOp();
    }

    public void drawCircle(int x, int y, Cons<Tile> drawer) {
        int clamped = (int)this.brushSize;
        for (int rx = -clamped; rx <= clamped; ++rx) {
            for (int ry = -clamped; ry <= clamped; ++ry) {
                if (!Mathf.within((float)rx, (float)ry, (float)(this.brushSize - 0.5f + 1.0E-4f))) continue;
                int wx = x + rx;
                int wy = y + ry;
                if (wx < 0 || wy < 0 || wx >= this.width() || wy >= this.height()) continue;
                drawer.get((Object)this.tile(wx, wy));
            }
        }
    }

    public void drawSquare(int x, int y, Cons<Tile> drawer) {
        int clamped = (int)(this.brushSize * (float)(this.diamMode ? 1 : 2)) - 1;
        this.diamMode = false;
        for (int rx = -clamped / 2; rx <= clamped - clamped / 2; ++rx) {
            for (int ry = -clamped / 2; ry <= clamped - clamped / 2; ++ry) {
                int wx = x + rx;
                int wy = y + ry;
                if (wx < 0 || wy < 0 || wx >= this.width() || wy >= this.height()) continue;
                drawer.get((Object)this.tile(wx, wy));
            }
        }
    }

    public void resize(int width, int height, int shiftX, int shiftY) {
        this.clearOp();
        Tiles previous = Vars.world.tiles;
        int offsetX = (this.width() - width) / 2 - shiftX;
        int offsetY = (this.height() - height) / 2 - shiftY;
        this.loading = true;
        Vars.world.clearBuildings();
        Tiles tiles = Vars.world.tiles = new Tiles(width, height);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int px = offsetX + x;
                int py = offsetY + y;
                if (previous.in(px, py)) {
                    Object out;
                    tiles.set(x, y, previous.getn(px, py));
                    Tile tile = tiles.getn(x, y);
                    Object config = null;
                    if (tile.build != null && tile.isCenter()) {
                        config = tile.build.config();
                    }
                    tile.x = (short)x;
                    tile.y = (short)y;
                    if (tile.build == null || !tile.isCenter()) continue;
                    tile.build.x = (float)(x * 8) + tile.block().offset;
                    tile.build.y = (float)(y * 8) + tile.block().offset;
                    if (config == null || (out = BuildPlan.pointConfig((Block)tile.block(), (Object)config, p -> {
                        if (!tile.build.block.ignoreResizeConfig) {
                            p.sub(offsetX, offsetY);
                        }
                    })) == config) continue;
                    boolean prev = Vars.state.rules.editor;
                    Vars.state.rules.editor = true;
                    tile.build.configureAny(out);
                    Vars.state.rules.editor = prev;
                    continue;
                }
                tiles.set(x, y, (Tile)new EditorTile(x, y, (int)Blocks.stone.id, 0, 0));
            }
        }
        this.renderer.resize(width, height);
        this.loading = false;
    }

    public void clearOp() {
        this.stack.clear();
    }

    public void undo() {
        if (this.stack.canUndo()) {
            this.stack.undo();
        }
    }

    public void redo() {
        if (this.stack.canRedo()) {
            this.stack.redo();
        }
    }

    public boolean canUndo() {
        return this.stack.canUndo();
    }

    public boolean canRedo() {
        return this.stack.canRedo();
    }

    public void flushOp() {
        if (this.currentOp == null || this.currentOp.isEmpty()) {
            return;
        }
        this.stack.add(this.currentOp);
        this.currentOp = null;
    }

    public void addTileOp(long data) {
        if (this.loading) {
            return;
        }
        if (this.currentOp == null) {
            this.currentOp = new DrawOperation();
        }
        this.currentOp.addOperation(data);
        this.renderer.updateStatic(TileOp.x((long)data), TileOp.y((long)data));
    }

    public int ops() {
        if (this.currentOp == null) {
            return 0;
        }
        return this.currentOp.size();
    }

    public void removeLastOps(int amount) {
        if (this.currentOp == null || this.loading) {
            return;
        }
        this.currentOp.remove(amount);
    }

    class Context
    implements WorldContext {
        Context() {
        }

        public Tile tile(int index) {
            return Vars.world.tiles.geti(index);
        }

        public void resize(int width, int height) {
            Vars.world.resize(width, height);
        }

        public Tile create(int x, int y, int floorID, int overlayID, int wallID) {
            EditorTile tile = new EditorTile(x, y, floorID, overlayID, wallID);
            MapEditor.this.tiles().set(x, y, (Tile)tile);
            return tile;
        }

        public boolean isGenerating() {
            return Vars.world.isGenerating();
        }

        public void begin() {
            Vars.world.beginMapLoad();
        }

        public void end() {
            Vars.world.endMapLoad();
        }
    }
}

