/*
 * Decompiled with CFR 0.152.
 */
package mindustry.desktop;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.Files;
import arc.backend.sdl.SdlApplication;
import arc.backend.sdl.SdlConfig;
import arc.backend.sdl.jni.SDL;
import arc.discord.DiscordRPC;
import arc.files.Fi;
import arc.func.Cons;
import arc.math.Rand;
import arc.profiling.GLProfiler;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.OS;
import arc.util.SharedLibraryLoader;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.Threads;
import arc.util.serialization.Base64Coder;
import com.codedisaster.steamworks.SteamAPI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import mindustry.ClientLauncher;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.desktop.steam.SNet;
import mindustry.desktop.steam.SStats;
import mindustry.desktop.steam.SUser;
import mindustry.desktop.steam.SVars;
import mindustry.desktop.steam.SWorkshop;
import mindustry.game.EventType;
import mindustry.gen.Groups;
import mindustry.graphics.IntelGpuCheck;
import mindustry.mod.Mods;
import mindustry.net.ArcNetProvider;
import mindustry.net.CrashHandler;
import mindustry.net.Net;
import mindustry.service.GameService;
import mindustry.type.Publishable;

public class DesktopLauncher
extends ClientLauncher {
    public static final long discordID = 610508934456934412L;
    public final String[] args;
    boolean useDiscord = !OS.hasProp((String)"nodiscord");
    boolean loadError = false;
    Throwable steamError;

    public static void main(final String[] arg) {
        try {
            Vars.loadLogger();
            new SdlApplication((ApplicationListener)new DesktopLauncher(arg), new SdlConfig(){
                {
                    this.title = "Mindustry";
                    this.maximized = true;
                    this.coreProfile = true;
                    this.width = 900;
                    this.height = 700;
                    if (IntelGpuCheck.wasIntel()) {
                        this.allowGl30 = false;
                        this.coreProfile = false;
                        this.glVersions = new int[][]{{2, 1}, {2, 0}};
                    } else {
                        this.glVersions = OS.isMac ? (Object)new int[][]{{4, 1}, {3, 2}, {2, 1}, {2, 0}} : (int[][])new int[][]{{4, 6}, {4, 5}, {4, 4}, {4, 1}, {3, 3}, {3, 2}, {3, 1}, {2, 1}, {2, 0}};
                    }
                    block24: for (int i = 0; i < arg.length; ++i) {
                        String name;
                        if (arg[i].charAt(0) != '-') continue;
                        switch (name = arg[i].substring(1)) {
                            case "width": {
                                this.width = Strings.parseInt((String)arg[i + 1], (int)this.width);
                                continue block24;
                            }
                            case "height": {
                                this.height = Strings.parseInt((String)arg[i + 1], (int)this.height);
                                continue block24;
                            }
                            case "gl": {
                                String[] split;
                                String str = arg[i + 1];
                                if (str.contains(".") && (split = str.split("\\.")).length == 2 && Strings.canParsePositiveInt((String)split[0]) && Strings.canParsePositiveInt((String)split[1])) {
                                    this.glVersions = new int[][]{{Strings.parseInt((String)split[0]), Strings.parseInt((String)split[1])}};
                                    this.allowGl30 = true;
                                    continue block24;
                                }
                                Log.err((String)"Invalid GL version format string: '@'. GL version must be of the form <major>.<minor>", (Object[])new Object[]{str});
                                continue block24;
                            }
                            case "coreGl": {
                                this.coreProfile = true;
                                continue block24;
                            }
                            case "compatibilityGl": {
                                this.coreProfile = false;
                                continue block24;
                            }
                            case "antialias": {
                                this.samples = 16;
                                continue block24;
                            }
                            case "debug": {
                                Log.level = Log.LogLevel.debug;
                                continue block24;
                            }
                            case "maximized": {
                                this.maximized = Boolean.parseBoolean(arg[i + 1]);
                                continue block24;
                            }
                            case "testMobile": {
                                Vars.testMobile = true;
                                continue block24;
                            }
                            case "gltrace": {
                                Events.on(EventType.ClientCreateEvent.class, e -> {
                                    final GLProfiler profiler = new GLProfiler(Core.graphics);
                                    profiler.enable();
                                    Core.app.addListener(new ApplicationListener(){

                                        public void update() {
                                            profiler.reset();
                                        }
                                    });
                                });
                            }
                        }
                    }
                    this.setWindowIcon(Files.FileType.internal, new String[]{"icon.png"});
                }
            });
        }
        catch (Throwable e) {
            DesktopLauncher.handleCrash(e);
        }
    }

    public DesktopLauncher(String[] args) {
        this.args = args;
        Version.init();
        String steamJar = null;
        if (!OS.isAndroid && !OS.isIos && (new Fi("saves").exists() || new Fi("steam_appid.txt").exists())) {
            if (new Fi("addon_steam.jar").exists()) {
                steamJar = "addon_steam.jar";
                Version.modifier = "steam";
            } else if (new Fi("steamworks4j.dll", Files.FileType.classpath).exists()) {
                Version.modifier = "steam";
            }
        }
        boolean useSteam = Version.modifier.contains("steam");
        if (this.useDiscord) {
            Threads.daemon(() -> {
                try {
                    DiscordRPC.connect((long)610508934456934412L);
                    Log.info((Object)"Initialized Discord rich presence.");
                    Runtime.getRuntime().addShutdownHook(new Thread(DiscordRPC::close));
                }
                catch (DiscordRPC.NoDiscordClientException none) {
                    this.useDiscord = false;
                }
                catch (Throwable t) {
                    this.useDiscord = false;
                    Log.warn((String)"Failed to initialize Discord RPC - you are likely using a JVM <16.", (Object[])new Object[0]);
                }
            });
        }
        if (useSteam) {
            Events.on(EventType.ClientLoadEvent.class, event -> {
                if (this.steamError != null) {
                    Core.app.post(() -> Core.app.post(() -> Core.app.post(() -> Vars.ui.showErrorMessage(Core.bundle.format("steam.error", new Object[]{this.steamError.getMessage() == null ? this.steamError.getClass().getSimpleName() : this.steamError.getClass().getSimpleName() + ": " + this.steamError.getMessage()})))));
                }
            });
            try {
                new SharedLibraryLoader(steamJar).load("steam_api");
                new SharedLibraryLoader(steamJar).load("steamworks4j");
                SteamAPI.skipLoadLibraries();
                if (!SteamAPI.init()) {
                    this.loadError = true;
                    Log.err((String)"Steam client not running.", (Object[])new Object[0]);
                } else {
                    this.initSteam(args);
                    Vars.steam = true;
                }
                if (SteamAPI.restartAppIfNecessary((int)1127400)) {
                    System.exit(0);
                }
            }
            catch (Throwable e) {
                Vars.steam = false;
                Log.err((String)"Failed to load Steam native libraries.", (Object[])new Object[0]);
                this.logSteamError(e);
            }
        }
    }

    void logSteamError(Throwable e) {
        this.steamError = e;
        this.loadError = true;
        Log.err((Throwable)e);
        try (FileOutputStream s = new FileOutputStream("steam-error-log-" + System.nanoTime() + ".txt");){
            String log = Strings.neatError((Throwable)e);
            ((OutputStream)s).write(log.getBytes());
        }
        catch (Exception e2) {
            Log.err((Throwable)e2);
        }
    }

    void initSteam(String[] args) {
        SVars.net = new SNet((Net.NetProvider)new ArcNetProvider());
        SVars.stats = new SStats();
        SVars.workshop = new SWorkshop();
        SVars.user = new SUser();
        boolean[] isShutdown = new boolean[]{false};
        Vars.service = new GameService(){

            public boolean enabled() {
                return true;
            }

            public void completeAchievement(String name) {
                SVars.stats.stats.setAchievement(name);
                SVars.stats.stats.storeStats();
            }

            public void clearAchievement(String name) {
                SVars.stats.stats.clearAchievement(name);
                SVars.stats.stats.storeStats();
            }

            public boolean isAchieved(String name) {
                return SVars.stats.stats.isAchieved(name, false);
            }

            public int getStat(String name, int def) {
                return SVars.stats.stats.getStatI(name, def);
            }

            public void setStat(String name, int amount) {
                SVars.stats.stats.setStatI(name, amount);
            }

            public void storeStats() {
                SVars.stats.onUpdate();
            }
        };
        Events.on(EventType.ClientLoadEvent.class, event -> {
            Core.settings.defaults(new Object[]{"name", SVars.net.friends.getPersonaName()});
            if (Vars.player.name.isEmpty()) {
                Vars.player.name = SVars.net.friends.getPersonaName();
                Core.settings.put("name", (Object)Vars.player.name);
            }
            Vars.steamPlayerName = SVars.net.friends.getPersonaName();
            Core.app.addListener(new ApplicationListener(){

                public void update() {
                    if (SteamAPI.isSteamRunning()) {
                        SteamAPI.runCallbacks();
                    }
                }
            });
            Core.app.post(() -> {
                if (args.length >= 2 && args[0].equals("+connect_lobby")) {
                    try {
                        long id = Long.parseLong(args[1]);
                        Vars.ui.join.connect("steam:" + id, 6567);
                    }
                    catch (Exception e) {
                        Log.err((String)"Failed to parse steam lobby ID: @", (Object[])new Object[]{e.getMessage()});
                        e.printStackTrace();
                    }
                }
            });
        });
        Events.on(EventType.DisposeEvent.class, event -> {
            SteamAPI.shutdown();
            isShutdown[0] = true;
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!isShutdown[0]) {
                SteamAPI.shutdown();
            }
        }));
    }

    static void handleCrash(Throwable e) {
        boolean badGPU = false;
        String finalMessage = Strings.getFinalMessage((Throwable)e);
        String total = Strings.getCauses((Throwable)e).toString();
        if (total.contains("Couldn't create window") || total.contains("OpenGL 2.0 or higher") || total.toLowerCase().contains("pixel format") || total.contains("GLEW") || total.contains("unsupported combination of formats")) {
            DesktopLauncher.message(total.contains("Couldn't create window") ? "A graphics initialization error has occured! Try to update your graphics drivers:\n" + finalMessage : "Your graphics card does not support the right OpenGL features.\nTry to update your graphics drivers. If this doesn't work, your computer may not support Mindustry.\n\nFull message: " + finalMessage);
            badGPU = true;
        }
        boolean fbgp = badGPU;
        Mods.LoadedMod cause = CrashHandler.getModCause(e);
        String causeString = cause == null ? (Structs.contains((Object[])e.getStackTrace(), st -> st.getClassName().contains("rhino.gen.")) ? "A mod or script has caused Mindustry to crash.\nConsider disabling your mods if the issue persists.\n" : "Mindustry has crashed.") : "'" + cause.meta.displayName + "' (" + cause.name + ") has caused Mindustry to crash.\nConsider disabling this mod if issues persist.\n";
        CrashHandler.handle(e, (Cons<File>)((Cons)file -> {
            Throwable fc = Strings.getFinalCause((Throwable)e);
            if (!fbgp) {
                DesktopLauncher.message(causeString + "\nThe logs have been saved in:\n" + file.getAbsolutePath() + "\n" + fc.getClass().getSimpleName().replace("Exception", "") + (fc.getMessage() == null ? "" : ":\n" + fc.getMessage()));
            }
        }));
    }

    public Seq<Fi> getWorkshopContent(Class<? extends Publishable> type) {
        return !Vars.steam ? super.getWorkshopContent(type) : SVars.workshop.getWorkshopFiles(type);
    }

    public void viewListing(Publishable pub) {
        SVars.workshop.viewListing(pub);
    }

    public void viewListingID(String id) {
        SVars.net.friends.activateGameOverlayToWebPage("steam://url/CommunityFilePage/" + id);
    }

    public Net.NetProvider getNet() {
        return Vars.steam ? SVars.net : new ArcNetProvider();
    }

    public void openWorkshop() {
        SVars.net.friends.activateGameOverlayToWebPage("https://steamcommunity.com/app/1127400/workshop/");
    }

    public void publish(Publishable pub) {
        SVars.workshop.publish(pub);
    }

    public void inviteFriends() {
        SVars.net.showFriendInvites();
    }

    public void updateLobby() {
        if (SVars.net != null) {
            SVars.net.updateLobby();
        }
    }

    public void updateRPC() {
        if (!this.useDiscord && !Vars.steam) {
            return;
        }
        boolean inGame = Vars.state.isGame();
        String gameMapWithWave = "Unknown Map";
        String gameMode = "";
        String gamePlayersSuffix = "";
        String uiState = "";
        if (inGame) {
            gameMapWithWave = Strings.capitalize((String)Strings.stripColors((CharSequence)Vars.state.map.name()));
            if (Vars.state.rules.waves) {
                gameMapWithWave = gameMapWithWave + " | Wave " + Vars.state.wave;
            }
            String string = Vars.state.rules.pvp ? "PvP" : (Vars.state.rules.attackMode ? "Attack" : (gameMode = Vars.state.rules.infiniteResources ? "Sandbox" : "Survival"));
            if (Vars.net.active() && Groups.player.size() > 1) {
                gamePlayersSuffix = " | " + Groups.player.size() + " Players";
            }
        } else {
            uiState = Vars.ui.editor != null && Vars.ui.editor.isShown() ? "In Editor" : (Vars.ui.planet != null && Vars.ui.planet.isShown() ? "In Launch Selection" : "In Menu");
        }
        if (this.useDiscord) {
            DiscordRPC.RichPresence presence = new DiscordRPC.RichPresence();
            if (inGame) {
                presence.state = gameMode + gamePlayersSuffix;
                presence.details = gameMapWithWave;
                if (Vars.state.rules.waves) {
                    presence.largeImageText = "Wave " + Vars.state.wave;
                }
            } else {
                presence.state = uiState;
            }
            presence.largeImageKey = "logo";
            try {
                DiscordRPC.send((DiscordRPC.RichPresence)presence);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Vars.steam) {
            SVars.net.friends.setRichPresence("steam_display", "#steam_status_raw");
            if (inGame) {
                SVars.net.friends.setRichPresence("steam_status", gameMapWithWave);
            } else {
                SVars.net.friends.setRichPresence("steam_status", uiState);
            }
        }
    }

    public String getUUID() {
        if (Vars.steam) {
            try {
                byte[] result = new byte[8];
                new Rand((long)SVars.user.user.getSteamID().getAccountID()).nextBytes(result);
                return new String(Base64Coder.encode((byte[])result));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.getUUID();
    }

    private static void message(String message) {
        SDL.SDL_ShowSimpleMessageBox((int)16, (String)"oh no", (String)message);
    }
}

