/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ctype;

import arc.Core;
import arc.Events;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.content.Planets;
import mindustry.content.TechTree;
import mindustry.ctype.MappableContent;
import mindustry.game.EventType;
import mindustry.graphics.Drawf;
import mindustry.graphics.MultiPacker;
import mindustry.mod.NoPatch;
import mindustry.type.ItemStack;
import mindustry.type.Planet;
import mindustry.ui.Fonts;
import mindustry.world.meta.Stats;
import mindustryX.VarsX;

public abstract class UnlockableContent
extends MappableContent {
    @NoPatch
    public Stats stats = new Stats();
    public String localizedName;
    @Nullable
    public String description;
    @Nullable
    public String details;
    public boolean alwaysUnlocked = false;
    public boolean inlineDescription = true;
    public boolean hideDetails = true;
    public boolean hideDatabase = false;
    public boolean generateIcons = true;
    public float selectionSize = 24.0f;
    public TextureRegion uiIcon;
    public TextureRegion fullIcon;
    public String fullOverride = "";
    public boolean allDatabaseTabs = false;
    public ObjectSet<Planet> shownPlanets = new ObjectSet();
    public ObjectSet<UnlockableContent> databaseTabs = new ObjectSet();
    @NoPatch
    @Nullable
    public TechTree.TechNode techNode;
    @NoPatch
    public Seq<TechTree.TechNode> techNodes = new Seq();
    @NoPatch
    protected boolean unlocked;

    public UnlockableContent(String name) {
        super(name);
        this.localizedName = Core.bundle.get(this.getContentType() + "." + this.name + ".name", this.name);
        this.description = Core.bundle.getOrNull(this.getContentType() + "." + this.name + ".description");
        this.details = Core.bundle.getOrNull(this.getContentType() + "." + this.name + ".details");
        this.unlocked = Core.settings != null && Core.settings.getBool(this.name + "-unlocked", false);
    }

    public void postInit() {
        super.postInit();
        this.databaseTabs.addAll(this.shownPlanets);
    }

    public void loadIcon() {
        this.fullIcon = Core.atlas.find(this.fullOverride == null ? "" : this.fullOverride, Core.atlas.find(this.getContentType().name() + "-" + this.name + "-full", Core.atlas.find(this.name + "-full", Core.atlas.find(this.name, Core.atlas.find(this.getContentType().name() + "-" + this.name, (TextureRegion)Core.atlas.find(this.name + "1"))))));
        this.uiIcon = Core.atlas.find(this.getContentType().name() + "-" + this.name + "-ui", this.fullIcon);
    }

    public void afterPatch() {
        super.afterPatch();
        this.stats = new Stats();
    }

    public boolean isBanned() {
        return false;
    }

    public boolean isOnPlanet(@Nullable Planet planet) {
        return planet == null || planet == Planets.sun || this.shownPlanets.isEmpty() || this.shownPlanets.contains((Object)planet);
    }

    public int getLogicId() {
        return Vars.logicVars.lookupLogicId(this);
    }

    public String displayDescription() {
        return this.minfo.mod == null ? this.description : this.description + "\n" + Core.bundle.format("mod.display", new Object[]{this.minfo.mod.meta.displayName});
    }

    public void checkStats() {
        if (!this.stats.intialized) {
            this.setStats();
            this.stats.intialized = true;
        }
    }

    public void setStats() {
    }

    public void displayExtra(Table table2) {
    }

    public void createIcons(MultiPacker packer) {
    }

    protected void makeOutline(MultiPacker.PageType page, MultiPacker packer, TextureRegion region, boolean makeNew, Color outlineColor, int outlineRadius) {
        if (region instanceof TextureAtlas.AtlasRegion) {
            TextureAtlas.AtlasRegion at = (TextureAtlas.AtlasRegion)region;
            if (region.found()) {
                String regName;
                String name = at.name;
                if (!(makeNew && packer.has(name + "-outline") || !packer.registerOutlined(regName = name + (makeNew ? "-outline" : "")))) {
                    PixmapRegion base = Core.atlas.getPixmap(region);
                    Pixmap result = Pixmaps.outline((PixmapRegion)base, (Color)outlineColor, (int)outlineRadius);
                    Drawf.checkBleed((Pixmap)result);
                    packer.add(page, regName, result);
                    result.dispose();
                }
            }
        }
    }

    protected void makeOutline(MultiPacker packer, TextureRegion region, String name, Color outlineColor, int outlineRadius) {
        if (region.found() && packer.registerOutlined(name)) {
            PixmapRegion base = Core.atlas.getPixmap(region);
            Pixmap result = Pixmaps.outline((PixmapRegion)base, (Color)outlineColor, (int)outlineRadius);
            Drawf.checkBleed((Pixmap)result);
            packer.add(MultiPacker.PageType.main, name, result);
            result.dispose();
        }
    }

    protected void makeOutline(MultiPacker packer, TextureRegion region, String name, Color outlineColor) {
        this.makeOutline(packer, region, name, outlineColor, 4);
    }

    public ItemStack[] researchRequirements() {
        return ItemStack.empty;
    }

    public String emoji() {
        return Fonts.getUnicodeStr(this.name);
    }

    public int emojiChar() {
        return Fonts.getUnicode(this.name);
    }

    public boolean hasEmoji() {
        return Fonts.hasUnicodeStr(this.name);
    }

    public void getDependencies(Cons<UnlockableContent> cons) {
    }

    public void onUnlock() {
    }

    public boolean isHidden() {
        return false;
    }

    public boolean showUnlock() {
        return true;
    }

    public boolean logicVisible() {
        return !this.isHidden();
    }

    public void unlock() {
        if (!this.unlocked && !this.alwaysUnlocked) {
            this.unlocked = true;
            Core.settings.put(this.name + "-unlocked", (Object)true);
            this.onUnlock();
            Events.fire((Object)new EventType.UnlockEvent(this));
        }
    }

    public void quietUnlock() {
        if (!this.unlocked()) {
            this.unlocked = true;
            Core.settings.put(this.name + "-unlocked", (Object)true);
        }
    }

    public boolean unlockedNowHost() {
        return (Boolean)VarsX.allUnlocked.get() != false || !Vars.state.isCampaign() || this.unlockedHost();
    }

    public boolean unlockedHost() {
        return Vars.net != null && Vars.net.client() ? this.alwaysUnlocked || Vars.state.rules.researched.contains((Object)this) : this.unlocked || this.alwaysUnlocked;
    }

    public boolean unlockedNow() {
        return (Boolean)VarsX.allUnlocked.get() != false || this.unlocked() || !Vars.state.isCampaign();
    }

    public boolean unlocked() {
        return Vars.net != null && Vars.net.client() ? this.alwaysUnlocked || this.unlocked || Vars.state.rules.researched.contains((Object)this) : this.unlocked || this.alwaysUnlocked;
    }

    public void clearUnlock() {
        if (this.unlocked) {
            this.unlocked = false;
            Core.settings.put(this.name + "-unlocked", (Object)false);
        }
    }

    public boolean locked() {
        return !this.unlocked();
    }
}

