/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Gl;
import arc.graphics.Mesh;
import arc.graphics.Texture;
import arc.graphics.VertexAttribute;
import arc.graphics.g2d.Batch;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.Shader;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.struct.IntIntMap;
import arc.util.Structs;
import java.nio.FloatBuffer;
import java.util.Arrays;

public class MySpriteBatchBase
extends Batch {
    public static final int VERTEX_SIZE = 6;
    public static final int SPRITE_SIZE = 24;
    private static final int initialSize = 10000;
    private static final float[] emptyVertices = new float[0];
    protected Mesh mesh;
    protected FloatBuffer buffer;
    final float[] tmpVertices = new float[24];
    float[] requestVerts = new float[240000];
    int requestVertOffset = 0;
    protected boolean sort;
    protected boolean flushing;
    protected DrawRequest[] requests = new DrawRequest[10000];
    protected DrawRequest[] copy = new DrawRequest[0];
    protected int[] requestZ = new int[10000];
    protected int numRequests = 0;
    protected int[] contiguous = new int[2048];
    protected int[] contiguousCopy = new int[2048];
    protected int intZ = Float.floatToRawIntBits(this.z + 16.0f);

    public MySpriteBatchBase() {
        this(4096, null);
    }

    public MySpriteBatchBase(int size) {
        this(size, null);
    }

    public MySpriteBatchBase(int size, Shader defaultShader) {
        if (size > 8191) {
            throw new IllegalArgumentException("Can't have more than 8191 sprites per batch: " + size);
        }
        if (size > 0) {
            this.projectionMatrix.setOrtho(0.0f, 0.0f, (float)Core.graphics.getWidth(), (float)Core.graphics.getHeight());
            this.mesh = new Mesh(true, false, size * 4, size * 6, new VertexAttribute[]{VertexAttribute.position, VertexAttribute.color, VertexAttribute.texCoords, VertexAttribute.mixColor});
            int len = size * 6;
            short[] indices = new short[len];
            short j = 0;
            int i = 0;
            while (i < len) {
                indices[i] = j;
                indices[i + 1] = (short)(j + 1);
                indices[i + 2] = (short)(j + 2);
                indices[i + 3] = (short)(j + 2);
                indices[i + 4] = (short)(j + 3);
                indices[i + 5] = j;
                i += 6;
                j = (short)(j + 4);
            }
            this.mesh.setIndices(indices);
            this.mesh.getVerticesBuffer().position(0);
            this.mesh.getVerticesBuffer().limit(this.mesh.getVerticesBuffer().capacity());
            if (defaultShader == null) {
                this.shader = MySpriteBatchBase.createShader();
                this.ownsShader = true;
            } else {
                this.shader = defaultShader;
            }
            this.mesh.getIndicesBuffer();
            this.buffer = this.mesh.getVerticesBuffer();
        } else {
            this.shader = null;
        }
        for (int i = 0; i < this.requests.length; ++i) {
            this.requests[i] = new DrawRequest();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.mesh != null) {
            this.mesh.dispose();
        }
    }

    protected void setSort(boolean sort) {
        if (this.sort != sort) {
            this.flush();
        }
        this.sort = sort;
    }

    protected void setShader(Shader shader, boolean apply) {
        if (!this.flushing && this.sort) {
            throw new IllegalArgumentException("Shaders cannot be set while sorting is enabled. Set shaders inside Draw.run(...).");
        }
        super.setShader(shader, apply);
    }

    protected void setBlending(Blending blending) {
        this.blending = blending;
    }

    protected void z(float z) {
        if (z == this.z) {
            return;
        }
        this.z = z;
        this.intZ = Float.floatToRawIntBits(z + 16.0f);
    }

    protected void discard() {
        super.discard();
        this.buffer.position(0);
    }

    protected void draw(Texture texture, float[] spriteVertices, int offset, int count) {
        if (this.sort && !this.flushing) {
            int num = this.numRequests;
            if (num > 0) {
                DrawRequest last = this.requests[num - 1];
                if (last.run == null && last.texture == texture && last.blending == this.blending && this.requestZ[num - 1] == this.intZ) {
                    if (spriteVertices != emptyVertices) {
                        this.prepare(count);
                        System.arraycopy(spriteVertices, offset, this.requestVerts, this.requestVertOffset, count);
                        this.requestVertOffset += count;
                    }
                    last.verticesLength += count;
                    return;
                }
            }
            if (num >= this.requests.length) {
                this.expandRequests();
            }
            DrawRequest req = this.requests[num];
            if (spriteVertices != emptyVertices) {
                req.verticesOffset = this.requestVertOffset;
                this.prepare(count);
                System.arraycopy(spriteVertices, offset, this.requestVerts, this.requestVertOffset, count);
                this.requestVertOffset += count;
            } else {
                req.verticesOffset = offset;
            }
            req.verticesLength = count;
            this.requestZ[num] = this.intZ;
            req.texture = texture;
            req.blending = this.blending;
            req.run = null;
            ++this.numRequests;
        } else {
            this.drawSuper(texture, spriteVertices, offset, count);
        }
    }

    protected void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float rotation) {
        if (!this.sort || this.flushing) {
            this.drawSuper(region, x, y, originX, originY, width, height, rotation);
            return;
        }
        int pos = this.requestVertOffset;
        this.requestVertOffset += 24;
        this.prepare(24);
        this.constructVertices(this.requestVerts, pos, region, x, y, originX, originY, width, height, rotation);
        this.draw(region.texture, emptyVertices, pos, 24);
    }

    protected void draw(Runnable request) {
        if (this.sort && !this.flushing) {
            if (this.numRequests >= this.requests.length) {
                this.expandRequests();
            }
            DrawRequest req = this.requests[this.numRequests];
            req.run = request;
            req.blending = this.blending;
            this.requestZ[this.numRequests] = this.intZ;
            req.texture = null;
            ++this.numRequests;
        } else {
            request.run();
        }
    }

    protected void prepare(int i) {
        if (this.requestVertOffset + i >= this.requestVerts.length) {
            this.requestVerts = Arrays.copyOf(this.requestVerts, this.requestVerts.length << 1);
        }
    }

    protected void expandRequests() {
        DrawRequest[] requests = this.requests;
        DrawRequest[] newRequests = Arrays.copyOf(requests, requests.length * 7 / 4);
        for (int i = requests.length; i < newRequests.length; ++i) {
            newRequests[i] = new DrawRequest();
        }
        this.requests = newRequests;
        this.requestZ = Arrays.copyOf(this.requestZ, newRequests.length);
    }

    protected void flush() {
        if (!this.flushing) {
            this.flushing = true;
            this.flushRequests();
            this.flushing = false;
        }
        if (this.idx == 0) {
            return;
        }
        this.getShader().bind();
        this.setupMatrices();
        if (this.customShader != null && this.apply) {
            this.customShader.apply();
        }
        Gl.depthMask((boolean)false);
        int count = this.idx / 24 * 6;
        this.blending.apply();
        this.lastTexture.bind();
        Mesh mesh = this.mesh;
        mesh.getVerticesBuffer();
        this.buffer.position(0);
        this.buffer.limit(this.idx);
        mesh.render(this.getShader(), 4, 0, count);
        this.buffer.limit(this.buffer.capacity());
        this.buffer.position(0);
        this.idx = 0;
    }

    protected void flushRequests() {
        if (this.numRequests == 0) {
            return;
        }
        this.sortRequests();
        float preColor = this.colorPacked;
        float preMixColor = this.mixColorPacked;
        Blending preBlending = this.blending;
        float[] vertices = this.requestVerts;
        DrawRequest[] r = this.copy;
        int num = this.numRequests;
        for (int j = 0; j < num; ++j) {
            DrawRequest req = r[j];
            super.setBlending(req.blending);
            if (req.run != null) {
                req.run.run();
                req.run = null;
                continue;
            }
            if (req.texture == null) continue;
            this.drawSuper(req.texture, vertices, req.verticesOffset, req.verticesLength);
        }
        this.colorPacked = preColor;
        this.mixColorPacked = preMixColor;
        this.blending = preBlending;
        this.numRequests = 0;
        this.requestVertOffset = 0;
    }

    protected void drawSuper(Texture texture, float[] spriteVertices, int offset, int count) {
        int verticesLength;
        int remainingVertices = verticesLength = this.buffer.capacity();
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if ((remainingVertices -= this.idx) == 0) {
            this.flush();
            remainingVertices = verticesLength;
        }
        int copyCount = Math.min(remainingVertices, count);
        this.buffer.put(spriteVertices, offset, copyCount);
        this.idx += copyCount;
        count -= copyCount;
        while (count > 0) {
            this.flush();
            copyCount = Math.min(verticesLength, count);
            this.buffer.put(spriteVertices, offset += copyCount, copyCount);
            this.idx += copyCount;
            count -= copyCount;
        }
    }

    protected void drawSuper(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float rotation) {
        Texture texture = region.texture;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.idx == this.buffer.capacity()) {
            this.flush();
        }
        this.idx += 24;
        this.constructVertices(this.tmpVertices, 0, region, x, y, originX, originY, width, height, rotation);
        this.buffer.put(this.tmpVertices);
    }

    protected final void constructVertices(float[] vertices, int idx, TextureRegion region, float x, float y, float originX, float originY, float width, float height, float rotation) {
        float u = region.u;
        float v = region.v2;
        float u2 = region.u2;
        float v2 = region.v;
        float color = this.colorPacked;
        float mixColor = this.mixColorPacked;
        if (!Mathf.zero((float)rotation)) {
            float worldOriginX = x + originX;
            float worldOriginY = y + originY;
            float fx = -originX;
            float fy = -originY;
            float fx2 = width - originX;
            float fy2 = height - originY;
            float cos = Mathf.cosDeg((float)rotation);
            float sin = Mathf.sinDeg((float)rotation);
            float x1 = cos * fx - sin * fy + worldOriginX;
            float y1 = sin * fx + cos * fy + worldOriginY;
            float x2 = cos * fx - sin * fy2 + worldOriginX;
            float y2 = sin * fx + cos * fy2 + worldOriginY;
            float x3 = cos * fx2 - sin * fy2 + worldOriginX;
            float y3 = sin * fx2 + cos * fy2 + worldOriginY;
            float x4 = x1 + (x3 - x2);
            float y4 = y3 - (y2 - y1);
            vertices[idx] = x1;
            vertices[idx + 1] = y1;
            vertices[idx + 2] = color;
            vertices[idx + 3] = u;
            vertices[idx + 4] = v;
            vertices[idx + 5] = mixColor;
            vertices[idx + 6] = x2;
            vertices[idx + 7] = y2;
            vertices[idx + 8] = color;
            vertices[idx + 9] = u;
            vertices[idx + 10] = v2;
            vertices[idx + 11] = mixColor;
            vertices[idx + 12] = x3;
            vertices[idx + 13] = y3;
            vertices[idx + 14] = color;
            vertices[idx + 15] = u2;
            vertices[idx + 16] = v2;
            vertices[idx + 17] = mixColor;
            vertices[idx + 18] = x4;
            vertices[idx + 19] = y4;
            vertices[idx + 20] = color;
            vertices[idx + 21] = u2;
            vertices[idx + 22] = v;
            vertices[idx + 23] = mixColor;
        } else {
            float fx2 = x + width;
            float fy2 = y + height;
            vertices[idx] = x;
            vertices[idx + 1] = y;
            vertices[idx + 2] = color;
            vertices[idx + 3] = u;
            vertices[idx + 4] = v;
            vertices[idx + 5] = mixColor;
            vertices[idx + 6] = x;
            vertices[idx + 7] = fy2;
            vertices[idx + 8] = color;
            vertices[idx + 9] = u;
            vertices[idx + 10] = v2;
            vertices[idx + 11] = mixColor;
            vertices[idx + 12] = fx2;
            vertices[idx + 13] = fy2;
            vertices[idx + 14] = color;
            vertices[idx + 15] = u2;
            vertices[idx + 16] = v2;
            vertices[idx + 17] = mixColor;
            vertices[idx + 18] = fx2;
            vertices[idx + 19] = y;
            vertices[idx + 20] = color;
            vertices[idx + 21] = u2;
            vertices[idx + 22] = v;
            vertices[idx + 23] = mixColor;
        }
    }

    public static Shader createShader() {
        return new Shader("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nattribute vec4 a_mix_color;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec4 v_mix_color;\nvarying vec2 v_texCoords;\n\nvoid main(){\n   v_color = a_color;\n   v_color.a = v_color.a * (255.0/254.0);\n   v_mix_color = a_mix_color;\n   v_mix_color.a *= (255.0/254.0);\n   v_texCoords = a_texCoord0;\n   gl_Position = u_projTrans * a_position;\n}", "\nvarying lowp vec4 v_color;\nvarying lowp vec4 v_mix_color;\nvarying highp vec2 v_texCoords;\nuniform highp sampler2D u_texture;\n\nvoid main(){\n  vec4 c = texture2D(u_texture, v_texCoords);\n  gl_FragColor = v_color * mix(c, vec4(v_mix_color.rgb, c.a), v_mix_color.a);\n}");
    }

    protected void sortRequests() {
        int numRequests = this.numRequests;
        int[] itemZ = this.requestZ;
        int[] contiguous = this.contiguous;
        int ci = 0;
        int cl = contiguous.length;
        int z = itemZ[0];
        int startI = 0;
        for (int i = 1; i < numRequests; ++i) {
            if (itemZ[i] == z) continue;
            contiguous[ci] = z;
            contiguous[ci + 1] = startI;
            contiguous[ci + 2] = i - startI;
            if ((ci += 3) + 3 > cl) {
                contiguous = Arrays.copyOf(contiguous, cl <<= 1);
            }
            startI = i;
            z = itemZ[startI];
        }
        contiguous[ci] = z;
        contiguous[ci + 1] = startI;
        contiguous[ci + 2] = numRequests - startI;
        this.contiguous = contiguous;
        int L = ci / 3 + 1;
        if (this.contiguousCopy.length < contiguous.length) {
            this.contiguousCopy = new int[contiguous.length];
        }
        int[] sorted2 = CountingSort.countingSortMap(contiguous, this.contiguousCopy, L);
        if (this.copy.length < numRequests) {
            this.copy = new DrawRequest[numRequests + (numRequests >> 3)];
        }
        int ptr = 0;
        DrawRequest[] items = this.requests;
        DrawRequest[] dest = this.copy;
        for (int i = 0; i < L * 3; i += 3) {
            int pos = sorted2[i + 1];
            int length = sorted2[i + 2];
            if (length < 10) {
                int end = pos + length;
                int sj = pos;
                int dj = ptr;
                while (sj < end) {
                    dest[dj] = items[sj];
                    ++sj;
                    ++dj;
                }
            } else {
                System.arraycopy(items, pos, dest, ptr, Math.min(length, dest.length - ptr));
            }
            ptr += length;
        }
    }

    protected static class DrawRequest {
        int verticesOffset;
        int verticesLength;
        Texture texture;
        Blending blending;
        Runnable run;

        protected DrawRequest() {
        }
    }

    static class CountingSort {
        static int[] locs = new int[100];
        static final IntIntMap counts = new IntIntMap();
        private static Point2[] entries = new Point2[100];

        CountingSort() {
        }

        static int[] countingSortMap(int[] arr, int[] swap, int end) {
            int i;
            int[] locs = CountingSort.locs;
            IntIntMap counts = CountingSort.counts;
            counts.clear();
            int unique = 0;
            int end3 = end * 3;
            for (int i2 = 0; i2 < end3; i2 += 3) {
                int loc;
                arr[i2] = loc = counts.getOrPut(arr[i2], unique);
                if (loc == unique) {
                    if (unique >= locs.length) {
                        locs = Arrays.copyOf(locs, unique * 3 / 2);
                    }
                    locs[unique++] = 1;
                    continue;
                }
                int n = loc;
                locs[n] = locs[n] + 1;
            }
            CountingSort.locs = locs;
            if (entries.length < unique) {
                int prevLength = entries.length;
                Point2[] entries = CountingSort.entries = Arrays.copyOf(CountingSort.entries, unique * 3 / 2);
                for (int i3 = prevLength; i3 < entries.length; ++i3) {
                    entries[i3] = new Point2();
                }
            }
            Point2[] entries = CountingSort.entries;
            IntIntMap.Entries countEntries = counts.entries();
            IntIntMap.Entry entry = countEntries.next();
            entries[0].set(entry.key, entry.value);
            int j = 1;
            while (countEntries.hasNext) {
                countEntries.next();
                entries[j++].set(entry.key, entry.value);
            }
            Arrays.sort(entries, 0, unique, Structs.comparingInt(p -> p.x));
            int prev = entries[0].y;
            for (i = 1; i < unique; ++i) {
                int next = entries[i].y;
                locs[next] = locs[next] + locs[prev];
                prev = next;
            }
            i = end - 1;
            int i3 = i * 3;
            while (i >= 0) {
                int n = arr[i3];
                int n2 = locs[n] - 1;
                locs[n] = n2;
                int destPos = n2 * 3;
                swap[destPos] = arr[i3];
                swap[destPos + 1] = arr[i3 + 1];
                swap[destPos + 2] = arr[i3 + 2];
                --i;
                i3 -= 3;
            }
            return swap;
        }

        static {
            for (int i = 0; i < entries.length; ++i) {
                CountingSort.entries[i] = new Point2();
            }
        }
    }
}

