/*
 * Decompiled with CFR 0.152.
 */
package arc.backend.sdl;

import arc.Application;
import arc.ApplicationListener;
import arc.Core;
import arc.Settings;
import arc.audio.Audio;
import arc.backend.sdl.SdlConfig;
import arc.backend.sdl.SdlFiles;
import arc.backend.sdl.SdlGraphics;
import arc.backend.sdl.SdlInput;
import arc.backend.sdl.jni.SDL;
import arc.files.Fi;
import arc.func.Cons;
import arc.graphics.Pixmap;
import arc.struct.Seq;
import arc.util.ArcNativesLoader;
import arc.util.Log;
import arc.util.OS;
import arc.util.Reflect;
import arc.util.Strings;
import arc.util.TaskQueue;
import arc.util.Threads;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.List;

public class SdlApplication
implements Application {
    private final Seq<ApplicationListener> listeners = new Seq();
    private final TaskQueue runnables = new TaskQueue();
    private final int[] inputs = new int[64];
    final SdlGraphics graphics;
    final SdlInput input;
    final SdlConfig config;
    final Thread mainThread;
    boolean running = true;
    long window;
    long context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SdlApplication(ApplicationListener listener, SdlConfig config) {
        this.config = config;
        this.listeners.add((Object)listener);
        this.mainThread = Thread.currentThread();
        this.init();
        Core.app = this;
        Core.files = new SdlFiles();
        this.graphics = new SdlGraphics(this);
        Core.graphics = this.graphics;
        this.input = new SdlInput();
        Core.input = this.input;
        Core.settings = new Settings();
        Core.audio = new Audio(!config.disableAudio);
        this.initIcon();
        this.graphics.updateSize(config.width, config.height);
        if (!OS.isMac) {
            this.addTextInputListener();
        }
        try {
            this.loop();
            this.listen((Cons<ApplicationListener>)((Cons)ApplicationListener::exit));
        }
        finally {
            try {
                this.cleanup();
            }
            catch (Throwable error) {
                error.printStackTrace();
            }
        }
    }

    private void addTextInputListener() {
        this.addListener((ApplicationListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initIcon() {
        if (this.config.windowIconPaths != null && this.config.windowIconPaths.length > 0) {
            String path = this.config.windowIconPaths[0];
            try {
                Pixmap p = new Pixmap(Core.files.get(path, this.config.windowIconFileType));
                long surface = SDL.SDL_CreateRGBSurfaceFrom((ByteBuffer)p.pixels, (int)p.width, (int)p.height);
                SDL.SDL_SetWindowIcon((long)this.window, (long)surface);
                SDL.SDL_FreeSurface((long)surface);
                p.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void init() {
        ArcNativesLoader.load();
        if (OS.isMac) {
            this.restartMac();
        }
        if (System.getProperty("MDTX-SDL-window") != null) {
            Log.info((Object)"[Core] Initialize reusing window and context.");
            this.window = Long.parseLong(System.getProperty("MDTX-SDL-window"));
            this.context = Long.parseLong(System.getProperty("MDTX-SDL-context"));
            this.config.width = Integer.parseInt(System.getProperty("MDTX-SDL-width"));
            this.config.height = Integer.parseInt(System.getProperty("MDTX-SDL-height"));
            int[] ver = new int[3];
            SDL.SDL_GetVersion((int[])ver);
            Log.info((String)"[Core] Initialized SDL v@.@.@", (Object[])new Object[]{ver[0], ver[1], ver[2]});
            return;
        }
        this.check(SDL.SDL_Init((int)16416));
        SDL.SDL_SetHint((String)"SDL_IME_SHOW_UI", (String)"1");
        SDL.SDL_SetHint((String)"SDL_WINDOWS_DPI_SCALING", (String)"1");
        this.check(SDL.SDL_GL_SetAttribute((int)21, (int)(OS.isMac || this.config.coreProfile ? 1 : 2)));
        this.check(SDL.SDL_GL_SetAttribute((int)0, (int)this.config.r));
        this.check(SDL.SDL_GL_SetAttribute((int)1, (int)this.config.g));
        this.check(SDL.SDL_GL_SetAttribute((int)2, (int)this.config.b));
        this.check(SDL.SDL_GL_SetAttribute((int)6, (int)this.config.depth));
        this.check(SDL.SDL_GL_SetAttribute((int)7, (int)this.config.stencil));
        this.check(SDL.SDL_GL_SetAttribute((int)5, (int)1));
        if (this.config.samples > 0) {
            this.check(SDL.SDL_GL_SetAttribute((int)13, (int)1));
            this.check(SDL.SDL_GL_SetAttribute((int)14, (int)this.config.samples));
        }
        int flags = 2;
        if (this.config.initialVisible) {
            flags |= 4;
        }
        if (!this.config.decorated) {
            flags |= 0x10;
        }
        if (this.config.resizable) {
            flags |= 0x20;
        }
        if (this.config.maximized) {
            flags |= 0x80;
        }
        if (this.config.fullscreen) {
            flags |= 1;
        }
        this.window = SDL.SDL_CreateWindow((String)this.config.title, (int)this.config.width, (int)this.config.height, (int)flags);
        if (this.window == 0L) {
            throw new SdlError();
        }
        SdlError finalError = null;
        boolean createdContext = false;
        for (int[] attemptedVersion : this.config.glVersions) {
            if (attemptedVersion[0] == 2) {
                this.check(SDL.SDL_GL_SetAttribute((int)21, (int)2));
            }
            this.check(SDL.SDL_GL_SetAttribute((int)17, (int)attemptedVersion[0]));
            this.check(SDL.SDL_GL_SetAttribute((int)18, (int)attemptedVersion[1]));
            try {
                this.context = SDL.SDL_GL_CreateContext((long)this.window);
                if (this.context == 0L) {
                    throw new SdlError();
                }
                createdContext = true;
                break;
            }
            catch (SdlError error) {
                finalError = error;
                Log.err((String)"Failed to initialize OpenGL @.@: @", (Object[])new Object[]{attemptedVersion[0], attemptedVersion[1], Strings.getSimpleMessage((Throwable)error)});
            }
        }
        if (finalError != null && !createdContext) {
            throw finalError;
        }
        if (this.config.vSyncEnabled) {
            SDL.SDL_GL_SetSwapInterval((int)1);
        }
        int[] ver = new int[3];
        SDL.SDL_GetVersion((int[])ver);
        Log.info((String)"[Core] Initialized SDL v@.@.@", (Object[])new Object[]{ver[0], ver[1], ver[2]});
    }

    private void loop() {
        this.graphics.updateSize(this.config.width, this.config.height);
        this.listen((Cons<ApplicationListener>)((Cons)ApplicationListener::init));
        while (this.running) {
            while (SDL.SDL_PollEvent((int[])this.inputs)) {
                if (this.inputs[0] == 0) {
                    this.running = false;
                    continue;
                }
                if (this.inputs[0] == 1) {
                    int type = this.inputs[1];
                    if (type == 6) {
                        this.graphics.updateSize(this.inputs[2], this.inputs[3]);
                        this.listen((Cons<ApplicationListener>)((Cons)l -> l.resize(this.inputs[2], this.inputs[3])));
                        continue;
                    }
                    if (type == 12) {
                        this.listen((Cons<ApplicationListener>)((Cons)ApplicationListener::resume));
                        continue;
                    }
                    if (type != 13) continue;
                    this.listen((Cons<ApplicationListener>)((Cons)ApplicationListener::pause));
                    continue;
                }
                if (this.inputs[0] != 2 && this.inputs[0] != 3 && this.inputs[0] != 4 && this.inputs[0] != 5 && this.inputs[0] != 6 && this.inputs[0] != 8) continue;
                this.input.handleInput(this.inputs);
            }
            this.graphics.update();
            this.input.update();
            this.defaultUpdate();
            this.listen((Cons<ApplicationListener>)((Cons)ApplicationListener::update));
            this.runnables.run();
            SDL.SDL_GL_SwapWindow((long)this.window);
            this.input.postUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listen(Cons<ApplicationListener> cons) {
        Seq<ApplicationListener> seq = this.listeners;
        synchronized (seq) {
            for (ApplicationListener l : this.listeners) {
                cons.get((Object)l);
            }
        }
    }

    private void cleanup() {
        this.listen((Cons<ApplicationListener>)((Cons)l -> {
            l.pause();
            try {
                l.dispose();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }));
        this.dispose();
        SDL.SDL_DestroyWindow((long)this.window);
        SDL.SDL_Quit();
    }

    private void check(int code) {
        if (code != 0) {
            throw new SdlError();
        }
    }

    public long getWindow() {
        return this.window;
    }

    public Thread getMainThread() {
        return this.mainThread;
    }

    public boolean openFolder(String file) {
        Threads.daemon(() -> {
            if (OS.isWindows) {
                OS.execSafe((String)("explorer.exe /select," + file.replace("/", "\\")));
            } else if (OS.isLinux) {
                OS.execSafe((String[])new String[]{"xdg-open", file});
            } else if (OS.isMac) {
                OS.execSafe((String[])new String[]{"open", file});
            }
        });
        return true;
    }

    public boolean openURI(String url) {
        if (url.isEmpty()) {
            return false;
        }
        try {
            URI.create(url);
        }
        catch (Exception wrong) {
            return false;
        }
        Threads.daemon(() -> {
            if (OS.isMac) {
                OS.execSafe((String[])new String[]{"open", url});
            } else if (OS.isLinux) {
                OS.execSafe((String[])new String[]{"xdg-open", url});
            } else if (OS.isWindows) {
                OS.execSafe((String[])new String[]{"rundll32", "url.dll,FileProtocolHandler", url});
            }
        });
        return true;
    }

    public Seq<ApplicationListener> getListeners() {
        return this.listeners;
    }

    public Application.ApplicationType getType() {
        return Application.ApplicationType.desktop;
    }

    public String getClipboardText() {
        return SDL.SDL_GetClipboardText();
    }

    public void setClipboardText(String text) {
        SDL.SDL_SetClipboardText((String)text);
    }

    public void post(Runnable runnable) {
        this.runnables.post(runnable);
    }

    public void exit() {
        this.running = false;
    }

    private void restartMac() {
        try {
            Class<?> mgmt = Class.forName("java.lang.management.ManagementFactory");
            Class<?> beanClass = Class.forName("java.lang.management.RuntimeMXBean");
            Object bean = Reflect.invoke(mgmt, (String)"getRuntimeMXBean");
            String id = ((String)beanClass.getMethod("getName", new Class[0]).invoke(bean, new Object[0])).split("@")[0];
            if (!OS.hasEnv((String)("JAVA_STARTED_ON_FIRST_THREAD_" + id)) || OS.env((String)("JAVA_STARTED_ON_FIRST_THREAD_" + id)).equals("0")) {
                Log.warn((String)"Applying -XstartOnFirstThread for macOS support.", (Object[])new Object[0]);
                String javaPath = new Fi(OS.prop((String)"java.home")).child("bin/java").exists() ? new Fi(OS.prop((String)"java.home")).child("bin/java").absolutePath() : (Core.files.local("jre/bin/java").exists() ? Core.files.local("jre/bin/java").absolutePath() : "java");
                try {
                    Fi jar = Fi.get((String)SdlApplication.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                    Seq launchOptions = Seq.with((Object[])new String[]{javaPath});
                    launchOptions.addAll((Iterable)((List)beanClass.getMethod("getInputArguments", new Class[0]).invoke(bean, new Object[0])));
                    launchOptions.addAll((Object[])((String[])System.getProperties().entrySet().stream().map(it -> "-D" + it).toArray(String[]::new)));
                    launchOptions.addAll((Object[])new String[]{"-XstartOnFirstThread", "-jar", jar.absolutePath(), "-firstThread"});
                    Process proc = new ProcessBuilder((String[])launchOptions.toArray(String.class)).inheritIO().start();
                    System.exit(proc.waitFor());
                }
                catch (IOException | URISyntaxException e) {
                    Log.err((Throwable)e);
                    Log.err((String)"Failed to apply the -XstartOnFirstThread argument, it is required in order to work on mac.", (Object[])new Object[0]);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class SdlError
    extends RuntimeException {
        public SdlError() {
            super(SDL.SDL_GetError());
        }
    }
}

