#include "board.h"

/**********************************************************
*** ZDT_X42_V2.0ջ
*** дߣZHANGDATOU
*** ֧֣Ŵͷջŷ
*** Ա̣https://zhangdatou.taobao.com
*** CSDNͣhttp s://blog.csdn.net/zhangdatou666
*** qqȺ262438510
**********************************************************/

/**
	*	@brief		ʱӳʼ
	*	@param		
	*	@retval		
	*/
extern uint8_t board_move_i;                      // յ
extern uint8_t board_move_mode,rfid_mode,blue_tooth_mode;                      // յ

void clock_init(void)
{
	// ʹGPIOA˿ʱ
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);
}

/**
	*	@brief		gpioųʼ
	*	@param		
	*	@retval		
	*/
void gpio_init(void)
{
	// ʼPA5(En) PA6(Stp) PA7(Dir)˿Ϊģʽ
	GPIO_InitTypeDef  GPIO_InitStructure;
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_5 | GPIO_Pin_6 | GPIO_Pin_7;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(GPIOB, &GPIO_InitStructure);

	// ʼPA5(En) PA6(Stp) PA7(Dir)˿Ϊ͵ƽ
	GPIO_ResetBits(GPIOB, GPIO_Pin_5 | GPIO_Pin_6 | GPIO_Pin_7);
}

/**
	*	@brief		سʼ
	*	@param		
	*	@retval		
	*/
void board_init(void)
{
	clock_init();
	gpio_init();
}

extern unsigned char board_turn_flag_cw;  // ˳ʱ־λ
extern unsigned char board_turn_flag_ccw; // ˳ʱת

//
void rotate90_degrees(void) {
    static uint16_t pulse_count = 0;

    // Ѿ˳ʱת90ȣͲ˳ʱת
    if (board_turn_flag_cw == 1) {
        return;  // Ѿִй˳ʱתֱӷ
    }

    // õΪת˳ʱ룩
    GPIO_ResetBits(GPIOB, GPIO_Pin_7);  // ź͵ƽת

    // һ
    GPIO_SetBits(GPIOB, GPIO_Pin_6);    // ߵƽ
    delay_cnt(100);                     // ߵƽʱ
    GPIO_ResetBits(GPIOB, GPIO_Pin_6);  // ͵ƽ
    delay_cnt(100);                     // ͵ƽʱ

    // 1
    pulse_count++;

    // ÿ10һOLEDʾ
    if(pulse_count % 10 == 0) {
        OLED_ShowNum(3, 10, pulse_count, 3);
    }

    // Ƿ800(90)
    if(pulse_count >= 800) {
        pulse_count = 0;                 // ü
        Delay_ms(1000);                  // ʱ1
        OLED_ShowString(3, 1, "Done");
        OLED_Clear();
        board_move_mode = 2;             // л״̬
        rfid_mode = 2;
        blue_tooth_mode = 2;

        // ˳ʱ־λΪ1ʾ˳ʱת
        board_turn_flag_cw = 1;

    }
}

// ת
void rotate90_degrees_reverse(void) {
    static uint16_t pulse_count = 0;

    // Ѿʱת90ȣͲʱת
    if (board_turn_flag_ccw == 1) {
        return;  // Ѿִйʱתֱӷ
    }

    // õΪתʱ룩
    GPIO_SetBits(GPIOB, GPIO_Pin_7);  // źߵƽת

    // һ
    GPIO_SetBits(GPIOB, GPIO_Pin_6);    // ߵƽ
    delay_cnt(100);                     // ߵƽʱ
    GPIO_ResetBits(GPIOB, GPIO_Pin_6);  // ͵ƽ
    delay_cnt(100);                     // ͵ƽʱ

    // 1
    pulse_count++;

    // ÿ10һOLEDʾ
    if(pulse_count % 10 == 0) {
        OLED_ShowNum(3, 10, pulse_count, 3);
    }

    // Ƿ800(90)
    if(pulse_count >= 800) {
        pulse_count = 0;                 // ü
        Delay_ms(1000);                  // ʱ1
        OLED_ShowString(3, 1, "Done");
        OLED_Clear();
        board_move_mode = 2;             // л״̬
        rfid_mode = 2;
        blue_tooth_mode = 2;

        // ʱ־λΪ1ʾʱת
        board_turn_flag_ccw = 1;
    }
}
uint8_t ii =0;

void close_door(void){
	GPIO_SetBits(GPIOB, GPIO_Pin_7);  	// ź͵ƽת
	for(ii=0; ii < 800; ii++)             	// 3200ź
	{
		GPIO_SetBits(GPIOB, GPIO_Pin_6);    // ߵƽ 
		delay_cnt(1000+ii*20);           					// ߵƽʱ
		GPIO_ResetBits(GPIOB, GPIO_Pin_6);	// ͵ƽ 
		delay_cnt(1000+ii*20);           					// ͵ƽʱ
		if(ii % 10 == 0) {
        OLED_ShowNum(3, 10, ii, 3);
    }
	}
	if(ii>=799){
        Delay_ms(1000);                  // ʱ1
        OLED_ShowString(3, 1, "Done");
        OLED_Clear();
        board_move_mode = 2;             // л״̬
        rfid_mode = 2;
        blue_tooth_mode = 2;

        // ˳ʱ־λΪ1ʾ˳ʱת
        board_turn_flag_cw = 1;
	}
}