#include "reg52.h"

#define uchar unsigned char 
	
unsigned int time;//定义延迟时间

uchar dis[10]=//共阳极数码管字符0-9
{0xc0,0xf9,0xa4,
0xb0,0x99,0x92,
0x82,0xf8,0x80,0x90};

unsigned int h=9, m=59, s=50;
//  定义时,分,秒初始值，可直接更改，数码管从这个时间开始
unsigned int count=0;// 计时器中断中用到的变量

//延时函数
void delay(unsigned int t)
{
	unsigned int i=0, j=0;
	for(i=0; i<t; i++)
		for(j=0; j<120; j++);
}

void Display()
{		
	unsigned int h0=0,h1=0,m0=0,m1=0,s0=0,s1=0;  
	// 定义变量 h0=时的十位,h1=时的个位,m0=分的十位，
	//m1=分的个位,s0=秒的十位， s1=秒的个位
	h0 = h/10;   //  小时除以10，只取整数部分就正好是小时的十位数
	h1 = h%10;   //  小时除10取余，正好就是小时的个位数
	m0 = m/10;	 //  分钟除以10，只取整数部分就正好是分钟的十位数
	m1 = m%10;	 //  分钟除10取余，正好就是分钟的个位数
	s0 = s/10; //  秒钟除以10，只取整数部分就正好是秒钟的十位数
	s1 = s%10; //  秒钟除10取余，正好就是秒钟的个位数
	
	//显示日期“10”
	P3=0xff;//解锁
	P2=0x01;//开启WX0
	P3=0x7f;//锁存
	P2=dis[1];//1
	delay(2);//延时
		
	P3=0xff;//解锁
	P2=0x02;//开启WX1
	P3=0x7f;//锁存
	P2=dis[0];//0
	delay(2);//延时
	
	//显示时间时数	
	P3=0xff;//解锁
	P2=0x04;//开启WX2
	P3=0x7f;//锁存
	P2=dis[h0];//小时的十位数
	delay(2);//延时
		
	P3=0xff;//解锁
	P2=0x08;//开启WX3
	P3=0x7f;//锁存
	P2=dis[h1];//小时的个位数
	delay(2);//延时

	//显示时间分数
	P3=0xff;//解锁
	P2=0x10;//开启WX4
	P3=0x7f;//锁存
	P2=dis[m0];//分钟的十位数
	delay(2);//延时
		
	P3=0xff;//解锁
	P2=0x20;//开启WX5
	P3=0x7f;//锁存
	P2=dis[m1];//分钟的个位数
	delay(2);//延时
	
	//显示时间秒数
	P3=0xff;//解锁
	P2=0x40;//开启WX6
	P3=0x7f;//锁存
	P2=dis[s0];//秒钟的十位数
	delay(2);//延时
		
	P3=0xff;//解锁
	P2=0x80;//开启WX7
	P3=0x7f;//锁存
	P2=dis[s1];//秒钟的个位数
	delay(2);//延时
}

//  时间中断函数
void timer0() interrupt 1{
	unsigned int i=0;
	TH0 = 0x3C;     // 初值高8位就是65536-计时值50000（50毫秒） = 15536转换成16进制为 3cb0
	TL0 = 0xB0;     // 高8位为3c， 低8位为b0
	count++;		//  这个中断函数每隔50毫秒运行一次，每次count加1
	if(count==20){  //  如果count等于了20，就是运行了20次X50=1000毫秒=1秒   
		s+=1;	// 秒钟加1
		count = 0;	// count置0重新计算
	}
	if(s==60){   //  秒钟=60
		m+=1;		//分钟加1
		s=0;		// 秒钟置0从新计算
	}
	if(m==60){    // 如果分钟等于60了
		h+=1;		// 小时加1
		m=0;		// 分钟置0从新计算
	}
	if(h==24){	//  如果小时等于24了或是12了
		h=0;		//  小时置0从新计算      （后面还可以加天，月， 年）
	}
}

void main()
{
	TMOD =0x01;
	TH0 = 0x3C;  // 初值高8位就是65536-计时值50000（50毫秒） = 15536转换成16进制为 3cb0
	TL0 = 0xB0;  // 高8位为3c， 低8位为b0
	ET0 =1;      // 开启定时器0
	EA = 1;      // 开启总中断
	TR0 = 1;     // 开启定时器
		
	while(1)
	{
		Display();
	}	
}