/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.MainFrame;

public interface TreeState {
    public static final TreeState NOTHING = guiInstance -> {};

    public void restore(GuiPackage var1);

    public static TreeState from(GuiPackage guiPackage) {
        if (guiPackage == null) {
            return NOTHING;
        }
        MainFrame mainframe = guiPackage.getMainFrame();
        if (mainframe != null) {
            JTree tree = mainframe.getTree();
            int savedSelected = tree.getMinSelectionRow();
            ArrayList<Integer> savedExpanded = new ArrayList<Integer>();
            for (int rowN = 0; rowN < tree.getRowCount(); ++rowN) {
                if (!tree.isExpanded(rowN)) continue;
                savedExpanded.add(rowN);
            }
            return new TreeStateImpl(savedSelected, savedExpanded);
        }
        return NOTHING;
    }

    public static final class TreeStateImpl
    implements TreeState {
        private final List<Integer> savedExpanded;
        private final int savedSelected;

        public TreeStateImpl(int savedSelected, List<Integer> savedExpanded) {
            this.savedSelected = savedSelected;
            this.savedExpanded = savedExpanded;
        }

        @Override
        public void restore(GuiPackage guiInstance) {
            MainFrame mainframe = guiInstance.getMainFrame();
            if (mainframe == null) {
                return;
            }
            JTree tree = mainframe.getTree();
            if (!this.savedExpanded.isEmpty()) {
                this.savedExpanded.forEach(tree::expandRow);
            } else {
                tree.expandRow(0);
            }
            tree.setSelectionRow(this.savedSelected);
        }
    }
}

