﻿// ==UserScript==
// @name              LinkSwift
// @namespace         github.com/hmjz100
// @version           1.1.1.9
// @author            Hmjz100、油小猴
// @icon              data:image/svg+xml;base64,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
// @description       (｡>ᴗ•)✧《也许同类型中最好用？》系列 - 一个基于 JavaScript 的网盘文件下载地址获取工具✨，基于【网盘直链下载助手】修改 | 支持 百度网盘 / 阿里云盘 / 中国移动云盘 / 天翼云盘 / 迅雷云盘 / 夸克网盘 / UC网盘 / 123云盘 八大网盘 | 开源・自用・去广 | 改界面・添功能・修Bug | 既超越原版，亦是同类中最好用版本！👋
// @description:zh-CN (｡>ᴗ•)✧《也许同类型中最好用？》系列 - 一个基于 JavaScript 的网盘文件下载地址获取工具✨，基于【网盘直链下载助手】修改 | 支持 百度网盘 / 阿里云盘 / 中国移动云盘 / 天翼云盘 / 迅雷云盘 / 夸克网盘 / UC网盘 / 123云盘 八大网盘 | 开源・自用・去广 | 改界面・添功能・修Bug | 既超越原版，亦是同类中最好用版本！👋
// @description:zh-TW (｡>ᴗ•)✧《也許同類型中最好用？》系列 - 一個基於 JavaScript 的網盤檔案下載地址獲取工具✨，基於【網盤直鏈下載助手】改編 | 支援 百度網盤 / 阿里雲盤 / 中國移動雲盤 / 天翼雲盤 / 迅雷雲盤 / 夸克網盤 / UC網盤 / 123雲盤 八大平台 | 開源・自用・除廣 | 改介面・擴功能・修Bug | 既超越原版，亦是同類中最好用版本！👋
// @description:zh-HK (｡>ᴗ•)✧《也許同類型中最好用？》系列 - 一個基於 JavaScript 的網盤檔案下載地址獲取工具✨，基於【網盤直鏈下載助手】改編 | 支援 百度網盤 / 阿里雲盤 / 中國移動雲盤 / 天翼雲盤 / 迅雷雲盤 / 夸克網盤 / UC網盤 / 123雲盤 八大平台 | 開源・自用・除廣 | 改介面・擴功能・修Bug | 既超越原版，亦是同類中最好用版本！👋
// @license           AGPL-3.0-or-later
// @homepage          https://github.com/hmjz100/LinkSwift/
// @homepageURL       https://github.com/hmjz100/LinkSwift/
// @support           https://github.com/hmjz100/LinkSwift/issues
// @supportURL        https://github.com/hmjz100/LinkSwift/issues
// @require           https://unpkg.com/jquery@3.6.0/dist/jquery.min.js
// @require           https://unpkg.com/sweetalert2@11.4.8/dist/sweetalert2.min.js
// @resource SwalLigt https://unpkg.com/sweetalert2@11.4.8/dist/sweetalert2.min.css
// @resource SwalDark https://unpkg.com/@sweetalert2/theme-dark@5.0.26/dark.min.css
// @require           https://unpkg.com/js-md5@0.7.3/build/md5.min.js
// @run-at            document-start
// @early-start
// @match             *://pan.baidu.com/disk/home*
// @match             *://yun.baidu.com/disk/home*
// @match             *://pan.baidu.com/disk/timeline*
// @match             *://yun.baidu.com/disk/timeline*
// @match             *://pan.baidu.com/disk/main*
// @match             *://yun.baidu.com/disk/main*
// @match             *://pan.baidu.com/youth/pan/main*
// @match             *://yun.baidu.com/youth/pan/main*
// @match             *://pan.baidu.com/disk/base*
// @match             *://yun.baidu.com/disk/base*
// @match             *://pan.baidu.com/disk/timeline*
// @match             *://yun.baidu.com/disk/timeline*
// @match             *://pan.baidu.com/pfile/*
// @match             *://yun.baidu.com/pfile/*
// @match             *://pan.baidu.com/s/*
// @match             *://pan.baidu.com/aipan/*
// @match             *://yun.baidu.com/s/*
// @match             *://yun.baidu.com/aipan/*
// @match             *://pan.baidu.com/share/*
// @match             *://yun.baidu.com/share/*
// @match             *://pan.baidu.com/embed/*
// @match             *://yun.baidu.com/embed/*
// @match             *://openapi.baidu.com/*
// @match             *://www.aliyundrive.com/s/*
// @match             *://www.aliyundrive.com/drive*
// @match             *://www.alipan.com/s/*
// @match             *://www.alipan.com/drive*
// @match             *://cloud.189.cn/web/*
// @match             *://pan.xunlei.com/*
// @match             *://pan.quark.cn/*
// @match             *://drive.uc.cn/*
// @match             *://yun.139.com/*
// @match             *://caiyun.139.com/*
// @match             *://*.123pan.com/*
// @match             *://*.123pan.cn/*
// @match             *://*.123684.com/*
// @match             *://*.123865.com/*
// @match             *://*.123952.com/*
// @match             *://*.123912.com/*
// @connect           *
// @connect           localhost
// @connect           baidu.com
// @connect           baidupcs.com
// @connect           aliyundrive.com
// @connect           aliyundrive.net
// @connect           alipan.com
// @connect           alicloudccp.com
// @connect           aliyundrive.cloud
// @connect           139.com
// @connect           cmecloud.cn
// @connect           189.cn
// @connect           xunlei.com
// @connect           quark.cn
// @connect           uc.cn
// @connect           123pan.com
// @connect           123pan.cn
// @connect           123684.com
// @connect           123865.com
// @connect           123952.com
// @connect           123912.com
// @connect           cjjd19.com
// @grant             unsafeWindow
// @grant             window.close
// @grant             GM_xmlhttpRequest
// @grant             GM_setClipboard
// @grant             GM_setValue
// @grant             GM_getValue
// @grant             GM_deleteValue
// @grant             GM_openInTab
// @grant             GM_registerMenuCommand
// @grant             GM_getResourceText
// @compatible	      Chrome
// @compatible	      Edge
// @compatible	      Firefox
// @compatible	      Safari
// @compatible	      Opera
// ==/UserScript==
/**
 * @name LinkSwift
 * @template （改）网盘直链下载助手
 * @author 油小猴
 * @author hmjz100
 * @namespace github.com/hmjz100
 * @description  一个基于 JavaScript 盘的文件下载地址获取工具
 * 支持 百度网盘/阿里云盘/中国移动云盘/天翼云盘/迅雷云盘/夸克网盘/UC网盘/123云盘 八大网盘
 * @version 1.1.1.9
 * @license AGPL-3.0-or-later
 * @see {@link https://github.com/hmjz100/LinkSwift/ Github 仓库}
 */
(function linkSwift() {
	// 严格模式，确保代码安全执行，不越界
	'use strict';
	// unsafeWindow 检测，适用于 Via 这类无 unsafeWindow 的浏览器
	if (typeof (unsafeWindow) === 'undefined') window.unsafeWindow = window;
	/*
	防止代码因其他原因被执行多次
	代码出自 “Via 轻插件”，作者谷花泰
	*/
	let key = encodeURIComponent('LinkSwift:主代码');
	if (window[key]) return;
	window[key] = true;
	/*
	网盘直链下载助手
	代码改自 “网盘直链下载助手”，作者油小猴
	有增添新代码
	*/
	/* 全局参数 */
	let mount = idontknow("LinkSwift");
	let info = {
		author: GM_info.script?.author,
		name: GM_info.script?.name,
		version: (GM_info.script?.version || "1.1.1.9"),
		icon: (GM_info.script?.icon || "data:image/svg+xml;base64,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"),
		mhandler: GM_info.scriptHandler,
		mversion: GM_info.version,
	};
	let $doc = $(document);
	let temp = {
		mount: $(`.${mount}`),
		main: {},
		page: "",
		mode: [],
		links: [],
		color: "",
		progress: {},
		request: {},
		ins: {},
		idm: {},
		selectList: [],
		colored: false,
		swalDefault: {
			position: 'center',
			heightAuto: false,
			scrollbarPadding: false,
			confirmButtonText: `<svg class="pl-icon"><use xlink:href="#pl-icon-fa-check"/></svg> 确认`,
			denyButtonText: `<svg class="pl-icon"><use xlink:href="#pl-icon-fa-x-mark"/></svg> 拒绝`,
			cancelButtonText: `<svg class="pl-icon"><use xlink:href="#pl-icon-fa-x-mark"/></svg> 取消`
		},
		terminalType: {
			wc: "Microsoft Windows 命令提示符",
			wp: "Microsoft Windows PowerShell",
			lt: "Linux 终端",
			ls: "Linux Shell",
			mt: "Apple MacOS 终端"
		}
	};
	/**
	 * SweetAlert2 的 Toast 提示框基础配置
	 * @author 油小猴
	 * @author hmjz100
	 * @description 创建一个全局通用的 Toast 提示框实例，支持自动关闭、鼠标悬停暂停、右上角弹出等特性。
	 *
	 * @type{Sweetalert2.Toast}
	 */
	let toast = Swal.mixin({
		toast: true,
		position: 'top-end',
		showConfirmButton: false,
		timer: 3500,
		timerProgressBar: true,
		showCloseButton: true,
		didOpen: function (toast) {
			toast.addEventListener('mouseenter', () => {
				Swal.stopTimer();
			});
			toast.addEventListener('mouseleave', () => {
				Swal.resumeTimer();
			});
		}
	});
	/**
	 * 消息提示工具类
	 * @author 油小猴
	 * @description 提供统一的提示信息展示方法，基于 SweetAlert2 的 Toast 实现；
	 * 包含 success / error / warning / info / question 等类型。
	 */
	let message = {
		success: function (text) {
			toast.fire({ title: text, icon: 'success' });
		},
		error: function (text) {
			toast.fire({ title: text, icon: 'error' });
		},
		warning: function (text) {
			toast.fire({ title: text, icon: 'warning' });
		},
		info: function (text) {
			toast.fire({ title: text, icon: 'info' });
		},
		question: function (text) {
			toast.fire({ title: text, icon: 'question' });
		}
	};
	/**
	 * 基础配置集合
	 * @author 油小猴
	 * @author hmjz100
	 */
	let config = {
		base: {
			num: "865746",
			license: "AGPL3",
			service: {
				account: "https://pic.rmb.bdstatic.com/bjh/8b9e14345b3cdf96aedac2f3971adcb02681.png"
			},
			dom: {
				footer: `o(≧▽≦)o 十分感谢您的支持！来给此项目一个 <a href="https://github.com/hmjz100/LinkSwift" target="_blank" class="pl-a" data-no-instant="1"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-star"></use></svg>Star</a> 吧~`,
				button: {
					api: {
						title: "API 下载",
						footer: `<p>适用于 <a href="https://www.youxiaohou.com/zh-cn/idm.html" target="_blank" class="pl-a" data-no-instant="1"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-link"></use></svg>IDM</a>，<a href="https://www.youxiaohou.com/zh-cn/ndm.html" target="_blank" class="pl-a" data-no-instant="1"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-link"></use></svg>NDM</a> 以及浏览器自带下载</p>`
					},
					aria2: {
						title: "Aria2 下载",
						footer: `<p>RPC 适用于 <a href="https://www.youxiaohou.com/zh-cn/motrix.html" target="_blank" class="pl-a" data-no-instant="1"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-link"></use></svg>Motrix</a>，<a href="https://www.youxiaohou.com/download.html" target="_blank" class="pl-a" data-no-instant="1"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-link"></use></svg>Aria2 Tools</a>，<a href="https://www.youxiaohou.com/download.html" target="_blank" class="pl-a" data-no-instant="1"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-link"></use></svg>AriaNgGUI</a></p>
						<p>命令行适用于 <a href="https://www.youxiaohou.com/zh-cn/xdown.html" target="_blank" class="pl-a" data-no-instant="1"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-link"></use></svg>XDown</a> 及 <a href="https://www.youxiaohou.com/zh-cn/linux.html#linux-shell" target="_blank" class="pl-a" data-no-instant="1"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-link"></use></svg>Linux Shell 命令行</a></p>`
					},
					curl: {
						title: "cURL 下载",
						footer: `<p>适用于 <a href="https://www.youxiaohou.com/zh-cn/curl.html" target="_blank" class="pl-a" data-no-instant="1"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-link"></use></svg>Windows，Linux，MacOS 终端</a></p>`
					},
					bitcomet: {
						title: "比特彗星下载",
						footer: `<p>适用于 <a href="https://www.youxiaohou.com/zh-cn/bitcomet.html" target="_blank" class="pl-a" data-no-instant="1"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-link"></use></svg>比特彗星</a></p>`
					},
					abdm: {
						title: "ABDM 下载",
						footer: `<p>适用于 <a href="https://abdownloadmanager.com/" target="_blank" class="pl-a" data-no-instant="1"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-link"></use></svg>AB Download Manager</a></p>`
					}
				},
				theme: [
					{ color: '#09AAFF', name: '度盘|经典蓝' },
					{ color: '#cc3235', name: '度盘|平安红' },
					{ color: '#518c17', name: '度盘|盎然绿' },
					{ color: '#ed944b', name: '度盘|周年橙' },
					{ color: '#f969a5', name: '度盘|幸会粉' },
					{ color: '#bca280', name: '度盘|午后棕' },
					{ color: '#b673ab', name: '度盘|物语紫' },
					{ color: '#574AB8', name: '度盘|星空紫' },
					{ color: '#1d2327', name: 'OpenAI|默认黑' },
					{ color: '#18a497', name: 'OpenAI|默认青' },
					{ color: '#637dff', name: '度里叁|霞光紫' },
					{ color: '#0d53ff', name: '夸克|极简蓝' },
					{ color: '#3181f9', name: '移动|彩云蓝' },
					{ color: '#f8d800', name: '果核|柠檬黄' },
					{ color: '#0396ff', name: '果核|默认蓝' },
					{ color: '#32ccbc', name: '果核|碧波绿' },
					{ color: '#f6416c', name: '果核|玫瑰红' },
					{ color: '#2271b1', name: '文派|默认蓝' },
					{ color: '#59524c', name: '文派|咖啡灰' },
					{ color: '#ff679a', name: '哔哩|少女粉' },
					{ color: '#f44236', name: '哔哩|高能红' },
					{ color: '#fec107', name: '哔哩|咸蛋黄' },
					{ color: '#8bc24a', name: '哔哩|早苗绿' },
					{ color: '#2594ed', name: '哔哩|宝石蓝' },
					{ color: '#9c28b1', name: '哔哩|罗兰紫' }
				]
			}
		},
		$baidu: {
			api: {
				ua: {
					downloadLink: "pan.baidu.com"
				},
				getAccessToken: "https://openapi.baidu.com/oauth/2.0/authorize?response_type=token&scope=basic,netdisk&client_id=IlLqBbU3GjQ0t46TRwFateTprHWl39zF&redirect_uri=oob&confirm_login=0",
				getLink: "https://pan.baidu.com/rest/2.0/xpan/multimedia?method=filemetas&dlink=1",
				getFiles: "https://pan.baidu.com/rest/2.0/xpan/file?method=list&showempty=1",
				getShareLink: "https://pan.baidu.com/api/sharedownload?channel=chunlei&clienttype=0&web=1&app_id=250528",
				getShareInfo: "https://pan.baidu.com/share/tplconfig?fields=sign,timestamp&channel=chunlei&web=1&app_id=250528&clienttype=0",
				getShareFiles: "https://pan.baidu.com/rest/2.0/xpan/share?method=list&showempty=1"
			},
			mount: {
				home: ".frame-main>div>div>div>div:has(.g-dropdown-button.g-new-create)",
				main: ".wp-s-agile-tool-bar__header",
				share: ".module-share-top-bar .x-button-box .g-dropdown-button.tools-more"
			},
			dom: {
				enhance: `+<br/>此方式下载有可能会被 IDM 捕获下载链接`,
				normal: `+<br/>不允许超过 50MB 的文件，若超过点击会没有反应<br/>此方式下载有可能会被 IDM 捕获下载链接`,
				copy: `不建议使用本功能，在百度网盘中单独复制链接并粘贴下载可能会导致服务器回报 403 错误<br/>如仍需使用，请搭配此用户代理进行下载：pan.baidu.com`
			}
		},
		$aliyun: {
			api: {
				getLink: "https://api.aliyundrive.com/v2/file/get_download_url",
				getShareLink: "https://api.aliyundrive.com/v2/file/get_share_link_download_url"
			},
			mount: {
				home: `[class^="header--"]>[class^="actions--"]`,
				share: `[class^="banner--"]>[class^="right--"]`,
				list: `[class^="node-list-table-view--"]`,
				grid: `[class^="node-list-grid-view--"]`,
				switch: `[class^="switch-wrapper--"]`
			},
			dom: {
				enhance: `+<br/>此方式下载不会被 IDM 捕获下载链接`,
				normal: `+<br/>此方式下载有可能会被 IDM 捕获下载链接`,
				copy: `不建议使用本功能，在阿里云盘中单独复制链接并粘贴下载可能会导致服务器回报 403 错误`,
				filename: `阿里云盘于下载高峰期时可能不会显示文件名称，这时需要手动复制文件名称到下载工具中`
			}
		},
		$mcloud: {
			api: {
				getLink: "https://personal-kd-njs.yun.139.com/hcy/file/getDownloadUrl"
			},
			mount: {
				home: ".top_button",
				share: ".top-btns"
			},
			dom: {
				enhance: `+<br/>此方式下载不会被 IDM 捕获下载链接`,
				normal: `+<br/>此方式下载有可能会被 IDM 捕获下载链接`
			}
		},
		$tcloud: {
			api: {
				getAccessToken: "https://api.cloud.189.cn/open/oauth2/ssoH5.action",
				getLink: "https://api.cloud.189.cn/open/file/getFileDownloadUrl.action"
			},
			mount: {
				home: "[class*=\"FileHead_file-head-left\"]",
				share: ".nav-opea"
			},
			dom: {
				enhance: `+<br/>此方式下载不会被 IDM 捕获下载链接`,
				normal: `+<br/>此方式下载有可能会被 IDM 捕获下载链接`
			}
		},
		$xunlei: {
			api: {
				mirror: [
					"vod0007-h05-vip-lixian.xunlei.com", "vod0008-h05-vip-lixian.xunlei.com", "vod0009-h05-vip-lixian.xunlei.com", "vod0010-h05-vip-lixian.xunlei.com", "vod0011-h05-vip-lixian.xunlei.com", "vod0012-h05-vip-lixian.xunlei.com", "vod0013-h05-vip-lixian.xunlei.com", "vod0014-h05-vip-lixian.xunlei.com", "vod0067-aliyun08-vip-lixian.xunlei.com", "vod0254-aliyun08-vip-lixian.xunlei.com", "vod0255-aliyun08-vip-lixian.xunlei.com", "vod0256-aliyun08-vip-lixian.xunlei.com", "vod0257-aliyun08-vip-lixian.xunlei.com", "vod0258-aliyun08-vip-lixian.xunlei.com", "vod0259-aliyun08-vip-lixian.xunlei.com", "vod0260-aliyun08-vip-lixian.xunlei.com", "vod0261-aliyun08-vip-lixian.xunlei.com", "vod0262-aliyun08-vip-lixian.xunlei.com", "vod0263-aliyun08-vip-lixian.xunlei.com", "vod0264-aliyun08-vip-lixian.xunlei.com", "vod0265-aliyun08-vip-lixian.xunlei.com", "vod0266-aliyun08-vip-lixian.xunlei.com", "vod0267-aliyun08-vip-lixian.xunlei.com", "vod0554-aliyun06-vip-lixian.xunlei.com", "vod0555-aliyun06-vip-lixian.xunlei.com", "vod0556-aliyun06-vip-lixian.xunlei.com", "vod0680-aliyun08-vip-lixian.xunlei.com", "vod0681-aliyun08-vip-lixian.xunlei.com", "vod0682-aliyun08-vip-lixian.xunlei.com", "vod0683-aliyun08-vip-lixian.xunlei.com", "vod0684-aliyun08-vip-lixian.xunlei.com", "vod0685-aliyun08-vip-lixian.xunlei.com", "vod0686-aliyun08-vip-lixian.xunlei.com", "vod0687-aliyun08-vip-lixian.xunlei.com", "vod0688-aliyun08-vip-lixian.xunlei.com", "vod0689-aliyun08-vip-lixian.xunlei.com", "vod0690-aliyun08-vip-lixian.xunlei.com", "vod0724-aliyun08-vip-lixian.xunlei.com", "vod0725-aliyun08-vip-lixian.xunlei.com", "vod0726-aliyun08-vip-lixian.xunlei.com", "vod0727-aliyun08-vip-lixian.xunlei.com", "vod0728-aliyun08-vip-lixian.xunlei.com", "vod0075.aliyun06.vip.lixian.xunlei.com", "vod0076.aliyun06.vip.lixian.xunlei.com", "vod0077.aliyun06.vip.lixian.xunlei.com", "vod0779-aliyun04-vip-lixian.xunlei.com", "vod0078.aliyun06.vip.lixian.xunlei.com", "vod0780-aliyun04-vip-lixian.xunlei.com", "vod0781-aliyun04-vip-lixian.xunlei.com", "vod0079.aliyun06.vip.lixian.xunlei.com", "vod0080.aliyun06.vip.lixian.xunlei.com", "vod0117.aliyun04.vip.lixian.xunlei.com", "vod0118.aliyun04.vip.lixian.xunlei.com", "vod0119.aliyun04.vip.lixian.xunlei.com", "vod1284-aliyun06-vip-lixian.xunlei.com", "vod1285-aliyun06-vip-lixian.xunlei.com", "vod1363-aliyun06-vip-lixian.xunlei.com", "vod1371-aliyun06-vip-lixian.xunlei.com", "vod1372-aliyun06-vip-lixian.xunlei.com", "vod1426-aliyun06-vip-lixian.xunlei.com", "vod1427-aliyun06-vip-lixian.xunlei.com", "vod1428-aliyun06-vip-lixian.xunlei.com", "vod1429-aliyun06-vip-lixian.xunlei.com", "vod1442-aliyun06-vip-lixian.xunlei.com", "vod1443-aliyun06-vip-lixian.xunlei.com", "vod1444-aliyun06-vip-lixian.xunlei.com", "vod1445-aliyun06-vip-lixian.xunlei.com", "vod1446-aliyun06-vip-lixian.xunlei.com", "vod1447-aliyun06-vip-lixian.xunlei.com", "vod1469-aliyun06-vip-lixian.xunlei.com", "vod1470-aliyun06-vip-lixian.xunlei.com", "vod1471-aliyun06-vip-lixian.xunlei.com", "vod1489-aliyun06-vip-lixian.xunlei.com", "vod1490-aliyun06-vip-lixian.xunlei.com", "vod1491-aliyun06-vip-lixian.xunlei.com", "vod1492-aliyun06-vip-lixian.xunlei.com", "vod1493-aliyun06-vip-lixian.xunlei.com", "vod0215.aliyun06.vip.lixian.xunlei.com", "vod0216.aliyun06.vip.lixian.xunlei.com", "vod0217.aliyun06.vip.lixian.xunlei.com", "vod0218.aliyun06.vip.lixian.xunlei.com", "vod0219.aliyun06.vip.lixian.xunlei.com", "vod0220.aliyun06.vip.lixian.xunlei.com", "vod0241.aliyun08.vip.lixian.xunlei.com", "vod0244.aliyun08.vip.lixian.xunlei.com", "vod0251.aliyun08.vip.lixian.xunlei.com", "vod0252.aliyun08.vip.lixian.xunlei.com", "vod0253.aliyun08.vip.lixian.xunlei.com", "vod0254.aliyun08.vip.lixian.xunlei.com", "vod0255.aliyun08.vip.lixian.xunlei.com", "vod0256.aliyun08.vip.lixian.xunlei.com", "vod0257.aliyun08.vip.lixian.xunlei.com", "vod0260.aliyun08.vip.lixian.xunlei.com", "vod0261.aliyun08.vip.lixian.xunlei.com", "vod0262.aliyun08.vip.lixian.xunlei.com", "vod0263.aliyun08.vip.lixian.xunlei.com", "vod0264.aliyun08.vip.lixian.xunlei.com", "vod0265.aliyun08.vip.lixian.xunlei.com", "vod0266.aliyun08.vip.lixian.xunlei.com", "vod0267.aliyun08.vip.lixian.xunlei.com", "vod3379-aliyun04-vip-lixian.xunlei.com", "vod3380-aliyun04-vip-lixian.xunlei.com", "vod3429-aliyun04-vip-lixian.xunlei.com", "vod3458-aliyun04-vip-lixian.xunlei.com", "vod3459-aliyun04-vip-lixian.xunlei.com", "vod3496-aliyun04-vip-lixian.xunlei.com", "vod3497-aliyun04-vip-lixian.xunlei.com", "vod3498-aliyun04-vip-lixian.xunlei.com", "vod3499-aliyun04-vip-lixian.xunlei.com", "vod3500-aliyun04-vip-lixian.xunlei.com", "vod3501-aliyun04-vip-lixian.xunlei.com", "vod3522-aliyun04-vip-lixian.xunlei.com", "vod3523-aliyun04-vip-lixian.xunlei.com", "vod3533-aliyun04-vip-lixian.xunlei.com", "vod3534-aliyun04-vip-lixian.xunlei.com", "vod3535-aliyun04-vip-lixian.xunlei.com", "vod3536-aliyun04-vip-lixian.xunlei.com", "vod3549-aliyun04-vip-lixian.xunlei.com", "vod3550-aliyun04-vip-lixian.xunlei.com", "vod3551-aliyun04-vip-lixian.xunlei.com", "vod3552-aliyun04-vip-lixian.xunlei.com", "vod3553-aliyun04-vip-lixian.xunlei.com", "vod3554-aliyun04-vip-lixian.xunlei.com", "vod3555-aliyun04-vip-lixian.xunlei.com", "vod0551.aliyun06.vip.lixian.xunlei.com", "vod0552.aliyun06.vip.lixian.xunlei.com", "vod0553.aliyun06.vip.lixian.xunlei.com", "vod0554.aliyun06.vip.lixian.xunlei.com", "vod0555.aliyun06.vip.lixian.xunlei.com", "vod0556.aliyun06.vip.lixian.xunlei.com", "vod0686.aliyun08.vip.lixian.xunlei.com", "vod0687.aliyun08.vip.lixian.xunlei.com", "vod0688.aliyun08.vip.lixian.xunlei.com", "vod0689.aliyun08.vip.lixian.xunlei.com", "vod0724.aliyun08.vip.lixian.xunlei.com", "vod0725.aliyun08.vip.lixian.xunlei.com", "vod0726.aliyun08.vip.lixian.xunlei.com", "vod0727.aliyun08.vip.lixian.xunlei.com", "vod0728.aliyun08.vip.lixian.xunlei.com", "vod0759.aliyun04.vip.lixian.xunlei.com", "vod0760.aliyun04.vip.lixian.xunlei.com", "vod0769.aliyun04.vip.lixian.xunlei.com", "vod0770.aliyun04.vip.lixian.xunlei.com", "vod0771.aliyun04.vip.lixian.xunlei.com", "vod0772.aliyun04.vip.lixian.xunlei.com", "vod0773.aliyun04.vip.lixian.xunlei.com", "vod0774.aliyun04.vip.lixian.xunlei.com", "vod0775.aliyun04.vip.lixian.xunlei.com", "vod0776.aliyun04.vip.lixian.xunlei.com", "vod0777.aliyun04.vip.lixian.xunlei.com", "vod0778.aliyun04.vip.lixian.xunlei.com", "vod0779.aliyun04.vip.lixian.xunlei.com", "vod0780.aliyun04.vip.lixian.xunlei.com", "vod0781.aliyun04.vip.lixian.xunlei.com", "vod3522.aliyun04.vip.lixian.xunlei.com", "vod3523.aliyun04.vip.lixian.xunlei.com", "vod3533.aliyun04.vip.lixian.xunlei.com", "vod3535.aliyun04.vip.lixian.xunlei.com", "vod3550.aliyun04.vip.lixian.xunlei.com", "vod3551.aliyun04.vip.lixian.xunlei.com", "vod3552.aliyun04.vip.lixian.xunlei.com", "vod3553.aliyun04.vip.lixian.xunlei.com", "vod3554.aliyun04.vip.lixian.xunlei.com", "vod3555.aliyun04.vip.lixian.xunlei.com"
				],
				getLink: "https://api-pan.xunlei.com/drive/v1/files/"
			},
			mount: {
				home: `[class^="FileMenu__menu--"]`,
				share: `[class^="Share__batchActionBox--"]`
			},
			dom: {
				enhance: `+<br/>此方式下载不会被 IDM 捕获下载链接，但可以自动命名`,
				normal: `+<br/>此方式下载不会被 IDM 捕获下载链接`,
				filename: `迅雷云盘下载时可能不会回报文件名称给下载工具，这时需要手动复制文件名称到下载工具中`
			}
		},
		$quark: {
			api: {
				ua: {
					downloadLink: "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) quark-cloud-drive/2.5.20 Chrome/100.0.4896.160 Electron/18.3.5.4-b478491100 Safari/537.36 Channel/pckk_other_ch"
				},
				getLink: "https://drive.quark.cn/1/clouddrive/file/download?pr=ucpro&fr=pc"
			},
			mount: {
				home: ".btn-operate .btn-main",
				share: ".share-btns"
			},
			dom: {
				enhance: `+<br/>此方式下载不会被 IDM 捕获下载链接`,
				normal: `+<br/>此方式下载有可能会被 IDM 捕获下载链接`
			}
		},
		$uc: {
			api: {
				ua: {
					downloadLink: "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) uc-cloud-drive/2.5.20 Chrome/100.0.4896.160 Electron/18.3.5.4-b478491100 Safari/537.36 Channel/pckk_other_ch"
				},
				getLink: "https://pc-api.uc.cn/1/clouddrive/file/download?pr=UCBrowser&fr=pc"
			},
			mount: {
				home: ".btn-operate .btn-main",
				share: ".file-info-share-buttom"
			},
			dom: {
				enhance: `+<br/>此方式下载不会被 IDM 捕获下载链接`,
				normal: `+<br/>此方式下载有可能会被 IDM 捕获下载链接`
			}
		},
		$123pan: {
			api: {
				getLink: "https://www.123pan.com/api/file/download_info",
				getShareLink: "https://www.123pan.com/api/share/download/info"
			},
			mount: {
				home: "main .homeClass .home-operator .home-operator-button-group",
				share: ".conter .rightInfo",
				shareNew: ".content .content-header-container-wrap .rightInfo"
			},
			dom: {
				enhance: `+<br/>此方式下载不会被 IDM 捕获下载链接`,
				normal: `+<br/>此方式下载有可能会被 IDM 捕获下载链接`
			}
		}
	}
	/**
	 * 基础工具集合
	 * @author 油小猴
	 * @author hmjz100
	 */
	let base = {
		/**
		 * 注册 GreaseMonkey-Compatible-Manager 扩展菜单命令
		 * @author 油小猴
		 * @author hmjz100
		 * @description 包含 "设置"、"美化"、"更新" 和 "调试" 四个功能入口
		 */
		registerMenuCommand() {
			GM_registerMenuCommand('⚙️ 设置', () => {
				base.showSetting();
			});
			GM_registerMenuCommand('🍃️ 美化', () => {
				base.showBeautify();
			});
			GM_registerMenuCommand('📃 更新', () => {
				base.showUpdate();
			});
			GM_registerMenuCommand('🛠️ 调试', () => {
				base.showDebug();
			});
		},
		/**
		 * 判断 JavaScript 对象类型
		 * @author 油小猴
		 * @description 通过 Object.prototype.toString 精确识别对象类型
		 * @param {*} obj - 待检测对象
		 * @returns {string} 类型名称（全小写），如：array/number/null/date 等
		 * @example
		 * isType([]) // => "array"
		 * isType(null) // => "null"
		 */
		isType(obj) {
			return Object.prototype.toString.call(obj).replace(/^\[object (.+)\]$/, '$1').toLowerCase();
		},
		/**
		 * 获取 GreaseMonkey-Compatible-Manager 存储的值
		 * @author 油小猴
		 * @param {string} name - 存储键名
		 * @returns {*} 存储的值
		 */
		getValue(name) {
			return GM_getValue(name);
		},
		/**
		 * 设置 GreaseMonkey-Compatible-Manager 存储的值
		 * @author 油小猴
		 * @param {string|array} path - 存储键名或路径数组
		 * @param {*} value - 要存储的值
		 */
		setValue(path, value) {
			if (base.isType(path) === 'string') {
				GM_setValue(path, value);
				return;
			}
			let key = path[0];
			let obj = this.getValue(key) || {};
			let current = obj;
			for (let i = 1; i < path.length - 1; i++) {
				let keyPart = path[i];
				if (!current[keyPart]) current[keyPart] = "";
				current = current[keyPart];
			}
			current[path[path.length - 1]] = value;
			GM_setValue(key, obj);
		},
		/**
		 * 删除 GreaseMonkey-Compatible-Manager 存储的值
		 * @author 油小猴
		 * @param {string|array} key - 单个键名
		 */
		delValue(key) {
			return GM_deleteValue(key);
		},
		/**
		 * 从 localStorage 获取存储值
		 * @description 自动解析 JSON 格式内容
		 * @author 油小猴
		 * @param {string} key - 存储键名
		 * @returns {*} 存储的原始值或解析后的对象
		 */
		getStorage(key) {
			try {
				return JSON.parse(localStorage.getItem(key));
			} catch (e) {
				return localStorage.getItem(key);
			}
		},
		/**
		 * 设置 localStorage 存储值
		 * @author 油小猴
		 * @description 自动 `JSON.stringify` `对象` `数组` 类型的数据
		 * @param {string} key - 存储键名
		 * @param {*} value - 要存储的值
		 */
		setStorage(key, value) {
			if (this.isType(value) === 'object' || this.isType(value) === 'array') {
				return localStorage.setItem(key, JSON.stringify(value));
			}
			return localStorage.setItem(key, value);
		},
		/**
		 * 删除 localStorage 存储值
		 * @author 油小猴
		 * @description 没什么特别的
		 * @param {string} key - 存储键名
		 */
		delStorage(key) {
			return localStorage.removeItem(key);
		},
		/**
		 * 剪贴板写入
		 * @author 油小猴
		 * @param {string} text - 要复制的文本内容
		 */
		setClipboard(text) {
			GM_setClipboard(text, 'text');
		},
		/**
		 * Base64-URI 编码处理
		 * @author 油小猴
		 * @author hmjz100
		 * @description 自动执行 URI 兼容性编码转换
		 * @param {string} str - 待编码的字符串
		 * @returns {string} Base64 编码结果字符串
		 */
		encodeBase(str) {
			try { str = btoa(str) } catch { }
			return str;
		},
		/**
		 * Base64-URI 解码处理
		 * @author 油小猴
		 * @author hmjz100
		 * @description 自动执行 URI 兼容性解码转换
		 * @param {string} str - Base64 编码字符串
		 * @returns {string} 解码后的原始字符串
		 */
		decodeBase(str) {
			try { str = decodeURIComponent(str) } catch { }
			try { str = atob(str) } catch { }
			try { str = decodeURIComponent(str) } catch { }
			return str;
		},
		/**
		 * 数字补零格式化
		 * @author hmjz100
		 * @description 对 1-9 的数字自动补前导零
		 * @param {number} i - 待格式化的数字
		 * @returns {string} 格式化后的字符串（如"05"）
		 */
		timeFormat(i) {
			if (i >= 0 && i <= 9) {
				return "0" + i;
			} else {
				return i;
			}
		},
		/**
		 * 获取文件扩展名并转为大写
		 * @author 油小猴
		 * @param {string} name - 完整文件名
		 * @returns {string} 大写的文件扩展名（如 `TXT`）
		 */
		getExtension(name) {
			let reg = /(?!\.)\w+$/;
			if (reg.test(name)) {
				let match = name.match(reg);
				return match[0].toUpperCase();
			}
			return "";
		},
		/**
		 * 文件大小格式化
		 * @author hmjz100
		 * @description 自动转换单位到最合适的存储单位（如 `1.2MB`）
		 * @param {number} value - 文件字节大小
		 * @returns {string} 可读格式的大小描述
		 */
		sizeFormat(value = 0) {
			try { value = Number(value) } catch { }
			if (value === +value) {
				let unit = ["字节(B)", "千字节(KB)", "兆字节(MB)", "吉字节(GB)", "太字节(TB)", "拍字节(PB)", "艾字节(EB)", "泽字节(ZB)", "尧字节(YB)"];
				if (value === 0) {
					return "0字节(B)";
				} else {
					let index = Math.floor(Math.log(value) / Math.log(1024));
					let size = value / Math.pow(1024, index);
					size = size.toFixed(2);
					return size + unit[index];
				}
			}
			return "";
		},
		/**
		 * 将剩余时间（秒）格式化为可读的时间字符串
		 *
		 * @param {number} remainingTimeSeconds 剩余总秒数（支持小数）
		 * @returns {string} 格式化后的时间字符串，包含以下可能格式：
		 *   - "X天 HH时:MM分:SS秒"（超过1天）
		 *   - "HH时:MM分:SS秒"（超过1小时）
		 *   - "MM分:SS秒"（超过1分钟）
		 *   - "SS秒"（1分钟内）
		 *   - "即将完成"（0秒时）
		 *   - "计算中..."（无效输入时）
		 *
		 * @example
		 * formatRemainingTime(86400) // "1天 00时:00分:00秒"
		 * formatRemainingTime(3661.5) // "01时:01分:01秒"
		 * formatRemainingTime(0) // "即将完成"
		 * formatRemainingTime(-5) // "计算中..."
		 * formatRemainingTime(NaN) // "计算中..."
		 */
		rtimeFormat(remainingTimeSeconds) {
			if (!Number.isFinite(remainingTimeSeconds) || remainingTimeSeconds < 0) {
				return '计算中...';
			}
			let remainingDays = Math.floor(remainingTimeSeconds / (60 * 60 * 24));
			remainingTimeSeconds %= (60 * 60 * 24);
			let remainingHours = Math.floor(remainingTimeSeconds / (60 * 60));
			remainingTimeSeconds %= (60 * 60);
			let remainingMinutes = Math.floor(remainingTimeSeconds / 60);
			let remainingSeconds = Math.floor(remainingTimeSeconds % 60);
			if (remainingDays > 0) {
				return `${remainingDays}天 ${base.timeFormat(remainingHours)}时:${base.timeFormat(remainingMinutes)}分:${base.timeFormat(remainingSeconds)}秒`;
			} else if (remainingHours > 0) {
				return `${base.timeFormat(remainingHours)}时:${base.timeFormat(remainingMinutes)}分:${base.timeFormat(remainingSeconds)}秒`;
			} else if (remainingMinutes > 0) {
				return `${base.timeFormat(remainingMinutes)}分:${base.timeFormat(remainingSeconds)}秒`;
			} else if (remainingSeconds > 0) {
				return `${remainingSeconds}秒`;
			} else {
				return '即将完成';
			}
		},
		/**
		 * 文件列表排序
		 * @author 油小猴
		 * @description 按中文拼音顺序对文件数组进行排序
		 * @param {Array} arr - 包含文件对象的数组
		 * @param {string} arr[].filename - 文件名属性（兼容 server_filename）
		 */
		sortByName(arr) {
			let handle = () => {
				return (a, b) => {
					let p1 = a.filename ? a.filename : a.server_filename;
					let p2 = b.filename ? b.filename : b.server_filename;
					return p1.localeCompare(p2, "zh-CN");
				};
			};
			arr.sort(handle());
		},
		/**
		 * 文件名安全处理
		 * @author 油小猴
		 * @description 替换非法字符为下划线
		 * @param {string} name - 原始文件名
		 * @returns {string} 修正后的安全文件名
		 */
		fixFilename(name) {
			let replace = /[!?&|`"'*\/:<>\\]/g
			return name.replace(replace, '_');
		},
		/**
		 * 生成 cURL 下载命令
		 * @author 油小猴
		 * @author hmjz100
		 * @description 根据终端类型生成对应 curl 命令，支持断点续传，自动处理文件名特殊字符
		 * @param {string} link - 下载链接
		 * @param {string} filename - 文件名
		 * @param {string} [headers] - 自定义请求头参数（可选）
		 * @returns {string} 编码后的 curl 命令字符串
		 */
		convertLinkToCurl(link, filename, headers) {
			let terminal = base.getValue('setting_curl_terminal');
			filename = base.fixFilename(filename);
			return `${terminal !== 'wp' ? 'curl' : 'curl.exe'} -L -C - "${link}" -o "${filename}"${headers ? (" " + headers) : ""}`;
		},
		/**
		 * 生成 Aria2 下载命令
		 * @author 油小猴
		 * @author hmjz100
		 * @description 将链接转换为 Aria2 格式命令，自动处理文件名特殊字符
		 * @param {string} link - 下载链接
		 * @param {string} filename - 文件名
		 * @param {string} [headers] - 自定义请求头参数（可选）
		 * @returns {string} 编码后的 aria2c 命令字符串
		 */
		convertLinkToAria2(link, filename, headers) {
			filename = base.fixFilename(filename);
			return `aria2c "${link}" --out "${filename}"${headers ? (" " + headers) : ""}`;
		},
		/**
		 * 生成 BC 协议下载链接
		 * @author 油小猴
		 * @author hmjz100
		 * @description 将链接转换为 BC 协议格式，自动处理 URL 编码
		 * @param {string} link - 下载链接
		 * @param {string} filename - 文件名
		 * @param {string} [headers] - 自定义请求头参数（可选）
		 * @returns {string} 编码后的 BC 协议 URL
		 */
		convertLinkToBitComet(link, filename, headers) {
			filename = base.fixFilename(filename);
			let bc = `AA/${encodeURIComponent(filename)}/?url=${encodeURIComponent(link)}${headers ? ("&" + headers) : ""}ZZ`;
			return `bc://http/${base.encodeBase(bc)}`;
		},
		/**
		 * 发送链接到 Aria2 下载器
		 * @author 油小猴
		 * @author hmjz100
		 * @description Aria2 下载必备
		 * @param {string} link - 下载链接
		 * @param {string} filename - 文件名
		 * @param {Array} [headers] - 自定义请求头参数（可选）
		 * @returns {Promise<'success'|'fail'>} 发送态结果
		 */
		async sendLinkToAria2(link, filename, headers) {
			let list = base.getValue('setting_aria2_rpc');
			let selected = list.find(i => i.default);
			let rpc = {
				domain: selected.domain,
				port: selected.port,
				path: selected.path,
				dir: selected.dir,
				token: selected.token
			};
			let url = `${rpc.domain}:${rpc.port}${rpc.path}`;
			let dir = (rpc.dir !== null && rpc.dir !== "") ? rpc.dir : undefined;
			let data = {
				id: new Date().getTime(),
				jsonrpc: '2.0',
				method: 'aria2.addUri',
				params: [`token:${rpc.token}`, [link], {
					dir,
					out: filename,
					header: headers
				}]
			};
			try {
				let res = await base.post(url, data, {}, "");
				if (res.result) return 'success';
				return 'fail';
			} catch (e) {
				return 'fail';
			}
		},
		/**
		 * 发送链接到比特彗星下载器
		 * @author hmjz100
		 * @description 比特彗星下载必备
		 * @param {string} link - 下载链接
		 * @param {string} filename - 文件名
		 * @param {Array} [headers] - 自定义请求头参数（可选）
		 * @returns {Promise<'success'|'fail'>} 发送态结果
		 */
		async sendLinkToBitcomet(link, filename, headers) {
			let list = base.getValue('setting_bitcomet_rpc');
			let selected = list.find(i => i.default);
			let rpc = {
				domain: selected.domain,
				port: selected.port,
				path: selected.path,
				dir: selected.dir,
				authName: selected.authName,
				authPass: selected.authPass,
			};
			let url = `${rpc.domain}:${rpc.port}${rpc.path}`;
			let data = new URLSearchParams();
			data.append('url', link);
			if (rpc.dir !== null && rpc.dir !== "") data.append('save_path', rpc.dir);
			data.append('file_name', filename);
			data.append('connection', 200);
			if (headers && base.isType(headers) === 'object') {
				for (const [key, value] of Object.entries(headers)) {
					data.append(key, value);
				}
			}
			try {
				let res = await base.post(url, data, {
					"Authorization": `Basic ${base.encodeBase(rpc.authName + ":" + rpc.authPass)}`,
					"Content-Type": "application/x-www-form-urlencoded"
				}, "blob");
				if (res.response && res?.responseText?.includes('Add task failed!')) {
					return 'fail';
				} else {
					return "success";
				}
			} catch (e) {
				return "success";
			}
		},
		/**
		 * 发送链接到 AB Download Manager 下载器
		 * @author hmjz100
		 * @description AB Download Manager 下载必备
		 * @param {string} link - 下载链接
		 * @param {string} filename - 文件名
		 * @param {Array} [headers] - 自定义请求头参数（可选）
		 * @returns {Promise<'success'|'fail'>} 发送态结果
		 */
		async sendLinkToABDM(link, filename, headers) {
			let newHeaders = {};
			for (let key in headers) {
				newHeaders[key.toLowerCase().split('-').map(word => word.charAt(0).toUpperCase() + word.slice(1)).join('-')] = headers[key];
			}
			headers = { "User-Agent": navigator.userAgent, "Origin": location.origin, "Referer": `${location.origin}/`, "DNT": "1", ...newHeaders };
			let list = base.getValue('setting_abdm_rpc');
			let selected = list.find(i => i.default);
			let rpc = {
				domain: selected.domain,
				port: selected.port,
				dir: selected.dir
			};
			let url = `${rpc.domain}:${rpc.port}/start-headless-download`;
			let data = {
				"downloadSource": {
					"name": filename,
					"description": "LinkSwift",
					"link": link,
					"headers": headers,
					"downloadPage": headers["Referer"]
				},
				"name": filename
			}
			if (rpc.dir) data.folder = rpc.dir;
			try {
				let res = await base.post(url, data, { "Content-Type": "text/plain;charset=UTF-8" }, "text");
				if (res === "OK") return "success";
				return 'fail';
			} catch (e) {
				return 'fail';
			}
		},
		/**
		 * Blob 文件下载
		 * @author 油小猴
		 * @description 通过创建临时链接实现文件下载
		 * @param {Blob} blob - 要下载的 Blob 对象
		 * @param {string} filename - 下载时提示保存的文件名
		 */
		blobDownload(blob, filename) {
			if (blob instanceof Blob) {
				let url = URL.createObjectURL(blob);
				let a = document.createElement('a');
				a.href = url;
				a.download = filename;
				a.click();
				URL.revokeObjectURL(url);
			}
		},
		/**
		 * 可跨域 xmlhttpRequest 请求
		 * @author hmjz100
		 * @description 封装 `GreaseMonkey-Compatible_xmlhttpRequest` 实现的跨域请求，与原始函数参数相同
		 * @param {Object} option - 请求配置对象
		 * @returns {XMLHttpRequest} 请求对象实例
		 */
		xmlHttpRequest(option) {
			let request = (base.isType(GM_xmlhttpRequest) !== "undefined") ? GM_xmlhttpRequest : GM.xmlHttpRequest;
			if (request && base.isType(request) === 'function') return request(option);
		},
		/**
		 * 发送 POST 请求
		 * @author 油小猴
		 * @author hmjz100
		 * @description 一般用于请求 API，支持自动重试和数据格式化，内置错误处理，请求数据自动 `JSON.stringify`
		 * @param {string} url - 请求地址
		 * @param {Object|string} data - 请求数据
		 * @param {Object} headers - 请求头配置
		 * @param {string} [type='json'] - 响应类型（支持 `json`, `blob` 等）
		 * @returns {Promise} 包含响应数据的 `Promise` 对象
		 */
		post(url, data, headers, type = "json") {
			let exampleData = data;
			if (this.isType(data) === 'object' || this.isType(data) === 'array') {
				data = JSON.stringify(data);
			} else if (this.isType(data) === 'urlsearchparams') {
				exampleData = Object.fromEntries(data);
			}
			let newHeaders = {};
			for (let key in headers) {
				newHeaders[key.toLowerCase().split('-').map(word => word.charAt(0).toUpperCase() + word.slice(1)).join('-')] = headers[key];
			}
			headers = { "Content-Type": "application/json;charset=utf-8", "User-Agent": navigator.userAgent, "Origin": location.origin, "Referer": `${location.origin}/`, "Dnt": "", "Cache-Control": "no-cache", "Pragma": "no-cache", "Expires": "0", ...newHeaders };
			return new Promise((resolve, reject) => {
				let sendRequest = () => {
					base.xmlHttpRequest({
						method: "POST", url, headers, data,
						responseType: type,
						onloadstart() {
							console.log('【LinkSwift】Post(start)\n请求地址：' + url + '\n请求头部：', headers, '\n请求数据：', exampleData);
						},
						onload: function (res) {
							console.log('【LinkSwift】Post(load)\n请求地址：' + url, '\n请求结果：', res);
							try { res.decodeResponse = JSON.parse(res.response) } catch { }
							type === 'blob' ? resolve(res) : resolve(res.decodeResponse || res.response || res.responseText);
						},
						onerror: async function (err) {
							console.error('【LinkSwift】Post(error)\n请求出现错误，可能是网络问题。', err);
							reject(err);
						},
					});
				};
				sendRequest(); // 初始请求
			});
		},
		/**
		 * 发送 GET 请求
		 * @author 油小猴
		 * @author hmjz100
		 * @description 一般用于下载文件，支持进度监控、文件下载和自动重试，可处理被下载工具捕获特殊逻辑
		 * @param {string} url - 请求地址
		 * @param {Object} headers - 请求头配置
		 * @param {string} [type='json'] - 响应类型
		 * @param {Object} [extra] - 附加参数（需包含 `filename` 和 `index` 属性）
		 * @returns {Promise} 包含响应数据的 `Promise` 对象
		 */
		get(url, headers, type, extra) {
			let newHeaders = {};
			for (let key in headers) {
				newHeaders[key.toLowerCase().split('-').map(word => word.charAt(0).toUpperCase() + word.slice(1)).join('-')] = headers[key];
			}
			headers = { "User-Agent": navigator.userAgent, "Origin": location.origin, "Referer": `${location.origin}/`, "Dnt": "", "Cache-Control": "no-cache", "Pragma": "no-cache", "Expires": "0", ...newHeaders };
			return new Promise((resolve, reject) => {
				let sendRequest = () => {
					let requestObj = base.xmlHttpRequest({
						method: "GET", url, headers,
						responseType: type || 'json',
						onload: function (res) {
							try { res.decodeResponse = JSON.parse(res.response) } catch { }
							if (res.status === 204) {
								console.log('【LinkSwift】Get(load)\n\x1B[31m该请求已被某个下载工具捕获。' + (res.statusText ? ("\n\x1B[0m工具提示：\x1B[31m" + res.statusText) : "") + '\x1B[0m\n请求地址：' + url + '\n请求头部：', headers, '\n请求结果：', res);
								requestObj.abort();
								temp.idm[extra.index] = true;
								return;
							}
							if (type === 'blob') {
								console.log('【LinkSwift】Get(load) Blob\n请求地址：' + url, '\n请求结果：', res);
								res.status === 200 && base.blobDownload(res.response, extra.filename);
								resolve(res);
							} else {
								console.log('【LinkSwift】Get(load)\n请求地址：' + url + '\n请求头部：', headers, '\n请求结果：', res);
								resolve(res.decodeResponse || res.response || res.responseText);
							}
						},
						onprogress: function (res) {
							if (res.status === 204) {
								console.log('【LinkSwift】Get(progress)\n\x1B[31m该请求已被某个下载工具捕获。' + (res.statusText ? ("\n\x1B[0m工具提示：\x1B[31m" + res.statusText) : "") + '\x1B[0m\n请求地址：' + url + '\n请求头部：', headers, '\n请求结果：', res);
								requestObj.abort();
								temp.idm[extra.index] = true;
								return;
							}
							if (extra && res.loaded && res.total && extra.filename && extra.index) {
								res.total > 0 ? temp.progress[extra.index] = (res.loaded * 100 / res.total) : temp.progress[extra.index] = 0.00;
							}
						},
						onloadstart(res) {
							if (res.status === 204) {
								console.log('【LinkSwift】Get(start)\n\x1B[31m该请求已被某个下载工具捕获。' + (res.statusText ? ("\n\x1B[0m工具提示：\x1B[31m" + res.statusText) : "") + '\x1B[0m\n请求地址：' + url + '\n请求头部：', headers, '\n请求结果：', res);
								requestObj.abort();
								temp.idm[extra.index] = true;
								return;
							}
							console.log('【LinkSwift】Get(start)\n请求地址：' + url + '\n请求头部：', headers);
							if (extra && extra.filename && extra.index) temp.request[extra.index] = requestObj;
						},
						onerror: async function (err) {
							console.error('【LinkSwift】Get(error)\n请求出现错误，可能是网络问题。', err);
							reject(err);
						},
					});
				};
				sendRequest(); // 初始请求
			});
		},
		/**
		 * 获取最终重定向 URL
		 * @author 油小猴
		 * @author hmjz100
		 * @description 手动追踪 HTTP 30x 重定向，返回最终访问地址
		 * @param {string} url - 初始请求地址
		 * @param {Object} headers - 请求头配置
		 * @param {boolean} unLimit - 是否完整请求整个文件而不是仅请求请求头
		 * @returns {Promise<string>} 最终 URL 地址
		 */
		getFinalUrl(url, headers, unLimit) {
			return new Promise((resolve, reject) => {
				if (unLimit === true) {
					base.xmlHttpRequest({
						method: "GET",
						url: url,
						headers: headers,
						onloadstart: () => {
							console.log('【LinkSwift】Get(start) FinalUrl\n请求地址：' + url + '\n请求头部：', headers);
						},
						onload: function (res) {
							console.log('【LinkSwift】Get(load) FinalUrl\n请求地址：' + res.finalUrl + '\n响应状态：' + res.status);
							let status = res.status;
							if (status >= 300 && status < 400) {
								base.getFinalUrl(res.finalUrl, headers, maxRetries, currentRetry + 1).then(resolve).catch(reject);
							} else {
								resolve(res.finalUrl);
							}
						},
						onerror: async function (err) {
							console.error('【LinkSwift】Get(error) FinalUrl\n请求出现错误，可能是网络问题。', err);
							reject(err);
						}
					});
				} else {
					base.xmlHttpRequest({
						method: "HEAD",
						url: url,
						headers: headers,
						onloadstart: () => {
							console.log('【LinkSwift】Head(start) FinalUrl\n请求地址：' + url + '\n请求头部：', headers);
						},
						onload: function (res) {
							console.log('【LinkSwift】Head(load) FinalUrl\n请求地址：' + res.finalUrl + '\n响应状态：' + res.status);
							let status = res.status;
							if (status >= 300 && status < 400) {
								base.getFinalUrl(res.finalUrl, headers, maxRetries, currentRetry + 1).then(resolve).catch(reject);
							} else {
								resolve(res.finalUrl);
							}
						},
						onerror: async function (err) {
							console.error('【LinkSwift】Head(error) FinalUrl\n请求出现错误，可能是网络问题。', err);
							reject(err);
						}
					});
				}
			});
		},
		/**
		 * Aria2 RPC 服务测试
		 * @author hmjz100
		 * @description 验证 `JSON-RPC` 接口可用性
		 * @param {string} domain - 服务域名
		 * @param {string} port - 服务端口
		 * @param {string} path - RPC 路径
		 * @param {string} token - 认证令牌
		 * @returns {Promise<'success'|'fail'>} 连接状态结果
		 */
		async testConnectToAria2(domain, port, path, token) {
			return new Promise((resolve, reject) => {
				let rpc = { domain, port, path, token };
				let url = `${rpc.domain}:${rpc.port}${rpc.path}`;
				let rpcData = {
					id: new Date().getTime(),
					jsonrpc: '2.0',
					method: 'aria2.getVersion',
					params: [`token:${rpc.token}`]
				};
				base.xmlHttpRequest({
					method: "POST", url, headers: {}, data: JSON.stringify(rpcData),
					responseType: 'json',
					onloadstart() {
						console.log('【LinkSwift】Post(start) Aria2Test\n请求地址：' + url + '\n请求内容：', rpcData);
					},
					onload: function (res) {
						console.log('【LinkSwift】Post(load) Aria2Test\n请求地址：' + url + '\n请求结果：', res);
						if (!res.response) return resolve("fail");
						if (res.response?.error) {
							resolve("fail");
						} else {
							resolve("success");
						}
					},
					onerror: function (err) {
						console.error('【LinkSwift】Post(error) Aria2Test\n请求失败', err);
						resolve("fail");
					},
				});
			});
		},
		/**
		 * AB Download Manager RPC 服务测试
		 * @author hmjz100
		 * @description 验证 `JSON-RPC` 接口可用性
		 * @param {string} domain - 服务域名
		 * @param {string} port - 服务端口
		 * @returns {Promise<'success'|'fail'>} 连接状态结果
		 */
		async testConnectToABDM(domain, port) {
			return new Promise((resolve, reject) => {
				let rpc = { domain, port };
				let url = `${rpc.domain}:${rpc.port}/ping`;
				base.xmlHttpRequest({
					method: "POST", url, headers: {}, data: new Date().getTime(),
					responseType: 'text',
					onloadstart() {
						console.log('【LinkSwift】Post(start) ABDMTest\n请求地址：' + url + '\n请求内容：', new Date().getTime());
					},
					onload: function (res) {
						console.log('【LinkSwift】Post(load) ABDMTest\n请求地址：' + url + '\n请求结果：', res);
						if (!res.response || res.response !== "pong") return resolve("fail");
						resolve("success");
					},
					onerror: function (err) {
						console.error('【LinkSwift】Post(error) ABDMTest\n请求失败', err);
						resolve("fail");
					},
				});
			});
		},
		/**
		 * 重置请求相关数据
		 * @author 油小猴
		 * @description 中止所有进行中的请求，清除进度记录和定时器
		 */
		_resetAllData() {
			temp.progress = {};
			$.each(temp.request, function (key) {
				(temp.request[key]).abort();
			});
			$.each(temp.ins, function (key) {
				clearInterval(temp.ins[key]);
			});
			temp.idm = {};
			temp.ins = {};
			temp.request = {};
		},
		/**
		 * 重置请求相关数据
		 * @author 油小猴
		 * @description 中止指定的进行中的请求，清除进度记录和定时器
		 */
		_resetData(i) {
			temp.ins[i] && clearInterval(temp.ins[i]);
			temp.request[i] && temp.request[i].abort();
			temp.progress[i] = 0;
			temp.idm[i] = false;
		},
		/**
		 * 将对象转换为 URL 编码字符串
		 * @author 油小猴
		 * @description 递归处理嵌套数组，自动进行 URI 编码
		 * @param {Object} obj - 待转换的键值对对象
		 * @returns {string} URL 编码格式字符串（如`key1=value1&key2=value2`）
		 */
		stringify(obj) {
			let str = "";
			for (let key in obj) {
				if (obj.hasOwnProperty(key)) {
					let value = obj[key];
					if (Array.isArray(value)) {
						for (let i = 0; i < value.length; i++) {
							str += encodeURIComponent(key) + '=' + encodeURIComponent(value[i]) + '&';
						}
					} else {
						str += encodeURIComponent(key) + '=' + encodeURIComponent(value) + '&';
					}
				}
			}
			return str.slice(0, -1); // 去掉末尾的 "&"
		},
		/**
		 * 动态注入样式表
		 * @author 油小猴
		 * @author hmjz100
		 * @description 支持 `样式标签` `外链CSS` 注入，提供精准的 DOM 定位和插入位置控制
		 * @param {string} id - 样式元素 ID
		 * @param {'style'|'link'} tag - 标签类型（`style` 或 `link`）
		 * @param {string} css - CSS 内容或外链 URL
		 * @param {string} [element='.{mount}'] - 定位基准元素选择器
		 * @param {'before'|'after'|'prepend'|'append'} [position='append'] - 插入位置
		 */
		addStyle(id, tag = 'style', css, element = `.${mount}`, position = "append") {
			base.waitForKeyElements(element, (element) => {
				let $styleDom = $(`[${mount}="${id}"], #${id}`);
				let $style = $(`<${tag}>`, {
					rel: 'stylesheet',
					id: id,
					[mount]: id
				});
				tag === 'style' ? $style.html(css.trim().replace(/\t/g, "").replace(/\r\n|\n\r|\n|\r/g, '\n').replace(/\n+/g, '\n')) : $style.attr('href', css);
				if ($styleDom.length) {
					$styleDom.replaceWith($style);
					console.log($style[0])
					return true;
				}
				if (position === "before") {
					element.before($style);
				} else if (position === "after") {
					element.after($style);
				} else if (position === "prepend") {
					element.prepend($style);
				} else {
					element.append($style);
				}
				// return true;
			}, true);
		},
		/**
		 * 十六进制颜色转 RGBA
		 * @author hmjz100
		 * @description 支持 4 位和 8 位十六进制格式，自动解析透明度通道
		 * @param {string} hex - 十六进制颜色值（如 `#09f` 或 `#0099ffaa` ）
		 * @returns {string} RGBA 格式字符串（如 `15, 170, 255, 0.67`）
		 */
		hexToRgba(hex) {
			// 去掉 # 号
			hex = hex.replace(/^#/, "");
			// 如果是四位十六进制颜色值，转换为八位
			if (hex.length === 4) {
				hex = hex[0] + hex[0] + hex[1] + hex[1] + hex[2] + hex[2] + hex[3] + hex[3];
			}
			// 解析 RGB 分量
			let r = parseInt(hex.substring(0, 2), 16);
			let g = parseInt(hex.substring(2, 4), 16);
			let b = parseInt(hex.substring(4, 6), 16);
			let a = "";
			// 如果是八位十六进制颜色值，解析 alpha 通道
			if (hex.length === 8) {
				a = parseInt(hex.substring(6, 8), 16) / 255; // 将 alpha 值转换为 0 到 1 之间的小数
				a = ',' + a
			}
			// 返回 rgba 格式字符串
			return r + ', ' + g + ', ' + b + a;
		},
		/**
		 * RGBA 颜色转十六进制
		 * @author hmjz100
		 * @description 支持透明度转换，自动补全缩写格式
		 * @param {string} rgba - RGBA 格式颜色值（如 `rgba(15,170,255,0.67)`）
		 * @returns {string} 十六进制颜色值（如 `#09aaffaa`）
		 */
		rgbaToHex(rgba) {
			// 去掉前缀 "rgba" 或 "rgb" 并移除空格
			rgba = rgba.replace(/^(rgba?|RGBA?)\(/, "").replace(/\s+/g, "").replace(')', "");
			// 将颜色值分割为数组
			let [r, g, b, a] = rgba.split(',');
			// 将 RGB 转换为十六进制
			r = parseInt(r).toString(16).padStart(2, '0');
			g = parseInt(g).toString(16).padStart(2, '0');
			b = parseInt(b).toString(16).padStart(2, '0');
			// 如果存在 alpha 通道，处理透明度值
			if (a !== undefined) {
				// 将 alpha 转换为 0 到 255 的十六进制
				a = Math.round(parseFloat(a) * 255).toString(16).padStart(2, '0');
				return `#${r}${g}${b}${a}`;
			}
			// 如果没有 alpha 通道，返回标准六位的十六进制颜色
			return `#${r}${g}${b}`;
		},
		/**
		 * 自适应 CSS 颜色替换
		 * @author hmjz100
		 * @description 支持全局样式替换和资源路径修正，处理颜色渐变过渡效果
		 * @param {string} cssText - 原始 CSS 内容
		 * @param {string} baseURI - 资源基础路径
		 * @param {'default'|'other'} type - 替换模式（默认模式包含过渡效果）
		 * @param {Array<[string, string]>} colorMap - 颜色映射表（旧颜色 → 新颜色）
		 * @returns {string} 处理后的 CSS 内容
		 */
		adaptiveStyleOverride(cssText, baseURI, type, colorMap) {
			if (!cssText) return "";
			if (baseURI) {
				// 替换相对路径资源为绝对路径
				cssText = cssText.replace(/url\s*\(\s*(['"]?)(.*?)\1\s*\)/g, (match, quote, url) => {
					if (url && !/^(data:|https?:|\/\/)/i.test(url)) {
						try {
							let absoluteURL = new URL(url, baseURI).href;
							return `url(${absoluteURL})`;
						} catch (e) {
							return match;
						}
					}
					return match;
				});
			}
			// 处理默认颜色列表
			config.base.dom.theme.forEach(item => {
				let oldColor = item.color;
				cssText = cssText.replace(new RegExp(base.hexToRgba(oldColor), 'ig'), base.hexToRgba(temp.color));
				cssText = cssText.replace(new RegExp(oldColor, 'ig'), temp.color);
			});
			// 处理 colorMap
			if (type === 'other') {
				colorMap.forEach(function (colorPair) {
					let oldColor = colorPair[0];
					let newColor = colorPair[1];
					// 生成旧颜色的三种形式：原样、全大写、全小写
					const variants = [
						oldColor,
						oldColor.toUpperCase(),
						oldColor.toLowerCase()
					];
					// 使用 Set 去重
					const uniqueVariants = [...new Set(variants)];
					uniqueVariants.forEach(variant => {
						const regex = new RegExp(variant, 'g');
						cssText = cssText.replace(regex, newColor);
					});
				});
				return cssText;
			}
			if (colorMap) {
				colorMap.forEach(function (colorPair) {
					let oldColor = colorPair[0];
					let newColor = colorPair[1];
					// 生成三种形式
					const variants = [
						oldColor,
						oldColor.toUpperCase(),
						oldColor.toLowerCase()
					];
					const uniqueVariants = [...new Set(variants)];
					if (oldColor.includes("#")) {
						// 替换带属性块的情况（添加 transition）
						uniqueVariants.forEach(variant => {
							const regexWithBlock = new RegExp(variant + '(.*?)}', 'gi');
							cssText = cssText.replace(regexWithBlock, newColor + '$1; transition:all.2s}');
						});
						// 最后再统一替换剩下的
						uniqueVariants.forEach(variant => {
							cssText = cssText.replace(new RegExp(variant, 'gi'), newColor);
						});
					} else {
						// 普通字符串替换
						uniqueVariants.forEach(variant => {
							cssText = cssText.replace(new RegExp(variant, 'gi'), newColor);
						});
					}
				});
			}
			return cssText;
		},
		/**
		 * 自适应全局主题颜色修改器
		 * @author hmjz100
		 * @description 自动遍历并替换 `页面所有样式表` `SVG 元素` 的颜色值
		 * @param {Array<[string, string]>} colorMap - 颜色映射表
		 * @param {'default'|'other'} type - 替换模式
		 */
		adaptiveThemeOverride(colorMap, type) {
			base.waitForKeyElements(`[${mount}^="${mount}-ColorUI-"], [id^="${mount}-ColorUI-"]`, function (tag) {
				if (tag.html() === base.adaptiveStyleOverride(tag.text(), "", type, colorMap)) return;
				let cssText = base.adaptiveStyleOverride(tag.text(), "", type, colorMap);
				base.addStyle(tag.attr(mount), 'style', cssText, tag[0]);
				return true;
			}, true)
			base.waitForKeyElements(`[data-pl-colored]`, function (tag) {
				if (tag.attr("data-pl-colored") === temp.color) return;
				let originalStyle = tag.attr("style");
				if (!originalStyle) return;
				let newStyle = base.adaptiveStyleOverride(originalStyle, "", type, colorMap);
				if (newStyle !== originalStyle) {
					tag.attr("style", newStyle);
				}
				return true;
			}, true);
			let count = 0;
			if (!temp.colored) {
				base.waitForKeyElements('link[rel="stylesheet"]', function (tag) {
					if (!tag.parent().length || !tag.attr('href')) return;
					let href = tag.attr('href');
					try {
						href = new URL(href, location.href).href;
					} catch (e) {
						return;
					}
					fetch(href)
						.then(response => response.text())
						.then(responseText => {
							let id = `${mount}-ColorUI-` + href.replace(/[^\w]/g, "_");
							let cssText = base.adaptiveStyleOverride(responseText, href, type, colorMap);
							if (responseText === base.adaptiveStyleOverride(responseText, href, type, colorMap)) return;
							base.addStyle(id, 'style', cssText, tag[0], "after");
						})
				}, true);
				base.waitForKeyElements(`style:not([${mount}^="${mount}-"],[id^="swal-pub"],[class^="darkreader"])`, function (tag) {
					let id = tag.attr(mount);
					let text = tag.html()
					if (tag.data("styles") === text) return;
					tag.data("styles", text);
					// 替换颜色并添加样式
					let cssText = base.adaptiveStyleOverride(text, "", type, colorMap);
					if (text === cssText) return;
					id = id ? id : `${mount}-ColorUI-${count++}`
					base.addStyle(id, 'style', cssText, tag[0], "after");
				}, true)
				base.waitForKeyElements('svg', function (element) {
					element.find('*').each((index, element) => {
						let fill = $(element).attr('fill');
						let stroke = $(element).attr('stroke');
						if (fill) {
							let newFill = base.adaptiveStyleOverride(fill, "", type, colorMap);
							if (newFill !== fill) {
								$(element).attr('fill', newFill);
							}
						}
						if (stroke) {
							let newStroke = base.adaptiveStyleOverride(stroke, "", type, colorMap);
							if (newStroke !== stroke) {
								$(element).attr('stroke', newStroke);
							}
						}
					});
				}, true);
				base.waitForKeyElements(`[style]:not([${mount}^="${mount}-"],[class*="listener-"])`, function (element) {
					if (element.attr("data-pl-colored") === temp.color) return;
					let originalStyle = element.attr("style");
					if (!originalStyle) return;
					let newStyle = base.adaptiveStyleOverride(originalStyle, "", type, colorMap);
					if (newStyle !== originalStyle) {
						element.attr("style", newStyle);
						element.attr("data-pl-colored", temp.color);
					}
				}, true);
				temp.colored = true;
			}
		},
		/**
		 * 延时执行
		 * @author 油小猴
		 * @description 仅可于 `async` 函数中执行，否则无法倒计时。
		 * @param {number} time - 等待时间（毫秒）
		 * @returns {Promise<void>} 延时完成的 `Promise`
		 */
		sleep(time) {
			return new Promise(resolve => setTimeout(resolve, time));
		},
		/**
		 * 判断版本号新旧
		 * @author hmjz100
		 * @description 该函数将版本号按 `.` 分割为数字数组，逐段比较大小。
		 * 若某段 a 的数字大于 b，则 a 更新；
		 * 若所有段均相等，则版本相等（返回 false）。
		 * @param {string} a - 待比较的版本号
		 * @param {string} b - 基准版本号（如 "1.0.9.7"）
		 * @returns {boolean} - 若 a 比 b 更新，返回 true；否则返回 false
		 */
		isNewerVersion(a, b) {
			let partsA = a.split('.').map(Number);
			let partsB = b.split('.').map(Number);
			let maxLength = Math.max(partsA.length, partsB.length);
			for (let i = 0; i < maxLength; i++) {
				let numA = partsA[i] || 0;
				let numB = partsB[i] || 0;
				if (numA > numB) return true;
				if (numA < numB) return false;
			}
			return false;
		},
		/**
		 * 提取版本号主版本
		 * @author 油小猴
		 * @param {string} version - 完整版本号（如 `1.2.3`）
		 * @returns {string|null} 主版本号（如 `1`）或 `null`（格式错误时）
		 */
		getMajorVersion(version) {
			let [major] = (version || "").split('.');
			return /^\d+$/.test(major) ? major : null;
		},
		/**
		 * 查找 React 组件实例
		 * @author 油小猴
		 * @description 支持 Fiber 架构遍历，可指定向上查找层级
		 * @param {HTMLElement} dom - 起始 DOM 元素
		 * @param {number} [traverseUp=0] - 向上遍历层级
		 * @returns {Object|null} React 组件实例或 `null`
		 */
		findReact(dom, traverseUp = 0) {
			let key = Object.keys(dom).find(key => {
				return key.startsWith("__reactFiber$")
					|| key.startsWith("__reactInternalInstance$");
			});
			let domFiber = dom[key];
			if (domFiber == null) return null;
			if (domFiber._currentElement) {
				let compFiber = domFiber._currentElement._owner;
				for (let i = 0; i < traverseUp; i++) {
					compFiber = compFiber._currentElement._owner;
				}
				return compFiber._instance;
			}
			let GetCompFiber = fiber => {
				let parentFiber = fiber.return;
				while (base.isType(parentFiber.type) == "string") {
					parentFiber = parentFiber.return;
				}
				return parentFiber;
			};
			let compFiber = GetCompFiber(domFiber);
			for (let i = 0; i < traverseUp; i++) {
				compFiber = GetCompFiber(compFiber);
			}
			return compFiber.stateNode || compFiber;
		},
		/**
		 * 迁移旧版本配置
		 * @author hmjz100
		 * @description 将旧版配置项目迁移到新版配置
		 */
		initConfigMigration(latest) {
			try {
				if (latest === 1) {
					let mapping = {
						'setting_rpc_domain': ['setting_aria2_rpc', 0, 'domain'],
						'setting_rpc_port': ['setting_aria2_rpc', 0, 'port'],
						'setting_rpc_path': ['setting_aria2_rpc', 0, 'path'],
						'setting_rpc_token': ['setting_aria2_rpc', 0, 'token'],
						'setting_rpc_dir': ['setting_aria2_rpc', 0, 'dir'],
						'setting_terminal_type': ['setting_curl_terminal'],
						'setting_init_code': ['setting_init', 'code'],
						'setting_init_license': ['setting_init', 'license'],
						'setting_init_version': ['setting_init', 'version'],
						'setting_theme_color': ['setting_ui_theme', 'color'],
						'setting_theme_baidu': ['setting_ui_theme', 'custom', '$baidu'],
						'setting_theme_ali': ['setting_ui_theme', 'custom', '$aliyun'],
						'setting_theme_mcloud': ['setting_ui_theme', 'custom', '$mcloud'],
						'setting_theme_tcloud': ['setting_ui_theme', 'custom', '$tcloud'],
						'setting_theme_xunlei': ['setting_ui_theme', 'custom', '$xunlei'],
						'setting_theme_quark': ['setting_ui_theme', 'custom', '$quark'],
						'setting_theme_uc': ['setting_ui_theme', 'custom', '$uc'],
						'setting_theme_123': ['setting_ui_theme', 'custom', '$123pan']
					};
					// 旧版配置执行迁移
					for (let oldKey in mapping) {
						let val = base.getValue(oldKey);
						if (val === undefined || val === null) continue;
						val = (val === 'no' ? false : val === 'yes' ? true : val);
						let path = mapping[oldKey];
						if (path.length === 1) {
							base.setValue(path[0], val);
						} else {
							let [root, ...keys] = path;
							let obj = base.getValue(root);
							if (obj === undefined || obj === null) {
								let firstKeyType = typeof keys[0];
								let isIndex = firstKeyType === 'number' || (firstKeyType === 'string' && /^\d+$/.test(keys[0]));
								obj = isIndex ? [] : {};
							}
							let ref = obj;
							for (let i = 0; i < keys.length - 1; i++) {
								let key = keys[i];
								if (!ref[key]) {
									let nextKey = keys[i + 1];
									let hasNextIndex = nextKey !== undefined && (base.isType(nextKey === 'number' || (typeof nextKey) === 'string' && /^\d+$/.test(nextKey)));
									ref[key] = hasNextIndex ? [] : {};
								}
								ref = ref[key];
							}
							ref[keys.slice(-1)[0]] = val;
							base.setValue(root, obj);
						}
						base.delValue(oldKey);
					}
				}
			} catch (e) {
				console.error("【LinkSwift】迁移旧版本配置到新配置时出错", e);
			}
		},
		/**
		 * 初始化默认配置
		 * @author 油小猴
		 * @author hmjz100
		 * @description 创建基础配置、主题设置等存储项（仅当不存在时）
		 */
		initDefaultConfig() {
			if (base.getValue('setting_config_version') !== '1') base.initConfigMigration(1);
			// 设置新结构的默认值（仅当未设置时）
			let defaults = [
				{
					name: "setting_aria2_rpc",
					value: [
						{
							domain: "http://localhost",
							port: "16800",
							path: "/jsonrpc",
							token: "",
							dir: "",
							default: true
						}
					]
				},
				{
					name: "setting_bitcomet_rpc",
					value: [
						{
							domain: "http://localhost",
							port: "8080",
							path: "/panel/task_add_httpftp_result",
							authName: "",
							authPass: "",
							dir: "",
							default: true
						}
					]
				},
				{
					name: "setting_abdm_rpc",
					value: [
						{
							domain: "http://localhost",
							port: "15151",
							dir: "",
							default: true
						}
					]
				},
				{
					name: "setting_curl_terminal",
					value: "wc"
				},
				{
					name: "setting_init",
					value: {
						code: "",
						license: "",
						version: ""
					}
				},
				{
					name: "setting_ui_theme",
					value: {
						color: "#574AB8",
						custom: {
							$baidu: false,
							$aliyun: false,
							$mcloud: false,
							$tcloud: false,
							$xunlei: false,
							$quark: false,
							$uc: false,
							$123pan: false
						}
					}
				},
				{
					name: "setting_config_version",
					value: "1"
				}
			];
			function cloneDeep(item) {
				return JSON.parse(JSON.stringify(item));
			}
			function fillMissingFields(target, source) {
				// 如果 target 不存在，直接返回 source 的深拷贝
				if (target === null || target === undefined) {
					return cloneDeep(source);
				}
				// 如果类型不同，直接替换为 source
				if (typeof source !== typeof target) {
					return cloneDeep(source);
				}
				// 如果 source 是对象
				if (base.isType(source) === 'object' && !Array.isArray(source)) {
					if (typeof target !== 'object' || Array.isArray(target)) {
						return cloneDeep(source);
					}
					let result = { ...target };
					for (let key in source) {
						if (!source.hasOwnProperty(key)) continue;
						// 跳过 default 的自动合并
						if (key === 'default') continue;
						if (key === 'dir' && target[key] !== undefined) continue;
						if (key === 'token' && target[key] !== undefined) continue;
						if (key === 'authName' && target[key] !== undefined) continue;
						if (key === 'authPass' && target[key] !== undefined) continue;
						result[key] = fillMissingFields(target[key], source[key]);
					}
					return result;
				}
				// 如果 source 是数组
				if (Array.isArray(source)) {
					if (!Array.isArray(target)) {
						return cloneDeep(source);
					}
					let result = [...target];
					if (source.length > 0 && base.isType(source[0]) === 'object' && source[0] !== null) {
						let template = source[0];
						// 填充字段
						for (let i = 0; i < result.length; i++) {
							if (base.isType(result[i]) === 'object' && result[i] !== null) {
								result[i] = fillMissingFields(result[i], template);
							} else {
								result[i] = cloneDeep(template);
							}
						}
						// 自动补充 default: true
						if (
							template.default === true &&
							!result.some(item => item && item.default === true) &&
							result.length > 0
						) {
							result[0].default = true;
						}
					}
					return result;
				}
				// 基本类型，保留原始值
				return target;
			}
			defaults.forEach(({ name, value }) => {
				let current = base.getValue(name);
				if (
					current === null ||
					current === undefined ||
					(Array.isArray(current) && current.length === 0)
				) {
					base.setValue(name, cloneDeep(value));
				} else {
					base.setValue(name, fillMissingFields(current, value));
				}
			});
		},
		/**
		 * 显示设置界面
		 * @author 油小猴
		 * @author hmjz100
		 * @description 构建包含 RPC 配置、终端类型等设置项的交互界面
		 * @see {@link https://www.youxiaohou.com/zh-cn/motrix.html#使用指南 RPC 配置说明}、 {@link https://www.youxiaohou.com/zh-cn/curl.html cURL 使用教程}
		 */
		showSetting(event) {
			let setting = $(`<div>
				<div style="text-align:center;">带星号的设置项目将在网页刷新后生效</div>
				<label class="pl-setting-item listener-tip aria2" data-title="有关 Aria2 远程服务的配置">
					<div>Aria2 服务器</div>
					<button type="button" class="pl-button-mini swal2-confirm swal2-styled listener-open-aria2-setting" data-back-to-setting="true"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-plug"/></svg><span>配置</span></button>
				</label>
				<label class="pl-setting-item listener-tip bitcomet" data-title="有关比特彗星远程服务的配置">
					<div>比特彗星服务器</div>
					<button type="button" class="pl-button-mini swal2-confirm swal2-styled listener-open-bitcomet-setting" data-back-to-setting="true"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-plug"/></svg><span>配置</span></button>
				</label>
				<label class="pl-setting-item listener-tip abdm" data-title="有关 AB Download Manager 远程服务的配置">
					<div>AB Download Manager 服务器</div>
					<button type="button" class="pl-button-mini swal2-confirm swal2-styled listener-open-abdm-setting" data-back-to-setting="true"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-plug"/></svg><span>配置</span></button>
				</label>
				<label class="pl-setting-item curl">
					<div>终端类型</div>
					<select class="swal2-select pl-input listener-terminal">
					${Object.keys(temp.terminalType).map(i => `<option value="${i}" ${base.getValue('setting_curl_terminal') === i ? 'selected' : ""}>${temp.terminalType[i]}</option>`).join("")}
					</select>
				</label>
				<div class="curl" style="display:flex;justify-content:flex-end;"><a href="https://www.youxiaohou.com/zh-cn/curl.html" target="_blank" class="pl-a" data-no-instant="1"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-link"></use></svg> cURL使用教程</a>，适用于 cURL 下载👆</div>
				<div class="other" style="display:flex;justify-content:center;margin-top:20px"><button type="button" class="pl-button-mini swal2-deny swal2-styled listener-unregister listener-tip" data-title="仅会清除已存储的百度令牌，其余设置项目无影响，仍会保留"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-x-mark"/></svg><span>熄灭已经点亮的按钮*</span></button></div>
			</div>`);
			Swal.fire({
				...temp.swalDefault,
				title: '(｡•ᴗ•｡) 助手设置',
				html: setting.html(),
				icon: 'info',
				iconHtml: '⚙︎',
				allowOutsideClick: false,
				showCloseButton: true,
				showConfirmButton: false,
				footer: `<p><a href="&#104;&#116;&#116;&#112;&#115;&#58;&#47;&#47;&#103;&#105;&#116;&#104;&#117;&#98;&#46;&#99;&#111;&#109;&#47;&#104;&#109;&#106;&#122;&#49;&#48;&#48;&#47;&#76;&#105;&#110;&#107;&#83;&#119;&#105;&#102;&#116;" target="_blank" class="pl-a"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-star"></use></svg>&#76;&#105;&#110;&#107;&#83;&#119;&#105;&#102;&#116;</a>&#32;&#30001;&#32;<a href="&#104;&#116;&#116;&#112;&#115;&#58;&#47;&#47;&#103;&#105;&#116;&#104;&#117;&#98;&#46;&#99;&#111;&#109;&#47;&#104;&#109;&#106;&#122;&#49;&#48;&#48;" target="_blank" class="pl-a">&#104;&#109;&#106;&#122;&#49;&#48;&#48;</a>&#32;&#21046;&#20316;</p><p>${config.base.dom.footer}</p>`,
				didOpen: (toast) => {
					let element = $(toast);
					if (event && Object.keys($(event.currentTarget).data()).some(key => key.startsWith('backTo'))) element.find('.swal2-close').addClass('listener-tip').attr('data-title', '返回上页').css({ "left": "0", "right": "auto" }).text("◃");
					if (event && $(event.currentTarget).data("back-to-downloads")) element.find(".aria2, .bitcomet, .abdm, .other").hide();
				},
				willClose: () => {
					if (event && $(event.currentTarget).data("back-to-downloads")) base.showMainDialog(config.base.dom.button[temp.mode].title, base.generateDom(temp.links), config.base.dom.button[temp.mode].footer);
				},
			});
		},
		/**
		 * 显示 Aria2 服务设置界面
		 * @author hmjz100
		 * @description 包含 RPC 配置的交互界面
		 * @see {@link https://www.youxiaohou.com/zh-cn/motrix.html#使用指南 RPC 配置说明}
		 */
		showAria2Setting(event) {
			let AriaList = base.getValue('setting_aria2_rpc');
			let AriaOptions = AriaList.map((item, index) => {
				return `<option value="${index}"${item.default ? ' selected' : ""}>${item.domain ? item.domain : ""}:${item.port ? item.port : ""}${item.path ? item.path : ""}</option>`;
			}).join("");
			let AriaSelected = AriaList.find(i => i.default);
			let Aria2Setting = `<div style="text-align:center;"><a href="https://www.youxiaohou.com/zh-cn/motrix.html#使用指南" target="_blank" class="pl-a" data-no-instant="1"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-link"></use></svg> RPC配置说明</a>，适用于 Aria2 推送下载</div>
				<label class="pl-setting-item">
					<div>默认配置</div>
					<div>
						<select class="swal2-select pl-input listener-rpc-select" data-type="aria2" style="max-width:50%;min-width:auto">
							${AriaOptions}<option value="new">+ 创建新项目</option>
						</select>
						<button type="button" class="pl-button-mini swal2-deny swal2-styled listener-rpc-delete" data-type="aria2"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-x-mark"/></svg><span>删除</span></button>
						<button type="button" class="pl-button-mini swal2-confirm swal2-styled listener-rpc-test" data-type="aria2" style="margin-left:0"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-plug"/></svg><span>测试</span></button>
					</div>
				</label>
				<label class="pl-setting-item">
					<div>服务主机</div>
					<input type="text" autocomplete="off" placeholder="主机名，仅支持以及需带上 http(s)://，不支持 ws" class="swal2-input pl-input listener-rpc-input" data-type="aria2.domain" value="">
				</label>
				<label class="pl-setting-item">
					<div>服务端口</div>
					<input type="text" autocomplete="off" placeholder="端口号，例如 Motrix 为 16800，Aria2 为 6800" class="swal2-input pl-input listener-rpc-input" data-type="aria2.port" value="">
				</label>
				<label class="pl-setting-item">
					<div>服务路径</div>
					<input type="text" autocomplete="off" placeholder="访问路径，一般是 /jsonrpc" class="swal2-input pl-input listener-rpc-input" data-type="aria2.path" value="">
				</label>
				<label class="pl-setting-item">
					<div>服务密钥</div>
					<input type="text" autocomplete="off" placeholder="无密钥无需填写" class="swal2-input pl-input listener-rpc-input" data-type="aria2.token" value="">
				</label>
				<label class="pl-setting-item">
					<div>存储路径</div>
					<input type="text" autocomplete="off" placeholder="文件下载后保存路径，例如 D:\\Downloads\\，留空则默认" class="swal2-input pl-input listener-rpc-input" data-type="aria2.dir" value="">
				</label>`;
			Swal.fire({
				...temp.swalDefault,
				title: 'Aria2 服务设置',
				html: Aria2Setting,
				icon: 'info',
				iconHtml: '⚙︎',
				allowOutsideClick: false,
				showCloseButton: true,
				showConfirmButton: false,
				footer: `<p><a href="&#104;&#116;&#116;&#112;&#115;&#58;&#47;&#47;&#103;&#105;&#116;&#104;&#117;&#98;&#46;&#99;&#111;&#109;&#47;&#104;&#109;&#106;&#122;&#49;&#48;&#48;&#47;&#76;&#105;&#110;&#107;&#83;&#119;&#105;&#102;&#116;" target="_blank" class="pl-a"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-star"></use></svg>&#76;&#105;&#110;&#107;&#83;&#119;&#105;&#102;&#116;</a>&#32;&#30001;&#32;<a href="&#104;&#116;&#116;&#112;&#115;&#58;&#47;&#47;&#103;&#105;&#116;&#104;&#117;&#98;&#46;&#99;&#111;&#109;&#47;&#104;&#109;&#106;&#122;&#49;&#48;&#48;" target="_blank" class="pl-a">&#104;&#109;&#106;&#122;&#49;&#48;&#48;</a>&#32;&#21046;&#20316;</p><p>${config.base.dom.footer}</p>`,
				didOpen: (toast) => {
					let element = $(toast);
					if (event && Object.keys($(event.currentTarget).data()).some(key => key.startsWith('backTo'))) element.find('.swal2-close').addClass('listener-tip').attr('data-title', '返回上页').css({ "left": "0", "right": "auto" }).text("◃");
					if (AriaSelected) {
						element.find('.listener-rpc-input').each(function () {
							let type = $(this).data('type').split(".")[1];
							$(this).val(AriaSelected[type] || "");
						});
					} else {
						AriaList[0].default = true;
						base.setValue('setting_aria2_rpc', AriaList);
						AriaSelected = AriaList[0];
					}
				},
				willClose: () => {
					if (event && $(event.currentTarget).data("back-to-setting")) base.showSetting();
					if (event && $(event.currentTarget).data("back-to-downloads")) base.showMainDialog(config.base.dom.button[temp.mode].title, base.generateDom(temp.links), config.base.dom.button[temp.mode].footer);
				},
			});
		},
		/**
		 * 显示比特彗星服务设置界面
		 * @author hmjz100
		 * @description 包含 RPC 配置的交互界面
		 */
		showBitcometSetting(event) {
			let BCList = base.getValue('setting_bitcomet_rpc');
			let BCOptions = BCList.map((item, index) => {
				return `<option value="${index}"${item.default ? ' selected' : ""}>${item.domain ? item.domain : ""}:${item.port ? item.port : ""}${item.path ? item.path : ""}</option>`;
			}).join("");
			let BCSelected = BCList.find(i => i.default);
			let BitcometSetting = `<div style="text-align:center;">适用于比特彗星推送下载</div>
				<label class="pl-setting-item">
					<div>默认配置</div>
					<div>
						<select class="swal2-select pl-input listener-rpc-select" data-type="bitcomet" style="max-width:75%;min-width:auto">
							${BCOptions}<option value="new">+ 创建新项目</option>
						</select>
						<button type="button" class="pl-button-mini swal2-deny swal2-styled listener-rpc-delete" data-type="bitcomet"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-x-mark"/></svg><span>删除</span></button>
					</div>
				</label>
				<label class="pl-setting-item">
					<div>服务主机</div>
					<input type="text" autocomplete="off" placeholder="主机地址，需带上 http(s)://，但不需要写端口与路径" class="swal2-input pl-input listener-rpc-input" data-type="bitcomet.domain" value="">
				</label>
				<label class="pl-setting-item">
					<div>服务端口</div>
					<input type="text" autocomplete="off" placeholder="服务器端口号，一般为 8080" class="swal2-input pl-input listener-rpc-input" data-type="bitcomet.port" value="">
				</label>
				<label class="pl-setting-item">
					<div>服务路径</div>
					<input type="text" autocomplete="off" placeholder="一般是 /panel/task_add_httpftp_result" class="swal2-input pl-input listener-rpc-input" data-type="bitcomet.path" value="">
				</label>
				<label class="pl-setting-item">
					<div>服务账号</div>
					<input type="text" autocomplete="off" placeholder="本地服务器账号，无账号无需填写" class="swal2-input pl-input listener-rpc-input" data-type="bitcomet.authName" value="">
				</label>
				<label class="pl-setting-item">
					<div>服务密码</div>
					<input type="text" autocomplete="off" placeholder="本地服务器密码，无密码无需填写" class="swal2-input pl-input listener-rpc-input" data-type="bitcomet.authPass" value="">
				</label>
				<label class="pl-setting-item">
					<div>存储路径</div>
					<input type="text" autocomplete="off" placeholder="文件下载后保存路径，例如 D:\\Downloads\\，留空则默认" class="swal2-input pl-input listener-rpc-input" data-type="bitcomet.dir" value="">
				</label>`;
			Swal.fire({
				...temp.swalDefault,
				title: '比特彗星服务设置',
				html: BitcometSetting,
				icon: 'info',
				iconHtml: '⚙︎',
				allowOutsideClick: false,
				showCloseButton: true,
				showConfirmButton: false,
				footer: `<p><a href="&#104;&#116;&#116;&#112;&#115;&#58;&#47;&#47;&#103;&#105;&#116;&#104;&#117;&#98;&#46;&#99;&#111;&#109;&#47;&#104;&#109;&#106;&#122;&#49;&#48;&#48;&#47;&#76;&#105;&#110;&#107;&#83;&#119;&#105;&#102;&#116;" target="_blank" class="pl-a"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-star"></use></svg>&#76;&#105;&#110;&#107;&#83;&#119;&#105;&#102;&#116;</a>&#32;&#30001;&#32;<a href="&#104;&#116;&#116;&#112;&#115;&#58;&#47;&#47;&#103;&#105;&#116;&#104;&#117;&#98;&#46;&#99;&#111;&#109;&#47;&#104;&#109;&#106;&#122;&#49;&#48;&#48;" target="_blank" class="pl-a">&#104;&#109;&#106;&#122;&#49;&#48;&#48;</a>&#32;&#21046;&#20316;</p><p>${config.base.dom.footer}</p>`,
				didOpen: (toast) => {
					let element = $(toast);
					if (event && Object.keys($(event.currentTarget).data()).some(key => key.startsWith('backTo'))) element.find('.swal2-close').addClass('listener-tip').attr('data-title', '返回上页').css({ "left": "0", "right": "auto" }).text("◃");
					if (BCSelected) {
						element.find('.listener-rpc-input').each(function () {
							let type = $(this).data('type').split(".")[1];
							$(this).val(BCSelected[type] || "");
						});
					} else {
						BCSelected[0].default = true;
						base.setValue('setting_bitcomet_rpc', BCSelected);
						BCSelected = BCList[0];
					}
				},
				willClose: () => {
					if (event && $(event.currentTarget).data("back-to-setting")) base.showSetting();
					if (event && $(event.currentTarget).data("back-to-downloads")) base.showMainDialog(config.base.dom.button[temp.mode].title, base.generateDom(temp.links), config.base.dom.button[temp.mode].footer);
				},
			});
		},
		/**
		 * 显示 AB Download Manager 服务设置界面
		 * @author hmjz100
		 * @description 包含 RPC 配置的交互界面
		 */
		showABDMSetting(event) {
			let ABList = base.getValue('setting_abdm_rpc');
			let ABOptions = ABList.map((item, index) => {
				return `<option value="${index}"${item.default ? ' selected' : ""}>${item.domain}:${item.port}</option>`;
			}).join("");
			let ABSelected = ABList.find(i => i.default);
			let ABSetting = `<div style="text-align:center;">适用于 AB Download Manager 推送下载</div>
				<label class="pl-setting-item">
					<div>默认配置</div>
					<div>
						<select class="swal2-select pl-input listener-rpc-select" data-type="abdm" style="max-width:50%;min-width:auto">
							${ABOptions}<option value="new">+ 创建新项目</option>
						</select>
						<button type="button" class="pl-button-mini swal2-deny swal2-styled listener-rpc-delete" data-type="abdm"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-x-mark"/></svg><span>删除</span></button>
						<button type="button" class="pl-button-mini swal2-confirm swal2-styled listener-rpc-test" data-type="abdm" style="margin-left:0"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-plug"/></svg><span>测试</span></button>
					</div>
				</label>
				<label class="pl-setting-item">
					<div>服务主机</div>
					<input type="text" autocomplete="off" placeholder="主机地址，需带上 http(s)://，但不需要写端口与路径" class="swal2-input pl-input listener-rpc-input" data-type="abdm.domain" value="">
				</label>
				<label class="pl-setting-item">
					<div>服务端口</div>
					<input type="text" autocomplete="off" placeholder="服务器端口号，一般为 15151" class="swal2-input pl-input listener-rpc-input" data-type="abdm.port" value="">
				</label>
				<label class="pl-setting-item">
					<div>存储路径</div>
					<input type="text" autocomplete="off" placeholder="文件下载后保存路径，例如 D:\\Downloads\\，留空则默认" class="swal2-input pl-input listener-rpc-input" data-type="abdm.dir" value="">
				</label>`;
			Swal.fire({
				...temp.swalDefault,
				title: 'ABDM 服务设置',
				html: ABSetting,
				icon: 'info',
				iconHtml: '⚙︎',
				allowOutsideClick: false,
				showCloseButton: true,
				showConfirmButton: false,
				footer: `<p><a href="&#104;&#116;&#116;&#112;&#115;&#58;&#47;&#47;&#103;&#105;&#116;&#104;&#117;&#98;&#46;&#99;&#111;&#109;&#47;&#104;&#109;&#106;&#122;&#49;&#48;&#48;&#47;&#76;&#105;&#110;&#107;&#83;&#119;&#105;&#102;&#116;" target="_blank" class="pl-a"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-star"></use></svg>&#76;&#105;&#110;&#107;&#83;&#119;&#105;&#102;&#116;</a>&#32;&#30001;&#32;<a href="&#104;&#116;&#116;&#112;&#115;&#58;&#47;&#47;&#103;&#105;&#116;&#104;&#117;&#98;&#46;&#99;&#111;&#109;&#47;&#104;&#109;&#106;&#122;&#49;&#48;&#48;" target="_blank" class="pl-a">&#104;&#109;&#106;&#122;&#49;&#48;&#48;</a>&#32;&#21046;&#20316;</p><p>${config.base.dom.footer}</p>`,
				didOpen: (toast) => {
					let element = $(toast);
					if (event && Object.keys($(event.currentTarget).data()).some(key => key.startsWith('backTo'))) element.find('.swal2-close').addClass('listener-tip').attr('data-title', '返回上页').css({ "left": "0", "right": "auto" }).text("◃");
					if (ABSelected) {
						element.find('.listener-rpc-input').each(function () {
							let type = $(this).data('type').split(".")[1];
							$(this).val(ABSelected[type] || "");
						});
					} else {
						ABSelected[0].default = true;
						base.setValue('setting_abdm_rpc', ABSelected);
						ABSelected = BCList[0];
					}
				},
				willClose: () => {
					if (event && $(event.currentTarget).data("back-to-setting")) base.showSetting();
					if (event && $(event.currentTarget).data("back-to-downloads")) base.showMainDialog(config.base.dom.button[temp.mode].title, base.generateDom(temp.links), config.base.dom.button[temp.mode].footer);
				},
			});
		},
		/**
		 * 显示美化设置界面
		 * @author hmjz100
		 * @description 提供主题颜色选择器和各网盘界面美化配置
		 * @fires .listener-color - 主题色选择事件
		 * @fires .listener-theme - 网盘主题配置变更事件
		 */
		showBeautify() {
			function changeColor() {
				temp.color = base.getValue('setting_ui_theme').color;
				return config.base.dom.theme.map(item => {
					return `<div style="--color:${item.color}" class="listener-color" data-color="${item.color}">
						<div class="mask">
							${item.name.split('|').map(part => `<div>${part}</div>`).join("")}
							${item.color === temp.color ? '<div class="this"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-check"></use></svg></div>' : ""}
						</div>
					</div>`;
				}).join("")
			}
			function changeTheme() {
				let themeList = [
					{ name: '百度网盘', key: '$baidu' },
					{ name: '阿里云盘', key: '$aliyun' },
					{ name: '移动云盘', key: '$mcloud' },
					{ name: '天翼云盘', key: '$tcloud' },
					{ name: '迅雷云盘', key: '$xunlei' },
					{ name: '夸克网盘', key: '$quark' },
					{ name: 'UC 网盘', key: '$uc' },
					{ name: '123 云盘', key: '$123pan' }
				];
				return themeList.map(item => {
					return `<label class="pl-setting-item">
						<div>${item.name}</div>
						<input type="checkbox" class="swal2-checkbox pl-input listener-theme" data-type="${item.key}" ${base.getValue('setting_ui_theme').custom[item.key] === true ? 'checked' : ""}>
					</label>`;
				}).join("");
			}
			let beautify = $(`<div>
				<div style="text-align:center;">带星号的美化项目将在网页刷新后生效</div>
				<label class="pl-setting-item" style="justify-content:center"><div class="pl-color">${changeColor()}</div></label>
				<div class="pl-setting-item"><div>替换界面配色为主题颜色*</div><div class="pl-checkboxies">${changeTheme()}</div></div>
				<style>
					.pl-color{display:grid!important;grid-template-columns:repeat(5, var(--pl-color-width));gap:10px;--pl-color-width:55px}
					.pl-color > div{background-color:var(--color);width:var(--pl-color-width);height:var(--pl-color-width);box-sizing:border-box;cursor:pointer}
					.pl-color .mask{width:calc(var(--pl-color-width) - 2px);height:calc(var(--pl-color-width) - 2px);opacity:0;transition:opacity.2s;color:#fff;font-size:13px;display:flex;align-items:center;justify-content:center;flex-direction:column}
					.pl-color > div:hover .mask{opacity:1}
					.pl-checkboxies{display:grid!important;grid-template-columns:repeat(2, 98px);gap:10px}
					.pl-input[type=checkbox]{height:20px;width:20px;padding:0!important;background-image:none!important}
				</style>
			</div>`)
			Swal.fire({
				...temp.swalDefault,
				title: '(✿ᴗ‿ᴗ) 助手美化',
				html: beautify.html(),
				icon: 'success',
				iconHtml: '🍃︎',
				allowOutsideClick: false,
				showCloseButton: true,
				showConfirmButton: false,
				footer: `<p><a href="&#104;&#116;&#116;&#112;&#115;&#58;&#47;&#47;&#103;&#105;&#116;&#104;&#117;&#98;&#46;&#99;&#111;&#109;&#47;&#104;&#109;&#106;&#122;&#49;&#48;&#48;&#47;&#76;&#105;&#110;&#107;&#83;&#119;&#105;&#102;&#116;" target="_blank" class="pl-a"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-star"></use></svg>&#76;&#105;&#110;&#107;&#83;&#119;&#105;&#102;&#116;</a>&#32;&#30001;&#32;<a href="&#104;&#116;&#116;&#112;&#115;&#58;&#47;&#47;&#103;&#105;&#116;&#104;&#117;&#98;&#46;&#99;&#111;&#109;&#47;&#104;&#109;&#106;&#122;&#49;&#48;&#48;" target="_blank" class="pl-a">&#104;&#109;&#106;&#122;&#49;&#48;&#48;</a>&#32;&#21046;&#20316;</p><p>${config.base.dom.footer}</p>`,
			});
		},
		/**
		 * 显示调试信息面板
		 * @description 展示脚本运行时环境、版本信息及依赖状态
		 * @author hmjz100
		 * @property{string} manageHandler - 外部管理器名称
		 * @property{string} manageVersion - 外部管理器版本
		 */
		showDebug() {
			let debugInfo = "";
			debugInfo += `<span>以下内容均为脚本自检信息<br/>本页面仅作为调试使用<span>`;
			debugInfo += `<label class="pl-setting-item"><div>[外] 管理器名称</div>${info.mhandler ? info.mhandler : "无法获取"}</label>`;
			debugInfo += `<label class="pl-setting-item"><div>[外] 管理器版本</div>${info.mversion ? info.mversion : "无法获取"}</label>`;
			debugInfo += `<label class="pl-setting-item"><div>[内] 脚本挂载点</div>${mount ? `${mount.toLowerCase()}.${mount}` : "无法获取"}</label>`;
			debugInfo += `<label class="pl-setting-item"><div>[外] 脚本名称</div>${info.name ? info.name : "无法获取"}</label>`;
			debugInfo += `<label class="pl-setting-item"><div>[外] 脚本作者</div>${info.author ? info.author : "无法获取"}</label>`;
			debugInfo += `<label class="pl-setting-item"><div>[外/内] 脚本版本</div>${info.version ? info.version : "无法获取"}</label>`;
			debugInfo += `<label class="pl-setting-item"><div>[外/内] 脚本图标</div>${info.icon ? `<img style="max-width:30%" src="${info.icon}"></img>` : "无法获取"}</label>`;
			debugInfo += `<label class="pl-setting-item"><div>[内] 公众号二维码</div>${config.base?.service?.account ? `<img style="max-width:30%" src="${config.base.service.account}"></img>` : "无法获取"}</label>`;
			debugInfo = '<div>' + debugInfo + '</div>';
			Swal.fire({
				...temp.swalDefault,
				icon: 'info',
				title: '调试信息',
				html: debugInfo,
				allowOutsideClick: false,
				showCloseButton: true,
				footer: `<p><a href="&#104;&#116;&#116;&#112;&#115;&#58;&#47;&#47;&#103;&#105;&#116;&#104;&#117;&#98;&#46;&#99;&#111;&#109;&#47;&#104;&#109;&#106;&#122;&#49;&#48;&#48;&#47;&#76;&#105;&#110;&#107;&#83;&#119;&#105;&#102;&#116;" target="_blank" class="pl-a"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-star"></use></svg>&#76;&#105;&#110;&#107;&#83;&#119;&#105;&#102;&#116;</a>&#32;&#30001;&#32;<a href="&#104;&#116;&#116;&#112;&#115;&#58;&#47;&#47;&#103;&#105;&#116;&#104;&#117;&#98;&#46;&#99;&#111;&#109;&#47;&#104;&#109;&#106;&#122;&#49;&#48;&#48;" target="_blank" class="pl-a">&#104;&#109;&#106;&#122;&#49;&#48;&#48;</a>&#32;&#21046;&#20316;</p><p>${config.base.dom.footer}</p>`,
			});
		},
		/**
		 * 显示版本更新日志
		 * @author hmjz100
		 * @description 按时间倒序展示所有历史版本更新内容
		 */
		async showUpdate() {
			await Swal.fire({
				...temp.swalDefault,
				icon: 'info',
				title: '更新日志',
				html: `<div class="version-log">
				<div class="block">
					<blockquote>
						<div>风雨送春归，飞雪迎春到。已是悬崖百丈冰，犹有花枝俏。</div>
						<div>俏也不争春，只把春来报。待到山花烂漫时，她在丛中笑。</div>
					</blockquote>
				</div>
				<div class="block">(ﾉ◕ヮ◕)ﾉ 遇到 Bug 要记得去 <a class="pl-a" href="https://github.com/hmjz100/LinkSwift/issues" target="_blank">Github 议题</a> 向我报告哦~</div>
				<div class="block">
					<name>V1.1.1.9</name>
					<div>
					<div>1、修复 - 123 云盘下载视频变为缩略图。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.1.1.8</name>
					<div>
					<div>1、修复 - 适配新版 123 云盘分享页。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.1.1.7</name>
					<div>
					<div>1、修复 - 缺失声明 @connect 导致的问题。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.1.1.6</name>
					<div>
					<div>1、<span style="color:#fff;background:${temp.color}">废弃 - 百度网盘 BDUSS Cookie 相关代码，转向使用更安全的 AccessToken</span>；</div>
					<div>2、废弃 - 百度网盘分享页面下载相关代码；</div>
					<div>3、优化 - 下载窗口可在设置改变后动态修改界面。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.1.1.5</name>
					<div>
					<div>1、新增 - AB Download Manager 下载方式；</div>
					<div>2、优化 - 支持从设置页面一键返回下载窗口，无需重复获取链接。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.1.1.4</name>
					<div>
					<div>1、适配 123 云盘新版页面。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.1.1.3</name>
					<div>
					<div>1、修复夸克网盘无法获取下载链接的 Bug；</div>
					<div>2、修复 API 下载无法复制全部链接。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.1.1.2</name>
					<div>
					<div>1、修复无法删除第一项远程配置的 Bug。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.1.1.1</name>
					<div>
					<div>1、修复推送到 Aria2 时推送成功但报错的 Bug。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.1.1</name>
					<div>
					<div>1、配置文件格式更新，<span style="color:#fff;background:${temp.color}">支持添加、删除、切换多个服务配置</span>；</div>
					<div>2、支持比特彗星推送下载，<span style="color:#fff;background:${temp.color}">原 RPC 已并入 Aria2 下载</span>；</div>
					<div>3、界面<span style="color:#fff;background:${temp.color}">增加 Font Awesome 图标！</span>更好看啦；</div>
					<div>4、优化脚本代码、界面，运行更轻快；</div>
					<div>5、修复上个版本遗存的问题。</div>
					</div>
				</div>
				<hr/>
				<div class="block">
					<name>V1.1.0.1</name>
					<div>
					<div>1、修复查看 RPC 下载任务的 Bug。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.1.0</name>
					<div>
					<div>1、支持 UC 网盘、123 云盘；</div>
					<div>2、改进了网盘主题的注入方式；</div>
					<div>3、聚合并重构了部分重复函数，对整体脚本逻辑进行了梳理和精简；</div>
					<div>4、将脚本执行阶段从 document-body 适配为 document-start。</div>
					</div>
				</div>
				<hr/>
				<div class="block">
					<name>V1.0.9.7</name>
					<div>
					<div>1、修复移动云盘下载错误；</div>
					<div>2、优化代码，更好的错误识别；</div>
					<div>3、去除了游小猴云服务。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.9.6</name>
					<div>
					<div>1、支持在百度网盘中选择文件夹下载；</div>
					<div>2、优化部分提示。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.9.5</name>
					<div>
					<div>1、修复因代码逻辑错误而无法获取链接的 Bug。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.9.4</name>
					<div>
					<div>1、修复因百度网盘 AccessToken 过期导致无法获取链接的 Bug。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.9.3</name>
					<div>
					<div>1、若网盘不支持在分享中下载，将仅显示保存网盘按钮；</div>
					<div>2、优化下载界面，支持选择 Iframe 或 Blob 的方式来下载文件，增加按钮的提示文本；</div>
					<div>3、优化 CSS 样式，统一了 SweetAlert2 按钮样式，同时适配了 Dark Reader 插件，界面更协调；</div>
					<div>4、支持修改油小猴网站主题色；</div>
					<div>5、原有主题相关设置现已移动至助手美化页面中。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.9.2</name>
					<div>
					<div>1、修复使用API 下载时有可能会导致IDM无限弹窗的Bug。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.9.1</name>
					<div>
					<div>1、修复在百度网盘旧版下脚本无法删除元素的Bug。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.9</name>
					<div>
					<div>1、跟进官方V6.2.7，修复因无法进行百度授权而导致获取直链报错 9019 的 Bug。</div>
					</div>
				</div>
				<hr/>
				<div class="block">
					<name>V1.0.8.9</name>
					<div>
					<div>1、跟进官方V6.2.3，优化保存到网盘提示，修复阿里云盘、移动云盘失效的问题；</div>
					<div>2、优化修改网盘主题的代码，减少对页面的破坏。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.8.8</name>
					<div>
					<div>1、修复下载菜单字体过小的Bug。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.8.7</name>
					<div>
					<div>1、修复在阿里云盘分享页面下点击“未点亮”按钮时没有任何反应的Bug；</div>
					<div>2、更新并优化网盘界面精简规则；</div>
					<div>3、支持更换 百度网盘、阿里云盘、迅雷云盘、夸克网盘、移动云盘 界面的主题颜色。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.8.6</name>
					<div>
					<div>1、新增移动云盘会员中心页面，可在网盘中点击“会员中心”按钮查看(但无法使用第三方支付)。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.8.5</name>
					<div>
					<div>1、跟进官方V6.1.6，修复迅雷网盘分享页面无法选中文件，修复移动云盘无法判断页面。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.8.4</name>
					<div>
					<div>1、修复因重复绑定按钮而导致命令重复执行的Bug；</div>
					<div>2、优化调试信息界面排版；</div>
					<div>3、移除对百度网盘手机网页版的支持。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.8.3</name>
					<div>
					<div>1、适配阿里云盘新域名alipan.com。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.8.2</name>
					<div>
					<div>1、更换新图标。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.8.1</name>
					<div>
					<div>1、修复因重复绑定按钮而导致 RPC 下载会发送多条下载请求的Bug；</div>
					<div>2、选择不使用油小猴服务器时，“用ghproxy连接Github仓库”更换为“用jsdelivr连接Github仓库”；</div>
					<div>3、跟进官方V6.1.4版本，修复移动网盘无法获取链接，支持阿里云盘新域名alipan.com。</div>
					</div>
				</div>
				<hr/>
				<div class="block">
					<name>V1.0.8</name>
					<div>
					<div>1、修复迅雷网盘无法勾选文件。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.7.9</name>
					<div>
					<div>1、更新精简网盘元素匹配规则，防止因通知横条而导致不能点到“API 下载”以下的按钮。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.7.8</name>
					<div>
					<div>1、跟进官方V6.1.2，加入V2接口。</div>
					<div>2、修复百度网盘下载时因为获取不到accessToken而一直转圈。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.7.7</name>
					<div>
					<div>1、修复百度网盘的按钮会因为主题不同而被改变颜色的Bug；</div>
					<div>2、更新夸克网盘按钮与界面。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.7.6</name>
					<div>
					<div>1、修复“注入”功能；</div>
					<div>2、黑暗模式支持随设置热切换。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.7.5</name>
					<div>
					<div>1、修复阿里云盘下载逻辑；</div>
					<div>2、精简代码；</div>
					<div>3、支持深色模式；</div>
					<div>4、修改部分提示文本；</div>
					<div>5、修改部分CSS；</div>
					<div>6、设置可测试RPC连接。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.7.4</name>
					<div>
					<div>1、优化下载逻辑；</div>
					<div>2、修复阿里云盘无法使用API 下载。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.7.3</name>
					<div>
					<div>1、如果出现网络请求错误时支持自动重新请求；</div>
					<div>2、可选择是否使用油小猴服务器。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.7.2</name>
					<div>
					<div>1、修复使用 RPC 下载时会重复发送链接的Bug。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.7.1</name>
					<div>
					<div>[实验功能，不影响正常使用]支持百度网盘手机网页版，勾选文件后可在顶栏找到“下载助手”按钮。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.7</name>
					<div>
					<div>1、重构夸克网盘、阿里云盘按钮。</div>
					</div>
				</div>
				<hr/>
				<div class="block">
					<name>V1.0.6.9</name>
					<div>
					<div>1、下载窗口加入关闭按钮。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.6.8</name>
					<div>
					<div>1、修复夸克网盘按钮错位。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.6.7</name>
					<div>
					<div>1、将百度网盘界面修改为主题色，可在设置选择是否修改；</div>
					<div>2、增加主题色名称，更改部分内容颜色；</div>
					<div>3、移动云盘API 下载支持批量复制；</div>
					<div>4、优化控制台输出结果；</div>
					<div>5、百度网盘API 下载不使用IDM时可以显示剩余时间；</div>
					<div>6、“取消点亮按钮”按钮的位置现已移动到设置页面。</div>
					<div>7、homo特有的彩蛋又回来力(喜)。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.6.6</name>
					<div>
					<div>1、修复暗号错误。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.6.5</name>
					<div>
					<div>1、修复即使输入正确暗号也不能成功点亮按钮的服务器错误。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.6.4</name>
					<div>
					<div>1、跟进官方V6.1.1版本，修复阿里云盘获取下载链接时的问题。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.6.3</name>
					<div>
					<div>1、照顾小屏幕用户，将始终显示复制全部链接的按钮；</div>
					<div>2、增加取消下载时的动画。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.6.2</name>
					<div>
					<div>1、修复部分界面错位，实现CSS内置；</div>
					<div>2、百度网盘界面将变得更加简洁。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.6.1</name>
					<div>
					<div>1、新增百度云盘API 下载支持复制链接；</div>
					<div>2、为了照顾手机浏览器用户，增大项目之间间隙，新增隐藏IDM提示选项，可在助手设置中启用；</div>
					<div>3、修改CSS，界面会出现更多的主题色；</div>
					<div>4、支持在游小猴官网查看暗号；</div>
					<div>5、修复部分语法错误。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.6</name>
					<div>
					<div>1、修复了打开阿里云盘分享连接时因下载移动端广告导致只能点击 API 下载；</div>
					<div>2、跟进官方6.0.4版本，修复夸克网盘获取下载链接失效、支持移动云盘。</div>
					</div>
				</div>
				<hr/>
				<div class="block">
					<name>V1.0.5.5</name>
					<div>
					<div>1、感谢<a href="https://github.com/Night-stars-1">Night-stars-1</a>的帮助，修复因为原作者服务器导致的初始化暗号识别错误；</div>
					<div>2、修改一些文本以及提供给服务器的信息。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.5.4</name>
					<div>
					<div>1、小修小改css，让主题色出现在更多地方；</div>
					<div>2、修改下载链接获取失败的提示；</div>
					<div>3、增加更多的主题色，可在助手设置查看；</div>
					<div>4、homo彩蛋被删去力（悲）。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.5.3</name>
					<div>
					<div>1、修啦修啦，阿里云盘可以摸到下载菜单了。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.5.2</name>
					<div>
					<div>1、增加脚本信息菜单（没有用）；</div>
					<div>2、优化阿里云盘显示svg图片；</div>
					<div>3、修改弹窗按钮颜色。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.5.1</name>
					<div>
					<div>1、修复在切换按钮主题后夸克网盘不能正常显示按钮。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.5</name>
					<div>
					<div>1、跟进官方V5.0.4版本；</div>
					<div>2、小改动，照着官方版本更正文件名称检测；</div>
					<div>3、保留彩蛋，但必须舍弃官方暗号。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.4</name>
					<div>
					<div>大改！</div>
					<div>1、修复了原作者留下的夸克网盘切换文件夹就多一个“下载助手”按钮的大BUG；</div>
					<div>2、终于来了，在下载菜单增加“助手设置”“更新日志”按钮；</div>
					<div>【再也不用点进油猴管理再进设置了(保留油猴管理内设置)】</div>
					<div>3、修改阿里云盘和夸克网盘下载助手按钮样式；</div>
					<div>4、增加“取消点亮按钮”油猴菜单；</div>
					<div>5、修改部分css，使其与选择的主题更贴切。</div>
					</div>
				</div>
				<hr/>
				<div class="block">
					<name>V1.0.3</name>
					<div>
					<div>1、增加一个小彩蛋； 提示：</div>
					<div>homo（需在未点亮按钮状态触发）</div>
					<div>【需要重新恢复按钮为未点亮状态请进入 已安装脚本->编辑->开发者->重置到出厂->确定】</div>
					<div>2、修改/增加默认主题色。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.2</name>
					<div>
					<div>1、修改并加宽界面，调整部分css，使Sweetalert2界面更美观，更与原版相近；</div>
					<div>2、修改部分提示文字，使文字更容易复制。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.1</name>
					<div>
					<div>1、去除更新提示；</div>
					<div>2、更新Sweetalert2至11版本；</div>
					<div>3、部分CDN节点更换为jsdelivr。</div>
					</div>
				</div>
				<div class="block">
					<name>V1.0.0</name>
					<div>
					<div>1、增加“注入”功能（bushi）；</div>
					<div>2、去除广告。</div>
				</div>
				</div>
				</div>
				<style>
				div:where(.swal2-container) div:where(.swal2-popup){
					width:36em!important;
				}
				.version-log{
					text-align:left;
				}
				.version-log > .block,
				.version-log > hr{
					margin-bottom:20px;
				}
				.version-log > hr{
					border-style:inset;
					border-width:1px;
				}
				.version-log .block name{
					display:block;
					margin-bottom:10px;
					font-size:1.2em;
				}
				.version-log .block div{
					margin-bottom:5px;
				}
				.version-log .block blockquote{
					padding:0.7em;
					border-left:5px solid #bdbdbd;
					background-color:#f9f9f9;
					margin:0;
				}
				@media (prefers-color-scheme:dark){
					.version-log .block blockquote{
						border-left:5px solid #7A7C84;
						background-color:#464851;
					}
				}
				</style>`,
				allowOutsideClick: false,
				showCloseButton: true,
				confirmButtonText: '<svg class="pl-icon"><use xlink:href="#pl-icon-fa-check"/></svg> 我已阅',
			});
		},
		/**
		 * 创建浮动提示框
		 * @description 监听元素悬停事件，动态显示带文件大小的提示框
		 * @author 油小猴
		 * @author hmjz100
		 * @fires .listener-tip - 鼠标移动事件触发提示框定位
		 * @see {@link temp.color} 使用全局主题色渲染文件大小信息
		 */
		createTip() {
			// 使用原生JavaScript创建tooltip元素
			let tooltip = document.querySelector('.pl-tooltip');
			
			// 提取公共显示逻辑
			const showTooltip = (target, x, y) => {
				const title = target.dataset.title;
				const size = target.dataset.size;
				const innerText = target.innerText;
				
				if (!title && !size && !innerText) return;
				
				let tip = "";
				if (title) {
					tip += `<span>${title}</span>`;
				} else {
					// 使用原生方法查找子元素
					const nameElement = target.querySelector(".name");
					const sizeElement = target.querySelector(".size");
					const name = nameElement ? nameElement.textContent : "";
					const sizeText = sizeElement ? sizeElement.textContent : "";
					
					tip += `<span>${name}</span>`;
					if (sizeText !== undefined) {
						tip += `<span style="background-color:${temp.color}">${sizeText}</span>`;
					}
				}
				if (!tooltip) {
					tooltip = document.createElement('div');
					tooltip.className = 'pl-tooltip';
					temp.mount[0].appendChild(tooltip);
				}
				
				tooltip.innerHTML = tip;
				tooltip.style.display = 'flex';
				tooltip.style.top = (y + 20) + 'px';
				tooltip.style.left = (x + 10) + 'px';
			};
			
			// 鼠标/触摸移动时更新位置
			const handleMove = (e) => {
				const isTouch = e.type.startsWith('touch');
				const pageX = isTouch ? e.touches[0].pageX : e.pageX;
				const pageY = isTouch ? e.touches[0].pageY : e.pageY;
				const target = e.currentTarget;
				showTooltip(target, pageX, pageY);
			};
			
			// 触摸开始时立即显示
			const handleTouchStart = (e) => {
				// 阻止滚动避免干扰
				e.preventDefault();
				const touch = e.touches[0];
				const target = e.currentTarget;
				showTooltip(target, touch.pageX, touch.pageY);
			};
			
			// 统一隐藏逻辑
			const hideTooltip = () => {
				tooltip.style.display = '';
			};
			
			// 增强跨事件类型检测
			const handleGlobalMove = (e) => {
				if (tooltip?.style?.display !== 'flex') return;
				
				const isTouch = e.type.startsWith('touch');
				const touch = isTouch ? e.touches[0] : null;
				const target = isTouch
					? document.elementFromPoint(touch.clientX, touch.clientY)
					: e.target;
					
				const closest = target.closest('.listener-tip, .pl-tooltip');
				if (!closest) {
					tooltip.style.display = '';
				}
			};
			
			// 绑定事件（仍使用jQuery简化事件绑定）
			$doc.on('mousemove touchmove', '.listener-tip', handleMove);
			$doc.on('touchstart', '.listener-tip', handleTouchStart);
			$doc.on('mouseleave touchend touchcancel', '.listener-tip, .pl-tooltip', hideTooltip);
			$doc.on('mousemove touchmove', handleGlobalMove);
		},
		/**
		 * 创建加载状态弹窗
		 * @author 油小猴
		 * @description 生成包含旋转动画的加载容器
		 */
		createLoading() {
			return $('<div class="pl-loading"><div class="pl-loading-box"><div><div></div><div></div></div></div></div>');
		},
		/**
		 * 创建用于下载的隐藏 iframe
		 * @author 油小猴
		 * @description 该方法会创建一个隐藏的 iframe 元素，并将其插入到指定的挂载点中，用于后续的下载操作。
		 * iframe 的 src 设置为 "javascript:;" 以避免加载额外资源，提升性能。
		 */
		createIframe() {
			let iframe = $('<iframe style="padding:0;margin:0;display:block;display:none" src="javascript:;" id="downloadIframe"></iframe>');
			temp.mount.append(iframe);
		},
		/**
		 * 创建用于下载页面的 HTML
		 * @author 油小猴
		 * @author hmjz100
		 * @param {Array} configs - 用于配置生成 HTML 的参数
		 * @returns {string} 生成的 HTML 内容
		 * @description 详见代码
		 */
		generateDom(configs) {
			if (base.isType(configs) !== "array" && configs.length !== 2) return message.error('提示：<br/>配置解析失败~');
			let list = (Array.isArray(configs[0]) ? configs[0] : []);
			if (!list.length) return message.error('提示：<br/>获取下载链接失败，刷新网页后再试试吧~');
			let {
				isFolder,
				getFileName,
				getFileSize,
				getFileLink,
				getFileMirror,
				convert = {},
				tooltip = {}
			} = (base.isType(configs[1]) === 'object' ? configs[1] : {});
			let content = $(`<div><div class="pl-main"></div><div class="pl-extra"></div></div>`);
			let allLink = [];
			list.forEach((v, i) => {
				if (isFolder(v)) return;
				let filename = getFileName(v);
				let size = getFileSize(v);
				let dlink = getFileLink(v);
				let mirror = base.isType(getFileMirror) !== "undefined" ? getFileMirror(getFileLink(v)) : undefined;
				if (!dlink || !dlink.includes("http")) {
					content.find(".pl-main").append(`<div class="pl-item">
						<div class="pl-item-name listener-tip" data-size="${size}"><div class="name">${filename}</div><div class="size">${base.sizeFormat(size)}</div></div>
						<div class="pl-item-tip">获取下载链接失败，刷新网页后再试试吧~</div>
					</div>`)
				} else {
					if (temp.mode === "api") {
						allLink.push(dlink);
						content.find(".pl-main").append(`<div class="pl-item">
							<div class="pl-item-name listener-tip"><div class="name">${filename}</div><div class="size">${base.sizeFormat(size)}</div></div>
							<button class="pl-item-link pl-btn-primary pl-btn-default listener-api-download enhance listener-tip" data-index="${i}" data-link="${dlink}" data-filename="${filename}" data-size="${size}" data-title="建议换用 “Aria2 推送下载”，本方式若文件过大（具体取决于浏览器限制）可能会导致无法下载<br/>通过脚本跨域请求下载文件，适用于较新的浏览器，可在此显示剩余时间和速度"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-downward"/></svg>增强下载 (基于脚本跨域)</button>
							<button class="pl-item-link pl-btn-primary pl-btn-info listener-api-download normal listener-tip" data-link="${dlink}" data-filename="${filename}" data-title="通过浏览器访问链接下载文件，适用于支持 iframe 的浏览器<br/>点击后需等待浏览器弹出提示才可点击下个下载，否则只会下载后者"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-downward"/></svg>直接下载 (基于访问链接)</button>
							<button class="pl-item-copy pl-btn-primary pl-btn-success listener-copy listener-tip" data-copy='${filename}' data-title="点击复制文件名"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-copy"/></svg>复制名称</button>
							<button class="pl-item-copy pl-btn-primary pl-btn-warning listener-copy copy listener-tip" data-copy='${dlink}' data-title="点击复制下载链接"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-copy"/></svg>复制链接</button>
							<div class="pl-item-progress" style="display:none">
								<div class="pl-progress">
									<div class="pl-progress-outer"></div>
									<div class="pl-progress-inner" style="width:5%">
									<div class="pl-progress-inner-text">正在加载进度...0%</div>
									</div>
								</div>
								<button class="pl-btn-primary pl-btn-danger pl-progress-stop listener-stop"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-x-mark"/></svg>取消下载</button>
								<button class="pl-btn-primary pl-btn-info pl-progress-back listener-back" style="display:none"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-x-mark"/></svg>返回</button>
							</div>
						</div>`);
					}
					if (temp.mode === "curl") {
						let finalink = base.convertLinkToCurl(dlink, filename, convert?.curl);
						allLink.push(finalink);
						content.find(".pl-main").append(`<div class="pl-item">
							<div class="pl-item-name listener-tip" data-size="${size}"><div class="name">${filename}</div><div class="size">${base.sizeFormat(size)}</div></div>
							<a class="pl-item-link listener-copy listener-tip" data-copy='${finalink}' data-title="点击复制 curl 命令行">${finalink}<br/><svg class="pl-icon"><use xlink:href="#pl-icon-fa-copy"/></svg>复制 ${filename} 下载命令行</a>
						</div>`);
					}
					if (temp.mode === "aria2") {
						let finalink = base.convertLinkToAria2(dlink, filename, convert?.aria2);
						allLink.push(finalink);
						content.find(".pl-main").append(`<div class="pl-item">
							<div class="pl-item-name listener-tip" data-size="${size}"><div class="name">${filename}</div><div class="size">${base.sizeFormat(size)}</div></div>
							<button class="pl-item-link pl-btn-primary pl-btn-default listener-aria2-download" data-filename="${filename}" data-link="${dlink}"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-up"/></svg><span>推送链接到 Aria2 下载器</span></button>
							<button class="pl-btn-primary pl-btn-info listener-copy listener-tip" data-copy='${finalink}' data-title="Aria2 没启用 RPC？点击复制 aria2c 命令行手动下载"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-copy"/></svg>复制下载命令行</button>
						</div>`);
					}
					if (temp.mode === "bitcomet") {
						let finalink = base.convertLinkToBitComet(dlink, filename, convert?.bitcomet);
						allLink.push(finalink);
						content.find(".pl-main").append(`<div class="pl-item">
							<div class="pl-item-name listener-tip" data-size="${size}"><div class="name">${filename}</div><div class="size">${base.sizeFormat(size)}</div></div>
							<a class="pl-item-link pl-btn-primary pl-btn-default listener-tip" href="${finalink}" data-title="点击打开 BC 链接以手动调起比特彗星下载，右键可复制 BC 链接"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-downward"/></svg>使用 BC 链接下载</a>
							${mirror ? `<button class="pl-btn-primary pl-btn-success listener-copy listener-tip" data-copy='${mirror}' data-title="点击复制镜像地址"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-copy"/></svg>复制镜像</a>` : ""}
							<button class="pl-btn-primary pl-btn-info listener-bitcomet-download listener-tip" data-filename="${filename}" data-link="${dlink}" data-title="除非 BC 链接无法调起比特彗星，否则不建议使用此方式<br/><br/>由于比特彗星内置的远程下载 Web API 服务代码存在缺陷，请求可能会随机出现“发送失败 - 服务器返回空请求”错误，实际上客户端已成功开始下载<br/>由于脚本无法准确判断请求是否真正成功，即使出现错误，也会提示“成功”"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-up"/></svg><span>推送到下载器</span></button>
						</div>`);
					}
					if (temp.mode === "abdm") {
						content.find(".pl-main").append(`<div class="pl-item">
							<div class="pl-item-name listener-tip" data-size="${size}"><div class="name">${filename}</div><div class="size">${base.sizeFormat(size)}</div></div>
							<button class="pl-item-link pl-btn-primary pl-btn-default listener-abdm-download slient" data-filename="${filename}" data-link="${dlink}"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-up"/></svg><span>推送链接到 ABDM 下载器</span></button>
						</div>`);
					}
				}
			});
			allLink = (allLink ? allLink.join("\r\n") : "")
			if (temp.mode === "api" && list.length >= 2) {
				content.find(".pl-extra").append(`<button class="pl-btn-primary api listener-download-all enhance listener-tip" data-title="建议换用 “Aria2 推送下载”，本方式若文件过大有可能不会弹出下载后窗口<br/>通过脚本跨域请求下载文件，适用于较新的浏览器，可在此显示剩余时间和速度"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-downward"/></svg>全部增强下载</button>
				<button class="pl-btn-primary pl-btn-warning api listener-copy listener-tip" data-copy="${allLink}" data-title="点击复制全部下载链接"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-copy"/></svg>复制全部链接</button>`);
			} else if (temp.mode === "curl") {
				content.find(".pl-extra").append(`<button class="pl-btn-primary pl-btn-warning curl listener-open-setting listener-tip" data-title="${temp.terminalType[base.getValue('setting_curl_terminal')]}" data-back-to-downloads="true"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>修改终端类型</button>`);
				if (list.length >= 2) content.find(".pl-extra").append(`<button class="pl-btn-primary curl listener-copy listener-tip" data-copy='${allLink}' data-title="点击复制全部 curl 命令行"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-copy"/></svg>复制全部命令行</button>`);
			} else if (temp.mode === 'aria2') {
				let rpc = base.getValue("setting_aria2_rpc").find(i => i.default);
				content.find(".pl-extra").append(`<button class="pl-btn-primary pl-btn-warning aria2 listener-open-aria2-setting listener-tip" data-title="${rpc.domain + ':' + rpc.port + rpc.path}" data-back-to-downloads="true"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>修改服务参数</button>`);
				content.find(".pl-extra").append(`<button class="pl-btn-primary pl-btn-success aria2 listener-rpc-task youxiaohou listener-tip" data-title="访问原作者的 Aria2 管理页面以查看下载任务，功能较少"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-list-check"/></svg>查看任务 (油小猴)</button>`);
				content.find(".pl-extra").append(`<button class="pl-btn-primary pl-btn-success aria2 listener-rpc-task ariang listener-tip" data-title="访问 AriaNg 的官方 Demo 以查看下载任务，功能较多"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-list-check"/></svg>查看任务 (AriaNg)</button>`);
				if (list.length >= 2) content.find(".pl-extra").append(`<button class="pl-btn-primary pl-btn-default aria2 listener-send-rpc" data-type="aria2"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-up"/></svg>推送全部到下载器</button>`);
				if (list.length >= 2) content.find(".pl-extra").append(`<button class="pl-btn-primary pl-btn-info aria2 listener-copy listener-tip" data-copy='${allLink}' data-title="Aria2 没启用 RPC？点击复制 aria2c 命令行手动下载"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-copy"/></svg>复制全部命令行</button>`);
			} else if (temp.mode === "bitcomet") {
				let rpc = base.getValue("setting_bitcomet_rpc").find(i => i.default);
				content.find(".pl-extra").append(`<button class="pl-btn-primary pl-btn-warning bitcomet listener-open-bitcomet-setting listener-tip" data-title="${rpc.domain + ':' + rpc.port + rpc.path}" data-back-to-downloads="true"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>修改服务参数</button>`);
				if (list.length >= 2) content.find(".pl-extra").append(`<button class="pl-btn-primary pl-btn-default bitcomet listener-copy listener-tip" data-copy='${allLink}' data-title="点击复制全部 BC 链接"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-copy"/></svg>复制全部 BC 链接</button>`);
				if (list.length >= 2) content.find(".pl-extra").append(`<button class="pl-btn-primary pl-btn-info bitcomet listener-send-rpc listener-tip" data-type="bitcomet" data-title="除非 BC 链接无法调起比特彗星，否则不建议使用此方式<br/><br/>由于比特彗星内置的远程下载 Web API 服务代码存在缺陷，请求可能会随机出现“发送失败 - 服务器返回空请求”错误，实际上客户端已成功开始下载<br/>由于脚本无法准确判断请求是否真正成功，即使出现错误，也会提示“成功”"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-up"/></svg>推送全部到下载器</button>`);
			} else if (temp.mode === 'abdm') {
				let rpc = base.getValue("setting_abdm_rpc").find(i => i.default);
				content.find(".pl-extra").append(`<button class="pl-btn-primary pl-btn-warning abdm listener-open-abdm-setting listener-tip" data-title="${rpc.domain + ':' + rpc.port}" data-back-to-downloads="true"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>修改服务参数</button>`);
			}
			function updateTooltip($element, value) {
				if (!value) return;
				$element.addClass("listener-tip");
				if (value.startsWith('+')) {
					// 追加模式：去掉开头的 '+'，然后拼接到现有 data-title
					const newValue = value.substring(1);
					const existingTitle = $element.attr("data-title") || "";
					$element.attr("data-title", existingTitle + newValue);
				} else {
					// 替换模式
					$element.attr("data-title", value);
				}
			}
			if (tooltip?.enhance) updateTooltip(content.find(".enhance"), tooltip.enhance);
			if (tooltip?.normal) updateTooltip(content.find(".normal"), tooltip.normal);
			if (tooltip?.copy) updateTooltip(content.find(".copy"), tooltip.copy);
			if (tooltip?.filename) updateTooltip(content.find(".filename"), tooltip.filename);
			let html = content.html();
			content.remove();
			return html;
		},
		/**
		 * 获取镜像列表
		 * @author 油小猴
		 * @description 根据原始链接和镜像域名列表生成多个镜像链接，支持多线程下载。
		 * 每个镜像地址会根据 thread 参数生成多个重复链接（通过添加 `&` 符号区分）。
		 * @param {string} link - 原始下载链接
		 * @param {Array<string>} mirror - 镜像域名数组
		 * @param {number} [thread=2] - 每个镜像生成的线程数（链接重复次数），默认为 2
		 * @returns {string} 所有镜像链接组成的字符串，每行一个链接
		 *
		 * @example
		 * getMirrorList("https://example.com/file.zip", ["mirror1.com", "mirror2.com"], 2)
		 * // 返回:
		 * // https://mirror1.com/file.zip
		 * // https://mirror1.com/file.zip&
		 * // https://mirror2.com/file.zip
		 * // https://mirror2.com/file.zip&
		 */
		getMirrorList(link, mirror, thread = 2) {
			try {
				let host = new URL(link).host;
				let mirrors = [];
				for (let i = 0; i < mirror.length; i++) {
					for (let j = 0; j < thread; j++) {
						let item = link.replace(host, mirror[i]) + '&'.repeat(j);
						mirrors.push(item);
					}
				}
				return mirrors.join('\n');
			} catch {
				return undefined
			}
		},
		/**
		 * 添加页面元素监听
		 * @author 油小猴
		 * @author hmjz100
		 * @description 详见代码
		 */
		addPageListener() {
			$doc.on('click', '.listener-open-setting', (e) => {
				base.showSetting(e);
			});
			$doc.on('click', '.listener-open-aria2-setting', (e) => {
				base.showAria2Setting(e);
			});
			$doc.on('click', '.listener-open-bitcomet-setting', (e) => {
				base.showBitcometSetting(e);
			});
			$doc.on('click', '.listener-open-abdm-setting', (e) => {
				base.showABDMSetting(e);
			});
			$doc.on('click', '.listener-open-updatelog', () => {
				base.showUpdate();
			});
			$doc.on('click', '.listener-open-beautify', () => {
				base.showBeautify();
			});
			$doc.on('click', '.listener-unregister', async function (e) {
				message.warning("正在“注入”设置项目...");
				let list = base.getValue("setting_init");
				list.code = "";
				list.license = "";
				base.setValue('setting_init', list);
				base.delValue('baidu_access_token');
				location.reload();
			});
			$doc.on('change', '.listener-terminal', async function (e) {
				base.setValue('setting_curl_terminal', e.currentTarget.value);
			});
			$doc.on('click', '.listener-color', async function (e) {
				let element = $(e.currentTarget).closest('.listener-color').length > 0 ? $(e.currentTarget).closest('.listener-color') : $(e.currentTarget);
				let parent = element.closest('.pl-color');
				let mask = element.find(".mask");
				let color = element.data('color');
				if (color && parent.length > 0 && mask.length > 0) {
					parent.find(".this").remove();
					mask.append(`<div class="this"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-check"></use></svg></div>`);
					let list = base.getValue("setting_ui_theme")
					list.color = color;
					base.setValue("setting_ui_theme", list);
					base.addPanLinkerStyle();
				}
			});
			$doc.on('change', '.listener-theme', async function (e) {
				let list = base.getValue("setting_ui_theme");
				list.custom[e.currentTarget.dataset.type] = e.currentTarget.checked;
				base.setValue("setting_ui_theme", list);
			});
			$doc.on('click', '.listener-api-download.normal', async function (e) {
				e.preventDefault();
				let dataset = e.currentTarget.dataset;
				let link = new URL(dataset.link);
				$('#downloadIframe').attr('src', link.href);
			});
			$doc.on('click', '.listener-retry', async function (e) {
				let o = base._EventFactory(e);
				o.tip.hide();
				o.link.show();
				o.directLink.show();
			});
			$doc.on('click', '.listener-stop', async function (e) {
				let o = base._EventFactory(e);
				let index = o.link[0].dataset.index;
				if (temp.request[index]) {
					temp.request[index].abort();
					clearInterval(temp.ins[index]);
					o.item.find('.pl-progress-inner-text').text('正在取消...');
					o.item.find('.pl-progress-inner').css('width', 100 + '%');
					await base.sleep(1050);
					o.tip.hide();
					o.back.hide();
					o.link.show();
					o.directLink.show();
					o.copy.show();
					o.progress.hide();
					o.stop.hide();
				}
			});
			$doc.on('click', '.listener-back', async function (e) {
				let o = base._EventFactory(e);
				o.progress.hide();
				o.tip.hide();
				o.link.show();
				o.directLink.show();
				o.copy.show();
				o.stop.hide();
				o.back.hide();
			});
			$doc.on('click', '.listener-download-all', async function (e) {
				let target = $(e.currentTarget);
				let originalHtml = target.html();
				$('.pl-item-link.enhance').each((index, element) => {
					if ($(element).css('display') !== 'none') {
						$(element).click();
					}
				});
				target.text('下载开始，进度见上方按钮哦~').animate({ opacity: '0.5' }, "slow");
				await base.sleep(2000);
				target.css('opacity', "");
				target.html(originalHtml);
			});
			$doc.on('click', '.listener-send-rpc', async function (e) {
				let target = $(e.currentTarget);
				let originalHtml = target.html();
				$(`.listener-${target.data("type")}-download`).each((index, element) => {
					if ($(element).attr('data-processing') !== 'true') {
						$(element).click();
					}
				});
				target.text('发送完成，结果见上方按钮哦~').animate({ opacity: '0.5' }, "slow");
				await base.sleep(2000);
				target.css('opacity', "");
				target.html(originalHtml);
			});
			$doc.on('click', '.listener-copy', async function (e) {
				e.preventDefault();
				let target = $(e.currentTarget);
				let originalHtml = target.html();
				let copy = target.data("copy");
				if (copy) {
					base.setClipboard(copy)
					target.html(`<svg class="pl-icon"><use xlink:href="#pl-icon-fa-check"/></svg>复制成功`).animate({ opacity: '0.5' }, "slow");
					await base.sleep(2000);
					target.css('opacity', "");
					target.html(originalHtml);
				}
			});
			$doc.on('click', '.listener-rpc-task.youxiaohou', function () {
				let rpc = base.getValue("setting_aria2_rpc").find(i => i.default);
				let isHttps = rpc.domain.startsWith('https://');
				let url = `${isHttps ? 'https' : 'http'}://d.youxiaohou.com/?rpc=${base.encodeBase(JSON.stringify({ domain: rpc.domain, port: rpc.port }))}#${rpc.token}`;
				GM_openInTab(url, { active: true, insert: true, setParent: true });
			});
			$doc.on('click', '.listener-rpc-task.ariang', function () {
				let rpc = base.getValue("setting_aria2_rpc").find(i => i.default);
				let isHttps = rpc.domain.startsWith('https://');
				let url = `${isHttps ? 'https' : 'http'}://ariang.mayswind.net/latest/#!/settings/rpc/set?protocol=${isHttps ? 'wss' : 'ws'}&host=${rpc.domain.replace(/^(https?:\/\/)/, "")}&port=${rpc.port}&interface=${rpc.path.replace(/^\//, "")}&secret=${rpc.token}`;
				GM_openInTab(url, { active: true, insert: true, setParent: true });
			});
			$doc.on('change', '.listener-rpc-select', async function (e) {
				let element = $(this);
				let selectedIndex = element.val();
				let type = element.data("type");
				let list = base.getValue(`setting_${type}_rpc`);
				if (selectedIndex === 'new') {
					return $('.listener-rpc-input').val("");
				} else if (list[selectedIndex]) {
					list.forEach((item, index) => {
						if (item.default) {
							delete item.default;
						}
					});
					list[selectedIndex].default = true;
					base.setValue(`setting_${type}_rpc`, list);
					$('.listener-rpc-input').each((index, element) => {
						let type = $(element).data('type').split(".")[1];
						$(element).val(list[selectedIndex][type] || "");
					});
				}
			});
			$doc.on('input', '.listener-rpc-input', async function (e) {
				let type = $(this).data("type");
				if (!type) return;
				type = type.split(".")
				let list = base.getValue(`setting_${type[0]}_rpc`);
				let value = $(this).val();
				let selectedIndex = $('.listener-rpc-select option:selected').val();
				if (selectedIndex === 'new') {
					list.forEach((item, index) => {
						if (item.default) {
							delete item.default;
						}
					});
					list.push({
						domain: "",
						port: "",
						path: "",
						default: true
					});
					base.setValue(`setting_${type[0]}_rpc`, list);
					selectedIndex = list.length - 1
				}
				list[selectedIndex][type[1]] = value;
				base.setValue(`setting_${type[0]}_rpc`, list)
				let select = $('.listener-rpc-select');
				let options = list.map((item, index) => {
					return `<option value="${index}"${item.default ? ' selected' : ""}>${item.domain ? item.domain : ""}:${item.port ? item.port : ""}${item.path ? item.path : ""}</option>`;
				}).join("");
				select.html(`${options}<option value="new">+ 创建新项目</option>`);
			});
			$doc.on('click', '.listener-rpc-delete', async function (e) {
				let type = $(this).data("type");
				let list = base.getValue(`setting_${type}_rpc`);
				let selectedIndex = parseInt($('.listener-rpc-select option:selected').val(), 10);
				if (selectedIndex === 'new' || !confirm('您确定要删除此项目吗？')) return;
				list = list.filter((_, i) => i !== selectedIndex);
				if (list.length === 0) return alert('至少保留一个配置');
				let newDefaultIndex = selectedIndex === 0 ? 0 : selectedIndex - 1;
				list[newDefaultIndex].default = true;
				base.setValue(`setting_${type}_rpc`, list);
				let select = $('.listener-rpc-select');
				let options = list.map((item, index) => {
					return `<option value="${index}"${item.default ? ' selected' : ""}>${item.domain ? item.domain : ""}:${item.port ? item.port : ""}${item.path ? item.path : ""}</option>`;
				}).join("");
				select.html(`${options}<option value="new">+ 创建新项目</option>`);
				$('.listener-rpc-input').each(function () {
					let key = $(this).data('type').split(".")[1];
					$(this).val(list[newDefaultIndex][key] || "");
				});
			});
			$doc.on('click', '.listener-rpc-test', async function (e) {
				let element = $(this);
				let type = element.data("type");
				let selectedIndex = $('.listener-rpc-select option:selected').val();
				let list = base.getValue(`setting_${type}_rpc`);
				let text = element.find("span");
				let originalHtml = text.html();
				if (selectedIndex === 'new' || element.data("testing") === "true") return;
				if (list[selectedIndex]) {
					element.data("testing", "true");
					text.html("等待");
					element.css({ 'opacity': '0.9' });
					let selected = list.find(i => i.default);
					let result = "fail"
					if (type === "aria2") {
						let domain = selected.domain,
							port = selected.port,
							path = selected.path,
							token = selected.token;
						result = await base.testConnectToAria2(domain, port, path, token);
					} else if (type === "abdm") {
						let domain = selected.domain,
							port = selected.port;
						result = await base.testConnectToABDM(domain, port);
					}
					if (result === "success") {
						text.html("成功");
						element.css({ 'background-color': '#52c41a' });
					} else {
						text.html("失败");
						element.css({ 'background-color': '#cb1616' });
					}
					element.css({ 'opacity': "" });
					await base.sleep(3000);
					element.data("testing", "false");
					text.html(originalHtml);
					element.css({ 'background-color': "" });
				}
			});
		},
		/**
		 * 创建基础样式
		 * @author 油小猴
		 * @author hmjz100
		 * @description 为组件添加默认的公共样式，包括浅色和深色模式适配样式。
		 */
		addPanLinkerStyle() {
			temp.color = base.getValue('setting_ui_theme').color;
			if ('beautifyPage' in temp.main) temp.main.beautifyPage();
			base.addStyle('swal-pub-style', 'style', `@media (prefers-color-scheme:light){${GM_getResourceText('SwalLigt')}}`);
			base.addStyle('swal-pub-dark-style', 'style', `@media (prefers-color-scheme:dark){${GM_getResourceText('SwalDark').replace(/#19191a/, '#222226')}}`);
			base.addStyle('swal-pub-custom-style', 'style', `
.swal2-container *{vertical-align:baseline}
.swal2-styled{transition:all.2s}
.swal2-loader{display:none;align-items:center;justify-content:center;width:2.2em;height:2.2em;margin:0 1.875em;-webkit-animation:swal2-rotate-loading 1.5s linear 0s infinite normal;animation:swal2-rotate-loading 1.5s linear 0s infinite normal;border-width:.25em;border-style:solid;border-radius:100%;border-color:${temp.color} transparent }
.swal2-timer-progress-bar-container{position:absolute;right:0;bottom:0;left:0;grid-column:auto;overflow:hidden;border-bottom-right-radius:5px;border-bottom-left-radius:5px}
.swal2-timer-progress-bar{width:100%;height:.25em;background:${temp.color}33 }
.swal2-progress-steps .swal2-progress-step{z-index:20;flex-shrink:0;width:2em;height:2em;border-radius:2em;background:${temp.color};color:#fff;line-height:2em;text-align:center}
.swal2-progress-steps .swal2-progress-step.swal2-active-progress-step{background:${temp.color} }
.swal2-progress-steps .swal2-progress-step-line{z-index:10;flex-shrink:0;width:2.5em;height:.4em;margin:0 -1px;background:${temp.color}}
.swal2-html-container{padding:1em 1.6em 0.3em;margin:0}
.swal2-close,div:where(.swal2-container) button:where(.swal2-close){position:absolute;border-radius:10px;top:0;right:0;transition:all.2s}
.swal2-close:hover,div:where(.swal2-container) button:where(.swal2-close):hover{color:${temp.color};background-color:${temp.color}30;font-size:60px}
.swal2-styled{display:flex;justify-content:center;align-items:center;gap:5px}
.swal2-styled.swal2-confirm,div:where(.swal2-container) button:where(.swal2-styled):where(.swal2-confirm){background-color:${temp.color};color:#fff}
.swal2-styled.swal2-confirm:focus,div:where(.swal2-container) button:where(.swal2-styled):where(.swal2-confirm):focus{box-shadow:0 0 0 3px ${temp.color}80}
.swal2-styled.swal2-deny:focus,.swal2-close:focus,div:where(.swal2-container) button:where(.swal2-styled):where(.swal2-deny):focus{box-shadow:0 0 0 3px #dc374180}
.swal2-styled.swal2-cancel:focus,div:where(.swal2-container) button:where(.swal2-styled):where(.swal2-cancel):focus{box-shadow:0 0 0 3px #6e788180}
.swal2-styled.swal2-confirm,
.swal2-styled.swal2-deny,
.swal2-styled.swal2-cancel,
div:where(.swal2-container) button:where(.swal2-styled):where(.swal2-confirm),
div:where(.swal2-container) button:where(.swal2-styled):where(.swal2-deny),
div:where(.swal2-container) button:where(.swal2-styled):where(.swal2-cancel)
{border-radius:50px}
div:where(.swal2-container) div:where(.swal2-actions):not(.swal2-loading) .swal2-styled:hover{opacity:0.7}
.swal2-backdrop-show,.swal2-noanimation,div:where(.swal2-container).swal2-backdrop-show, div:where(.swal2-container).swal2-noanimation{background:rgba(25,25,26,.75);transition:backdrop-filter.2s;backdrop-filter:blur(1px)}
body.swal2-toast-shown .swal2-container{backdrop-filter:none}
.swal2-popup,div:where(.swal2-container) div:where(.swal2-popup){padding-bottom:1em;border-radius:10px}
.swal2-title,div:where(.swal2-container) h2:where(.swal2-title){height:auto}
.swal2-html-container,div:where(.swal2-container) div:where(.swal2-html-container){padding:1.3em 1.3em 0.3em;margin:0}
.swal2-footer,div:where(.swal2-container) div:where(.swal2-footer){flex-direction:column;justify-content:center;align-items:center}
.swal2-footer p,div:where(.swal2-container) div:where(.swal2-footer) p{margin:0;padding:0}
.swal2-icon-content,div:where(.swal2-icon) .swal2-icon-content{font-family:sans-serif}
.swal2-input, .swal2-file, swal2-select, .swal2-textarea,
div:where(.swal2-container) input:where(.swal2-input),
div:where(.swal2-container) input:where(.swal2-file),
div:where(.swal2-container) input:where(.swal2-select),
div:where(.swal2-container) textarea:where(.swal2-textarea)
{box-shadow:none}
.swal2-input:focus, .swal2-file:focus, .swal2-select:focus, .swal2-textarea:focus,
.swal2-input:focus-visible, .swal2-file:focus-visible, .swal2-select:focus-visible, .swal2-textarea:focus-visible,
div:where(.swal2-container) input:where(.swal2-input):focus,
div:where(.swal2-container) input:where(.swal2-input):focus-visible,
div:where(.swal2-container) input:where(.swal2-file):focus,
div:where(.swal2-container) input:where(.swal2-file):focus-visible,
div:where(.swal2-container) input:where(.swal2-select):focus,
div:where(.swal2-container) input:where(.swal2-select):focus-visible,
div:where(.swal2-container) textarea:where(.swal2-textarea):focus,
div:where(.swal2-container) textarea:where(.swal2-textarea):focus-visible
{outline:0;border:1px solid ${temp.color};box-shadow:0 0 0 3px ${temp.color}80}
.swal2-checkbox, .swal2-file, .swal2-input, .swal2-radio, .swal2-select, .swal2-textarea,
div:where(.swal2-container) input:where(.swal2-input), div:where(.swal2-container) input:where(.swal2-file), div:where(.swal2-container) textarea:where(.swal2-textarea), div:where(.swal2-container) select:where(.swal2-select), div:where(.swal2-container) div:where(.swal2-radio), div:where(.swal2-container) label:where(.swal2-checkbox)
{margin:1em 2em}`);
			base.addStyle(`${mount}-main-style`, 'style', `
::-webkit-scrollbar{width:8px;height:8px}
::-webkit-scrollbar-track{border-radius:10px;background:#fff}
::-webkit-scrollbar-thumb,::-webkit-scrollbar-thumb:hover{border-radius:10px}
::-webkit-scrollbar-thumb{background-color:${temp.color}90!important,transition:background-color.2s;will-change:background-color}
::-webkit-scrollbar-thumb:hover{background-color:${temp.color}D0!important}
.swal2-popup{font-size:16px}
.pl-popup{font-size:12px;min-width:70%;max-width:95%}
.pl-header{padding:0;align-items:flex-start;border-bottom:1px solid #eee;margin:0 0 10px;padding:0 0 5px}
.pl-title{font-size:18px;white-space:nowrap;text-overflow:ellipsis}
.pl-content{padding:0;font-size:12px}
.pl-footer{font-size:15px;text-align:center;display:block}
.pl-icon{width:15px;height:15px;vertical-align:-0.15em;fill:currentColor;overflow:hidden;font-size:18px}
.pl-main{background:${temp.color}15;border-radius:10px;display:flex;flex-direction:column;gap:8px;max-height:calc(${document.documentElement.clientHeight}px - 300px);overflow:auto;padding:8px 6px}
.pl-a{position:relative;vertical-align:baseline;color:${temp.color};border-bottom:2px solid ${temp.color};text-decoration:none!important;transition:color.3s,opacity.3s;will-change:color,opacity;overflow:hidden}
.pl-a::before{content:"";position:absolute;left:0;bottom:0;width:100%;height:100%;background-color:${temp.color};transform:scaleY(0);transform-origin:bottom center;transition:transform.15s,opacity.3s;will-change:transform;z-index:-1}
.pl-a:hover,.pl-a:focus{color:#fff}
.pl-a:hover::before,.pl-a:focus::before{transform:scaleY(1)}
.pl-a:active{color:#fff;opacity:0.8}
.pl-a .pl-icon{vertical-align:-0.06em;}
.pl-item{display:flex;align-items:center;background:${temp.color}30;border-radius:8px;padding:5px;gap:10px}
.pl-item-name{width:15%;text-align:left;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;cursor:default}
.pl-item-name>*{text-align:left;overflow:hidden;white-space:nowrap;text-overflow:ellipsis}
.pl-item-link{flex:1;cursor:pointer}
a.pl-item-link{color:${temp.color};text-align:left;white-space:nowrap;text-overflow:ellipsis;overflow:hidden;transition:color.15s;will-change:color}
a.pl-item-link:hover{color:#fff}
.pl-item-tip{display:flex;justify-content:space-between;flex:1}
.pl-item-progress{display:flex;flex:1;align-items:center}
.pl-progress{display:inline-block;vertical-align:middle;width:100%;box-sizing:border-box;line-height:1;position:relative;height:20px;margin:0 6px;flex:1}
.pl-progress-outer{height:20px;border-radius:100px;background-color:#c1c1c1;overflow:hidden;position:relative;vertical-align:middle}
.pl-progress-inner{position:absolute;left:0;top:0;background-color:${temp.color};border-radius:100px;line-height:1;white-space:nowrap;transition:width.6s;will-change:width;height:20px;display:inline-flex;text-align:center;align-items:center}
.pl-progress-inner-text{display:inline-block;vertical-align:middle;cursor:default;color:#ffffff;font-size:12px;margin:0 5px;height:20px;width:100%}
.pl-progress-inner-text:after{display:inline-block;content:"";height:100%;vertical-align:middle}
.pl-ext{display:inline-block;width:44px;background:#999;color:#fff;height:16px;line-height:16px;font-size:12px;border-radius:3px}
.pl-retry{padding:3px 10px;background:#cc3235;color:#fff;border-radius:3px;cursor:pointer}
.pl-extra{display:flex;justify-content:center;background-color:${temp.color}15;border-radius:10px;gap:10px}
.pl-extra:has(>*){margin-top:1.25em;padding:8px 6px}
.pl-extra>.api.listener-download-all,.pl-extra>.curl.listener-copy,.pl-extra>.aria2.listener-send-rpc,.pl-extra>.bitcomet.listener-copy,.pl-extra>.abdm{flex:1}
.pl-extra:not(:has(>.api.listener-download-all,>.curl.listener-copy,>.aria2.listener-send-rpc,>.bitcomet.listener-copy,>.abdm))>*{flex:1}
.pl-btn-primary{color:#ffffff!important;background:${temp.color};border:0;border-radius:50px;cursor:pointer;font-size:12px;outline:none;display:flex;align-items:center;justify-content:center;gap:5px;padding:0.625em 1.1em;transition:opacity.2s,box-shadow.2s;will-change:opacity,box-shadow}
.pl-btn-primary:hover{opacity:0.8}
.pl-btn-primary:focus{box-shadow:0 0 0 3px ${temp.color}80}
.pl-btn-success{background:#55af28}
.pl-btn-success:focus{box-shadow:0 0 0 3px #55af2880}
.pl-btn-info{background:#606266}
.pl-btn-info:focus{box-shadow:0 0 0 3px #60626680}
.pl-btn-warning{background:#da9328}
.pl-btn-warning:focus{box-shadow:0 0 0 3px #da932880}
.pl-btn-danger{background:#cc3235}
.pl-btn-danger:focus{box-shadow:0 0 0 3px #cc323580}
.pl-btn-opacity{animation:easeOpacity 1.2s 2;animation-fill-mode:forwards;will-change:opacity}
@keyframes easeOpacity{ from{opacity:1} 50%{opacity:0.35} to{opacity:1} }
.pl-button-mini{padding:5px 10px}
.pl-button,.pl-dropdown-menu{transition:all.2s}
.pl-button{position:relative}
.pl-button .pl-dropdown-menu{opacity:0;pointer-events:none;will-change:opacity}
.pl-button:hover .pl-dropdown-menu{opacity:1;pointer-events:auto}
.pl-button-init{opacity:0.5;animation:easeInitOpacity 1.2s 5;animation-fill-mode:forwards}
@keyframes easeInitOpacity{ from{opacity:0.5} 50%{opacity:1} to{opacity:0.5} }
.pl-dropdown-menu{position:absolute;padding:5px 0;color:${temp.color};background:#fff;z-index:999;min-width:110px;border-radius:5px;box-shadow:0 1px 6px ${temp.color}33;-webkit-box-shadow:0 1px 6px ${temp.color}33;text-align:center;border:none}
@media (prefers-color-scheme:dark){ .pl-dropdown-menu{color:#fff;background:#222226} }
.pl-button-mode{color:${temp.color}!important;height:30px;padding:0 10px!important;display:flex;align-items:center;justify-content:center;gap:5px;cursor:pointer;white-space:nowrap;transition:background-color.2s;will-change:background-color}
@media (prefers-color-scheme:dark){ .pl-dropdown-menu .pl-button-mode{color:#fff!important} }
.pl-button-mode:hover{background-color:${temp.color}33!important}
@media (prefers-color-scheme:dark){ .pl-button-mode:hover{color:#fff!important;background:${temp.color}!important} }
header[style="display:none;"]~.pl-button{display:inline-block;position:fixed;top:0.6em;left:65%;z-index:99999}
.color-button{background:${temp.color}!important;border-color:${temp.color}!important;border:1px solid ${temp.color}!important;display:inline-flex;transition:background.2s,border-color.2s;will-change:background,border-color}
.color-button:hover{background:${temp.color}b0!important;border-color:${temp.color}!important}
.ali-button{background:${temp.color};border:0 solid transparent;font-size:14px;margin-left:20px;padding:8px 16px;position:relative;height:32px;border-radius:100px;display:flex;align-items:center;justify-content:center;color:var(--basic_white);cursor:pointer;transition:background.2s;will-change:background}
.ali-button:hover{background:${temp.color}D0}
.ali-btn-icon{vertical-align:-0.2em}
.mcloud-button{float:left;position:relative;margin:20px 24px 20px 0;width:110px;height:36px;background:${temp.color};border-radius:2px;font-size:14px;color:#fff;line-height:39px;text-align:center;cursor:pointer;will-change:background}
.mcloud-button:hover{background:${temp.color}b0}
.mcloud-share-button{display:inline-block;position:relative;font-size:14px;line-height:36px;height:36px;text-align:center;color:#fff;border:1px solid ${temp.color};border-radius:2px;padding:0 24px;background:${temp.color};will-change:background}
.mcloud-share-button:hover{background:${temp.color}b0}
.mcloud-btn{background:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAAAAXNSR0IB2cksfwAAAAlwSFlzAAALEwAACxMBAJqcGAAAAGNQTFRFAAAA////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////mkUNoAAAACF0Uk5TAAbHPP9AMRtr9PwrV8zqXfmNgDODHTLD4iJxhGJJ8Z269m0aDgAAAMZJREFUeJzd0ssOgyAQBVDUK74rWq0PFP3/ryxqTMdGqJtuvGHD5CTDTGDs3nFc17kEPcC7BH3At/Tjvk5AYbBU+NcrwghL4uQDk3gtRSF1KWCCQEpghkd+3jp/ICNQoDANU0AQCJQmWAJ3h8+q3mFdvSywQdttsGvRWGAPLReoHXrbG6WWAzBoJ+3DaCnWI39NLbcvszvLeuTB2fYoqbNBNo7sGjzk31BhMsEJitxmiKk8zSQwE8gFjBGcNuCzOmdqPrib5A2JRQ7qK9g+hQAAAABJRU5ErkJggg==");height:20px;line-height:20px;display:inline-block;background-repeat:no-repeat;background-size:20px 20px;text-indent:25px}
.tcloud-button{color:#fff;border:1px solid ${temp.color};background:${temp.color};position:relative;height:30px;padding:0 12px;margin-right:12px;font-size:12px;line-height:28px;cursor:pointer;will-change:background,border-color}
.tcloud-button:hover{border-color:${temp.color}b0;background:${temp.color}b0}
.xunlei-button{display:inline-flex;align-items:center;justify-content:center;border:0 solid transparent;border-radius:5px;box-shadow:0 0 0 0 transparent;width:fit-content;white-space:nowrap;flex-shrink:0;font-size:14px;line-height:1.5;outline:0;touch-action:manipulation;transition:background.2s,color.2s,border.2s,box-shadow.2s;color:#fff;background:${temp.color};margin-left:12px;padding:0px 12px;position:relative;cursor:pointer;height:36px;will-change:background}
.xunlei-button:hover{background:${temp.color}b0}
.quark-button,.uc-button{padding:0 14px;background:${temp.color}!important;background-color:${temp.color}!important;will-change:background,background-color}
.uc-btn-icon{width:20px;height:20px;vertical-align:-0.3em}
.uc-button{padding:10px 20px!important}
.pl-setting-item{display:flex;align-items:center;justify-content:space-between;margin-top:1em}
.pl-setting-item > *:nth-child(2){max-width:80%;display:flex;justify-content:space-between;align-items:center}
.pl-setting-item .pl-setting-item{margin:0;gap:5px}
.pl-input{padding:8px 10px!important;border:1px solid #c2c2c2;border-radius:5px;font-size:14px!important;margin:0;appearance:auto!important}
.pl-setting-item > .pl-input:not([type="checkbox"]){width:80%}
.init-input{width:90%;margin:0;margin:10px 0;text-align:center;font-family:system-ui,-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Ubuntu,"Helvetica Neue",sans-serif;font-weight:300}
.pl-tooltip{position:absolute;z-index:110000;display:none;align-items:center;color:#ffffff;background:#333;font-size:12px;line-height:1.3;max-width:600px;border-radius:5px;word-break:break-all;will-change:display,top,left}
.pl-tooltip>*{padding:5px 10px}
.pl-tooltip>*:first-child{border:1px solid;border-top-left-radius:5px;border-bottom-left-radius:5px;border-top-color:#333;border-bottom-color:#333;border-left-color:#333;border-right-color:transparent}
.pl-tooltip>*:last-child{border:1px solid;border-top-right-radius:5px;border-bottom-right-radius:5px;border-top-color:#333;border-bottom-color:#333;border-left-color:transparent;border-right-color:#333}
.pl-loading-box>div>div{position:absolute;border-radius:50%}
.pl-loading-box>div>div:nth-child(1){top:9px;left:9px;width:82px;height:82px;background:#ffffff}
@keyframes load{ 0%{transform:rotate(0deg)} 100%{transform:rotate(360deg)} }
.pl-loading-box>div>div:nth-child(2){top:14px;left:38px;width:25px;height:25px;background:${temp.color};animation:load 1s linear infinite;transform-origin:12px 36px}
.pl-loading{width:16px;height:16px;display:inline-block;overflow:hidden;background:none}
.pl-loading-box{width:100%;height:100%;position:relative;transform:translateZ(0) scale(0.16);backface-visibility:hidden;transform-origin:0 0}
.pl-loading-box div{box-sizing:content-box}
.pl-button-save{background-color:${temp.color}!important;color:#fff!important}
.pl-button-save:hover{background-color:${temp.color}D0!important;color:#fff!important}
.swal2-container{z-index:100000}
body.swal2-height-auto{height:inherit}
[class^="swal2-"],[class*="pl-btn"]{transition:all.2s}
/* 适配（改）百度网盘会员青春版 */
a.downloadSubtitle, button.downloadSubtitle{transition:all.2s;background-color:${temp.color}}
a.downloadSubtitle:hover, button.downloadSubtitle:hover{background-color:${temp.color}D0}
a.downloadSubtitle:disabled, button.downloadSubtitle:disabled{background-color:${temp.color}D0}
/* 哪里都没用到的 RGB! */
@keyframes RGB{ 0%{filter:hue-rotate()} to{filter:hue-rotate(-360deg)} }
/* Webkit, Opera, IE9, Chrome*/
::selection, ::-webkit-selection, ::-moz-selection, ::-ms-selection{background-color:${temp.color}!important;background:${temp.color}!important;color:white!important}
`);
		},
		/**
		 * 初始化引导弹窗
		 * @author 油小猴
		 * @author hmjz100
		 * @description 显示初始化对话框，引导用户进行配置或跳过流程。
		 * 支持输入特定数字触发彩蛋，并自动注入默认设置点亮功能。
		 * @returns {Promise<void>} 弹窗关闭后返回空值，可能触发页面刷新
		 */
		async showInitDialog() {
			let dialog = await Swal.fire({
				...temp.swalDefault,
				title: `(◍•ᴗ•◍)/ 你好呀`,
				html: `<div class="pl-init-content">
					<p>“这里好像没什么好输入的…”</p>
					<input type="text" autocomplete="off" class="swal2-input init-input" id="init" placeholder="输入内容...">
					<p>
						但其实…你可以按下下方的 <span style="color:red">红色按钮</span> 跳过流程<br/>
						或者继续输入一些神秘的 <span class="listener-tip" data-title="乙烯一克，一克一克一克……锕！<br/>　　　　　　▃▃▆█▇▄▖<br/>　　　　▟◤▖　　　　◥█▎<br/>　　◢◤　　▐　　　　　▐▉<br/>　▗◤　　▂　　▗▖　　　▕█▎<br/>　◤　▗▅▖◥▄　▀◣　　　　█▊<br/>▐　▕▎◥▖◣◤　　　　　◢██<br/>█◣　◥▅█▀　　　　　▐██◤<br/>▐█▙▂　　　　　　◢██◤<br/>　◥██◣　　　　◢▄◤<br/>　　　▀██▅▇▀" style="font-style:italic;color:#412300;background-color:#d0b164">“恶臭数字”</span>，解锁隐藏彩蛋~
					</p>
					<p>
						如果您喜欢这个脚本的话<br/>
						请支持原作者 <a class="listener-tip pl-a" target="_blank" href="https://www.youxiaohou.com" data-title="${config.base.service.account ? `的微信公众号……<br/><img style='width:250px' src='${config.base.service.account}'>` : ""}"><svg class="pl-icon"><use xlink:href="#pl-icon-si-tampermonkey"></use></svg> 油小猴</a><br/>
						或给此改版点个 <a class="listener-tip pl-a" target="_blank" href="https://github.com/hmjz100/LinkSwift/" data-title="来看看此项目的 Github 页面吧~"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-star"></use></svg> Star</a> ？
					</p>
					<p>
						脚本不仅能精简网盘界面<br/>点亮后还能修改多个网盘的主题色哦！
					</p>
				</div>
				<style>
				.pl-init-content p{margin:10px 0!important}
				</style>
				`,
				showCloseButton: true,
				showDenyButton: true,
				denyButtonText: '<svg class="pl-icon"><use xlink:href="#pl-icon-fa-unlock-keyhole"></use></svg> 懒得输入...我要直接点亮！',
				allowOutsideClick: false,
			});
			if (dialog.isDenied) {
				message.warning("正在“注入”设置项目...");
				await base.sleep(2500);
				let list = base.getValue("setting_init");
				list.code = config.base.num;
				list.license = config.base.license;
				base.setValue("setting_init", list);
				message.success("“注入”成功啦!");
				await base.sleep(1500);
				location.reload();
			};
			if (dialog.isConfirmed) {
				if ($('#init').val() === '114514' || $('#init').val() === '1919810' || $('#init').val() === '1145141919810') {
					await Swal.fire({
						...temp.swalDefault,
						icon: 'error',
						title: '1145141919810',
						html: '<span>homo特有的数字当然不行啦<br/>哼哼哼啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊</span>',
						timer: 4000,
						imageUrl: 'https://pic1.zhimg.com/v2-1b97a088e156c015108dec663bba8b04.avis',
						allowOutsideClick: false,
						timerProgressBar: true,
						showConfirmButton: false,
						showDenyButton: true,
						denyButtonText: '哼哼哼啊啊啊啊啊啊啊啊啊啊',
					});
					message.info("成就：你触发了一个homo特有的彩蛋！");
					await base.sleep(4000)
					Swal.fire({
						...temp.swalDefault,
						title: '1145141919810',
						text: 'homo特有的数字当然不行啦...吗？',
						icon: 'question',
						imageUrl: 'https://lh1.hetaousercontent.com/img/7d4c1c0b4adb0e95.jpg',
						showConfirmButton: false,
						allowOutsideClick: false,
					});
					await base.sleep(3000)
					let list = base.getValue("setting_init");
					list.code = config.base.num;
					list.license = config.base.license;
					base.setValue("setting_init", list);
					message.success("成就：哼哼哼啊啊啊啊啊啊啊啊地注入成功(喜)");
					await base.sleep(1500)
					location.reload();
				} else {
					await this.showInitDialog();
					return;
				};
			}
		},
		/**
		 * 显示主对话框
		 * @author 油小猴
		 * @author hmjz100
		 * @description 使用 SweetAlert2 显示一个自定义样式的对话框，用于展示信息或操作提示。
		 * @param {string} title - 对话框标题
		 * @param {string} html - 对话框内容的 HTML 字符串
		 * @param {string} footer - 对话框底部说明文字
		 */
		showMainDialog(title, html, footer) {
			Swal.fire({
				...temp.swalDefault,
				title,
				html,
				footer: `${footer}<p>${config.base.dom.footer}</p>`,
				customClass: {
					popup: 'pl-popup',
					header: 'pl-header',
					title: 'pl-title',
					closeButton: 'pl-close',
					content: 'pl-content',
					input: 'pl-input',
					footer: 'pl-footer'
				},
				confirmButtonText: `<svg class="pl-icon"><use xlink:href="#pl-icon-fa-x-mark"/></svg> 关闭`,
				showCloseButton: true,
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: false,
				willClose: () => {
					base._resetAllData();
				},
			}).then(() => {
				base._resetAllData();
			});
		},
		/**
		 * 等待指定元素加载完成并执行回调
		 * @author hmjz100
		 * @description 监听 DOM 元素是否出现，若未出现则每隔一段时间重试，直到找到为止。
		 * 支持在 iframe 内部查找元素，适用于异步加载场景。
		 * @param {string} selectorElem - 要等待的目标元素选择器
		 * @param {Function} actionFunction - 找到元素后执行的回调函数，接收 jQuery 元素作为参数，返回 true 可以不再继续寻找
		 * @param {boolean} [bWaitOnce=false] - 是否只执行一次回调，默认为 false，如果不设置为 true 的话需要自行判断是否对元素进行操作
		 * @param {string} [iframeSelector] - 若目标元素位于 iframe 中，传入 iframe 的选择器
		 * @param {string} [controlKey] - 控制唯一性的键名，用于避免重复处理
		 */
		waitForKeyElements(selectorElem, actionFunction, bWaitOnce, iframeSelector, controlKey) {
			// 初始化管理器
			const manager = this.waitForKeyElements.manager || (
				this.waitForKeyElements.manager = {
					observers: new WeakMap(),
					tasks: new Map(),
					instanceCounter: 0
				}
			);
			const targetDoc = iframeSelector
				? $(iframeSelector).get(0)?.contentDocument
				: document;
			if (!targetDoc) return; // 无效文档直接返回
			// 生成唯一控制键
			controlKey = controlKey || `wkfe_${manager.instanceCounter++}`;
			// 清理重复任务
			const existingTask = manager.tasks.get(controlKey);
			if (existingTask) {
				existingTask.observer.disconnect();
				manager.tasks.delete(controlKey);
			}
			// 创建MutationObserver回调
			const processElements = () => {
				const elements = $(selectorElem, targetDoc);
				let foundActive = false;
				elements.each((i, el) => {
					const jEl = $(el);
					const isProcessed = jEl.data(controlKey);
					if (isProcessed) return true; // 跳过已处理元素
					const cancelAction = actionFunction(jEl);
					if (cancelAction) {
						foundActive = true;
					} else if (bWaitOnce) {
						jEl.data(controlKey, true); // 标记已处理
					}
				});
				// 一次性任务且找到有效元素时清理
				if (bWaitOnce && foundActive) {
					observer.disconnect();
					manager.tasks.delete(controlKey);
				}
			};
			// 创建Observer实例
			const observer = new MutationObserver(processElements);
			// 配置并启动观察
			observer.observe(targetDoc.documentElement, {
				childList: true,
				subtree: true,
				attributes: true,
				characterData: true
			});
			// 注册任务
			manager.tasks.set(controlKey, {
				observer,
				targetDoc
			});
			// 立即执行初始检查
			processElements();
		},
		/**
		 * 状态工厂
		 * @author 油小猴
		 * @author hmjz100
		 * @description 接受被监听的 DOM 元素的状态，根据状态确定元素是谁
		 * @param {Event} event - 元素状态
		 */
		_EventFactory(event) {
			let target = $(event.target);
			let item = target.parents('.pl-item');
			let link = item.find('.pl-item-link.enhance');
			let directLink = item.find('.pl-item-link.normal');
			let progress = item.find('.pl-item-progress');
			let tip = item.find('.pl-item-tip');
			let copy = item.find('.pl-item-copy');
			let back = item.find('.pl-progress-back');
			let stop = item.find('.pl-progress-stop');
			return {
				item, link, directLink, progress, tip, copy, back, stop, target,
			};
		}
	};
	/**
	 * 百度网盘
	 * @author 油小猴
	 * @author hmjz100
	 */
	let $baidu = {
		async getToken() {
			try {
				$doc.find('.loading-popup .loading-title').html(`令牌获取中`);
				$doc.find('.loading-popup .swal2-html-container').html(`<div>正在获取授权状态~</div>`);
				// 获取授权状态
				let authorize = await base.getFinalUrl(config.$baidu.api.getAccessToken, undefined, true);
				let accessToken = "";
				// 判断授权情况
				if (authorize.includes('authorize')) {
					$doc.find('.loading-popup .loading-title').html(`授权获取中`);
					$doc.find('.loading-popup .swal2-html-container').html(`<div>正在获取授权页面~</div>`);
					// 没授权，先获取授权的页面
					let html = await base.get(config.$baidu.api.getAccessToken, undefined, 'text');
					// 提取页面的发送确认授权的参数
					let bdstoken = html.match(/name="bdstoken"\s+value="([^"]+)"/)?.[1];
					let client_id = html.match(/name="client_id"\s+value="([^"]+)"/)?.[1];
					let data = {
						grant_permissions_arr: 'netdisk',
						bdstoken: bdstoken,
						client_id: client_id,
						response_type: "token",
						display: "page",
						grant_permissions: "basic,netdisk"
					};
					$doc.find('.loading-popup .swal2-html-container').html(`<div>正在自动确认授权~</div>`);
					// 发送请求达到自动进行授权
					await base.post(config.$baidu.api.getAccessToken, base.stringify(data), { "Content-Type": "application/x-www-form-urlencoded" });
					// 再次获取授权状态
					let res2 = await base.getFinalUrl(config.$baidu.api.getAccessToken, undefined, true);
					accessToken = res2.match(/access_token=([^&]+)/)?.[1];
				} else if (authorize.includes('access_token=')) {
					accessToken = authorize.match(/access_token=([^&]+)/)?.[1];
				}
				// 统一处理令牌结果
				$doc.find('.loading-popup .loading-title').html(`令牌获取中`);
				if (!!accessToken) {
					$doc.find('.loading-popup .swal2-html-container').html(`<div>授权成功，令牌已缓存~</div>`);
					base.setValue('baidu_access_token', accessToken);
					return accessToken;
				} else return "";
			} catch (error) {
				return "";
			}
		},
		addPageListener() {
			$doc.on('mouseenter mouseleave click', '.pl-button.g-dropdown-button', function (e) {
				if (e.type === 'mouseleave') {
					$(e.currentTarget).removeClass('button-open');
				} else {
					$(e.currentTarget).addClass('button-open');
					$(e.currentTarget).find('.pl-dropdown-menu').show();
				}
			});
			$doc.on('mouseleave', '.pl-button.g-dropdown-button .pl-dropdown-menu', function (e) {
				$(e.currentTarget).hide();
			});
			$doc.on('click', '.pl-button-mode', async function (e) {
				temp.mode = e.currentTarget.dataset.mode;
				if (!temp.mode) return;
				temp.main.getLink();
			});
			$doc.on('click', '.pl-button-save', async function (e) {
				e.preventDefault();
				let selectList = temp.main.getSelectedList();
				if (selectList.length === 0) {
					return message.error('提示：<br/>请勾选要保存到网盘的文件哦~');
				}
				message.info('提示：<br/>因网盘限制，请保存到自己网盘后再去下载哦~');
				await base.sleep(500);
				document.querySelector('.tools-share-save-hb').click();
			});
			$doc.on('click', '.listener-api-download.enhance', async function (e) {
				e.preventDefault();
				let o = base._EventFactory(e);
				let $width = o.item.find('.pl-progress-inner');
				let $text = o.item.find('.pl-progress-inner-text');
				let filename = o.link[0].dataset.filename;
				let index = o.link[0].dataset.index;
				let size = Number(o.link[0].dataset.size) || 0;
				let originalHtml = o.link.html();
				base._resetData(index);
				base.get(o.link[0].dataset.link, { "User-Agent": config.$baidu.api.ua.downloadLink, "Origin": "", "Referer": "", "DNT": "" }, 'blob', { filename, index });
				let startTime = Date.now();
				let prevLoaded = 0;
				let prevTime = startTime;
				temp.ins[index] = setInterval(async () => {
					let prog = +temp.progress[index] || 0;
					let isIDM = !!temp.idm[index];
					if (isIDM) {
						// IDM 捕获处理逻辑
						o.tip.hide();
						o.progress.hide();
						o.copy.show();
						o.directLink.show();
						o.link
							.text('链接已被IDM捕获~请查看IDM下载窗口哦!')
							.animate({ opacity: '0.5' }, "slow")
							.show();
						clearInterval(temp.ins[index]);
						await base.sleep(2000);
						o.link.html(originalHtml).animate({ opacity: '1' }, "slow");
						temp.idm[index] = false;
						return;
					}
					let currentTime = Date.now();
					let elapsedTime = currentTime - startTime;
					let loaded = prog * size / 100;
					let timeDiff = Math.max(currentTime - prevTime, 1); // 避免除零
					let speed = ((loaded - prevLoaded) / (timeDiff / 1000)) || 0;
					// 计算剩余时间（保护除零）
					let totalProgress = Math.max(prog / 100, 0.01);
					let totalElapsedSeconds = elapsedTime / 1000;
					let estTotalTime = totalElapsedSeconds / totalProgress;
					let remainingTime = estTotalTime - totalElapsedSeconds;
					// 更新界面状态
					o.link.hide();
					o.directLink.hide();
					o.tip.hide();
					o.stop.show();
					o.copy.hide();
					o.progress.show();
					// 更新进度条
					$width.css('width', `${prog}%`);
					$text.text(`${prog.toFixed(2)}% | 速度:${base.sizeFormat(speed)} | 剩余:${base.rtimeFormat(remainingTime)}`);
					// 更新历史值
					prevLoaded = loaded;
					prevTime = currentTime;
					// 下载完成
					if (prog >= 100) {
						await base.sleep(1000);
						clearInterval(temp.ins[index]);
						temp.progress[index] = 0;
						o.item.find('.pl-progress-stop').hide();
						$text.text('下载完成~ 浏览器下载框应该弹出来了哦~');
						o.back.show();
						await base.sleep(3000);
						o.link.html(originalHtml).animate({ opacity: '1' }, "slow");
					}
				}, 500);
			});
			$doc.on('click', '.listener-aria2-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToAria2(target.data("link"), target.data("filename"), [`User-Agent:${config.$baidu.api.ua.downloadLink}`]);
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
			$doc.on('click', '.listener-bitcomet-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToBitcomet(target.data("link"), target.data("filename"), { "user_agent": config.$baidu.api.ua.downloadLink });
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
			$doc.on('click', '.listener-abdm-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToABDM(target.data("link"), target.data("filename"), { "User-Agent": config.$baidu.api.ua.downloadLink });
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
		},
		greenerPage() {
			temp.page = temp.main.detectPage();
			base.waitForKeyElements(".wp-s-header-user__vip-center", function (tag) {
				tag.remove();
			}, true);
			base.waitForKeyElements(".wp-s-header-user__create-team-content", function (tag) {
				tag.remove();
			}, true);
			base.waitForKeyElements(".app-user-vip-center-box.vip-center-type-2", function (tag) {
				tag.remove();
			}, true);
			base.waitForKeyElements(".wp-s-header__vip-btn-tip", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements(".app-user-vip-center-tip", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements("#web-header-text-s-45", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements(".wp-s-header__vip-btn", function (tag) {
				tag.text("会员中心")
			}, true);
			base.waitForKeyElements(".KQcHyA", function (tag) {
				tag.text("会员中心")
			}, true);
			base.waitForKeyElements(".gOIbzPb", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements(".wp-s-header-user__create-team-title", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements(".web-header-ad-item", function (tag) {
				tag.fadeOut();
			});
			base.waitForKeyElements(".wp-s-header__game-entry", function (tag) {
				tag.fadeOut();
			}, true)
			base.waitForKeyElements(".bd-aside-ad", function (tag) {
				tag.fadeOut();
			}, true)
			base.waitForKeyElements(".btn-img-tips", function (tag) {
				tag.fadeOut();
			}, true)
			base.waitForKeyElements(".nd-operate-guidance", function (tag) {
				tag.fadeOut();
			}, true)
			base.waitForKeyElements(".module-operation-content", function (tag) {
				tag.fadeOut();
				document.querySelector(".operate-guide-close").click();
				document.querySelector(".module-canvas").click();
			}, true)
			base.waitForKeyElements("[class*='module-'][class*='-box']:not(.module-box), [class*='module-'][class*='-mask']", function (tag) {
				tag.fadeOut();
				tag.find(".close-mask").click();
			}, true)
			base.waitForKeyElements(".newIcon", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements(".u-badge__content.is-dot", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements(".wp-side-options.g-clearfix", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements(".wp-s-header-user__drop-channel", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements(".app-download", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements('.g-button[title*="手机"]', function (tag) {
				tag.fadeOut();
			}, true)
			base.waitForKeyElements('.yike-entrance', function (tag) {
				tag.remove();
			}, true)
			base.waitForKeyElements("a.tools__item", function (tag) {
				if (tag.attr("linked")) return;
				if (tag.attr('href')) {
					try {
						let url = new URL(tag.closest('a').attr('href'));
						url.search = "";
						url.hash = url.hash.replace(/\?(.*?)(#|$)/, '$2')
						tag.attr('href', url.href)
					} catch (e) { }
				}
				tag.attr("linked", true)
			}, true);
			base.waitForKeyElements("p.wp-s-aside-nav__main-item-text", function (tag) {
				if (tag.attr("linked")) return;
				if (tag.closest('a').attr('href')) {
					try {
						let url = new URL(tag.closest('a').attr('href'));
						url.search = "";
						url.hash = url.hash.replace(/\?(.*?)(#|$)/, '$2')
						tag.closest('a').attr('href', url.href)
					} catch (e) { }
				}
				if (tag.is(":contains('插件'), :contains('相册'), :contains('笔记')") && tag.closest('a').attr('target') !== "_blank") {
					tag.closest('a').fadeOut();
				} else {
					tag.text(tag.text().replace("百度", ""));
				}
				tag.attr("linked", true)
			}, true);
			base.waitForKeyElements('dd[node-type="header-link"]', function (tag) {
				tag.children().each((index, element) => {
					let tag = $(element);
					if (!tag.attr("node-type")) return;
					let type = tag.attr("node-type");
					if (
						type !== "disk-home" &&
						type !== "mbox-homepage" &&
						type !== "find-apps"
					) {
						tag.fadeOut();
					}
				});
			}, true);
			base.waitForKeyElements(".__yunguanjia", function (tag) {
				tag.html(`<div class="yunguanjia-list __yunguanjia row g-clearfix _item sel">
					<span type="radio" class="radio-box _radioInput __yunguanjiaRadio">
						<span class="device-name">添加我的电脑</span>
					</span>
					<div class="__yunguanjiaTips radio-tips" style="display:block;">
						用电脑下载并登录最新百度网盘客户端，即自动完成添加。
						<a href="//pan.baidu.com/download" target="_blank">下载百度网盘客户端</a>
						<br/>由 <a href="https://github.com/hmjz100/LinkSwift/" target="_blank">LinkSwift</a> 修复该选项
					</div>
				</div>`);
			}, true)
			// 美化分享页面
			if (temp.page === 'share') {
				base.waitForKeyElements(`iframe[src^="/buy/ad"]`, function (tag) {
					tag.fadeOut();
				}, true)
				base.addStyle(`${mount}-baiduShare`, 'style', `
					body, .theme-white.init-new, #layoutApp{
						background-color:#DCEFFE!important;
						background:#DCEFFE url(https://nd-static.bdstatic.com/m-static/disk-share/widget/pageModule/init-new/image/init-bg_1708266.png) no-repeat center center;
					}
					#bd-main .bd-left{
						background:#ffffffC0;
						border-radius:10px;
					}
					iframe[src="/buy/ad/home"]{
						display:none!important;
					}
				`, `.${mount}`);
				base.waitForKeyElements(`.KPDwCE`, function (tag) {
					tag.css('background', 'transparent');
				}, true);
				base.waitForKeyElements('.share-list .KPDwCE .AuPKyz', function (tag) {
					tag.css('background', 'transparent');
				}, true);
				base.waitForKeyElements(`#layoutMain`, function (tag) {
					tag.css({ "border-radius": "24px" });
				}, true)
				base.waitForKeyElements(".frame-content", function (tag) {
					tag.css({ "margin": "auto" });
				}, true)
			}
		},
		beautifyPage() {
			if (base.getValue('setting_ui_theme').custom.$baidu !== true) return;
			if (temp.main.detectPage() !== 'home') {
				base.adaptiveThemeOverride([
					['#717fff', temp.color],
					['#717FFF', temp.color],
					['#06a8ff', temp.color],
					['#06A8FF', temp.color],
					['#06a7ff', temp.color],
					['#06A7FF', temp.color],
					['#dcdfe6', temp.color],
					['#DCDFE6', temp.color],
					['#0095ff', temp.color],
					['#0095FF', temp.color],
					['#09aaff', temp.color],
					['#09AAFF', temp.color],
					['#0ca6ff', temp.color],
					['#0CA6FF', temp.color],
					['#5040ff', temp.color],
					['#5040FF', temp.color],
					['#454d5a', temp.color],
					['#454D5A', temp.color],
					['#a2abbd', temp.color],
					['#A2ABBD', temp.color],
					['#030b1a', temp.color],
					['#030B1A', temp.color],
					['#afb3bf', temp.color],
					['#AFB3BF', temp.color],
					['#ff436a', temp.color],
					['#FF436A', temp.color],
					['#03081a', temp.color],
					['#03081A', temp.color],
					['#2974b6', temp.color],
					['#2974B6', temp.color],
					['#0596e6', temp.color],
					['#0596E6', temp.color],
					['#C3EAFF', temp.color],
					['#c0d9fe', `${temp.color}50`],
					['#0098EA', `${temp.color}D0`],
					['#38b9ff', `${temp.color}D0`],
					['#38B9FF', `${temp.color}D0`],
					['#42d8ff', `${temp.color}D0`],
					['#42D8FF', `${temp.color}D0`],
					['#a48dff', `${temp.color}D0`],
					['#A48DFF', `${temp.color}D0`],
					['#6b79f2', `${temp.color}D0`],
					['#6B79F2', `${temp.color}D0`],
					['#9c86f2', `${temp.color}90`],
					['#9C86F2', `${temp.color}90`],
					['#83d3ff', `${temp.color}90`],
					['#83D3FF', `${temp.color}90`],
					['#C4D8F4', `${temp.color}90`],
					['#fafafc', `${temp.color}20`],
					['#FAFAFC', `${temp.color}20`],
					['#f5fbff', `${temp.color}20`],
					['#F5FBFF', `${temp.color}20`],
					['#b4e5ff', `${temp.color}20`],
					['#B4E5FF', `${temp.color}20`],
					['#f0faff', `${temp.color}20`],
					['#F0FAFF', `${temp.color}20`],
					['#c4d8f4', `${temp.color}20`],
					['#f1f3f8', `${temp.color}15`],
					['#F1F3F8', `${temp.color}15`],
					['#f2faff', `${temp.color}10`],
					['#F2FAFF', `${temp.color}10`],
					['#eef9fe', `${temp.color}10`],
					['#EEF9FE', `${temp.color}10`],
					['#f7f9fc', `${temp.color}10`],
					['#F7F9FC', `${temp.color}10`],
					['#f5f6fa', `${temp.color}10`],
					['#F5F6FA', `${temp.color}10`],
					['#b4e5ff', `${temp.color}10`],
					['#B4E5FF', `${temp.color}10`],
					['#e6f6ff', `${temp.color}10`],
					['#E6F6FF', `${temp.color}10`],
					['0,149,255', base.hexToRgba(temp.color)],
					['30, 175, 255', base.hexToRgba(temp.color)],
					['6, 167, 255, 0.1', base.hexToRgba(`${temp.color}1a`)],
					['6,167,255,.1', base.hexToRgba(`${temp.color}1a`)],
					['6,167,255,.23', base.hexToRgba(`${temp.color}3b`)],
					['164,141,255,.2', base.hexToRgba(`${temp.color}30`)],
					['196,182,255,.2', base.hexToRgba(`${temp.color}20`)],
					['113,127,255,.2', base.hexToRgba(`${temp.color}40`)],
					['3,8,26,.6', base.hexToRgba(`${temp.color}D0`)],
					['255,32,102,.4', base.hexToRgba(`${temp.color}66`)],
					['72,166,248,.7', base.hexToRgba(`${temp.color}66`)],
				]);
			};
			base.addStyle(`${mount}-baidu`, 'style', `
				#layoutMain,.DxdbeCb{border-radius:10px;border-bottom-left-radius:0;border-bottom-right-radius:0;background:#ffffffA0!important}
				.KPDwCE,
				.DxdbeCb .OFaPaO .tanwePYr,
				.xGLMIab .fufHyA:hover,
				.module-search-timeline .form-box
				{background:#ffffffA0!important}
				.KPDwCE .JDeHdxb,
				.NHcGw .AuPKyz,
				.xGLMIab .tvPMvPb,
				.xGLMIab .FcQMwt,
				.cazEfA .yfHIsP,
				.hscjZ4QL .bbxnZ0Bq .ehnyLxWZ span,
				.module-topToolBar,
				.module-timeline-view .timeline-title-curday
				{background:transparent!important;border-bottom:0}
				.MdLxwM{background :#fff!important}
				.aside-absolute-container{position:absolute!important}
				.aside-absolute-container .QGOvsxb .remainingSpaceUi_span{background:#8af248!important;border-radius:10px 0 0 10px;border-right:#fff 1px solid;border-bottom:#fff 1px solid}
				.xtJbHcb .CDaavKb .KQcHyA{background:rgb(244,207,0)!important;padding:8px 15px}
				.xtJbHcb .web-header-nav-new-version-inner{background:${temp.color}!important;padding:8px 15px;line-height:15px;width:auto;height:auto}
				a{transition:all.2s!important}
				#bd-main .bd-left{margin:auto!important}
				.verify-input input{padding-left:0!important;text-align:center!important}
				.verify-input input:focus{border:2px solid ${temp.color}!important}
				[data-theme=light] .vp-video-page-card .vp-video-page-card__video-detail{color:#030b1a}
				dt.level-1{background:#fd6d65!important}
				dt.level-2{background:#f3a723!important}
				dt.level-1 i.desc-arrow{border-bottom:10px solid #dd6966!important}
				dt.level-2 i.desc-arrow{border-bottom:10px solid #d29633!important}
				`, `.${mount}`);
			base.adaptiveThemeOverride([
				['#717fff', temp.color],
				['#717FFF', temp.color],
				['#06a8ff', temp.color],
				['#06A8FF', temp.color],
				['#06a7ff', temp.color],
				['#06A7FF', temp.color],
				['#dcdfe6', temp.color],
				['#DCDFE6', temp.color],
				['#0095ff', temp.color],
				['#0095FF', temp.color],
				['#09aaff', temp.color],
				['#09AAFF', temp.color],
				['#0ca6ff', temp.color],
				['#0CA6FF', temp.color],
				['#5040ff', temp.color],
				['#5040FF', temp.color],
				['#454d5a', temp.color],
				['#454D5A', temp.color],
				['#a2abbd', temp.color],
				['#A2ABBD', temp.color],
				['#030b1a', temp.color],
				['#030B1A', temp.color],
				['#afb3bf', temp.color],
				['#AFB3BF', temp.color],
				['#ff436a', temp.color],
				['#FF436A', temp.color],
				['#03081a', temp.color],
				['#03081A', temp.color],
				['#2974b6', temp.color],
				['#2974B6', temp.color],
				['#0596e6', temp.color],
				['#0596E6', temp.color],
				['#C3EAFF', temp.color],
				['#c0d9fe', `${temp.color}50`],
				['#0098EA', `${temp.color}D0`],
				['#38b9ff', `${temp.color}D0`],
				['#38B9FF', `${temp.color}D0`],
				['#42d8ff', `${temp.color}D0`],
				['#42D8FF', `${temp.color}D0`],
				['#a48dff', `${temp.color}D0`],
				['#A48DFF', `${temp.color}D0`],
				['#6b79f2', `${temp.color}D0`],
				['#6B79F2', `${temp.color}D0`],
				['#9c86f2', `${temp.color}90`],
				['#9C86F2', `${temp.color}90`],
				['#83d3ff', `${temp.color}90`],
				['#83D3FF', `${temp.color}90`],
				['#C4D8F4', `${temp.color}90`],
				['#fafafc', `${temp.color}20`],
				['#FAFAFC', `${temp.color}20`],
				['#f5fbff', `${temp.color}20`],
				['#F5FBFF', `${temp.color}20`],
				['#b4e5ff', `${temp.color}20`],
				['#B4E5FF', `${temp.color}20`],
				['#f0faff', `${temp.color}20`],
				['#F0FAFF', `${temp.color}20`],
				['#c4d8f4', `${temp.color}20`],
				['#f1f3f8', `${temp.color}15`],
				['#F1F3F8', `${temp.color}15`],
				['#f2faff', `${temp.color}10`],
				['#F2FAFF', `${temp.color}10`],
				['#eef9fe', `${temp.color}10`],
				['#EEF9FE', `${temp.color}10`],
				['#f7f9fc', `${temp.color}10`],
				['#F7F9FC', `${temp.color}10`],
				['#f5f6fa', `${temp.color}10`],
				['#F5F6FA', `${temp.color}10`],
				['#b4e5ff', `${temp.color}10`],
				['#B4E5FF', `${temp.color}10`],
				['#e6f6ff', `${temp.color}10`],
				['#E6F6FF', `${temp.color}10`],
				['0,149,255', base.hexToRgba(temp.color)],
				['30, 175, 255', base.hexToRgba(temp.color)],
				['6, 167, 255, 0.1', base.hexToRgba(`${temp.color}1a`)],
				['6,167,255,.1', base.hexToRgba(`${temp.color}1a`)],
				['6,167,255,.23', base.hexToRgba(`${temp.color}3b`)],
				['164,141,255,.2', base.hexToRgba(`${temp.color}30`)],
				['196,182,255,.2', base.hexToRgba(`${temp.color}20`)],
				['113,127,255,.2', base.hexToRgba(`${temp.color}40`)],
				['3,8,26,.6', base.hexToRgba(`${temp.color}D0`)],
				['255,32,102,.4', base.hexToRgba(`${temp.color}66`)],
				['72,166,248,.7', base.hexToRgba(`${temp.color}66`)],
			], "other");
		},
		addButton() {
			base.waitForKeyElements(config.$baidu.mount.home, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'home') return;
				let $button = $(`<div class="g-dropdown-button pl-button">
					<div class="g-button g-button-blue color-button"><span class="g-button-right"><em class="icon icon-download" style="color:#fff;"></em><span class="text" style="width:60px;">下载助手</span></span></div>
					<div class="menu" style="color:${temp.color};border-color:${temp.color};width:auto;z-index:41;">
						<div class="g-button-menu pl-button-mode" data-mode="api"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-downward"/></svg> API 下载</div>
						<div class="g-button-menu pl-button-mode" data-mode="curl"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-plug"/></svg> cURL 下载</div>
						<div class="g-button-menu pl-button-mode" data-mode="aria2"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg> Aria2 下载</div>
						<div class="g-button-menu pl-button-mode" data-mode="bitcomet"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg> 彗星下载</div>
						<div class="g-button-menu pl-button-mode" data-mode="abdm"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg> ABDM 下载</div>
						<div class="g-button-menu pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg> 助手设置</div>
						<div class="g-button-menu pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg> 助手美化</div>
						<div class="g-button-menu pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg> 更新日志</div>
					</div>
				</div>`);
				element.prepend($button);
			})
			base.waitForKeyElements(config.$baidu.mount.main, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'main') return;
				let $button = $(`<div class="wp-s-agile-tool-bar__h-group pl-button">
					<div class="wp-s-agile-tool-bar__h-action is-need-left-sep is-main color-button">
						<button type="button" class="u-button nd-file-list-toolbar-action-item u-button--primary u-button--small is-round is-has-icon pl-button color-button">
							<i class="u-icon u-icon-download"></i>
							<span>下载助手</span>
						</button>
						<ul class="dropdown-list nd-common-float-menu pl-dropdown-menu">
							<li class="sub cursor-p pl-button-mode" data-mode="api"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-downward"/></svg>API 下载</li>
							<li class="sub cursor-p pl-button-mode" data-mode="curl"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-plug"/></svg>cURL 下载</li>
							<li class="sub cursor-p pl-button-mode" data-mode="aria2"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>Aria2 下载</li>
							<li class="sub cursor-p pl-button-mode" data-mode="bitcomet"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>彗星下载</li>
							<li class="sub cursor-p pl-button-mode" data-mode="abdm"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>ABDM 下载</li>
							<li class="sub cursor-p pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>助手设置</li>
							<li class="sub cursor-p pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg>助手美化</li>
							<li class="sub cursor-p pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg>更新日志</li>
						</ul>
					</div>
				</div>`);
				element.prepend($button);
			})
			base.waitForKeyElements(config.$baidu.mount.main, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'youth') return;
				let $button = $(`<div class="wp-s-agile-tool-bar__h-group pl-button">
					<div class="wp-s-agile-tool-bar__h-action is-need-left-sep is-main color-button">
						<button type="button" class="u-button nd-file-list-toolbar-action-item u-button--primary u-button--small is-round is-has-icon pl-button color-button" style="font-size:14px;font-weight:700">
							<i class="u-icon u-icon-more"></i>
							<span>网盘助手</span>
						</button>
						<ul class="dropdown-list nd-common-float-menu pl-dropdown-menu">
							<li class="sub cursor-p pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>助手设置</li>
							<li class="sub cursor-p pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg>助手美化</li>
							<li class="sub cursor-p pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg>更新日志</li>
						</ul>
					</div>
				</div>`);
				element.prepend($button);
			})
			base.waitForKeyElements(config.$baidu.mount.share, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'share') return;
				let $button = $(`<a class="g-button tools-share-V20-btn save_btn pl-button color-button" style="padding:0;">
					<span class="g-button-right" style="padding-left:10px">
						<em class="icon icon-download" style="color:#fff;line-height:27px"></em>
						<span class="text" style="width:auto;">下载助手</span>
					</span>
					<ul class="dropdown-list nd-common-float-menu pl-dropdown-menu" style="top:37px">
						<li class="sub cursor-p pl-button-mode pl-button-save"><em class="icon noicon-zhuancun_bai"></em>保存后下载</li>
						<li class="sub cursor-p pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>助手设置</li>
						<li class="sub cursor-p pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg>助手美化</li>
						<li class="sub cursor-p pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg>更新日志</li>
					</ul>
				</a>`)
				element.after($button);
			})
		},
		addInitButton() {
			base.waitForKeyElements(config.$baidu.mount.home, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || temp.page !== 'home') return;
				let $button = $(`<div class="g-dropdown-button pl-button-init" style="opacity:0.5"><div style="color:#fff;" class="g-button g-button-blue color-button"><span class="g-button-right"><em class="icon icon-download" style="color:#fff;"></em><span class="text" style="width:60px;">点我点亮</span></span></div></div>`);
				$button.click(base.showInitDialog);
				element.prepend($button);
			})
			base.waitForKeyElements(config.$baidu.mount.main, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || (temp.page !== 'main' && temp.page !== 'youth')) return;
				let $button = $(`<div class="wp-s-agile-tool-bar__h-group pl-button-init">
					<div class="wp-s-agile-tool-bar__h-action is-need-left-sep is-main color-button">
						<button type="button" class="u-button nd-file-list-toolbar-action-item u-button--primary u-button--small is-round is-has-icon pl-button color-button" style="font-size:14px;font-weight:700">
							<i class="u-icon u-icon-download"></i>
							<span>点我点亮</span>
						</button>
					</div>
				</div>`);
				$button.click(base.showInitDialog);
				element.prepend($button);
			})
			base.waitForKeyElements(config.$baidu.mount.share, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || temp.page !== 'share') return;
				let $button = $(`<a class="g-button tools-share-V20-btn save_btn pl-button-init color-button" href="javascript:;">
					<span class="g-button-right">
						<em class="icon icon-download" style="color:#fff;line-height:27px"></em>
						<span class="text" style="width:auto;">点我点亮</span>
					</span>
				</a>`)
				$button.click(base.showInitDialog);
				element.after($button);
			})
		},
		async getLink() {
			Swal.fire({
				...temp.swalDefault,
				showConfirmButton: false,
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: false,
				title: "获取中",
				html: `...`,
				footer: "如果选的文件较多，请耐心等待获取完成哦！",
				customClass: {
					popup: 'loading-popup',
					header: 'loading-header',
					title: 'loading-title',
					content: 'loading-content',
					input: 'loading-input',
					footer: 'loading-footer'
				},
				willOpen: () => {
					Swal.showLoading();
				},
			});
			// 获取选择的文件列表
			let selectList = this.getSelectedList();
			let accessToken = (base.getValue('baidu_access_token') || await temp.main.getToken());
			if (!accessToken) {
				message.info('提示：<br/>稍后请在新标签页中授权助手哦~');
				base.delValue('baidu_access_token');
				await base.sleep(3300);
				GM_openInTab(config.$baidu.api.getAccessToken, { active: true, insert: true, setParent: true })
				let attempts = 0;
				let interval = setInterval(() => {
					if (!!base.getValue('baidu_access_token')) {
						clearInterval(interval);
						accessToken = base.getValue('baidu_access_token')
					}
					attempts++;
					if (attempts > 120) {
						clearInterval(interval);
						return message.error('提示：<br/>时间太长，我先撤下啦~');
					}
				}, 1000);
				return;
			}
			if (selectList.length === 0) return message.error('提示：<br/>请勾选要下载的文件哦~');
			if (temp.page === 'home' || temp.page === 'main') {
				let cnt = 0;
				let processed = selectList.filter(f => !f.isdir).length;
				async function fetchFiles(dirs) {
					let files = [];
					for (let dir of dirs) {
						$doc.find('.loading-popup .loading-title').html(`文件获取中`);
						let url = `${config.$baidu.api.getFiles}&dir=${encodeURIComponent(dir.path)}&access_token=${accessToken}`;
						let res = await base.get(url, { "User-Agent": config.$baidu.api.ua.downloadLink });
						cnt++;
						if (res?.list?.length && (res.errno === 0 || res.errmsg === "succ")) {
							let subFiles = res.list.filter(f => !f.isdir);
							processed += subFiles.length;
							$doc.find('.loading-popup .swal2-html-container').html(`<div>已获取 ${processed} 个文件~</div><div>${dir.path}</div>`);
							files = files.concat(subFiles);
							if (res.list.some(f => f.isdir)) {
								files = files.concat(await fetchFiles(res.list.filter(f => f.isdir)));
							}
						}
						if (cnt >= 50) {
							$doc.find('.loading-popup .swal2-html-container').html(`<div>已获取 ${processed} 个文件~</div><div>休息 3 秒...</div>`);
							await base.sleep(3000);
							cnt = 0;
						}
					}
					return files;
				}
				let files = selectList.filter(f => !f.isdir);
				if (selectList.some(f => f.isdir)) {
					files = files.concat(await fetchFiles(selectList.filter(f => f.isdir)));
				}
				if (!files.length) {
					return message.error('提示：<br/>文件夹是空的哦~');
				}
				$doc.find('.loading-popup .loading-title').html(`链接获取中`);
				$doc.find('.loading-popup .swal2-html-container').html(`<div>正在获取文件对应的下载链接~</div>`);
				let fidList = files.map(f => f.fs_id);
				let batchSize = 100;
				let linkList = [];
				for (let i = 0; i < fidList.length; i += batchSize) {
					let url = `${config.$baidu.api.getLink}&fsids=${encodeURIComponent(JSON.stringify(fidList.slice(i, i + batchSize)))}&access_token=${accessToken}`;
					let res = await base.get(url, { "User-Agent": config.$baidu.api.ua.downloadLink });
					if (res.list && res.list.length !== 0 && res.errno === 0) {
						linkList = linkList.concat(res.list);
						$doc.find('.loading-popup .swal2-html-container').html(`<div>已获取 ${linkList.length} / ${fidList.length} 个链接~</div>`);
					} else {
						if (res.errno) {
							if (res.errno === 112) {
								return message.error('提示：<br/>页面过期了，刷新重试下吧~<br/>代码：' + res.errno);
							}
							if (res.errno === 9019) {
								base.delValue('baidu_access_token');
								return message.error('提示：<br/>访问令牌已过期，刷新网页后再获取一次吧~<br/>代码：' + res.errno);
							}
							base.delValue('baidu_access_token');
							return message.error('提示：<br/>获取下载链接失败，刷新网页后再试试吧~<br/>代码：' + res.errno);
						} else {
							return message.error('提示：<br/>获取下载链接失败，刷新网页后再试试吧~');
						}
					}
					await base.sleep(1000);
				}
				if (linkList.length) {
					temp.links = [linkList, {
						isFolder: v => v.isdir === 1,
						getFileName: v => (v.server_filename || v.filename),
						getFileSize: v => v.size,
						getFileLink: v => {
							let url = new URL(v.dlink);
							url.searchParams.set("access_token", accessToken);
							return url.href;
						},
						convert: {
							aria2: `--header "User-Agent:${config.$baidu.api.ua.downloadLink}"`,
							curl: `-A "${config.$baidu.api.ua.downloadLink}"`,
							bitcomet: `user_agent=${encodeURIComponent(config.$baidu.api.ua.downloadLink)}`
						},
						tooltip: config.$baidu.dom
					}];
					base.showMainDialog(config.base.dom.button[temp.mode].title, base.generateDom(temp.links), config.base.dom.button[temp.mode].footer);
				} else {
					return message.error('提示：<br/>获取下载链接失败，刷新网页后再试试吧~');
				}
			} else {
				return message.error('提示：<br/>页面错误~');
			}
		},
		getSelectedList() {
			let List, selectList
			try {
				List = require("system-core:context/context.js").instanceForSystem.list;
				selectList = List.getSelected();
				return selectList;
			} catch (e) { }
			try {
				List = unsafeWindow.document.querySelector('.wp-s-core-pan');
				if (List && List.__vue__.selectedList) {
					selectList = List.__vue__.selectedList;
					return selectList;
				}
			} catch (e) { }
			try {
				List = unsafeWindow.document.querySelector('.file-list');
				if (List && List.__vue__.allFileList) {
					selectList = List.__vue__.allFileList.filter(function (item) { return !!item.selected; });
					return selectList;
				}
			} catch (e) { }
		},
		detectPage() {
			let path = location.pathname;
			if (/^\/disk\/home/.test(path)) return 'home';
			if (/^\/disk\/main/.test(path)) return 'main';
			if (/^\/youth\/pan\/main/.test(path)) return 'youth';
			if (/^\/(s|share)\//.test(path)) return 'share';
			return "";
		},
		async initPanLinker() {
			base.registerMenuCommand();
			if (config.base.num === base.getValue('setting_init').code || config.base.license === base.getValue('setting_init').license) {
				this.addButton();
			} else {
				this.addInitButton();
			}
			this.addPageListener();
		},
	};
	let $baiduAuthorize = {
		async initPanLinker() {
			base.registerMenuCommand();
			Swal.fire({
				...temp.swalDefault,
				showConfirmButton: false,
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: false,
				html: `请稍后`,
				willOpen: () => {
					Swal.showLoading();
				},
			});
			if (config.base.num === base.getValue('setting_init').code || config.base.license === base.getValue('setting_init').license) {
				let url = new URL(location);
				let auth = new URL(config.$baidu.api.getAccessToken);
				let allowedClientIds = [
					auth.searchParams.get("client_id"),
					'L6g70tBRRIXLsY0Z3HwKqlRE', // pcstest_oauth
					'fSds3K4w43rw37tOqlQmTa2kDwaczK4U', // 小度智能词典笔专业版
					'TFwtw8uwHxpdkvVqVKdIlx1XqXUnr1zG', // 印象笔记
					'9dgBV9yesuBVOXaxls7aVHbLBLqU8yyg', // WPS文档
					'l9DdBOG4RYroMscmzK5OChdaGelgd92M', // 小猴云印PC版
					'Kyr013gHQBf2immy3fQt1jZ3nZVpiGAm', // 简单打印
					'iYCeC9g08h5vuP9UqvPHKKSVrKFXGa1v', // Alist
					'omiOnr2tYnN9vSyDErcVFWpPU2mZA7YO', // OpenList
					'QHOuRXiepJBMjtk0esLhrPoNlQyYd0mF', // mcp_server
					'IlLqBbU3GjQ0t46TRwFateTprHWl39zF',  // 百度手机助手
				];
				if (
					/openapi.baidu.com\/oauth\/2.0\/authorize/.test(location.href) &&
					url.searchParams.get("response_type").includes("token") &&
					url.searchParams.get("scope").includes("netdisk") &&
					allowedClientIds.includes(url.searchParams.get("client_id"))
				) {
					let dialog = await Swal.fire({
						...temp.swalDefault,
						icon: 'info',
						title: `提示`,
						html: `<p>(◍•ᴗ•◍) 你好呀，为了获取百度网盘文件的下载直链<br/>“下载助手” 需要你的授权，以获取网盘文件的访问令牌</p><br/>
						<p>由于在百度 OAuth 页面使用了其他应用的 Client ID<br/>所以显示的应用名称可能会有所不同，敬请理解</p><br/>
						<p>获取到的令牌仅用于调用百度网盘 API 生成直链<br/>不会用于其他用途，请放心授权</p>`,
						showConfirmButton: true,
						showDenyButton: true,
						allowOutsideClick: false,
						allowEscapeKey: false,
						allowEnterKey: false,
						confirmButtonText: '<svg class="pl-icon"><use xlink:href="#pl-icon-fa-check"/></svg> 授权',
						denyButtonText: '<svg class="pl-icon"><use xlink:href="#pl-icon-fa-x-mark"/></svg> 再想想',
						position: 'center'
					});
					if (dialog.isConfirmed) {
						base.waitForKeyElements("button#auth-allow", function (element) {
							element[0].click();
						}, true)
						return;
					}
					if (dialog.isDenied) {
						return await Swal.fire({
							...temp.swalDefault,
							icon: 'question',
							title: `好吧(*￣3￣)╭`,
							html: '那就再想一想<br/>想好了就按下 “授权” 按钮吧~',
							timer: 180000,
							toast: true,
							timerProgressBar: true,
							showConfirmButton: false,
							showDenyButton: false,
							position: 'bottom-end',
						})
					}
				} else if (/openapi.baidu.com\/oauth\/2.0\/login_success/.test(location.href)) {
					let int = setInterval(async () => {
						if (location.href.includes('access_token') && (location.href.includes('basic+netdisk') || location.href.includes('basic,netdisk'))) {
							clearInterval(int)
							let token = location.href.match(/access_token=(.*?)&/)[1];
							base.setValue('baidu_access_token', token);
							await Swal.fire({
								...temp.swalDefault,
								icon: 'success',
								title: `成功啦`,
								html: '<p>(◍•ᴗ•◍) 您已<b>成功授权/授权过</b>脚本获取网盘访问令牌~</p><p>获取到的令牌<b>仅用于调用百度网盘 API 生成直链</b><br/>不会用于其他用途</p><p>等待 <span id="second">/</span> 秒之后将关闭此页面</p>',
								timer: 5000,
								timerProgressBar: true,
								showConfirmButton: true,
								showDenyButton: false,
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false,
								confirmButtonText: `<svg class="pl-icon"><use xlink:href="#pl-icon-fa-x-mark"/></svg> 关闭`,
								willOpen: () => {
									let secondSpan = document.getElementById("second");
									let interval = setInterval(() => {
										if (Swal.isVisible()) {
											let timeLeft = Swal.getTimerLeft();
											if (timeLeft !== null && timeLeft > 0) {
												secondSpan.textContent = (timeLeft / 1000).toFixed(2);
											}
										} else {
											clearInterval(interval);
										}
									}, 10);
								},
								didOpen: function (toast) {
									toast.addEventListener('mouseenter', () => {
										Swal.stopTimer();
									});
									toast.addEventListener('mouseleave', () => {
										Swal.resumeTimer();
									});
								},
								willClose: () => window.close()
							});
							return window.close();
						} else {
							clearInterval(int)
							Swal.close()
						}
					}, 1)
				} else {
					Swal.close()
				}
			} else {
				Swal.close()
			}
		}
	}
	/**
	 * 阿里云盘
	 * @author 油小猴
	 * @author hmjz100
	 */
	let $aliyun = {
		addPageListener() {
			$doc.on('click', '.pl-button-save', async function (e) {
				e.preventDefault();
				let reactDomGrid = document.querySelector(config.$aliyun.mount.grid);
				if (reactDomGrid) {
					let dialog = await Swal.fire({
						...temp.swalDefault,
						title: '提示',
						html: '<div style="display:flex;align-items:center;justify-content:center;">请先切换到&nbsp;&nbsp;<svg class="icon" class="icon--D3kMk " viewBox="0 0 1024 1024" width="20" height="20" fill="currentColor"><use xlink:href="#PDSDrag"></use></svg>&nbsp;<b>列表视图</b>&nbsp;&nbsp;后再获取下载链接哦</div>',
						icon: 'info',
						showCloseButton: true,
						showDenyButton: true,
						confirmButtonText: '<svg class="pl-icon"><use xlink:href="#pl-icon-fa-check"/></svg> 切换',
						denyButtonText: '<svg class="pl-icon"><use xlink:href="#pl-icon-fa-x-mark"/></svg> 不要',
					});
					if (dialog.isConfirmed) {
						document.querySelector(config.$aliyun.mount.switch).click();
						return message.success('提示：<br/>切换为列表视图成功<br/>请再获取一次下载链接吧~');
					}
					return false;
				}
				let selectList = temp.main.getSelectedList();
				if (selectList.length === 0) {
					return message.error('提示：<br/>请勾选要保存到网盘的文件哦~');
				}
				message.info('提示：<br/>因网盘限制，请保存到自己网盘后再去下载哦~');
				await base.sleep(500);
				document.querySelector('[class*="btn-save--"]').click();
			});
			$doc.on('click', '.pl-button-mode', async function (e) {
				temp.mode = e.currentTarget.dataset.mode;
				if (!temp.mode) return;
				let reactDomGrid = document.querySelector(config.$aliyun.mount.grid);
				if (reactDomGrid) {
					let dialog = await Swal.fire({
						...temp.swalDefault,
						title: '提示',
						html: '<div style="display:flex;align-items:center;justify-content:center;">请先切换到&nbsp;&nbsp;<svg class="icon" class="icon--D3kMk " viewBox="0 0 1024 1024" width="20" height="20" fill="currentColor"><use xlink:href="#PDSDrag"></use></svg>&nbsp;<b>列表视图</b>&nbsp;&nbsp;后再获取下载链接哦</div>',
						icon: 'info',
						showCloseButton: true,
						showDenyButton: true,
						confirmButtonText: '<svg class="pl-icon"><use xlink:href="#pl-icon-fa-check"/></svg> 切换',
						denyButtonText: '<svg class="pl-icon"><use xlink:href="#pl-icon-fa-x-mark"/></svg> 不要',
					});
					if (dialog.isConfirmed) {
						document.querySelector(config.$aliyun.mount.switch).click();
						return message.success('提示：<br/>切换为列表视图成功<br/>请再获取一次下载链接吧~');
					}
					return false;
				}
				temp.main.getLink();
			});
			$doc.on('click', '.listener-api-download.enhance', async function (e) {
				e.preventDefault();
				let o = base._EventFactory(e);
				let $width = o.item.find('.pl-progress-inner');
				let $text = o.item.find('.pl-progress-inner-text');
				let filename = o.link[0].dataset.filename;
				let index = o.link[0].dataset.index;
				let size = Number(o.link[0].dataset.size) || 0;
				let originalHtml = o.link.html();
				base._resetData(index);
				base.get(e.currentTarget.dataset.link, undefined, 'blob', { filename, index });
				let startTime = Date.now();
				let prevLoaded = 0;
				let prevTime = startTime;
				temp.ins[index] = setInterval(async () => {
					let prog = +temp.progress[index] || 0;
					let currentTime = Date.now();
					let elapsedTime = currentTime - startTime;
					let loaded = prog * size / 100;
					let timeDiff = Math.max(currentTime - prevTime, 1); // 避免除零
					let speed = ((loaded - prevLoaded) / (timeDiff / 1000)) || 0;
					// 计算剩余时间（保护除零）
					let totalProgress = Math.max(prog / 100, 0.01);
					let totalElapsedSeconds = elapsedTime / 1000;
					let estTotalTime = totalElapsedSeconds / totalProgress;
					let remainingTime = estTotalTime - totalElapsedSeconds;
					// 更新界面状态
					o.link.hide();
					o.directLink.hide();
					o.tip.hide();
					o.stop.show();
					o.copy.hide();
					o.progress.show();
					// 更新进度条
					$width.css('width', `${prog}%`);
					$text.text(`${prog.toFixed(2)}% | 速度:${base.sizeFormat(speed)} | 剩余:${base.rtimeFormat(remainingTime)}`);
					// 更新历史值
					prevLoaded = loaded;
					prevTime = currentTime;
					// 下载完成
					if (prog >= 100) {
						await base.sleep(1000);
						clearInterval(temp.ins[index]);
						temp.progress[index] = 0;
						o.item.find('.pl-progress-stop').hide();
						$text.text('下载完成~ 浏览器下载框应该弹出来了哦~');
						o.back.show();
						await base.sleep(3000);
						o.link.html(originalHtml).animate({ opacity: '1' }, "slow");
					}
				}, 500);
			});
			$doc.on('click', '.listener-aria2-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToAria2(target.data("link"), target.data("filename"), [`Referer:https://${location.host}/`]);
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
			$doc.on('click', '.listener-bitcomet-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToBitcomet(target.data("link"), target.data("filename"), { "referrer": `https://${location.host}/` });
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
			$doc.on('click', '.listener-abdm-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToABDM(target.data("link"), target.data("filename"), undefined);
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
		},
		greenerPage() {
			base.waitForKeyElements('[class*="share-list-banner"]', function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements('[class*="to-app"]', function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements('[class*="btn-mobile-save"]', function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements('[class*="SplashScreenImg--close"]', function (tag) {
				tag[0].click();
			}, true);
			base.waitForKeyElements('[class*="container"]', function (tag) {
				tag.find('[class^="icon-close"]').click();
			}, true);
			base.waitForKeyElements('[class*="popup_main_close"]', function (tag) {
				tag[0].click();
			}, true);
		},
		beautifyPage() {
			if (base.getValue('setting_ui_theme').custom.$aliyun !== true) return;
			base.adaptiveThemeOverride([
				['#3763ff', temp.color],
				['#8664ff', `${temp.color}D0`],
				['99, 125, 255', base.hexToRgba(temp.color)],
				['132, 133, 141', base.hexToRgba(temp.color)],
				['112, 136, 255', base.hexToRgba(temp.color)],
				['97, 122, 250', base.hexToRgba(temp.color)],
				['68, 109, 255', base.hexToRgba(temp.color)],
				['82, 110, 250', base.hexToRgba(`${temp.color}20`)],
				['122, 144, 255', base.hexToRgba(`${temp.color}D0`)],
				['138, 157, 255', base.hexToRgba(`${temp.color}D0`)],
			]);
		},
		svg: `<svg class="ali-btn-icon" style="margin-right:3px;" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path d="M853.333 938.667H170.667a85.333 85.333 0 0 1-85.334-85.334v-384A85.333 85.333 0 0 1 170.667 384H288a32 32 0 0 1 0 64H170.667a21.333 21.333 0 0 0-21.334 21.333v384a21.333 21.333 0 0 0 21.334 21.334h682.666a21.333 21.333 0 0 0 21.334-21.334v-384A21.333 21.333 0 0 0 853.333 448H736a32 32 0 0 1 0-64h117.333a85.333 85.333 0 0 1 85.334 85.333v384a85.333 85.333 0 0 1-85.334 85.334z" fill="#FFFFFF"></path><path d="M715.03 543.552a32.81 32.81 0 0 0-46.251 0L554.005 657.813v-540.48a32 32 0 0 0-64 0v539.734L375.893 543.488a32.79 32.79 0 0 0-46.229 0 32.427 32.427 0 0 0 0 46.037l169.557 168.811a32.81 32.81 0 0 0 46.251 0l169.557-168.81a32.47 32.47 0 0 0 0-45.974z" fill="#FFFFFF"></path></svg>`,
		addButton() {
			base.waitForKeyElements(config.$aliyun.mount.home, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'home') return;
				let $button = $(`<div class="ali-button pl-button">
					<span data-role="icon" data-render-as="svg" class="icon">${temp.main.svg}下载助手</span>
					<ul class="pl-dropdown-menu" style="top:30px; right:0;">
						<li class="pl-button-mode" data-mode="api"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-downward"/></svg>API 下载</li>
						<li class="pl-button-mode" data-mode="curl"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-plug"/></svg>cURL 下载</li>
						<li class="pl-button-mode" data-mode="aria2"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>Aria2 下载</li>
						<li class="pl-button-mode" data-mode="bitcomet"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>彗星下载</li>
						<li class="pl-button-mode" data-mode="abdm"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>ABDM 下载</li>
						<li class="pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>助手设置</li>
						<li class="pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg>助手美化</li>
						<li class="pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg>更新日志</li>
					</ul>
				</div>`);
				element.append($button);
			})
			base.waitForKeyElements(config.$aliyun.mount.share, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'share') return;
				let $button = $(`<div class="ali-button pl-button">
					<span data-role="icon" data-render-as="svg" class="icon">${temp.main.svg}下载助手</span>
					<ul class="pl-dropdown-menu" style="top:30px; right:16px;">
						<li class="pl-button-mode pl-button-save"><use xlink:href="#pl-icon-fa-save"/></svg>保存后下载</li>
						<li class="pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>助手设置</li>
						<li class="pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg>助手美化</li>
						<li class="pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg>更新日志</li>
					</ul>
				</div>`);
				$button.css({ 'margin-right': '10px', "height": "36px", "width": "auto", "padding": "1px 30px" });
				element.prepend($button);
			})
		},
		addInitButton() {
			let $button = $(`<div class="ali-button pl-button-init"><span data-role="icon" data-render-as="svg" class="icon">${temp.main.svg}点我点亮</span></div>`);
			$button.click(base.showInitDialog);
			base.waitForKeyElements(config.$aliyun.mount.home, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || temp.page !== 'home') return;
				$button.css({ "width": "auto" });
				element.append($button);
			})
			base.waitForKeyElements(config.$aliyun.mount.share, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || temp.page !== 'share') return;
				$button.css({ 'margin-right': '10px', "height": "36px", "padding": "1px 30px", "width": "auto" });
				element.prepend($button);
			})
		},
		async getLink() {
			Swal.fire({
				...temp.swalDefault,
				showConfirmButton: false,
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: false,
				title: "获取中",
				html: `...`,
				footer: "如果选的文件较多，请耐心等待获取完成哦！",
				customClass: {
					popup: 'loading-popup',
					header: 'loading-header',
					title: 'loading-title',
					content: 'loading-content',
					input: 'loading-input',
					footer: 'loading-footer'
				},
				willOpen: () => {
					Swal.showLoading();
				},
			});
			let selectList = this.getSelectedList();
			if (selectList.length === 0) return message.error('提示：<br/>请勾选要下载的文件哦~');
			if (selectList.every(item => item.type !== 'file')) return message.error('提示：<br/>请打开文件夹后再勾选文件~');
			if (temp.page === 'home') {
				selectList = selectList.filter(item => item.type === 'file')
				let batchSize = 15;
				let processed = 0;
				$doc.find('.loading-popup .loading-title').html(`链接获取中`);
				$doc.find('.loading-popup .swal2-html-container').html(`<div>正在获取文件对应的下载链接~</div>`);
				for (let i = 0; i < selectList.length; i += batchSize) {
					// 当前批次文件
					let batch = selectList.slice(i, i + batchSize);
					// 过滤掉已有 URL 的文件
					let noUrlSelectList = batch.filter(v => !Boolean(v.url));
					let hasUrlSelectList = batch.filter(v => Boolean(v.url));
					let queue = [];
					// 为没有 URL 的文件生成请求队列
					noUrlSelectList.forEach((item) => {
						queue.push(this.getFileUrlByOnce(item.driveId, item.fileId)
							.then(val => {
								processed++;
								$doc.find('.loading-popup .swal2-html-container').html(`<div>已获取 ${processed} / ${selectList.length} 个链接~</div>`);
								return val;
							}));
					});
					hasUrlSelectList.forEach((item) => {
						processed++;
						$doc.find('.loading-popup .swal2-html-container').html(`<div>已获取 ${processed} / ${selectList.length} 个链接~</div>`);
					});
					// 等待本批次的请求结果
					let res = await Promise.all(queue);
					res.forEach((val, index) => {
						noUrlSelectList[index].url = val;
					});
					// 每次处理完一个批次后，等待 1 秒
					await base.sleep(1000);
				}
			} else {
				return message.error('提示：<br/>页面错误~');
			}
			temp.links = [selectList, {
				isFolder: v => v.type === 'folder',
				getFileName: v => v.name,
				getFileSize: v => v.size,
				getFileLink: v => (v.downloadUrl || v.url),
				convert: {
					aria2: `--header "Referer:https://${location.host}/"`,
					curl: `-e "https://${location.host}/"`,
					bitcomet: `&refer=${encodeURIComponent(`https://${location.host}/`)}`
				},
				tooltip: config.$aliyun.dom
			}];
			base.showMainDialog(config.base.dom.button[temp.mode].title, base.generateDom(temp.links), config.base.dom.button[temp.mode].footer);
		},
		async getFileUrlByOnce(d, f) {
			let res = await base.post(config.$aliyun.api.getLink, { drive_id: d, file_id: f }, { "Authorization": `${base.getStorage('token').token_type} ${base.getStorage('token').access_token}`, "X-Canary": "client=windows,app=adrive,version=v6.0.0" });
			if (res.code === 'AccessTokenInvalid') {
				return message.error('提示：<br/>访问令牌过期了，请刷新网页后再试');
			}
			if (res.url) {
				return res.url;
			}
			return "";
		},
		getSelectedList() {
			try {
				let selectedList = [];
				let reactDom = document.querySelector(config.$aliyun.mount.list);
				let reactObj = base.findReact(reactDom, 1);
				let props = reactObj.pendingProps;
				if (props) {
					let fileList = props.dataSource || [];
					let selectedKeys = props.selectedKeys.split(',');
					fileList.forEach(function (val) {
						if (selectedKeys.includes(val.fileId)) {
							selectedList.push(val);
						}
					});
				}
				return selectedList;
			} catch (e) {
				return [];
			}
		},
		detectPage() {
			let path = location.pathname;
			if (/^\/(drive)/.test(path)) return 'home';
			if (/^\/(s|share)\//.test(path)) return 'share';
			return "";
		},
		async initPanLinker() {
			base.registerMenuCommand();
			if (config.base.num === base.getValue('setting_init').code || config.base.license === base.getValue('setting_init').license) {
				this.addButton();
			} else {
				this.addInitButton();
			}
			this.addPageListener();
		},
	};
	/**
	 * 中国移动云盘 / 和彩云
	 * @author 油小猴
	 * @author hmjz100
	 */
	let $mcloud = {
		addPageListener() {
			$doc.on('click', '.pl-button-mode', async function (e) {
				temp.mode = e.currentTarget.dataset.mode;
				if (!temp.mode) return;
				temp.main.getLink();
			});
			$doc.on('click', '.pl-button-save', async function (e) {
				e.preventDefault();
				let selectList = temp.main.getSelectedList();
				if (selectList.length === 0) return message.error('提示：<br/>请勾选要下载的文件哦~');
				if (selectList.every(item => !item.contentID && !item.contentName)) return message.error('提示：<br/>请打开文件夹后再勾选文件~');
				message.info('提示：<br/>因网盘限制，只能够通过页面直接下载哦~');
				await base.sleep(500);
				document.querySelector('.btn-top.btn-top_dl').click();
			});
			$doc.on('click', '.listener-api-download.enhance', async function (e) {
				e.preventDefault();
				let o = base._EventFactory(e);
				let $width = o.item.find('.pl-progress-inner');
				let $text = o.item.find('.pl-progress-inner-text');
				let filename = o.link[0].dataset.filename;
				let index = o.link[0].dataset.index;
				let size = Number(o.link[0].dataset.size) || 0;
				let originalHtml = o.link.html();
				base._resetData(index);
				base.get(e.currentTarget.dataset.link, undefined, 'blob', { filename, index });
				let startTime = Date.now();
				let prevLoaded = 0;
				let prevTime = startTime;
				temp.ins[index] = setInterval(async () => {
					let prog = +temp.progress[index] || 0;
					let currentTime = Date.now();
					let elapsedTime = currentTime - startTime;
					let loaded = prog * size / 100;
					let timeDiff = Math.max(currentTime - prevTime, 1); // 避免除零
					let speed = ((loaded - prevLoaded) / (timeDiff / 1000)) || 0;
					// 计算剩余时间（保护除零）
					let totalProgress = Math.max(prog / 100, 0.01);
					let totalElapsedSeconds = elapsedTime / 1000;
					let estTotalTime = totalElapsedSeconds / totalProgress;
					let remainingTime = estTotalTime - totalElapsedSeconds;
					// 更新界面状态
					o.link.hide();
					o.directLink.hide();
					o.tip.hide();
					o.stop.show();
					o.copy.hide();
					o.progress.show();
					// 更新进度条
					$width.css('width', `${prog}%`);
					$text.text(`${prog.toFixed(2)}% | 速度:${base.sizeFormat(speed)} | 剩余:${base.rtimeFormat(remainingTime)}`);
					// 更新历史值
					prevLoaded = loaded;
					prevTime = currentTime;
					// 下载完成
					if (prog >= 100) {
						await base.sleep(1000);
						clearInterval(temp.ins[index]);
						temp.progress[index] = 0;
						o.item.find('.pl-progress-stop').hide();
						$text.text('下载完成~ 浏览器下载框应该弹出来了哦~');
						o.back.show();
						await base.sleep(3000);
						o.link.html(originalHtml).animate({ opacity: '1' }, "slow");
					}
				}, 500);
			});
			$doc.on('click', '.listener-aria2-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToAria2(target.data("link"), target.data("filename"));
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
			$doc.on('click', '.listener-bitcomet-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToBitcomet(target.data("link"), target.data("filename"));
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
			$doc.on('click', '.listener-abdm-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToABDM(target.data("link"), target.data("filename"), undefined);
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
		},
		greenerPage() {
			base.waitForKeyElements(".adv_swiper_menu", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements(".client-bubble", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements(".avs-box", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements(".top-adv-swiper", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements(".client_download_icon", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements(".document_top_memberCenter", function (tag) {
				$(tag[0]).click(function () {
					Swal.fire({
						...temp.swalDefault,
						html: `<iframe style="height:700px; width:420px; border:0;" src="https://vip.yun.139.com/vip/"></iframe>`,
						allowOutsideClick: false,
						showCloseButton: true,
						showConfirmButton: false,
					});
				});
			}, true);
		},
		beautifyPage() {
			if (base.getValue('setting_ui_theme').custom.$mcloud !== true) return;
			base.adaptiveThemeOverride([
				['#3181f9', temp.color],
				['#5a9afa', temp.color],
				['#98c0fc', `${temp.color}D0`],
				['#2d76e5', `${temp.color}D0`],
				['49,129,249,.08', base.hexToRgba(`${temp.color}20`)],
			]);
		},
		addButton() {
			base.waitForKeyElements(config.$mcloud.mount.home, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'home') return;
				let $button = $(`<div class="pl-button mcloud-button btn-top">
					<span class="mcloud-btn">下载助手</span>
					<ul class="pl-dropdown-menu" style="top:36px; left:0; letter-spacing:normal;">
						<li class="pl-button-mode" data-mode="api"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-downward"/></svg>API 下载</li>
						<li class="pl-button-mode" data-mode="curl"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-plug"/></svg>cURL 下载</li>
						<li class="pl-button-mode" data-mode="aria2"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>Aria2 下载</li>
						<li class="pl-button-mode" data-mode="bitcomet"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>彗星下载</li>
						<li class="pl-button-mode" data-mode="abdm"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>ABDM 下载</li>
						<li class="pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>助手设置</li>
						<li class="pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg>助手美化</li>
						<li class="pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg>更新日志</li>
					</ul>
				</div>`);
				element.prepend($button);
			})
			base.waitForKeyElements(config.$mcloud.mount.share, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'share') return;
				let $button = $(`<div class="pl-button mcloud-share-button">
					<span class="mcloud-btn">下载助手</span>
					<ul class="pl-dropdown-menu" style="top:36px; left:0; letter-spacing:normal;">
						<li class="pl-button-mode pl-button-save"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-downward"/></svg>直接下载</li>
						<li class="pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>助手设置</li>
						<li class="pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg>助手美化</li>
						<li class="pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg>更新日志</li>
					</ul>
				</div>`);
				element.prepend($button);
			})
		},
		addInitButton() {
			let $button = $(`<div class="pl-button-init"><span class="mcloud-btn">点我点亮</span></div>`);
			$button.click(base.showInitDialog);
			base.waitForKeyElements(config.$mcloud.mount.home, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || temp.page !== 'home') return;
				$button.addClass('mcloud-button');
				element.prepend($button);
			})
			base.waitForKeyElements(config.$mcloud.mount.share, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || temp.page !== 'share') return;
				$button.addClass('mcloud-share-button').css({ "cursor": "pointer" });
				element.prepend($button);
			})
		},
		getRandomString(len) {
			len = len || 16;
			let $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678';
			let maxPos = $chars.length;
			let pwd = "";
			for (let i = 0; i < len; i++) {
				pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
			}
			return pwd;
		},
		utob(str) {
			let u = String.fromCharCode;
			return str.replace(/[\uD800-\uDBFF][\uDC00-\uDFFFF]|[^\x00-\x7F]/g, function (t) {
				if (t.length < 2) {
					let e = t.charCodeAt(0);
					return e < 128 ? t : e < 2048 ? u(192 | e >>> 6) + u(128 | 63 & e) : u(224 | e >>> 12 & 15) + u(128 | e >>> 6 & 63) + u(128 | 63 & e);
				}
				e = 65536 + 1024 * (t.charCodeAt(0) - 55296) + (t.charCodeAt(1) - 56320);
				return u(240 | e >>> 18 & 7) + u(128 | e >>> 12 & 63) + u(128 | e >>> 6 & 63) + u(128 | 63 & e);
			});
		},
		getSign(e, t, a, n) {
			let r = "",
				i = "";
			if (t) {
				let s = Object.assign({}, t);
				i = JSON.stringify(s),
					i = i.replace(/\s*/g, ""),
					i = encodeURIComponent(i);
				let c = i.split(""),
					u = c.sort();
				i = u.join("");
			}
			let A = md5(base.encodeBase(this.utob(i)));
			let l = md5(a + ":" + n);
			return md5(A + l).toUpperCase();
		},
		async getFileUrlByOnce(item, index) {
			try {
				if (item.downloadUrl) return {
					index,
					downloadUrl: item.downloadUrl
				};
				if (this.detectPage() === 'home') {
					let body = {
						fileId: item.contentID
					}
					let time = new Date(+new Date() + 8 * 3600 * 1000).toJSON().substr(0, 19).replace('T', ' ');
					let key = this.getRandomString(16);
					let sign = this.getSign(undefined, body, time, key);
					let getCookie = (name) => {
						let cname = name + "=";
						let ca = document.cookie.split(';');
						for (let i = 0; i < ca.length; i++) {
							let c = ca[i].trim();
							if (c.indexOf(cname) == 0) return c.substring(cname.length, c.length);
						}
						return "";
					}
					let res = await base.post(config.$mcloud.api.getLink, body, {
						"Authorization": getCookie("authorization"),
						"Caller": "web",
						"CMS-DEVICE": "default",
						"Mcloud-Channel": "1000101",
						"Mcloud-Client": "10701",
						"Mcloud-Sign": time + "," + key + "," + sign,
						"Mcloud-Version": "7.14.2",
						"X-DeviceInfo": "||9|7.14.2|chrome|119.0.0.0|||windows 10||zh-CN|||",
						"X-Huawei-ChannelSrc": "10000034",
						"X-Inner-Ntwk": "2",
						"X-M4C-Caller": "PC",
						"X-M4C-Src": "10002",
						"X-SvcType": "1",
						"X-Yun-Api-Version": "v1",
						"X-Yun-App-Channel": "10000034",
						"X-Yun-Channel-Source": "10000034",
						"X-Yun-Client-Info": "||9|7.14.2|chrome|119.0.0.0|||windows 10||zh-CN|||||",
						"X-Yun-Module-Type": "100",
						"X-Yun-Svc-Type": "1"
					});
					if (res.success) {
						return {
							index,
							downloadUrl: res.data.url
						};
					} else {
						return {
							index,
							downloadUrl: '获取下载地址失败，刷新后再试试吧~'
						};
					}
				}
				if (this.detectPage() === 'share') {
					let vueDom = document.querySelector(".main_file_list").__vue__;
					let res = await base.post(config.$mcloud.api.getShareLink, `linkId=${vueDom.linkID}&contentIds=${item.path}&catalogIds=`, { "Content-Type": "application/x-www-form-urlencoded" });
					if (res.code === 0) {
						return {
							index,
							downloadUrl: res.data.redrUrl
						};
					} else {
						return {
							index,
							downloadUrl: '获取下载地址失败，刷新后再试试吧~'
						};
					}
				}
			} catch (e) {
				return {
					index,
					downloadUrl: '获取下载地址失败，刷新后再试试吧~'
				};
			}
		},
		async getLink() {
			Swal.fire({
				...temp.swalDefault,
				showConfirmButton: false,
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: false,
				title: "获取中",
				html: `...`,
				footer: "如果选的文件较多，请耐心等待获取完成哦！",
				customClass: {
					popup: 'loading-popup',
					header: 'loading-header',
					title: 'loading-title',
					content: 'loading-content',
					input: 'loading-input',
					footer: 'loading-footer'
				},
				willOpen: function () {
					Swal.showLoading();
				},
			});
			let selectList = this.getSelectedList();
			if (selectList.length === 0) return message.error('提示：<br/>请勾选要下载的文件哦~');
			if (selectList.every(item => !item.contentID && !item.contentName)) return message.error('提示：<br/>请打开文件夹后再勾选文件~');
			if (temp.page === 'home') {
				selectList = selectList.filter(item => item.contentID && item.contentName && item.contentSuffix);
				let batchSize = 15;
				let processed = 0;
				$doc.find('.loading-popup .loading-title').html(`链接获取中`);
				$doc.find('.loading-popup .swal2-html-container').html(`<div>正在获取文件对应的下载链接~</div>`);
				for (let i = 0; i < selectList.length; i += batchSize) {
					let batch = selectList.slice(i, i + batchSize);
					let queue = [];
					batch.forEach((item, localIndex) => {
						let globalIndex = i + localIndex;
						queue.push(this.getFileUrlByOnce(item, globalIndex)
							.then(val => {
								processed++;
								$doc.find('.loading-popup .swal2-html-container').html(`<div>已获取 ${processed} / ${selectList.length} 个链接~</div>`);
								return val;
							}));
					});
					let res = await Promise.all(queue);
					res.forEach(val => {
						selectList[val.index].downloadUrl = val.downloadUrl;
					});
					await base.sleep(1000);
				}
			} else {
				return message.error('提示：<br/>页面错误~');
			}
			temp.links = [selectList, {
				isFolder: v => (v.dirEtag || v.caName),
				getFileName: v => (v.contentName || v.coName),
				getFileSize: v => (v.contentSize || v.coSize),
				getFileLink: v => v.downloadUrl,
				tooltip: config.$mcloud.dom
			}];
			base.showMainDialog(config.base.dom.button[temp.mode].title, base.generateDom(temp.links), config.base.dom.button[temp.mode].footer);
		},
		getSelectedList() {
			try {
				return document.querySelector(".main_file_list").__vue__.selectList.map(val => val.item);
			} catch (e) {
				let vueDom = document.querySelector(".home-page").__vue__;
				let fileList = vueDom._computedWatchers.fileList.value;
				let dirList = vueDom._computedWatchers.dirList.value;
				let selectedFileIndex = vueDom.selectedFile;
				let selectedDirIndex = vueDom.selectedDir;
				let selectFileList = fileList.filter((v, i) => {
					return selectedFileIndex.includes(i);
				});
				let selectDirList = dirList.filter((v, i) => {
					return selectedDirIndex.includes(i);
				});
				return [...selectFileList, ...selectDirList];
			}
		},
		detectPage() {
			let path = location.pathname;
			if (/^\/w/.test(path)) return 'home';
			if (/^\/link|shareweb/.test(path)) return 'share';
			return "";
		},
		async initPanLinker() {
			base.registerMenuCommand();
			if (config.base.num === base.getValue('setting_init').code || config.base.license === base.getValue('setting_init').license) {
				this.addButton();
			} else {
				this.addInitButton();
			}
			this.addPageListener();
		},
	};
	/**
	 * 天翼云盘
	 * @author 油小猴
	 * @author hmjz100
	 */
	let $tcloud = {
		addPageListener() {
			$doc.on('click', '.pl-button-mode', async function (e) {
				temp.mode = e.currentTarget.dataset.mode;
				if (!temp.mode) return;
				temp.main.getLink();
			});
			$doc.on('click', '.listener-api-download.enhance', async function (e) {
				e.preventDefault();
				let o = base._EventFactory(e);
				let $width = o.item.find('.pl-progress-inner');
				let $text = o.item.find('.pl-progress-inner-text');
				let filename = o.link[0].dataset.filename;
				let index = o.link[0].dataset.index;
				let size = Number(o.link[0].dataset.size) || 0;
				let originalHtml = o.link.html();
				base._resetData(index);
				base.get(e.currentTarget.dataset.link, undefined, 'blob', { filename, index });
				let startTime = Date.now();
				let prevLoaded = 0;
				let prevTime = startTime;
				temp.ins[index] = setInterval(async function () {
					let prog = +temp.progress[index] || 0;
					let currentTime = Date.now();
					let elapsedTime = currentTime - startTime;
					let loaded = prog * size / 100;
					let timeDiff = Math.max(currentTime - prevTime, 1); // 避免除零
					let speed = ((loaded - prevLoaded) / (timeDiff / 1000)) || 0;
					// 计算剩余时间（保护除零）
					let totalProgress = Math.max(prog / 100, 0.01);
					let totalElapsedSeconds = elapsedTime / 1000;
					let estTotalTime = totalElapsedSeconds / totalProgress;
					let remainingTime = estTotalTime - totalElapsedSeconds;
					// 更新界面状态
					o.link.hide();
					o.directLink.hide();
					o.tip.hide();
					o.stop.show();
					o.copy.hide();
					o.progress.show();
					// 更新进度条
					$width.css('width', `${prog}%`);
					$text.text(`${prog.toFixed(2)}% | 速度:${base.sizeFormat(speed)} | 剩余:${base.rtimeFormat(remainingTime)}`);
					// 更新历史值
					prevLoaded = loaded;
					prevTime = currentTime;
					// 下载完成
					if (prog >= 100) {
						await base.sleep(1000);
						clearInterval(temp.ins[index]);
						temp.progress[index] = 0;
						o.item.find('.pl-progress-stop').hide();
						$text.text('下载完成~ 浏览器下载框应该弹出来了哦~');
						o.back.show();
						await base.sleep(3000);
						o.link.html(originalHtml).animate({ opacity: '1' }, "slow");
					}
				}, 500);
			});
			$doc.on('click', '.listener-aria2-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToAria2(target.data("link"), target.data("filename"));
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
			$doc.on('click', '.listener-bitcomet-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToBitcomet(target.data("link"), target.data("filename"));
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
			$doc.on('click', '.listener-abdm-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToABDM(target.data("link"), target.data("filename"), undefined);
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
		},
		greenerPage() {
			base.waitForKeyElements(".advertising-mask", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements("a.client-download.nav-block", function (tag) {
				tag.fadeOut();
			}, true);
		},
		beautifyPage() {
			if (base.getValue('setting_ui_theme').custom.$tcloud !== true) return;
			base.adaptiveThemeOverride([
				['#2b89ea', temp.color],
				['#1874d3', `${temp.color}F0`],
				['#1890ff', temp.color],
				['#388fc9', temp.color],
				['#0087ff', temp.color],
				['#255697', temp.color],
				['#3ea6ff', `${temp.color}80`],
				['#1d52f2', temp.color],
				['#3699ff', `${temp.color}D0`],
				['#f4f9fe', `${temp.color}10`],
				['#eaf5ff', `${temp.color}20`],
			], "other");
		},
		addButton() {
			let $button = $(`<div class="pl-button tcloud-button">
				下载助手&nbsp;
				<i aria-label="icon:caret-down" class="anticon anticon-caret-down">
					<svg viewBox="0 0 1024 1024" data-icon="caret-down" width="1em" height="1em" fill="currentColor" aria-hidden="true" focusable="false">
						<path d="M840.4 300H183.6c-19.7 0-30.7 20.8-18.5 35l328.4 380.8c9.4 10.9 27.5 10.9 37 0L858.9 335c12.2-14.2 1.2-35-18.5-35z"></path>
					</svg>
				</i>
				<ul class="pl-dropdown-menu">
					<li class="pl-button-mode" data-mode="api"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-downward"/></svg>API 下载</li>
					<li class="pl-button-mode" data-mode="curl"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-plug"/></svg>cURL 下载</li>
					<li class="pl-button-mode" data-mode="aria2"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>Aria2 下载</li>
					<li class="pl-button-mode" data-mode="bitcomet"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>彗星下载</li>
					<li class="pl-button-mode" data-mode="abdm"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>ABDM 下载</li>
					<li class="pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>助手设置</li>
					<li class="pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg>助手美化</li>
					<li class="pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg>更新日志</li>
				</ul>
			</div>`);
			$button.find(".pl-dropdown-menu").css({ 'position': 'absolute', 'left': '-1px' })
			base.waitForKeyElements(config.$tcloud.mount.home, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'home') return;
				$button.find(".pl-dropdown-menu").css({ 'top': '28px' })
				element.prepend($button);
			})
			base.waitForKeyElements(config.$tcloud.mount.share, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'share') return;
				$button.css({ 'height': '28px', 'border-radius': '15px' })
				$button.find(".pl-dropdown-menu").css({ 'top': '25px' })
				element.prepend($button);
			})
		},
		addInitButton() {
			let $button = $(`<div class="tcloud-button pl-button-init">点我点亮</div>`);
			$button.click(base.showInitDialog);
			base.waitForKeyElements(config.$tcloud.mount.home, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || temp.page !== 'home') return;
				element.prepend($button);
			})
			base.waitForKeyElements(config.$tcloud.mount.share, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || temp.page !== 'share') return;
				$button.css({ 'height': '28px', 'border-radius': '15px' })
				element.prepend($button);
			})
		},
		async getToken() {
			$doc.find('.loading-popup .loading-title').html(`令牌获取中`);
			$doc.find('.loading-popup .swal2-html-container').html(`<div>正在获取状态~</div>`);
			let res = await base.getFinalUrl(config.$tcloud.api.getAccessToken, undefined, true);
			let accessToken = res.match(/accessToken=(\w+)/)?.[1];
			accessToken && base.setStorage('accessToken', accessToken);
			$doc.find('.loading-popup .loading-title').html(`令牌获取中`);
			$doc.find('.loading-popup .swal2-html-container').html(`<div>获取成功，令牌已缓存~</div>`);
			return accessToken;
		},
		async getFileUrlByOnce(item, index, token) {
			try {
				if (item.downloadUrl) {
					return {
						index,
						downloadUrl: item.downloadUrl
					}
				};
				let time = Date.now(),
					fileId = item.fileId,
					o = "AccessToken=" + token + "&Timestamp=" + time + "&fileId=" + fileId,
					url = config.$tcloud.api.getLink + '?fileId=' + fileId;
				if (item.shareId) {
					o = "AccessToken=" + token + "&Timestamp=" + time + "&dt=1&fileId=" + fileId + "&shareId=" + item.shareId;
					url += '&dt=1&shareId=' + item.shareId;
				}
				let sign = md5(o).toString();
				let res = await base.get(url, { "Accept": "application/json;charset=UTF-8", "Sign-Type": 1, "Accesstoken": token, "Timestamp": time, "Signature": sign });
				if (res.res_code === 0) {
					return {
						index,
						downloadUrl: res.fileDownloadUrl
					};
				} else if (res.errorCode === 'InvalidSessionKey') {
					return {
						index,
						downloadUrl: '提示：<br/>请先登录网盘~'
					};
				} else if (res.res_code === 'ShareNotFoundFlatDir') {
					return {
						index,
						downloadUrl: '提示：<br/>请[转存]文件，之后再👉前往[我的网盘]中下载哦~'
					};
				} else {
					return {
						index,
						downloadUrl: '获取下载地址失败，刷新后再试试吧~' + (res.res_code ? res.res_code : "")
					};
				}
			} catch (e) {
				return {
					index,
					downloadUrl: '获取下载地址失败，刷新后再试试吧~'
				};
			}
		},
		async getLink() {
			Swal.fire({
				...temp.swalDefault,
				showConfirmButton: false,
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: false,
				title: "获取中",
				html: `...`,
				footer: "如果选的文件较多，请耐心等待获取完成哦！",
				customClass: {
					popup: 'loading-popup',
					header: 'loading-header',
					title: 'loading-title',
					content: 'loading-content',
					input: 'loading-input',
					footer: 'loading-footer'
				},
				willOpen: function () {
					Swal.showLoading();
				},
			});
			let selectList = this.getSelectedList();
			if (selectList.length === 0) return message.error('提示：<br/>请勾选要下载的文件哦~');
			if (selectList.every(item => item.isFolder)) return message.error('提示：<br/>请打开文件夹后再勾选文件~');
			selectList = selectList.filter(item => !item.isFolder)
			$doc.find('.loading-popup .loading-title').html(`令牌获取中`);
			$doc.find('.loading-popup .swal2-html-container').html(`<div>正在获取状态~</div>`);
			let token = base.getStorage('accessToken') || await this.getToken();
			if (!token) {
				return message.error('提示：<br/>请先登录网盘~');
			}
			$doc.find('.loading-popup .loading-title').html(`令牌获取中`);
			$doc.find('.loading-popup .swal2-html-container').html(`<div>获取缓存成功~</div>`);
			let batchSize = 15;
			let processed = 0;
			$doc.find('.loading-popup .loading-title').html(`链接获取中`);
			$doc.find('.loading-popup .swal2-html-container').html(`<div>正在获取文件对应的下载链接~</div>`);
			for (let i = 0; i < selectList.length; i += batchSize) {
				let batch = selectList.slice(i, i + batchSize);
				let queue = [];
				batch.forEach((item, localIndex) => {
					let globalIndex = i + localIndex;
					queue.push(this.getFileUrlByOnce(item, globalIndex, token)
						.then(val => {
							processed++;
							$doc.find('.loading-popup .swal2-html-container').html(`<div>已获取 ${processed} / ${selectList.length} 个链接~</div>`);
							return val;
						}));
				});
				let res = await Promise.all(queue);
				res.forEach(val => {
					selectList[val.index].downloadUrl = val.downloadUrl;
				});
				await base.sleep(1000);
			}
			temp.links = [selectList, {
				isFolder: v => v.isFolder,
				getFileName: v => v.fileName,
				getFileSize: v => v.size,
				getFileLink: v => v.downloadUrl,
				tooltip: config.$mcloud.dom
			}];
			base.showMainDialog(config.base.dom.button[temp.mode].title, base.generateDom(temp.links), config.base.dom.button[temp.mode].footer);
		},
		getSelectedList() {
			try {
				return document.querySelector(".c-file-list").__vue__.selectedList;
			} catch (e) {
				return [document.querySelector(".info-detail").__vue__.fileDetail];
			}
		},
		detectPage() {
			let path = location.pathname;
			if (/^\/web\/main/.test(path)) return 'home';
			if (/^\/web\/share/.test(path)) return 'share';
			return "";
		},
		async initPanLinker() {
			base.registerMenuCommand();
			if (config.base.num === base.getValue('setting_init').code || config.base.license === base.getValue('setting_init').license) {
				this.addButton();
			} else {
				this.addInitButton();
			}
			this.addPageListener();
			this.getToken();
		},
	};
	/**
	 * 迅雷云盘
	 * @author 油小猴
	 * @author hmjz100
	 */
	let $xunlei = {
		addPageListener() {
			$doc.on('click', '.pl-button-mode', async function (e) {
				temp.mode = e.currentTarget.dataset.mode;
				if (!temp.mode) return;
				temp.main.getLink();
			});
			$doc.on('click', '.pl-button-save', async function (e) {
				e.preventDefault();
				let selectList = temp.main.getSelectedList();
				if (selectList.length === 0) {
					return message.error('提示：<br/>请勾选要保存到网盘的文件哦~');
				}
				message.info('提示：<br/>因网盘限制，请保存到自己网盘后再去下载哦~');
				await base.sleep(500);
				document.querySelector('.saveToCloud').click();
			});
			$doc.on('click', '.listener-api-download.enhance', async function (e) {
				e.preventDefault();
				let o = base._EventFactory(e);
				let $width = o.item.find('.pl-progress-inner');
				let $text = o.item.find('.pl-progress-inner-text');
				let filename = o.link[0].dataset.filename;
				let index = o.link[0].dataset.index;
				let size = Number(o.link[0].dataset.size) || 0;
				let originalHtml = o.link.html();
				base._resetData(index);
				base.get(e.currentTarget.dataset.link, undefined, 'blob', { filename, index });
				let startTime = Date.now();
				let prevLoaded = 0;
				let prevTime = startTime;
				temp.ins[index] = setInterval(async function () {
					let prog = +temp.progress[index] || 0;
					let currentTime = Date.now();
					let elapsedTime = currentTime - startTime;
					let loaded = prog * size / 100;
					let timeDiff = Math.max(currentTime - prevTime, 1); // 避免除零
					let speed = ((loaded - prevLoaded) / (timeDiff / 1000)) || 0;
					// 计算剩余时间（保护除零）
					let totalProgress = Math.max(prog / 100, 0.01);
					let totalElapsedSeconds = elapsedTime / 1000;
					let estTotalTime = totalElapsedSeconds / totalProgress;
					let remainingTime = estTotalTime - totalElapsedSeconds;
					// 更新界面状态
					o.link.hide();
					o.directLink.hide();
					o.tip.hide();
					o.stop.show();
					o.copy.hide();
					o.progress.show();
					// 更新进度条
					$width.css('width', `${prog}%`);
					$text.text(`${prog.toFixed(2)}% | 速度:${base.sizeFormat(speed)} | 剩余:${base.rtimeFormat(remainingTime)}`);
					// 更新历史值
					prevLoaded = loaded;
					prevTime = currentTime;
					// 下载完成
					if (prog >= 100) {
						await base.sleep(1000);
						clearInterval(temp.ins[index]);
						temp.progress[index] = 0;
						o.item.find('.pl-progress-stop').hide();
						$text.text('下载完成~ 浏览器下载框应该弹出来了哦~');
						o.back.show();
						await base.sleep(3000);
						o.link.html(originalHtml).animate({ opacity: '1' }, "slow");
					}
				}, 500);
			});
			$doc.on('click', '.listener-aria2-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToAria2(target.data("link"), target.data("filename"));
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
			$doc.on('click', '.listener-bitcomet-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToBitcomet(target.data("link"), target.data("filename"), { "mirror_url_list": base.getMirrorList(target.data("link"), config.$xunlei.api.mirror), "checkboxCustomHeadersForMirrors": "on" });
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
			$doc.on('click', '.listener-abdm-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToABDM(target.data("link"), target.data("filename"), undefined);
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
		},
		beautifyPage() {
			if (base.getValue('setting_ui_theme').custom.$xunlei !== true) return;
			base.adaptiveThemeOverride([
				['#3f85ff', temp.color],
				['63,133,255,.1', base.hexToRgba(`${temp.color}20`)],
				['#2670ea', `${temp.color}D0`],
				['#619bff', `${temp.color}D0`],
				['#ecf3ff', `${temp.color}10`],
				['#f6faff', `${temp.color}10`],
				['#1a2845', `${temp.color}20`],
				['#0f2035', `${temp.color}20`],
				['#308bfd', `${temp.color}20`],
				['#eee', `${temp.color}20`],
			], "other");
			base.addStyle(`${mount}-xunlei`, 'style', `.web-header{background:linear-gradient(0deg,${temp.color}D0,${temp.color})}`);
		},
		addButton() {
			base.waitForKeyElements(config.$xunlei.mount.home, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'home') return;
				let $button = $(`<div class="xunlei-button pl-button"><i class="xlpfont xlp-download"></i><span style="font-size:13px;margin-left:6px;">下载助手</span>
					<ul class="pl-dropdown-menu" style="top:34px;">
						<li class="pl-button-mode" data-mode="api"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-downward"/></svg>API 下载</li>
						<li class="pl-button-mode" data-mode="curl"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-plug"/></svg>cURL 下载</li>
						<li class="pl-button-mode" data-mode="aria2"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>Aria2 下载</li>
						<li class="pl-button-mode" data-mode="bitcomet"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>彗星下载</li>
						<li class="pl-button-mode" data-mode="abdm"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>ABDM 下载</li>
						<li class="pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>助手设置</li>
						<li class="pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg>助手美化</li>
						<li class="pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg>更新日志</li>
					</ul>
				</div>`);
				element.prepend($button);
			})
			base.waitForKeyElements(config.$xunlei.mount.share, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'share') return;
				let $button = $(`<div class="xunlei-button pl-button">
					<i class="xlpfont xlp-download"></i><span style="font-size:13px;margin-left:6px;">下载助手</span>
					<ul class="pl-dropdown-menu" style="top:34px;">
						<li class="pl-button-mode pl-button-save"><i class="xlpfont xlp-file-upload"></i><span style="margin-left:3px;">转存后下载</span></li>
						<li class="pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>助手设置</li>
						<li class="pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg>助手美化</li>
						<li class="pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg>更新日志</li>
					</ul>
				</div>`);
				$button.css({ 'margin-right': '10px' });
				element.prepend($button);
			})
		},
		addInitButton() {
			let $button = $(`<div class="xunlei-button pl-button-init"><i class="xlpfont xlp-download"></i><span style="font-size:13px;margin-left:6px;">点我点亮</span></div>`);
			$button.click(base.showInitDialog);
			base.waitForKeyElements(config.$xunlei.mount.home, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || temp.page !== 'home') return;
				element.prepend($button);
			})
			base.waitForKeyElements(config.$xunlei.mount.share, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || temp.page !== 'share') return;
				$button.css({ 'margin-right': '10px' });
				element.prepend($button);
			})
		},
		getToken() {
			$doc.find('.loading-popup .loading-title').html(`令牌获取中`);
			$doc.find('.loading-popup .swal2-html-container').html(`<div>正在获取状态~</div>`);
			let credentials = {}, captcha = {};
			for (let i = 0; i < localStorage.length; i++) {
				if (/^credentials_/.test(localStorage.key(i))) {
					credentials = base.getStorage(localStorage.key(i));
					base.setStorage("");
				}
				if (/^captcha_[\w]{16}/.test(localStorage.key(i))) {
					captcha = base.getStorage(localStorage.key(i));
				}
			}
			let deviceid = /(\w{32})/.exec(base.getStorage('deviceid').split(','))[0];
			let token = {
				credentials,
				captcha,
				deviceid
			};
			return token;
		},
		async getFileUrlByOnce(item, index, token) {
			try {
				if (item.downloadUrl) return {
					index,
					downloadUrl: item.downloadUrl
				};
				let res = await base.get(config.$xunlei.api.getLink + item.id, { "Authorization": `${token.credentials.token_type} ${token.credentials.access_token}`, "Content-Type": "application/json", "X-Captcha-Token": token.captcha.token, "X-Device-Id": token.deviceid });
				if (res.web_content_link) {
					return {
						index,
						downloadUrl: res.web_content_link
					};
				} else {
					return {
						index,
						downloadUrl: '获取下载地址失败，刷新后再试试吧~'
					};
				}
			} catch (e) {
				return message.error('提示：<br/>请先登录网盘后再刷新页面呢~');
			}
		},
		async getLink() {
			Swal.fire({
				...temp.swalDefault,
				showConfirmButton: false,
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: false,
				title: "获取中",
				html: `...`,
				footer: "如果选的文件较多，请耐心等待获取完成哦！",
				customClass: {
					popup: 'loading-popup',
					header: 'loading-header',
					title: 'loading-title',
					content: 'loading-content',
					input: 'loading-input',
					footer: 'loading-footer'
				},
				willOpen: function () {
					Swal.showLoading();
				},
			});
			let selectList = this.getSelectedList();
			if (selectList.length === 0) return message.error('提示：<br/>请勾选要下载的文件哦~');
			if (selectList.every(item => item.kind !== 'drive#file')) return message.error('提示：<br/>请打开文件夹后再勾选文件~');
			if (temp.page === 'home') {
				let token = this.getToken();
				let batchSize = 15;
				let processed = 0;
				$doc.find('.loading-popup .loading-title').html(`链接获取中`);
				$doc.find('.loading-popup .swal2-html-container').html(`<div>正在获取文件对应的下载链接~</div>`);
				for (let i = 0; i < selectList.length; i += batchSize) {
					let batch = selectList.slice(i, i + batchSize);
					let queue = [];
					batch.forEach((item, localIndex) => {
						let globalIndex = i + localIndex;
						queue.push(this.getFileUrlByOnce(item, globalIndex, token)
							.then(val => {
								processed++;
								$doc.find('.loading-popup .swal2-html-container').html(`<div>已获取 ${processed} / ${selectList.length} 个链接~</div>`);
								return val;
							}));
					});
					let res = await Promise.all(queue);
					res.forEach(val => {
						selectList[val.index].downloadUrl = val.downloadUrl;
					});
					await base.sleep(1000);
				}
			} else {
				return message.error('提示：<br/>页面错误~');
			}
			temp.links = [selectList, {
				isFolder: v => v.kind === 'drive#folder',
				getFileName: v => v.name,
				getFileSize: v => v.size,
				getFileLink: v => v.downloadUrl,
				getFileMirror: v => base.getMirrorList(v, config.$xunlei.api.mirror),
				tooltip: config.$xunlei.dom
			}];
			base.showMainDialog(config.base.dom.button[temp.mode].title, base.generateDom(temp.links), config.base.dom.button[temp.mode].footer);
		},
		getSelectedList() {
			try {
				let doms = document.querySelectorAll('.SourceListItem__item--XxpOC');
				let selectedList = [];
				for (let dom of doms) {
					let domVue = dom.__vue__;
					if (domVue.selected.includes(domVue.info.id)) {
						selectedList.push(domVue.info);
					}
				}
				return selectedList;
			} catch (e) {
				return [];
			}
		},
		detectPage() {
			let path = location.pathname;
			if (/^\/$/.test(path)) return 'home';
			if (/^\/(s|share)\//.test(path)) return 'share';
			return "";
		},
		async initPanLinker() {
			base.registerMenuCommand();
			if (config.base.num === base.getValue('setting_init').code || config.base.license === base.getValue('setting_init').license) {
				this.addButton();
			} else {
				this.addInitButton();
			}
			this.addPageListener();
		},
	};
	/**
	 * 夸克网盘
	 * @author 油小猴
	 * @author hmjz100
	 */
	let $quark = {
		addPageListener() {
			$doc.on('click', '.pl-button-mode', async function (e) {
				temp.mode = e.currentTarget.dataset.mode;
				if (!temp.mode) return;
				temp.main.getLink();
			});
			$doc.on('click', '.pl-button-save', async function (e) {
				e.preventDefault();
				let selectList = temp.main.getSelectedList();
				if (selectList.length === 0) {
					return message.error('提示：<br/>请勾选要保存到网盘的文件哦~');
				}
				message.info('提示：<br/>因网盘限制，请保存到自己网盘后再去下载哦~');
				await base.sleep(500);
				document.querySelector('.share-path').click();
				base.waitForKeyElements(".btn-file.btn-file-primary.confirm-btn", (element) => {
					element.one("click", async () => {
						await base.sleep(1000);
						document.querySelector('.share-save').click();
					})
					return true;
				}, true)
			});
			$doc.on('click', '.listener-api-download.enhance', async function (e) {
				e.preventDefault();
				let o = base._EventFactory(e);
				let $width = o.item.find('.pl-progress-inner');
				let $text = o.item.find('.pl-progress-inner-text');
				let filename = o.link[0].dataset.filename;
				let index = o.link[0].dataset.index;
				let size = Number(o.link[0].dataset.size) || 0;
				let originalHtml = o.link.html();
				base._resetData(index);
				base.get(e.currentTarget.dataset.link, { "User-Agent": config.$quark.api.ua.downloadLink }, 'blob', { filename, index });
				let startTime = Date.now();
				let prevLoaded = 0;
				let prevTime = startTime;
				temp.ins[index] = setInterval(async function () {
					let prog = +temp.progress[index] || 0;
					let currentTime = Date.now();
					let elapsedTime = currentTime - startTime;
					let loaded = prog * size / 100;
					let timeDiff = Math.max(currentTime - prevTime, 1); // 避免除零
					let speed = ((loaded - prevLoaded) / (timeDiff / 1000)) || 0;
					// 计算剩余时间（保护除零）
					let totalProgress = Math.max(prog / 100, 0.01);
					let totalElapsedSeconds = elapsedTime / 1000;
					let estTotalTime = totalElapsedSeconds / totalProgress;
					let remainingTime = estTotalTime - totalElapsedSeconds;
					// 更新界面状态
					o.link.hide();
					o.directLink.hide();
					o.tip.hide();
					o.stop.show();
					o.copy.hide();
					o.progress.show();
					// 更新进度条
					$width.css('width', `${prog}%`);
					$text.text(`${prog.toFixed(2)}% | 速度:${base.sizeFormat(speed)} | 剩余:${base.rtimeFormat(remainingTime)}`);
					// 更新历史值
					prevLoaded = loaded;
					prevTime = currentTime;
					// 下载完成
					if (prog >= 100) {
						await base.sleep(1000);
						clearInterval(temp.ins[index]);
						temp.progress[index] = 0;
						o.item.find('.pl-progress-stop').hide();
						$text.text('下载完成~ 浏览器下载框应该弹出来了哦~');
						o.back.show();
						await base.sleep(3000);
						o.link.html(originalHtml).animate({ opacity: '1' }, "slow");
					}
				}, 500);
			});
			$doc.on('click', '.listener-aria2-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToAria2(target.data("link"), target.data("filename"), [`User-Agent:${config.$quark.api.ua.downloadLink}`, `Referer:https://${location.host}/`, `Cookie:${document.cookie}`]);
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
			$doc.on('click', '.listener-bitcomet-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToBitcomet(target.data("link"), target.data("filename"), { "user_agent": config.$quark.api.ua.downloadLink, "referrer": `https://${location.host}/`, "cookie": document.cookie });
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
			$doc.on('click', '.listener-abdm-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToABDM(target.data("link"), target.data("filename"), { "User-Agent": config.$quark.api.ua.downloadLink, "Cookie": document.cookie });
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
		},
		greenerPage() {
			base.waitForKeyElements('[class*="Activity--video-toolbar-activity"]', function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements('span[class*="SectionHeaderController--icon-download"]', function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements('div[class*="SectionHeaderController--download-popover"]', function (tag) {
				tag.find(".ant-popover-arrow").css({ "left": "75%" });
			}, true);
			base.waitForKeyElements('div[class*="DetailLayout--client-download"]', function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements(".next-box.share-right-side-content", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements('[class*="DetailLayout--container"] .feature-screen', function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements('.ant-modal-content .ant-modal-body .right-wrap', function (tag) {
				if (tag.find(".hint").text().includes("客户端")) tag.fadeOut();
			}, true);
			base.waitForKeyElements(".pc-member-entrance span.button-text", function (tag) {
				tag.text("会员中心");
				let observer = new MutationObserver(function (mutations) {
					mutations.forEach(function (mutation) {
						if (tag.text() === "会员中心") return
						tag.text("会员中心");
					});
				});
				let config = { subtree: true, characterData: true, childList: true };
				observer.observe(tag[0], config);
			}, true);
			base.waitForKeyElements(".pc-member-entrance .tips", function (tag) {
				tag.fadeOut();
			}, true);
			base.waitForKeyElements(".modal .modal-content .halo-animated-background .halo-content .pay-modal .close", function (tag) {
				tag[0].click();
			}, true);
			base.waitForKeyElements(".modal .modal-content .halo-animated-background .halo-content .red-envelope .close", function (tag) {
				tag[0].click();
			}, true);
		},
		beautifyPage() {
			if (base.getValue('setting_ui_theme').custom.$quark !== true) return;
			base.adaptiveThemeOverride([
				['#0d53ff', temp.color],
				['#e6f1ff', `${temp.color}20`],
				['#f0faff', `${temp.color}20`],
				['#7da3ff', `${temp.color}D0`],
				['#ddd', `${temp.color}D0`],
				['17,17,17,.9', base.hexToRgba(`${temp.color}D0`)],
				['40,40,255,.04', base.hexToRgba(`${temp.color}20`)],
				['#f7f7ff', 'transparent'],
				['238,247,255,0', base.hexToRgba(`${temp.color}00`)],
			]);
			base.addStyle(`${mount}-quark`, 'style', `.file-list .hover-oper .hover-transparent-bg{background:transparent!important} .ant-checkbox-wrapper .ant-checkbox-checked .ant-checkbox-inner,.ant-checkbox-wrapper .ant-checkbox-indeterminate .ant-checkbox-inner:after{background-color:${temp.color}!important}`);
		},
		svg: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGcgZmlsbC1ydWxlPSJub256ZXJvIiBzdHJva2U9IiNmZmYiIHN0cm9rZS13aWR0aD0iMiIgZmlsbD0ibm9uZSI+PHBhdGggc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIiBkPSJNNiA5bDIgMiAyLTJ6Ii8+PHBhdGggZD0iTTExIDVoMS41NTNjLjg1IDAgMS4xNi4wOTMgMS40Ny4yNjcuMzExLjE3NC41NTYuNDMuNzIyLjc1Ni4xNjYuMzI2LjI1NS42NS4yNTUgMS41NHY0Ljg3M2MwIC44OTItLjA4OSAxLjIxNS0uMjU1IDEuNTQtLjE2Ni4zMjctLjQxLjU4My0uNzIyLjc1Ny0uMzEuMTc0LS42Mi4yNjctMS40Ny4yNjdIMy40NDdjLS44NSAwLTEuMTYtLjA5My0xLjQ3LS4yNjdhMS43NzggMS43NzggMCAwMS0uNzIyLS43NTZjLS4xNjYtLjMyNi0uMjU1LS42NS0uMjU1LTEuNTRWNy41NjNjMC0uODkyLjA4OS0xLjIxNS4yNTUtMS41NC4xNjYtLjMyNy40MS0uNTgzLjcyMi0uNzU3LjMxLS4xNzQuNjItLjI2NyAxLjQ3LS4yNjdIOCIvPjxwYXRoIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIgZD0iTTggMXY5Ii8+PC9nPjwvc3ZnPg==',
		addButton() {
			base.waitForKeyElements(config.$quark.mount.home, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'home') return;
				let $button = $(`<div class="ant-dropdown-trigger pl-button" style="display: inline-block;">
					<div class="ant-upload ant-upload-select ant-upload-select-text">
						<ul class="pl-dropdown-menu" style="top:35px">
							<li class="pl-button-mode" data-mode="api"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-downward"/></svg>API 下载</li>
							<li class="pl-button-mode" data-mode="curl"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-plug"/></svg>cURL 下载</li>
							<li class="pl-button-mode" data-mode="aria2"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>Aria2 下载</li>
							<li class="pl-button-mode" data-mode="bitcomet"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>彗星下载</li>
							<li class="pl-button-mode" data-mode="abdm"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>ABDM 下载</li>
							<li class="pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>助手设置</li>
							<li class="pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg>助手美化</li>
							<li class="pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg>更新日志</li>
						</ul>
						<button type="button" class="ant-btn ant-btn-primary quark-button">
							<img class="btn-icon" src="${temp.main.svg}">
							<span>下载助手</span>
						</button>
					</div>
				</div>`);
				$button.css({ "margin-right": "16px" });
				element.prepend($button);
			})
			base.waitForKeyElements(config.$quark.mount.share, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'share') return;
				let $button = $(`<button type="button" class="ant-btn btn-file ant-btn-primary pl-button quark-button"><img class="btn-icon" src="${temp.main.svg}"><span>下载助手</span><ul class="pl-dropdown-menu" style="bottom:22px;left:0"><li class="pl-button-mode pl-button-save"><span class="share-save-ico"></span>保存后下载</li><li class="pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>助手设置</li><li class="pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg>助手美化</li><li class="pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg>更新日志</li></ul></button>`);
				$button.css({ "height": "36px", "margin-left": "16px", "border-radius": "6px", "display": "inline-block" });
				element.append($button);
			})
		},
		addInitButton() {
			base.waitForKeyElements(config.$quark.mount.home, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || temp.page !== 'home') return;
				let $button = $(`<button type="button" class="ant-btn ant-btn-primary quark-button pl-button-init"><img class="btn-icon" src="${temp.main.svg}"><span>点我点亮</span></button>`);
				$button.css({ "margin-right": "16px", "display": "inline-block" });
				$button.click(base.showInitDialog);
				element.prepend($button);
			})
			base.waitForKeyElements(config.$quark.mount.share, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || temp.page !== 'share') return;
				let $button = $(`<button type="button" class="ant-btn btn-file ant-btn-primary pl-button-init quark-button"><img class="btn-icon" src="${temp.main.svg}"><span>点我点亮</span></button>`);
				$button.css({ "height": "36px", "margin-left": "16px", "border-radius": "6px", "display": "inline-block" });
				$button.click(base.showInitDialog);
				element.append($button);
			})
		},
		async getLink() {
			Swal.fire({
				...temp.swalDefault,
				showConfirmButton: false,
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: false,
				title: "获取中",
				html: `...`,
				footer: "如果选的文件较多，请耐心等待获取完成哦！",
				customClass: {
					popup: 'loading-popup',
					header: 'loading-header',
					title: 'loading-title',
					content: 'loading-content',
					input: 'loading-input',
					footer: 'loading-footer'
				},
				willOpen: function () {
					Swal.showLoading();
				},
			});
			let selectList = this.getSelectedList();
			if (selectList.length === 0) return message.error('提示：<br/>请勾选要下载的文件哦~');
			if (selectList.every(item => !item.file)) return message.error('提示：<br/>请打开文件夹后再勾选文件~');
			if (temp.page === 'home') {
				let data = [];
				let batchSize = 15;
				let processed = 0;
				selectList = selectList.filter(item => item.file === true)
				for (let i = 0; i < selectList.length; i += batchSize) {
					// 获取当前批次文件
					let batch = selectList.slice(i, i + batchSize);
					let fids = batch.map(item => item.fid);
					// 发起请求获取链接
					let res = await base.post(config.$quark.api.getLink, { "fids": fids }, { "User-Agent": config.$quark.api.ua.downloadLink });
					if (res?.code === 31001) {
						return message.error('提示：<br/>请先登录网盘~<br/>代码：' + res.code);
					}
					if (res?.code !== 0) {
						return message.error('提示：<br/>获取链接失败了~<br/>代码：' + res.code);
					}
					// 合并响应数据
					if (res?.data) {
						data.push(...res.data);
					}
					// 更新处理进度
					processed += batch.length;
					// 更新UI显示
					$doc.find('.loading-popup .loading-title').html(`链接获取中`);
					$doc.find('.loading-popup .swal2-html-container').html(`<div>已获取 ${processed} / ${selectList.length} 个链接~</div>`);
					// 请求间隔节流
					await base.sleep(1000);
				}
				temp.links = [data, {
					isFolder: v => v.file === false,
					getFileName: v => v.file_name,
					getFileSize: v => v.size,
					getFileLink: v => v.download_url,
					convert: {
						aria2: `--header "User-Agent:${config.$quark.api.ua.downloadLink}" --header "Referer:https://${location.host}/" --header "Cookie:${document.cookie}"`,
						curl: `-A "${config.$quark.api.ua.downloadLink}" -e "https://${location.host}/" -b "${document.cookie}"`,
						bitcomet: `user_agent=${encodeURIComponent(config.$quark.api.ua.downloadLink)}&refer=${encodeURIComponent(`https://${location.host}/`)}&cookie=${encodeURIComponent(document.cookie)}`
					},
					tooltip: config.$quark.dom
				}];
				base.showMainDialog(config.base.dom.button[temp.mode].title, base.generateDom(temp.links), config.base.dom.button[temp.mode].footer);
			} else {
				return message.error('提示：<br/>页面错误~');
			}
		},
		getSelectedList() {
			try {
				let selectedList = [];
				let reactDom = document.getElementsByClassName('file-list')[0];
				let reactObj = base.findReact(reactDom);
				let props = reactObj.props;
				if (props) {
					let fileList = props.list || [];
					let selectedKeys = props.selectedRowKeys || [];
					fileList.forEach(function (val) {
						if (selectedKeys.includes(val.fid)) {
							selectedList.push(val);
						}
					});
				}
				return selectedList;
			} catch (e) {
				return [];
			}
		},
		detectPage() {
			let path = location.pathname;
			if (/^\/(list)/.test(path)) return 'home';
			if (/^\/(s|share)\//.test(path)) return 'share';
			return "";
		},
		async initPanLinker() {
			base.registerMenuCommand();
			if (config.base.num === base.getValue('setting_init').code || config.base.license === base.getValue('setting_init').license) {
				this.addButton();
			} else {
				this.addInitButton();
			}
			this.addPageListener();
		},
	};
	/**
	 * UC网盘
	 * @author 油小猴
	 * @author hmjz100
	 */
	let $uc = {
		addPageListener() {
			$doc.on('click', '.pl-button-mode', async function (e) {
				temp.mode = e.currentTarget.dataset.mode;
				if (!temp.mode) return;
				temp.main.getLink();
			});
			$doc.on('click', '.pl-button-save', async function (e) {
				e.preventDefault();
				let selectList = temp.main.getSelectedList();
				if (selectList.length === 0) {
					return message.error('提示：<br/>请勾选要保存到网盘的文件哦~');
				}
				message.info('提示：<br/>因网盘限制，请保存到自己网盘后再去下载哦~');
				await base.sleep(500);
				document.querySelector('.file-info_r').click();
			});
			$doc.on('click', '.listener-api-download.enhance', async function (e) {
				e.preventDefault();
				let o = base._EventFactory(e);
				let $width = o.item.find('.pl-progress-inner');
				let $text = o.item.find('.pl-progress-inner-text');
				let filename = o.link[0].dataset.filename;
				let index = o.link[0].dataset.index;
				let size = Number(o.link[0].dataset.size) || 0;
				let originalHtml = o.link.html();
				base._resetData(index);
				base.get(e.currentTarget.dataset.link, { "User-Agent": config.$uc.api.ua.downloadLink }, 'blob', { filename, index });
				let startTime = Date.now();
				let prevLoaded = 0;
				let prevTime = startTime;
				temp.ins[index] = setInterval(async function () {
					let prog = +temp.progress[index] || 0;
					let currentTime = Date.now();
					let elapsedTime = currentTime - startTime;
					let loaded = prog * size / 100;
					let timeDiff = Math.max(currentTime - prevTime, 1); // 避免除零
					let speed = ((loaded - prevLoaded) / (timeDiff / 1000)) || 0;
					// 计算剩余时间（保护除零）
					let totalProgress = Math.max(prog / 100, 0.01);
					let totalElapsedSeconds = elapsedTime / 1000;
					let estTotalTime = totalElapsedSeconds / totalProgress;
					let remainingTime = estTotalTime - totalElapsedSeconds;
					// 更新界面状态
					o.link.hide();
					o.directLink.hide();
					o.tip.hide();
					o.stop.show();
					o.copy.hide();
					o.progress.show();
					// 更新进度条
					$width.css('width', `${prog}%`);
					$text.text(`${prog.toFixed(2)}% | 速度:${base.sizeFormat(speed)} | 剩余:${base.rtimeFormat(remainingTime)}`);
					// 更新历史值
					prevLoaded = loaded;
					prevTime = currentTime;
					// 下载完成
					if (prog >= 100) {
						await base.sleep(1000);
						clearInterval(temp.ins[index]);
						temp.progress[index] = 0;
						o.item.find('.pl-progress-stop').hide();
						$text.text('下载完成~ 浏览器下载框应该弹出来了哦~');
						o.back.show();
						await base.sleep(3000);
						o.link.html(originalHtml).animate({ opacity: '1' }, "slow");
					}
				}, 500);
			});
			$doc.on('click', '.listener-aria2-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToAria2(target.data("link"), target.data("filename"), [`User-Agent:${config.$uc.api.ua.downloadLink}`, `Referer:https://${location.host}/`, `Cookie:${document.cookie}`]);
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
			$doc.on('click', '.listener-bitcomet-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToBitcomet(target.data("link"), target.data("filename"), { "user_agent": config.$uc.api.ua.downloadLink, "referrer": `https://${location.host}/`, "cookie": document.cookie });
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
			$doc.on('click', '.listener-abdm-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToABDM(target.data("link"), target.data("filename"), { "User-Agent": config.$uc.api.ua.downloadLink, "Cookie": document.cookie });
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
		},
		greenerPage() {
			base.waitForKeyElements('[class*="VideoDetail--content-footer"]', function (tag) {
				tag.children().each(function () {
					let $child = $(this);
					if ($child.text().includes('手机客户端')) {
						$child.hide();
					}
				});
			}, true);
			base.waitForKeyElements('[class*="PCLandingBanner--ad-block"]', function (tag) {
				tag.hide();
			}, true);
		},
		beautifyPage() {
			if (base.getValue('setting_ui_theme').custom.$uc !== true) return;
			base.adaptiveThemeOverride([
				['#12161a', temp.color],
				['#e6f1ff', `${temp.color}20`],
				['#f0faff', `${temp.color}20`],
				['#7da3ff', `${temp.color}D0`],
				['#ddd', `${temp.color}D0`],
				['17,17,17,.9', base.hexToRgba(`${temp.color}D0`)],
				['40,40,255,.04', base.hexToRgba(`${temp.color}20`)],
				['#f7f7ff', 'transparent'],
				['238,247,255,0', base.hexToRgba(`${temp.color}00`)],
			]);
			base.addStyle(`${mount}-uc`, 'style', `.file-list .hover-oper .hover-transparent-bg{background:transparent!important}`);
		},
		svg: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjIiIGhlaWdodD0iMjIiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGcgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIiBzdHJva2U9IiNGRkZGRkYiIHN0cm9rZS13aWR0aD0iMiI+PHBhdGggc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIiBkPSJNOSAxMmwyIDIgMi0yeiIvPjxwYXRoIGQ9Ik0xNCA4aDEuNTUzYy44NSAwIDEuMTYuMDkzIDEuNDcuMjY3LjMxMS4xNzQuNTU2LjQzLjcyMi43NTYuMTY2LjMyNi4yNTUuNjUuMjU1IDEuNTR2NC44NzNjMCAuODkyLS4wODkgMS4yMTUtLjI1NSAxLjU0LS4xNjYuMzI3LS40MS41ODMtLjcyMi43NTctLjMxLjE3NC0uNjIuMjY3LTEuNDcuMjY3SDYuNDQ3Yy0uODUgMC0xLjE2LS4wOTMtMS40Ny0uMjY3YTEuNzc4IDEuNzc4IDAgMDEtLjcyMi0uNzU2Yy0uMTY2LS4zMjYtLjI1NS0uNjUtLjI1NS0xLjU0di00Ljg3M2MwLS44OTIuMDg5LTEuMjE1LjI1NS0xLjU0LjE2Ni0uMzI3LjQxLS41ODMuNzIyLS43NTcuMzEtLjE3NC42Mi0uMjY3IDEuNDctLjI2N0gxMSIvPjxwYXRoIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIgZD0iTTExIDN2MTAiLz48L2c+PC9zdmc+',
		addButton() {
			base.waitForKeyElements(config.$uc.mount.home, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'home') return;
				let $button = $(`<div class="ant-dropdown-trigger pl-button">
					<button type="button" class="uc-button ant-btn btn-file ant-btn-primary">
						<img class="uc-btn-icon" src="${temp.main.svg}"><span>下载助手</span>
					</button>
					<ul class="pl-dropdown-menu" style="top:39px;">
						<li class="pl-button-mode" data-mode="api"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-downward"/></svg>API 下载</li>
						<li class="pl-button-mode" data-mode="curl"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-plug"/></svg>cURL 下载</li>
						<li class="pl-button-mode" data-mode="aria2"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>Aria2 下载</li>
						<li class="pl-button-mode" data-mode="bitcomet"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>彗星下载</li>
						<li class="pl-button-mode" data-mode="abdm"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>ABDM 下载</li>
						<li class="pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>助手设置</li>
						<li class="pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg>助手美化</li>
						<li class="pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg>更新日志</li>
					</ul>
				</div>`);
				$button.css({ "margin-right": "10px", "display": "inline-block" });
				element.prepend($button);
			})
			base.waitForKeyElements(config.$uc.mount.share, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'share') return;
				let $button = $(`<div class="ant-dropdown-trigger pl-button"><button type="button" class="uc-button ant-btn btn-file ant-btn-primary" style="height:40px;"><img class="uc-btn-icon" src="${temp.main.svg}"><span>下载助手</span></button><ul class="pl-dropdown-menu"><li class="pl-button-mode pl-button-save"><span class="save-btn-icon"></span>保存后下载</li><li class="pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>助手设置</li><li class="pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg>助手美化</li><li class="pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg>更新日志</li></ul></div>`);
				$button.css({ "margin-left": "10px", "display": "inline-block" });
				element.append($button);
			})
		},
		addInitButton() {
			let $button = $(`<div class="ant-dropdown-trigger pl-button-init"><button type="button" class="uc-button ant-btn btn-file ant-btn-primary" style="height:40px;"><img class="uc-btn-icon" src="${temp.main.svg}"><span>点我点亮</span></button></div>`);
			$button.click(base.showInitDialog);
			base.waitForKeyElements(config.$uc.mount.home, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || temp.page !== 'home') return;
				$button.css({ "margin-right": "10px", "display": "inline-block" });
				element.prepend($button);
			})
			base.waitForKeyElements(config.$uc.mount.share, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || temp.page !== 'share') return;
				$button.css({ "margin-left": "10px", "display": "inline-block" });
				element.append($button);
			})
		},
		async getLink() {
			Swal.fire({
				...temp.swalDefault,
				showConfirmButton: false,
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: false,
				title: "获取中",
				html: `...`,
				footer: "如果选的文件较多，请耐心等待获取完成哦！",
				customClass: {
					popup: 'loading-popup',
					header: 'loading-header',
					title: 'loading-title',
					content: 'loading-content',
					input: 'loading-input',
					footer: 'loading-footer'
				},
				willOpen: function () {
					Swal.showLoading();
				},
			});
			let selectList = this.getSelectedList();
			if (selectList.length === 0) return message.error('提示：<br/>请勾选要下载的文件哦~');
			if (selectList.every(item => !item.file)) return message.error('提示：<br/>请打开文件夹后再勾选文件~');
			if (temp.page === 'home') {
				let data = [];
				let batchSize = 15;
				let processed = 0;
				selectList = selectList.filter(item => item.file === true)
				for (let i = 0; i < selectList.length; i += batchSize) {
					// 获取当前批次文件
					let batch = selectList.slice(i, i + batchSize);
					let fids = batch.map(item => item.fid);
					// 发起请求获取链接
					let res = await base.post(config.$uc.api.getLink, { "fids": fids }, { "User-Agent": config.$uc.api.ua.downloadLink });
					if (res?.code === 31001) {
						return message.error('提示：<br/>请先登录网盘~<br/>代码：' + res.code);
					}
					if (res?.code !== 0) {
						return message.error('提示：<br/>获取链接失败了~<br/>代码：' + res.code);
					}
					// 合并响应数据
					if (res?.data) {
						data.push(...res.data);
					}
					// 更新处理进度
					processed += batch.length;
					// 更新UI显示
					$doc.find('.loading-popup .loading-title').html(`链接获取中`);
					$doc.find('.loading-popup .swal2-html-container').html(`<div>已获取 ${processed} / ${selectList.length} 个链接~</div>`);
					// 请求间隔节流
					await base.sleep(1000);
				}
				temp.links = [data, {
					isFolder: v => v.file === false,
					getFileName: v => v.file_name,
					getFileSize: v => v.size,
					getFileLink: v => v.download_url,
					convert: {
						aria2: `--header "User-Agent:${config.$uc.api.ua.downloadLink}" --header "Referer:https://${location.host}/" --header "Cookie:${document.cookie}"`,
						curl: `-A "${config.$uc.api.ua.downloadLink}" -e "https://${location.host}/" -b "${document.cookie}"`,
						bitcomet: `user_agent=${encodeURIComponent(config.$uc.api.ua.downloadLink)}&refer=${encodeURIComponent(`https://${location.host}/`)}&cookie=${encodeURIComponent(document.cookie)}`
					},
					tooltip: config.$uc.dom
				}];
				base.showMainDialog(config.base.dom.button[temp.mode].title, base.generateDom(temp.links), config.base.dom.button[temp.mode].footer);
			} else {
				return message.error('提示：<br/>页面错误~');
			}
		},
		getSelectedList() {
			try {
				let selectedList = [];
				let reactDom = document.getElementsByClassName('file-list')[0];
				let reactObj = base.findReact(reactDom);
				let props = reactObj.props;
				if (props) {
					let fileList = props.list || [];
					let selectedKeys = props.selectedRowKeys || [];
					fileList.forEach(function (val) {
						if (selectedKeys.includes(val.fid)) {
							selectedList.push(val);
						}
					});
				}
				return selectedList;
			} catch (e) {
				return [];
			}
		},
		detectPage() {
			let path = location.pathname;
			if (/^\/(list)/.test(path)) return 'home';
			if (/^\/(s|share)\//.test(path)) return 'share';
			return "";
		},
		async initPanLinker() {
			base.registerMenuCommand();
			if (config.base.num === base.getValue('setting_init').code || config.base.license === base.getValue('setting_init').license) {
				this.addButton();
			} else {
				this.addInitButton();
			}
			this.addPageListener();
		},
	};
	/**
	 * 123云盘
	 * @author 油小猴
	 * @author hmjz100
	 */
	let $123pan = {
		addPageListener() {
			$doc.on('click', '.pl-button-mode', async function (e) {
				temp.mode = e.currentTarget.dataset.mode;
				if (!temp.mode) return;
				temp.main.getLink();
			});
			$doc.on('click', '.listener-api-download.enhance', async function (e) {
				e.preventDefault();
				let o = base._EventFactory(e);
				let $width = o.item.find('.pl-progress-inner');
				let $text = o.item.find('.pl-progress-inner-text');
				let filename = o.link[0].dataset.filename;
				let index = o.link[0].dataset.index;
				let size = Number(o.link[0].dataset.size) || 0;
				let originalHtml = o.link.html();
				base._resetData(index);
				base.get(e.currentTarget.dataset.link, undefined, 'blob', { filename, index });
				let startTime = Date.now();
				let prevLoaded = 0;
				let prevTime = startTime;
				temp.ins[index] = setInterval(async function () {
					let prog = +temp.progress[index] || 0;
					let currentTime = Date.now();
					let elapsedTime = currentTime - startTime;
					let loaded = prog * size / 100;
					let timeDiff = Math.max(currentTime - prevTime, 1); // 避免除零
					let speed = ((loaded - prevLoaded) / (timeDiff / 1000)) || 0;
					// 计算剩余时间（保护除零）
					let totalProgress = Math.max(prog / 100, 0.01);
					let totalElapsedSeconds = elapsedTime / 1000;
					let estTotalTime = totalElapsedSeconds / totalProgress;
					let remainingTime = estTotalTime - totalElapsedSeconds;
					// 更新界面状态
					o.link.hide();
					o.directLink.hide();
					o.tip.hide();
					o.stop.show();
					o.copy.hide();
					o.progress.show();
					// 更新进度条
					$width.css('width', `${prog}%`);
					$text.text(`${prog.toFixed(2)}% | 速度:${base.sizeFormat(speed)} | 剩余:${base.rtimeFormat(remainingTime)}`);
					// 更新历史值
					prevLoaded = loaded;
					prevTime = currentTime;
					// 下载完成
					if (prog >= 100) {
						await base.sleep(1000);
						clearInterval(temp.ins[index]);
						temp.progress[index] = 0;
						o.item.find('.pl-progress-stop').hide();
						$text.text('下载完成~ 浏览器下载框应该弹出来了哦~');
						o.back.show();
						await base.sleep(3000);
						o.link.html(originalHtml).animate({ opacity: '1' }, "slow");
					}
				}, 500);
			});
			$doc.on('click', '.listener-aria2-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToAria2(target.data("link"), target.data("filename"));
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
			$doc.on('click', '.listener-bitcomet-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToBitcomet(target.data("link"), target.data("filename"));
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
			$doc.on('click', '.listener-abdm-download', async function (e) {
				let target = $(e.currentTarget);
				if (target.attr('data-processing') === 'true') return;
				target.attr('data-processing', 'true');
				let originalHtml = target.html();
				target.find(".pl-icon").remove();
				target.find('.pl-loading').remove();
				target.prepend(base.createLoading());
				let res = await base.sendLinkToABDM(target.data("link"), target.data("filename"), undefined);
				if (res === 'success') {
					target.removeClass('pl-btn-danger').html('发送成功啦!快去看看吧~').animate({ opacity: '0.5' }, "slow");
				} else {
					target.addClass('pl-btn-danger').text('发送失败，检查一下您的配置信息哦!').animate({ opacity: '0.5' }, "slow");
				}
				await base.sleep(3000);
				target.removeClass('pl-btn-danger').removeAttr('data-processing').html(originalHtml).css('opacity', "");
			});
		},
		greenerPage() {
			// 旧版 分享 登录按钮
			base.waitForKeyElements(".cent > .cent-not-login > .ant-btn", (tag) => {
				if (tag.hasClass("reg") || tag.hasClass("log")) return;
				tag.addClass("reg");
				tag.removeClass("loginRight");
				tag.find("span").text("注册");
				if (tag.next().hasClass("log")) return;
				let button = $(`<button type="button" class="ant-btn ant-btn-default ant-btn-two-chinese-chars log loginRight" style="width:auto!important;height:auto!important;margin-left:10px!important"><span>登录</span></button>`);
				button.on("click", () => {
					let login = new URL(`https://login.123pan.com/centerlogin`);
					login.searchParams.set("redirect_url", location.href);
					location.href = login;
				});
				tag.after(button);
			});
			// 旧版 分享 按钮去除文本
			base.waitForKeyElements(`.rightInfo .register:not(.pl-button, .pl-button-init),
				.homeClass > div > .ant-dropdown-trigger:not(.pl-button, .pl-button-init),
				.homeClass > div > .sysbut`, function (tag) {
				let hasTextNode = false;
				tag.contents().each(function () {
					if (this.nodeType === 3 && $.trim(this.textContent)) {
						hasTextNode = true;
						return;
					}
				});
				if (!hasTextNode) return;
				tag.css({ "width": "38px" });
				tag.contents().each(function () {
					if (this.nodeType === 3) {
						$(this).remove();
					}
				});
				tag.find('svg').css({ "margin-right": "0" });
			});
			// 新版 分享 登录按钮
			base.waitForKeyElements(".share-header_center > .share-header_center-not-login > .ant-btn", (tag) => {
				if (tag.hasClass("reg") || tag.hasClass("log")) return;
				tag.removeClass("ant-btn-variant-solid").addClass("ant-btn-variant-outlined");
				tag.addClass("ant-btn-two-chinese-chars").addClass("reg");
				tag.find("span").text("注册");
				if (tag.next().hasClass("log")) return;
				let button = $(`<button type="button" class="ant-btn ${[...document.querySelector('[class*="ant-btn css-"]').classList].find(c => /^css-[a-z0-9]+$/.test(c))} ant-btn-primary ant-btn-color-primary ant-btn-variant-solid loginRight mfy-button ant-btn-two-chinese-chars log" style="margin-left:10px!important"><span>登录</span></button>`);
				// 加个跳转到原页面也不难吧？
				button.on("click", () => {
					let login = new URL(`https://login.123pan.com/centerlogin`);
					login.searchParams.set("redirect_url", location.href);
					location.href = login;
				});
				tag.after(button);
				try {
					let container = tag.closest('.share-header_center-not-login');
					if (container.length && !container.data('logObserverAttached')) {
						container.data('logObserverAttached', true);
						let observer = new MutationObserver((mutations) => {
							for (let m of mutations) {
								if (!m.removedNodes) continue;
								for (let n of m.removedNodes) {
									if (!(n instanceof HTMLElement)) continue;
									// 如果被移除的节点是注册按钮或其包含注册按钮的容器，则清理登录按钮
									if (n.classList && (n.classList.contains('reg') || n.querySelector && n.querySelector('.reg'))) {
										try { container.find('.log').remove(); } catch (e) { }
									}
								}
							}
						});
						observer.observe(container[0], { childList: true, subtree: true });
						container.data('logObserver', observer);
					}
				} catch (e) { }
			});
			// 新版 分享 超限登录
			base.waitForKeyElements(".login-footer-240828", (tag) => {
				if (tag.find(".replaced").length) return;
				tag.children().each(function () {
					let $child = $(this);
					if ($child.hasClass("pointer-text")) {
						let button = $(`<button type="button" class="ant-btn ${[...document.querySelector('[class*="ant-btn css-"]').classList].find(c => /^css-[a-z0-9]+$/.test(c))} ant-btn-primary ant-btn-color-primary ant-btn-variant-solid loginRight mfy-button replaced"><span>${$child.text()}</span></button>`);
						button.on("click", () => {
							if ($child.text().includes("登录")) {
								let login = new URL(`https://login.123pan.com/centerlogin`);
								login.searchParams.set("redirect_url", location.href);
								location.href = login;
							} else {
								return $child.click();
							}
						});
						$child.after(button);
						$child.hide();
					}
				});
			}, true);
			// 旧版 主页 播放器会员广告
			base.waitForKeyElements(".new-menu-item-image, .special-menu-item-container-migration--label, .sider-member-btn, .video-new-user-tips", (tag) => {
				if (tag.is(":hidden")) return;
				tag.hide();
			}, true);
			// 新版 主页 顶栏会员广告
			base.waitForKeyElements('.frontend-layout-header-right > span > [alt^="buttonMall"]', (tag) => {
				if (tag.parent().is(":hidden")) return;
				tag.parent().hide();
				let button = $(`<div class="frontend-layout-header-right-button-invite-new">会员中心</div>`);
				button.on("click", () => { tag.click() });
				tag.parent().after(button);
			}, true);
			// 分享 手机二维码
			base.waitForKeyElements('.rightInfo .qrcode_btn', function (tag) {
				tag.hide();
			}, true);
			// 为页面主动添加 notoken 参数（token 太长影响观感，故不添加），以避免被新版页面屎山代码搞得二次刷新
			setInterval(() => {
				let url = new URL(location);
				if (!url.searchParams.has('notoken') && !url.searchParams.has('token')) {
					url.searchParams.delete('token');
					url.searchParams.set('notoken', '1');
					history.replaceState({}, "", url);
				}
			}, 500)
		},
		beautifyPage() {
			if (base.getValue('setting_ui_theme').custom.$123pan !== true) return;
			base.adaptiveThemeOverride([
				['#597dfc', temp.color],
				['#5a7cfc', temp.color],
				['#2A82E4', temp.color],
				['#51a1f0', temp.color],
				['#597DFC', temp.color],
				['#40a9ff', temp.color],
				['#3c80ff', temp.color],
				['#3C80FF', temp.color],
				['#1677ff', temp.color],
				['#1890ff', temp.color],
				['#0958d9', temp.color],
				['#F0F8FF', `${temp.color}10`],
				['#f0f9ff', `${temp.color}20`],
				['#F2F5FF', `${temp.color}20`],
				['#C5E1FF', `${temp.color}20`],
				['#2961D9', `${temp.color}20`],
				['#b8d8ff', `${temp.color}20`],
				['#325cf0', `${temp.color}D0`],
				['#66A1FF', `${temp.color}D0`],
				['#69b1ff', `${temp.color}D0`],
				['60, 128, 255', base.hexToRgba(temp.color)],
				['42, 130, 228', base.hexToRgba(temp.color)],
				['89, 125, 252', base.hexToRgba(temp.color)],
			]);
		},
		getToken() {
			$doc.find('.loading-popup .loading-title').html(`令牌获取中`);
			$doc.find('.loading-popup .swal2-html-container').html(`<div>正在获取令牌~</div>`);
			let token = base.getStorage("authorToken");
			return token;
		},
		async getLink() {
			Swal.fire({
				...temp.swalDefault,
				showConfirmButton: false,
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: false,
				title: "获取中",
				html: `...`,
				footer: "如果选的文件较多，请耐心等待获取完成哦！",
				customClass: {
					popup: 'loading-popup',
					header: 'loading-header',
					title: 'loading-title',
					content: 'loading-content',
					input: 'loading-input',
					footer: 'loading-footer'
				},
				willOpen: function () {
					Swal.showLoading();
				},
			});
			let selectList = this.getSelectedList();
			if (selectList.length === 0) return message.error('提示：<br/>请勾选要下载的文件哦~');
			if (selectList.every(item => item.Type !== 0)) return message.error('提示：<br/>请打开文件夹后再勾选文件~');
			if (temp.page === 'home') {
				let token = this.getToken();
				let batchSize = 15;
				let processed = 0;
				selectList = selectList.filter(item => item.Type === 0);
				for (let i = 0; i < selectList.length; i += batchSize) {
					let batch = selectList.slice(i, i + batchSize);
					let queue = [];
					$doc.find('.loading-popup .loading-title').html(`链接获取中`);
					$doc.find('.loading-popup .swal2-html-container').html(`<div>正在获取文件对应的下载链接~</div>`);
					batch.forEach((item, localIndex) => {
						let globalIndex = i + localIndex;
						queue.push(this.getFileUrlByOnce(item, globalIndex, token)
							.then(val => {
								processed++;
								$doc.find('.loading-popup .swal2-html-container').html(`<div>已获取 ${processed} / ${selectList.length} 个链接~</div>`);
								return val;
							}));
					});
					let res = await Promise.all(queue);
					res.forEach(val => {
						selectList[val.index].DownloadUrl = val.downloadUrl;
					});
					await base.sleep(1000);
				}
				temp.links = [selectList, {
					isFolder: v => v.Type !== 0,
					getFileName: v => v.FileName,
					getFileSize: v => v.Size,
					getFileLink: v => v.DownloadUrl || v.DownloadURL,
					tooltip: config.$123pan.dom
				}]
				base.showMainDialog(config.base.dom.button[temp.mode].title, base.generateDom(temp.links), config.base.dom.button[temp.mode].footer);
			} else if (temp.page === 'share') {
				let token = this.getToken();
				let batchSize = 15;
				let processed = 0;
				selectList = selectList.filter(item => item.Type === 0);
				let pathSplit = location.pathname.split('/').filter(Boolean);
				let ShareKey = pathSplit[1];
				for (let i = 0; i < selectList.length; i += batchSize) {
					let batch = selectList.slice(i, i + batchSize);
					let queue = [];
					$doc.find('.loading-popup .loading-title').html(`链接获取中`);
					$doc.find('.loading-popup .swal2-html-container').html(`<div>正在获取文件对应的下载链接~</div>`);
					batch.forEach((item, localIndex) => {
						let globalIndex = i + localIndex;
						queue.push(this.getFileUrlByOnce(item, globalIndex, token, ShareKey)
							.then(val => {
								processed++;
								$doc.find('.loading-popup .swal2-html-container').html(`<div>已获取 ${processed} / ${selectList.length} 个链接~</div>`);
								return val;
							}));
					});
					let res = await Promise.all(queue);
					res.forEach(val => {
						selectList[val.index].DownloadUrl = val.downloadUrl;
					});
					await base.sleep(1000);
				}
				temp.links = [selectList, {
					isFolder: v => v.Type !== 0,
					getFileName: v => v.FileName,
					getFileSize: v => v.Size,
					getFileLink: v => v.DownloadUrl || v.DownloadURL,
					tooltip: config.$123pan.dom
				}]
				base.showMainDialog(config.base.dom.button[temp.mode].title, base.generateDom(temp.links), config.base.dom.button[temp.mode].footer);
			} else {
				return message.error('提示：<br/>页面错误~');
			}
		},
		async getFileUrlByOnce(item, index, token, ShareKey) {
			let res = null;
			if (ShareKey) {
				res = await base.post(config.$123pan.api.getShareLink, { "ShareKey": ShareKey, "FileID": item.FileId, "S3keyFlag": item.S3KeyFlag, "Size": item.Size, "Etag": item.Etag }, { "Authorization": `Bearer ${token}`, "Platform": "ios" }); // 高贵的苹果思维，苹果脚本，苹果请求，安卓苹果（狗头
			} else {
				res = await base.post(config.$123pan.api.getLink, { "driveId": 0, "etag": item.Etag, "fileId": item.FileId, "s3keyFlag": item.S3KeyFlag, "type": item.Type, "fileName": item.FileName, "size": item.Size }, { "Authorization": `Bearer ${token}`, "Platform": "ios" }); // 高贵的苹果思维，苹果脚本，苹果请求，安卓苹果（狗头
			}
			if (res.data?.DownloadUrl || res.data?.DownloadURL) {
				let url = res.data.DownloadUrl ? res.data.DownloadUrl : res.data?.DownloadURL;
				let surl = new URL(url).searchParams.get("params");
				if (surl) url = base.decodeBase(surl);
				// url = await base.getFinalUrl(url);
				return {
					index,
					downloadUrl: url
				};
			} else if (res?.code === 5112) {
				return message.error('提示：<br/>请先登录网盘后再获取链接呢~');
			} else {
				return {
					index,
					downloadUrl: '获取下载地址失败，刷新后再试试吧~'
				};
			}
		},
		getSelectedList() {
			try {
				let selectedList = [];
				let reactDom = $(".ant-table-wrapper, .tiled-list, .file-list")[0];
				let reactObj = base.findReact(reactDom);
				let props = reactObj.pendingProps;
				if (props) {
					let fileList = props?.dataSource || props?.loadedFileList || props?.files || [];
					let selectedKey = props?.rowSelection?.selectedRowKeys || [];
					fileList.forEach(function (val) {
						if (val?.checked === true) {
							selectedList.push(val);
						} else if (selectedKey.includes(val.FileId)) {
							selectedList.push(val);
						}
					});
				}
				return selectedList;
			} catch (e) {
				return [];
			}
		},
		addButton() {
			base.waitForKeyElements(config.$123pan.mount.home, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'home') return;
				let $button = $(`<button type="button" class="ant-btn ${[...document.querySelector('[class*="css-dev-only-do-not-override-"]').classList].find(c => /^css-dev-only-do-not-override-[a-z0-9]+$/.test(c))} ant-btn-primary ant-btn-color-primary ant-btn-variant-solid ant-dropdown-trigger mfy-button upload-button pl-button color-button" style="user-select: text !important;">
					<svg class="icon home-operator-icon-upload" aria-hidden="true"><use xlink:href="#general_download_16_1"></use></svg>
					<span>下载助手</span>
					<ul class="pl-dropdown-menu" style="top:23px">
						<li class="pl-button-mode" data-mode="api"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-downward"/></svg>API 下载</li>
						<li class="pl-button-mode" data-mode="curl"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-plug"/></svg>cURL 下载</li>
						<li class="pl-button-mode" data-mode="aria2"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>Aria2 下载</li>
						<li class="pl-button-mode" data-mode="bitcomet"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>彗星下载</li>
						<li class="pl-button-mode" data-mode="abdm"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>ABDM 下载</li>
						<li class="pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>助手设置</li>
						<li class="pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg>助手美化</li>
						<li class="pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg>更新日志</li>
					</ul>
				</button>`);
				element.prepend($button);
			})
			base.waitForKeyElements(config.$123pan.mount.share, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'share') return;
				let $button = $(`<div class="register pl-button color-button">
					<svg class="icon" aria-hidden="true" style="color:rgb(255, 255, 255);margin-right:5px;"><use xlink:href="#top_btn_download2"></use></svg>下载助手
					<ul class="pl-dropdown-menu" style="top:37px">
						<li class="pl-button-mode" data-mode="api"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-downward"/></svg>API 下载</li>
						<li class="pl-button-mode" data-mode="curl"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-plug"/></svg>cURL 下载</li>
						<li class="pl-button-mode" data-mode="aria2"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>Aria2 下载</li>
						<li class="pl-button-mode" data-mode="bitcomet"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>彗星下载</li>
						<li class="pl-button-mode" data-mode="abdm"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>ABDM 下载</li>
						<li class="pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>助手设置</li>
						<li class="pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg>助手美化</li>
						<li class="pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg>更新日志</li>
					</ul>
				</div>`);
				$button.css({ "width": "100px" });
				element.append($button);
			})
			base.waitForKeyElements(config.$123pan.mount.shareNew, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button").length > 0 || !temp.page || temp.page !== 'share') return;
				let $button = $(`<button type="button" class="ant-btn ${[...document.querySelector('[class*="ant-btn css-"]').classList].find(c => /^css-[a-z0-9]+$/.test(c))} ant-btn-primary ant-btn-color-primary ant-btn-variant-solid mfy-button pl-button color-button" style="user-select: text !important;">
					<svg class="icon" aria-hidden="true" style="color: rgb(255, 255, 255);"><use xlink:href="#general_download_16_1"></use></svg>
					<span>下载助手</span>
					<ul class="pl-dropdown-menu" style="top:20px">
						<li class="pl-button-mode" data-mode="api"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-downward"/></svg>API 下载</li>
						<li class="pl-button-mode" data-mode="curl"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-plug"/></svg>cURL 下载</li>
						<li class="pl-button-mode" data-mode="aria2"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>Aria2 下载</li>
						<li class="pl-button-mode" data-mode="bitcomet"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>彗星下载</li>
						<li class="pl-button-mode" data-mode="abdm"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-cloud-arrow-down"/></svg>ABDM 下载</li>
						<li class="pl-button-mode listener-open-setting"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-gear"/></svg>助手设置</li>
						<li class="pl-button-mode listener-open-beautify"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-palette"/></svg>助手美化</li>
						<li class="pl-button-mode listener-open-updatelog"><svg class="pl-icon"><use xlink:href="#pl-icon-fa-newspaper"/></svg>更新日志</li>
					</ul>
				</button>`);
				element.append($button);
			})
		},
		addInitButton() {
			base.waitForKeyElements(config.$123pan.mount.home, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || temp.page !== 'home') return;
				let $button = $(`<button type="button" class="ant-btn ${[...document.querySelector('[class*="css-dev-only-do-not-override-"]').classList].find(c => /^css-dev-only-do-not-override-[a-z0-9]+$/.test(c))} ant-btn-primary ant-btn-color-primary ant-btn-variant-solid ant-dropdown-trigger mfy-button upload-button pl-button-init color-button" style="user-select: text !important;">
					<svg class="icon home-operator-icon-upload" aria-hidden="true"><use xlink:href="#general_download_16_1"></use></svg>
					<span>点我点亮</span>
				</button>`);
				$button.click(base.showInitDialog);
				element.prepend($button);
			})
			base.waitForKeyElements(config.$123pan.mount.share, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || temp.page !== 'share') return;
				let $button = $(`<div class="register pl-button-init color-button">
					<svg class="icon" aria-hidden="true" style="color:rgb(255, 255, 255);margin-right:5px;"><use xlink:href="#top_btn_download2"></use></svg>点我点亮
				</div>`);
				$button.click(base.showInitDialog);
				$button.css({ "width": "100px" });
				element.append($button);
			})
			base.waitForKeyElements(config.$123pan.mount.shareNew, (element) => {
				temp.page = temp.main.detectPage();
				if ($(".pl-button-init").length > 0 || !temp.page || temp.page !== 'share') return;
				let $button = $(`<button type="button" class="ant-btn ${[...document.querySelector('[class*="ant-btn css-"]').classList].find(c => /^css-[a-z0-9]+$/.test(c))} ant-btn-primary ant-btn-color-primary ant-btn-variant-solid mfy-button pl-button-init color-button" style="user-select: text !important;">
					<svg class="icon" aria-hidden="true" style="color: rgb(255, 255, 255);"><use xlink:href="#general_download_16_1"></use></svg>
					<span>点我点亮</span>
				</button>`);
				$button.click(base.showInitDialog);
				element.append($button);
			})
		},
		detectPage() {
			let path = location.pathname;
			if (/^\/$/.test(path)) return 'home';
			if (/^\/s\//.test(path)) return 'share';
			return "";
		},
		async initPanLinker() {
			base.registerMenuCommand();
			if (config.base.num === base.getValue('setting_init').code || config.base.license === base.getValue('setting_init').license) {
				this.addButton();
			} else {
				this.addInitButton();
			}
			this.addPageListener();
		},
	};
	// 主代码
	let main = {
		async init() {
			/**
			 * 控制台输出
			 * @author 油小猴
			 * @author hmjz100
			 * @description 来自【网盘智能识别助手】，有改动
			 */
			console.log(`%c %c LinkSwift\n一个基于 JavaScript 的网盘文件下载地址获取工具\n仓库：https://github.com/hmjz100/LinkSwift\n版本：${info.version}\n领域：${(window.self !== window.top ? "[iframe] " : "") + (document.title ? (document.title + " (" + location.origin + location.pathname + ")") : location.href)}`, `background:url(${info.icon}) center center no-repeat;background-size:12px;padding:3px`, `padding:2px`);
			// 创建挂载点
			let mountElem = $(`<${mount} class="${mount}" />`);
			temp.mount = mountElem;

			base.waitForKeyElements(`html:not(:has(> .${mount})) head`, (element) => {
				if ($(`.${mount}`).length > 0) return;
				element.after(temp.mount);
			})
			
			// 判断页面地址，定义主执行
			if (/(pan|yun).baidu.com/.test(location.host)) temp.main = $baidu;
			else if (/openapi.baidu.com\/oauth/.test(location.href)) temp.main = $baiduAuthorize;
			else if (/www.(aliyundrive|alipan).com/.test(location.host)) temp.main = $aliyun;
			else if (/(yun|caiyun).139.com/.test(location.host)) temp.main = $mcloud;
			else if (/cloud.189.cn/.test(location.host)) temp.main = $tcloud;
			else if (/pan.xunlei.com/.test(location.host)) temp.main = $xunlei;
			else if (/pan.quark.cn/.test(location.host)) temp.main = $quark;
			else if (/drive.uc.cn/.test(location.host)) temp.main = $uc;
			else if (/(www|login).(123(pan|684|865|952|912).com|123pan.cn)/.test(location.host)) temp.main = $123pan;
			
			// 智能默认设置
			base.initDefaultConfig();
			// 创建美化样式
			base.addPanLinkerStyle();
			// 创建按钮事件
			base.addPageListener();
			// 创建提示信息用的隐藏 tip
			base.createTip();
			// 创建下载用的隐藏 iframe
			base.createIframe();

			// 运行主程序
			if ('initPanLinker' in temp.main) temp.main.initPanLinker();
			// 运行绿化程序
			if ('greenerPage' in temp.main) temp.main.greenerPage();

			// 脚本更新后提示消息
			let storedVersion = base.getValue("setting_init").version;
			if (!storedVersion || base.isNewerVersion(info.version, storedVersion)) {
				base.waitForKeyElements("body:not(.swal2-shown)", async () => {
					await base.showUpdate();
					let list = base.getValue("setting_init");
					list.version = info.version;
					base.setValue("setting_init", list);
					return true;
				}, true);
			}
			// 创建图标
			temp.mount.append(`<svg aria-hidden="true" style="position: absolute; width: 0px; height: 0px; overflow: hidden;">
				<symbol id="pl-icon-fa-downward" viewBox="0 0 512 512">
					<path d="M425.199,223.957c-13.303-13.303-34.961-13.303-48.205-0.06l-86.861,85.086V34.133C290.133,15.309,274.824,0,256,0 s-34.133,15.309-34.133,34.133v274.867l-86.801-85.052c-13.312-13.312-34.961-13.312-48.273,0 c-13.312,13.312-13.303,34.97,0,48.273c0.017,0.017,0.034,0.026,0.043,0.043l148.361,146.5c5.726,5.658,13.227,8.482,20.727,8.482 c7.543,0,15.078-2.859,20.787-8.568L425.199,272.23c6.451-6.443,10.001-15.019,10.001-24.132S431.65,230.409,425.199,223.957z"></path>
					<path d="M401.067,443.733H110.933c-18.825,0-34.133,15.309-34.133,34.133S92.109,512,110.933,512h290.133 c18.825,0,34.133-15.309,34.133-34.133S419.883,443.733,401.067,443.733z"></path>
				</symbol>
				<symbol id="pl-icon-fa-plug" viewBox="0 0 384 512">
					<path d="M96 0C78.3 0 64 14.3 64 32l0 96 64 0 0-96c0-17.7-14.3-32-32-32zM288 0c-17.7 0-32 14.3-32 32l0 96 64 0 0-96c0-17.7-14.3-32-32-32zM32 160c-17.7 0-32 14.3-32 32s14.3 32 32 32l0 32c0 77.4 55 142 128 156.8l0 67.2c0 17.7 14.3 32 32 32s32-14.3 32-32l0-67.2C297 398 352 333.4 352 256l0-32c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 160z"></path>
				</symbol>
				<symbol id="pl-icon-fa-cloud-arrow-down" viewBox="0 0 640 512">
					<path d="M144 480C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96c0 12.2-2.3 23.8-6.4 34.6C596 238.4 640 290.1 640 352c0 70.7-57.3 128-128 128l-368 0zm79-167l80 80c9.4 9.4 24.6 9.4 33.9 0l80-80c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-39 39L344 184c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 134.1-39-39c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9z"></path>
				</symbol>
				<symbol id="pl-icon-fa-gear" viewBox="0 0 512 512">
					<path d="M495.9 166.6c3.2 8.7 .5 18.4-6.4 24.6l-43.3 39.4c1.1 8.3 1.7 16.8 1.7 25.4s-.6 17.1-1.7 25.4l43.3 39.4c6.9 6.2 9.6 15.9 6.4 24.6c-4.4 11.9-9.7 23.3-15.8 34.3l-4.7 8.1c-6.6 11-14 21.4-22.1 31.2c-5.9 7.2-15.7 9.6-24.5 6.8l-55.7-17.7c-13.4 10.3-28.2 18.9-44 25.4l-12.5 57.1c-2 9.1-9 16.3-18.2 17.8c-13.8 2.3-28 3.5-42.5 3.5s-28.7-1.2-42.5-3.5c-9.2-1.5-16.2-8.7-18.2-17.8l-12.5-57.1c-15.8-6.5-30.6-15.1-44-25.4L83.1 425.9c-8.8 2.8-18.6 .3-24.5-6.8c-8.1-9.8-15.5-20.2-22.1-31.2l-4.7-8.1c-6.1-11-11.4-22.4-15.8-34.3c-3.2-8.7-.5-18.4 6.4-24.6l43.3-39.4C64.6 273.1 64 264.6 64 256s.6-17.1 1.7-25.4L22.4 191.2c-6.9-6.2-9.6-15.9-6.4-24.6c4.4-11.9 9.7-23.3 15.8-34.3l4.7-8.1c6.6-11 14-21.4 22.1-31.2c5.9-7.2 15.7-9.6 24.5-6.8l55.7 17.7c13.4-10.3 28.2-18.9 44-25.4l12.5-57.1c2-9.1 9-16.3 18.2-17.8C227.3 1.2 241.5 0 256 0s28.7 1.2 42.5 3.5c9.2 1.5 16.2 8.7 18.2 17.8l12.5 57.1c15.8 6.5 30.6 15.1 44 25.4l55.7-17.7c8.8-2.8 18.6-.3 24.5 6.8c8.1 9.8 15.5 20.2 22.1 31.2l4.7 8.1c6.1 11 11.4 22.4 15.8 34.3zM256 336a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"></path>
				</symbol>
				<symbol id="pl-icon-fa-palette" viewBox="0 0 512 512">
					<path d="M512 256c0 .9 0 1.8 0 2.7c-.4 36.5-33.6 61.3-70.1 61.3L344 320c-26.5 0-48 21.5-48 48c0 3.4 .4 6.7 1 9.9c2.1 10.2 6.5 20 10.8 29.9c6.1 13.8 12.1 27.5 12.1 42c0 31.8-21.6 60.7-53.4 62c-3.5 .1-7 .2-10.6 .2C114.6 512 0 397.4 0 256S114.6 0 256 0S512 114.6 512 256zM128 288a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm96 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"></path>
				</symbol>
				<symbol id="pl-icon-fa-newspaper" viewBox="0 0 512 512">
					<path d="M96 96c0-35.3 28.7-64 64-64l288 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L80 480c-44.2 0-80-35.8-80-80L0 128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 272c0 8.8 7.2 16 16 16s16-7.2 16-16L96 96zm64 24l0 80c0 13.3 10.7 24 24 24l112 0c13.3 0 24-10.7 24-24l0-80c0-13.3-10.7-24-24-24L184 96c-13.3 0-24 10.7-24 24zm208-8c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zm0 96c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zM160 304c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-256 0c-8.8 0-16 7.2-16 16zm0 96c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-256 0c-8.8 0-16 7.2-16 16z"></path>
				</symbol>
				<symbol id="pl-icon-fa-cloud-arrow-up" viewBox="0 0 640 512">
					<path d="M144 480C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96c0 12.2-2.3 23.8-6.4 34.6C596 238.4 640 290.1 640 352c0 70.7-57.3 128-128 128l-368 0zm79-217c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l39-39L296 392c0 13.3 10.7 24 24 24s24-10.7 24-24l0-134.1 39 39c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-80-80c-9.4-9.4-24.6-9.4-33.9 0l-80 80z"></path>
				</symbol>
				<symbol id="pl-icon-fa-copy" viewBox="0 0 448 512">
					<path d="M208 0L332.1 0c12.7 0 24.9 5.1 33.9 14.1l67.9 67.9c9 9 14.1 21.2 14.1 33.9L448 336c0 26.5-21.5 48-48 48l-192 0c-26.5 0-48-21.5-48-48l0-288c0-26.5 21.5-48 48-48zM48 128l80 0 0 64-64 0 0 256 192 0 0-32 64 0 0 48c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 176c0-26.5 21.5-48 48-48z"></path>
				</symbol>
				<symbol id="pl-icon-fa-check" viewBox="0 0 448 512">
					<path d="M438.6 105.4c12.5 12.5 12.5 32.8 0 45.3l-256 256c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L160 338.7 393.4 105.4c12.5-12.5 32.8-12.5 45.3 0z"></path>
				</symbol>
				<symbol id="pl-icon-fa-list-check" viewBox="0 0 512 512">
					<path d="M152.1 38.2c9.9 8.9 10.7 24 1.8 33.9l-72 80c-4.4 4.9-10.6 7.8-17.2 7.9s-12.9-2.4-17.6-7L7 113C-2.3 103.6-2.3 88.4 7 79s24.6-9.4 33.9 0l22.1 22.1 55.1-61.2c8.9-9.9 24-10.7 33.9-1.8zm0 160c9.9 8.9 10.7 24 1.8 33.9l-72 80c-4.4 4.9-10.6 7.8-17.2 7.9s-12.9-2.4-17.6-7L7 273c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l22.1 22.1 55.1-61.2c8.9-9.9 24-10.7 33.9-1.8zM224 96c0-17.7 14.3-32 32-32l224 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-224 0c-17.7 0-32-14.3-32-32zm0 160c0-17.7 14.3-32 32-32l224 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-224 0c-17.7 0-32-14.3-32-32zM160 416c0-17.7 14.3-32 32-32l288 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-288 0c-17.7 0-32-14.3-32-32zM48 368a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"></path>
				</symbol>
				<symbol id="pl-icon-fa-x-mark" viewBox="0 0 384 512">
					<path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"></path>
				</symbol>
				<symbol id="pl-icon-fa-unlock-keyhole" viewBox="0 0 448 512">
					<path d="M224 64c-44.2 0-80 35.8-80 80l0 48 240 0c35.3 0 64 28.7 64 64l0 192c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 256c0-35.3 28.7-64 64-64l16 0 0-48C80 64.5 144.5 0 224 0c57.5 0 107 33.7 130.1 82.3c7.6 16 .8 35.1-15.2 42.6s-35.1 .8-42.6-15.2C283.4 82.6 255.9 64 224 64zm32 320c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0z"></path>
				</symbol>
				<symbol id="pl-icon-fa-star" viewBox="0 0 576 512">
					<path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"></path>
				</symbol>
				<symbol id="pl-icon-fa-link" viewBox="0 0 640 512">
					<path d="M579.8 267.7c56.5-56.5 56.5-148 0-204.5c-50-50-128.8-56.5-186.3-15.4l-1.6 1.1c-14.4 10.3-17.7 30.3-7.4 44.6s30.3 17.7 44.6 7.4l1.6-1.1c32.1-22.9 76-19.3 103.8 8.6c31.5 31.5 31.5 82.5 0 114L422.3 334.8c-31.5 31.5-82.5 31.5-114 0c-27.9-27.9-31.5-71.8-8.6-103.8l1.1-1.6c10.3-14.4 6.9-34.4-7.4-44.6s-34.4-6.9-44.6 7.4l-1.1 1.6C206.5 251.2 213 330 263 380c56.5 56.5 148 56.5 204.5 0L579.8 267.7zM60.2 244.3c-56.5 56.5-56.5 148 0 204.5c50 50 128.8 56.5 186.3 15.4l1.6-1.1c14.4-10.3 17.7-30.3 7.4-44.6s-30.3-17.7-44.6-7.4l-1.6 1.1c-32.1 22.9-76 19.3-103.8-8.6C74 372 74 321 105.5 289.5L217.7 177.2c31.5-31.5 82.5-31.5 114 0c27.9 27.9 31.5 71.8 8.6 103.9l-1.1 1.6c-10.3 14.4-6.9 34.4 7.4 44.6s34.4 6.9 44.6-7.4l1.1-1.6C433.5 260.8 427 182 377 132c-56.5-56.5-148-56.5-204.5 0L60.2 244.3z"></path>
				</symbol>
				<symbol id="pl-icon-si-tampermonkey" viewBox="0 0 24 24">
					<path d="M5.955.002C3-.071.275 2.386.043 5.335c-.069 3.32-.011 6.646-.03 9.969.06 1.87-.276 3.873.715 5.573 1.083 2.076 3.456 3.288 5.77 3.105 4.003-.011 8.008.022 12.011-.017 2.953-.156 5.478-2.815 5.482-5.772-.007-4.235.023-8.473-.015-12.708C23.82 2.533 21.16.007 18.205.003c-4.083-.005-8.167 0-12.25-.002zm.447 12.683c2.333-.046 4.506 1.805 4.83 4.116.412 2.287-1.056 4.716-3.274 5.411-2.187.783-4.825-.268-5.874-2.341-1.137-2.039-.52-4.827 1.37-6.197a4.896 4.896 0 012.948-.99zm11.245 0c2.333-.046 4.505 1.805 4.829 4.116.413 2.287-1.056 4.716-3.273 5.411-2.188.783-4.825-.268-5.875-2.341-1.136-2.039-.52-4.827 1.37-6.197a4.896 4.896 0 012.949-.99z"/>
				</symbol>
			</svg>`);
		}
	};
	main.init();
	// 这是啥？我不到啊
	function idontknow(input) {
		let charArray = input.split("");
		// 这是 Fisher-Yates 洗牌算法的实现
		for (let i = charArray.length - 1; i > 0; i--) {
			let j = Math.floor(Math.random() * (i + 1));
			[charArray[i], charArray[j]] = [charArray[j], charArray[i]];
		}
		return charArray.join("");
	}
})();