package ice.library.content.item

import arc.graphics.Color
import ice.content.IPlanets
import ice.library.meta.stat.IceStats
import mindustry.type.Item

open class IceItem(name: String, color: String, applys: IceItem.(IceItem) -> Unit = {}) :
    Item(name, Color.valueOf(color)) {
    var nutrientConcentration = 0f

    init {
        applys(this)
    }

    override fun postInit() {
        shownPlanets.add(IPlanets.阿德里)
        super.postInit()
    }

    override fun setStats() {
        super.setStats()
        if (nutrientConcentration > 0) stats.addPercent(IceStats.营养浓度, nutrientConcentration)
        stats.add(IceStats.建造时间花费, cost)
        stats.add(IceStats.建筑血量系数, healthScaling)
        stats.add(IceStats.硬度, "$hardness")
        stats.add(IceStats.是否用于建造, buildable)
    }

}
