Ponder.registry(event => {
    event.create([
        "createdelight:big_centrifuge",
        "createdelight:centrifuge_rotor"
    ])
        .scene(
            "createdelight:big_centrifuge",
            "大型离心机",
            "createdelight:ponder_big_centrifuge",
            
            (builder, util) => {
                let scene = new $CreateSceneBuilder(builder)
                scene.showBasePlate()
                scene.idle(20)
                scene.text(40, "先让我们快速的搭建一下基础结构").attachKeyFrame()
                scene.idle(40)
                for (let i = 0; i < 7; i++) {
                    scene.world.showSection([2, i + 1, 2, 6, i + 1, 6], Direction.DOWN)
                    scene.idle(10)
                }
                scene.text(40, "OK,搭建完毕!").attachKeyFrame()
                scene.idle(40)
                scene.overlay.showOutline("green", {}, [2, 2, 2, 6, 2, 6], 120)
                scene.overlay.showOutline("green", {}, [3, 3, 6, 5, 6, 6], 120)
                scene.overlay.showOutline("green", {}, [2, 3, 4], 120)
                scene.overlay.showOutline("green", {}, [2, 6, 4], 120)
                scene.overlay.showOutline("green", {}, [6, 3, 4], 120)
                scene.overlay.showOutline("green", {}, [6, 6, 4], 120)
                scene.text(40, "在这个多方块结构中, 这些钢制机壳可以被钢制输入/输出总线代替", [2, 3.5, 4.5]).attachKeyFrame()
                scene.world.replaceBlocks([2, 3, 4], Block.id("createdelight:steel_export_bus").blockState.trySetValue($BlockStateProperties.FACING, Direction.WEST), true)
                scene.world.replaceBlocks([2, 6, 4], Block.id("createdelight:steel_export_bus").blockState.trySetValue($BlockStateProperties.FACING, Direction.WEST), true)
                scene.idle(40)
                scene.rotateCameraY(90)
                scene.text(40, "在这个多方块结构中, 这些钢制机壳可以被钢制输入/输出总线代替", [7, 3.5, 4.5])
                scene.world.replaceBlocks([6, 3, 4], Block.id("createdelight:steel_export_bus").blockState.trySetValue($BlockStateProperties.FACING, Direction.EAST), true)
                scene.world.replaceBlocks([6, 6, 4], Block.id("createdelight:steel_export_bus").blockState.trySetValue($BlockStateProperties.FACING, Direction.EAST), true)
                scene.idle(40)
                scene.rotateCameraY(-180)
                scene.text(40, "在这个多方块结构中, 这些钢制机壳可以被钢制输入/输出总线代替", [4.5, 3.5, 7])
                scene.world.replaceBlocks([4, 3, 6], Block.id("createdelight:steel_export_bus").blockState.trySetValue($BlockStateProperties.FACING, Direction.SOUTH), true)
                scene.world.replaceBlocks([4, 6, 6], Block.id("createdelight:steel_export_bus").blockState.trySetValue($BlockStateProperties.FACING, Direction.SOUTH), true)
                scene.idle(40)
                scene.rotateCameraY(90)
                scene.idle(40)
                scene.addKeyframe()
                scene.text(40, "此处为应力输入口, 转速至少为32", [4.5, 3, 4.5])
                scene.world.hideSection([2, 3, 2, 6, 7, 6], Direction.UP)
                scene.idle(40)
                scene.text(40, "配方速度随转速增加而线性增加，当转速达到256时配方速度*4", [4.5, 3, 4.5])
                scene.idle(40)
                scene.world.showSection([2, 3, 2, 6, 7, 6], Direction.DOWN)
                scene.idle(25)
                scene.addKeyframe()
                scene.overlay.showOutline("blue", {}, [3, 3, 2, 5, 6, 2], 40)
                scene.overlay.showOutline("blue", {}, [2, 4, 3, 2, 5, 5], 40)
                scene.overlay.showOutline("blue", {}, [6, 4, 3, 6, 5, 5], 40)
                scene.overlay.showOutline("blue", {}, [2, 3, 3], 40)
                scene.overlay.showOutline("blue", {}, [2, 6, 3], 40)
                scene.overlay.showOutline("blue", {}, [2, 3, 5], 40)
                scene.overlay.showOutline("blue", {}, [2, 6, 5], 40)
                scene.overlay.showOutline("blue", {}, [6, 3, 3], 40)
                scene.overlay.showOutline("blue", {}, [6, 6, 3], 40)
                scene.overlay.showOutline("blue", {}, [6, 3, 5], 40)
                scene.overlay.showOutline("blue", {}, [6, 6, 5], 40)
                scene.text(40, "其中的钢制通透玻璃机壳也可以使用钢制玻璃机壳/普通钢制机壳", [4, 4.5, 2.5])
                scene.world.replaceBlocks([3, 3, 2, 5, 6, 2], Block.id("createdelightcore:steel_glass_casing").blockState, true)
                scene.world.replaceBlocks([2, 4, 3, 2, 5, 5], Block.id("createdelightcore:steel_casing").blockState, true)
                scene.world.replaceBlocks([2, 3, 3], Block.id("createdelightcore:steel_casing").blockState, true)
                scene.world.replaceBlocks([2, 6, 3], Block.id("createdelightcore:steel_casing").blockState, true)
                scene.world.replaceBlocks([2, 3, 5], Block.id("createdelightcore:steel_casing").blockState, true)
                scene.world.replaceBlocks([2, 6, 5], Block.id("createdelightcore:steel_casing").blockState, true)
                scene.idle(40)
                scene.world.replaceBlocks([3, 3, 2, 5, 6, 2], Block.id("createdelightcore:steel_clear_glass_casing").blockState, false)
                scene.world.replaceBlocks([2, 4, 3, 2, 5, 5], Block.id("createdelightcore:steel_clear_glass_casing").blockState, false)
                scene.world.replaceBlocks([2, 3, 3], Block.id("createdelightcore:steel_clear_glass_casing").blockState, false)
                scene.world.replaceBlocks([2, 6, 3], Block.id("createdelightcore:steel_clear_glass_casing").blockState, false)
                scene.world.replaceBlocks([2, 3, 5], Block.id("createdelightcore:steel_clear_glass_casing").blockState, false)
                scene.world.replaceBlocks([2, 6, 5], Block.id("createdelightcore:steel_clear_glass_casing").blockState, false)
                scene.idle(40)
                scene.addKeyframe()
                scene.world.hideSection([3, 3, 2, 5, 7, 3], Direction.NORTH)
                scene.world.hideSection([2, 3, 3, 3, 7, 5], Direction.WEST)
                scene.world.hideSection([6, 3, 3, 5, 7, 5], Direction.EAST)
                scene.world.hideSection([3, 3, 6, 5, 7, 5], Direction.SOUTH)
                scene.text(40, "注意, 离心机转子扭矩为64", [4.5, 4.5, 4.5])
                scene.idle(40)
                scene.text(140, "离心机基础并行数为16")
                scene.text(140, "其中离心机转子可以叠加, 最少一层, 最多三层, 每层离心机转子使得配方速度*4, 且可与转速叠加", [4.5, 4.5, 4.5])
                scene.idle(20)
                let top = scene.world.makeSectionIndependent([4, 5, 4, 4, 7, 4])
                scene.world.hideSection([4, 4, 4], Direction.EAST)
                scene.idle(20)
                scene.world.moveSection(top, [0, -1, 0], 15)
                scene.idle(40)
                scene.world.moveSection(top, [0, 2, 0], 15)
                scene.idle(20)
                scene.world.showSection([4, 4, 4, 4, 5, 4], Direction.EAST)
                scene.idle(40)
                scene.world.hideSection([4, 3, 4, 4, 5, 4], Direction.UP)
                scene.world.hideIndependentSection(top, Direction.UP)
                scene.idle(20)
                scene.world.showSection([4, 3, 4, 4, 7, 4], Direction.DOWN)
                scene.world.showSection([3, 3, 2, 5, 7, 3], Direction.SOUTH)
                scene.world.showSection([2, 3, 3, 3, 7, 5], Direction.EAST)
                scene.world.showSection([6, 3, 3, 5, 7, 5], Direction.WEST)
                scene.world.showSection([3, 3, 6, 5, 7, 5], Direction.NORTH)
                scene.idle(20)
                scene.markAsFinished()
            })
        .scene(
            "createdelight:using_big_centrifuge",
            "大型离心机的使用",
            "createdelight:ponder_big_centrifuge_use",
            
            (builder, util) => {
                let scene = new $CreateSceneBuilder(builder)
                scene.showBasePlate()
                scene.idle(20)
                scene.text(40, "现在让我们来学习一下如何使用大型离心机").attachKeyFrame()
                scene.idle(40)
                scene.world.showSection([2, 1, 2, 6, 7, 6], Direction.DOWN)
                scene.idle(20)
                scene.text(40, "首先你需要几个输入/输出总线...", [2, 2.5, 4.5]).attachKeyFrame()
                scene.world.replaceBlocks([2, 2, 4], Block.id("createdelight:steel_export_bus").blockState.trySetValue($BlockStateProperties.FACING, Direction.WEST), true)
                scene.idle(20)
                scene.rotateCameraY(90)
                scene.idle(20)
                scene.world.replaceBlocks([6, 2, 4], Block.id("createdelight:steel_import_bus").blockState.trySetValue($BlockStateProperties.FACING, Direction.EAST), true)
                scene.idle(20)
                scene.rotateCameraY(-90)
                scene.idle(20)
                scene.text(40, "然后将输入/输出总线接入你的工厂").attachKeyFrame()
                scene.world.showSection([1, 2, 4], Direction.EAST)
                scene.idle(20)
                scene.rotateCameraY(90)
                scene.idle(20)
                scene.world.showSection([7, 2, 4, 9, 1, 5], Direction.WEST)
                scene.idle(20)
                scene.text(40, "输入你要离心的材料(这里用污浊铁粉做示范)").attachKeyFrame()
                scene.idle(45)
                scene.showControls(40, [8.5, 1.5, 4.6], "up").withItem("createmetallurgy:dirty_iron_dust")
                scene.text(40, "输入污浊铁粉")
                let dirty_iron_dust = scene.world.createItemEntity(
                    [8.5, 4, 4.5],
                    [0, 0, 0],
                    "64x createmetallurgy:dirty_iron_dust"
                )
                scene.idle(10)
                PonderUtil.removeEntity(scene, dirty_iron_dust)
                PonderUtil.createItemOnBelt(scene, [8, 1, 4], Direction.UP, Item.of("64x createmetallurgy:dirty_iron_dust"))
                scene.idle(20)
                PonderUtil.flapFunnel(scene, [7, 2, 4], false)
                PonderUtil.setKineticSpeed(scene, [4, 2, 4, 4, 5, 4], 128)
                PonderUtil.removeItemsFromBelt(scene, [7, 1, 4])
                scene.idle(40)
                scene.rotateCameraY(-90)
                scene.idle(40)
                PonderUtil.multiplyKineticSpeed(scene, [4, 2, 4, 4, 5, 4], 1/2)
                scene.idle(2)
                PonderUtil.multiplyKineticSpeed(scene, [4, 2, 4, 4, 5, 4], 1/2)
                scene.idle(2)
                PonderUtil.multiplyKineticSpeed(scene, [4, 2, 4, 4, 5, 4], 1/2)
                scene.idle(2)
                PonderUtil.multiplyKineticSpeed(scene, [4, 2, 4, 4, 5, 4], 0)
                scene.text(40, "等待一段时间后, 产出铁粉及其副产物").attachKeyFrame()
                scene.idle(20)
                scene.showControls(40, [1.5, 2.5, 4.6], "down").withItem('createmetallurgy:iron_dust')
                PonderUtil.flapFunnel(scene, [1, 2, 4], true)
                scene.world.createItemEntity(
                    [1.5, 2.3, 4.5],
                    [0, 0, 0],
                    "64x createmetallurgy:iron_dust"
                )
                scene.idle(20)
                PonderUtil.flapFunnel(scene, [1, 2, 4], true)
                scene.world.createItemEntity(
                    [1.5, 2.3, 4.5],
                    [0, 0, 0],
                    "16x createmetallurgy:iron_dust"
                )
                scene.idle(20)
                PonderUtil.flapFunnel(scene, [1, 2, 4], true)
                scene.world.createItemEntity(
                    [1.5, 2.3, 4.5],
                    [0, 0, 0],
                    "48x minecraft:redstone"
                )
                scene.idle(5)
                scene.showControls(20, [1.5, 2.5, 4.6], "down").withItem('minecraft:redstone')
                scene.idle(20)
                scene.markAsFinished()
            })
})