---
navigation:
  parent: index.md
  title: 压印模板
  icon: ae2omnicells:multidimensional_expansion_processor
  position: 20
item_ids:
  - ender_ingot
  - charged_ender_ingot
  - omni_link_print_press
  - complex_link_print_press
  - multidimensional_expansion_print_press
  - omni_link_circuit_print
  - complex_link_circuit_print
  - multidimensional_expansion_circuit_print
  - omni_link_processor
  - complex_link_processor
  - multidimensional_expansion_processor
---

# 压印模板

> 本页介绍制作新型存储元件所需的 压印模板 → 电路板 → 处理器 整套链路。

## 概览

为打造本模组的三大系列存储元件（全能 / 复杂全能 / 量子），你需要先完成一条简洁的加工流水：

1. **基础材料**：合成 **末影钢**，并可将其进一步**充能**。
2. **压印模板**：用末影材料制作 3 种对应系列的**压印模板**。
3. **电路板**：在 AE2 的**压印器**中使用模板压制出对应的**电路板**。
4. **处理器**：将电路板与其他材料组装为三系**处理器**，用于后续存储元件配方。

---

## 物品一览

### 压印模板
<Row>
  <ItemImage id="omni_link_print_press" scale="3" />
  <ItemImage id="complex_link_print_press" scale="3" />
  <ItemImage id="multidimensional_expansion_print_press" scale="3" />
</Row>

- **全能链路压印模板**
- **复杂链路压印模板**
- **多维展开压印模板**

---

### 电路板
<Row>
  <ItemImage id="omni_link_circuit_print" scale="3" />
  <ItemImage id="complex_link_circuit_print" scale="3" />
  <ItemImage id="multidimensional_expansion_circuit_print" scale="3" />
</Row>

- **全能链路电路板**
- **复杂链路电路板**
- **多维展开电路板**

---

### 处理器
<Row>
  <ItemImage id="omni_link_processor" scale="3" />
  <ItemImage id="complex_link_processor" scale="3" />
  <ItemImage id="multidimensional_expansion_processor" scale="3" />
</Row>

- **全能链路处理器**
- **复杂链路处理器**
- **多维展开处理器**

---

## 制作流程

1. **末影钢与充能末影钢**
    - 作为后续模板与高阶部件的关键材料。
    - 配方：见下方“配方快速索引”。

2. **压印模板**
    - 使用末影材料合成三系模板。
    - 每种模板用于压印对应系列的电路板。

3. **压印电路板**
    - 在 **Inscriber（压印器）**中放入：模板 + 基础材料 → 相应**电路板**。

4. **组装处理器**
    - 用电路板与其他零件合成三系**处理器**，后续用于存储元件配方。

> 小贴士：具体材料/替代材与细节以 JEI/REI/EMI 显示为准。

---

## 配方快速索引

### 基础材料
<RecipeFor id="ender_ingot" />
<RecipeFor id="charged_ender_ingot" />

### 压印模板
<RecipeFor id="omni_link_print_press" />
<RecipeFor id="complex_link_print_press" />
<RecipeFor id="multidimensional_expansion_print_press" />

### 电路板
<RecipeFor id="omni_link_circuit_print" />
<RecipeFor id="complex_link_circuit_print" />
<RecipeFor id="multidimensional_expansion_circuit_print" />

### 处理器
<RecipeFor id="omni_link_processor" />
<RecipeFor id="complex_link_processor" />
<RecipeFor id="multidimensional_expansion_processor" />
