/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.mixin.client.render.chunk;

import com.llamalad7.mixinextras.sugar.Local;
import com.teamtea.eclipticseasons.api.misc.IChunkBiomeHolder;
import com.teamtea.eclipticseasons.api.misc.client.IMapSlice;
import com.teamtea.eclipticseasons.common.core.map.BiomeHolder;
import com.teamtea.eclipticseasons.common.core.map.ChunkInfoMap;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyMapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyStatusKeeper;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.chunk.RenderRegionCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RenderRegionCache.class})
public class MixinRenderRegionCache {
    @Inject(method={"createRegion"}, at={@At(value="RETURN", ordinal=1)})
    private void eclipticseasons$compile_init_chunk(Level level, BlockPos pStart, BlockPos pEnd, int pPadding, CallbackInfoReturnable<RenderChunkRegion> cir, @Local RenderChunk[][] arenderchunk) {
        int SIZE_X = 0;
        int SIZE_Z = 0;
        Object object = cir.getReturnValue();
        if (object instanceof IMapSlice) {
            IMapSlice iMapSlice = (IMapSlice)object;
            int[][] HEIGHT_MAP = null;
            int[][] SOLID_HEIGHT_MAP = null;
            int[][] BIOME_MAP = null;
            SnowyStatusKeeper[] SNOWY_STATUS_MAP = null;
            if (MapChecker.isValidDimension(level)) {
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                int maxH = level.m_151558_();
                int minChunkX = SectionPos.m_123171_((int)(pStart.m_123341_() - pPadding));
                int minChunkZ = SectionPos.m_123171_((int)(pStart.m_123343_() - pPadding));
                int maxChunkX = SectionPos.m_123171_((int)(pEnd.m_123341_() + pPadding));
                int maxChunkZ = SectionPos.m_123171_((int)(pEnd.m_123343_() + pPadding));
                SIZE_X = maxChunkX - minChunkX + 1;
                SIZE_Z = maxChunkZ - minChunkZ + 1;
                HEIGHT_MAP = new int[SIZE_X * SIZE_Z][256];
                SOLID_HEIGHT_MAP = new int[SIZE_X * SIZE_Z][256];
                BIOME_MAP = new int[SIZE_X * SIZE_Z][256];
                SNOWY_STATUS_MAP = new SnowyStatusKeeper[SIZE_X * SIZE_Z];
                for (int sectionX = minChunkX; sectionX < minChunkX + SIZE_X; ++sectionX) {
                    for (int sectionZ = minChunkZ; sectionZ < minChunkZ + SIZE_Z; ++sectionZ) {
                        int localSectionIndex = sectionX - minChunkX + (sectionZ - minChunkZ) * SIZE_X;
                        LevelChunk wrapped = arenderchunk[sectionX - minChunkX][sectionZ - minChunkZ].f_200444_;
                        Heightmap heightmap = wrapped.m_6005_(Heightmap.Types.MOTION_BLOCKING);
                        ChunkPos chunkPos = wrapped.m_7697_();
                        BiomeHolder biomeHolder = ((IChunkBiomeHolder)wrapped).eclipticseasons$getBiomeHolder();
                        int[] heights = HEIGHT_MAP[localSectionIndex];
                        int[] biomes = BIOME_MAP[localSectionIndex];
                        int[] solidHeights = SOLID_HEIGHT_MAP[localSectionIndex];
                        SNOWY_STATUS_MAP[localSectionIndex] = SnowyMapChecker.getSnowyStatusKeeperCopy(wrapped);
                        int startX = chunkPos.m_45604_();
                        int startZ = chunkPos.m_45605_();
                        mutableBlockPos.m_142451_(startX);
                        mutableBlockPos.m_142443_(startZ);
                        ChunkInfoMap chunkMap = MapChecker.getChunkInfoMapOrCreate(level, (BlockPos)mutableBlockPos);
                        if (chunkMap == null) continue;
                        for (int x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                int biomeId;
                                int index = x * 16 + z;
                                mutableBlockPos.m_142451_(startX + x);
                                mutableBlockPos.m_142443_(startZ + z);
                                int y = chunkMap.getHeight((BlockPos)mutableBlockPos);
                                heights[index] = y > chunkMap.getMinY() ? y : MapChecker.getHeight(level, (BlockPos)mutableBlockPos);
                                mutableBlockPos.m_142448_(heights[index] + 1);
                                if (mutableBlockPos.m_123342_() > maxH) {
                                    mutableBlockPos.m_142448_(level.m_6924_(Heightmap.Types.MOTION_BLOCKING, mutableBlockPos.m_123341_(), mutableBlockPos.m_123343_()));
                                }
                                biomes[index] = (biomeId = biomeHolder.getBiomeId((BlockPos)mutableBlockPos)) > -1 ? biomeId : MapChecker.biomeToId(level, (Biome)MapChecker.getUnCachedSurfaceBiome(level, (BlockPos)mutableBlockPos).m_203334_());
                                solidHeights[index] = heightmap.m_158368_(x, z);
                            }
                        }
                    }
                }
            }
            iMapSlice.forceMapSliceUpdate(HEIGHT_MAP, SOLID_HEIGHT_MAP, BIOME_MAP, SIZE_X, SIZE_Z, SNOWY_STATUS_MAP);
        }
    }
}

