/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.mixin.client.render.chunk;

import com.teamtea.eclipticseasons.api.misc.client.IExtraRendererContextOwner;
import com.teamtea.eclipticseasons.api.misc.client.IMapSlice;
import com.teamtea.eclipticseasons.client.core.ExtraRendererContext;
import com.teamtea.eclipticseasons.common.core.snow.SnowyStatusKeeper;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Pseudo
@Mixin(value={RenderChunkRegion.class})
public abstract class MixinChunkSlice
implements IMapSlice,
IExtraRendererContextOwner {
    @Shadow
    @Final
    protected Level f_112908_;
    @Shadow
    @Final
    private int f_112899_;
    @Shadow
    @Final
    private int f_112900_;
    @Unique
    private int[][] HEIGHT_MAP;
    @Unique
    private int[][] SOLID_HEIGHT_MAP;
    @Unique
    private int[][] BIOME_MAP;
    @Unique
    private int SIZE_X;
    @Unique
    private int SIZE_Z;
    @Unique
    private SnowyStatusKeeper[] SNOWY_STATUS_MAP;
    @Unique
    private ExtraRendererContext eclipticseasons$rendererHolder = new ExtraRendererContext();
    @Unique
    private BlockPos.MutableBlockPos eclipticseasons$mutableBlockPos = new BlockPos.MutableBlockPos();

    @Override
    public void forceMapSliceUpdate(int[][] heights, int[][] solidHeights, int[][] biomes, int sizex, int sizez, SnowyStatusKeeper[] statusKeepers) {
        this.HEIGHT_MAP = heights;
        this.SOLID_HEIGHT_MAP = solidHeights;
        this.BIOME_MAP = biomes;
        this.SIZE_X = sizex;
        this.SIZE_Z = sizez;
        this.SNOWY_STATUS_MAP = statusKeepers;
    }

    @Override
    public int getSolidBlockHeight(BlockPos pos) {
        if (this.SOLID_HEIGHT_MAP == null || this.SOLID_HEIGHT_MAP[0] == null) {
            return 0;
        }
        int relBlockX = SectionPos.m_123171_((int)pos.m_123341_()) - this.f_112899_;
        int relBlockZ = SectionPos.m_123171_((int)pos.m_123343_()) - this.f_112900_;
        int[] lightArrays = this.SOLID_HEIGHT_MAP[relBlockX + relBlockZ * this.SIZE_X];
        int localBlockX = pos.m_123341_() & 0xF;
        int localBlockZ = pos.m_123343_() & 0xF;
        return lightArrays[localBlockX * 16 + localBlockZ];
    }

    @Override
    public int getBlockHeight(BlockPos pos) {
        if (this.HEIGHT_MAP == null || this.HEIGHT_MAP[0] == null) {
            return 0;
        }
        int relBlockX = SectionPos.m_123171_((int)pos.m_123341_()) - this.f_112899_;
        int relBlockZ = SectionPos.m_123171_((int)pos.m_123343_()) - this.f_112900_;
        int[] lightArrays = this.HEIGHT_MAP[relBlockX + relBlockZ * this.SIZE_X];
        int localBlockX = pos.m_123341_() & 0xF;
        int localBlockZ = pos.m_123343_() & 0xF;
        return lightArrays[localBlockX * 16 + localBlockZ];
    }

    @Override
    public int getSurfaceFaceBiomeId(BlockPos pos) {
        if (this.BIOME_MAP == null || this.BIOME_MAP[0] == null) {
            return 0;
        }
        int relBlockX = SectionPos.m_123171_((int)pos.m_123341_()) - this.f_112899_;
        int relBlockZ = SectionPos.m_123171_((int)pos.m_123343_()) - this.f_112900_;
        int[] lightArrays = this.BIOME_MAP[relBlockX + relBlockZ * this.SIZE_X];
        int localBlockX = pos.m_123341_() & 0xF;
        int localBlockZ = pos.m_123343_() & 0xF;
        return lightArrays[localBlockX * 16 + localBlockZ];
    }

    @Override
    public boolean isSnowyBlock(BlockPos pos) {
        int relBlockZ;
        if (this.SNOWY_STATUS_MAP == null || this.SNOWY_STATUS_MAP[0] == null) {
            return false;
        }
        int relBlockX = SectionPos.m_123171_((int)pos.m_123341_()) - this.f_112899_;
        SnowyStatusKeeper lightArrays = this.SNOWY_STATUS_MAP[relBlockX + (relBlockZ = SectionPos.m_123171_((int)pos.m_123343_()) - this.f_112900_) * this.SIZE_X];
        return lightArrays != null && lightArrays.isSnowyBlock(pos);
    }

    @Override
    public ExtraRendererContext eclipticseasons$getContext() {
        return this.eclipticseasons$rendererHolder;
    }

    @Override
    public BlockPos.MutableBlockPos getModelCheckPos() {
        return this.eclipticseasons$mutableBlockPos;
    }
}

