/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.data.general.font;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.gui.font.providers.BitmapProvider;
import net.minecraft.client.gui.font.providers.GlyphProviderDefinition;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ESFontProvider
implements DataProvider {
    private final PackOutput output;
    protected final String modid;
    public final ExistingFileHelper helper;
    protected final Map<ResourceLocation, FontManager.FontDefinitionFile> outMap = new HashMap<ResourceLocation, FontManager.FontDefinitionFile>();

    public ESFontProvider(PackOutput output, String modid, ExistingFileHelper helper) {
        this.output = output;
        this.modid = modid;
        this.helper = helper;
    }

    public int[][] toInts(List<String> p_286900_) {
        int i = p_286900_.size();
        int[][] aint = new int[i][];
        for (int j = 0; j < i; ++j) {
            aint[j] = p_286900_.get(j).codePoints().toArray();
        }
        return aint;
    }

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        this.gather();
        Path path = this.output.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve(this.modid).resolve("font");
        return CompletableFuture.allOf((CompletableFuture[])this.outMap.entrySet().stream().map(e -> DataProvider.m_253162_((CachedOutput)output, (JsonElement)((JsonElement)FontManager.FontDefinitionFile.f_285562_.encode((Object)((FontManager.FontDefinitionFile)e.getValue()), (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()).result().orElse(new JsonObject())), (Path)path.resolve(((ResourceLocation)e.getKey()).m_266382_(".json").m_135815_()))).toArray(CompletableFuture[]::new));
    }

    protected void gather() {
        this.outMap.put(SolarTerm.getFont(), new FontManager.FontDefinitionFile(List.of(this.buildFont(SolarTerm.getFontIcon(), IntStream.range(0, 4).mapToObj(ESFontProvider::buildRow).toList()))));
        this.outMap.put(EclipticSeasons.rl("monsoon_icons"), new FontManager.FontDefinitionFile(List.of(this.buildFont(EclipticSeasons.rl("font/season_phase/dry_end"), List.of("a")), this.buildFont(EclipticSeasons.rl("font/season_phase/dry_middle"), List.of("b")), this.buildFont(EclipticSeasons.rl("font/season_phase/dry_start"), List.of("c")), this.buildFont(EclipticSeasons.rl("font/season_phase/rain_end"), List.of("d")), this.buildFont(EclipticSeasons.rl("font/season_phase/rain_middle"), List.of("e")), this.buildFont(EclipticSeasons.rl("font/season_phase/rain_start"), List.of("f")), this.buildFont(EclipticSeasons.rl("font/season_phase/wet_end"), List.of("g")), this.buildFont(EclipticSeasons.rl("font/season_phase/wet_middle"), List.of("h")), this.buildFont(EclipticSeasons.rl("font/season_phase/wet_start"), List.of("i")))));
    }

    private GlyphProviderDefinition buildFont(ResourceLocation iconCollection, List<String> a) {
        return new BitmapProvider.Definition(iconCollection.m_266382_(".png"), 9, 7, this.toInts(a));
    }

    private static String buildRow(int rowIndex) {
        return IntStream.range(0, 6).mapToObj(j -> SolarTerm.collectValues()[rowIndex * 6 + j].getFontLabel()).collect(Collectors.joining());
    }

    public String m_6055_() {
        return "ES Font Provider";
    }
}

