/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.data.general.datapack.client;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.tag.ClimateTypeBiomeTags;
import com.teamtea.eclipticseasons.api.data.client.model.seasonal.SeasonBlockDefinition;
import com.teamtea.eclipticseasons.data.api.provider.base.ESClientBiomeDataMapProvider;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ClientSeasonModelDefinitionProvider
extends ESClientBiomeDataMapProvider<SeasonBlockDefinition> {
    public ClientSeasonModelDefinitionProvider(PackOutput output, String modid, ExistingFileHelper helper, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, modid, helper, registries, "eclipticseasons/season_definitions", SeasonBlockDefinition.CODEC);
    }

    @Override
    protected void gather(HolderLookup.Provider provider, HolderGetter<Biome> biomeRegistryLookup) {
        HolderLookup.RegistryLookup blockRegistryLookup = provider.m_255025_(Registries.f_256747_);
        ArrayList<SeasonBlockDefinition.Slice> slices = new ArrayList<SeasonBlockDefinition.Slice>();
        for (SolarTerm solarTerm : SolarTerm.collectValues()) {
            ResourceLocation rl;
            if (solarTerm.isInTerms(SolarTerm.BEGINNING_OF_SPRING, SolarTerm.GRAIN_RAIN)) {
                rl = EclipticSeasons.rl("flower_on_grass_" + solarTerm.getName());
                slices.add(SeasonBlockDefinition.Slice.builder().solarTerm(solarTerm).mid(rl).build());
            }
            if (!solarTerm.isInTerms(SolarTerm.LESSER_FULLNESS, SolarTerm.BEGINNING_OF_AUTUMN)) continue;
            rl = EclipticSeasons.rl("fourleaf_clovers_" + solarTerm.getName());
            slices.add(SeasonBlockDefinition.Slice.builder().solarTerm(solarTerm).mid(rl).build());
        }
        SolarTerm beginningOfSummer = SolarTerm.BEGINNING_OF_SUMMER;
        slices.add(SeasonBlockDefinition.Slice.builder().solarTerm(beginningOfSummer).transitionModels((Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)EclipticSeasons.rl("flower_on_grass_" + beginningOfSummer.getName()), (Object)EclipticSeasons.rl("fourleaf_clovers_" + beginningOfSummer.getName()))).build());
        this.add(SeasonBlockDefinition.GRASS_BLOCK, new SeasonBlockDefinition((HolderSet<Block>)HolderSet.m_205809_((Holder[])new Holder[]{Blocks.f_50440_.m_204297_()}), Optional.empty(), this.and(this.get(ClimateTypeBiomeTags.SEASONAL), this.not(this.get((TagKey<Biome>)Tags.Biomes.IS_HOT)), this.not(this.get((TagKey<Biome>)Tags.Biomes.IS_COLD))), slices));
    }

    private static String getPath(ResourceLocation overlay) {
        return overlay.m_135815_();
    }
}

