/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.data.season.SnowDefinition;
import com.teamtea.eclipticseasons.common.core.snow.ClientModelDefinitions;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.function.BiFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class SnowDefinitionsRegistry {
    private static final ResourceKey<SnowDefinition> OVERLAY = SnowDefinitionsRegistry.createKey("test/overlay");
    public static final ResourceKey<SnowDefinition> SNOWY_GRASS_BLOCK = SnowDefinitionsRegistry.createKey("snowy_grass_block");
    public static final ResourceKey<SnowDefinition> SNOWY_SWEET_BERRY_BUSH = SnowDefinitionsRegistry.createKey("snowy_sweet_berry_bush");
    public static final ResourceKey<SnowDefinition> SNOWY_DEAD_BUSH = SnowDefinitionsRegistry.createKey("snowy_dead_bush");
    public static final ResourceKey<SnowDefinition> SNOWY_SUGAR_CANE = SnowDefinitionsRegistry.createKey("snowy_sugar_cane");
    public static final ResourceKey<SnowDefinition> SNOWY_BAMBOO = SnowDefinitionsRegistry.createKey("snowy_bamboo");
    public static final ResourceKey<SnowDefinition> SNOWY_BAMBOO_SAPLING = SnowDefinitionsRegistry.createKey("snowy_bamboo_sapling");

    private static ResourceKey<SnowDefinition> createKey(String name) {
        return ResourceKey.m_135785_(ESRegistries.SNOW_DEFINITIONS, (ResourceLocation)EclipticSeasons.rl(name));
    }

    public static void bootstrap2(BootstapContext<SnowDefinition> context) {
        HolderGetter blockHolderGetter = context.m_255420_(Registries.f_256747_);
        context.m_255272_(OVERLAY, (Object)SnowDefinition.builder().blocks((HolderSet<Block>)HolderSet.m_205809_((Holder[])new Holder[0])).info(SnowDefinition.Info.builder().mid(ClientModelDefinitions.OVERLAY).build()).build());
    }

    public static void bootstrap(BootstapContext<SnowDefinition> context) {
        HolderGetter blockHolderGetter = context.m_255420_(Registries.f_256747_);
        context.m_255272_(SNOWY_GRASS_BLOCK, (Object)SnowDefinition.builder().blocks((HolderSet<Block>)HolderSet.m_205809_((Holder[])new Holder[]{Blocks.f_50440_.m_204297_()})).info(SnowDefinition.Info.builder().mid(ClientModelDefinitions.SNOWY_GRASS_BLOCK_OVERLAY).build()).build());
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50130_, 1200);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50036_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50685_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50570_);
        SnowDefinitionsRegistry.register(context, Blocks.f_50571_, (b, s) -> s.info(SnowDefinition.Info.builder().flag(1100).snowPassable(true).mid2(SnowDefinitionsRegistry.getSnowModelPath(b)).mid(SnowDefinitionsRegistry.getSnowModelPath(b).m_266382_("_top")).build()));
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull HolderSet.Direct<Block> set(Block bamboo) {
        return HolderSet.m_205809_((Holder[])new Holder[]{bamboo.m_204297_()});
    }

    public static void register(BootstapContext<SnowDefinition> context, Block block, BiFunction<Block, SnowDefinition.SnowDefinitionBuilder, SnowDefinition.SnowDefinitionBuilder> function) {
        context.m_255272_(SnowDefinitionsRegistry.createSnowyKey(block), (Object)function.apply(block, SnowDefinition.builder()).blocks((HolderSet<Block>)SnowDefinitionsRegistry.set(block)).build());
    }

    public static void addPlant(BootstapContext<SnowDefinition> context, Block block) {
        SnowDefinitionsRegistry.addPlant(context, block, 1001);
    }

    public static void addPlant(BootstapContext<SnowDefinition> context, Block block, int flag) {
        String path = SnowDefinitionsRegistry.path(block);
        context.m_255272_(SnowDefinitionsRegistry.createSnowyKey(path), (Object)SnowDefinition.builder().blocks((HolderSet<Block>)SnowDefinitionsRegistry.set(block)).info(SnowDefinition.Info.builder().offset(1).flag(flag).mid(SnowDefinitionsRegistry.getSnowModelPath(path)).build()).build());
    }

    @NotNull
    private static ResourceKey<SnowDefinition> createSnowyKey(String path) {
        return SnowDefinitionsRegistry.createKey("snowy_" + path);
    }

    @NotNull
    private static ResourceKey<SnowDefinition> createSnowyKey(Block block) {
        return SnowDefinitionsRegistry.createKey("snowy_" + SnowDefinitionsRegistry.path(block));
    }

    @NotNull
    public static String path(Block block) {
        return block.m_204297_().m_205785_().m_135782_().m_135815_();
    }

    @NotNull
    public static ResourceLocation getSnowModelPath(String path) {
        return EclipticSeasons.rl("snowy/" + path);
    }

    @NotNull
    public static ResourceLocation getSnowModelPath(Block block) {
        return EclipticSeasons.rl("snowy/" + SnowDefinitionsRegistry.path(block));
    }

    @NotNull
    public static ResourceLocation getSnowModelPath(String modid, Block block) {
        return new ResourceLocation(modid, "snowy/" + SnowDefinitionsRegistry.path(block));
    }

    public static void bootstrap_extra(BootstapContext<SnowDefinition> context) {
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50746_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50751_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50750_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50748_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50749_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50747_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_271334_);
        context.m_255272_(SnowDefinitionsRegistry.createSnowyKey("mangrove_propagule"), (Object)SnowDefinition.builder().blocks((HolderSet<Block>)HolderSet.m_205809_((Holder[])new Holder[]{Blocks.f_220831_.m_204297_()})).info(SnowDefinition.Info.builder().offset(1).flag(1001).mid(SnowDefinitionsRegistry.getSnowModelPath("mangrove_propagule")).build()).build());
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50073_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50072_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50114_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50115_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50113_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50121_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50111_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50071_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50117_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50119_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50118_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50116_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50120_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50112_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50070_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50355_, 1001);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50356_, 1001);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50358_, 1001);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50357_, 1001);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_271329_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_271410_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_276665_, 1001);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_276668_, 1001);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50444_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50249_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50250_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50092_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50190_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50188_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50189_);
        SnowDefinitionsRegistry.addPlant(context, Blocks.f_50187_);
    }
}

