/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.tag.CropClimateTags;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.data.quest.SeasonQuest;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import com.teamtea.eclipticseasons.common.registry.ItemRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class SeasonQuestRegistry {
    public static final ResourceKey<SeasonQuest> SPRING_CORE = SeasonQuestRegistry.createKey("spring_core");
    public static final ResourceKey<SeasonQuest> SUMMER_CORE = SeasonQuestRegistry.createKey("summer_core");
    public static final ResourceKey<SeasonQuest> AUTUMN_CORE = SeasonQuestRegistry.createKey("autumn_core");
    public static final ResourceKey<SeasonQuest> WINTER_CORE = SeasonQuestRegistry.createKey("winter_core");

    private static ResourceKey<SeasonQuest> createKey(String name) {
        return ResourceKey.m_135785_(ESRegistries.SEASON_QUEST, (ResourceLocation)EclipticSeasons.rl(name));
    }

    public static void bootstrap(BootstapContext<SeasonQuest> context) {
        HolderGetter cropClimateTypeHolderGetter = context.m_255420_(ESRegistries.AGRO_CLIMATE);
        context.m_255272_(SPRING_CORE, (Object)SeasonQuest.builder().setTittle(ESRegistries.createLangKey(SPRING_CORE)).setStart(SolarTerm.SPRING_EQUINOX).setEnd(SolarTerm.BEGINNING_OF_SUMMER).addNeed((Holder<Item>)Items.f_42405_.m_204114_(), 192).addAward((Item)ItemRegistry.spring_greenhouse_essence_item.get()).setClimate((HolderSet<AgroClimaticZone>)cropClimateTypeHolderGetter.m_254956_(CropClimateTags.ALL)).setWeight(10).setGlowing(true).setColor(Season.SPRING.getColor().m_126665_()).build());
        context.m_255272_(SUMMER_CORE, (Object)SeasonQuest.builder().setTittle(ESRegistries.createLangKey(SUMMER_CORE)).setStart(SolarTerm.SUMMER_SOLSTICE).setEnd(SolarTerm.BEGINNING_OF_AUTUMN).addNeed((Holder<Item>)Items.f_42028_.m_204114_(), 48).addAward((Item)ItemRegistry.summer_greenhouse_essence_item.get()).setClimate((HolderSet<AgroClimaticZone>)cropClimateTypeHolderGetter.m_254956_(CropClimateTags.ALL)).setWeight(10).setGlowing(true).setColor(Season.SUMMER.getColor().m_126665_()).build());
        context.m_255272_(AUTUMN_CORE, (Object)SeasonQuest.builder().setTittle(ESRegistries.createLangKey(AUTUMN_CORE)).setStart(SolarTerm.AUTUMNAL_EQUINOX).setEnd(SolarTerm.BEGINNING_OF_WINTER).addNeed((Holder<Item>)Items.f_42046_.m_204114_(), 96).addNeed((Holder<Item>)Items.f_42619_.m_204114_(), 64).addNeed((Holder<Item>)Items.f_42732_.m_204114_(), 64).addAward((Item)ItemRegistry.autumn_greenhouse_essence_item.get()).setClimate((HolderSet<AgroClimaticZone>)cropClimateTypeHolderGetter.m_254956_(CropClimateTags.ALL)).setWeight(10).setGlowing(true).setColor(Season.AUTUMN.getColor().m_126665_()).build());
        context.m_255272_(WINTER_CORE, (Object)SeasonQuest.builder().setTittle(ESRegistries.createLangKey(WINTER_CORE)).setStart(SolarTerm.WINTER_SOLSTICE).setEnd(SolarTerm.BEGINNING_OF_SPRING).addNeed((Holder<Item>)Items.f_42780_.m_204114_(), 96).addAward((Item)ItemRegistry.winter_greenhouse_essence_item.get()).setClimate((HolderSet<AgroClimaticZone>)cropClimateTypeHolderGetter.m_254956_(CropClimateTags.ALL)).setWeight(10).setGlowing(true).setColor(Season.WINTER.getColor().m_126665_()).build());
    }
}

